% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy_dir}
\alias{tidy_dir}
\alias{tidy_file}
\title{Format all R scripts under a directory, or specified R scripts}
\usage{
tidy_dir(path = ".", recursive = FALSE, ...)

tidy_file(file, ...)
}
\arguments{
\item{path}{The path to a directory containning R scripts.}

\item{recursive}{Whether to recursively look for R scripts under \code{path}.}

\item{...}{Other arguments to be passed to \code{\link{tidy_source}()}.}

\item{file}{A vector of filenames.}
}
\value{
Invisible \code{NULL}.
}
\description{
Look for all R scripts under a directory (using the pattern
\code{"[.][RrSsQq]$"}), then tidy them with \code{\link{tidy_source}()}. If
successful, the original scripts will be overwritten with reformatted ones.
Please back up the original directory first if you do not fully understand
the tricks used by \code{\link{tidy_source}()}. \code{tidy_file()} formats
scripts specified by file names.
}
\examples{
library(formatR)

path = tempdir()
file.copy(system.file("demo", package = "base"), path, recursive = TRUE)
tidy_dir(path, recursive = TRUE)
}
\seealso{
\code{\link{tidy_source}()}
}
\author{
Yihui Xie (\code{tidy_dir}) and Ed Lee (\code{tidy_file})
}
