% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrg.R
\name{consensus_tree}
\alias{consensus_tree}
\alias{hrg.consensus}
\title{Create a consensus tree from several hierarchical random graph models}
\usage{
consensus_tree(graph, hrg = NULL, start = FALSE, num.samples = 10000)
}
\arguments{
\item{graph}{The graph the models were fitted to.}

\item{hrg}{A hierarchical random graph model, in the form of an
\code{igraphHRG} object. \code{consensus_tree} allows this to be
\code{NULL} as well, then a HRG is fitted to the graph first, from a
random starting point.}

\item{start}{Logical, whether to start the fitting/sampling from the
supplied \code{igraphHRG} object, or from a random starting point.}

\item{num.samples}{Number of samples to use for consensus generation or
missing edge prediction.}
}
\value{
\code{consensus_tree} returns a list of two objects. The first
is an \code{igraphHRGConsensus} object, the second is an
\code{igraphHRG} object.  The \code{igraphHRGConsensus} object has the
following members:
  \item{parents}{For each vertex, the id of its parent vertex is stored,
    or zero, if the vertex is the root vertex in the tree. The first n
    vertex ids (from 0) refer to the original vertices of the graph, the
    other ids refer to vertex groups.}
  \item{weights}{Numeric vector, counts the number of times a given tree
    split occured in the generated network samples, for each internal
    vertices. The order is the same as in the \code{parents} vector.}
}
\description{
\code{consensus_tree} creates a consensus tree from several fitted
hierarchical random graph models, using phylogeny methods. If the \code{hrg}
argument is given and \code{start} is set to \code{TRUE}, then it starts
sampling from the given HRG. Otherwise it optimizes the HRG log-likelihood
first, and then samples starting from the optimum.
}
\seealso{
Other hierarchical random graph functions: \code{\link{fit_hrg}},
  \code{\link{hrg-methods}}, \code{\link{hrg_tree}},
  \code{\link{hrg}}, \code{\link{predict_edges}},
  \code{\link{print.igraphHRGConsensus}},
  \code{\link{print.igraphHRG}}, \code{\link{sample_hrg}}
}
\concept{hierarchical random graph functions}
