% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopTime.R
\name{stopTime}
\alias{stopTime}
\title{Stop the time of an event history object}
\usage{
stopTime(object, stop.time)
}
\arguments{
\item{object}{Event history object as obtained with \code{Hist}}

\item{stop.time}{Time point at which to stop the event history object}
}
\value{
Stopped event history object where all times are censored 
        at \code{stop.time}. All observations with times greater than \code{stop.time}
        are set to \code{stop.time} and the event status is set to \code{attr(object,"cens.code")}.
        A new column \code{"stop.time"} is equal to \code{1} for stopped observations
        and equal to \code{0} for the other observations.
}
\description{
All event times are stopped at a given time point and
corresponding events are censored
}
\examples{

set.seed(29)
d <- SimSurv(10)
h <- with(d,Hist(time,status))
h
stopTime(h,8)
stopTime(h,5)

## works also with Surv objects
library(survival)
s <- with(d,Surv(time,status))
stopTime(s,5)

## competing risks
set.seed(29)
dr <- SimCompRisk(10)
hr <- with(dr,Hist(time,event))
hr
stopTime(hr,8)
stopTime(hr,5)

}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
\seealso{
Hist
}

