% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2factor.R
\name{step_bin2factor}
\alias{step_bin2factor}
\title{Create a factors from A dummy variable}
\usage{
step_bin2factor(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  levels = c("yes", "no"),
  ref_first = TRUE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("bin2factor")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{levels}{A length 2 character string that indicates the
factor levels for the 1's (in the first position) and the zeros
(second)}

\item{ref_first}{Logical. Should the first level, which replaces
1's, be the factor reference level?}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_bin2factor()} creates a \emph{specification} of a recipe step that will
create a two-level factor from a single dummy variable.
}
\details{
This operation may be useful for situations where a
binary piece of information may need to be represented as
categorical instead of numeric. For example, naive Bayes models
would do better to have factor predictors so that the binomial
distribution is modeled instead of a Gaussian probability
density of numeric binary data. Note that the numeric data is
only verified to be numeric (and does not count levels).
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(covers, package = "modeldata")

rec <- recipe(~description, covers) \%>\%
  step_regex(description, pattern = "(rock|stony)", result = "rocks") \%>\%
  step_regex(description, pattern = "(rock|stony)", result = "more_rocks") \%>\%
  step_bin2factor(rocks)

tidy(rec, number = 3)

rec <- prep(rec, training = covers)
results <- bake(rec, new_data = covers)

table(results$rocks, results$more_rocks)

tidy(rec, number = 3)
\dontshow{\}) # examplesIf}
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
