% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{refresh}
\alias{refresh}
\title{Refresh the local cache of available packages}
\usage{
refresh()
}
\value{
A list of package databases, invisibly -- one for each repository
currently active in the \R session. Note that this function is normally
called for its side effects.
}
\description{
Query the active R package repositories for available packages, and
update the in-memory cache of those packages.
}
\details{
Note that \R also maintains its own on-disk cache of available packages,
which is used by \code{available.packages()}. Calling \code{refresh()} will force
an update of both types of caches. renv prefers using an in-memory
cache as on occasion the temporary directory can be slow to access (e.g.
when it is a mounted network filesystem).
}
\examples{
\dontrun{

# check available packages
db <- available.packages()

# wait some time (suppose packages are uploaded / changed in this time)
Sys.sleep(5)

# refresh the local available packages database
# (the old locally cached db will be removed)
db <- renv::refresh()

}
}
