% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependencies}
\alias{dependencies}
\title{Find R package dependencies in a project}
\usage{
dependencies(
  path = getwd(),
  root = NULL,
  ...,
  quiet = NULL,
  progress = TRUE,
  errors = c("reported", "fatal", "ignored"),
  dev = FALSE
)
}
\arguments{
\item{path}{The path to a \code{.R}, \code{.Rmd}, \code{.qmd}, \code{DESCRIPTION}, a directory
containing such files, or an R function. The default uses all files
found within the current working directory and its children.}

\item{root}{The root directory to be used for dependency discovery.
Defaults to the active project directory. You may need to set this
explicitly to ensure that your project's \code{.renvignore}s (if any) are
properly handled.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, renv will signal an error.}

\item{quiet}{Boolean; be quiet while checking for dependencies?
Setting \code{quiet = TRUE} is equivalent to setting \code{progress = FALSE}
and \code{errors = "ignored"}, and overrides those options when not \code{NULL}.}

\item{progress}{Boolean; report progress output while enumerating
dependencies?}

\item{errors}{How should errors that occur during dependency enumeration be
handled?
\itemize{
\item \code{"reported"} (the default): errors are reported to the user, but
otherwise ignored.
\item \code{"fatal"}: errors are fatal and stop execution.
\item \code{"ignored"}: errors are ignored and not reported to the user.
}}

\item{dev}{Boolean; include development dependencies? These packages are
typically required when developing the project, but not when running it
(i.e. you want them installed when humans are working on the project but
not when computers are deploying it).

Development dependencies include packages listed in the \code{Suggests} field
of a \code{DESCRIPTION} found in the project root, and roxygen2 or devtools if
their use is implied by other project metadata. They also include packages
used in \verb{~/.Rprofile} if \code{config$user.profile()} is \code{TRUE}.}
}
\value{
An \R \code{data.frame} of discovered dependencies, mapping inferred
package names to the files in which they were discovered. Note that the
\code{Package} field might name a package remote, rather than just a plain
package name.
}
\description{
\code{dependencies()} will scan files within your project, looking for \R files
and the packages used within those \R files. This is done primarily by
parsing the code and looking for calls of the form \code{library(package)},
\code{require(package)}, \code{requireNamespace("package")}, and \code{package::method()}.
renv also supports package loading with
\href{https://cran.r-project.org/package=box}{box} (\code{box::use(...)}) and
\href{https://cran.r-project.org/package=pacman}{pacman} (\code{pacman::p_load(...)}).

For \R package projects, \code{renv} will also detect dependencies expressed
in the \code{DESCRIPTION} file. For projects using Python, \R dependencies within
the \R code chunks of your project's \code{.ipynb} files will also be used.

Note that the \code{\link[rmarkdown:rmarkdown-package]{rmarkdown}} package is
required in order to scan dependencies in R Markdown files.
}
\section{Missing dependencies}{
\code{dependencies()} uses static analysis to determine which packages are used
by your project. This means that it inspects, but doesn't run, the \R code
in your project. Static analysis generally works well, but is not
100\% reliable in detecting the packages required by your project. For
example, \code{renv} is unable to detect this kind of usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{for (package in c("dplyr", "ggplot2")) \{
  library(package, character.only = TRUE)
\}
}\if{html}{\out{</div>}}

It also can't generally tell if one of the packages you use, uses one of
its suggested packages. For example, the \code{tidyr::separate_wider_delim()}
function requires the \code{stringr} package, but \code{stringr} is only suggested,
not required, by \code{tidyr}.

If you find that renv's dependency discovery misses one or more packages
that you actually use in your project, one escape hatch is to include a file
called \verb{_dependencies.R} that includes straightforward library calls:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(dplyr)
library(ggplot2)
library(stringr)
}\if{html}{\out{</div>}}
}

\section{Ignoring files}{
By default, renv will read your project's \code{.gitignore}s (if present) to
determine whether certain files or folders should be included when traversing
directories. If preferred, you can also create a \code{.renvignore} file (with
entries of the same format as a standard \code{.gitignore} file) to tell renv
which files to ignore within a directory. If both \code{.renvignore} and
\code{.gitignore} exist within a folder, the \code{.renvignore} will be used in lieu of
the \code{.gitignore}.

See \url{https://git-scm.com/docs/gitignore} for documentation on the
\code{.gitignore} format. Some simple examples here:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# ignore all R Markdown files
*.Rmd

# ignore all data folders
data/

# ignore only data folders from the root of the project
/data/
}\if{html}{\out{</div>}}

Using ignore files is important if your project contains a large number
of files; for example, if you have a \verb{data/} directory containing many
text files.
}

\section{Errors}{
renv's attempts to enumerate package dependencies in your project can fail
-- most commonly, because of failures when attempting to parse your \R code.
You can use the \code{errors} argument to suppress these problems, but a
more robust solution is tell renv not to look at the problematic code.
As well as using \code{.renvignore}, as described above, you can also suppress errors
discovered within individual \code{.Rmd} chunks by including \code{renv.ignore=TRUE}
in the chunk header. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r chunk-label, renv.ignore=TRUE\}
# code in this chunk will be ignored by renv
```
}\if{html}{\out{</div>}}

Similarly, if you'd like renv to parse a chunk that is otherwise ignored
(e.g. because it has \code{eval=FALSE} as a chunk header), you can set:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r chunk-label, eval=FALSE, renv.ignore=FALSE\}
# code in this chunk will _not_ be ignored
```
}\if{html}{\out{</div>}}
}

\section{Development dependencies}{
renv has some support for distinguishing between development and run-time
dependencies. For example, your Shiny app might rely on
\href{https://ggplot2.tidyverse.org}{ggplot2} (a run-time dependency) but while
you use \href{https://usethis.r-lib.org}{usethis} during development, your app
doesn't need it to run (i.e. it's only a development dependency).

You can record development dependencies by listing them in the \code{Suggests}
field of your project's \code{DESCRIPTION} file. Development dependencies will be installed by
\code{\link[=install]{install()}} (when called without arguments) but will not be tracked in
the project snapshot. If you need greater control, you can also try project
profiles as discussed in \code{vignette("profiles")}.
}

\examples{
\dontrun{

# find R package dependencies in the current directory
renv::dependencies()

}
}
