% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-chr.R
\name{chr_unserialise_unicode}
\alias{chr_unserialise_unicode}
\title{Translate unicode points to UTF-8}
\usage{
chr_unserialise_unicode(chr)
}
\arguments{
\item{chr}{A character vector.}
}
\description{
For historical reasons, R translates strings to the native encoding
when they are converted to symbols. This string-to-symbol
conversion is not a rare occurrence and happens for instance to the
names of a list of arguments converted to a call by \code{do.call()}.

If the string contains unicode characters that cannot be
represented in the native encoding, R serialises those as a ASCII
sequence representing the unicode point. This is why Windows users
with western locales often see strings looking like \code{<U+xxxx>}. To
alleviate some of the pain, rlang parses strings and looks for
serialised unicode points to translate them back to the proper
UTF-8 representation. This transformation occurs automatically in
functions like \code{\link[=env_names]{env_names()}} and can be manually triggered with
\code{as_utf8_character()} and \code{chr_unserialise_unicode()}.
}
\section{Life cycle}{


This function is experimental.
}

\examples{
ascii <- "<U+5E78>"
chr_unserialise_unicode(ascii)

identical(chr_unserialise_unicode(ascii), "\\u5e78")
}
\keyword{internal}
