% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design_set.R
\name{getDesignSet}
\alias{getDesignSet}
\title{Get Design Set}
\usage{
getDesignSet(...)
}
\arguments{
\item{...}{'designs' OR 'design' and one or more design parameters, e.g., deltaWT = c(0.1, 0.3, 0.4).
\itemize{
  \item \code{design} The master design (optional, you need to specify an 
        additional parameter that shall be varied).
  \item \code{designs} The designs to compare (optional).
}}
}
\value{
Returns a \code{\link{TrialDesignSet}} object.
}
\description{
Creates a trial design set object and returns it.
}
\details{
Specify a master design and one or more design parameters or a list of designs.
}
\examples{

# Example 1
 design <- getDesignGroupSequential(alpha = 0.05, kMax = 6, 
    sided = 2, typeOfDesign = "WT", deltaWT = 0.1)
 designSet <- getDesignSet()
 designSet$add(design = design, deltaWT = c(0.3, 0.4))
 if (require(ggplot2)) plot(designSet, type = 1)

# Example 2 (shorter script)
design <- getDesignGroupSequential(alpha = 0.05, kMax = 6, 
    sided = 2, typeOfDesign = "WT", deltaWT = 0.1)
designSet <- getDesignSet(design = design, deltaWT = c(0.3, 0.4))
if (require(ggplot2)) plot(designSet)

}
