% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_simulation_results.R
\name{plot.SimulationResults}
\alias{plot.SimulationResults}
\title{Simulation Results Plotting}
\usage{
\method{plot}{SimulationResults}(
  x,
  y,
  main = NA_character_,
  xlab = NA_character_,
  ylab = NA_character_,
  type = 1,
  palette = "Set1",
  theta = seq(-1, 1, 0.01),
  plotPointsEnabled = NA,
  legendPosition = NA_integer_,
  showSource = FALSE,
  ...
)
}
\arguments{
\item{x}{The simulation results, obtained from \cr
\code{\link{getSimulationSurvival}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{type}{The plot type (default = \code{1}). The following plot types are available:
\itemize{
  \item \code{1}: creates a 'Boundaries' plot
  \item \code{2}: creates a 'Boundaries Effect Scale' plot
  \item \code{3}: creates a 'Boundaries p Values Scale' plot
  \item \code{4}: creates a 'Type One Error Spending' plot
  \item \code{5}: creates a 'Sample Size' or 'Overall Power and Early Stopping' plot
  \item \code{6}: creates a 'Number of Events' or 'Sample Size' plot
  \item \code{7}: creates an 'Overall Power' plot
  \item \code{8}: creates an 'Overall Early Stopping' plot
  \item \code{9}: creates an 'Expected Number of Events' or 'Expected Sample Size' plot
  \item \code{10}: creates a 'Study Duration' plot
  \item \code{11}: creates an 'Expected Number of Subjects' plot
  \item \code{12}: creates an 'Analysis Times' plot
  \item \code{13}: creates a 'Cumulative Distribution Function' plot
  \item \code{14}: creates a 'Survival Function' plot
}}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{theta}{A vector of theta values.}

\item{plotPointsEnabled}{If \code{TRUE}, additional points will be plotted.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{-1}: no legend will be shown
  \item \code{NA}: the algorithm tries to find a suitable position
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with \code{\link[graphics]{plot}}.}

\item{...}{Optional \code{ggplot2} arguments.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plots simulation results.
}
\details{
Generic function to plot all kinds of simulation results.
}
