% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinycssloaders-package.r
\docType{package}
\name{shinycssloaders-package}
\alias{shinycssloaders}
\alias{shinycssloaders-package}
\title{shinycssloaders: Add Loading Animations to a 'shiny' Output While It's Recalculating}
\description{
When a 'Shiny' output (such as a plot, table, map, etc.) is recalculating, it remains visible but gets greyed out. Using 'shinycssloaders', you can add a loading animation ("spinner") to outputs instead. By wrapping a 'Shiny' output in 'withSpinner()', a spinner will automatically appear while the output is recalculating. You can also manually show and hide the spinner, or add a full-page spinner to cover the entire page. See the demo online at \url{https://daattali.com/shiny/shinycssloaders-demo/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/daattali/shinycssloaders}
  \item \url{https://daattali.com/shiny/shinycssloaders-demo/}
  \item Report bugs at \url{https://github.com/daattali/shinycssloaders/issues}
}

}
\author{
\strong{Maintainer}: Dean Attali \email{daattali@gmail.com} (\href{https://orcid.org/0000-0002-5645-3493}{ORCID}) (Maintainer/developer of shinycssloaders since 2019)

Authors:
\itemize{
  \item Andras Sali \email{andras.sali@alphacruncher.hu} (Original creator of shinycssloaders package)
}

Other contributors:
\itemize{
  \item Luke Hass (Author of included CSS loader code) [contributor, copyright holder]
}

}
\keyword{internal}
