% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth-encrypt.R
\name{Authenticated encryption}
\alias{Authenticated encryption}
\alias{auth_encrypt}
\alias{auth_decrypt}
\title{Authenticated Encryption}
\usage{
auth_encrypt(msg, key, pubkey, nonce = random(24))

auth_decrypt(bin, key, pubkey, nonce = attr(bin, "nonce"))
}
\arguments{
\item{msg}{message to be encrypted}

\item{key}{your own private key}

\item{pubkey}{other person's public key}

\item{nonce}{non-secret unique data to randomize the cipher}

\item{bin}{encrypted ciphertext generated by \code{secure_send}}
}
\description{
Exchange secure messages through curve25519 authenticated encryption.
}
\details{
Authenticated encryption implements best practices for secure messaging.
It requires that both sender and receiver have a keypair and know each
other's public key. Each message gets authenticated with the key of the
sender and encrypted with the key of the receiver.

Even though public keys are not confidential, you should not exchange them
over the same insecure channel you are trying to protect. If the connection
is being tampered with, the attacker could simply replace the key with another
one to hijack the interaction.

Most people share their public key by posting them on their website or on a
public keyserver. Another alternative is having your public key signed by a
mutually trusted third party. HTTPS does this using Certificate Authorities.
}
\examples{
# Bob's keypair:
bob_key <- keygen()
bob_pubkey <- pubkey(bob_key)

# Alice's keypair:
alice_key <- keygen()
alice_pubkey <- pubkey(alice_key)

# Bob sends encrypted message for Alice:
msg <- charToRaw("TTIP is evil")
ciphertext <- auth_encrypt(msg, bob_key, alice_pubkey)

# Alice verifies and decrypts with her key
out <- auth_decrypt(ciphertext, alice_key, bob_pubkey)
stopifnot(identical(out, msg))

# Alice sends encrypted message for Bob
msg <- charToRaw("Let's protest")
ciphertext <- auth_encrypt(msg, alice_key, bob_pubkey)

# Bob verifies and decrypts with his key
out <- auth_decrypt(ciphertext, bob_key, alice_pubkey)
stopifnot(identical(out, msg))
}
\references{
\url{http://doc.libsodium.org/public-key_cryptography/authenticated_encryption.html}
}
