// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DateTime.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.datetime {
  public class DateTime_3_0_2 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("datetime.DateTime:3.0.2", null);

    public DateTime_3_0_2(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DateTime_3_0_2(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DateTime_3_0_2 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DateTime_3_0_2(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class ZoneInfo : ICloneable {
      public object Clone() {
        ZoneInfo copy = new ZoneInfo();
        copy.id = this.id;
        copy.name = this.name;
        copy.hasDSTInfo = this.hasDSTInfo;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["name"] = this.name;
        json["hasDSTInfo"] = this.hasDSTInfo;
        return json;
      }

      public static ZoneInfo Decode(LightJson.JsonObject json, Agent agent) {
        ZoneInfo inst = new ZoneInfo();
        inst.id = (int)json["id"];
        inst.name = (string)json["name"];
        inst.hasDSTInfo = (bool)json["hasDSTInfo"];
        return inst;
      }

      public int id = 0;
      public string name = "";
      public bool hasDSTInfo = false;
    }

    public class ZoneCfg : ICloneable {
      public object Clone() {
        ZoneCfg copy = new ZoneCfg();
        copy.id = this.id;
        copy.name = this.name;
        copy.enableAutoDST = this.enableAutoDST;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["name"] = this.name;
        json["enableAutoDST"] = this.enableAutoDST;
        return json;
      }

      public static ZoneCfg Decode(LightJson.JsonObject json, Agent agent) {
        ZoneCfg inst = new ZoneCfg();
        inst.id = (int)json["id"];
        inst.name = (string)json["name"];
        inst.enableAutoDST = (bool)json["enableAutoDST"];
        return inst;
      }

      public int id = 0;
      public string name = "";
      public bool enableAutoDST = false;
    }

    public enum Protocol {
      STATIC,
      NTP,
    }

    public class NtpCfg : ICloneable {
      public object Clone() {
        NtpCfg copy = new NtpCfg();
        copy.server1 = this.server1;
        copy.server2 = this.server2;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["server1"] = this.server1;
        json["server2"] = this.server2;
        return json;
      }

      public static NtpCfg Decode(LightJson.JsonObject json, Agent agent) {
        NtpCfg inst = new NtpCfg();
        inst.server1 = (string)json["server1"];
        inst.server2 = (string)json["server2"];
        return inst;
      }

      public string server1 = "";
      public string server2 = "";
    }

    public class Cfg : ICloneable {
      public object Clone() {
        Cfg copy = new Cfg();
        copy.zoneCfg = this.zoneCfg;
        copy.protocol = this.protocol;
        copy.deviceTime = this.deviceTime;
        copy.ntpCfg = this.ntpCfg;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["zoneCfg"] = this.zoneCfg.Encode();
        json["protocol"] = (int)this.protocol;
        json["deviceTime"] = this.deviceTime.Ticks;
        json["ntpCfg"] = this.ntpCfg.Encode();
        return json;
      }

      public static Cfg Decode(LightJson.JsonObject json, Agent agent) {
        Cfg inst = new Cfg();
        inst.zoneCfg = Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneCfg.Decode(json["zoneCfg"], agent);
        inst.protocol = (Com.Raritan.Idl.datetime.DateTime_3_0_2.Protocol)(int)json["protocol"];
        inst.deviceTime = new System.DateTime(json["deviceTime"]);
        inst.ntpCfg = Com.Raritan.Idl.datetime.DateTime_3_0_2.NtpCfg.Decode(json["ntpCfg"], agent);
        return inst;
      }

      public Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneCfg zoneCfg = new Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneCfg();
      public Com.Raritan.Idl.datetime.DateTime_3_0_2.Protocol protocol = Com.Raritan.Idl.datetime.DateTime_3_0_2.Protocol.STATIC;
      public System.DateTime deviceTime = new System.DateTime(0);
      public Com.Raritan.Idl.datetime.DateTime_3_0_2.NtpCfg ntpCfg = new Com.Raritan.Idl.datetime.DateTime_3_0_2.NtpCfg();
    }

    public class ConfigurationChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("datetime.DateTime_3_0_2.ConfigurationChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

    }

    public class GetZoneInfosResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo> zoneInfos;
    }

    public GetZoneInfosResult getZoneInfos(bool useOlson) {
      var _parameters = new LightJson.JsonObject();
      _parameters["useOlson"] = useOlson;

      var _result = RpcCall("getZoneInfos", _parameters);
      var _ret = new GetZoneInfosResult();
      _ret.zoneInfos = new System.Collections.Generic.List<Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo>(_result["zoneInfos"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getZoneInfos(bool useOlson, AsyncRpcResponse<GetZoneInfosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getZoneInfos(useOlson, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getZoneInfos(bool useOlson, AsyncRpcResponse<GetZoneInfosResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["useOlson"] = useOlson;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getZoneInfos", _parameters,
        _result => {
          try {
            var _ret = new GetZoneInfosResult();
            _ret.zoneInfos = new System.Collections.Generic.List<Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo>(_result["zoneInfos"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class CheckNtpServerResult {
      public bool _ret_;
    }

    public CheckNtpServerResult checkNtpServer(string ntpServer) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ntpServer"] = ntpServer;

      var _result = RpcCall("checkNtpServer", _parameters);
      var _ret = new CheckNtpServerResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest checkNtpServer(string ntpServer, AsyncRpcResponse<CheckNtpServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return checkNtpServer(ntpServer, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest checkNtpServer(string ntpServer, AsyncRpcResponse<CheckNtpServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ntpServer"] = ntpServer;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("checkNtpServer", _parameters,
        _result => {
          try {
            var _ret = new CheckNtpServerResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetActiveNtpServersResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetActiveNtpServersResult getActiveNtpServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getActiveNtpServers", _parameters);
      var _ret = new GetActiveNtpServersResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getActiveNtpServers(AsyncRpcResponse<GetActiveNtpServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getActiveNtpServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getActiveNtpServers(AsyncRpcResponse<GetActiveNtpServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getActiveNtpServers", _parameters,
        _result => {
          try {
            var _ret = new GetActiveNtpServersResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCfgResult {
      public Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg cfg;
    }

    public GetCfgResult getCfg() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCfg", _parameters);
      var _ret = new GetCfgResult();
      _ret.cfg = Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg.Decode(_result["cfg"], agent);
      return _ret;
    }

    public AsyncRequest getCfg(AsyncRpcResponse<GetCfgResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCfg(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCfg(AsyncRpcResponse<GetCfgResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCfg", _parameters,
        _result => {
          try {
            var _ret = new GetCfgResult();
            _ret.cfg = Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg.Decode(_result["cfg"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetCfgResult {
      public int _ret_;
    }

    public SetCfgResult setCfg(Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg cfg) {
      var _parameters = new LightJson.JsonObject();
      _parameters["cfg"] = cfg.Encode();

      var _result = RpcCall("setCfg", _parameters);
      var _ret = new SetCfgResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setCfg(Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg cfg, AsyncRpcResponse<SetCfgResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setCfg(cfg, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setCfg(Com.Raritan.Idl.datetime.DateTime_3_0_2.Cfg cfg, AsyncRpcResponse<SetCfgResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["cfg"] = cfg.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setCfg", _parameters,
        _result => {
          try {
            var _ret = new SetCfgResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetTimeResult {
      public Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo zone;
      public bool dstEnabled;
      public int utcOffset;
      public System.DateTime currentTime;
    }

    public GetTimeResult getTime(bool useOlson) {
      var _parameters = new LightJson.JsonObject();
      _parameters["useOlson"] = useOlson;

      var _result = RpcCall("getTime", _parameters);
      var _ret = new GetTimeResult();
      _ret.zone = Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo.Decode(_result["zone"], agent);
      _ret.dstEnabled = (bool)_result["dstEnabled"];
      _ret.utcOffset = (int)_result["utcOffset"];
      _ret.currentTime = new System.DateTime(_result["currentTime"]);
      return _ret;
    }

    public AsyncRequest getTime(bool useOlson, AsyncRpcResponse<GetTimeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTime(useOlson, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTime(bool useOlson, AsyncRpcResponse<GetTimeResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["useOlson"] = useOlson;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getTime", _parameters,
        _result => {
          try {
            var _ret = new GetTimeResult();
            _ret.zone = Com.Raritan.Idl.datetime.DateTime_3_0_2.ZoneInfo.Decode(_result["zone"], agent);
            _ret.dstEnabled = (bool)_result["dstEnabled"];
            _ret.utcOffset = (int)_result["utcOffset"];
            _ret.currentTime = new System.DateTime(_result["currentTime"]);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
