# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from Port.idl.

use strict;

package Raritan::RPC::portsmodel::Port_2_0_2;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "portsmodel.Port:2.0.2";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::portsmodel::Port_2_0_2::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use constant NO_ERROR => 0;

use constant ERR_INVALID_PARAM => 1;

use constant ERR_DEVICE_BUSY => 2;

use Raritan::RPC::portsmodel::Port_2_0_2::Properties;

sub getProperties($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getProperties', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::portsmodel::Port_2_0_2::Properties::decode($agent, $rsp->{'_ret_'});
    return $_ret_;
}

sub setName($$) {
    my ($self, $name) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'name'} = "$name";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setName', $args);
}

use Raritan::RPC::portsmodel::Port_2_0_2::DetectionMode;

sub setDetectionMode($$) {
    my ($self, $mode) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'mode'} = Raritan::RPC::portsmodel::Port_2_0_2::DetectionMode::encode($mode);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setDetectionMode', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

sub getDetectableDevices($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDetectableDevices', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

sub getDevice($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDevice', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}, 'idl.Object');
    return $_ret_;
}

sub getDeviceConfig($$) {
    my ($self, $deviceType) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'deviceType'} = "$deviceType";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getDeviceConfig', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}, 'idl.Object');
    return $_ret_;
}


sub getFuse($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getFuse', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}, 'portsmodel.PortFuse');
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('portsmodel.Port', 2, 0, 2, 'Raritan::RPC::portsmodel::Port_2_0_2');
1;
