# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DiagLogSettings.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.diag


# interface
class DiagLogSettings(Interface):
    idlType = "diag.DiagLogSettings:1.0.0"

    # enumeration
    class LogLevel(Enumeration):
        idlType = "diag.DiagLogSettings.LogLevel:1.0.0"
        values = ["LOG_LEVEL_NONE", "LOG_LEVEL_ERR", "LOG_LEVEL_WARN", "LOG_LEVEL_INFO", "LOG_LEVEL_DEBUG", "LOG_LEVEL_TRACE"]

    LogLevel.LOG_LEVEL_NONE = LogLevel(0)
    LogLevel.LOG_LEVEL_ERR = LogLevel(1)
    LogLevel.LOG_LEVEL_WARN = LogLevel(2)
    LogLevel.LOG_LEVEL_INFO = LogLevel(3)
    LogLevel.LOG_LEVEL_DEBUG = LogLevel(4)
    LogLevel.LOG_LEVEL_TRACE = LogLevel(5)

    # structure
    class LogLevelEntry(Structure):
        idlType = "diag.DiagLogSettings.LogLevelEntry:1.0.0"
        elements = ["ctxName", "logLevel"]

        def __init__(self, ctxName, logLevel):
            typecheck.is_string(ctxName, AssertionError)
            typecheck.is_enum(logLevel, raritan.rpc.diag.DiagLogSettings.LogLevel, AssertionError)

            self.ctxName = ctxName
            self.logLevel = logLevel

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ctxName = json['ctxName'],
                logLevel = raritan.rpc.diag.DiagLogSettings.LogLevel.decode(json['logLevel']),
            )
            return obj

        def encode(self):
            json = {}
            json['ctxName'] = self.ctxName
            json['logLevel'] = raritan.rpc.diag.DiagLogSettings.LogLevel.encode(self.logLevel)
            return json

    ERR_NONE = 0

    ERR_UNKNOWN_LOG_CONTEXT_NAME = 1

    ERR_UNKNOWN_LOG_LEVEL = 2

    class _resetLogLevelsForAllCtxNames(Interface.Method):
        name = 'resetLogLevelsForAllCtxNames'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getLogLevelsForAllCtxNames(Interface.Method):
        name = 'getLogLevelsForAllCtxNames'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.diag.DiagLogSettings.LogLevelEntry.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.diag.DiagLogSettings.LogLevelEntry, DecodeException)
            return _ret_

    class _setLogLevelForAllCtxNames(Interface.Method):
        name = 'setLogLevelForAllCtxNames'

        @staticmethod
        def encode(logLevel):
            typecheck.is_enum(logLevel, raritan.rpc.diag.DiagLogSettings.LogLevel, AssertionError)
            args = {}
            args['logLevel'] = raritan.rpc.diag.DiagLogSettings.LogLevel.encode(logLevel)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getLogLevelByCtxName(Interface.Method):
        name = 'getLogLevelByCtxName'

        @staticmethod
        def encode(ctxName):
            typecheck.is_string(ctxName, AssertionError)
            args = {}
            args['ctxName'] = ctxName
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            logLevel = raritan.rpc.diag.DiagLogSettings.LogLevel.decode(rsp['logLevel'])
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_enum(logLevel, raritan.rpc.diag.DiagLogSettings.LogLevel, DecodeException)
            return (_ret_, logLevel)

    class _setLogLevelByCtxName(Interface.Method):
        name = 'setLogLevelByCtxName'

        @staticmethod
        def encode(ctxName, logLevel):
            typecheck.is_string(ctxName, AssertionError)
            typecheck.is_enum(logLevel, raritan.rpc.diag.DiagLogSettings.LogLevel, AssertionError)
            args = {}
            args['ctxName'] = ctxName
            args['logLevel'] = raritan.rpc.diag.DiagLogSettings.LogLevel.encode(logLevel)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DiagLogSettings, self).__init__(target, agent)
        self.resetLogLevelsForAllCtxNames = DiagLogSettings._resetLogLevelsForAllCtxNames(self)
        self.getLogLevelsForAllCtxNames = DiagLogSettings._getLogLevelsForAllCtxNames(self)
        self.setLogLevelForAllCtxNames = DiagLogSettings._setLogLevelForAllCtxNames(self)
        self.getLogLevelByCtxName = DiagLogSettings._getLogLevelByCtxName(self)
        self.setLogLevelByCtxName = DiagLogSettings._setLogLevelByCtxName(self)

# from raritan/rpc/diag/__extend__.py
def download_diag(agent):
    """
    Method to download the diagnostic data

    **parameters**

    :param agent: An agent instance from the device where the diagnostic file should be downloaded
    :return: returns the diagnostic data

    **Example**
        :Example:

        from raritan import rpc
        from raritan.rpc import diag

        agent = rpc.Agent("https", "my-pdu.example.com", "admin", "raritan")
        # download
        diag = diag.download_diag(agent)
        print(diag)
    """
    target = "cgi-bin/diag-data.cgi"
    return agent.get(target)
