# move a mesh: obtain a curved element
# from Pk reference triangle or tetra
BEGIN {
	have_rheolef = 0;
	have_3d      = 1;
      }
($1 != "") {
        if (have_rheolef) {
	  x = $1;
	  y = $2; 
	  z = $3;
        } else { # gmsh
	  i = $1;
	  x = $2;
	  y = $3; 
	  z = $4;
        }
        f = x*(1-x) + y*(1-y) + z*(1-z);
        if (! have_3d && z == 0) {
          a = 0.5;
          b = 0.25;
          c = 0;
        } else {
          a = 0.2;
          b = 0.15;
          c = 0.1;
        }
        u = a*f;
        v = b*f;
        w = c*f;
        x += u;
        y += v;
        z += w;
        if (have_rheolef) {
          printf("%.15g %.15g %.15g\n", x,y,z);
        } else {
          printf("%d %.15g %.15g %.15g\n", i, x,y,z);
        }
  }
