//
// file automatically generated using m4 expansion
//
// blas 1 expressions without template expression
// 
// author: Pierre.Saramito@imag.fr
//
// date: 1 april 1997
//
# include "blas1-dense-no-tmpl.h"
# include "blas-algorithm.h"
namespace rheolef {

// ========================[ INLINE UTILITIES ]=================================
template <
    class PairInputIterator, 
    class T>
inline
T
normx (
    PairInputIterator iter_x, 
    PairInputIterator last_x, 
    const T&)
{
    T s = 0;
    while (iter_x != last_x) {
	s += sqr(*iter_x);
	++iter_x;
    }
    return std::sqrt(s);
}
template <
    class PairInputIterator1, 
    class PairInputIterator2,
    class T>
inline
T
xdoty (
    PairInputIterator1 iter_x, 
    PairInputIterator1 last_x, 
    PairInputIterator2 iter_y, 
    const T&)
{
    T s = 0;
    while (iter_x != last_x) {
	s += (*iter_x) * (*iter_y);
	++iter_x;
	++iter_y;
    }
    return s;
}

// norm
template <class T>
T
norm (const vec<T>& x)
{
    return normx (x.begin(), x.end(), T());
}
// dot product
template <class T>
T
dot (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    return xdoty (x.begin(), x.end(), y.begin(), T());
}

// unary operators
template <class T>
vec<T>
operator + (const vec<T>& x)
{
    return x;
}
template <class T>
vec<T>
operator - (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), std::negate<T>(), x.begin());
    return z;
}
// unary functions

template<class T>
struct abs_op : std::unary_function<T, T> {
    T operator() (T x) const { return xabs(x); }
};

template <class T>
vec<T>
abs (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), abs_op<T>(), x.begin());
    return z;
}
template<class T>
struct atan_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::atan(x); }
};

template <class T>
vec<T>
atan (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), atan_op<T>(), x.begin());
    return z;
}
template<class T>
struct cos_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::cos(x); }
};

template <class T>
vec<T>
cos (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), cos_op<T>(), x.begin());
    return z;
}
template<class T>
struct cosh_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::cosh(x); }
};

template <class T>
vec<T>
cosh (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), cosh_op<T>(), x.begin());
    return z;
}
template<class T>
struct exp_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::exp(x); }
};

template <class T>
vec<T>
exp (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), exp_op<T>(), x.begin());
    return z;
}
template<class T>
struct log_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::log(x); }
};

template <class T>
vec<T>
log (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), log_op<T>(), x.begin());
    return z;
}
template<class T>
struct log10_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::log10(x); }
};

template <class T>
vec<T>
log10 (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), log10_op<T>(), x.begin());
    return z;
}
template<class T>
struct sin_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::sin(x); }
};

template <class T>
vec<T>
sin (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), sin_op<T>(), x.begin());
    return z;
}
template<class T>
struct sinh_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::sinh(x); }
};

template <class T>
vec<T>
sinh (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), sinh_op<T>(), x.begin());
    return z;
}
template<class T>
struct sqrt_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::sqrt(x); }
};

template <class T>
vec<T>
sqrt (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), sqrt_op<T>(), x.begin());
    return z;
}
template<class T>
struct tanh_op : std::unary_function<T, T> {
    T operator() (T x) const { return std::tanh(x); }
};

template <class T>
vec<T>
tanh (const vec<T>& x)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), tanh_op<T>(), x.begin());
    return z;
}
// binary operators and computed assignments

template <class T>
vec<T>
operator + (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), add_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
operator + (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(add_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
operator + (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(add_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template <class T>
vec<T>&
operator += (vec<T>& z, const vec<T>& x)
{
    check_length(z,x);
    zopassignx (add_assign<T, T>(), z.begin(), z.end(), x.begin());
    return z;
}
template <class T>
vec<T>&
operator += (vec<T>& z, const Float& lambda)
{
    zopassignr (add_assign<T, Float>(), z.begin(), z.end(), lambda);
    return z;
}
template <class T>
vec<T>
operator - (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), sub_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
operator - (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(sub_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
operator - (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(sub_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template <class T>
vec<T>&
operator -= (vec<T>& z, const vec<T>& x)
{
    check_length(z,x);
    zopassignx (sub_assign<T, T>(), z.begin(), z.end(), x.begin());
    return z;
}
template <class T>
vec<T>&
operator -= (vec<T>& z, const Float& lambda)
{
    zopassignr (sub_assign<T, Float>(), z.begin(), z.end(), lambda);
    return z;
}
template <class T>
vec<T>
operator * (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), mul_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
operator * (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(mul_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
operator * (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(mul_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template <class T>
vec<T>&
operator *= (vec<T>& z, const vec<T>& x)
{
    check_length(z,x);
    zopassignx (mul_assign<T, T>(), z.begin(), z.end(), x.begin());
    return z;
}
template <class T>
vec<T>&
operator *= (vec<T>& z, const Float& lambda)
{
    zopassignr (mul_assign<T, Float>(), z.begin(), z.end(), lambda);
    return z;
}
template <class T>
vec<T>
operator / (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), div_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
operator / (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(div_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
operator / (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(div_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template <class T>
vec<T>&
operator /= (vec<T>& z, const vec<T>& x)
{
    check_length(z,x);
    zopassignx (div_assign<T, T>(), z.begin(), z.end(), x.begin());
    return z;
}
template <class T>
vec<T>&
operator /= (vec<T>& z, const Float& lambda)
{
    zopassignr (div_assign<T, Float>(), z.begin(), z.end(), lambda);
    return z;
}
// binary functions

template<class T1, class T2, class T3>
struct atan2_op : std::binary_function<T1, T2, T3> {
T3 operator() (T1 x, T2 y) const { return std::atan2(x,y); }
};
template <class T>
vec<T>
atan2 (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), atan2_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
atan2 (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(atan2_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
atan2 (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(atan2_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template<class T1, class T2, class T3>
struct max_op : std::binary_function<T1, T2, T3> {
T3 operator() (T1 x, T2 y) const { return std::max(x,y); }
};
template <class T>
vec<T>
max (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), max_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
max (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(max_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
max (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(max_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template<class T1, class T2, class T3>
struct min_op : std::binary_function<T1, T2, T3> {
T3 operator() (T1 x, T2 y) const { return std::min(x,y); }
};
template <class T>
vec<T>
min (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), min_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
min (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(min_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
min (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(min_op<Float, T, T>(), lambda), y.begin());
    return z;
}
template<class T1, class T2, class T3>
struct pow_op : std::binary_function<T1, T2, T3> {
T3 operator() (T1 x, T2 y) const { return std::pow(x,y); }
};
template <class T>
vec<T>
pow (const vec<T>& x, const vec<T>& y)
{
    check_length(x,y);
    vec<T> z(x.n());
    zassignxopy (z.begin(), z.end(), pow_op<T, T, T>(), x.begin(), y.begin());
    return z;
}
template <class T>
vec<T>
pow (const vec<T>& x, const Float& lambda)
{
    vec<T> z(x.n());
    zassignopx (z.begin(), z.end(), bind2nd(pow_op<T, Float, T>(), lambda), x.begin());
    return z;
}
template <class T>
vec<T>
pow (const Float& lambda, const vec<T>& y)
{
    vec<T> z(y.n());
    zassignopx (z.begin(), z.end(), bind1st(pow_op<Float, T, T>(), lambda), y.begin());
    return z;
}
// =====================[ INSTANCIATION IN LIBRARY ]=============================
template Float norm (const vec<Float>& x);
template Float dot  (const vec<Float>& x, const vec<Float>& y);
template vec<Float> operator + (const vec<Float>&);
template vec<Float> operator - (const vec<Float>&);
template vec<Float> abs (const vec<Float>& x);
template vec<Float> atan (const vec<Float>& x);
template vec<Float> cos (const vec<Float>& x);
template vec<Float> cosh (const vec<Float>& x);
template vec<Float> exp (const vec<Float>& x);
template vec<Float> log (const vec<Float>& x);
template vec<Float> log10 (const vec<Float>& x);
template vec<Float> sin (const vec<Float>& x);
template vec<Float> sinh (const vec<Float>& x);
template vec<Float> sqrt (const vec<Float>& x);
template vec<Float> tanh (const vec<Float>& x);
template vec<Float>  operator +  (const vec<Float>&, const vec<Float>&);
template vec<Float>  operator +  (const vec<Float>&, const Float&);
template vec<Float>  operator +  (const Float&, const vec<Float>&);
template vec<Float>& operator += (vec<Float>&, const vec<Float>&);
template vec<Float>& operator += (vec<Float>&, const Float&);
template vec<Float>  operator -  (const vec<Float>&, const vec<Float>&);
template vec<Float>  operator -  (const vec<Float>&, const Float&);
template vec<Float>  operator -  (const Float&, const vec<Float>&);
template vec<Float>& operator -= (vec<Float>&, const vec<Float>&);
template vec<Float>& operator -= (vec<Float>&, const Float&);
template vec<Float>  operator /  (const vec<Float>&, const vec<Float>&);
template vec<Float>  operator /  (const vec<Float>&, const Float&);
template vec<Float>  operator /  (const Float&, const vec<Float>&);
template vec<Float>& operator /= (vec<Float>&, const vec<Float>&);
template vec<Float>& operator /= (vec<Float>&, const Float&);
template vec<Float>  operator *  (const vec<Float>&, const vec<Float>&);
template vec<Float>  operator *  (const vec<Float>&, const Float&);
template vec<Float>  operator *  (const Float&, const vec<Float>&);
template vec<Float>& operator *= (vec<Float>&, const vec<Float>&);
template vec<Float>& operator *= (vec<Float>&, const Float&);
template vec<Float> atan2 (const vec<Float>&, const vec<Float>&);
template vec<Float> atan2 (const vec<Float>&, const Float&);
template vec<Float> atan2 (const Float&,   const vec<Float>&);
template vec<Float> max (const vec<Float>&, const vec<Float>&);
template vec<Float> max (const vec<Float>&, const Float&);
template vec<Float> max (const Float&,   const vec<Float>&);
template vec<Float> min (const vec<Float>&, const vec<Float>&);
template vec<Float> min (const vec<Float>&, const Float&);
template vec<Float> min (const Float&,   const vec<Float>&);
template vec<Float> pow (const vec<Float>&, const vec<Float>&);
template vec<Float> pow (const vec<Float>&, const Float&);
template vec<Float> pow (const Float&,   const vec<Float>&);
}// namespace rheolef
