#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
BIN=./ssk_tst
if test x"$1" = x"-3d"; then
    flag_3d=$1;
    shift
fi
k_max=$1
k_step=$2

echo "# size	cpu_fact	cpu_solve"
echo "# size	cpu_fact	cpu_solve" 1>&2
k=${k_step}
while test ${k} -le ${k_max}; do
    ${BIN} ${flag_3d} ${k} 2> spooles_tst.log
    status=$?
    if test $status -ne 0; then
        echo "${BIN}: error." 1>&2
	exit 1
    fi
    problem_size=`grep problem_size spooles_tst.log | awk '{print $3}' `
    cpu_fact=`grep cpu_fact spooles_tst.log | awk '{print $3}' `
    cpu_solve=`grep cpu_solve spooles_tst.log | awk '{print $3}' `
    /bin/rm -f spooles_tst.log
    echo "${problem_size}	${cpu_fact}	${cpu_solve}"
    echo "${problem_size}	${cpu_fact}	${cpu_solve}" 1>&2
    k=`echo "${k}+${k_step}" | bc -l`
done
exit 0

