/*  This file is part of SAIL (https://github.com/HappySeaFox/sail)

    Copyright (c) 2020 Dmitry Baryshev

    The MIT License

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
*/

#ifndef SAIL_CODEC_BUNDLE_PRIVATE_H
#define SAIL_CODEC_BUNDLE_PRIVATE_H

#include <sail-common/export.h>
#include <sail-common/status.h>

struct sail_codec_bundle;

/*
 * Private codec bundle functions.
 */

/*
 * Allocates a new codec bundle.
 *
 * Returns SAIL_OK on success.
 */
SAIL_HIDDEN sail_status_t alloc_codec_bundle(struct sail_codec_bundle **codec_bundle);

/*
 * Destroys the specified codec bundle and all its internal allocated memory buffers.
 */
SAIL_HIDDEN void destroy_codec_bundle(struct sail_codec_bundle *codec_bundle);

#endif
