/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SchemaErrorHandler
implements ErrorHandler {
    private Logger m_aLogger;
    private SAXParseExceptionFilter m_aFilter;

    SchemaErrorHandler(Logger aLogger, SAXParseExceptionFilter aFilter) {
        this.m_aLogger = aLogger;
        this.m_aFilter = aFilter;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (!this.filter(e)) {
            this.m_aLogger.logWarning(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.fatalErrorNoException(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (!this.filter(e)) {
            this.m_aLogger.logError(e);
        }
    }

    public void fatalErrorNoException(SAXParseException e) {
        if (!this.filter(e)) {
            this.m_aLogger.logFatalError(e);
        }
    }

    private boolean filter(SAXParseException e) {
        boolean bFiltered = false;
        if (this.m_aFilter != null) {
            SAXParseException aNewExc = this.m_aFilter.filterException(e);
            if (aNewExc == null) {
                bFiltered = true;
            } else if (aNewExc != e) {
                this.m_aLogger.logWarning(aNewExc);
                bFiltered = true;
            }
        }
        return bFiltered;
    }
}

