
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_SSTRUCT_MV_MUP_HEADER
#define hypre_SSTRUCT_MV_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
hypre_SStructAxpy_flt( hypre_float alpha, hypre_SStructVector *x, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructAxpy_dbl( hypre_double alpha, hypre_SStructVector *x, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructAxpy_long_dbl( hypre_long_double alpha, hypre_SStructVector *x, hypre_SStructVector *y );

HYPRE_Int
hypre_SStructBoxManEntryGetBoxnum_flt( hypre_BoxManEntry *entry, HYPRE_Int *id_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetBoxnum_dbl( hypre_BoxManEntry *entry, HYPRE_Int *id_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetBoxnum_long_dbl( hypre_BoxManEntry *entry, HYPRE_Int *id_ptr );

HYPRE_Int
hypre_SStructBoxManEntryGetCSRstrides_flt( hypre_BoxManEntry *entry, hypre_Index strides );
HYPRE_Int
hypre_SStructBoxManEntryGetCSRstrides_dbl( hypre_BoxManEntry *entry, hypre_Index strides );
HYPRE_Int
hypre_SStructBoxManEntryGetCSRstrides_long_dbl( hypre_BoxManEntry *entry, hypre_Index strides );

HYPRE_Int
hypre_SStructBoxManEntryGetGhstrides_flt( hypre_BoxManEntry *entry, hypre_Index strides );
HYPRE_Int
hypre_SStructBoxManEntryGetGhstrides_dbl( hypre_BoxManEntry *entry, hypre_Index strides );
HYPRE_Int
hypre_SStructBoxManEntryGetGhstrides_long_dbl( hypre_BoxManEntry *entry, hypre_Index strides );

HYPRE_Int
hypre_SStructBoxManEntryGetGlobalCSRank_flt( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalCSRank_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalCSRank_long_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );

HYPRE_Int
hypre_SStructBoxManEntryGetGlobalGhrank_flt( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalGhrank_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalGhrank_long_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr );

HYPRE_Int
hypre_SStructBoxManEntryGetGlobalRank_flt( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr, HYPRE_Int type );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalRank_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr, HYPRE_Int type );
HYPRE_Int
hypre_SStructBoxManEntryGetGlobalRank_long_dbl( hypre_BoxManEntry *entry, hypre_Index index, HYPRE_BigInt *rank_ptr, HYPRE_Int type );

HYPRE_Int
hypre_SStructBoxManEntryGetPart_flt( hypre_BoxManEntry *entry, HYPRE_Int part, HYPRE_Int *part_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetPart_dbl( hypre_BoxManEntry *entry, HYPRE_Int part, HYPRE_Int *part_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetPart_long_dbl( hypre_BoxManEntry *entry, HYPRE_Int part, HYPRE_Int *part_ptr );

HYPRE_Int
hypre_SStructBoxManEntryGetProcess_flt( hypre_BoxManEntry *entry, HYPRE_Int *proc_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetProcess_dbl( hypre_BoxManEntry *entry, HYPRE_Int *proc_ptr );
HYPRE_Int
hypre_SStructBoxManEntryGetProcess_long_dbl( hypre_BoxManEntry *entry, HYPRE_Int *proc_ptr );

HYPRE_Int
hypre_SStructBoxManEntryGetStrides_flt( hypre_BoxManEntry *entry, hypre_Index strides, HYPRE_Int type );
HYPRE_Int
hypre_SStructBoxManEntryGetStrides_dbl( hypre_BoxManEntry *entry, hypre_Index strides, HYPRE_Int type );
HYPRE_Int
hypre_SStructBoxManEntryGetStrides_long_dbl( hypre_BoxManEntry *entry, hypre_Index strides, HYPRE_Int type );

HYPRE_Int
hypre_SStructBoxNumMap_flt( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int boxnum, HYPRE_Int **num_varboxes_ptr, HYPRE_Int ***map_ptr );
HYPRE_Int
hypre_SStructBoxNumMap_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int boxnum, HYPRE_Int **num_varboxes_ptr, HYPRE_Int ***map_ptr );
HYPRE_Int
hypre_SStructBoxNumMap_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int boxnum, HYPRE_Int **num_varboxes_ptr, HYPRE_Int ***map_ptr );

HYPRE_Int
hypre_SStructBoxToNborBox_flt( hypre_Box *box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );
HYPRE_Int
hypre_SStructBoxToNborBox_dbl( hypre_Box *box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );
HYPRE_Int
hypre_SStructBoxToNborBox_long_dbl( hypre_Box *box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );

HYPRE_Int
hypre_SStructCellBoxToVarBox_flt( hypre_Box *box, hypre_Index offset, hypre_Index varoffset, HYPRE_Int *valid );
HYPRE_Int
hypre_SStructCellBoxToVarBox_dbl( hypre_Box *box, hypre_Index offset, hypre_Index varoffset, HYPRE_Int *valid );
HYPRE_Int
hypre_SStructCellBoxToVarBox_long_dbl( hypre_Box *box, hypre_Index offset, hypre_Index varoffset, HYPRE_Int *valid );

HYPRE_Int
hypre_SStructCellGridBoxNumMap_flt( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int ***num_varboxes_ptr, HYPRE_Int ****map_ptr );
HYPRE_Int
hypre_SStructCellGridBoxNumMap_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int ***num_varboxes_ptr, HYPRE_Int ****map_ptr );
HYPRE_Int
hypre_SStructCellGridBoxNumMap_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int ***num_varboxes_ptr, HYPRE_Int ****map_ptr );

HYPRE_Int
hypre_SStructCopy_flt( hypre_SStructVector *x, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructCopy_dbl( hypre_SStructVector *x, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructCopy_long_dbl( hypre_SStructVector *x, hypre_SStructVector *y );

HYPRE_BigInt
hypre_SStructGraphFindBoxEndpt_flt( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_Int boxi );
HYPRE_BigInt
hypre_SStructGraphFindBoxEndpt_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_Int boxi );
HYPRE_BigInt
hypre_SStructGraphFindBoxEndpt_long_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_Int boxi );

HYPRE_Int
hypre_SStructGraphFindSGridEndpts_flt( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_BigInt *endpts );
HYPRE_Int
hypre_SStructGraphFindSGridEndpts_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_BigInt *endpts );
HYPRE_Int
hypre_SStructGraphFindSGridEndpts_long_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, HYPRE_Int proc, HYPRE_Int endpt, HYPRE_BigInt *endpts );

HYPRE_Int
hypre_SStructGraphGetUVEntryRank_flt( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, hypre_Index index, HYPRE_BigInt *rank );
HYPRE_Int
hypre_SStructGraphGetUVEntryRank_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, hypre_Index index, HYPRE_BigInt *rank );
HYPRE_Int
hypre_SStructGraphGetUVEntryRank_long_dbl( hypre_SStructGraph *graph, HYPRE_Int part, HYPRE_Int var, hypre_Index index, HYPRE_BigInt *rank );

HYPRE_Int
hypre_SStructGraphRef_flt( hypre_SStructGraph *graph, hypre_SStructGraph **graph_ref );
HYPRE_Int
hypre_SStructGraphRef_dbl( hypre_SStructGraph *graph, hypre_SStructGraph **graph_ref );
HYPRE_Int
hypre_SStructGraphRef_long_dbl( hypre_SStructGraph *graph, hypre_SStructGraph **graph_ref );

HYPRE_Int
hypre_SStructGridAssembleBoxManagers_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridAssembleBoxManagers_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridAssembleBoxManagers_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridAssembleNborBoxManagers_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridAssembleNborBoxManagers_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridAssembleNborBoxManagers_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridBoxProcFindBoxManEntry_flt( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int box, HYPRE_Int proc, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridBoxProcFindBoxManEntry_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int box, HYPRE_Int proc, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridBoxProcFindBoxManEntry_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int box, HYPRE_Int proc, hypre_BoxManEntry **entry_ptr );

HYPRE_Int
hypre_SStructGridCoarsen_flt( hypre_SStructGrid *fgrid, hypre_IndexRef origin, hypre_Index *strides, hypre_Index *periodic, hypre_SStructGrid **cgrid_ptr );
HYPRE_Int
hypre_SStructGridCoarsen_dbl( hypre_SStructGrid *fgrid, hypre_IndexRef origin, hypre_Index *strides, hypre_Index *periodic, hypre_SStructGrid **cgrid_ptr );
HYPRE_Int
hypre_SStructGridCoarsen_long_dbl( hypre_SStructGrid *fgrid, hypre_IndexRef origin, hypre_Index *strides, hypre_Index *periodic, hypre_SStructGrid **cgrid_ptr );

HYPRE_Int
hypre_SStructGridComputeGlobalSizes_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridComputeGlobalSizes_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridComputeGlobalSizes_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridCreateCommInfo_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridCreateCommInfo_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridCreateCommInfo_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridFindBoxManEntry_flt( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridFindBoxManEntry_dbl( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridFindBoxManEntry_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );

HYPRE_Int
hypre_SStructGridFindNborBoxManEntry_flt( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridFindNborBoxManEntry_dbl( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_SStructGridFindNborBoxManEntry_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, hypre_Index index, HYPRE_Int var, hypre_BoxManEntry **entry_ptr );

HYPRE_Int
hypre_SStructGridGetMaxBoxSize_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridGetMaxBoxSize_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridGetMaxBoxSize_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridIntersect_flt( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, hypre_Box *box, HYPRE_Int action, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );
HYPRE_Int
hypre_SStructGridIntersect_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, hypre_Box *box, HYPRE_Int action, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );
HYPRE_Int
hypre_SStructGridIntersect_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, hypre_Box *box, HYPRE_Int action, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );

HYPRE_Int
hypre_SStructGridPrint_flt( FILE *file, hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridPrint_dbl( FILE *file, hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridPrint_long_dbl( FILE *file, hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridPrintGLVis_flt( hypre_SStructGrid *grid, const char *meshprefix, hypre_float *trans, hypre_float *origin );
HYPRE_Int
hypre_SStructGridPrintGLVis_dbl( hypre_SStructGrid *grid, const char *meshprefix, hypre_double *trans, hypre_double *origin );
HYPRE_Int
hypre_SStructGridPrintGLVis_long_dbl( hypre_SStructGrid *grid, const char *meshprefix, hypre_long_double *trans, hypre_long_double *origin );

HYPRE_Int
hypre_SStructGridRead_flt( MPI_Comm comm, FILE *file, hypre_SStructGrid **grid_ptr );
HYPRE_Int
hypre_SStructGridRead_dbl( MPI_Comm comm, FILE *file, hypre_SStructGrid **grid_ptr );
HYPRE_Int
hypre_SStructGridRead_long_dbl( MPI_Comm comm, FILE *file, hypre_SStructGrid **grid_ptr );

HYPRE_Int
hypre_SStructGridRef_flt( hypre_SStructGrid *grid, hypre_SStructGrid **grid_ref );
HYPRE_Int
hypre_SStructGridRef_dbl( hypre_SStructGrid *grid, hypre_SStructGrid **grid_ref );
HYPRE_Int
hypre_SStructGridRef_long_dbl( hypre_SStructGrid *grid, hypre_SStructGrid **grid_ref );

HYPRE_Int
hypre_SStructGridSetActiveParts_flt( hypre_SStructGrid *grid, HYPRE_Int *active );
HYPRE_Int
hypre_SStructGridSetActiveParts_dbl( hypre_SStructGrid *grid, HYPRE_Int *active );
HYPRE_Int
hypre_SStructGridSetActiveParts_long_dbl( hypre_SStructGrid *grid, HYPRE_Int *active );

HYPRE_Int
hypre_SStructGridSetAllPartsActive_flt( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridSetAllPartsActive_dbl( hypre_SStructGrid *grid );
HYPRE_Int
hypre_SStructGridSetAllPartsActive_long_dbl( hypre_SStructGrid *grid );

HYPRE_Int
hypre_SStructGridSetNumGhost_flt( hypre_SStructGrid *grid, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_SStructGridSetNumGhost_dbl( hypre_SStructGrid *grid, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_SStructGridSetNumGhost_long_dbl( hypre_SStructGrid *grid, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_SStructIndexToNborIndex_flt( hypre_Index index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index nbor_index );
HYPRE_Int
hypre_SStructIndexToNborIndex_dbl( hypre_Index index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index nbor_index );
HYPRE_Int
hypre_SStructIndexToNborIndex_long_dbl( hypre_Index index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index nbor_index );

HYPRE_Int
hypre_SStructInnerProd_flt( hypre_SStructVector *x, hypre_SStructVector *y, hypre_float *result_ptr );
HYPRE_Int
hypre_SStructInnerProd_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_double *result_ptr );
HYPRE_Int
hypre_SStructInnerProd_long_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_long_double *result_ptr );

HYPRE_Int
hypre_SStructMatmat_flt( hypre_SStructMatrix *A, hypre_SStructMatrix *B, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmat_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *B, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmat_long_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *B, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatmult_flt( HYPRE_Int nmatrices, hypre_SStructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmult_dbl( HYPRE_Int nmatrices, hypre_SStructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmult_long_dbl( HYPRE_Int nmatrices, hypre_SStructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatmultCommunicate_flt( hypre_SStructMatmultData *mmdata );
HYPRE_Int
hypre_SStructMatmultCommunicate_dbl( hypre_SStructMatmultData *mmdata );
HYPRE_Int
hypre_SStructMatmultCommunicate_long_dbl( hypre_SStructMatmultData *mmdata );

HYPRE_Int
hypre_SStructMatmultCompute_flt( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultCompute_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultCompute_long_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );

HYPRE_Int
hypre_SStructMatmultComputeS_flt( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultComputeS_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultComputeS_long_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );

HYPRE_Int
hypre_SStructMatmultComputeU_flt( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultComputeU_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );
HYPRE_Int
hypre_SStructMatmultComputeU_long_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix *M );

HYPRE_Int
hypre_SStructMatmultCreate_flt( HYPRE_Int nmatrices_input, hypre_SStructMatrix **matrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructMatmultData **mmdata_ptr );
HYPRE_Int
hypre_SStructMatmultCreate_dbl( HYPRE_Int nmatrices_input, hypre_SStructMatrix **matrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructMatmultData **mmdata_ptr );
HYPRE_Int
hypre_SStructMatmultCreate_long_dbl( HYPRE_Int nmatrices_input, hypre_SStructMatrix **matrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructMatmultData **mmdata_ptr );

HYPRE_Int
hypre_SStructMatmultDestroy_flt( hypre_SStructMatmultData *mmdata );
HYPRE_Int
hypre_SStructMatmultDestroy_dbl( hypre_SStructMatmultData *mmdata );
HYPRE_Int
hypre_SStructMatmultDestroy_long_dbl( hypre_SStructMatmultData *mmdata );

HYPRE_Int
hypre_SStructMatmultInitialize_flt( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmultInitialize_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatmultInitialize_long_dbl( hypre_SStructMatmultData *mmdata, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatrixBoxesToUMatrix_flt( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, hypre_BoxArray ***convert_boxa );
HYPRE_Int
hypre_SStructMatrixBoxesToUMatrix_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, hypre_BoxArray ***convert_boxa );
HYPRE_Int
hypre_SStructMatrixBoxesToUMatrix_long_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, hypre_BoxArray ***convert_boxa );

HYPRE_Int
hypre_SStructMatrixCompressUToS_flt( HYPRE_SStructMatrix matrix, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixCompressUToS_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixCompressUToS_long_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int action );

HYPRE_Int
hypre_SStructMatrixComputeL1Norms_flt( hypre_SStructMatrix *A, HYPRE_Int option, hypre_SStructVector **l1_norms_ptr );
HYPRE_Int
hypre_SStructMatrixComputeL1Norms_dbl( hypre_SStructMatrix *A, HYPRE_Int option, hypre_SStructVector **l1_norms_ptr );
HYPRE_Int
hypre_SStructMatrixComputeL1Norms_long_dbl( hypre_SStructMatrix *A, HYPRE_Int option, hypre_SStructVector **l1_norms_ptr );

HYPRE_Int
hypre_SStructMatrixComputeRowSum_flt( hypre_SStructMatrix *A, HYPRE_Int type, hypre_SStructVector **rowsum_ptr );
HYPRE_Int
hypre_SStructMatrixComputeRowSum_dbl( hypre_SStructMatrix *A, HYPRE_Int type, hypre_SStructVector **rowsum_ptr );
HYPRE_Int
hypre_SStructMatrixComputeRowSum_long_dbl( hypre_SStructMatrix *A, HYPRE_Int type, hypre_SStructVector **rowsum_ptr );

HYPRE_Int
hypre_SStructMatrixGetDiagonal_flt( hypre_SStructMatrix *matrix, hypre_SStructVector **diag_ptr );
HYPRE_Int
hypre_SStructMatrixGetDiagonal_dbl( hypre_SStructMatrix *matrix, hypre_SStructVector **diag_ptr );
HYPRE_Int
hypre_SStructMatrixGetDiagonal_long_dbl( hypre_SStructMatrix *matrix, hypre_SStructVector **diag_ptr );

HYPRE_Int
hypre_SStructMatrixHaloToUMatrix_flt( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, HYPRE_Int halo_size );
HYPRE_Int
hypre_SStructMatrixHaloToUMatrix_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, HYPRE_Int halo_size );
HYPRE_Int
hypre_SStructMatrixHaloToUMatrix_long_dbl( hypre_SStructMatrix *A, hypre_SStructGrid *grid, hypre_IJMatrix **ij_Ahat_ptr, HYPRE_Int halo_size );

HYPRE_Int
hypre_SStructMatrixMapDataBox_flt( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int vi, HYPRE_Int vj, hypre_Box *map_vbox );
HYPRE_Int
hypre_SStructMatrixMapDataBox_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int vi, HYPRE_Int vj, hypre_Box *map_vbox );
HYPRE_Int
hypre_SStructMatrixMapDataBox_long_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int vi, HYPRE_Int vj, hypre_Box *map_vbox );

HYPRE_MemoryLocation
hypre_SStructMatrixMemoryLocation_flt( hypre_SStructMatrix *matrix );
HYPRE_MemoryLocation
hypre_SStructMatrixMemoryLocation_dbl( hypre_SStructMatrix *matrix );
HYPRE_MemoryLocation
hypre_SStructMatrixMemoryLocation_long_dbl( hypre_SStructMatrix *matrix );

HYPRE_Int
hypre_SStructMatrixPtAP_flt( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixPtAP_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixPtAP_long_dbl( hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatrixRAP_flt( hypre_SStructMatrix *R, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixRAP_dbl( hypre_SStructMatrix *R, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixRAP_long_dbl( hypre_SStructMatrix *R, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatrixRTtAP_flt( hypre_SStructMatrix *RT, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixRTtAP_dbl( hypre_SStructMatrix *RT, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );
HYPRE_Int
hypre_SStructMatrixRTtAP_long_dbl( hypre_SStructMatrix *RT, hypre_SStructMatrix *A, hypre_SStructMatrix *P, hypre_SStructMatrix **M_ptr );

HYPRE_Int
hypre_SStructMatrixRef_flt( hypre_SStructMatrix *matrix, hypre_SStructMatrix **matrix_ref );
HYPRE_Int
hypre_SStructMatrixRef_dbl( hypre_SStructMatrix *matrix, hypre_SStructMatrix **matrix_ref );
HYPRE_Int
hypre_SStructMatrixRef_long_dbl( hypre_SStructMatrix *matrix, hypre_SStructMatrix **matrix_ref );

HYPRE_Int
hypre_SStructMatrixSetBoxValues_flt( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetBoxValues_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetBoxValues_long_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructMatrixSetInterPartValues_flt( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetInterPartValues_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetInterPartValues_long_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructMatrixSetValues_flt( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetValues_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructMatrixSetValues_long_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int part, HYPRE_Int *index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructMatrixSplitEntries_flt( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *nSentries_ptr, HYPRE_Int **Sentries_ptr, HYPRE_Int *nUentries_ptr, HYPRE_Int **Uentries_ptr );
HYPRE_Int
hypre_SStructMatrixSplitEntries_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *nSentries_ptr, HYPRE_Int **Sentries_ptr, HYPRE_Int *nUentries_ptr, HYPRE_Int **Uentries_ptr );
HYPRE_Int
hypre_SStructMatrixSplitEntries_long_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, HYPRE_Int *nSentries_ptr, HYPRE_Int **Sentries_ptr, HYPRE_Int *nUentries_ptr, HYPRE_Int **Uentries_ptr );

hypre_IJMatrix*
hypre_SStructMatrixToUMatrix_flt( HYPRE_SStructMatrix matrix, HYPRE_Int fill_diagonal );
hypre_IJMatrix*
hypre_SStructMatrixToUMatrix_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int fill_diagonal );
hypre_IJMatrix*
hypre_SStructMatrixToUMatrix_long_dbl( HYPRE_SStructMatrix matrix, HYPRE_Int fill_diagonal );

HYPRE_Int
hypre_SStructMatvec_flt( hypre_float alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_float beta, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructMatvec_dbl( hypre_double alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_double beta, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructMatvec_long_dbl( hypre_long_double alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_long_double beta, hypre_SStructVector *y );

HYPRE_Int
hypre_SStructMatvecCompute_flt( void *matvec_vdata, hypre_float alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_float beta, hypre_SStructVector *b, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructMatvecCompute_dbl( void *matvec_vdata, hypre_double alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_double beta, hypre_SStructVector *b, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructMatvecCompute_long_dbl( void *matvec_vdata, hypre_long_double alpha, hypre_SStructMatrix *A, hypre_SStructVector *x, hypre_long_double beta, hypre_SStructVector *b, hypre_SStructVector *y );

HYPRE_Int
hypre_SStructMatvecCreate_flt( void **matvec_vdata_ptr );
HYPRE_Int
hypre_SStructMatvecCreate_dbl( void **matvec_vdata_ptr );
HYPRE_Int
hypre_SStructMatvecCreate_long_dbl( void **matvec_vdata_ptr );

HYPRE_Int
hypre_SStructMatvecDestroy_flt( void *matvec_vdata );
HYPRE_Int
hypre_SStructMatvecDestroy_dbl( void *matvec_vdata );
HYPRE_Int
hypre_SStructMatvecDestroy_long_dbl( void *matvec_vdata );

HYPRE_Int
hypre_SStructMatvecSetTranspose_flt( void *matvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_SStructMatvecSetTranspose_dbl( void *matvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_SStructMatvecSetTranspose_long_dbl( void *matvec_vdata, HYPRE_Int transpose );

HYPRE_Int
hypre_SStructMatvecSetup_flt( void *matvec_vdata, hypre_SStructMatrix *A, hypre_SStructVector *x );
HYPRE_Int
hypre_SStructMatvecSetup_dbl( void *matvec_vdata, hypre_SStructMatrix *A, hypre_SStructVector *x );
HYPRE_Int
hypre_SStructMatvecSetup_long_dbl( void *matvec_vdata, hypre_SStructMatrix *A, hypre_SStructVector *x );

HYPRE_Int
hypre_SStructNborBoxToBox_flt( hypre_Box *nbor_box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );
HYPRE_Int
hypre_SStructNborBoxToBox_dbl( hypre_Box *nbor_box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );
HYPRE_Int
hypre_SStructNborBoxToBox_long_dbl( hypre_Box *nbor_box, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir );

HYPRE_Int
hypre_SStructNborIndexToIndex_flt( hypre_Index nbor_index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_SStructNborIndexToIndex_dbl( hypre_Index nbor_index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_SStructNborIndexToIndex_long_dbl( hypre_Index nbor_index, hypre_Index root, hypre_Index nbor_root, hypre_Index coord, hypre_Index dir, HYPRE_Int ndim, hypre_Index index );

HYPRE_Int
hypre_SStructPAxpy_flt( hypre_float alpha, hypre_SStructPVector *px, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPAxpy_dbl( hypre_double alpha, hypre_SStructPVector *px, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPAxpy_long_dbl( hypre_long_double alpha, hypre_SStructPVector *px, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPCopy_flt( hypre_SStructPVector *px, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPCopy_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPCopy_long_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPGridAssemble_flt( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridAssemble_dbl( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridAssemble_long_dbl( hypre_SStructPGrid *pgrid );

HYPRE_Int
hypre_SStructPGridCreate_flt( MPI_Comm comm, HYPRE_Int ndim, hypre_SStructPGrid **pgrid_ptr );
HYPRE_Int
hypre_SStructPGridCreate_dbl( MPI_Comm comm, HYPRE_Int ndim, hypre_SStructPGrid **pgrid_ptr );
HYPRE_Int
hypre_SStructPGridCreate_long_dbl( MPI_Comm comm, HYPRE_Int ndim, hypre_SStructPGrid **pgrid_ptr );

HYPRE_Int
hypre_SStructPGridDestroy_flt( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridDestroy_dbl( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridDestroy_long_dbl( hypre_SStructPGrid *pgrid );

HYPRE_Int
hypre_SStructPGridGetMaxBoxSize_flt( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridGetMaxBoxSize_dbl( hypre_SStructPGrid *pgrid );
HYPRE_Int
hypre_SStructPGridGetMaxBoxSize_long_dbl( hypre_SStructPGrid *pgrid );

HYPRE_Int
hypre_SStructPGridRef_flt( hypre_SStructPGrid *pgrid, hypre_SStructPGrid **pgrid_ref );
HYPRE_Int
hypre_SStructPGridRef_dbl( hypre_SStructPGrid *pgrid, hypre_SStructPGrid **pgrid_ref );
HYPRE_Int
hypre_SStructPGridRef_long_dbl( hypre_SStructPGrid *pgrid, hypre_SStructPGrid **pgrid_ref );

HYPRE_Int
hypre_SStructPGridSetCellSGrid_flt( hypre_SStructPGrid *pgrid, hypre_StructGrid *cell_sgrid );
HYPRE_Int
hypre_SStructPGridSetCellSGrid_dbl( hypre_SStructPGrid *pgrid, hypre_StructGrid *cell_sgrid );
HYPRE_Int
hypre_SStructPGridSetCellSGrid_long_dbl( hypre_SStructPGrid *pgrid, hypre_StructGrid *cell_sgrid );

HYPRE_Int
hypre_SStructPGridSetExtents_flt( hypre_SStructPGrid *pgrid, hypre_Index ilower, hypre_Index iupper );
HYPRE_Int
hypre_SStructPGridSetExtents_dbl( hypre_SStructPGrid *pgrid, hypre_Index ilower, hypre_Index iupper );
HYPRE_Int
hypre_SStructPGridSetExtents_long_dbl( hypre_SStructPGrid *pgrid, hypre_Index ilower, hypre_Index iupper );

HYPRE_Int
hypre_SStructPGridSetPNeighbor_flt( hypre_SStructPGrid *pgrid, hypre_Box *pneighbor_box, hypre_Index pnbor_offset );
HYPRE_Int
hypre_SStructPGridSetPNeighbor_dbl( hypre_SStructPGrid *pgrid, hypre_Box *pneighbor_box, hypre_Index pnbor_offset );
HYPRE_Int
hypre_SStructPGridSetPNeighbor_long_dbl( hypre_SStructPGrid *pgrid, hypre_Box *pneighbor_box, hypre_Index pnbor_offset );

HYPRE_Int
hypre_SStructPGridSetSGrid_flt( hypre_StructGrid *sgrid, hypre_SStructPGrid *pgrid, HYPRE_Int var );
HYPRE_Int
hypre_SStructPGridSetSGrid_dbl( hypre_StructGrid *sgrid, hypre_SStructPGrid *pgrid, HYPRE_Int var );
HYPRE_Int
hypre_SStructPGridSetSGrid_long_dbl( hypre_StructGrid *sgrid, hypre_SStructPGrid *pgrid, HYPRE_Int var );

HYPRE_Int
hypre_SStructPGridSetVariables_flt( hypre_SStructPGrid *pgrid, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes );
HYPRE_Int
hypre_SStructPGridSetVariables_dbl( hypre_SStructPGrid *pgrid, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes );
HYPRE_Int
hypre_SStructPGridSetVariables_long_dbl( hypre_SStructPGrid *pgrid, HYPRE_Int nvars, HYPRE_SStructVariable *vartypes );

HYPRE_Int
hypre_SStructPInnerProd_flt( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_float *presult_ptr );
HYPRE_Int
hypre_SStructPInnerProd_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_double *presult_ptr );
HYPRE_Int
hypre_SStructPInnerProd_long_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_long_double *presult_ptr );

HYPRE_Int
hypre_SStructPInnerProdLocal_flt( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_float *presult_ptr );
HYPRE_Int
hypre_SStructPInnerProdLocal_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_double *presult_ptr );
HYPRE_Int
hypre_SStructPInnerProdLocal_long_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_long_double *presult_ptr );

HYPRE_Int
hypre_SStructPMatmat_flt( hypre_SStructPMatrix *A, hypre_SStructPMatrix *B, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatmat_dbl( hypre_SStructPMatrix *A, hypre_SStructPMatrix *B, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatmat_long_dbl( hypre_SStructPMatrix *A, hypre_SStructPMatrix *B, hypre_SStructPMatrix **M_ptr );

HYPRE_Int
hypre_SStructPMatmult_flt( HYPRE_Int nmatrices, hypre_SStructPMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatmult_dbl( HYPRE_Int nmatrices, hypre_SStructPMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatmult_long_dbl( HYPRE_Int nmatrices, hypre_SStructPMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_SStructPMatrix **M_ptr );

HYPRE_Int
hypre_SStructPMatmultCommSetup_flt( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultCommSetup_dbl( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultCommSetup_long_dbl( hypre_SStructPMatmultData *pmmdata );

HYPRE_Int
hypre_SStructPMatmultCommunicate_flt( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultCommunicate_dbl( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultCommunicate_long_dbl( hypre_SStructPMatmultData *pmmdata );

HYPRE_Int
hypre_SStructPMatmultCompute_flt( hypre_SStructPMatmultData *pmmdata, hypre_SStructPMatrix *pM );
HYPRE_Int
hypre_SStructPMatmultCompute_dbl( hypre_SStructPMatmultData *pmmdata, hypre_SStructPMatrix *pM );
HYPRE_Int
hypre_SStructPMatmultCompute_long_dbl( hypre_SStructPMatmultData *pmmdata, hypre_SStructPMatrix *pM );

HYPRE_Int
hypre_SStructPMatmultCreate_flt( HYPRE_Int nmatrices_input, hypre_SStructPMatrix **pmatrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructPMatmultData **pmmdata_ptr );
HYPRE_Int
hypre_SStructPMatmultCreate_dbl( HYPRE_Int nmatrices_input, hypre_SStructPMatrix **pmatrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructPMatmultData **pmmdata_ptr );
HYPRE_Int
hypre_SStructPMatmultCreate_long_dbl( HYPRE_Int nmatrices_input, hypre_SStructPMatrix **pmatrices_input, HYPRE_Int nterms, HYPRE_Int *terms_input, HYPRE_Int *trans_input, hypre_SStructPMatmultData **pmmdata_ptr );

HYPRE_Int
hypre_SStructPMatmultDestroy_flt( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultDestroy_dbl( hypre_SStructPMatmultData *pmmdata );
HYPRE_Int
hypre_SStructPMatmultDestroy_long_dbl( hypre_SStructPMatmultData *pmmdata );

HYPRE_Int
hypre_SStructPMatmultInitialize_flt( hypre_SStructPMatmultData *pmmdata, HYPRE_Int assemble_grid, hypre_SStructPMatrix **pM_ptr );
HYPRE_Int
hypre_SStructPMatmultInitialize_dbl( hypre_SStructPMatmultData *pmmdata, HYPRE_Int assemble_grid, hypre_SStructPMatrix **pM_ptr );
HYPRE_Int
hypre_SStructPMatmultInitialize_long_dbl( hypre_SStructPMatmultData *pmmdata, HYPRE_Int assemble_grid, hypre_SStructPMatrix **pM_ptr );

HYPRE_Int
hypre_SStructPMatrixAccumulate_flt( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixAccumulate_dbl( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixAccumulate_long_dbl( hypre_SStructPMatrix *pmatrix );

HYPRE_Int
hypre_SStructPMatrixAssemble_flt( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixAssemble_dbl( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixAssemble_long_dbl( hypre_SStructPMatrix *pmatrix );

HYPRE_Int
hypre_SStructPMatrixComputeRowSum_flt( hypre_SStructPMatrix *pA, HYPRE_Int type, hypre_SStructPVector *prowsum );
HYPRE_Int
hypre_SStructPMatrixComputeRowSum_dbl( hypre_SStructPMatrix *pA, HYPRE_Int type, hypre_SStructPVector *prowsum );
HYPRE_Int
hypre_SStructPMatrixComputeRowSum_long_dbl( hypre_SStructPMatrix *pA, HYPRE_Int type, hypre_SStructPVector *prowsum );

HYPRE_Int
hypre_SStructPMatrixCreate_flt( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructStencil **stencils, hypre_SStructPMatrix **pmatrix_ptr );
HYPRE_Int
hypre_SStructPMatrixCreate_dbl( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructStencil **stencils, hypre_SStructPMatrix **pmatrix_ptr );
HYPRE_Int
hypre_SStructPMatrixCreate_long_dbl( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructStencil **stencils, hypre_SStructPMatrix **pmatrix_ptr );

HYPRE_Int
hypre_SStructPMatrixDestroy_flt( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixDestroy_dbl( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixDestroy_long_dbl( hypre_SStructPMatrix *pmatrix );

HYPRE_Int
hypre_SStructPMatrixGetDiagonal_flt( hypre_SStructPMatrix *pmatrix, hypre_SStructPVector *pdiag );
HYPRE_Int
hypre_SStructPMatrixGetDiagonal_dbl( hypre_SStructPMatrix *pmatrix, hypre_SStructPVector *pdiag );
HYPRE_Int
hypre_SStructPMatrixGetDiagonal_long_dbl( hypre_SStructPMatrix *pmatrix, hypre_SStructPVector *pdiag );

HYPRE_Int
hypre_SStructPMatrixInitialize_flt( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixInitialize_dbl( hypre_SStructPMatrix *pmatrix );
HYPRE_Int
hypre_SStructPMatrixInitialize_long_dbl( hypre_SStructPMatrix *pmatrix );

HYPRE_Int
hypre_SStructPMatrixPrint_flt( const char *filename, hypre_SStructPMatrix *pmatrix, HYPRE_Int all );
HYPRE_Int
hypre_SStructPMatrixPrint_dbl( const char *filename, hypre_SStructPMatrix *pmatrix, HYPRE_Int all );
HYPRE_Int
hypre_SStructPMatrixPrint_long_dbl( const char *filename, hypre_SStructPMatrix *pmatrix, HYPRE_Int all );

HYPRE_Int
hypre_SStructPMatrixPtAP_flt( hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixPtAP_dbl( hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixPtAP_long_dbl( hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );

HYPRE_Int
hypre_SStructPMatrixRAP_flt( hypre_SStructPMatrix *R, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixRAP_dbl( hypre_SStructPMatrix *R, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixRAP_long_dbl( hypre_SStructPMatrix *R, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );

HYPRE_Int
hypre_SStructPMatrixRTtAP_flt( hypre_SStructPMatrix *RT, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixRTtAP_dbl( hypre_SStructPMatrix *RT, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );
HYPRE_Int
hypre_SStructPMatrixRTtAP_long_dbl( hypre_SStructPMatrix *RT, hypre_SStructPMatrix *A, hypre_SStructPMatrix *P, hypre_SStructPMatrix **M_ptr );

HYPRE_Int
hypre_SStructPMatrixRef_flt( hypre_SStructPMatrix *matrix, hypre_SStructPMatrix **matrix_ref );
HYPRE_Int
hypre_SStructPMatrixRef_dbl( hypre_SStructPMatrix *matrix, hypre_SStructPMatrix **matrix_ref );
HYPRE_Int
hypre_SStructPMatrixRef_long_dbl( hypre_SStructPMatrix *matrix, hypre_SStructPMatrix **matrix_ref );

HYPRE_Int
hypre_SStructPMatrixSetBoxValues_flt( hypre_SStructPMatrix *pmatrix, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPMatrixSetBoxValues_dbl( hypre_SStructPMatrix *pmatrix, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPMatrixSetBoxValues_long_dbl( hypre_SStructPMatrix *pmatrix, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructPMatrixSetCEntries_flt( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int num_centries, HYPRE_Int *centries );
HYPRE_Int
hypre_SStructPMatrixSetCEntries_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int num_centries, HYPRE_Int *centries );
HYPRE_Int
hypre_SStructPMatrixSetCEntries_long_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int num_centries, HYPRE_Int *centries );

HYPRE_Int
hypre_SStructPMatrixSetDomainStride_flt( hypre_SStructPMatrix *pmatrix, hypre_Index dom_stride );
HYPRE_Int
hypre_SStructPMatrixSetDomainStride_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index dom_stride );
HYPRE_Int
hypre_SStructPMatrixSetDomainStride_long_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index dom_stride );

HYPRE_Int
hypre_SStructPMatrixSetRangeStride_flt( hypre_SStructPMatrix *pmatrix, hypre_Index ran_stride );
HYPRE_Int
hypre_SStructPMatrixSetRangeStride_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index ran_stride );
HYPRE_Int
hypre_SStructPMatrixSetRangeStride_long_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index ran_stride );

HYPRE_Int
hypre_SStructPMatrixSetSymmetric_flt( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int symmetric );
HYPRE_Int
hypre_SStructPMatrixSetSymmetric_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int symmetric );
HYPRE_Int
hypre_SStructPMatrixSetSymmetric_long_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int var, HYPRE_Int to_var, HYPRE_Int symmetric );

HYPRE_Int
hypre_SStructPMatrixSetTranspose_flt( hypre_SStructPMatrix *pmatrix, HYPRE_Int transpose, HYPRE_Int *resize );
HYPRE_Int
hypre_SStructPMatrixSetTranspose_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int transpose, HYPRE_Int *resize );
HYPRE_Int
hypre_SStructPMatrixSetTranspose_long_dbl( hypre_SStructPMatrix *pmatrix, HYPRE_Int transpose, HYPRE_Int *resize );

HYPRE_Int
hypre_SStructPMatrixSetValues_flt( hypre_SStructPMatrix *pmatrix, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPMatrixSetValues_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPMatrixSetValues_long_dbl( hypre_SStructPMatrix *pmatrix, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructPMatvec_flt( hypre_float alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_float beta, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPMatvec_dbl( hypre_double alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_double beta, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPMatvec_long_dbl( hypre_long_double alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_long_double beta, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPMatvecCompute_flt( void *pmatvec_vdata, hypre_float alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_float beta, hypre_SStructPVector *pb, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPMatvecCompute_dbl( void *pmatvec_vdata, hypre_double alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_double beta, hypre_SStructPVector *pb, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPMatvecCompute_long_dbl( void *pmatvec_vdata, hypre_long_double alpha, hypre_SStructPMatrix *pA, hypre_SStructPVector *px, hypre_long_double beta, hypre_SStructPVector *pb, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPMatvecCreate_flt( void **pmatvec_vdata_ptr );
HYPRE_Int
hypre_SStructPMatvecCreate_dbl( void **pmatvec_vdata_ptr );
HYPRE_Int
hypre_SStructPMatvecCreate_long_dbl( void **pmatvec_vdata_ptr );

HYPRE_Int
hypre_SStructPMatvecDestroy_flt( void *pmatvec_vdata );
HYPRE_Int
hypre_SStructPMatvecDestroy_dbl( void *pmatvec_vdata );
HYPRE_Int
hypre_SStructPMatvecDestroy_long_dbl( void *pmatvec_vdata );

HYPRE_Int
hypre_SStructPMatvecSetTranspose_flt( void *pmatvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_SStructPMatvecSetTranspose_dbl( void *pmatvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_SStructPMatvecSetTranspose_long_dbl( void *pmatvec_vdata, HYPRE_Int transpose );

HYPRE_Int
hypre_SStructPMatvecSetup_flt( void *pmatvec_vdata, hypre_SStructPMatrix *pA, hypre_SStructPVector *px );
HYPRE_Int
hypre_SStructPMatvecSetup_dbl( void *pmatvec_vdata, hypre_SStructPMatrix *pA, hypre_SStructPVector *px );
HYPRE_Int
hypre_SStructPMatvecSetup_long_dbl( void *pmatvec_vdata, hypre_SStructPMatrix *pA, hypre_SStructPVector *px );

HYPRE_Int
hypre_SStructPScale_flt( hypre_float alpha, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPScale_dbl( hypre_double alpha, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPScale_long_dbl( hypre_long_double alpha, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPVectorAccumulate_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorAccumulate_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorAccumulate_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorAssemble_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorAssemble_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorAssemble_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorCreate_flt( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructPVector **pvector_ptr );
HYPRE_Int
hypre_SStructPVectorCreate_dbl( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructPVector **pvector_ptr );
HYPRE_Int
hypre_SStructPVectorCreate_long_dbl( MPI_Comm comm, hypre_SStructPGrid *pgrid, hypre_SStructPVector **pvector_ptr );

HYPRE_Int
hypre_SStructPVectorDestroy_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorDestroy_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorDestroy_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorGather_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorGather_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorGather_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorGetBoxValues_flt( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_float *values );
HYPRE_Int
hypre_SStructPVectorGetBoxValues_dbl( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_double *values );
HYPRE_Int
hypre_SStructPVectorGetBoxValues_long_dbl( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_long_double *values );

HYPRE_Int
hypre_SStructPVectorGetValues_flt( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_float *value );
HYPRE_Int
hypre_SStructPVectorGetValues_dbl( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_double *value );
HYPRE_Int
hypre_SStructPVectorGetValues_long_dbl( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_long_double *value );

HYPRE_Int
hypre_SStructPVectorInitialize_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorInitialize_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorInitialize_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorInitializeShell_flt( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorInitializeShell_dbl( hypre_SStructPVector *pvector );
HYPRE_Int
hypre_SStructPVectorInitializeShell_long_dbl( hypre_SStructPVector *pvector );

HYPRE_Int
hypre_SStructPVectorPointwiseDivpy_flt( hypre_float alpha, hypre_SStructPVector *px, hypre_SStructPVector *pz, hypre_float beta, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPVectorPointwiseDivpy_dbl( hypre_double alpha, hypre_SStructPVector *px, hypre_SStructPVector *pz, hypre_double beta, hypre_SStructPVector *py );
HYPRE_Int
hypre_SStructPVectorPointwiseDivpy_long_dbl( hypre_long_double alpha, hypre_SStructPVector *px, hypre_SStructPVector *pz, hypre_long_double beta, hypre_SStructPVector *py );

HYPRE_Int
hypre_SStructPVectorPrint_flt( const char *filename, hypre_SStructPVector *pvector, HYPRE_Int all );
HYPRE_Int
hypre_SStructPVectorPrint_dbl( const char *filename, hypre_SStructPVector *pvector, HYPRE_Int all );
HYPRE_Int
hypre_SStructPVectorPrint_long_dbl( const char *filename, hypre_SStructPVector *pvector, HYPRE_Int all );

HYPRE_Int
hypre_SStructPVectorRef_flt( hypre_SStructPVector *vector, hypre_SStructPVector **vector_ref );
HYPRE_Int
hypre_SStructPVectorRef_dbl( hypre_SStructPVector *vector, hypre_SStructPVector **vector_ref );
HYPRE_Int
hypre_SStructPVectorRef_long_dbl( hypre_SStructPVector *vector, hypre_SStructPVector **vector_ref );

HYPRE_Int
hypre_SStructPVectorSetBoxValues_flt( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPVectorSetBoxValues_dbl( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructPVectorSetBoxValues_long_dbl( hypre_SStructPVector *pvector, hypre_Box *set_box, HYPRE_Int var, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructPVectorSetConstantValues_flt( hypre_SStructPVector *pvector, hypre_float value );
HYPRE_Int
hypre_SStructPVectorSetConstantValues_dbl( hypre_SStructPVector *pvector, hypre_double value );
HYPRE_Int
hypre_SStructPVectorSetConstantValues_long_dbl( hypre_SStructPVector *pvector, hypre_long_double value );

HYPRE_Int
hypre_SStructPVectorSetRandomValues_flt( hypre_SStructPVector *pvector, HYPRE_Int seed );
HYPRE_Int
hypre_SStructPVectorSetRandomValues_dbl( hypre_SStructPVector *pvector, HYPRE_Int seed );
HYPRE_Int
hypre_SStructPVectorSetRandomValues_long_dbl( hypre_SStructPVector *pvector, HYPRE_Int seed );

HYPRE_Int
hypre_SStructPVectorSetValues_flt( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_float *value, HYPRE_Int action );
HYPRE_Int
hypre_SStructPVectorSetValues_dbl( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_double *value, HYPRE_Int action );
HYPRE_Int
hypre_SStructPVectorSetValues_long_dbl( hypre_SStructPVector *pvector, hypre_Index index, HYPRE_Int var, hypre_long_double *value, HYPRE_Int action );

HYPRE_Int
hypre_SStructPartialPCopy_flt( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_BoxArrayArray **array_boxes );
HYPRE_Int
hypre_SStructPartialPCopy_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_BoxArrayArray **array_boxes );
HYPRE_Int
hypre_SStructPartialPCopy_long_dbl( hypre_SStructPVector *px, hypre_SStructPVector *py, hypre_BoxArrayArray **array_boxes );

HYPRE_Int
hypre_SStructScale_flt( hypre_float alpha, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructScale_dbl( hypre_double alpha, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructScale_long_dbl( hypre_long_double alpha, hypre_SStructVector *y );

HYPRE_Int
hypre_SStructStencilRef_flt( hypre_SStructStencil *stencil, hypre_SStructStencil **stencil_ref );
HYPRE_Int
hypre_SStructStencilRef_dbl( hypre_SStructStencil *stencil, hypre_SStructStencil **stencil_ref );
HYPRE_Int
hypre_SStructStencilRef_long_dbl( hypre_SStructStencil *stencil, hypre_SStructStencil **stencil_ref );

HYPRE_Int
hypre_SStructUMatrixAssemble_flt( hypre_SStructMatrix *matrix );
HYPRE_Int
hypre_SStructUMatrixAssemble_dbl( hypre_SStructMatrix *matrix );
HYPRE_Int
hypre_SStructUMatrixAssemble_long_dbl( hypre_SStructMatrix *matrix );

HYPRE_Int
hypre_SStructUMatrixInitialize_flt( hypre_SStructMatrix *matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SStructUMatrixInitialize_dbl( hypre_SStructMatrix *matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_SStructUMatrixInitialize_long_dbl( hypre_SStructMatrix *matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_SStructUMatrixSetBoxValues_flt( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructUMatrixSetBoxValues_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructUMatrixSetBoxValues_long_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructUMatrixSetBoxValuesHelper_flt( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_float *values, HYPRE_Int action, HYPRE_IJMatrix ijmatrix );
HYPRE_Int
hypre_SStructUMatrixSetBoxValuesHelper_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_double *values, HYPRE_Int action, HYPRE_IJMatrix ijmatrix );
HYPRE_Int
hypre_SStructUMatrixSetBoxValuesHelper_long_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Box *set_box, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action, HYPRE_IJMatrix ijmatrix );

HYPRE_Int
hypre_SStructUMatrixSetValues_flt( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructUMatrixSetValues_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_SStructUMatrixSetValues_long_dbl( hypre_SStructMatrix *matrix, HYPRE_Int part, hypre_Index index, HYPRE_Int var, HYPRE_Int nentries, HYPRE_Int *entries, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_SStructVarToNborVar_flt( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int *coord, HYPRE_Int *nbor_var_ptr );
HYPRE_Int
hypre_SStructVarToNborVar_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int *coord, HYPRE_Int *nbor_var_ptr );
HYPRE_Int
hypre_SStructVarToNborVar_long_dbl( hypre_SStructGrid *grid, HYPRE_Int part, HYPRE_Int var, HYPRE_Int *coord, HYPRE_Int *nbor_var_ptr );

HYPRE_Int
hypre_SStructVariableGetOffset_flt( HYPRE_SStructVariable vartype, HYPRE_Int ndim, hypre_Index varoffset );
HYPRE_Int
hypre_SStructVariableGetOffset_dbl( HYPRE_SStructVariable vartype, HYPRE_Int ndim, hypre_Index varoffset );
HYPRE_Int
hypre_SStructVariableGetOffset_long_dbl( HYPRE_SStructVariable vartype, HYPRE_Int ndim, hypre_Index varoffset );

HYPRE_Int
hypre_SStructVectorClearGhostValues_flt( hypre_SStructVector *vector );
HYPRE_Int
hypre_SStructVectorClearGhostValues_dbl( hypre_SStructVector *vector );
HYPRE_Int
hypre_SStructVectorClearGhostValues_long_dbl( hypre_SStructVector *vector );

HYPRE_Int
hypre_SStructVectorConvert_flt( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );
HYPRE_Int
hypre_SStructVectorConvert_dbl( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );
HYPRE_Int
hypre_SStructVectorConvert_long_dbl( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );

HYPRE_Int
hypre_SStructVectorInitializeShell_flt( hypre_SStructVector *vector );
HYPRE_Int
hypre_SStructVectorInitializeShell_dbl( hypre_SStructVector *vector );
HYPRE_Int
hypre_SStructVectorInitializeShell_long_dbl( hypre_SStructVector *vector );

HYPRE_MemoryLocation
hypre_SStructVectorMemoryLocation_flt( hypre_SStructVector *vector );
HYPRE_MemoryLocation
hypre_SStructVectorMemoryLocation_dbl( hypre_SStructVector *vector );
HYPRE_MemoryLocation
hypre_SStructVectorMemoryLocation_long_dbl( hypre_SStructVector *vector );

HYPRE_Int
hypre_SStructVectorParConvert_flt( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );
HYPRE_Int
hypre_SStructVectorParConvert_dbl( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );
HYPRE_Int
hypre_SStructVectorParConvert_long_dbl( hypre_SStructVector *vector, hypre_ParVector **parvector_ptr );

HYPRE_Int
hypre_SStructVectorParRestore_flt( hypre_SStructVector *vector, hypre_ParVector *parvector );
HYPRE_Int
hypre_SStructVectorParRestore_dbl( hypre_SStructVector *vector, hypre_ParVector *parvector );
HYPRE_Int
hypre_SStructVectorParRestore_long_dbl( hypre_SStructVector *vector, hypre_ParVector *parvector );

HYPRE_Int
hypre_SStructVectorPointwiseDivision_flt( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseDivision_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseDivision_long_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );

HYPRE_Int
hypre_SStructVectorPointwiseDivpy_flt( hypre_float *alpha, hypre_SStructVector *x, hypre_SStructVector *z, hypre_float *beta, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructVectorPointwiseDivpy_dbl( hypre_double *alpha, hypre_SStructVector *x, hypre_SStructVector *z, hypre_double *beta, hypre_SStructVector *y );
HYPRE_Int
hypre_SStructVectorPointwiseDivpy_long_dbl( hypre_long_double *alpha, hypre_SStructVector *x, hypre_SStructVector *z, hypre_long_double *beta, hypre_SStructVector *y );

HYPRE_Int
hypre_SStructVectorPointwiseInverse_flt( hypre_SStructVector *x, hypre_SStructVector **y_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseInverse_dbl( hypre_SStructVector *x, hypre_SStructVector **y_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseInverse_long_dbl( hypre_SStructVector *x, hypre_SStructVector **y_ptr );

HYPRE_Int
hypre_SStructVectorPointwiseProduct_flt( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseProduct_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );
HYPRE_Int
hypre_SStructVectorPointwiseProduct_long_dbl( hypre_SStructVector *x, hypre_SStructVector *y, hypre_SStructVector **z_ptr );

HYPRE_Int
hypre_SStructVectorPrintGLVis_flt( hypre_SStructVector *vector, const char *fileprefix );
HYPRE_Int
hypre_SStructVectorPrintGLVis_dbl( hypre_SStructVector *vector, const char *fileprefix );
HYPRE_Int
hypre_SStructVectorPrintGLVis_long_dbl( hypre_SStructVector *vector, const char *fileprefix );

HYPRE_Int
hypre_SStructVectorRef_flt( hypre_SStructVector *vector, hypre_SStructVector **vector_ref );
HYPRE_Int
hypre_SStructVectorRef_dbl( hypre_SStructVector *vector, hypre_SStructVector **vector_ref );
HYPRE_Int
hypre_SStructVectorRef_long_dbl( hypre_SStructVector *vector, hypre_SStructVector **vector_ref );

HYPRE_Int
hypre_SStructVectorRestore_flt( hypre_SStructVector *vector, hypre_ParVector *parvector );
HYPRE_Int
hypre_SStructVectorRestore_dbl( hypre_SStructVector *vector, hypre_ParVector *parvector );
HYPRE_Int
hypre_SStructVectorRestore_long_dbl( hypre_SStructVector *vector, hypre_ParVector *parvector );

HYPRE_Int
hypre_SStructVectorSetConstantValues_flt( hypre_SStructVector *vector, hypre_float value );
HYPRE_Int
hypre_SStructVectorSetConstantValues_dbl( hypre_SStructVector *vector, hypre_double value );
HYPRE_Int
hypre_SStructVectorSetConstantValues_long_dbl( hypre_SStructVector *vector, hypre_long_double value );

HYPRE_Int
hypre_SStructVectorSetRandomValues_flt( hypre_SStructVector *vector, HYPRE_Int seed );
HYPRE_Int
hypre_SStructVectorSetRandomValues_dbl( hypre_SStructVector *vector, HYPRE_Int seed );
HYPRE_Int
hypre_SStructVectorSetRandomValues_long_dbl( hypre_SStructVector *vector, HYPRE_Int seed );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

