#! /bin/sh
### BEGIN INIT INFO
# Provides:          pagekite
# Required-Start:    $remote_fs $syslog $named
# Required-Stop:     $remote_fs $syslog $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: PageKite system service
# Description:       PageKite makes localhost servers publicly visible.
### END INIT INFO

# Authors: Bjarni R. Einarsson <bre@pagekite.net>
#          Hrafnkell Eiriksson <he@klaki.net>

# Do NOT "set -e"

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/sbin:/usr/sbin:/bin:/usr/bin
DESC="PageKite system service"
NAME=pagekite
RUNAS=daemon:daemon
DAEMON=/usr/bin/$NAME
WRAPPER=/usr/bin/daemon
PIDFILE=/var/run/$NAME.pid
LOGFILE=/var/log/$NAME/$NAME.log
WRAPPER_PIDFILE=$PIDFILE.wrapper
WRAPPER_ARGS="--noconfig --unsafe --respawn --delay=60 --name=$NAME"
DAEMON_ARGS="--clean \
             --runas=$RUNAS \
             --logfile=$LOGFILE \
             --optdir=/etc/$NAME.d"
SCRIPTNAME=/etc/init.d/$NAME

# Exit if the package is not installed
[ -x "$DAEMON" ] || exit 0

# Exit if package is unconfigured
grep -c ^abort_not_configured /etc/pagekite.d/10_account.rc \
  2>/dev/null >/dev/null && exit 0

# Read configuration variable file if it is present
[ -r /etc/default/$NAME ] && . /etc/default/$NAME

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
        touch $LOGFILE
        chown $RUNAS $(dirname $LOGFILE) $LOGFILE
        if [ -x $WRAPPER ]; then
	  start-stop-daemon --quiet --pidfile $WRAPPER_PIDFILE --test --start \
                            --startas $WRAPPER  > /dev/null \
	  	|| return 1
	  start-stop-daemon \
            --quiet --pidfile $WRAPPER_PIDFILE --start --startas $WRAPPER -- \
                    --pidfile $WRAPPER_PIDFILE $WRAPPER_ARGS -- $DAEMON \
                    --pidfile $PIDFILE $DAEMON_ARGS --noloop \
		|| return 2
        else
	  start-stop-daemon --quiet --pidfile $PIDFILE --test --start \
                            --startas $DAEMON  > /dev/null \
	  	|| return 1
	  start-stop-daemon \
            --quiet --pidfile $PIDFILE --start --startas $DAEMON -- \
                    --pidfile $PIDFILE --daemonize $DAEMON_ARGS \
		|| return 2
        fi
	# Add code here, if necessary, that waits for the process to be ready
	# to handle requests from services started subsequently which depend
	# on this one.  As a last resort, sleep for some time.
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
        if [ -e $WRAPPER_PIDFILE ]; then
	  start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 \
                            --pidfile $WRAPPER_PIDFILE
        else
          WRAPPERS=$(ps axw |grep $WRAPPER |grep $DAEMON \
                            |grep $LOGFILE |cut -b1-5)
          if [ "$WRAPPERS" = "" ]; then
	    start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 \
                              --pidfile $PIDFILE
          else
            kill $WRAPPERS
	    start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 \
                              --pidfile $PIDFILE --oknodo
          fi
        fi
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2

	# Many daemons don't delete their pidfiles when they exit.
	rm -f $PIDFILE $WRAPPER_PIDFILE
	return "$RETVAL"
}

case "$1" in
  start)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC" "$NAME"
	do_start
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  stop)
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
		2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
  status)
       status_of_proc "$DAEMON" "$NAME" && exit 0 || exit $?
       ;;
  #reload|force-reload)
	#
	# If do_reload() is not implemented then leave this commented out
	# and leave 'force-reload' as an alias for 'restart'.
	#
	#log_daemon_msg "Reloading $DESC" "$NAME"
	#do_reload
	#log_end_msg $?
	#;;
  restart|force-reload)
	#
	# If the "reload" option is implemented then remove the
	# 'force-reload' alias
	#
	log_daemon_msg "Restarting $DESC" "$NAME"
	(do_stop
	case "$?" in
	  0|1)
		do_start
		case "$?" in
			0) log_end_msg 0 ;;
			1) log_end_msg 1 ;; # Old process is still running
			*) log_end_msg 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		log_end_msg 1
		;;
	esac) &
	;;
  *)
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

:
