/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.image;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.ScaleFilter;

public class AreaAveragingScaleFilter
implements ScaleFilter {
    private NIOBufferImage srcImage;
    private int srcWidth;
    private int srcHeight;
    private int srcComponents;
    private float[] red;
    private float[] green;
    private float[] blue;
    private float[] alpha;
    private float srcMult;

    public AreaAveragingScaleFilter(NIOBufferImage nIOBufferImage) {
        this.srcImage = nIOBufferImage;
        this.srcWidth = nIOBufferImage.getWidth();
        this.srcHeight = nIOBufferImage.getHeight();
        this.srcComponents = nIOBufferImage.getType().size;
        this.srcMult = (float)this.srcWidth * (float)this.srcHeight;
    }

    public NIOBufferImage getScaledImage(int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * this.srcComponents);
        byteBuffer.order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer2 = this.srcImage.getBuffer();
        byteBuffer2.rewind();
        switch (this.srcComponents) {
            case 4: {
                this.fillFourCompBuffer(n, n2, byteBuffer2, byteBuffer);
                break;
            }
            case 3: {
                this.fillThreeCompBuffer(n, n2, byteBuffer2, byteBuffer);
                break;
            }
            case 2: {
                this.fillTwoCompBuffer(n, n2, byteBuffer2, byteBuffer);
                break;
            }
            case 1: {
                this.fillOneCompBuffer(n, n2, byteBuffer2, byteBuffer);
            }
        }
        NIOBufferImage nIOBufferImage = new NIOBufferImage(n, n2, this.srcImage.getType(), this.srcImage.isGrayScale(), byteBuffer);
        return nIOBufferImage;
    }

    private void fillFourCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.green = new float[n];
        this.blue = new float[n];
        this.alpha = new float[n];
        byte[] byArray = new byte[n * this.srcComponents];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < this.srcHeight) {
            int n7;
            if (n6 == 0) {
                for (n7 = 0; n7 < n; ++n7) {
                    this.blue[n7] = 0.0f;
                    this.green[n7] = 0.0f;
                    this.red[n7] = 0.0f;
                    this.alpha[n7] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n8 = n4 < n6 ? n4 : n6;
            n7 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            while (n7 < this.srcWidth) {
                if (n10 == 0) {
                    n10 = n;
                    f2 = 0xFF & byteBuffer.get();
                    f3 = 0xFF & byteBuffer.get();
                    f4 = 0xFF & byteBuffer.get();
                    f = 0xFF & byteBuffer.get();
                    if (f != 255.0f) {
                        float f5 = f / 255.0f;
                        f2 *= f5;
                        f3 *= f5;
                        f4 *= f5;
                    }
                }
                int n12 = n10 < n11 ? n10 : n11;
                float f6 = (float)n12 * (float)n8;
                int n13 = n9;
                this.alpha[n13] = this.alpha[n13] + f6 * f;
                int n14 = n9;
                this.red[n14] = this.red[n14] + f6 * f2;
                int n15 = n9;
                this.green[n15] = this.green[n15] + f6 * f3;
                int n16 = n9;
                this.blue[n16] = this.blue[n16] + f6 * f4;
                if ((n10 -= n12) == 0) {
                    ++n7;
                }
                if ((n11 -= n12) != 0) continue;
                ++n9;
                n11 = this.srcWidth;
            }
            if ((n6 -= n8) == 0) {
                this.process4CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n8) >= n8 && n8 == this.srcHeight);
            } else {
                n4 -= n8;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
        }
    }

    private void process4CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcMult;
            int n3 = Math.round(this.alpha[i] / f);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= 255) {
                n3 = 255;
            } else {
                f = this.alpha[i] / 255.0f;
            }
            int n4 = Math.round(this.red[i] / f);
            int n5 = Math.round(this.green[i] / f);
            int n6 = Math.round(this.blue[i] / f);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            if (n6 < 0) {
                n6 = 0;
            } else if (n6 > 255) {
                n6 = 255;
            }
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n5;
            byArray[n2++] = (byte)n6;
            byArray[n2++] = (byte)n3;
        }
    }

    private void fillThreeCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.green = new float[n];
        this.blue = new float[n];
        byte[] byArray = new byte[n * this.srcComponents];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < this.srcHeight) {
            int n7;
            if (n6 == 0) {
                for (n7 = 0; n7 < n; ++n7) {
                    this.blue[n7] = 0.0f;
                    this.green[n7] = 0.0f;
                    this.red[n7] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n8 = n4 < n6 ? n4 : n6;
            n7 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            while (n7 < this.srcWidth) {
                if (n10 == 0) {
                    n10 = n;
                    f = 0xFF & byteBuffer.get();
                    f2 = 0xFF & byteBuffer.get();
                    f3 = 0xFF & byteBuffer.get();
                }
                int n12 = n10 < n11 ? n10 : n11;
                float f4 = (float)n12 * (float)n8;
                int n13 = n9;
                this.red[n13] = this.red[n13] + f4 * f;
                int n14 = n9;
                this.green[n14] = this.green[n14] + f4 * f2;
                int n15 = n9;
                this.blue[n15] = this.blue[n15] + f4 * f3;
                if ((n10 -= n12) == 0) {
                    ++n7;
                }
                if ((n11 -= n12) != 0) continue;
                ++n9;
                n11 = this.srcWidth;
            }
            if ((n6 -= n8) == 0) {
                this.process3CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n8) >= n8 && n8 == this.srcHeight);
            } else {
                n4 -= n8;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
        }
    }

    private void process3CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcMult;
            int n3 = Math.round(this.red[i] / f);
            int n4 = Math.round(this.green[i] / f);
            int n5 = Math.round(this.blue[i] / f);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > 255) {
                n5 = 255;
            }
            byArray[n2++] = (byte)n3;
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n5;
        }
    }

    private void fillTwoCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        this.alpha = new float[n];
        byte[] byArray = new byte[n * this.srcComponents];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < this.srcHeight) {
            int n7;
            if (n6 == 0) {
                for (n7 = 0; n7 < n; ++n7) {
                    this.red[n7] = 0.0f;
                    this.alpha[n7] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n8 = n4 < n6 ? n4 : n6;
            n7 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = this.srcWidth;
            float f = 0.0f;
            float f2 = 0.0f;
            while (n7 < this.srcWidth) {
                if (n10 == 0) {
                    n10 = n;
                    f2 = 0xFF & byteBuffer.get();
                    f = 0xFF & byteBuffer.get();
                    if (f != 255.0f) {
                        float f3 = f / 255.0f;
                        f2 *= f3;
                    }
                }
                int n12 = n10 < n11 ? n10 : n11;
                float f4 = (float)n12 * (float)n8;
                int n13 = n9;
                this.alpha[n13] = this.alpha[n13] + f4 * f;
                int n14 = n9;
                this.red[n14] = this.red[n14] + f4 * f2;
                if ((n10 -= n12) == 0) {
                    ++n7;
                }
                if ((n11 -= n12) != 0) continue;
                ++n9;
                n11 = this.srcWidth;
            }
            if ((n6 -= n8) == 0) {
                this.process2CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n8) >= n8 && n8 == this.srcHeight);
            } else {
                n4 -= n8;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
        }
    }

    private void process2CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcMult;
            int n3 = Math.round(this.alpha[i] / f);
            if (n3 <= 0) {
                n3 = 0;
            } else if (n3 >= 255) {
                n3 = 255;
            } else {
                f = this.alpha[i] / 255.0f;
            }
            int n4 = Math.round(this.red[i] / f);
            if (n4 < 0) {
                n4 = 0;
            } else if (n4 > 255) {
                n4 = 255;
            }
            byArray[n2++] = (byte)n4;
            byArray[n2++] = (byte)n3;
        }
    }

    private void fillOneCompBuffer(int n, int n2, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.red = new float[n];
        byte[] byArray = new byte[n * this.srcComponents];
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = 0;
        while (n3 < this.srcHeight) {
            int n7;
            if (n6 == 0) {
                for (n7 = 0; n7 < n; ++n7) {
                    this.red[n7] = 0.0f;
                }
                n6 = this.srcHeight;
            }
            int n8 = n4 < n6 ? n4 : n6;
            n7 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = this.srcWidth;
            float f = 0.0f;
            while (n7 < this.srcWidth) {
                if (n10 == 0) {
                    n10 = n;
                    f = 0xFF & byteBuffer.get();
                }
                int n12 = n10 < n11 ? n10 : n11;
                float f2 = (float)n12 * (float)n8;
                int n13 = n9;
                this.red[n13] = this.red[n13] + f2 * f;
                if ((n10 -= n12) == 0) {
                    ++n7;
                }
                if ((n11 -= n12) != 0) continue;
                ++n9;
                n11 = this.srcWidth;
            }
            if ((n6 -= n8) == 0) {
                this.process1CompRow(n, byArray);
                do {
                    byteBuffer2.put(byArray);
                    ++n5;
                } while ((n4 -= n8) >= n8 && n8 == this.srcHeight);
            } else {
                n4 -= n8;
            }
            if (n4 != 0) continue;
            n4 = n2;
            ++n3;
        }
    }

    private void process1CompRow(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            float f = this.srcMult;
            int n3 = Math.round(this.red[i] / f);
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            byArray[n2++] = (byte)n3;
        }
    }
}

