Parsnp is a command-line-tool for efficient microbial core genome alignment and SNP detection. Parsnp was designed to work in tandem with Gingr, a flexible platform for visualizing genome alignments and phylogenetic trees; both Parsnp and Gingr form part of the Harvest suite :



# Installation
## From conda
Parsnp is available on [Bioconda](https://bioconda.github.io/recipes/parsnp/README.html). This is the recommended method of installation. 
Once you have [added the Bioconda channel](https://bioconda.github.io/#usage) to your conda environment, `parsnp` can be installed via
```
conda install -c bioconda parsnp
```

If you run into conflicts, even in a fresh environment, that may be due to the versions of the 
default dependencies in the env. You can get around this by letting conda figure out
which versions of the dependencies are necessary by telling it which packages you want at 
creation:
```
conda create -n parsnp-env parsnp==2.*
```

Instructions for building Parsnp from source are available towards the end of this README.

# Running Parsnp
Parsnp can be run multiple ways, but the most common is with a set of genomes and a reference. 
```
parsnp -g <reference_genbank> -d <genomes> 
```
```
parsnp -r <reference_fasta> -d <genomes> 
```
For example, 
```
parsnp -r examples/mers_virus/ref/England1.fna -d examples/mers_virus/genomes/*.fna -o examples-out
```

## Partition mode
Parsnp 2 will group query genomes up into random partitions of at least `--min-partition-size` genomes each (50 by default). Parsnp is then run independently on each group, and the resulting alignment of each group is merged into a single alignment of all input genomes. This limits the input size for an individual "core" Parsnp step, leading to significantly less memory and CPU usage. We've also shown, on simulated and empirical data, that this partitioning step often leads to increased core-genome size and better phylogenetic signal.

The `--no-partition` flag allows users to run all query genomes at once.

## Output files
* `parsnp.xmfa` is the core-genome alignment.
* `parsnp.ggr` is the compressed representation of the alignment generated by the harvest-toolkit. This file can be used to visualize alignments with Gingr.
* `parsnp.snps.mblocks` is the core-SNP signature of each sequence in fasta format. This is the file which is used to generate `parsnp.tree`
* `parsnp.tree` is the resulting phylogeny.
* If run in partition mode, Parsnp will produce a `partition` folder in the output directory, which contains the output of each of the partitioned runs. 


### XMFA format
The output XMFA file contains a header section mapping contig names to indices. Following the header section, the LCBs/clusters are reported in the XMFA format, where the ID for each record in an LCB is formatted as:

```
[fileidx]:[concat_start]-[concat_end] [strand] cluster[x] s[contig_idx]:p[contig_pos]
```

The `concat_start` and `concat_end` values are internal to parsnp. The sequence for this record can be found in the file at index `fileidx` (these are declared at the top of the xmfa) on the `contig_idx`th contig starting at position `contig_pos`. 

## Building from source 

To build Parsnp from source, users must have automake 1.15, autoconf, and libtool installed. Parsnp also requires RaxML (or FastTree), Harvest-tools, biopython, tqdm, and numpy. Some additional features require  pySPOA, Mash, FastANI, and Phipack. All of these packages are available via Conda (many on the Bioconda channel).

### Build instructions
First, you must build the Muscle library
```
cd muscle
./autogen.sh
./configure --prefix=$PWD CXXFLAGS='-fopenmp'
make install
```

Now we can build Parsnp
```
cd ..
./autogen.sh
./configure
make LDADD=-lMUSCLE-3.7 
make install
```

If you wish to be able to move your Parsnp installation around after building, build the parsp binary as follows (after building the Muscle library)
```
./autogen.sh
export ORIGIN=\$ORIGIN
./configure LDFLAGS='-Wl,-rpath,$$ORIGIN/../muscle/lib'
make LDADD=-lMUSCLE-3.7 
make install
```

Note that the `parsnp` executable in `bin/` is not the same as the one in the root level. The former is an alias for Parsnp.py while the latter is the core algorithm of Parsnp that we build above.

## OSX Users (Catalina)
Recent OSX have a Gatekeeper, that's designed to ensure that only softwre from known developers runs on  tour Mac. Please refer to this link to enable the binaries shipped with Parsnp to run: https://support.apple.com/en-us/HT202491

## Misc

CITATION provides details on how to cite Parsnp.

LICENSE provides licensing information.


- The [Harvest project page](http://harvest.readthedocs.org) provides examples of how to use Gingr and HarvestTools with Parsnp, however the Parsnp examples are not up-to-date with the current interface.



