/**************************************************************************
 **                                                                      **
 ** Copyright (C) 2011-2022 Lukas Spies                                  **
 ** Contact: https://photoqt.org                                         **
 **                                                                      **
 ** This file is part of PhotoQt.                                        **
 **                                                                      **
 ** PhotoQt is free software: you can redistribute it and/or modify      **
 ** it under the terms of the GNU General Public License as published by **
 ** the Free Software Foundation, either version 2 of the License, or    **
 ** (at your option) any later version.                                  **
 **                                                                      **
 ** PhotoQt is distributed in the hope that it will be useful,           **
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
 ** GNU General Public License for more details.                         **
 **                                                                      **
 ** You should have received a copy of the GNU General Public License    **
 ** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
 **                                                                      **
 **************************************************************************/

import QtQuick 2.9
import QtQuick.Controls 2.2

import "../../../elements"

PQSetting {
    //: A settings title referring to whether to fit images in window
    title: em.pty+qsTranslate("settingsmanager_imageview", "fit in window")
    helptext: em.pty+qsTranslate("settingsmanager_imageview", "Zoom smaller images to fill the full window width and/or height.")
    content: [

        PQCheckbox {
            id: fitinwin
            text: em.pty+qsTranslate("settingsmanager_imageview", "fit smaller images in window")
        }

    ]

    Connections {

        target: settingsmanager_top

        onLoadAllSettings: {
            load()
        }

        onSaveAllSettings: {
            PQSettings.imageviewFitInWindow = fitinwin.checked
        }

    }

    Component.onCompleted: {
        load()
    }

    function load() {
        fitinwin.checked = PQSettings.imageviewFitInWindow
    }

}
