# Overview of the build system

The PHP documentation is built from XML files and render into PHP files
that are available on the [php.net/manual](https://php.net/manual/en) pages.
All parts of the process live in the following GitHub repositories:

- [**doc-\* repos**](#the-english-language-documentation-and-its-translations):
   these are the repositories where all the information on documentation pages live
   and this is where changes to the wording and/or structure
   of the documentation's content can be made
- [**doc-base**](#doc-base): validates and pre-processes the language files
- [**PhD**](#phd): renders pages into .php files which include information on the files
   and function calls to include the documentation page headers and footers
- [**web-php**](#web-php): serves up the .php files generated by PhD
   and includes the functions to generate page headers and footers
   (to include contribution call-out and user notes)

## The English Language Documentation And Its Translations

These repositories contain PHP's documentation in their respective languages
and these are where changes to the content/structure
of the [php.net's documentation pages](https://www.php.net/docs.php) are made.

Please refer to the [contribution guidlines](contributing.md) on how to
contribute to the documentation.

## doc-base

[doc-base](https://github.com/php/doc-base) validates and combines the documentations' XML files.
It includes a skeleton/main table of contents of the PHP documentation (index.php)
and the `configure.php` script which processes the documentation:
- pulls version info file from repo files
- starting from the skeleton/main table of contents file, it iterates over all files in the language repository and includes all elements with the appropriate IDs
- pulls modification history file
- generates the file entities from the source language directory and writes these back into the same directory
- loads the combined XML file into memory
- runs/executes all XInclude/XPointer links
- subtitutes entities
- validates the document based on its DTD

## PhD

[PhD](https://github.com/php/phd) (PHP DocBook) renders the combined XML file,
the version file and modification history files generated/copied by [doc-base](https://github.com/php/doc-base)
into the final PHP documentation pages.

While PhD is capable of generating the documentation in a number of formats,
the PHP documentation website is using the format that generates .php files.
This format adds PHP code in each file that contains information on the current page
(e.g. title, breadcrumbs, source file name/path, last modified date/time, contributor list)
and calls to setting up the header and footer for the page.

It's important to note that the function calls included in the pages here
are for functions that are defined in [web-php](https://github.com/php/web-php).
A new functionality added to [web-php](https://github.com/php/web-php) can only be used
if the appropriate format in PhD is modified to include the function call.

Other than the above PhD also does the following:
- writes the search-index and search-description json files
- copies (by default downloads) css files into the output directory
- copies images to the images directory
- generates and saves the TOC (table of contents) files
 (the TOC/navbar on the right side of the documentation pages)

## web-php

[web-php](https://github.com/php/web-php) is the repository that PHP's web servers actually run
(ie. almost everything accesible on [php.net](https://php.net)).

This repository includes the functions that generate the header (top
navigation and search bar) and footer (copyright, privacy policy,
etc.) for most php.net pages and it also includes the functions that
generate the additional header (breadcrumbs, language dropdown, etc.)
and footer (contribution and user notes sections) of documentation pages.

It uses the css, image, TOC and search index/description files
copied/generated by PhD to serve up images/css files, generate the right
side TOC/navbar on the documentation pages and make the search bar on
[php.net](https://php.net) work.

The [local web development environment](local-web-setup.md) chapter
explains how to run the `php-web` repository locally so you can build
the documentation and review it as it will appear online.
