/*
 * Copyright 2020-present MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MONGOCRYPT_EXPORT_H
#define MONGOCRYPT_EXPORT_H

/* This file would typically be generated by libmongocrypt's CMake build process
 * so it must exist when building libmongocrypt as a submodule via Autotools. We
 * need only ensure this file exists and expected constants are defined, since
 * libmongocrypt APIs will not actually be exported.
 *
 * See: https://cmake.org/cmake/help/latest/module/GenerateExportHeader.html */
#define MONGOCRYPT_EXPORT
#define MONGOCRYPT_NO_EXPORT
#define MONGOCRYPT_DEPRECATED
#define MONGOCRYPT_DEPRECATED_EXPORT
#define MONGOCRYPT_DEPRECATED_NO_EXPORT

#endif /* MONGOCRYPT_EXPORT_H */
