#! /bin/sh
#
# /etc/init.d/Stage_Manager
#
# CVS ID: Stage_Manager.init.d.sh,v 1.4 2009/04/22 23:21:18 castalia Exp
#
#
### BEGIN INIT INFO
# Provides: Stage_Manager
# Required-Start: $network $remote_fs autofs
# Required-Stop: $network $remote_fs autofs
# Default-Start: 3 5
# Default-Stop: 0 1 2 6
# Description: Stage_Manager daemon
### END INIT INFO

STAGE_MANAGER_WATCHDOG=/opt/local/sh/Stage_Manager_Watchdog
STAGE_MANAGER_USER=hiroc
STAGE_MANAGER_GROUP=hiops
LOG_DIR=/var/log/Stage_Manager
PID_FILE=$LOG_DIR/Stage_Manager.pid
WATCHDOG_LOG=$LOG_DIR/Stage_Manager_Watchdog.log


case "$1" in

    start_now)

	#	Start the Stage_Manage without delay.

	if [ ! -x $STAGE_MANAGER_WATCHDOG ]
	then
		echo "Can't find the Stage_Manager_Watchdog: " $STAGE_MANAGER_WATCHDOG
		exit 5
	fi

	#	Create the log file directory if it doesn't already exist.
	if [ ! -d $LOG_DIR ]
	then
		/bin/mkdir -p $LOG_DIR
		/bin/chown $STAGE_MANAGER_USER.$STAGE_MANAGER_GROUP $LOG_DIR
	fi

	echo  "Starting the Stage_Manager_Watchdog"
	
	#	!!! Hack: Workaround for ISIS environment setup.
	export TERM=non_interactive

	#	The watchdog will start the Stage_Manager
	#	with a complete STAGE_MANAGER_USER login environment.
	/bin/su -l -c $STAGE_MANAGER_WATCHDOG $STAGE_MANAGER_USER >$WATCHDOG_LOG 2>&1 &
	/bin/sleep 2
	PID=`/bin/ps auxwww \
		| /bin/grep -v grep \
		| /bin/grep $STAGE_MANAGER_WATCHDOG \
		| /bin/awk '{print $2}'`
	if [ -z "$PID" ]
	then
		echo "  The Stage_Manager_Watchdog did not start"
		exit 1
	fi
	;;


    start)

	#	Schedule the real start for 5 minutes from now.
	echo "/etc/init.d/Stage_Manager start_now" | /usr/bin/at now + 5 minutes
	echo "Scheduled Stage_Manager start"
	;;


    stop)

	echo  "Shutting down the Stage_Manager_Watchdog"
	PID=`/bin/ps auxwww \
		| /bin/grep -v grep \
		| /bin/grep $STAGE_MANAGER_WATCHDOG \
		| /bin/awk '{print $2}'`
	if [ -n "$PID" ]
	then
		/bin/kill -TERM $PID
	else
		echo "  The Stage_Manager_Watchdog is not running"
	fi

	echo  "Shutting down the Stage Manager"
	if [ -f $PID_FILE ]
	then
		Process_ID=`cat $PID_FILE`
		PID=`/bin/ps auxwww \
			| /bin/grep -v grep \
			| /bin/grep "$Process_ID" \
			| /bin/awk '{print $2}'`
		if [ -n "$PID" ]
		then
			/bin/kill -TERM $PID
		else
			echo "  The Stage_Manager is not running"
		fi
		/bin/rm -f $PID_FILE
	else
		echo "  No $PID_FILE file"
	fi
	;;


    restart)
    #	Stop and then start the service.
    $0 stop
    $0 start_now
    ;;


    *)
	echo "Usage: $0 {start|start_now|restart|stop}"
	exit 1
	;;

esac



