/*	Configuration_Exception

PIRL CVS ID: Configuration_Exception.java,v 1.7 2012/04/16 06:05:20 castalia Exp

Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Configuration;

/**
The excpetion thrown from the PIRL.Configuration package.
<P>
@author		Bradford Castalia, Christian Schaller - UA/PIRL
@version	1.7
*/
public class Configuration_Exception
	extends java.lang.Exception
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Configuration.Configuration_Exception (1.7 2012/04/16 06:05:20)";

/*==============================================================================
	Constructors
*/
/**	Constructs a Configuration_Exception with a message and a cause.
<p>
	<b>N.B.</b>: Once a cause is set it can not be changed. Therefore,
	though it is allowed to set the cause to null, the
	Configuration_Exception will not do this to avoid the situation of
	not being able to replace a null cause with a valid cause. Use the
	{@link Throwable#initCause(Throwable)} method to provide a cause
	after the Configuration_Exception has been constructed without one.
<p>
	@param	message	The exception's message String. If null the {@link
		#ID class identification} will be used.
	@param	cause	The exception's Throwable cause. If null no cause is
		set in the exception object.
*/
public Configuration_Exception
	(
	String		message,
	Throwable	cause
	)
{
super ((message == null) ? ID : message);
if (cause != null)
	initCause (cause);
}

/**	Constructs a Configuration_Exception having a cause.
<p>
	The exception message will be Configuration_Exception class ID.
<p>
	@param	cause	The exception's Throwable cause. If null no cause is
		set in the exception object.
	@see	#Configuration_Exception(String, Throwable)
*/
public Configuration_Exception
	(
	Throwable	cause
	)
{this (null, cause);}

/**	Constructs a Configuration_Exception with a message.
<p>
	@param	message	The exception's message String (may be null).
	@see	#Configuration_Exception(String, Throwable)
*/
public Configuration_Exception
	(
	String		message
	)
{this (message, null);}

/**	Constructs a Configuration_Exception.
<p>
	The exception will have the ID of this class as its message.
<p>
	@see	#Configuration_Exception(String, Throwable)
*/
public Configuration_Exception ()
{this (null, null);}

}	//	End of class
