#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;

use Classes::User;
use Classes::Filter;

use CGI;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/pie.pl';
require 'Functions/encode.pl';
require 'Functions/Name_Resolution.pl';
require 'Functions/FakeFunctions.pl';
require 'Functions/score.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our %miss = ();	# missing Modules (optional ones)
our $cgi = '';	# CGI data

eval( 'require Geo::IP' ) || ( $miss{'Geo::IP'} = 1 );
LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

my $Where = '';
my $Title = '';
if ( ! $cgi->param( 'f' ) ) {$cgi->param( 'f', 'S' );};
my $Type_short = $cgi->param( 'f' );

if ( $Type_short eq 'S' ) {$Where = 'WHERE parent_type=\'S\' ';$Title = 'attacker';};
if ( $Type_short eq 'T' ) {$Where = 'WHERE parent_type=\'T\' ';$Title = 'attacked host';};
if ( $Type_short eq 'All' ) {$Where = 'WHERE (parent_type=\'S\' OR parent_type=\'T\') ';$Title = 'host';};

our $PageTitle = ' - Top '.$conf{'nb_topattack*s'}.' '.$Title.' list';

ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );
ParseComponent( 'TopAttackers_Filter' );

my ( @labels, @values, @iaddr, @parent, @country );
my $First = 1;
if ( ! $cgi->param( 'r' ) ) {$First = 0;};

my %CountryCount;

my $Statement = 'SELECT count(address) as cnt,address,parent_type,category FROM ';
$Statement .= 'Prelude_Address '.$Where;
$Statement .= 'GROUP BY address,parent_type,category ORDER BY cnt DESC LIMIT '.$conf{'nb_topattack*s'}.';';

my $Sth = $dbh->prepare( $Statement );
$Sth->execute();

while( my $HashRef = $Sth->fetchrow_hashref() )
{
	my $iaddr = $HashRef->{'address'};

	my $name = '';
	if ( $conf{'HostName_Lookup'} )
	{
		my ( $aliases, $proto ) = ( undef, undef );
		if ( $HashRef->{'category'} eq 'ipv4-addr' )
		{
			( $name, $aliases, $proto) = MY_gethostbyaddr( $iaddr );
		}
	}

	my $country = '';
	if ( ! $miss{'Geo::IP'} )
	{
		my $gi = Geo::IP->new();
		$country = $gi->country_code_by_addr( $iaddr );
		if ( ! $country ) {$country = 'Unk.';};
		if ( ! $First ) {$CountryCount{$country} += $HashRef->{'cnt'};};
	}

	if ( ! $First )
	{
		push @labels, ( $name || $iaddr );
		push @values, $HashRef->{'cnt'} ;
		push @iaddr, $iaddr;
		push @parent, $HashRef->{'parent_type'};
		push @country, $country;
	}
	else
	{
		$First = 0;
	}
}
$Sth->finish();

if ( $cgi->param( 'r' ) )
{
	print "In following pie charts, the biggest 'attacker' has been removed.\n";
}

my $FileExt = '';
if ( ! $cgi->param( 'backend' ) ) {$cgi->param( 'backend', $conf{'default_backend'} );};

if ( $cgi->param( 'backend' ) eq 'HTML' )
{
	print "<table class=\"bordered\" width=\"80%\" align=\"center\" border=\"1\">\n";
	print "  <tr>\n";
	print "    <th align=\"center\" width=\"1%\">AttackNb&nbsp;</th>\n";
	if ( $Type_short eq 'S' )
	{
		print "    <th align=\"center\" width=\"1%\">AttackTypeNb&nbsp;</th>\n";
		print "    <th align=\"center\" width=\"1%\">TargetNb&nbsp;</th>\n";
		print "    <th align=\"center\" width=\"1%\">Score&nbsp;</th>\n";
	}
	print "    <th align=\"center\">&nbsp;Address</th>\n";
	if ( ! $miss{'Geo::IP'} ) {print "    <th>Country</th>\n";};
	if ( $conf{'HostName_Lookup'} ) {print "    <th align=\"center\">&nbsp;Host name</th>\n";};
	if ( $Type_short eq 'All' ) {print "    <th>Source/Target</th>\n";};
	print "  </tr>\n";

	for( my $cnt = 0 ; $cnt <= $#values ; $cnt ++ )
	{
		my $name = $labels[$cnt];
		my $iaddr = $iaddr[$cnt];
		my $count = $values[$cnt];
		my $parent = $parent[$cnt];
		my $country = $country[$cnt];

		print "  <tr>\n";
		print "    <td align=\"center\">$count&nbsp;</td>\n";

		if ( $Type_short eq 'S' )
		{
			my $Source_AlertTypeNb = Source_AlertTypeNb( $iaddr ) || 1;
			my $Source_TargetNb = Source_TargetNb( $iaddr ) || 1;
			my $Score = $count/$Source_AlertTypeNb/$Source_TargetNb;

			print "    <td align=\"center\">$Source_AlertTypeNb&nbsp;</td>\n";
			print "    <td align=\"center\">$Source_TargetNb&nbsp;</td>\n";
			print "    <td align=\"center\">$Score&nbsp;</td>\n";
		}
		print "    <td align=\"left\">";
		print "<a href=\"Filters$conf{'extension'}?load=";
		print url_encode( 'defaults/eqAddress.address' );
		print "&amp;valA=".url_encode( $iaddr );
		print "&amp;timelimit=10Y\">$iaddr</a></td>\n";

		if ( ! $miss{'Geo::IP'} )
		{
			print "    <td align=\"center\">$country</td>\n";
		}

		if ( $conf{'HostName_Lookup'} )
		{
			print '    <td>'.( $name || 'n/a' )."</td>\n";
		}

		if ( $Type_short eq 'All' )
		{
			print "    <td align=\"center\">$parent</td>\n";
		}
		print "  </tr>\n";
	}

	print "</table>\n";
}

if ( $cgi->param( 'backend' ) eq 'GD' )
{
	eval( 'require GD::Graph::pie' ) || ( $miss{'GD::Graph'} = 1 );

	if ( $miss{'GD::Graph'} )
	{
		error( 'No graphics because module GD::Graph is missing' );
	}
	else
	{
		my @data = ( [@labels], [@values] );
		&piechart( \@data, 'top '.$Title, 'generated/Images/TopAttackers'.$Type_short.'.png' );
		undef @data;

		$FileExt = 'png';
	}
}

if ( $cgi->param( 'backend' ) eq 'PS' )
{
	require 'Functions/ps.pl';

	our $PS_Title = "Top $conf{'nb_topattack*s'} ".$Title;

	my @data = ( [@labels], [@values], [] );
	my $ res = &postscript( \@data, 'piechart.ps', 'generated/PostScript/TopAttackers.ps', 900 );
	if ( $res )
	{
		`$conf{'gs_path'} -sDEVICE=jpeg -dNOPAUSE -dBATCH -dGraphicsAlphaBits=4 -dTextAlphaBits=4 -sOutputFile="generated/Images/TopAttackers$Type_short.jpg" generated/PostScript/TopAttackers.ps`;

		unlink 'generated/PostScript/TopAttackers.ps';

		$FileExt = 'jpg';
	}
}

if ( ! $miss{'Geo::IP'} )
{
	my @labels = ();
	my @values = ();
	foreach my $Country ( sort {$CountryCount{$b} <=> $CountryCount{$a}} keys %CountryCount )
	{
		push @labels, $Country;
		push @values, $CountryCount{$Country};

		if ( $cgi->param( 'backend' ) eq 'GD' )
		{
			if ( ! $miss{'GD::Graph'} )
			{
				my @data = ( [@labels], [@values] );
				&piechart( \@data, 'top '.$Title.' countries', 'generated/Images/TopAttackers_country'.$Type_short.'.png' );
				undef @data;
			}
		}

		if ( $cgi->param( 'backend' ) eq 'PS' )
		{
			require 'Functions/ps.pl';

			our $PS_Title = "Top $conf{'nb_topattack*s'} ".$Title.' countries';

			my @data = ( [@labels], [@values], [] );
			my $res = &postscript( \@data, 'piechart.ps', 'generated/PostScript/TopAttackers.ps', 900 );
			if ( $res )
			{
				`$conf{'gs_path'} -sDEVICE=jpeg -dNOPAUSE -dBATCH -dGraphicsAlphaBits=4 -dTextAlphaBits=4 -sOutputFile="generated/Images/TopAttackers_country$Type_short.jpg" generated/PostScript/TopAttackers.ps`;

				unlink 'generated/PostScript/TopAttackers.ps';

				$FileExt = 'jpg';
			}
		}
	}
}
else
{
	error( 'No country information because module Geo::IP is missing' );
}

if ( $FileExt )
{
print <<"EOF";
<br><br><br><br>
<table width="90%" align="center">
  <tr><td align="center"><img src="generated/Images/TopAttackers$Type_short.$FileExt" alt=""></td>
EOF

	if ( $cgi->param( 'backend' ) eq 'PS') {print "</tr><tr>";};

	if ( ! $miss{'Geo::IP'} )
	{
		print "<td align=\"center\"><img src=\"generated/Images/TopAttackers_country$Type_short.$FileExt\" alt=\"\"></td>\n";
	}

	if ( $cgi->param( 'backend' ) eq 'PS' ) {print "</tr>";};

	print "</table>";
}

ParseComponent( 'CommonFooter' );
