/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __DENOMINATIONIDEE__
#define __DENOMINATIONIDEE__

#include <src/global/global.h>

typedef struct denominationidee CONTENEUR(DenominationIdee);

#include <src/donnees/flux/flux.h>

struct denominationidee
{
	STOCKAGE_SCALAIRE(TypeIdee) type;
	//Type de l'ide dnomme.
	union
	{
		STOCKAGE_SCALAIRE(IdIdee) idideepresente;
		STOCKAGE_SCALAIRE(Indice) indicemanquante;
		STOCKAGE_SCALAIRE(Chaine) referenceparentegenerique;
	} denomination;
	//Caractristique de la dnomination
	//de l'ide.
	STOCKAGE_SCALAIRE(Chaine) reference;
	//Rfrence exacte de l'ide.
};
/* Structure servant  indiquer une ide de
 * manire prcise, et ce quelque soit son
 * type.
 */

Resultat denominationidee_initialisation(TRAVAIL(DenominationIdee) denominationidee);
/* Cre une dnomination d'ide vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_definition_ideepresente(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(IdIdee) ididee , TRAVAIL(Flux) reference);
/* Dfinit une dnomination d'ide prsente.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_definition_ideemanquante(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(Indice) indice , TRAVAIL(Flux) reference);
/* Dfinit une dnomination d'ide manquante.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_definition_ideegenerique(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL_SCALAIRE(Chaine) referenceparente , TRAVAIL(Flux) reference);
/* Dfinit une dnomination d'ide gnrique.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_definition_ideeracine(TRAVAIL(DenominationIdee) denominationidee);
/* Dfinit une dnomination d'ide racine.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination n'tait pas vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_vide(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(Booleen) vide);
/* Renvoie VRAI si la dnomination d'ide est vide, ou non.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 */

Resultat denominationidee_lecture(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(TypeIdee) type , REFERENCE_SCALAIRE(IdIdee) ididee , REFERENCE_SCALAIRE(Indice) indice , REFERENCE_SCALAIRE(Chaine) referenceparente , REFERENCE_SCALAIRE(Chaine) reference);
/* Lit une dnomination d'ide. Le type est renvoy, et les paramtres
 * suivant donne la dnomination correspondant au type renvoy.
 * Dans le cas o la chaine est renvoye, il n'y a pas besoin
 * de la librer.
 * Enfin, la fonction renvoie la rfrence exacte de l'ide
 * ainsi dnome. Cette chaine n'a pas  tre libre.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_lecture_reference(TRAVAIL(DenominationIdee) denominationidee , REFERENCE_SCALAIRE(Chaine) reference);
/* Lit la rfrence d'une dnomination d'ide. Enfin, la fonction
 * renvoie la rfrence exacte de l'ide ainsi dnome.
 * Cette chaine n'a pas  tre libre.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_copie(TRAVAIL(DenominationIdee) denominationidee , TRAVAIL(DenominationIdee) copie);
/* Ralise une copie de la dnomination.
 * Si la copie tait non vide, elle est dtruite
 * avant la copie.
 * Renvoie RESULTAT_ERREUR si denominationidee est NULL.
 * Renvoie RESULTAT_ERREUR_DOMAINE si la dnomination tait vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec d'une allocation
 * mmoire.
 */

Resultat denominationidee_destruction(TRAVAIL(DenominationIdee) denominationidee);
/* Dtruit une dnomination d'ide.
 */

#endif
