/********************************************************************************
 *   Copyright (C) 2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef PHOTOSET_DIALOG_H
#define PHOTOSET_DIALOG_H

#include <QListWidgetItem>

#include <KDialog>
#include <Plasma/DataEngine>

static const int s_photoset_id = -1;

class QRadioButton;

class KListWidget;

class PhotosetItem : public QListWidgetItem
{
public:
  PhotosetItem( const QString &p_text = QString::null );
  ~PhotosetItem();
  QVariant data( int p_role = s_photoset_id ) const;
  void setData( int p_role, const QVariant &p_value );
private:
  QString m_data;
};

class PhotosetDialog : public KDialog
{
  Q_OBJECT
public:
  PhotosetDialog( QWidget *p_parent = 0 );
  ~PhotosetDialog();

  void addPhotosets( const Plasma::DataEngine::Data &p_data );
  QString photoset() const;
  void reset();
protected slots:
  void photosetChosen();
private:
  KListWidget *m_list;
};

#endif // CLUSTER_DIALOG_H
