/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2012 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#include "AnimationThrowRect.h"

#include <QRectF>

namespace SmoothTasks {

AnimationThrowRect::AnimationThrowRect(QObject* parent)
	: AnimationThrow<4, QRectF>(parent)
{}

AnimationThrowRect::AnimationThrowRect(QObject* target, const QByteArray& propertyName, QObject* parent)
	: AnimationThrow<4, QRectF>(target, propertyName, parent)
{}

AnimationThrowRect::~AnimationThrowRect() {
}

QRectF AnimationThrowRect::convert(const qreal src[]) const {
	QRectF rect;
	rect.setCoords(src[0], src[1], src[2], src[3]);
	return rect;
}

void AnimationThrowRect::convert(const QRectF& src, qreal dst[]) const {
	src.getCoords(dst, dst + 1, dst + 2, dst + 3);
}

} // namespace SmoothTasks
