# +-----------------------------------------------------------------------+
# | pLoader - a Perl photo uploader for Piwigo                            |
# +-----------------------------------------------------------------------+
# | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
# +-----------------------------------------------------------------------+
# | This program is free software; you can redistribute it and/or modify  |
# | it under the terms of the GNU General Public License as published by  |
# | the Free Software Foundation                                          |
# |                                                                       |
# | This program is distributed in the hope that it will be useful, but   |
# | WITHOUT ANY WARRANTY; without even the implied warranty of            |
# | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
# | General Public License for more details.                              |
# |                                                                       |
# | You should have received a copy of the GNU General Public License     |
# | along with this program; if not, write to the Free Software           |
# | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
# | USA.                                                                  |
# +-----------------------------------------------------------------------+
package Uploader::GUI::wxDestinationCategoryDlg;
use strict;
use Wx qw/
             wxDefaultSize
             wxDefaultPosition
             wxDIALOG_NO_PARENT
             wxDEFAULT_DIALOG_STYLE
             wxMAXIMIZE_BOX
             wxMINIMIZE_BOX
             wxID_CANCEL
             wxID_OK
         /;
use base qw/Wx::Dialog Uploader::GUI::DlgCommon Class::Accessor::Fast/;
use Wx::Event qw/
                    EVT_BUTTON
                /;

__PACKAGE__->mk_accessors( 
    qw/
           btok
      / 
);
use Carp;
use Uploader::GUI::wxCategoryTreeCtrl;

sub new {
    my ($this, $params) = @_;
    #on recupere le nom de la classe en fonction du type d'appel de la mthode.
    my $class = ref($this) || $this;


    my $self = $class->SUPER::new(
        undef, 
        -1,
        $params->{caption},
        wxDefaultPosition,
        [450, 300],
             wxDIALOG_NO_PARENT|
             wxDEFAULT_DIALOG_STYLE|
             wxMAXIMIZE_BOX|
             wxMINIMIZE_BOX
    );
    # load controls
    &main::DestinationCategory($self, $params );

    $self->properties(
        $params->{properties}
    );

    $self->InitLabels();
    $self->InitChoices();
    $self->SetProperties();
    $self->InitHandler();

    $self->init_event_handlers();
    
    $self->btok( $self->FindWindow($main::DESTINATION_CATEGORIES_OK) );
    $self->btok->Enable(0);

    $self;
}


sub init_event_handlers {
    my ( $self ) = @_;
    
    EVT_BUTTON( $self, $main::DESTINATION_CATEGORIES_OK, \&OnOK );
    EVT_BUTTON( $self, $main::DESTINATION_CATEGORIES_CANCEL, \&OnCancel );
    
}

# Update progress information

sub OnOK {
    my ( $self, $event ) = @_;
    
    $self->EndModal(wxID_OK);
}


sub OnCancel {
    my ( $self, $event ) = @_;
    
    $self->ClearProperties;
    $self->EndModal(wxID_CANCEL);
}

1;