//
// Handle.h
//
// $Id: //poco/1.3/Data/ODBC/include/Poco/Data/ODBC/Handle.h#3 $
//
// Library: Data/ODBC
// Package: ODBC
// Module:  Handle
//
// Definition of Handle.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ODBC_Handle_INCLUDED
#define ODBC_Handle_INCLUDED


#include "Poco/Data/ODBC/ODBC.h"
#include "Poco/Data/ODBC/EnvironmentHandle.h"
#include "Poco/Data/ODBC/ConnectionHandle.h"
#include "Poco/Data/ODBC/ODBCException.h"
#include "Poco/Data/ODBC/Utility.h"
#ifdef POCO_OS_FAMILY_WINDOWS
#include <windows.h>
#endif
#include <sqltypes.h>


namespace Poco {
namespace Data {
namespace ODBC {


template <typename H, SQLSMALLINT handleType>
class Handle
/// ODBC handle class template
{
public:
	Handle(const ConnectionHandle& rConnection): 
		_rConnection(rConnection),
		_handle(0)
			/// Creates the Handle.
	{
		if (Utility::isError(SQLAllocHandle(handleType, 
			_rConnection, 
			&_handle))) 
		{
			throw ODBCException("Could not allocate statement handle.");
		}
	}

	~Handle()
		/// Destroys the Handle.
	{
		SQLRETURN rc = SQLFreeHandle(handleType, _handle);
		poco_assert (!Utility::isError(rc));
	}

	operator const H& () const
		/// Const conversion operator into reference to native type.
	{
		return handle();
	}

	const H& handle() const
		/// Returns const reference to native type.
	{
		return _handle;
	}

private:
	Handle(const Handle&);
	const Handle& operator=(const Handle&);

	operator H& ()
		/// Conversion operator into reference to native type.
	{
		return handle();
	}

	H& handle()
		/// Returns reference to native type.
	{
		return _handle;
	}

	const ConnectionHandle& _rConnection;
	H _handle;

	friend class ODBCStatementImpl;
};


typedef Handle<SQLHSTMT, SQL_HANDLE_STMT> StatementHandle;
typedef Handle<SQLHDESC, SQL_HANDLE_DESC> DescriptorHandle;


} } } // namespace Poco::Data::ODBC


#endif
