//
// RemoteSyslogListener.h
//
// $Id: //poco/1.3/Net/include/Poco/Net/RemoteSyslogListener.h#1 $
//
// Library: Net
// Package: Logging
// Module:  RemoteSyslogListener
//
// Definition of the RemoteSyslogListener class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Net_RemoteSyslogListener_INCLUDED
#define Net_RemoteSyslogListener_INCLUDED


#include "Poco/Net/Net.h"
#include "Poco/Thread.h"
#include "Poco/SplitterChannel.h"
#include "Poco/NotificationQueue.h"


namespace Poco {
namespace Net {


class RemoteUDPListener;
class SyslogParser;


class Net_API RemoteSyslogListener: public Poco::SplitterChannel
	/// RemoteSyslogListener implents listening for syslog messages
	/// sent over UDP, according to the syslog Working Group Internet Draft:
	/// "The syslog Protocol" <http://www.ietf.org/internet-drafts/draft-ietf-syslog-protocol-17.txt>, 
	/// and "Transmission of syslog messages over UDP" <http://www.ietf.org/internet-drafts/draft-ietf-syslog-transport-udp-07.txt>.
	///
	/// In addition, RemoteSyslogListener also supports the "old" BSD syslog
	/// protocol, as described in RFC 3164.
	///
	/// The RemoteSyslogListener is a subclass of Poco::SplitterChannel.
	/// Every received log message is sent to the channels registered
	/// with addChannel() or the "channel" property.
{
public:
	RemoteSyslogListener();
		/// Creates the RemoteSyslogListener.

	RemoteSyslogListener(Poco::UInt16 port);
		/// Creates the RemoteSyslogListener.

	void setProperty(const std::string& name, const std::string& value);
		/// Sets the property with the given value.
		///
		/// The following properties are supported:
		///     * port: The UDP port number where to listen for UDP.
		
	std::string getProperty(const std::string& name) const;
		/// Returns the value of the property with the given name.

	void open();
		/// Starts the listener.

	void close();
		/// Stops the listener.

	static void registerChannel();
		/// Registers the channel with the global LoggingFactory.

	static const std::string PROP_PORT;

protected:
	~RemoteSyslogListener();
		/// Destroys the RemoteSyslogListener.

private:
	RemoteUDPListener*      _pListener;
	SyslogParser*           _pParser;
	Poco::Thread            _listener;
	Poco::Thread            _parser;
	Poco::NotificationQueue _queue;
	Poco::UInt16            _port;
};


} } // namespace Poco::Net


#endif // Net_RemoteSyslogListener_INCLUDED
