//
// VerificationErrorArgs.h
//
// $Id: //poco/1.3/NetSSL_OpenSSL/include/Poco/Net/VerificationErrorArgs.h#2 $
//
// Library: NetSSL_OpenSSL
// Package: SSLCore
// Module:  VerificationErrorArgs
//
// Definition of the VerificationErrorArgs class.
//
// Copyright (c) 2006-2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef NetSSL_VerificationErrorArgs_INCLUDED
#define NetSSL_VerificationErrorArgs_INCLUDED


#include "Poco/Net/NetSSL.h"
#include "Poco/Net/X509Certificate.h"


namespace Poco {
namespace Net {


class NetSSL_API VerificationErrorArgs
	/// A utility class for certificate error handling.
{
public:
	VerificationErrorArgs(const X509Certificate& cert, int errDepth, int errNum, const std::string& errMsg);
		/// Creates the VerificationErrorArgs. _ignoreError is per default set to false.

	~VerificationErrorArgs();
		/// Destroys the VerificationErrorArgs.

	const X509Certificate& certificate() const;
		/// Returns the certificate that caused the error.

	int errorDepth() const;
		/// Returns the position of the certificate in the certificate chain.

	int errorNumber() const;
		/// Returns the id of the error

	const std::string& errorMessage() const;
		/// Returns the textual presentation of the errorNumber.

	void setIgnoreError(bool ignoreError);
		/// setIgnoreError to true, if a verification error is judged non-fatal by the user.

	bool getIgnoreError() const;
		/// returns the value of _ignoreError

private:
	X509Certificate	_cert;
	int             _errorDepth;
	int             _errorNumber;
	std::string     _errorMessage; /// Textual representation of the _errorNumber
	bool            _ignoreError;
};


//
// inlines
//
inline const X509Certificate& VerificationErrorArgs::certificate() const
{
	return _cert;
}


inline int VerificationErrorArgs::errorDepth() const
{
	return _errorDepth;
}


inline int VerificationErrorArgs::errorNumber() const
{
	return _errorNumber;
}


inline const std::string& VerificationErrorArgs::errorMessage() const
{
	return _errorMessage;
}


inline void VerificationErrorArgs::setIgnoreError(bool ignoreError)
{
	_ignoreError = ignoreError;
}


inline bool VerificationErrorArgs::getIgnoreError() const
{
	return _ignoreError;
}


} } // namespace Poco::Net


#endif // NetSSL_VerificationErrorArgs_INCLUDED
