------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--             A W S . D I S P A T C H E R S . C A L L B A C K              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2000-2006, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

package body AWS.Dispatchers.Callback is

   ------------
   -- Create --
   ------------

   function Create
     (Callback : Response.Callback)
      return Handler is
   begin
      return (AWS.Dispatchers.Handler with Callback => Callback);
   end Create;

   --------------
   -- Dispatch --
   --------------

   function Dispatch
     (Dispatcher : Handler;
      Request    : Status.Data)
      return Response.Data is
   begin
      return Dispatcher.Callback (Request);
   end Dispatch;

end AWS.Dispatchers.Callback;
