/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassVersionFilter
implements ClassVisitor {
    private final int minimumClassVersion;
    private final int maximumClassVersion;
    private final ClassVisitor classVisitor;

    public ClassVersionFilter(int n, ClassVisitor classVisitor) {
        this(n, Integer.MAX_VALUE, classVisitor);
    }

    public ClassVersionFilter(int n, int n2, ClassVisitor classVisitor) {
        this.minimumClassVersion = n;
        this.maximumClassVersion = n2;
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u4version >= this.minimumClassVersion && programClass.u4version <= this.maximumClassVersion) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

