/*
 * getctty.c - Exec a process, giving it a controlling tty
 *
 * Written 2005 by Werner Almesberger
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/ioctl.h>


int main(int argc,char **argv)
{
    int tty;

    if (argc < 3) {
	fprintf(stderr,"usage: %s tty command ...\n",*argv);
	return 1;
    }
    tty = open(argv[1],O_RDWR);
    if (tty < 0) {
	perror(argv[1]);
	return 1;
    }
    if (dup2(tty,0) < 0 || dup2(tty,1) < 0 || dup2(tty,2) < 0) {
	perror("dup2");
	return 1;
    }
    (void) close(tty);
    if (setsid() < 0) {
	perror("setsid");
	return 1;
    }
    if (ioctl(0,TIOCSCTTY,1) < 0) {
	perror("ioctl(TIOCSCTTY)");
	return 1;
    }
    execvp(argv[2],argv+2);
    perror("execvp");
    return 1;
}
