#!/usr/bin/python

"""Helper function to make daemons out of normal processes."""
# (C) Copyright IBM Corp. 2008-2009
# Licensed under the GPLv2.
import sys
import os
import time

OUTPUT_FILE = "/dev/null"
INPUT_FILE = "/dev/null"
def daemonize():
	"""Fork and detach this process."""
	global OUTPUT_FILE, INPUT_FILE

	#print "parent pid %d\n" % os.getpid()
	# fork
	try:
		pid = os.fork()
		if pid > 0:
			#print "parent %d exiting" % os.getpid()
			sys.exit(0)
	except OSError, e:
		print >>sys.stderr, "Fork failed %d (%s)" % (e.errno, e.strerror)
		sys.exit(1)

	#print "child1 pid %d" % os.getpid()
	# detach
	os.setsid()
	os.umask(0)

	# do second fork?
	try:
		pid = os.fork()
		if pid > 0:
			#print "child1 exiting %d" % os.getpid()
			sys.exit(0)
	except OSError, e:
		print >>sys.stderr, "Fork2 failed %d" % e.errno

	print "Backgrounding as process %d" % os.getpid()

	fp1 = file(INPUT_FILE, "rb")
	if fp1 == None:
		print "Can't open %s?" % OUTPUT_FILE
		sys.exit(1)

	fp2 = file(OUTPUT_FILE, "wb+", 1)
	if fp2 == None:
		print "Can't open %s?" % OUTPUT_FILE
		sys.exit(1)

	fp3 = file(OUTPUT_FILE, "wb+", 0)
	if fp3 == None:
		print "Can't open %s?" % OUTPUT_FILE
		sys.exit(1)

	os.dup2(fp1.fileno(), sys.stdin.fileno())
	os.dup2(fp2.fileno(), sys.stdout.fileno())
	os.dup2(fp3.fileno(), sys.stderr.fileno())
