#!/usr/bin/python
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: FieldMappingDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import PropertyEditor
import vcard
from InputWidgets import TextComboEdit

class vCardFieldMapToPropEdit(TextComboEdit):
    def __init__(self, master, title, descr):
        TextComboEdit.__init__(self, master, nomanualedit=True,
            labelpos=W, label_text='->')
        # ToolTip.ToolTip(self.component('entry'), descr)
        self.setlist(vcard.FIELDNAMES)

class FieldMappingDialog(PropertyEditor.PropertyEditor):
    def __init__(self, master, sourcefields,
                 title="", headline=""):
        propdefs = [('Label', '', headline)]
        for field in sourcefields:
            propdefs.append(('vCardFieldMapTo', field, ''))
        PropertyEditor.PropertyEditor.__init__(self, master, propdefs, title=title,
            save_hook=None, editclasses={'vCardFieldMapTo':vCardFieldMapToPropEdit},
            addcolon='')
    def getvalue(self):
        return map(lambda x: x.get(), self.propwidgets)

if __name__ == "__main__":
    tk = Tk()
    dlg = FieldMappingDialog(tk, ['Name', 'Telefon', 'E-Mail'], 
                         title="FieldMappingDialog Test")
    dlg.activate()
    print dlg.getvalue()
