# CHANGELOG


## v2.4.3 (2026-01-14)

### Bug Fixes

- KeyError: is_consumer during token request
  ([#383](https://github.com/pyenphase/pyenphase/pull/383),
  [`0763a96`](https://github.com/pyenphase/pyenphase/commit/0763a961e7ad2ffefb910f9163f4d73a19253e50))

### Chores

- **ci**: Bump the github-actions group with 3 updates
  ([#378](https://github.com/pyenphase/pyenphase/pull/378),
  [`934a8b9`](https://github.com/pyenphase/pyenphase/commit/934a8b93281b43dce4a2543e89156e94fbc673af))

- **deps**: Bump aiohttp from 3.13.2 to 3.13.3
  ([#379](https://github.com/pyenphase/pyenphase/pull/379),
  [`2d4dbbd`](https://github.com/pyenphase/pyenphase/commit/2d4dbbd4b55238f2decaffd9f95a2fb4fe685795))

- **deps**: Bump orjson from 3.11.4 to 3.11.5
  ([#371](https://github.com/pyenphase/pyenphase/pull/371),
  [`a4448d8`](https://github.com/pyenphase/pyenphase/commit/a4448d8d01502bab51cf9774e4f571c2bebd00c1))

- **deps-dev**: Bump filelock from 3.19.1 to 3.20.1
  ([#375](https://github.com/pyenphase/pyenphase/pull/375),
  [`42a34f8`](https://github.com/pyenphase/pyenphase/commit/42a34f8983eb48633b7a3162c73e21cf8aa71f96))

- **deps-dev**: Bump filelock from 3.20.1 to 3.20.3
  ([#385](https://github.com/pyenphase/pyenphase/pull/385),
  [`5db70cc`](https://github.com/pyenphase/pyenphase/commit/5db70ccc799b532fac9a972967de825c978839b1))

- **deps-dev**: Bump pre-commit from 4.5.0 to 4.5.1
  ([#376](https://github.com/pyenphase/pyenphase/pull/376),
  [`aded8f0`](https://github.com/pyenphase/pyenphase/commit/aded8f0c76243ca5ffce56c2097a912243d7ae04))

- **deps-dev**: Bump pytest from 9.0.1 to 9.0.2
  ([#372](https://github.com/pyenphase/pyenphase/pull/372),
  [`e1149fc`](https://github.com/pyenphase/pyenphase/commit/e1149fcb1a798d49e9092795ca9762613cdc9e78))

- **deps-dev**: Bump python-jsonpath from 2.0.1 to 2.0.2
  ([#381](https://github.com/pyenphase/pyenphase/pull/381),
  [`4d6bb9e`](https://github.com/pyenphase/pyenphase/commit/4d6bb9ea31a1e84915f521f8090919a69dc7cfe3))

- **deps-dev**: Bump urllib3 from 2.5.0 to 2.6.0
  ([#370](https://github.com/pyenphase/pyenphase/pull/370),
  [`f659bef`](https://github.com/pyenphase/pyenphase/commit/f659befcc7e74384cba42d42d4ecd05e3bbab6b9))

- **deps-dev**: Bump urllib3 from 2.6.0 to 2.6.3
  ([#380](https://github.com/pyenphase/pyenphase/pull/380),
  [`7bfd9d1`](https://github.com/pyenphase/pyenphase/commit/7bfd9d1173ce2086b02edecf5db36ffea457e590))

- **deps-dev**: Bump virtualenv from 20.34.0 to 20.36.1
  ([#384](https://github.com/pyenphase/pyenphase/pull/384),
  [`a5b179e`](https://github.com/pyenphase/pyenphase/commit/a5b179e5a424f4be63c08166c7a7ed1172fb0375))

- **pre-commit.ci**: Pre-commit autoupdate ([#382](https://github.com/pyenphase/pyenphase/pull/382),
  [`09650fe`](https://github.com/pyenphase/pyenphase/commit/09650fe7e3c9fb44f8563eec1eb61e4cd015b55a))

- **pre-commit.ci**: Pre-commit autoupdate ([#377](https://github.com/pyenphase/pyenphase/pull/377),
  [`334b23f`](https://github.com/pyenphase/pyenphase/commit/334b23f1080bfc32cb9b3ae7b98aee69144e5c95))

- **pre-commit.ci**: Pre-commit autoupdate ([#374](https://github.com/pyenphase/pyenphase/pull/374),
  [`013eb30`](https://github.com/pyenphase/pyenphase/commit/013eb30ee0fa8eaf5a4c3058b645f8e795b888db))

- **pre-commit.ci**: Pre-commit autoupdate ([#373](https://github.com/pyenphase/pyenphase/pull/373),
  [`61d1346`](https://github.com/pyenphase/pyenphase/commit/61d1346b44d1a92a5412ef20e033f3d982b49bdd))

- **pre-commit.ci**: Pre-commit autoupdate ([#369](https://github.com/pyenphase/pyenphase/pull/369),
  [`6ef3254`](https://github.com/pyenphase/pyenphase/commit/6ef3254079b18bbd558697341227f796b125d1e5))


## v2.4.2 (2025-11-28)

### Bug Fixes

- Relax request retry timeout to prevent 11pm timeouts
  ([#363](https://github.com/pyenphase/pyenphase/pull/363),
  [`b2ce22f`](https://github.com/pyenphase/pyenphase/commit/b2ce22f1e3e34c2c235972591eb0592a90799cca))

### Chores

- Bump pytest-asyncio to 1.3.0 ([#360](https://github.com/pyenphase/pyenphase/pull/360),
  [`4390363`](https://github.com/pyenphase/pyenphase/commit/4390363d6b7987d24a4b320afaf8c3f6d6ed2ac1))

- **ci**: Bump browniebroke/hacktoberfest-labeler-action
  ([#357](https://github.com/pyenphase/pyenphase/pull/357),
  [`1d32114`](https://github.com/pyenphase/pyenphase/commit/1d321148f3815389cfc8ec39e750f024fdca8269))

- **ci**: Bump browniebroke/hacktoberfest-labeler-action from 2.4.0 to 2.6.0 in the github-actions
  group ([#357](https://github.com/pyenphase/pyenphase/pull/357),
  [`1d32114`](https://github.com/pyenphase/pyenphase/commit/1d321148f3815389cfc8ec39e750f024fdca8269))

- **deps**: Bump aiohttp from 3.13.0 to 3.13.1
  ([#353](https://github.com/pyenphase/pyenphase/pull/353),
  [`52b6475`](https://github.com/pyenphase/pyenphase/commit/52b6475a2bfa9eb7a4d22a4e45099e1b0bd52738))

- **deps**: Bump aiohttp from 3.13.1 to 3.13.2
  ([#358](https://github.com/pyenphase/pyenphase/pull/358),
  [`5f9a7c4`](https://github.com/pyenphase/pyenphase/commit/5f9a7c4524e48cab307dcb7fe71dc4f9bd469a3d))

- **deps**: Bump orjson from 3.11.3 to 3.11.4
  ([#355](https://github.com/pyenphase/pyenphase/pull/355),
  [`c1bb209`](https://github.com/pyenphase/pyenphase/commit/c1bb20965f51872d80afd257ae558d8af27bca76))

- **deps-dev**: Bump pre-commit from 4.3.0 to 4.4.0
  ([#361](https://github.com/pyenphase/pyenphase/pull/361),
  [`13b36ce`](https://github.com/pyenphase/pyenphase/commit/13b36ced5a8bba4363e7d5e07b800538854a3622))

- **deps-dev**: Bump pre-commit from 4.4.0 to 4.5.0
  ([#366](https://github.com/pyenphase/pyenphase/pull/366),
  [`2980ca3`](https://github.com/pyenphase/pyenphase/commit/2980ca33cfada3bd4cd1e9349c5787c0448f36e2))

- **deps-dev**: Bump pytest from 8.4.2 to 9.0.0
  ([#360](https://github.com/pyenphase/pyenphase/pull/360),
  [`4390363`](https://github.com/pyenphase/pyenphase/commit/4390363d6b7987d24a4b320afaf8c3f6d6ed2ac1))

- **deps-dev**: Bump pytest from 9.0.0 to 9.0.1
  ([#364](https://github.com/pyenphase/pyenphase/pull/364),
  [`d898a4a`](https://github.com/pyenphase/pyenphase/commit/d898a4a69a6a75c4e087a6cca808c3d9ab666982))

- **pre-commit.ci**: Pre-commit autoupdate ([#367](https://github.com/pyenphase/pyenphase/pull/367),
  [`019cdf9`](https://github.com/pyenphase/pyenphase/commit/019cdf9a9c810d281e97da987d7a5f3d8783b16a))

- **pre-commit.ci**: Pre-commit autoupdate ([#365](https://github.com/pyenphase/pyenphase/pull/365),
  [`c7e2cd5`](https://github.com/pyenphase/pyenphase/commit/c7e2cd5f4dd4a785ec60c913e1f84fc7d29fea1c))

- **pre-commit.ci**: Pre-commit autoupdate ([#362](https://github.com/pyenphase/pyenphase/pull/362),
  [`726009c`](https://github.com/pyenphase/pyenphase/commit/726009ca793296619cbd9f0be5307d4628bd15e4))

- **pre-commit.ci**: Pre-commit autoupdate ([#359](https://github.com/pyenphase/pyenphase/pull/359),
  [`ff6bec0`](https://github.com/pyenphase/pyenphase/commit/ff6bec00930fc23929850be56e3b511f2c1cdc05))

- **pre-commit.ci**: Pre-commit autoupdate ([#354](https://github.com/pyenphase/pyenphase/pull/354),
  [`1bff216`](https://github.com/pyenphase/pyenphase/commit/1bff2165fe96607e5d0c48c96f0e76ed86e47a3c))

### Documentation

- Fix table layout for inverter data ([#356](https://github.com/pyenphase/pyenphase/pull/356),
  [`ea66c7b`](https://github.com/pyenphase/pyenphase/commit/ea66c7b92f632f0f709c5d0797914acd66fdc35a))

- Move endpoint list to endpoint topic and add info and home
  ([#368](https://github.com/pyenphase/pyenphase/pull/368),
  [`659950d`](https://github.com/pyenphase/pyenphase/commit/659950d7e2c42d0f82f85a4156298f97a48db742))

### Testing

- Remove redundant ct tests ([#349](https://github.com/pyenphase/pyenphase/pull/349),
  [`3a515dc`](https://github.com/pyenphase/pyenphase/commit/3a515dcc1720cb6f280c60423136827a5b1558ae))


## v2.4.1 (2025-10-19)

### Bug Fixes

- Show used method in debug when sending data
  ([#352](https://github.com/pyenphase/pyenphase/pull/352),
  [`02bc58f`](https://github.com/pyenphase/pyenphase/commit/02bc58f349758510716c45b9331aafaddb070f17))

### Chores

- **deps**: Bump aiohttp from 3.12.15 to 3.13.0
  ([#351](https://github.com/pyenphase/pyenphase/pull/351),
  [`d580d6f`](https://github.com/pyenphase/pyenphase/commit/d580d6f271e8cb5d47e0c45e538e3968957cf8d2))

- **pre-commit.ci**: Pre-commit autoupdate ([#350](https://github.com/pyenphase/pyenphase/pull/350),
  [`fcac787`](https://github.com/pyenphase/pyenphase/commit/fcac78776fbe0b96d7b5f0208341060c38b2761f))


## v2.4.0 (2025-10-03)

### Chores

- Add python-jsonpath and pre-commit to dev group dependencies
  ([#340](https://github.com/pyenphase/pyenphase/pull/340),
  [`c762e13`](https://github.com/pyenphase/pyenphase/commit/c762e1320be397642ba29f0b06a84cbd2d0d4640))

- Switch dev tools to aiohttp ([#321](https://github.com/pyenphase/pyenphase/pull/321),
  [`9c0d67a`](https://github.com/pyenphase/pyenphase/commit/9c0d67a35d6d61277a9931dc2a5699455f174eac))

- **ci**: Bump the github-actions group with 7 updates
  ([#346](https://github.com/pyenphase/pyenphase/pull/346),
  [`9e44782`](https://github.com/pyenphase/pyenphase/commit/9e44782b5226360cdd0bc5e41dabf6963490b456))

- **deps**: Bump lxml from 6.0.0 to 6.0.1 ([#329](https://github.com/pyenphase/pyenphase/pull/329),
  [`98325ba`](https://github.com/pyenphase/pyenphase/commit/98325bae50e87ff26279b4a63af259d4ad65bd78))

- **deps**: Bump lxml from 6.0.1 to 6.0.2 ([#342](https://github.com/pyenphase/pyenphase/pull/342),
  [`b75088a`](https://github.com/pyenphase/pyenphase/commit/b75088af82810352448e7e526dacde0359d6b9a8))

- **deps**: Bump orjson from 3.11.1 to 3.11.2
  ([#328](https://github.com/pyenphase/pyenphase/pull/328),
  [`20b9806`](https://github.com/pyenphase/pyenphase/commit/20b98063cf5c98ef6c33e5288835221acbd123eb))

- **deps**: Bump orjson from 3.11.2 to 3.11.3
  ([#331](https://github.com/pyenphase/pyenphase/pull/331),
  [`0ebee3f`](https://github.com/pyenphase/pyenphase/commit/0ebee3fba6cea2548bb30ecb10dd047043145068))

- **deps-dev**: Bump pytest from 8.4.1 to 8.4.2
  ([#333](https://github.com/pyenphase/pyenphase/pull/333),
  [`fee3b88`](https://github.com/pyenphase/pyenphase/commit/fee3b8843c817a911cfb76ced9cb66f33dea2aa9))

- **deps-dev**: Bump pytest-asyncio from 1.1.0 to 1.2.0
  ([#338](https://github.com/pyenphase/pyenphase/pull/338),
  [`211f003`](https://github.com/pyenphase/pyenphase/commit/211f003d935a30c9a16b2300c9f4acd94c19b9ef))

- **deps-dev**: Bump pytest-cov from 6.2.1 to 6.3.0
  ([#332](https://github.com/pyenphase/pyenphase/pull/332),
  [`4cb0466`](https://github.com/pyenphase/pyenphase/commit/4cb04661a73ba124df7bb047243e7022f4f55994))

- **deps-dev**: Bump pytest-cov from 6.3.0 to 7.0.0
  ([#337](https://github.com/pyenphase/pyenphase/pull/337),
  [`59414ca`](https://github.com/pyenphase/pyenphase/commit/59414cab696139777c0c617272a83d68895a0d3b))

- **deps-dev**: Bump syrupy from 4.9.1 to 5.0.0
  ([#344](https://github.com/pyenphase/pyenphase/pull/344),
  [`e28c018`](https://github.com/pyenphase/pyenphase/commit/e28c01893ad34935321d84a10c8d539f02cd7e79))

- **pre-commit.ci**: Pre-commit autoupdate ([#345](https://github.com/pyenphase/pyenphase/pull/345),
  [`bb6d129`](https://github.com/pyenphase/pyenphase/commit/bb6d12959f7fecfaf3814e94ad893bbe838e0ac5))

- **pre-commit.ci**: Pre-commit autoupdate ([#343](https://github.com/pyenphase/pyenphase/pull/343),
  [`b2af0fe`](https://github.com/pyenphase/pyenphase/commit/b2af0fe42edb231dd328b267c34d1fd54c9b82ea))

- **pre-commit.ci**: Pre-commit autoupdate ([#339](https://github.com/pyenphase/pyenphase/pull/339),
  [`d3628c0`](https://github.com/pyenphase/pyenphase/commit/d3628c0b2ef2a1cf15e43b496339a62f5fe12d4f))

- **pre-commit.ci**: Pre-commit autoupdate ([#334](https://github.com/pyenphase/pyenphase/pull/334),
  [`eada400`](https://github.com/pyenphase/pyenphase/commit/eada4004affb8ba61291525c1c950d8d186187f4))

- **pre-commit.ci**: Pre-commit autoupdate ([#330](https://github.com/pyenphase/pyenphase/pull/330),
  [`3d6e1ad`](https://github.com/pyenphase/pyenphase/commit/3d6e1ad16d6c9b4d6a855f3e9515b4a3e60491f3))

- **pre-commit.ci**: Pre-commit autoupdate ([#327](https://github.com/pyenphase/pyenphase/pull/327),
  [`e3c8033`](https://github.com/pyenphase/pyenphase/commit/e3c803303eb95cba7f431deeb45cdffc0a1ccec0))

- **pre-commit.ci**: Pre-commit autoupdate ([#324](https://github.com/pyenphase/pyenphase/pull/324),
  [`71b8dea`](https://github.com/pyenphase/pyenphase/commit/71b8deacd37dac82c3c859dd56ed33ad1e047d70))

### Documentation

- Add descriptions of production and consumption model data and mapping to json data
  ([#325](https://github.com/pyenphase/pyenphase/pull/325),
  [`ffbfc12`](https://github.com/pyenphase/pyenphase/commit/ffbfc12e18316f0fabca9dd0272a46531a0a55e1))

- Re-add request response description ([#323](https://github.com/pyenphase/pyenphase/pull/323),
  [`2e9eeb3`](https://github.com/pyenphase/pyenphase/commit/2e9eeb35a5880de086fcab781a771c87ed91caaa))

- Some doc reorg, repairs, updates, and cleanups
  ([#322](https://github.com/pyenphase/pyenphase/pull/322),
  [`9b9da7c`](https://github.com/pyenphase/pyenphase/commit/9b9da7c33691bdad930ac29d46c72c936c36bd08))

### Features

- Add backfeed, load, evse and pv3p CT data
  ([#341](https://github.com/pyenphase/pyenphase/pull/341),
  [`350a645`](https://github.com/pyenphase/pyenphase/commit/350a645fd1c2fdf63e46ef4e43571becbb871545))

- Add feedback, load, evse and pv3p CT to reported CT data
  ([#341](https://github.com/pyenphase/pyenphase/pull/341),
  [`350a645`](https://github.com/pyenphase/pyenphase/commit/350a645fd1c2fdf63e46ef4e43571becbb871545))

### Refactoring

- Add generic empty data structures for CT data
  ([#336](https://github.com/pyenphase/pyenphase/pull/336),
  [`f8b53c1`](https://github.com/pyenphase/pyenphase/commit/f8b53c1c7ae37b8b362bc1c7a8d88ab9558f9625))

- Make unused variable a dummy ([#339](https://github.com/pyenphase/pyenphase/pull/339),
  [`d3628c0`](https://github.com/pyenphase/pyenphase/commit/d3628c0b2ef2a1cf15e43b496339a62f5fe12d4f))

- Replace individual meter_type with list of found types
  ([#335](https://github.com/pyenphase/pyenphase/pull/335),
  [`1e7c499`](https://github.com/pyenphase/pyenphase/commit/1e7c499e91c30c6ecffaee2df02e01b036ca5939))


## v2.3.1 (2025-08-16)

### Bug Fixes

- Error asyncio unclosed client session at app close
  ([#319](https://github.com/pyenphase/pyenphase/pull/319),
  [`b59a71d`](https://github.com/pyenphase/pyenphase/commit/b59a71ddcd25803d14c24ae6857f86f463ab36e8))

### Chores

- Enable additional ruff linting rules for code quality improvements
  ([#320](https://github.com/pyenphase/pyenphase/pull/320),
  [`b10df2f`](https://github.com/pyenphase/pyenphase/commit/b10df2fd7dc4a7198bfad9f9b265443df7840683))


## v2.3.0 (2025-08-13)

### Chores

- **deps**: Bump aiohttp from 3.12.14 to 3.12.15
  ([#316](https://github.com/pyenphase/pyenphase/pull/316),
  [`83d07aa`](https://github.com/pyenphase/pyenphase/commit/83d07aaf8bc7ee5f2fa65e58ed940b79a572a79a))

- **deps**: Bump awesomeversion from 25.5.0 to 25.8.0
  ([#317](https://github.com/pyenphase/pyenphase/pull/317),
  [`2144c90`](https://github.com/pyenphase/pyenphase/commit/2144c909c96d2870cff5d342eb9156642f4f0630))

- **deps**: Bump orjson from 3.10.18 to 3.11.1
  ([#314](https://github.com/pyenphase/pyenphase/pull/314),
  [`231de76`](https://github.com/pyenphase/pyenphase/commit/231de768e6f3594caadd1eac3bf35e0bf0452f76))

- **deps-dev**: Bump pytest-asyncio from 1.0.0 to 1.1.0
  ([#315](https://github.com/pyenphase/pyenphase/pull/315),
  [`04cbb38`](https://github.com/pyenphase/pyenphase/commit/04cbb38344c38a3476b1f17f80b07fc381846df6))

- **pre-commit.ci**: Pre-commit autoupdate ([#318](https://github.com/pyenphase/pyenphase/pull/318),
  [`6ed4108`](https://github.com/pyenphase/pyenphase/commit/6ed4108d17c956757b8b36d83d70ab2508c68912))

- **pre-commit.ci**: Pre-commit autoupdate ([#312](https://github.com/pyenphase/pyenphase/pull/312),
  [`e5560b7`](https://github.com/pyenphase/pyenphase/commit/e5560b7463b39ab5ab8f62663b39af5d22401814))

### Features

- Add iq meter collar and c6 combiner data ([#311](https://github.com/pyenphase/pyenphase/pull/311),
  [`47a2365`](https://github.com/pyenphase/pyenphase/commit/47a23655e426da3346e150e759fc91a03904d52a))


## v2.2.3 (2025-07-29)

### Bug Fixes

- 3RD-PV is not a valid DryContactType ([#313](https://github.com/pyenphase/pyenphase/pull/313),
  [`de641a6`](https://github.com/pyenphase/pyenphase/commit/de641a69330e87ad8b854dc43c127804d5e4d314))

- 3RD-PV is not a valid DryContactType - add new type
  ([#313](https://github.com/pyenphase/pyenphase/pull/313),
  [`de641a6`](https://github.com/pyenphase/pyenphase/commit/de641a69330e87ad8b854dc43c127804d5e4d314))

### Chores

- **deps**: Bump aiohttp from 3.12.13 to 3.12.14
  ([#307](https://github.com/pyenphase/pyenphase/pull/307),
  [`b1be28b`](https://github.com/pyenphase/pyenphase/commit/b1be28ba71960b8eacb1a1d110631adb5703313b))

- **pre-commit.ci**: Pre-commit autoupdate ([#310](https://github.com/pyenphase/pyenphase/pull/310),
  [`189adbc`](https://github.com/pyenphase/pyenphase/commit/189adbc963488ada345e7873818bd36483d0c2ef))

- **pre-commit.ci**: Pre-commit autoupdate ([#308](https://github.com/pyenphase/pyenphase/pull/308),
  [`7378188`](https://github.com/pyenphase/pyenphase/commit/7378188512565b6a0fff311aaf029f600d4dc7f4))


## v2.2.2 (2025-07-16)

### Bug Fixes

- Fallback to v1 inverter endpoint if installed inverters exceed deviceDataLimit
  ([#305](https://github.com/pyenphase/pyenphase/pull/305),
  [`c62c048`](https://github.com/pyenphase/pyenphase/commit/c62c0482b98bcbfdd01010905ecf876f20e0eae1))

- Fallback to v1 inverter endpoint if number of installed inverters exceed deviceDataLimit
  ([#305](https://github.com/pyenphase/pyenphase/pull/305),
  [`c62c048`](https://github.com/pyenphase/pyenphase/commit/c62c0482b98bcbfdd01010905ecf876f20e0eae1))

### Chores

- **ci**: Bump the github-actions group with 2 updates
  ([#302](https://github.com/pyenphase/pyenphase/pull/302),
  [`21f28de`](https://github.com/pyenphase/pyenphase/commit/21f28decbd7566844bc10fce1900ae8342db68d2))

- **pre-commit.ci**: Pre-commit autoupdate ([#306](https://github.com/pyenphase/pyenphase/pull/306),
  [`50c3163`](https://github.com/pyenphase/pyenphase/commit/50c3163149acda115a1591cafa9cfd1d9779648e))


## v2.2.1 (2025-07-06)

### Bug Fixes

- Early v7 firmware returns 401 on production probe with aiohttp.
  ([#304](https://github.com/pyenphase/pyenphase/pull/304),
  [`86f4df2`](https://github.com/pyenphase/pyenphase/commit/86f4df2aff689458312e7b0bae39dc8ecc565ed4))


## v2.2.0 (2025-07-03)

### Chores

- **deps**: Bump lxml from 5.4.0 to 6.0.0 ([#300](https://github.com/pyenphase/pyenphase/pull/300),
  [`c9a668e`](https://github.com/pyenphase/pyenphase/commit/c9a668eee25dc80293399ac324b73611f9f6b46d))

- **deps-dev**: Bump pytest from 8.4.0 to 8.4.1
  ([#298](https://github.com/pyenphase/pyenphase/pull/298),
  [`28439b6`](https://github.com/pyenphase/pyenphase/commit/28439b6da778622d20dc715a8152e9feb12e6f08))

- **pre-commit.ci**: Auto fixes ([#299](https://github.com/pyenphase/pyenphase/pull/299),
  [`1e1087e`](https://github.com/pyenphase/pyenphase/commit/1e1087ec3fc18f3f1e89544ab583a385cd49cb53))

- **pre-commit.ci**: Pre-commit autoupdate ([#301](https://github.com/pyenphase/pyenphase/pull/301),
  [`10451ab`](https://github.com/pyenphase/pyenphase/commit/10451ab48f8ef89f9fc69273ac83617fd960353a))

- **pre-commit.ci**: Pre-commit autoupdate ([#299](https://github.com/pyenphase/pyenphase/pull/299),
  [`1e1087e`](https://github.com/pyenphase/pyenphase/commit/1e1087ec3fc18f3f1e89544ab583a385cd49cb53))

### Features

- Add debug logging for HTTP errors and authentication failures
  ([#303](https://github.com/pyenphase/pyenphase/pull/303),
  [`3a9fb42`](https://github.com/pyenphase/pyenphase/commit/3a9fb4230fc52b2040b1fc864ea72ff06b647202))


## v2.1.2 (2025-06-19)

### Bug Fixes

- Set change log mode to init to regenerate missed 2.1.0
  ([#297](https://github.com/pyenphase/pyenphase/pull/297),
  [`39289b4`](https://github.com/pyenphase/pyenphase/commit/39289b4125dbb7a14e78d61ab57a3966895c59e8))

- Set change log mode to init to regenerated missed 2.1.0
  ([#297](https://github.com/pyenphase/pyenphase/pull/297),
  [`39289b4`](https://github.com/pyenphase/pyenphase/commit/39289b4125dbb7a14e78d61ab57a3966895c59e8))


## v2.1.1 (2025-06-19)

### Bug Fixes

- Empty commit to force changelog update ([#296](https://github.com/pyenphase/pyenphase/pull/296),
  [`f81a4ee`](https://github.com/pyenphase/pyenphase/commit/f81a4eee8fe7b96e96e5f5d350765fe24b94a128))

### Chores

- Add insertion flag to changelog ([#290](https://github.com/pyenphase/pyenphase/pull/290),
  [`eb7087e`](https://github.com/pyenphase/pyenphase/commit/eb7087e10ea4e427c818a0f2ef7b0123ec38b840))

- **deps**: Bump aiohttp from 3.12.11 to 3.12.13
  ([#292](https://github.com/pyenphase/pyenphase/pull/292),
  [`db1b8ef`](https://github.com/pyenphase/pyenphase/commit/db1b8ef06c0b6a0b2f39dc609c75815800a3aa3c))

- **deps-dev**: Bump pytest-asyncio from 0.26.0 to 1.0.0
  ([#291](https://github.com/pyenphase/pyenphase/pull/291),
  [`0c40ea3`](https://github.com/pyenphase/pyenphase/commit/0c40ea3e7f3048fbed4c815a31eb976b5a2cacd4))

- **deps-dev**: Bump pytest-cov from 6.1.1 to 6.2.1
  ([#293](https://github.com/pyenphase/pyenphase/pull/293),
  [`bbf0f5a`](https://github.com/pyenphase/pyenphase/commit/bbf0f5ab92416775abde872fd7b31f5f7f0ece56))

- **deps-dev**: Bump requests from 2.32.3 to 2.32.4
  ([#289](https://github.com/pyenphase/pyenphase/pull/289),
  [`919bda4`](https://github.com/pyenphase/pyenphase/commit/919bda470025f19f017edba64bedf7f7df0897c8))

- **deps-dev**: Bump urllib3 from 2.2.2 to 2.5.0
  ([#295](https://github.com/pyenphase/pyenphase/pull/295),
  [`2b8d6f2`](https://github.com/pyenphase/pyenphase/commit/2b8d6f2e74ffceefb6e094c92932d66b3c4f0d22))

- **pre-commit.ci**: Pre-commit autoupdate ([#294](https://github.com/pyenphase/pyenphase/pull/294),
  [`17f9387`](https://github.com/pyenphase/pyenphase/commit/17f9387d76fd0254a126193ac9785381e84b0427))

- **pre-commit.ci**: Pre-commit autoupdate ([#288](https://github.com/pyenphase/pyenphase/pull/288),
  [`353dde0`](https://github.com/pyenphase/pyenphase/commit/353dde00af0e15fc8a7a0ede961758944af87ea8))


## v2.1.0 (2025-06-10)

### Chores

- **ci**: Bump the github-actions group with 2 updates
  ([#282](https://github.com/pyenphase/pyenphase/pull/282),
  [`249f2c7`](https://github.com/pyenphase/pyenphase/commit/249f2c77460bc9f586b4d3f17d410b37e58e2a94))

- **deps**: Bump aiohttp from 3.12.9 to 3.12.11
  ([#286](https://github.com/pyenphase/pyenphase/pull/286),
  [`54f9d18`](https://github.com/pyenphase/pyenphase/commit/54f9d188dcdd95b4d39c8a3a98f191eb7f5edbb8))

- **deps-dev**: Bump pytest from 8.3.5 to 8.4.0
  ([#287](https://github.com/pyenphase/pyenphase/pull/287),
  [`65543b6`](https://github.com/pyenphase/pyenphase/commit/65543b62931da67120a37f87175d522cd5928f98))

### Features

- Use `/ivp/pdm/device_data` to obtain detailed device statistics
  ([#281](https://github.com/pyenphase/pyenphase/pull/281),
  [`66872c6`](https://github.com/pyenphase/pyenphase/commit/66872c6743ee0b0c57a868cb5788f46d22c52b5f))


## v2.0.1 (2025-06-07)

### Bug Fixes

- Pass middleware as a tuple ([#285](https://github.com/pyenphase/pyenphase/pull/285),
  [`7d140c5`](https://github.com/pyenphase/pyenphase/commit/7d140c5e7d61f31afea0715b53381fcd7025ac65))


## v2.0.0 (2025-06-06)

### Chores

- **deps**: Bump awesomeversion from 24.6.0 to 25.5.0
  ([#283](https://github.com/pyenphase/pyenphase/pull/283),
  [`1f02a1f`](https://github.com/pyenphase/pyenphase/commit/1f02a1fd18193bd931aa771926b23c0f10791560))

- **pre-commit.ci**: Pre-commit autoupdate ([#284](https://github.com/pyenphase/pyenphase/pull/284),
  [`9632e90`](https://github.com/pyenphase/pyenphase/commit/9632e9047614dbc0bea13f820ed23be1734d6cd1))

- **pre-commit.ci**: Pre-commit autoupdate ([#278](https://github.com/pyenphase/pyenphase/pull/278),
  [`d0581b8`](https://github.com/pyenphase/pyenphase/commit/d0581b89821fa67aaf4509d0e9e46b86799bf5d9))

- **pre-commit.ci**: Pre-commit autoupdate ([#276](https://github.com/pyenphase/pyenphase/pull/276),
  [`76ba3a6`](https://github.com/pyenphase/pyenphase/commit/76ba3a6676632008a81b38185792f97048f6dbb1))

### Features

- Migrate to aiohttp ([#277](https://github.com/pyenphase/pyenphase/pull/277),
  [`ebcc2c3`](https://github.com/pyenphase/pyenphase/commit/ebcc2c307bcbdabc01a46ae9d7964ff04cea0ea7))


## v1.26.1 (2025-05-10)

### Bug Fixes

- Metered envoy without ct reports wrong production in fw 8.2.4264
  ([#275](https://github.com/pyenphase/pyenphase/pull/275),
  [`a998bab`](https://github.com/pyenphase/pyenphase/commit/a998bab2fbc3251371b2833100d8cf16de098088))

### Chores

- **deps**: Bump h11 from 0.14.0 to 0.16.0 ([#269](https://github.com/pyenphase/pyenphase/pull/269),
  [`a6c8fce`](https://github.com/pyenphase/pyenphase/commit/a6c8fce90afe016de64af7df954ae85a8158c419))

- **deps**: Bump lxml from 5.3.2 to 5.4.0 ([#270](https://github.com/pyenphase/pyenphase/pull/270),
  [`ffced2f`](https://github.com/pyenphase/pyenphase/commit/ffced2f4466bc29d57fbdfeefb430218c6fdd650))

- **deps**: Bump orjson from 3.10.16 to 3.10.18
  ([#272](https://github.com/pyenphase/pyenphase/pull/272),
  [`4cee284`](https://github.com/pyenphase/pyenphase/commit/4cee2843989981b947825d33cf64b0f1291007e0))

- **pre-commit.ci**: Pre-commit autoupdate ([#273](https://github.com/pyenphase/pyenphase/pull/273),
  [`03af646`](https://github.com/pyenphase/pyenphase/commit/03af6469eb0560bafc86e0711073ce6d0011b95c))

- **pre-commit.ci**: Pre-commit autoupdate ([#271](https://github.com/pyenphase/pyenphase/pull/271),
  [`b53cbae`](https://github.com/pyenphase/pyenphase/commit/b53cbaecbd995f978a37372a5f7ee590d153ce09))


## v1.26.0 (2025-04-25)

### Chores

- **deps**: Bump lxml from 5.3.1 to 5.3.2 ([#262](https://github.com/pyenphase/pyenphase/pull/262),
  [`eea42ef`](https://github.com/pyenphase/pyenphase/commit/eea42ef0700ca583728a650dfec6c96fbe18f74b))

- **deps**: Bump tenacity from 9.0.0 to 9.1.2
  ([#263](https://github.com/pyenphase/pyenphase/pull/263),
  [`7a3e38b`](https://github.com/pyenphase/pyenphase/commit/7a3e38b0fdb0d46a32f4b43e1efc86c07383af80))

- **deps-dev**: Bump pytest-cov from 6.0.0 to 6.1.1
  ([#264](https://github.com/pyenphase/pyenphase/pull/264),
  [`aa99971`](https://github.com/pyenphase/pyenphase/commit/aa99971016ca1808a1a90f704c4771ec754d2e97))

- **pre-commit.ci**: Pre-commit autoupdate ([#267](https://github.com/pyenphase/pyenphase/pull/267),
  [`e3f555c`](https://github.com/pyenphase/pyenphase/commit/e3f555c246561f35c1befee1a25c880485803829))

- **pre-commit.ci**: Pre-commit autoupdate ([#266](https://github.com/pyenphase/pyenphase/pull/266),
  [`ff371d0`](https://github.com/pyenphase/pyenphase/commit/ff371d0b24292d73605b41e437a74c3d31efde0d))

- **pre-commit.ci**: Pre-commit autoupdate ([#265](https://github.com/pyenphase/pyenphase/pull/265),
  [`5f5b120`](https://github.com/pyenphase/pyenphase/commit/5f5b12053df3c4165c2e6df130afafeeeeb703b1))

### Features

- Add method to return envoy active interface settings
  ([#268](https://github.com/pyenphase/pyenphase/pull/268),
  [`70ff7ac`](https://github.com/pyenphase/pyenphase/commit/70ff7ac6e1a01b6ea62e1ea6df2638cddd4215e1))

### Testing

- De-duplicate fixture loading by using single fixture load function
  ([#261](https://github.com/pyenphase/pyenphase/pull/261),
  [`8ec3fba`](https://github.com/pyenphase/pyenphase/commit/8ec3fba4c1769bd1df702b5db182ec18cb0a6d2c))

- De-duplicate fixture loading by using single function
  ([#261](https://github.com/pyenphase/pyenphase/pull/261),
  [`8ec3fba`](https://github.com/pyenphase/pyenphase/commit/8ec3fba4c1769bd1df702b5db182ec18cb0a6d2c))

- Run blocking calls in executor ([#261](https://github.com/pyenphase/pyenphase/pull/261),
  [`8ec3fba`](https://github.com/pyenphase/pyenphase/commit/8ec3fba4c1769bd1df702b5db182ec18cb0a6d2c))


## v1.25.5 (2025-04-02)

### Bug Fixes

- V4 metered without cons CT crashes with KeyError: 'measurementType'
  ([#259](https://github.com/pyenphase/pyenphase/pull/259),
  [`da11b5b`](https://github.com/pyenphase/pyenphase/commit/da11b5bd84463188e6f98eb823a1a2f8420fde60))

### Chores

- Lock due to https://github.com/dependabot/dependabot-core/pull/11275
  ([#236](https://github.com/pyenphase/pyenphase/pull/236),
  [`dffeee0`](https://github.com/pyenphase/pyenphase/commit/dffeee0becae187b154e8c63b56ccfdd6b6abaae))

- Rebuild poetry.lock ([#245](https://github.com/pyenphase/pyenphase/pull/245),
  [`351036f`](https://github.com/pyenphase/pyenphase/commit/351036fa541075073c5bec8c30cfdf1dfc02a613))

- Replace tenacity .retry.statistics by .statistics
  ([#236](https://github.com/pyenphase/pyenphase/pull/236),
  [`dffeee0`](https://github.com/pyenphase/pyenphase/commit/dffeee0becae187b154e8c63b56ccfdd6b6abaae))

- Restore some legacy poetry keys to fix dependabot
  ([#232](https://github.com/pyenphase/pyenphase/pull/232),
  [`48e930e`](https://github.com/pyenphase/pyenphase/commit/48e930e51ceb9bada135b7fa6a064dc36c5b78de))

- Update dependabot.yml to force re-run attempt
  ([#231](https://github.com/pyenphase/pyenphase/pull/231),
  [`baabe6e`](https://github.com/pyenphase/pyenphase/commit/baabe6e5ddfe3f13c75c8b638b90f96cb7c990ec))

- Update dependabot.yml to force rerun
  ([`ba8f487`](https://github.com/pyenphase/pyenphase/commit/ba8f487f1f036304b7433276fffb23a3c77dc436))

- Update dev status to production/stable ([#243](https://github.com/pyenphase/pyenphase/pull/243),
  [`d97f24c`](https://github.com/pyenphase/pyenphase/commit/d97f24cb14451ea75d16e43e796e0ea968c38ff7))

- Update poetry.lock ([#248](https://github.com/pyenphase/pyenphase/pull/248),
  [`fb8ad43`](https://github.com/pyenphase/pyenphase/commit/fb8ad430a676ce43d22e9210d5e18e06eab3606d))

- **ci**: Bump the github-actions group with 2 updates
  ([#247](https://github.com/pyenphase/pyenphase/pull/247),
  [`31475ff`](https://github.com/pyenphase/pyenphase/commit/31475ffd7772b5bab3915c29aa2f52e789f8aec1))

- **deps**: Bump orjson from 3.10.15 to 3.10.16
  ([#256](https://github.com/pyenphase/pyenphase/pull/256),
  [`abfd861`](https://github.com/pyenphase/pyenphase/commit/abfd8617dd006b3d40ac8a08bcef222c9ad14928))

- **deps**: Bump tenacity from 8.2.3 to 9.0.0
  ([#236](https://github.com/pyenphase/pyenphase/pull/236),
  [`dffeee0`](https://github.com/pyenphase/pyenphase/commit/dffeee0becae187b154e8c63b56ccfdd6b6abaae))

- **deps-dev**: Bump jinja2 from 3.1.5 to 3.1.6
  ([#251](https://github.com/pyenphase/pyenphase/pull/251),
  [`f0b50de`](https://github.com/pyenphase/pyenphase/commit/f0b50dea3f98374821d0d01055d95c3bcba0ff65))

- **deps-dev**: Bump myst-parser from 4.0.0 to 4.0.1
  ([#240](https://github.com/pyenphase/pyenphase/pull/240),
  [`5423632`](https://github.com/pyenphase/pyenphase/commit/54236321c624e980a537fb6b7af01e5d1a14fc45))

- **deps-dev**: Bump pytest from 7.4.4 to 8.3.4
  ([#235](https://github.com/pyenphase/pyenphase/pull/235),
  [`199bd4a`](https://github.com/pyenphase/pyenphase/commit/199bd4a9cbe3c96a6abbee8a2c0b2dc4371e3a26))

- **deps-dev**: Bump pytest from 8.3.4 to 8.3.5
  ([#248](https://github.com/pyenphase/pyenphase/pull/248),
  [`fb8ad43`](https://github.com/pyenphase/pyenphase/commit/fb8ad430a676ce43d22e9210d5e18e06eab3606d))

- **deps-dev**: Bump pytest-asyncio from 0.21.2 to 0.25.3
  ([#239](https://github.com/pyenphase/pyenphase/pull/239),
  [`24ab1c0`](https://github.com/pyenphase/pyenphase/commit/24ab1c0c36a1b5fcdcce7c4d948f7bed7d34445e))

- **deps-dev**: Bump pytest-asyncio from 0.25.3 to 0.26.0
  ([#257](https://github.com/pyenphase/pyenphase/pull/257),
  [`9f73bce`](https://github.com/pyenphase/pyenphase/commit/9f73bce62b15fed33082a36ff5f8b150eef0eaf5))

- **deps-dev**: Bump sphinx from 7.3.7 to 8.1.3
  ([#234](https://github.com/pyenphase/pyenphase/pull/234),
  [`6310f28`](https://github.com/pyenphase/pyenphase/commit/6310f2881e5b7250b69885a2344bbdf6d71f7933))

- **deps-dev**: Bump sphinx-autodoc-typehints from 1.25.3 to 3.0.1
  ([#233](https://github.com/pyenphase/pyenphase/pull/233),
  [`29ca29d`](https://github.com/pyenphase/pyenphase/commit/29ca29dd8e97b59a427d7fe017ea5bc34411c238))

- **deps-dev**: Bump sphinx-rtd-theme from 2.0.0 to 3.0.2
  ([#237](https://github.com/pyenphase/pyenphase/pull/237),
  [`7d4498b`](https://github.com/pyenphase/pyenphase/commit/7d4498b2327f1e39a524668f578c923636d2a783))

- **deps-dev**: Bump syrupy from 4.8.1 to 4.8.2
  ([#245](https://github.com/pyenphase/pyenphase/pull/245),
  [`351036f`](https://github.com/pyenphase/pyenphase/commit/351036fa541075073c5bec8c30cfdf1dfc02a613))

- **deps-dev**: Bump syrupy from 4.8.2 to 4.9.0
  ([#250](https://github.com/pyenphase/pyenphase/pull/250),
  [`107e0c6`](https://github.com/pyenphase/pyenphase/commit/107e0c6e9829dafd0dca90ea754c4a408d0e8b4e))

- **deps-dev**: Bump syrupy from 4.9.0 to 4.9.1
  ([#254](https://github.com/pyenphase/pyenphase/pull/254),
  [`7f964d2`](https://github.com/pyenphase/pyenphase/commit/7f964d2e6dafed0dc62cf38a542c61e11c8fe2c6))

- **pre-commit.ci**: Pre-commit autoupdate ([#258](https://github.com/pyenphase/pyenphase/pull/258),
  [`153787d`](https://github.com/pyenphase/pyenphase/commit/153787d76070f30504dd41847b2863ca2471535d))

- **pre-commit.ci**: Pre-commit autoupdate ([#255](https://github.com/pyenphase/pyenphase/pull/255),
  [`20772e5`](https://github.com/pyenphase/pyenphase/commit/20772e5039e24983fbc2c030bd881dc044b925e5))

- **pre-commit.ci**: Pre-commit autoupdate ([#253](https://github.com/pyenphase/pyenphase/pull/253),
  [`3601946`](https://github.com/pyenphase/pyenphase/commit/3601946bed60eea298f215735fc0695d15af55d2))

- **pre-commit.ci**: Pre-commit autoupdate ([#252](https://github.com/pyenphase/pyenphase/pull/252),
  [`ea01214`](https://github.com/pyenphase/pyenphase/commit/ea012147bb5b18efc6f3f6d831708af23f5cc438))

- **pre-commit.ci**: Pre-commit autoupdate ([#249](https://github.com/pyenphase/pyenphase/pull/249),
  [`78547ef`](https://github.com/pyenphase/pyenphase/commit/78547efabf80242680498c801823ee8f661c535a))

- **pre-commit.ci**: Pre-commit autoupdate ([#246](https://github.com/pyenphase/pyenphase/pull/246),
  [`9878d8f`](https://github.com/pyenphase/pyenphase/commit/9878d8fb0e4946bf1a2566fd72c6100b4c300464))

- **pre-commit.ci**: Pre-commit autoupdate ([#241](https://github.com/pyenphase/pyenphase/pull/241),
  [`df71b5c`](https://github.com/pyenphase/pyenphase/commit/df71b5c3de495acaab0d484ff732b9044279b4f5))

### Documentation

- Reorganize and update usage documentation
  ([#244](https://github.com/pyenphase/pyenphase/pull/244),
  [`37d107b`](https://github.com/pyenphase/pyenphase/commit/37d107be3e9f87d02fe45d6abd36b4f8f25004fb))

- Replace black badge by ruff badge in readme
  ([#242](https://github.com/pyenphase/pyenphase/pull/242),
  [`d3fb541`](https://github.com/pyenphase/pyenphase/commit/d3fb541e342377e0eed98d6c8561f99deb9b3a2f))

- Update docstring examples to reflect ruff formatting rules.
  ([#238](https://github.com/pyenphase/pyenphase/pull/238),
  [`ede8786`](https://github.com/pyenphase/pyenphase/commit/ede87866a41cd55403c12031058cef28fc0c4852))

### Refactoring

- Remove unneeded int cast based on ruf046 ([#253](https://github.com/pyenphase/pyenphase/pull/253),
  [`3601946`](https://github.com/pyenphase/pyenphase/commit/3601946bed60eea298f215735fc0695d15af55d2))


## v1.25.4 (2025-02-11)

### Bug Fixes

- Add missing requires-python key to project
  ([#230](https://github.com/pyenphase/pyenphase/pull/230),
  [`8f48344`](https://github.com/pyenphase/pyenphase/commit/8f48344d4b4e73ba54548979355d0a6ab3c8fbff))

### Chores

- Add Python 3.13 to the CI ([#213](https://github.com/pyenphase/pyenphase/pull/213),
  [`3678102`](https://github.com/pyenphase/pyenphase/commit/36781022234d9efd5beefe02e5394908c97737e4))

- Bump pytest-asyncio to 0.21.2 ([#226](https://github.com/pyenphase/pyenphase/pull/226),
  [`098fa61`](https://github.com/pyenphase/pyenphase/commit/098fa61f0f262dbd84fc7773a0bf71a6b353ff33))

- Modify dependabot config to force re-run ([#219](https://github.com/pyenphase/pyenphase/pull/219),
  [`77c5f75`](https://github.com/pyenphase/pyenphase/commit/77c5f75bea06539698b12a897a8bfff7a6f329da))

- Switch to ruff to replace black/isort/flake8
  ([#217](https://github.com/pyenphase/pyenphase/pull/217),
  [`716eca6`](https://github.com/pyenphase/pyenphase/commit/716eca6a9bd7f80e98734d88f2c4d0a897368167))

- Update anyio in poetry.lock ([#224](https://github.com/pyenphase/pyenphase/pull/224),
  [`51d496c`](https://github.com/pyenphase/pyenphase/commit/51d496c91ff2c5953980da32a2899a7eb8b604e9))

- Update certifi to 2025.1.31 ([#227](https://github.com/pyenphase/pyenphase/pull/227),
  [`b9ad2a2`](https://github.com/pyenphase/pyenphase/commit/b9ad2a25d2f6887c9b0110a0e6a957e636ec67f7))

- Update dependabot.yml to retrigger run
  ([`20fc3bb`](https://github.com/pyenphase/pyenphase/commit/20fc3bb0b74a64bb45642c662925722e3a12c1aa))

- Update httpcore in poetry.lock ([#223](https://github.com/pyenphase/pyenphase/pull/223),
  [`f284b80`](https://github.com/pyenphase/pyenphase/commit/f284b80199cf570a4fe1c2fe8200ee41d964849b))

- Update httpx in the poetry lock ([#220](https://github.com/pyenphase/pyenphase/pull/220),
  [`e3d5717`](https://github.com/pyenphase/pyenphase/commit/e3d5717dd4d2f02bcf91b76a36c2845e62cbd676))

- Update idna in poetry lock ([#222](https://github.com/pyenphase/pyenphase/pull/222),
  [`cbf3b28`](https://github.com/pyenphase/pyenphase/commit/cbf3b28efc95bb97fc838f437328ce0c597b28fd))

- Update packaging to 24.2 ([#229](https://github.com/pyenphase/pyenphase/pull/229),
  [`828e960`](https://github.com/pyenphase/pyenphase/commit/828e96027ed4b13484280e236af506c3a4973860))

- Update pluggy to 1.5.0 ([#228](https://github.com/pyenphase/pyenphase/pull/228),
  [`c7b042e`](https://github.com/pyenphase/pyenphase/commit/c7b042ecf16d0fa0b3eef1587f4ab68b68719eb6))

- Update pyjwt in poetry.lock ([#225](https://github.com/pyenphase/pyenphase/pull/225),
  [`9d1b4ba`](https://github.com/pyenphase/pyenphase/commit/9d1b4bab44d463c8c1236e3432c41821ecfab653))

- Update pyupgrade to Python 3.10+ ([#216](https://github.com/pyenphase/pyenphase/pull/216),
  [`5278800`](https://github.com/pyenphase/pyenphase/commit/5278800f2de866cd1149096647b5f10052ae0eba))

- Update requests in poetry.lock ([#221](https://github.com/pyenphase/pyenphase/pull/221),
  [`8d19c79`](https://github.com/pyenphase/pyenphase/commit/8d19c79294e2d01628948ff192cd24071a38941f))

- Update zeroconf in the lock to speed up CI
  ([#218](https://github.com/pyenphase/pyenphase/pull/218),
  [`c89bfbe`](https://github.com/pyenphase/pyenphase/commit/c89bfbed1a728d930f4db98977dad4e3c59909ff))

- **ci**: Bump the github-actions group with 7 updates
  ([#206](https://github.com/pyenphase/pyenphase/pull/206),
  [`61e31b4`](https://github.com/pyenphase/pyenphase/commit/61e31b48da41fb606ee8135443b308fe0a472141))


## v1.25.3 (2025-02-11)

### Bug Fixes

- Bump orjson requirement to 3.10+ for Python 3.13
  ([#215](https://github.com/pyenphase/pyenphase/pull/215),
  [`7db2256`](https://github.com/pyenphase/pyenphase/commit/7db2256a59a26a4fc89b79a8dbaf4fbb16d5eb35))


## v1.25.2 (2025-02-11)

### Bug Fixes

- Update to poetry 2 ([#212](https://github.com/pyenphase/pyenphase/pull/212),
  [`43e5a15`](https://github.com/pyenphase/pyenphase/commit/43e5a15d747251dbecbad343b71562000d7f5b4f))

### Chores

- Add missing cache to CI ([#214](https://github.com/pyenphase/pyenphase/pull/214),
  [`d97d6cc`](https://github.com/pyenphase/pyenphase/commit/d97d6cc42b3eace1aa500d07d9abf5824b3ee7ad))

- Create dependabot.yml ([#205](https://github.com/pyenphase/pyenphase/pull/205),
  [`f3cf369`](https://github.com/pyenphase/pyenphase/commit/f3cf369a866fc91621e6cfb661e51643ed62aad2))

- **deps**: Bump awesomeversion from 24.2.0 to 24.6.0
  ([#208](https://github.com/pyenphase/pyenphase/pull/208),
  [`6488aa6`](https://github.com/pyenphase/pyenphase/commit/6488aa67d4d2c53783894ef31ba90135c0075b52))

- **deps-dev**: Bump pytest-cov from 5.0.0 to 6.0.0
  ([#210](https://github.com/pyenphase/pyenphase/pull/210),
  [`c8924a4`](https://github.com/pyenphase/pyenphase/commit/c8924a434311c9051efdc4e24ccab21347384219))

- **deps-dev**: Bump respx from 0.20.2 to 0.22.0
  ([#209](https://github.com/pyenphase/pyenphase/pull/209),
  [`607cbdf`](https://github.com/pyenphase/pyenphase/commit/607cbdf56db34b99f16ba005880aa4a617be1ceb))

- **deps-dev**: Bump sphinx-autodoc-typehints from 1.25.3 to 3.0.1
  ([#207](https://github.com/pyenphase/pyenphase/pull/207),
  [`bbf89ad`](https://github.com/pyenphase/pyenphase/commit/bbf89adf4c9d9f8b3081299dfc59d72c4affe19d))

- **deps-dev**: Bump syrupy from 4.6.1 to 4.8.1
  ([#211](https://github.com/pyenphase/pyenphase/pull/211),
  [`1ac802e`](https://github.com/pyenphase/pyenphase/commit/1ac802e6a5763d579fca1a731a969d461778718c))


## v1.25.1 (2025-02-11)

### Bug Fixes

- Indexerror crash for fw 8.3.5027 that sends data for not present CT
  ([#203](https://github.com/pyenphase/pyenphase/pull/203),
  [`770cab0`](https://github.com/pyenphase/pyenphase/commit/770cab092890d05b8f32fc9b180be6f58081a013))

### Chores

- **pre-commit.ci**: Auto fixes ([#203](https://github.com/pyenphase/pyenphase/pull/203),
  [`770cab0`](https://github.com/pyenphase/pyenphase/commit/770cab092890d05b8f32fc9b180be6f58081a013))


## v1.25.0 (2025-02-11)

### Features

- Add http method to request method parameters
  ([#197](https://github.com/pyenphase/pyenphase/pull/197),
  [`943f8d9`](https://github.com/pyenphase/pyenphase/commit/943f8d99306cc3dd1b45cf9ec810aa8936698c53))


## v1.24.0 (2025-02-11)

### Chores

- **deps-dev**: Bump jinja2 from 3.1.4 to 3.1.5
  ([#200](https://github.com/pyenphase/pyenphase/pull/200),
  [`ed9b448`](https://github.com/pyenphase/pyenphase/commit/ed9b448d3937fb922ecaccb2ee7dc135113f216b))

- **pre-commit.ci**: Pre-commit autoupdate ([#204](https://github.com/pyenphase/pyenphase/pull/204),
  [`2e5920d`](https://github.com/pyenphase/pyenphase/commit/2e5920d18569868cd6e1ede48678158465b5bd08))

- **pre-commit.ci**: Pre-commit autoupdate ([#202](https://github.com/pyenphase/pyenphase/pull/202),
  [`75b0ef0`](https://github.com/pyenphase/pyenphase/commit/75b0ef075ed29793471110de3e3fd0de9fe6d450))

- **pre-commit.ci**: Pre-commit autoupdate ([#201](https://github.com/pyenphase/pyenphase/pull/201),
  [`5fbb475`](https://github.com/pyenphase/pyenphase/commit/5fbb475b9c3770cc132d1ad36472dbd5842561bd))

### Features

- Add token_type property to identify user or installer type token.
  ([#180](https://github.com/pyenphase/pyenphase/pull/180),
  [`3708a54`](https://github.com/pyenphase/pyenphase/commit/3708a543bada7827fc16c52f9b747c0808061260))

- **tariff**: Add new firmware 8.2.42xx Storage settings opt_schedules property to
  EnvoyStorageSettings ([#179](https://github.com/pyenphase/pyenphase/pull/179),
  [`7b3d559`](https://github.com/pyenphase/pyenphase/commit/7b3d559ab56582519a6ccd34ce446f0f4014656e))

- **tariff**: Add opt_schedules to EnvoyStorageSettings
  ([#179](https://github.com/pyenphase/pyenphase/pull/179),
  [`7b3d559`](https://github.com/pyenphase/pyenphase/commit/7b3d559ab56582519a6ccd34ce446f0f4014656e))

### Refactoring

- Add exception catch for envoy._json_request() indirectly used by HA actions.
  ([#194](https://github.com/pyenphase/pyenphase/pull/194),
  [`e2224e2`](https://github.com/pyenphase/pyenphase/commit/e2224e22d8870210c8e1614b7114e16c9426c535))


## v1.23.1 (2025-01-21)

### Bug Fixes

- Set EnvoyStorageMode to None if tariff storage_settings mode is null and causes exception None is
  not a valid EnvoyStorageMode. ([#199](https://github.com/pyenphase/pyenphase/pull/199),
  [`d06680a`](https://github.com/pyenphase/pyenphase/commit/d06680adee686929aa648d294358e0c9a951f1be))

- Tariff storage_settings mode: None causes exception "None is not a valid EnvoyStorageMode", set
  EnvoyStorageMode to None. ([#199](https://github.com/pyenphase/pyenphase/pull/199),
  [`d06680a`](https://github.com/pyenphase/pyenphase/commit/d06680adee686929aa648d294358e0c9a951f1be))

### Chores

- Fix lint text issues ([#181](https://github.com/pyenphase/pyenphase/pull/181),
  [`a6bbc25`](https://github.com/pyenphase/pyenphase/commit/a6bbc256eedf2b8edbcaae7ed0549cb99957fc11))

- **pre-commit.ci**: Auto fixes ([#190](https://github.com/pyenphase/pyenphase/pull/190),
  [`58b2df1`](https://github.com/pyenphase/pyenphase/commit/58b2df1faa077fcc834377b4a03caf619156c2d2))

- **pre-commit.ci**: Auto fixes ([#186](https://github.com/pyenphase/pyenphase/pull/186),
  [`76de306`](https://github.com/pyenphase/pyenphase/commit/76de306906e0a7252def6c133a16c88d71913276))

- **pre-commit.ci**: Auto fixes ([#187](https://github.com/pyenphase/pyenphase/pull/187),
  [`ecc88c2`](https://github.com/pyenphase/pyenphase/commit/ecc88c285147ac55b2c370a6b28376ca68d4532d))

- **pre-commit.ci**: Auto fixes ([#184](https://github.com/pyenphase/pyenphase/pull/184),
  [`b869d0d`](https://github.com/pyenphase/pyenphase/commit/b869d0d9bcb9341c83d3848879efcac5ff5d597f))

- **pre-commit.ci**: Auto fixes ([#181](https://github.com/pyenphase/pyenphase/pull/181),
  [`a6bbc25`](https://github.com/pyenphase/pyenphase/commit/a6bbc256eedf2b8edbcaae7ed0549cb99957fc11))

- **pre-commit.ci**: Pre-commit autoupdate ([#198](https://github.com/pyenphase/pyenphase/pull/198),
  [`a4bc451`](https://github.com/pyenphase/pyenphase/commit/a4bc451f254d9fc7a5000d5f0e7b2d227950483e))

- **pre-commit.ci**: Pre-commit autoupdate ([#196](https://github.com/pyenphase/pyenphase/pull/196),
  [`ed7c44a`](https://github.com/pyenphase/pyenphase/commit/ed7c44aa486ecd14e129cdd030b6a38684ab3514))

- **pre-commit.ci**: Pre-commit autoupdate ([#193](https://github.com/pyenphase/pyenphase/pull/193),
  [`60d9fbf`](https://github.com/pyenphase/pyenphase/commit/60d9fbfe64ebf346d3802ea903d2c3446580d008))

### Documentation

- Docs gen 2, refactor authentication doc ([#181](https://github.com/pyenphase/pyenphase/pull/181),
  [`a6bbc25`](https://github.com/pyenphase/pyenphase/commit/a6bbc256eedf2b8edbcaae7ed0549cb99957fc11))

- Fix codespell lint issues ([#187](https://github.com/pyenphase/pyenphase/pull/187),
  [`ecc88c2`](https://github.com/pyenphase/pyenphase/commit/ecc88c285147ac55b2c370a6b28376ca68d4532d))

- Fix issue with multiple docstrings in ssl module.
  ([#186](https://github.com/pyenphase/pyenphase/pull/186),
  [`76de306`](https://github.com/pyenphase/pyenphase/commit/76de306906e0a7252def6c133a16c88d71913276))

- Fix more textlint issues ([#184](https://github.com/pyenphase/pyenphase/pull/184),
  [`b869d0d`](https://github.com/pyenphase/pyenphase/commit/b869d0d9bcb9341c83d3848879efcac5ff5d597f))

- Fix multiple docstrings in const.py ([#190](https://github.com/pyenphase/pyenphase/pull/190),
  [`58b2df1`](https://github.com/pyenphase/pyenphase/commit/58b2df1faa077fcc834377b4a03caf619156c2d2))

- Fix textlint issues ([#184](https://github.com/pyenphase/pyenphase/pull/184),
  [`b869d0d`](https://github.com/pyenphase/pyenphase/commit/b869d0d9bcb9341c83d3848879efcac5ff5d597f))

- Refactor const.py to use docstring for documentation.
  ([#190](https://github.com/pyenphase/pyenphase/pull/190),
  [`58b2df1`](https://github.com/pyenphase/pyenphase/commit/58b2df1faa077fcc834377b4a03caf619156c2d2))

- Refactor envoy class documentation using docstrings
  ([#184](https://github.com/pyenphase/pyenphase/pull/184),
  [`b869d0d`](https://github.com/pyenphase/pyenphase/commit/b869d0d9bcb9341c83d3848879efcac5ff5d597f))

- Refactor EnvoyData class documentation using docstrings
  ([#189](https://github.com/pyenphase/pyenphase/pull/189),
  [`6048a0f`](https://github.com/pyenphase/pyenphase/commit/6048a0fda2ef9eae1404962db13fcf300291530e))

- Refactor firmware class documentation ([#185](https://github.com/pyenphase/pyenphase/pull/185),
  [`ab7bae4`](https://github.com/pyenphase/pyenphase/commit/ab7bae40d135207f34ba762a14b35c0fa24acb08))

- Refactor firmware class documentation using docstrings
  ([#185](https://github.com/pyenphase/pyenphase/pull/185),
  [`ab7bae4`](https://github.com/pyenphase/pyenphase/commit/ab7bae40d135207f34ba762a14b35c0fa24acb08))

- Refactor json helper documentation using docstrings
  ([#188](https://github.com/pyenphase/pyenphase/pull/188),
  [`aea3359`](https://github.com/pyenphase/pyenphase/commit/aea3359762a105106705d066324729d7ac768b48))

- Refactor ssl helper documentation using docstring
  ([#186](https://github.com/pyenphase/pyenphase/pull/186),
  [`76de306`](https://github.com/pyenphase/pyenphase/commit/76de306906e0a7252def6c133a16c88d71913276))

- Update guidelines to documentation for using docstring
  ([#187](https://github.com/pyenphase/pyenphase/pull/187),
  [`ecc88c2`](https://github.com/pyenphase/pyenphase/commit/ecc88c285147ac55b2c370a6b28376ca68d4532d))


## v1.23.0 (2024-11-21)

### Chores

- **pre-commit.ci**: Auto fixes ([#182](https://github.com/pyenphase/pyenphase/pull/182),
  [`fa24372`](https://github.com/pyenphase/pyenphase/commit/fa2437208e76d6c1f90a01b55c98fdd1ca3cb450))

- **pre-commit.ci**: Pre-commit autoupdate ([#176](https://github.com/pyenphase/pyenphase/pull/176),
  [`fc76ed5`](https://github.com/pyenphase/pyenphase/commit/fc76ed5a43b76b4506b99423938bfbef49ad3a5d))

### Documentation

- Add license to documentation project info section
  ([#182](https://github.com/pyenphase/pyenphase/pull/182),
  [`fa24372`](https://github.com/pyenphase/pyenphase/commit/fa2437208e76d6c1f90a01b55c98fdd1ca3cb450))

- Minor updates to usage example. ([#183](https://github.com/pyenphase/pyenphase/pull/183),
  [`b287005`](https://github.com/pyenphase/pyenphase/commit/b28700558b53ebfaeb7d21e7cdb68415c9a78f1a))

### Features

- Add ACB model documentation and some pre-commit cleanup
  ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

- Add ACB updaters ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

- Add model for ACB batteries ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

- Add support for ACB batteries ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

### Refactoring

- Implement review change proposals. ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

### Testing

- Add 8.2.4382 ACB battery fixture ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))

- Add ACB battery tests ([#191](https://github.com/pyenphase/pyenphase/pull/191),
  [`1caeff2`](https://github.com/pyenphase/pyenphase/commit/1caeff2f49397e6c2dabf2ff99cb7a8ccc685a50))


## v1.22.0 (2024-08-03)

### Features

- **netconsumption**: Add system_net_consumption and phases
  ([#177](https://github.com/pyenphase/pyenphase/pull/177),
  [`c734a6d`](https://github.com/pyenphase/pyenphase/commit/c734a6d67b6ac355ba528fcf78fd86a33e48a419))


## v1.21.0 (2024-07-16)

### Chores

- **deps**: Bump certifi from 2024.2.2 to 2024.7.4
  ([#175](https://github.com/pyenphase/pyenphase/pull/175),
  [`52eb502`](https://github.com/pyenphase/pyenphase/commit/52eb502f4a710259cffc5313432c2b7ea8fee603))

### Features

- **generator**: Probe for generator ([#160](https://github.com/pyenphase/pyenphase/pull/160),
  [`42a2533`](https://github.com/pyenphase/pyenphase/commit/42a2533f44ec975c72bd0be9dc70c75a987ff030))

### Refactoring

- Extend fixture_collector with cmdline args and option to read HA config file
  ([#162](https://github.com/pyenphase/pyenphase/pull/162),
  [`cb6c40c`](https://github.com/pyenphase/pyenphase/commit/cb6c40cf5d423893f259bb7fd4c98a5a1e693b92))

- Tweak code ([#162](https://github.com/pyenphase/pyenphase/pull/162),
  [`cb6c40c`](https://github.com/pyenphase/pyenphase/commit/cb6c40cf5d423893f259bb7fd4c98a5a1e693b92))

- Use HA config information and cmdline args for fixture collection
  ([#162](https://github.com/pyenphase/pyenphase/pull/162),
  [`cb6c40c`](https://github.com/pyenphase/pyenphase/commit/cb6c40cf5d423893f259bb7fd4c98a5a1e693b92))


## v1.20.6 (2024-07-03)

### Bug Fixes

- Raise EnvoyCommunicationError for hhtpx NetworkError and TimeoutExcpetion exceptions
  ([#170](https://github.com/pyenphase/pyenphase/pull/170),
  [`c6d238f`](https://github.com/pyenphase/pyenphase/commit/c6d238f83b10622cb20493bcf70e4e54deb751d2))

- Raise EnvoyCommunicationError for httpx ConnectError and TimeoutException exceptions during
  Envoy.update ([#170](https://github.com/pyenphase/pyenphase/pull/170),
  [`c6d238f`](https://github.com/pyenphase/pyenphase/commit/c6d238f83b10622cb20493bcf70e4e54deb751d2))

### Testing

- Httpx.TimeoutException and NetworkError map to EnvoyCommunicationError
  ([#170](https://github.com/pyenphase/pyenphase/pull/170),
  [`c6d238f`](https://github.com/pyenphase/pyenphase/commit/c6d238f83b10622cb20493bcf70e4e54deb751d2))


## v1.20.5 (2024-07-03)

### Bug Fixes

- Report EnvoyHTTPStatusError for _json_request if status not in 200-300
  ([#171](https://github.com/pyenphase/pyenphase/pull/171),
  [`46fb2b3`](https://github.com/pyenphase/pyenphase/commit/46fb2b386ff1991ba26d4b60628163cff147afa9))

### Chores

- **pre-commit.ci**: Pre-commit autoupdate ([#174](https://github.com/pyenphase/pyenphase/pull/174),
  [`3fc9920`](https://github.com/pyenphase/pyenphase/commit/3fc99208c47f6d491442b341d9d571f658623169))

### Refactoring

- Get monotonic time and only when in debug mode
  ([#172](https://github.com/pyenphase/pyenphase/pull/172),
  [`8f0e092`](https://github.com/pyenphase/pyenphase/commit/8f0e092a52b7eea7d9c13a0d1ba1bf2172992e88))

- Unify request reply debug log all showing url and duration.
  ([#172](https://github.com/pyenphase/pyenphase/pull/172),
  [`8f0e092`](https://github.com/pyenphase/pyenphase/commit/8f0e092a52b7eea7d9c13a0d1ba1bf2172992e88))

### Testing

- Add test for request status not between 200-300
  ([#171](https://github.com/pyenphase/pyenphase/pull/171),
  [`46fb2b3`](https://github.com/pyenphase/pyenphase/commit/46fb2b386ff1991ba26d4b60628163cff147afa9))


## v1.20.4 (2024-07-02)

### Bug Fixes

- For fw 3.x mark production with only zero values as EnvoyPoorDataQuality error
  ([#173](https://github.com/pyenphase/pyenphase/pull/173),
  [`8b6b302`](https://github.com/pyenphase/pyenphase/commit/8b6b302b626742e101708c5bbd0c0a46e86f9cb7))

### Chores

- **deps-dev**: Bump jinja2 from 3.1.3 to 3.1.4
  ([#163](https://github.com/pyenphase/pyenphase/pull/163),
  [`d8d90f9`](https://github.com/pyenphase/pyenphase/commit/d8d90f92344ee10d2fe7bacdc7b40a59166be1fc))

- **deps-dev**: Bump requests from 2.31.0 to 2.32.0
  ([#164](https://github.com/pyenphase/pyenphase/pull/164),
  [`114854d`](https://github.com/pyenphase/pyenphase/commit/114854df454ad6b8d8a0aad9abd87168857af7ed))

- **deps-dev**: Bump urllib3 from 2.2.1 to 2.2.2
  ([#167](https://github.com/pyenphase/pyenphase/pull/167),
  [`9f130fb`](https://github.com/pyenphase/pyenphase/commit/9f130fb4e816953ea8652552b744cf5c4ea48cbb))


## v1.20.3 (2024-05-07)

### Bug Fixes

- Get production phase data using details parameter
  ([#159](https://github.com/pyenphase/pyenphase/pull/159),
  [`d2a478c`](https://github.com/pyenphase/pyenphase/commit/d2a478c25581cbb147506d138db3043c70345fae))

### Chores

- **deps**: Bump pytest-cov to 5.0 ([#156](https://github.com/pyenphase/pyenphase/pull/156),
  [`a955c65`](https://github.com/pyenphase/pyenphase/commit/a955c6587595cd36a2a0a24274de0778ae23df3d))

- **deps**: Remove deprecated cookies on request
  ([#158](https://github.com/pyenphase/pyenphase/pull/158),
  [`b4eecda`](https://github.com/pyenphase/pyenphase/commit/b4eecda718fd89894396d48e1c5ec484898ffe99))

- **deps**: Replace deprecated httpx data with content
  ([#157](https://github.com/pyenphase/pyenphase/pull/157),
  [`86f8ba2`](https://github.com/pyenphase/pyenphase/commit/86f8ba2a183ebdf0ca57bd92fd75c57841f4875d))


## v1.20.2 (2024-04-18)

### Bug Fixes

- Add missing EnvoyTokenAuth class properties
  ([#150](https://github.com/pyenphase/pyenphase/pull/150),
  [`d01157a`](https://github.com/pyenphase/pyenphase/commit/d01157a1ec3139f67e085f0a4e529f2e7af09943))

### Chores

- Update dependancies to latest versions ([#153](https://github.com/pyenphase/pyenphase/pull/153),
  [`e750144`](https://github.com/pyenphase/pyenphase/commit/e7501441baff3c66a198e8eec260292dc13bbb85))

- **deps**: Bump idna from 3.4 to 3.7 ([#149](https://github.com/pyenphase/pyenphase/pull/149),
  [`0596e59`](https://github.com/pyenphase/pyenphase/commit/0596e59d1f232376ce3f97342b8a76ba1bdac174))

### Documentation

- Let readtedocs use virtualenv for build ([#151](https://github.com/pyenphase/pyenphase/pull/151),
  [`9e8b648`](https://github.com/pyenphase/pyenphase/commit/9e8b648875db5fcc2210d7f180c0d278485eafb8))

- Let readthedocs use virtualenv for build ([#151](https://github.com/pyenphase/pyenphase/pull/151),
  [`9e8b648`](https://github.com/pyenphase/pyenphase/commit/9e8b648875db5fcc2210d7f180c0d278485eafb8))

- Use new format to specify virtual env for readthedocs
  ([#152](https://github.com/pyenphase/pyenphase/pull/152),
  [`4b9a9ea`](https://github.com/pyenphase/pyenphase/commit/4b9a9ea79ef94dfd1fed2b262a12cb016da2802c))

### Testing

- Correct 7.6.175 fw fixture and add 7.3.466 fw
  ([#155](https://github.com/pyenphase/pyenphase/pull/155),
  [`074eb7c`](https://github.com/pyenphase/pyenphase/commit/074eb7cd7ca6d19534ef84be3dc7a281edf3af48))

- Improve code coverage ([#146](https://github.com/pyenphase/pyenphase/pull/146),
  [`c55aa92`](https://github.com/pyenphase/pyenphase/commit/c55aa92e0b45fb9ed7b435d6fdc55c3a49e552dd))


## v1.20.1 (2024-03-26)

### Bug Fixes

- Endless loop on envoy unreachable ([#145](https://github.com/pyenphase/pyenphase/pull/145),
  [`f074c61`](https://github.com/pyenphase/pyenphase/commit/f074c61b56b0fdb1080ff3c54f82c59a8015b6d9))


## v1.20.0 (2024-03-21)

### Features

- Report storage CT data ([#144](https://github.com/pyenphase/pyenphase/pull/144),
  [`52c53fe`](https://github.com/pyenphase/pyenphase/commit/52c53fe20123514177290e964e03a23454e42e9c))

### Refactoring

- Add empty data structures for storage CT ([#142](https://github.com/pyenphase/pyenphase/pull/142),
  [`669b95a`](https://github.com/pyenphase/pyenphase/commit/669b95aba0d333807d795e6a83a657ae5c7c295b))


## v1.19.2 (2024-03-08)

### Bug Fixes

- Consumption CT not found when 3 CT reported
  ([#140](https://github.com/pyenphase/pyenphase/pull/140),
  [`7c2f52c`](https://github.com/pyenphase/pyenphase/commit/7c2f52cc28fdc872a8c5875fc7f7d8b7e233bc01))


## v1.19.1 (2024-02-27)

### Bug Fixes

- Force release ([#139](https://github.com/pyenphase/pyenphase/pull/139),
  [`b16f132`](https://github.com/pyenphase/pyenphase/commit/b16f13264ffdb90de53d3d9730eb0cd700724ffd))

### Chores

- **deps**: Bump orjson from 3.9.10 to 3.9.15
  ([#137](https://github.com/pyenphase/pyenphase/pull/137),
  [`25ad476`](https://github.com/pyenphase/pyenphase/commit/25ad4769681e70cd414ddb4efd665f3334aee361))

### Refactoring

- Add type hint to PHASENAMES ([#138](https://github.com/pyenphase/pyenphase/pull/138),
  [`b20d60f`](https://github.com/pyenphase/pyenphase/commit/b20d60fe8a4262c605e9598d5d33468aeb85051b))


## v1.19.0 (2024-01-27)

### Features

- Add envoy_model property ([#136](https://github.com/pyenphase/pyenphase/pull/136),
  [`42652cd`](https://github.com/pyenphase/pyenphase/commit/42652cda168d1cf1d4b637071f0603d0b0707066))


## v1.18.0 (2024-01-23)

### Documentation

- Document CT meter data ([#134](https://github.com/pyenphase/pyenphase/pull/134),
  [`cfd396b`](https://github.com/pyenphase/pyenphase/commit/cfd396bde18a908d7703d421a10126abc06f0542))

### Features

- Add updater for Current Transformer data ([#135](https://github.com/pyenphase/pyenphase/pull/135),
  [`1ca6118`](https://github.com/pyenphase/pyenphase/commit/1ca6118e6aaecb829b4cd711d72d6296fad26bae))

### Refactoring

- Add CT meters model datastructures ([#133](https://github.com/pyenphase/pyenphase/pull/133),
  [`8d6e2c5`](https://github.com/pyenphase/pyenphase/commit/8d6e2c585b2962838fc9be0ff30153915e6873c2))

- Add meters model datastructures ([#133](https://github.com/pyenphase/pyenphase/pull/133),
  [`8d6e2c5`](https://github.com/pyenphase/pyenphase/commit/8d6e2c585b2962838fc9be0ff30153915e6873c2))


## v1.17.0 (2024-01-11)

### Chores

- Bump python for readthedocs to 3.11 ([#130](https://github.com/pyenphase/pyenphase/pull/130),
  [`35fa785`](https://github.com/pyenphase/pyenphase/commit/35fa78501c0e0656c33c79bf96476b01ac0a2913))

- **deps-dev**: Bump jinja2 from 3.1.2 to 3.1.3
  ([#132](https://github.com/pyenphase/pyenphase/pull/132),
  [`c2a9460`](https://github.com/pyenphase/pyenphase/commit/c2a9460d8a958cc0b3d161e2fbfdcbaf648b021e))

### Documentation

- Reorganize and extend documentation. ([#129](https://github.com/pyenphase/pyenphase/pull/129),
  [`4d8e463`](https://github.com/pyenphase/pyenphase/commit/4d8e463fc5d5e500876f721ae2831cc90a275d9a))

### Features

- Write request reply to debuglog when in debug
  ([#131](https://github.com/pyenphase/pyenphase/pull/131),
  [`e255684`](https://github.com/pyenphase/pyenphase/commit/e25568444ca4a629bc38904c0f27777550219117))


## v1.16.0 (2024-01-09)

### Features

- Provide phase data for envoy metered with ct
  ([#126](https://github.com/pyenphase/pyenphase/pull/126),
  [`454dbc5`](https://github.com/pyenphase/pyenphase/commit/454dbc58ebb2edf23e9c64173fb8b5d155b327fc))


## v1.15.2 (2023-12-20)

### Bug Fixes

- 3.9.x firmware with meters probe ([#128](https://github.com/pyenphase/pyenphase/pull/128),
  [`06606c5`](https://github.com/pyenphase/pyenphase/commit/06606c5516c84b3ee500843b8b843bf180658055))


## v1.15.1 (2023-12-20)

### Bug Fixes

- Skip meters endpoint if it returns a 401 ([#125](https://github.com/pyenphase/pyenphase/pull/125),
  [`166c25c`](https://github.com/pyenphase/pyenphase/commit/166c25c410b6fa319bddea78db44606da7364aeb))

### Chores

- Add tests ([#125](https://github.com/pyenphase/pyenphase/pull/125),
  [`166c25c`](https://github.com/pyenphase/pyenphase/commit/166c25c410b6fa319bddea78db44606da7364aeb))


## v1.15.0 (2023-12-19)

### Features

- Provide phase configuration for envoy metered with ct
  ([#122](https://github.com/pyenphase/pyenphase/pull/122),
  [`12204a8`](https://github.com/pyenphase/pyenphase/commit/12204a8ec2082cb561f334e21e6febfdb2c8a082))

### Refactoring

- Add empty data structures and tests for phase information
  ([#121](https://github.com/pyenphase/pyenphase/pull/121),
  [`f5cbea7`](https://github.com/pyenphase/pyenphase/commit/f5cbea7bf431c1ce10420851a6e66383c6641fbb))

- Add sphinx napoleon extension for auto doc generation.
  ([#117](https://github.com/pyenphase/pyenphase/pull/117),
  [`577c40e`](https://github.com/pyenphase/pyenphase/commit/577c40ee9310ed02dfca675ffd63826c8c0287b1))

- Rename data parameter of EnvoyUpdater base class to envoy_data
  ([#119](https://github.com/pyenphase/pyenphase/pull/119),
  [`a0abccd`](https://github.com/pyenphase/pyenphase/commit/a0abccd7423ed0fa48e67543cd9bcc32352b0b74))

- Use TypedDict for meter data and enum for fields and phasenames
  ([#116](https://github.com/pyenphase/pyenphase/pull/116),
  [`0f7fe6b`](https://github.com/pyenphase/pyenphase/commit/0f7fe6bb80cd44f5fbd3bcededdb2d0e4ff2d3a1))

### Testing

- Add 401 test for ivp/meters and change not existing reply to 404
  ([#120](https://github.com/pyenphase/pyenphase/pull/120),
  [`12bbe91`](https://github.com/pyenphase/pyenphase/commit/12bbe91812161360e2f6f62269f19544084e2f77))


## v1.14.3 (2023-11-11)

### Bug Fixes

- **#99**: Envoy metered without CT reporting wrong values
  ([#111](https://github.com/pyenphase/pyenphase/pull/111),
  [`2188969`](https://github.com/pyenphase/pyenphase/commit/21889696fdc06f423f382eb404483e1b5d641094))

### Chores

- Fix docs build ([#115](https://github.com/pyenphase/pyenphase/pull/115),
  [`809bb5a`](https://github.com/pyenphase/pyenphase/commit/809bb5affd67c2d846485728fe03e329392b9fa3))

- Fix python version in readthedocs ([#114](https://github.com/pyenphase/pyenphase/pull/114),
  [`c89c989`](https://github.com/pyenphase/pyenphase/commit/c89c98989033b382bc05170972e1c4bedc67c3db))

### Documentation

- Update usage.md ([#109](https://github.com/pyenphase/pyenphase/pull/109),
  [`2e31671`](https://github.com/pyenphase/pyenphase/commit/2e316718081fccab314844a76aa9c6e4e54d20a9))


## v1.14.2 (2023-11-06)

### Bug Fixes

- Make date field optional in storage settings tariff model
  ([#112](https://github.com/pyenphase/pyenphase/pull/112),
  [`cf98198`](https://github.com/pyenphase/pyenphase/commit/cf98198b80326f5bf57c58c77eedbe17b6142b0b))

### Chores

- **deps**: Update deps via poetry ([#113](https://github.com/pyenphase/pyenphase/pull/113),
  [`34aaa0e`](https://github.com/pyenphase/pyenphase/commit/34aaa0e210c36cfe63e72fe5b1c3fef0f02ab4eb))


## v1.14.1 (2023-11-02)

### Bug Fixes

- Add economy EnvoyStorageMode ([#110](https://github.com/pyenphase/pyenphase/pull/110),
  [`edaf93c`](https://github.com/pyenphase/pyenphase/commit/edaf93c8c1cd71f34bf0be227436f676b1c13772))


## v1.14.0 (2023-10-24)

### Features

- **multiphase**: Add phase_count property to envoy
  ([#105](https://github.com/pyenphase/pyenphase/pull/105),
  [`39ec460`](https://github.com/pyenphase/pyenphase/commit/39ec4606b1bfc152189c48edc89396267564ac13))


## v1.13.1 (2023-10-21)

### Bug Fixes

- Ensure tariff endpoint is skipped on firmware 3
  ([#102](https://github.com/pyenphase/pyenphase/pull/102),
  [`4fd7796`](https://github.com/pyenphase/pyenphase/commit/4fd77967230089ec9e86c6e6c3e237b6153abb87))

### Chores

- Add python 3.12 to the CI ([#103](https://github.com/pyenphase/pyenphase/pull/103),
  [`c23c3cf`](https://github.com/pyenphase/pyenphase/commit/c23c3cf1402076bf32af685187247d240b4790d4))

- **deps-dev**: Bump urllib3 from 2.0.4 to 2.0.7
  ([#100](https://github.com/pyenphase/pyenphase/pull/100),
  [`f9ae1a7`](https://github.com/pyenphase/pyenphase/commit/f9ae1a766eafd5287c4801a55faa8f1b9a510dfc))


## v1.13.0 (2023-10-20)

### Features

- Add support for changing storage mode and reserve soc
  ([#101](https://github.com/pyenphase/pyenphase/pull/101),
  [`16a1471`](https://github.com/pyenphase/pyenphase/commit/16a1471d7b2e961be218825151401a4cd27fe096))


## v1.12.0 (2023-10-11)

### Chores

- Add 4.10.35 fixtures ([#92](https://github.com/pyenphase/pyenphase/pull/92),
  [`27e81d2`](https://github.com/pyenphase/pyenphase/commit/27e81d2233594b07d86eb2927bb97acbe10e7e08))

- Add fixtures for 7.6.185 with cts and battery 3t
  ([#93](https://github.com/pyenphase/pyenphase/pull/93),
  [`5d7a8f8`](https://github.com/pyenphase/pyenphase/commit/5d7a8f83fc0892c01ce7eae4d8c503090847ae8c))

- Add tests for 7.6.185_with_cts_and_battery_3t
  ([#94](https://github.com/pyenphase/pyenphase/pull/94),
  [`2ae0fa2`](https://github.com/pyenphase/pyenphase/commit/2ae0fa2058c34ca16cd005395bfaa51f79f29561))

- Bump syrupy to 4.5.0 ([#98](https://github.com/pyenphase/pyenphase/pull/98),
  [`7ea6c1c`](https://github.com/pyenphase/pyenphase/commit/7ea6c1cf2ca596c8b02ec1975d56121cec143147))

### Features

- Add initial tariff support and charge from grid functions
  ([#95](https://github.com/pyenphase/pyenphase/pull/95),
  [`5418d4c`](https://github.com/pyenphase/pyenphase/commit/5418d4c99ee6a5f0998367525ccba65f0edb9bc5))


## v1.11.4 (2023-09-13)

### Bug Fixes

- Use eim if activeCount is true ([#91](https://github.com/pyenphase/pyenphase/pull/91),
  [`ac041a4`](https://github.com/pyenphase/pyenphase/commit/ac041a4abd2119fa3c784aa74634b27e118b7624))


## v1.11.3 (2023-09-13)

### Bug Fixes

- More dry contact settings should be optional
  ([#90](https://github.com/pyenphase/pyenphase/pull/90),
  [`4fc503a`](https://github.com/pyenphase/pyenphase/commit/4fc503a4f8f60051319aaabf386bced2cd0f3076))

### Chores

- Update fixtures for 5.0.62 with newer fixture collector
  ([#88](https://github.com/pyenphase/pyenphase/pull/88),
  [`9086494`](https://github.com/pyenphase/pyenphase/commit/9086494081b02e0b9a97c606a0eb16e9f97dfa7f))


## v1.11.2 (2023-09-12)

### Bug Fixes

- Disable consumption when there are no active meters
  ([#87](https://github.com/pyenphase/pyenphase/pull/87),
  [`fa28f1c`](https://github.com/pyenphase/pyenphase/commit/fa28f1c31344f0e2d1bc60640902e94bd55b0331))

### Chores

- Add 7.3.130 fixtures without consumption ([#85](https://github.com/pyenphase/pyenphase/pull/85),
  [`4922693`](https://github.com/pyenphase/pyenphase/commit/49226932a95a69cab59c740f3033b4ebe413e8b0))

- Add tests for no consumption ([#86](https://github.com/pyenphase/pyenphase/pull/86),
  [`14039a6`](https://github.com/pyenphase/pyenphase/commit/14039a6b9481dfcda1ba3810584a0f1560acf36a))


## v1.11.1 (2023-09-12)

### Bug Fixes

- Black_s_start key not returned by all Ensemble systems
  ([#84](https://github.com/pyenphase/pyenphase/pull/84),
  [`357f0bd`](https://github.com/pyenphase/pyenphase/commit/357f0bd132a976f31a052063ce514ac86534de8e))

- Black_s_start not returned by all Ensemble systems
  ([#84](https://github.com/pyenphase/pyenphase/pull/84),
  [`357f0bd`](https://github.com/pyenphase/pyenphase/commit/357f0bd132a976f31a052063ce514ac86534de8e))


## v1.11.0 (2023-09-08)

### Bug Fixes

- Get watt_hours_lifetime on total system ([#83](https://github.com/pyenphase/pyenphase/pull/83),
  [`d7e195e`](https://github.com/pyenphase/pyenphase/commit/d7e195e498362d1374366d88a24afc8da6b01321))

### Chores

- Compare Enphase dataclasses as dict ([#82](https://github.com/pyenphase/pyenphase/pull/82),
  [`fd93f4c`](https://github.com/pyenphase/pyenphase/commit/fd93f4ceb4825feba80dcbedf0b6beb1b10af688))

### Features

- Add fallback when api/v1/production endpoint if broken
  ([#83](https://github.com/pyenphase/pyenphase/pull/83),
  [`d7e195e`](https://github.com/pyenphase/pyenphase/commit/d7e195e498362d1374366d88a24afc8da6b01321))

- Add fallback when api/v1/production endpoint is broken
  ([#83](https://github.com/pyenphase/pyenphase/pull/83),
  [`d7e195e`](https://github.com/pyenphase/pyenphase/commit/d7e195e498362d1374366d88a24afc8da6b01321))


## v1.10.0 (2023-09-08)

### Features

- Add 7.6.175 fixtures with total consumption
  ([#81](https://github.com/pyenphase/pyenphase/pull/81),
  [`1bc2b20`](https://github.com/pyenphase/pyenphase/commit/1bc2b20a427c6d03df318fcf5c529391fc6e25ed))


## v1.9.3 (2023-09-07)

### Bug Fixes

- Handle /production returning a 401 even with the correct auth on some 3.x firmwares
  ([#80](https://github.com/pyenphase/pyenphase/pull/80),
  [`947605f`](https://github.com/pyenphase/pyenphase/commit/947605fba25b41d12db273e9352c29b08cac1d4d))


## v1.9.2 (2023-09-07)

### Bug Fixes

- Raise EnvoyAuthenticationRequired when local auth is incorrect
  ([#79](https://github.com/pyenphase/pyenphase/pull/79),
  [`208e91a`](https://github.com/pyenphase/pyenphase/commit/208e91a6a66e8afa0931bb3a78e557b882277148))


## v1.9.1 (2023-09-04)

### Bug Fixes

- Envoy default password is last 6 not first 6
  ([#78](https://github.com/pyenphase/pyenphase/pull/78),
  [`33d07f6`](https://github.com/pyenphase/pyenphase/commit/33d07f6fb231a274bfdf5e693d1d2200fc0b516d))

### Chores

- Fix snapshot ([#78](https://github.com/pyenphase/pyenphase/pull/78),
  [`33d07f6`](https://github.com/pyenphase/pyenphase/commit/33d07f6fb231a274bfdf5e693d1d2200fc0b516d))


## v1.9.0 (2023-09-03)

### Chores

- Add additional endpoints to fixture collector
  ([#76](https://github.com/pyenphase/pyenphase/pull/76),
  [`9590d21`](https://github.com/pyenphase/pyenphase/commit/9590d219cdee3049364ce82691b74606062898e5))

### Features

- Add ivp/meters and ivp/meters/readings to fixture collector
  ([#77](https://github.com/pyenphase/pyenphase/pull/77),
  [`74c02bc`](https://github.com/pyenphase/pyenphase/commit/74c02bc882435f8605c85600c7f598a7e77c7141))


## v1.8.1 (2023-08-23)

### Bug Fixes

- Preemptively update dry contact state when toggling
  ([#75](https://github.com/pyenphase/pyenphase/pull/75),
  [`6a3f12f`](https://github.com/pyenphase/pyenphase/commit/6a3f12f26355721a4d12f3ef490659e4c4ce4a4c))


## v1.8.0 (2023-08-19)

### Features

- Add initial support for firmware 8.1.41 ([#73](https://github.com/pyenphase/pyenphase/pull/73),
  [`3562261`](https://github.com/pyenphase/pyenphase/commit/3562261d51a2f3d539d125c3512d9b1ca9b9bd6d))


## v1.7.1 (2023-08-15)

### Bug Fixes

- Startup was blocked for multiple minutes if the envoy was offline
  ([#71](https://github.com/pyenphase/pyenphase/pull/71),
  [`983ef52`](https://github.com/pyenphase/pyenphase/commit/983ef52e92ffff5a91b8de8bddda68f460058b56))


## v1.7.0 (2023-08-15)

### Features

- Add support for opening and closing dry contact relays
  ([#70](https://github.com/pyenphase/pyenphase/pull/70),
  [`f59aa54`](https://github.com/pyenphase/pyenphase/commit/f59aa546e4991c5aee446e9629b48df2ca556272))


## v1.6.0 (2023-08-13)

### Features

- Add support for changing settings on dry contact relays
  ([#68](https://github.com/pyenphase/pyenphase/pull/68),
  [`345165a`](https://github.com/pyenphase/pyenphase/commit/345165a92ffc7ffc35c5d09626757c53f4add7d2))


## v1.5.3 (2023-08-12)

### Bug Fixes

- Add "schedule" to DryContactAction ([#67](https://github.com/pyenphase/pyenphase/pull/67),
  [`403d8dc`](https://github.com/pyenphase/pyenphase/commit/403d8dc5c0361a30b95e57fdeda13ea25fd8179a))


## v1.5.2 (2023-08-11)

### Bug Fixes

- Add EnvoyEnchargeAggregate to __all__ ([#66](https://github.com/pyenphase/pyenphase/pull/66),
  [`63b7698`](https://github.com/pyenphase/pyenphase/commit/63b76980d620cf7e125df0d6058c80230f66756a))


## v1.5.1 (2023-08-11)

### Bug Fixes

- Switch fetching aggregate Encharge data to simpler endpoint
  ([#65](https://github.com/pyenphase/pyenphase/pull/65),
  [`e076476`](https://github.com/pyenphase/pyenphase/commit/e07647656920779e7a18a045ddfea1dec583fba7))


## v1.5.0 (2023-08-11)

### Features

- Add EnchargeAggregate model for aggregated battery data
  ([#64](https://github.com/pyenphase/pyenphase/pull/64),
  [`6985935`](https://github.com/pyenphase/pyenphase/commit/69859358ad6c4146fac30198ec5a342633db9834))


## v1.4.0 (2023-08-10)

### Features

- Add support for toggling grid on/off ([#62](https://github.com/pyenphase/pyenphase/pull/62),
  [`63d44dd`](https://github.com/pyenphase/pyenphase/commit/63d44ddbc59d04ca6afb6b3526a37cda32c7417d))


## v1.3.0 (2023-08-09)

### Features

- Refactor register interface to allow unregistering an updater
  ([#60](https://github.com/pyenphase/pyenphase/pull/60),
  [`82efcec`](https://github.com/pyenphase/pyenphase/commit/82efcec228dbe263c3f1c39e6ded3e9283fbfac2))


## v1.2.2 (2023-08-09)

### Bug Fixes

- Remove unreachable code in inverters updater
  ([#61](https://github.com/pyenphase/pyenphase/pull/61),
  [`84b6be0`](https://github.com/pyenphase/pyenphase/commit/84b6be081cde7bf624baaae2b5df5c1177144dec))


## v1.2.1 (2023-08-09)

### Bug Fixes

- Incorrect typing on enpower mains_*_state attributes
  ([#59](https://github.com/pyenphase/pyenphase/pull/59),
  [`14c7c14`](https://github.com/pyenphase/pyenphase/commit/14c7c14124ca33df6e011b1fa32ed4c57da7e294))

### Chores

- Add collected and mocked fixtures for 3.7.0
  ([#58](https://github.com/pyenphase/pyenphase/pull/58),
  [`56ba6fa`](https://github.com/pyenphase/pyenphase/commit/56ba6fa54cdac7f4680697a5a54d97d595246f30))

- Update 3.17.3 with new fixture downloader ([#57](https://github.com/pyenphase/pyenphase/pull/57),
  [`afb525c`](https://github.com/pyenphase/pyenphase/commit/afb525ce60900192cfa1e088a890da652b1b70bd))

- Update fixtures for 3.9.36 with new fixture fetcher
  ([#56](https://github.com/pyenphase/pyenphase/pull/56),
  [`20e7bbf`](https://github.com/pyenphase/pyenphase/commit/20e7bbfee2d9a49b2cb10bb3766ab6eb6cd2af18))


## v1.2.0 (2023-08-09)

### Chores

- Update firmware 7.3.517 fixtures ([#55](https://github.com/pyenphase/pyenphase/pull/55),
  [`c2dcb19`](https://github.com/pyenphase/pyenphase/commit/c2dcb19e4ea1aef815c145ad5dc688881215dcc2))

### Features

- Refactor to break updaters into modules ([#54](https://github.com/pyenphase/pyenphase/pull/54),
  [`a4686a3`](https://github.com/pyenphase/pyenphase/commit/a4686a30be37f88a3af27257b4a8d017d1579122))


## v1.1.4 (2023-08-08)

### Bug Fixes

- Return DryContactStatus enum for status ([#53](https://github.com/pyenphase/pyenphase/pull/53),
  [`d366ff3`](https://github.com/pyenphase/pyenphase/commit/d366ff3c86a3419bb0ffcbd24a1edb0333b0a32f))


## v1.1.3 (2023-08-08)

### Bug Fixes

- Handle envoy sending bad json ([#52](https://github.com/pyenphase/pyenphase/pull/52),
  [`7109e66`](https://github.com/pyenphase/pyenphase/commit/7109e6604f5fc1d1b197a128ceb264c9e00410d4))


## v1.1.2 (2023-08-08)

### Bug Fixes

- Adjust timeouts for when envoy is having trouble with DNS
  ([#51](https://github.com/pyenphase/pyenphase/pull/51),
  [`c82f9bb`](https://github.com/pyenphase/pyenphase/commit/c82f9bbf69f884516985dde04207d375c4953ad3))


## v1.1.1 (2023-08-08)

### Bug Fixes

- Add Enpower and DryContact classes to __all__
  ([#50](https://github.com/pyenphase/pyenphase/pull/50),
  [`d37b5e9`](https://github.com/pyenphase/pyenphase/commit/d37b5e9b6e6f12d62ba57a2f6d745868adf67914))


## v1.1.0 (2023-08-08)

### Features

- Add support for pulling dry contact data ([#48](https://github.com/pyenphase/pyenphase/pull/48),
  [`7814650`](https://github.com/pyenphase/pyenphase/commit/78146506bb4a93b51987a2b8725cc32f35368643))


## v1.0.0 (2023-08-08)

### Refactoring

- Drop python3.10 support ([#49](https://github.com/pyenphase/pyenphase/pull/49),
  [`9d8c20d`](https://github.com/pyenphase/pyenphase/commit/9d8c20d8f1d9b08b57649f7c8b84715f25312887))


## v0.18.0 (2023-08-08)

### Features

- Add support for polling Enpower data ([#47](https://github.com/pyenphase/pyenphase/pull/47),
  [`0ac58e0`](https://github.com/pyenphase/pyenphase/commit/0ac58e0396d67b4e858deba08eb6bef5c6de9f39))


## v0.17.0 (2023-08-07)

### Features

- Add fixtures for 7.6.114 without clamps ([#44](https://github.com/pyenphase/pyenphase/pull/44),
  [`4be0a33`](https://github.com/pyenphase/pyenphase/commit/4be0a339ed9ae458246f2260e03c5d4c89c58410))


## v0.16.0 (2023-08-07)

### Features

- Collect headers as well as XML files ([#43](https://github.com/pyenphase/pyenphase/pull/43),
  [`82678be`](https://github.com/pyenphase/pyenphase/commit/82678be2bdcd59b77befc04883b2bb4693789f36))

- Update 7.6.175 fixtures ([#45](https://github.com/pyenphase/pyenphase/pull/45),
  [`9c96475`](https://github.com/pyenphase/pyenphase/commit/9c96475f345786a24b5b786a4880a949a01cabd8))


## v0.15.1 (2023-08-07)

### Bug Fixes

- Add Encharge classes to __all__ ([#42](https://github.com/pyenphase/pyenphase/pull/42),
  [`229a84d`](https://github.com/pyenphase/pyenphase/commit/229a84df72a1ec6292f47fe426c46890feb1b83e))


## v0.15.0 (2023-08-07)

### Chores

- Remove unreachable code ([#39](https://github.com/pyenphase/pyenphase/pull/39),
  [`4335835`](https://github.com/pyenphase/pyenphase/commit/43358358ceb32ed114987931e90db1e7176d05ef))

### Features

- Add Encharge battery support ([#40](https://github.com/pyenphase/pyenphase/pull/40),
  [`e1a96e9`](https://github.com/pyenphase/pyenphase/commit/e1a96e9de3ade6429561ef863ed8302b481e02df))


## v0.14.1 (2023-08-07)

### Bug Fixes

- Probe failures with 5.0.62 firmware ([#38](https://github.com/pyenphase/pyenphase/pull/38),
  [`314df6d`](https://github.com/pyenphase/pyenphase/commit/314df6d83c4dfd7c91970e61f86e34218ce46be8))

### Chores

- Add tests for 7.6.175 with CTs ([#37](https://github.com/pyenphase/pyenphase/pull/37),
  [`84884f9`](https://github.com/pyenphase/pyenphase/commit/84884f9c1fa40ba7a78babfb1173a088c4c10248))


## v0.14.0 (2023-08-06)

### Chores

- Add second 7.6.175 fixtures ([#35](https://github.com/pyenphase/pyenphase/pull/35),
  [`6bf5309`](https://github.com/pyenphase/pyenphase/commit/6bf530964b13aa3c20524cc18626f64f15118c00))

### Features

- Add part number ([#36](https://github.com/pyenphase/pyenphase/pull/36),
  [`5b1d46d`](https://github.com/pyenphase/pyenphase/commit/5b1d46dd7c64180fff3118b087330a48de6646fe))


## v0.13.0 (2023-08-06)

### Features

- Add fixture collecting script ([#30](https://github.com/pyenphase/pyenphase/pull/30),
  [`5d66ee9`](https://github.com/pyenphase/pyenphase/commit/5d66ee96154bbd6238a27b6e449b6bb0aece3a54))


## v0.12.0 (2023-08-06)

### Chores

- Add test fixtures from Envoy 7.3.517 and Ensemble
  ([#29](https://github.com/pyenphase/pyenphase/pull/29),
  [`31ffcfa`](https://github.com/pyenphase/pyenphase/commit/31ffcfa00bd39c62df3abf791c250b859234f1b3))

- Add tests for 7.3.517 firmware/setup ([#33](https://github.com/pyenphase/pyenphase/pull/33),
  [`4d6434f`](https://github.com/pyenphase/pyenphase/commit/4d6434f0af01e0b4aff50d0d5624eb63519f91a5))

- Update gitignore ([#32](https://github.com/pyenphase/pyenphase/pull/32),
  [`57f5b52`](https://github.com/pyenphase/pyenphase/commit/57f5b526706151a0124a99983909a4f3f2aec1e2))

### Features

- Probe for Encharge and Enpower support ([#26](https://github.com/pyenphase/pyenphase/pull/26),
  [`da2db7d`](https://github.com/pyenphase/pyenphase/commit/da2db7d8005c81153dff6b5802d3c4851dd79432))

### Refactoring

- Small cleanups ([#31](https://github.com/pyenphase/pyenphase/pull/31),
  [`3b4c5ae`](https://github.com/pyenphase/pyenphase/commit/3b4c5ae1070cd2e67df0d1155422a03be8d1c887))


## v0.11.0 (2023-08-06)

### Features

- Add support for bifurcated endpoints ([#28](https://github.com/pyenphase/pyenphase/pull/28),
  [`7853cfd`](https://github.com/pyenphase/pyenphase/commit/7853cfd1ecb2e1cadf8e874f6d351c4efe408a79))


## v0.10.0 (2023-08-06)

### Features

- Add the ability to refresh the token on demand
  ([#25](https://github.com/pyenphase/pyenphase/pull/25),
  [`d1e391c`](https://github.com/pyenphase/pyenphase/commit/d1e391ccd9fcc9fcb3636f6f4a101005998f9f60))


## v0.9.0 (2023-08-05)

### Features

- Add EnvoyTokenAuth to __all__ ([#24](https://github.com/pyenphase/pyenphase/pull/24),
  [`738f4c7`](https://github.com/pyenphase/pyenphase/commit/738f4c7b1385e1045e9ca5065e06b0816d6a398f))


## v0.8.0 (2023-08-05)

### Features

- Add EnvoyData to __all__ ([#23](https://github.com/pyenphase/pyenphase/pull/23),
  [`63f9ba9`](https://github.com/pyenphase/pyenphase/commit/63f9ba94f7d10945aa314836f9a7425cda28ae59))


## v0.7.1 (2023-08-05)

### Bug Fixes

- Legacy installer auth was not working ([#22](https://github.com/pyenphase/pyenphase/pull/22),
  [`a2dd5e5`](https://github.com/pyenphase/pyenphase/commit/a2dd5e55ccfc796d7e162ccc75bb116fde1ca631))


## v0.7.0 (2023-08-05)

### Features

- Export a few more models for type checking ([#21](https://github.com/pyenphase/pyenphase/pull/21),
  [`e2337c4`](https://github.com/pyenphase/pyenphase/commit/e2337c4b8bf69e816611e76e4239fdbea78bf6e9))


## v0.6.1 (2023-08-05)

### Bug Fixes

- Unclosed cloud client session ([#20](https://github.com/pyenphase/pyenphase/pull/20),
  [`b46282a`](https://github.com/pyenphase/pyenphase/commit/b46282a9f9ed20be4487582cd2461a02b7740de6))


## v0.6.0 (2023-08-05)

### Features

- Export names at top level ([#19](https://github.com/pyenphase/pyenphase/pull/19),
  [`b209357`](https://github.com/pyenphase/pyenphase/commit/b2093578d12978da49788ca08c3959d2c3fb3641))


## v0.5.0 (2023-08-05)

### Features

- Add consumption api ([#17](https://github.com/pyenphase/pyenphase/pull/17),
  [`f094c4d`](https://github.com/pyenphase/pyenphase/commit/f094c4d129cbb26e0f6bf3cf9024967a0def46e7))


## v0.4.0 (2023-08-05)

### Chores

- Add comments for properties that come from additional API endpoints
  ([#14](https://github.com/pyenphase/pyenphase/pull/14),
  [`73520b6`](https://github.com/pyenphase/pyenphase/commit/73520b6c72e1dfb867d945054fcada84ee75d879))

- Adjust CI to only validate PR title ([#12](https://github.com/pyenphase/pyenphase/pull/12),
  [`b518216`](https://github.com/pyenphase/pyenphase/commit/b518216d37eadb46b9ad0c785b7182bac94453b2))

- Cleanup duplicate endpoints ([#15](https://github.com/pyenphase/pyenphase/pull/15),
  [`cb0ed2a`](https://github.com/pyenphase/pyenphase/commit/cb0ed2a66c8d4242345dab390b7636cf4c81e7d0))

- Only run action-semantic-pull-request on pull request
  ([#18](https://github.com/pyenphase/pyenphase/pull/18),
  [`ce022aa`](https://github.com/pyenphase/pyenphase/commit/ce022aab4a7594a66ebc97da503a1fc3a0b6b661))

- Start bootstrapping some models ([#13](https://github.com/pyenphase/pyenphase/pull/13),
  [`c5d2f36`](https://github.com/pyenphase/pyenphase/commit/c5d2f364f00c9efd7b3c239d2bb16c6affd84ff7))

### Features

- Add update functions ([#16](https://github.com/pyenphase/pyenphase/pull/16),
  [`d2802e0`](https://github.com/pyenphase/pyenphase/commit/d2802e0e9322050d37e0affa4a87f127731c29a2))


## v0.3.0 (2023-07-26)

### Chores

- Update deps to fix certifi vuln ([#10](https://github.com/pyenphase/pyenphase/pull/10),
  [`243d28b`](https://github.com/pyenphase/pyenphase/commit/243d28b9e7be10aba73d8f7fefc2123f0ea717fc))

### Features

- Add support for legacy firmware ([#11](https://github.com/pyenphase/pyenphase/pull/11),
  [`49cb15c`](https://github.com/pyenphase/pyenphase/commit/49cb15c58cde38dc41ff30c24c3365c491605274))


## v0.2.0 (2023-07-26)

### Chores

- Bump PSR to fix release process ([#8](https://github.com/pyenphase/pyenphase/pull/8),
  [`d2889e2`](https://github.com/pyenphase/pyenphase/commit/d2889e2c10e4565cddee1c10c337159fa4fa4e8b))

- Remove unused labels workflow ([#9](https://github.com/pyenphase/pyenphase/pull/9),
  [`a4c9d1b`](https://github.com/pyenphase/pyenphase/commit/a4c9d1bf158bcc8899c6388dc15d0a4938f78a79))

### Features

- Use cookie sessionId ([#7](https://github.com/pyenphase/pyenphase/pull/7),
  [`09a1a8a`](https://github.com/pyenphase/pyenphase/commit/09a1a8aa30f2e3be1aa636f2488dc736f4d4f476))

- Use sessionId cookie to have access to some endpoints
  ([#7](https://github.com/pyenphase/pyenphase/pull/7),
  [`09a1a8a`](https://github.com/pyenphase/pyenphase/commit/09a1a8aa30f2e3be1aa636f2488dc736f4d4f476))


## v0.1.0 (2023-05-28)

### Chores

- Add constants for API endpoint URLs ([#5](https://github.com/pyenphase/pyenphase/pull/5),
  [`9583a1f`](https://github.com/pyenphase/pyenphase/commit/9583a1fdc1d6070897fc6793c7f2dc8f13482bc2))

### Features

- Add initial cloud auth support ([#6](https://github.com/pyenphase/pyenphase/pull/6),
  [`28f4872`](https://github.com/pyenphase/pyenphase/commit/28f4872625a01ee209153d489de566b7ba2302e6))


## v0.0.3 (2023-05-23)

- Initial Release
