
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2451179.4,
          {1.3826,0.02699,380.91,1.13444,0.006587,0.7778}, /*cmx*/
          {2.864373,1.2889,0.8982,0.1676}, /*cfx*/
          {0.5811,0.0139,181.4814,0.52714,0.003117,0.3722}, /*cmy*/
          {2.945919,1.4661,0.7458,0.2509}, /*cfy*/
          {-2.1712,0.02844,421.4696,1.26645,0.006335,0.8564}, /*cmz*/
          {4.450317,2.8913,2.4074,1.7442} /*cfz*/
     },
     {
          2451209.4,
          {2.0829,0.01389,380.5984,1.49753,0.003749,0.812}, /*cmx*/
          {2.494787,0.9268,0.0537,6.2209}, /*cfx*/
          {0.9482,0.008,182.1898,0.67594,0.00264,0.3908}, /*cmy*/
          {2.581254,1.0201,5.966,0.0216}, /*cfy*/
          {-1.2651,0.04325,421.4573,1.62353,0.00501,0.8455}, /*cmz*/
          {4.081602,2.521,1.5461,1.447} /*cfz*/
     },
     {
          2451239.4,
          {2.3611,-0.00747,381.0528,1.64827,0.003436,0.8124}, /*cmx*/
          {2.104742,0.5628,5.3183,5.9734}, /*cfx*/
          {1.1171,-0.00209,181.2761,0.72749,0.00304,0.386}, /*cmy*/
          {2.199954,0.5448,5.0947,6.0681}, /*cfy*/
          {-0.0485,0.0476,421.4653,1.79781,0.003764,0.8521}, /*cmz*/
          {3.693457,2.1187,0.6372,1.2065} /*cfz*/
     },
     {
          2451269.4,
          {2.0934,-0.0295,382.7445,1.6441,0.002914,0.7914}, /*cmx*/
          {1.708213,0.1772,4.4892,5.6997}, /*cfx*/
          {1.023,-0.01237,178.089,0.70675,0.002797,0.364}, /*cmy*/
          {1.814912,0.0251,4.3738,5.8108}, /*cfy*/
          {1.2799,0.03385,421.3461,1.83318,0.004462,0.8482}, /*cmz*/
          {3.298682,1.7268,5.8206,0.9607} /*cfz*/
     },
     {
          2451299.4,
          {1.2438,-0.03954,385.3988,1.56072,0.003843,0.7863}, /*cmx*/
          {1.316444,6.0778,3.3422,5.3816}, /*cfx*/
          {0.6584,-0.01649,172.536,0.65374,0.002709,0.3428}, /*cmy*/
          {1.436711,5.7804,3.4206,5.5096}, /*cfy*/
          {2.2937,0.01152,421.2112,1.70339,0.005733,0.8421}, /*cmz*/
          {2.907423,1.347,5.1742,0.7006} /*cfz*/
     },
     {
          2451329.4,
          {0.0223,-0.03587,388.5407,1.36288,0.006606,0.7743}, /*cmx*/
          {0.938037,5.7277,2.7679,5.1133}, /*cfx*/
          {0.1434,-0.01427,165.275,0.55356,0.003266,0.3201}, /*cmy*/
          {1.073506,5.2817,2.6149,5.2682}, /*cfy*/
          {2.6673,-0.00838,421.227,1.43611,0.006372,0.8865}, /*cmz*/
          {2.529255,0.9594,4.4592,0.4331} /*cfz*/
     },
     {
          2451359.4,
          {-1.1415,-0.02615,391.7219,0.99385,0.008631,0.7678}, /*cmx*/
          {0.582247,5.401,2.3541,4.9192}, /*cfx*/
          {-0.3284,-0.01002,157.788,0.3914,0.003613,0.3029}, /*cmy*/
          {0.733533,4.7916,1.9135,5.0991}, /*cfy*/
          {2.3082,-0.0182,421.2006,1.05494,0.008892,0.9197}, /*cmz*/
          {2.173872,0.5856,3.7865,0.2299} /*cfz*/
     },
     {
          2451389.4,
          {-1.9548,-0.01533,394.1826,0.46961,0.010368,0.7526}, /*cmx*/
          {0.260112,5.072,1.9264,4.7706}, /*cfx*/
          {-0.6541,-0.00673,152.122,0.18256,0.004258,0.2877}, /*cmy*/
          {0.425645,4.2381,1.3102,4.9679}, /*cfy*/
          {1.5183,-0.02405,421.0865,0.4953,0.011353,0.9184}, /*cmz*/
          {1.851732,0.2659,3.4101,0.1007} /*cfz*/
     },
     {
          2451419.4,
          {-2.3166,-0.00592,394.8912,0.17456,0.010018,0.7664}, /*cmx*/
          {6.265416,1.6541,1.6632,4.6608}, /*cfx*/
          {-0.8301,-0.00469,150.3292,0.09209,0.003977,0.2948}, /*cmy*/
          {0.156731,1.4573,1.0549,4.8446}, /*cfy*/
          {0.6115,-0.02701,421.0218,0.23969,0.009703,0.8663}, /*cmz*/
          {1.573932,3.1146,3.2022,6.2635} /*cfz*/
     },
     {
          2451449.4,
          {-2.3674,0.00436,393.6112,0.7807,0.003448,0.7903}, /*cmx*/
          {6.034984,1.4003,1.8181,4.5262}, /*cfx*/
          {-0.9261,-0.0014,153.3345,0.3283,0.0011,0.3124}, /*cmy*/
          {6.209204,0.8969,1.4377,4.6937}, /*cfy*/
          {-0.2387,-0.02729,421.0791,0.90765,0.001573,0.8478}, /*cmz*/
          {1.344499,2.9242,3.4221,6.1721} /*cfz*/
     },
     {
          2451479.4,
          {-2.1765,0.01403,391.1994,0.94798,0.007622,0.7987}, /*cmx*/
          {5.834586,1.1973,4.1793,4.4129}, /*cfx*/
          {-0.9438,0.00351,159.1384,0.38048,0.003459,0.3279}, /*cmy*/
          {5.999467,0.7033,3.8003,4.5729}, /*cfy*/
          {-1.0467,-0.02263,421.1739,1.03889,0.0091,0.8796}, /*cmz*/
          {1.145282,2.7406,5.8818,6.0805} /*cfz*/
     },
     {
          2451509.4,
          {-1.7645,0.02436,389.2615,0.48413,0.012991,0.7884}, /*cmx*/
          {5.623213,0.9927,4.0992,4.2835}, /*cfx*/
          {-0.8468,0.00946,163.7819,0.17232,0.005479,0.3285}, /*cmy*/
          {5.77551,0.4046,3.7509,4.4397}, /*cfy*/
          {-1.8368,-0.01409,421.244,0.48203,0.013263,0.9043}, /*cmz*/
          {0.933741,2.5342,5.6863,5.9921} /*cfz*/
     },
     {
          2451539.4,
          {-1.0019,0.03017,388.7642,0.28151,0.011312,0.7692}, /*cmx*/
          {5.364675,3.8357,3.8334,4.1455}, /*cfx*/
          {-0.5594,0.01281,164.847,0.16016,0.004549,0.3198}, /*cmy*/
          {5.507716,3.7423,3.3851,4.2962}, /*cfy*/
          {-2.467,-0.00298,421.2909,0.3356,0.011493,0.8794}, /*cmz*/
          {0.673829,5.4091,5.3112,5.8218} /*cfz*/
     },
     {
          2451569.4,
          {0.0349,0.03236,389.8679,0.95207,0.007368,0.7897}, /*cmx*/
          {5.051482,3.5667,3.3058,3.9441}, /*cfx*/
          {-0.1283,0.01336,161.9643,0.42618,0.00319,0.3186}, /*cmy*/
          {5.191856,3.2456,2.537,4.0818}, /*cfy*/
          {-2.7006,0.00938,421.3783,1.02912,0.007992,0.8214}, /*cmz*/
          {0.359391,5.0691,4.8143,5.5633} /*cfz*/
     },
     {
          2451599.4,
          {1.1495,0.02802,392.6002,1.37283,0.00538,0.8214}, /*cmx*/
          {4.696234,3.2272,2.539,3.7026}, /*cfx*/
          {0.3298,0.01028,155.267,0.5815,0.003139,0.3129}, /*cmy*/
          {4.840786,2.7666,1.5708,3.8399}, /*cfy*/
          {-2.3699,0.02334,421.3262,1.49966,0.004596,0.8244}, /*cmz*/
          {0.003523,4.7054,4.0903,5.2534} /*cfz*/
     },
     {
          2451629.4,
          {2.0496,0.01598,396.7628,1.5956,0.003763,0.8633}, /*cmx*/
          {4.31641,2.8354,1.8583,3.4424}, /*cfx*/
          {0.6631,0.00451,144.8731,0.66185,0.002979,0.2999}, /*cmy*/
          {4.471615,2.2234,0.7312,3.5843}, /*cfy*/
          {-1.5599,0.0391,421.1787,1.74602,0.003774,0.8437}, /*cmz*/
          {5.90571,4.3359,2.9115,4.975} /*cfz*/
     },
     {
          2451659.4,
          {2.5408,-0.00606,401.6292,1.7027,0.002683,0.8716}, /*cmx*/
          {3.926409,2.4384,0.5558,3.1656}, /*cfx*/
          {0.7996,-0.00317,131.0323,0.69768,0.003068,0.2652}, /*cmy*/
          {4.099217,1.6705,6.121,3.321}, /*cfy*/
          {-0.3775,0.04607,421.1199,1.79229,0.004168,0.8456}, /*cmz*/
          {5.513566,3.9488,2.1413,4.7494} /*cfz*/
     },
     {
          2451689.4,
          {2.4524,-0.02917,406.576,1.67218,0.004539,0.8442}, /*cmx*/
          {3.536525,2.0574,5.8644,2.9109}, /*cfx*/
          {0.7253,-0.00872,114.568,0.68319,0.003168,0.2215}, /*cmy*/
          {3.735512,1.1208,5.3714,3.0925}, /*cfy*/
          {0.9385,0.03761,421.1747,1.72371,0.003959,0.8302}, /*cmz*/
          {5.121702,3.5451,1.2329,4.4827} /*cfz*/
     },
     {
          2451719.4,
          {1.7025,-0.04109,411.1478,1.48231,0.005582,0.8183}, /*cmx*/
          {3.155751,1.671,5.2254,2.6496}, /*cfx*/
          {0.4979,-0.00955,96.9967,0.62682,0.002827,0.181}, /*cmy*/
          {3.391962,0.5714,4.5016,2.8912}, /*cfy*/
          {2.1026,0.01439,421.1437,1.55623,0.005827,0.8456}, /*cmz*/
          {4.738927,3.161,0.3558,4.2114} /*cfz*/
     },
     {
          2451749.4,
          {0.5085,-0.03941,414.7884,1.17991,0.007609,0.8106}, /*cmx*/
          {2.793392,1.2769,4.4848,2.4222}, /*cfx*/
          {0.2362,-0.00711,80.4514,0.52632,0.003375,0.1501}, /*cmy*/
          {3.079774,0.062,3.512,2.7605}, /*cfy*/
          {2.7079,-0.00749,421.1636,1.22471,0.008062,0.9065}, /*cmz*/
          {4.373912,2.8018,6.0874,3.9741} /*cfz*/
     },
     {
          2451779.4,
          {-0.7424,-0.0302,416.9722,0.733,0.010953,0.8493}, /*cmx*/
          {2.459165,0.93,4.0406,2.2587}, /*cfx*/
          {0.0291,-0.00483,67.5962,0.34644,0.004571,0.135}, /*cmy*/
          {2.803382,5.9017,2.8635,2.6525}, /*cfy*/
          {2.6329,-0.02074,421.3131,0.71751,0.010017,0.9242}, /*cmz*/
          {4.037512,2.4407,5.5844,3.7878} /*cfz*/
     },
     {
          2451809.4,
          {-1.6646,-0.02212,417.81,0.08876,0.011679,0.8579}, /*cmx*/
          {2.164094,0.8908,3.8377,2.1334}, /*cfx*/
          {-0.1106,-0.00479,61.3072,0.07354,0.004903,0.1289}, /*cmy*/
          {2.548702,5.3993,2.516,2.5267}, /*cfy*/
          {2.0524,-0.02537,421.3631,0.07336,0.011184,0.902}, /*cmz*/
          {3.741811,1.629,5.2148,3.6459} /*cfz*/
     },
     {
          2451839.4,
          {-2.2286,-0.01279,417.4854,0.63983,0.006191,0.8384}, /*cmx*/
          {1.916395,3.5069,3.8406,2.017}, /*cfx*/
          {-0.2409,-0.00558,63.5282,0.24161,0.002805,0.1367}, /*cmy*/
          {2.290333,2.3078,2.428,2.3485}, /*cfy*/
          {1.2976,-0.02871,421.2206,0.65093,0.006553,0.8668}, /*cmz*/
          {3.494806,5.1019,5.0482,3.5275} /*cfz*/
     },
     {
          2451869.4,
          {-2.5007,-0.0022,416.0023,1.02101,0.004846,0.8059}, /*cmx*/
          {1.70857,3.3599,6.2726,1.8685}, /*cfx*/
          {-0.3901,-0.00465,73.1853,0.41861,0.001507,0.1523}, /*cmy*/
          {2.030496,2.1195,5.1576,2.1586}, /*cfy*/
          {0.5532,-0.03334,421.1887,1.04861,0.00437,0.8806}, /*cmz*/
          {3.288273,4.8725,1.6337,3.4684} /*cfz*/
     },
     {
          2451899.4,
          {-2.5761,0.01234,413.8585,0.71297,0.011588,0.8045}, /*cmx*/
          {1.505918,3.1949,0.0416,1.7528}, /*cfx*/
          {-0.5268,-0.00043,84.3021,0.31508,0.004475,0.1714}, /*cmy*/
          {1.777815,1.8924,5.2085,2.0278}, /*cfy*/
          {-0.2388,-0.03629,421.2957,0.75824,0.01259,0.9177}, /*cmz*/
          {3.086934,4.6771,1.5447,3.3843} /*cfz*/
     },
     {
          2451929.4,
          {-2.3217,0.02542,412.5432,0.02412,0.011606,0.8279}, /*cmx*/
          {1.2664,5.8734,6.0334,1.6268}, /*cfx*/
          {-0.5544,0.0043,89.8138,0.07049,0.004824,0.1786}, /*cmy*/
          {1.511372,0.6326,4.8824,1.8961}, /*cfy*/
          {-1.1511,-0.03105,421.4248,0.02824,0.012517,0.9206}, /*cmz*/
          {2.848159,0.4723,1.3131,3.2535} /*cfz*/
     },
     {
          2451959.4,
          {-1.635,0.03534,413.096,0.73003,0.009168,0.8313}, /*cmx*/
          {0.973198,5.7806,5.5618,1.4587}, /*cfx*/
          {-0.4316,0.00696,86.9691,0.27002,0.004028,0.1651}, /*cmy*/
          {1.215531,4.8856,4.2834,1.7369}, /*cfy*/
          {-2.0555,-0.01678,421.3744,0.79999,0.008159,0.8899}, /*cmz*/
          {2.554581,0.9698,0.8754,3.0198} /*cfz*/
     },
     {
          2451989.4,
          {-0.5334,0.03888,415.2176,1.2455,0.006182,0.8385}, /*cmx*/
          {0.634835,5.4135,5.0088,1.189}, /*cfx*/
          {-0.2056,0.00598,76.4816,0.48596,0.003271,0.1349}, /*cmy*/
          {0.899905,4.3304,3.4471,1.4905}, /*cfy*/
          {-2.5802,-0.00013,421.2826,1.33014,0.00517,0.852}, /*cmz*/
          {2.214348,0.6538,0.0349,2.7418} /*cfz*/
     },
     {
          2452019.4,
          {0.6967,0.03833,417.8655,1.57279,0.003744,0.8544}, /*cmx*/
          {0.267214,5.0319,4.0359,0.8736}, /*cfx*/
          {-0.0047,0.00278,60.1522,0.62912,0.003134,0.0949}, /*cmy*/
          {0.592916,3.8077,2.5296,1.2414}, /*cfy*/
          {-2.5184,0.01754,421.3242,1.60783,0.004149,0.8468}, /*cmz*/
          {1.844059,0.2772,5.512,2.4818} /*cfz*/
     },
     {
          2452049.4,
          {1.7569,0.02902,420.2182,1.70988,0.004124,0.8962}, /*cmx*/
          {6.167562,4.6376,2.9046,0.6102}, /*cfx*/
          {0.082,-0.00104,40.359,0.70736,0.003082,0.0541}, /*cmy*/
          {0.358391,3.2747,1.7107,1.1644}, /*cfy*/
          {-1.8508,0.03342,421.3679,1.7405,0.003038,0.832}, /*cmz*/
          {1.458949,6.1624,4.4807,2.2482} /*cfz*/
     },
     {
          2452079.4,
          {2.4386,0.00815,421.665,1.69234,0.004288,0.8937}, /*cmx*/
          {5.780837,4.2177,2.0679,0.3805}, /*cfx*/
          {0.0451,-0.00297,21.6053,0.73071,0.002825,0.0267}, /*cmy*/
          {0.442885,2.7452,0.8662,1.9896}, /*cfy*/
          {-0.7829,0.04473,421.269,1.74439,0.004317,0.8247}, /*cmz*/
          {1.069851,5.7824,3.4317,2.0253} /*cfz*/
     },
     {
          2452109.4,
          {2.5627,-0.01737,421.775,1.58146,0.005532,0.8548}, /*cmx*/
          {5.399509,3.7969,1.0771,0.1614}, /*cfx*/
          {-0.0492,-0.00149,19.6288,0.69618,0.002668,0.0513}, /*cmy*/
          {1.256299,2.2363,6.1991,2.7094}, /*cfy*/
          {0.5087,0.04101,421.2796,1.58421,0.005347,0.8346}, /*cmz*/
          {0.685753,5.4081,2.8276,1.7505} /*cfz*/
     },
     {
          2452139.4,
          {2.0517,-0.03422,420.627,1.32967,0.008171,0.8479}, /*cmx*/
          {5.031797,3.411,0.4458,6.2023}, /*cfx*/
          {-0.1,0.00202,35.1198,0.59794,0.003112,0.0843}, /*cmy*/
          {1.431986,1.7635,5.2193,2.701}, /*cfy*/
          {1.7013,0.02511,421.4921,1.29782,0.006353,0.8446}, /*cmz*/
          {0.316209,5.0195,2.0455,1.4771} /*cfz*/
     },
     {
          2452169.4,
          {0.9955,-0.03399,419.0116,0.89052,0.010221,0.8663}, /*cmx*/
          {4.687798,3.0578,6.2659,6.0188}, /*cfx*/
          {-0.0339,0.00404,49.9804,0.42458,0.004227,0.1104}, /*cmy*/
          {1.249669,1.3591,4.5088,2.6086}, /*cfy*/
          {2.4678,0.00612,421.6087,0.89984,0.009926,0.8671}, /*cmz*/
          {6.254706,4.6498,1.468,1.2286} /*cfz*/
     },
     {
          2452199.4,
          {-0.1947,-0.02598,417.7707,0.28295,0.011433,0.8934}, /*cmx*/
          {4.379667,2.7307,5.8907,5.9121}, /*cfx*/
          {0.1139,0.00336,58.8488,0.16781,0.005113,0.1235}, /*cmy*/
          {0.999913,1.119,4.1074,2.5448}, /*cfy*/
          {2.6343,-0.00543,421.5349,0.30699,0.012331,0.8583}, /*cmz*/
          {5.946038,4.3625,1.2047,1.0577} /*cfz*/
     },
     {
          2452229.4,
          {-1.1899,-0.01838,417.5725,0.42506,0.008768,0.8679}, /*cmx*/
          {4.11786,5.5982,5.7302,5.8108}, /*cfx*/
          {0.2445,0.00088,59.2564,0.15631,0.004266,0.1139}, /*cmy*/
          {0.746373,3.6502,4.0091,2.434}, /*cfy*/
          {2.3352,-0.01115,421.5289,0.44039,0.009024,0.8534}, /*cmz*/
          {5.683885,0.9412,1.0769,0.9832} /*cfz*/
     },
     {
          2452259.4,
          {-1.8437,-0.0162,418.6436,0.95388,0.001919,0.8399}, /*cmx*/
          {3.900598,5.3918,1.0198,5.691}, /*cfx*/
          {0.2793,-0.00119,50.9756,0.41264,0.001131,0.09}, /*cmy*/
          {0.492486,3.6331,4.9406,2.2658}, /*cfy*/
          {1.8316,-0.01691,421.628,0.9956,0.001266,0.8585}, /*cmz*/
          {5.467289,0.7708,3.3896,0.9207} /*cfz*/
     },
     {
          2452289.4,
          {-2.303,-0.01072,420.0822,0.88374,0.010188,0.8331}, /*cmx*/
          {3.700885,5.2083,1.9835,5.5407}, /*cfx*/
          {0.2348,-0.00194,38.4589,0.41888,0.003882,0.0679}, /*cmy*/
          {0.201799,3.5386,0.3131,1.9979}, /*cfy*/
          {1.2106,-0.0255,421.6624,0.89277,0.009953,0.896}, /*cmz*/
          {5.269136,0.597,3.7761,0.8234} /*cfz*/
     },
     {
          2452319.4,
          {-2.6132,0.00202,420.8787,0.25031,0.012706,0.8543}, /*cmx*/
          {3.475892,4.9669,1.8465,5.4232}, /*cfx*/
          {0.1728,-0.00119,29.7261,0.16989,0.00526,0.0587}, /*cmy*/
          {6.150844,3.3419,0.2135,1.758}, /*cfy*/
          {0.4147,-0.03288,421.5356,0.2171,0.011503,0.9229}, /*cmz*/
          {5.045263,0.367,3.5079,0.6508} /*cfz*/
     },
     {
          2452349.4,
          {-2.65,0.02091,420.8789,0.51287,0.009774,0.8525}, /*cmx*/
          {3.200582,1.6113,1.5161,5.2596}, /*cfx*/
          {0.1424,-0.00056,29.3486,0.15004,0.004428,0.0651}, /*cmy*/
          {5.882056,6.2804,6.071,1.6496}, /*cfy*/
          {-0.6257,-0.03103,421.4492,0.53934,0.009288,0.9105}, /*cmz*/
          {4.769914,3.2528,3.0234,0.4681} /*cfz*/
     },
     {
          2452379.4,
          {-2.1489,0.03403,420.1296,1.09946,0.006192,0.8186}, /*cmx*/
          {2.877108,1.2845,0.8658,5.0291}, /*cfx*/
          {0.1304,-0.00152,37.4406,0.41196,0.003194,0.0853}, /*cmy*/
          {5.681003,5.8728,5.3292,1.5611}, /*cfy*/
          {-1.6973,-0.02022,421.5219,1.10817,0.006735,0.8781}, /*cmz*/
          {4.445797,2.8933,2.4726,0.2552} /*cfz*/
     },
     {
          2452409.4,
          {-1.1003,0.03844,418.5528,1.44294,0.00474,0.8241}, /*cmx*/
          {2.519822,0.9109,6.2799,4.7124}, /*cfx*/
          {0.0681,-0.00414,52.2219,0.58293,0.002652,0.1225}, /*cmy*/
          {5.43974,5.4251,4.3382,1.3785}, /*cfy*/
          {-2.4752,-0.00374,421.5551,1.48723,0.003973,0.8341}, /*cmz*/
          {4.087928,2.5193,1.6866,0.0288} /*cfz*/
     },
     {
          2452439.4,
          {0.2045,0.03575,415.9085,1.615,0.003472,0.8485}, /*cmx*/
          {2.143522,0.4993,5.3905,4.4097}, /*cfx*/
          {-0.0973,-0.00706,70.7775,0.66849,0.002579,0.1684}, /*cmy*/
          {5.139676,4.9375,3.4283,1.1524}, /*cfy*/
          {-2.6438,0.01267,421.4867,1.67714,0.003826,0.8416}, /*cmz*/
          {3.710556,2.1511,0.4835,6.0624} /*cfz*/
     },
     {
          2452469.4,
          {1.3929,0.0274,412.0755,1.67262,0.003924,0.8594}, /*cmx*/
          {1.759632,0.0969,4.1573,4.171}, /*cfx*/
          {-0.3497,-0.00825,90.2614,0.69354,0.00238,0.2118}, /*cmy*/
          {4.804083,4.4288,2.4846,0.954}, /*cfy*/
          {-2.2162,0.03102,421.5185,1.68267,0.004322,0.8602}, /*cmz*/
          {3.325451,1.7686,6.0647,5.8061} /*cfz*/
     },
     {
          2452499.4,
          {2.1984,0.01122,407.5472,1.57493,0.005582,0.8221}, /*cmx*/
          {1.376865,5.9976,3.4473,3.9305}, /*cfx*/
          {-0.6084,-0.00546,108.4815,0.66419,0.002642,0.2393}, /*cmy*/
          {4.45368,3.9387,1.5097,0.7413}, /*cfy*/
          {-1.2957,0.04411,421.6768,1.57407,0.004067,0.8662}, /*cmz*/
          {2.942805,1.3668,5.1392,5.5795} /*cfz*/
     },
     {
          2452529.4,
          {2.5282,-0.01155,403.159,1.32747,0.006484,0.7892}, /*cmx*/
          {1.004657,5.6146,2.7964,3.7172}, /*cfx*/
          {-0.7829,0.00174,123.9101,0.56674,0.003033,0.2579}, /*cmy*/
          {4.104691,3.482,0.6994,0.5518}, /*cfy*/
          {-0.0797,0.04492,421.7171,1.36881,0.006446,0.8391}, /*cmz*/
          {2.571702,0.9864,4.2832,5.323} /*cfz*/
     },
     {
          2452559.4,
          {2.2827,-0.02878,399.4599,0.96559,0.008904,0.8107}, /*cmx*/
          {0.653633,5.241,2.1611,3.5236}, /*cfx*/
          {-0.77,0.00886,135.4382,0.40613,0.003745,0.2843}, /*cmy*/
          {3.770948,3.0658,6.1955,0.3742}, /*cfy*/
          {1.1889,0.03002,421.6746,0.99004,0.009318,0.8105}, /*cmz*/
          {2.22169,0.6508,3.8396,5.073} /*cfz*/
     },
     {
          2452589.4,
          {1.5764,-0.03479,396.8668,0.44188,0.011451,0.8445}, /*cmx*/
          {0.335491,4.9463,1.8302,3.3866}, /*cfx*/
          {-0.5594,0.01227,142.2543,0.18677,0.004881,0.3056}, /*cmy*/
          {3.465261,2.833,5.7437,0.241}, /*cfy*/
          {2.1661,0.01125,421.7178,0.41842,0.010997,0.8344}, /*cmz*/
          {1.904686,0.3521,3.4936,4.8849} /*cfz*/
     },
     {
          2452619.4,
          {0.6342,-0.03066,396.1194,0.25713,0.009621,0.8767}, /*cmx*/
          {0.061599,1.4054,1.6935,3.2712}, /*cfx*/
          {-0.2267,0.01108,143.8537,0.12056,0.004458,0.3143}, /*cmy*/
          {3.198858,4.9913,5.6906,0.1235}, /*cfy*/
          {2.621,-0.00059,421.7864,0.28289,0.009559,0.8431}, /*cmz*/
          {1.632086,3.2086,3.2366,4.8011} /*cfz*/
     },
     {
          2452649.4,
          {-0.2392,-0.02751,397.5742,0.87211,0.002017,0.8534}, /*cmx*/
          {6.118308,1.2764,2.3941,3.1555}, /*cfx*/
          {0.0878,0.00912,140.0341,0.37014,0.001977,0.2916}, /*cmy*/
          {2.974253,5.1779,0.1612,0.0034}, /*cfy*/
          {2.6352,-0.00595,421.8157,0.87536,0.002266,0.8539}, /*cmz*/
          {1.40614,2.9863,3.352,4.7543} /*cfz*/
     },
     {
          2452679.4,
          {-0.9909,-0.02653,400.4351,0.95701,0.008633,0.834}, /*cmx*/
          {5.918869,1.1038,4.2011,3.0527}, /*cfx*/
          {0.3328,0.00769,132.1911,0.41425,0.003545,0.2666}, /*cmy*/
          {2.771149,5.169,1.7173,6.18}, /*cfy*/
          {2.3853,-0.01316,421.8075,0.95496,0.007504,0.8446}, /*cmz*/
          {1.206068,2.7852,5.8484,4.6281} /*cfz*/
     },
     {
          2452709.4,
          {-1.6503,-0.02444,402.8096,0.42712,0.01176,0.8337}, /*cmx*/
          {5.704618,0.8655,4.042,2.9317}, /*cfx*/
          {0.5169,0.00705,124.8236,0.20675,0.004911,0.2546}, /*cmy*/
          {2.550517,5.1657,1.8327,6.0588}, /*cfy*/
          {1.9717,-0.02743,421.7396,0.44136,0.01196,0.8704}, /*cmz*/
          {0.99107,2.5486,5.6749,4.4462} /*cfz*/
     },
     {
          2452739.4,
          {-2.2329,-0.01209,403.378,0.29445,0.010075,0.8549}, /*cmx*/
          {5.443936,3.902,3.6579,2.7955}, /*cfx*/
          {0.6829,0.00442,122.753,0.10573,0.004104,0.2627}, /*cmy*/
          {2.286096,1.2884,1.4955,5.9255}, /*cfy*/
          {1.2546,-0.04053,421.7052,0.29764,0.010638,0.8957}, /*cmz*/
          {0.730402,5.4626,5.3802,4.2452} /*cfz*/
     },
     {
          2452769.4,
          {-2.5457,0.00744,402.0832,0.87543,0.007582,0.8563}, /*cmx*/
          {5.133581,3.4994,3.1701,2.5701}, /*cfx*/
          {0.8075,-0.00077,127.1385,0.35351,0.003095,0.2791}, /*cmy*/
          {1.97786,1.1955,0.784,5.7042}, /*cfy*/
          {0.1961,-0.04351,421.6227,0.9395,0.007002,0.892}, /*cmz*/
          {0.420606,5.1462,4.8748,4.0681} /*cfz*/
     },
     {
          2452799.4,
          {-2.3452,0.02599,399.2703,1.27556,0.004479,0.8292}, /*cmx*/
          {4.786014,3.1138,2.6405,2.2918}, /*cfx*/
          {0.8045,-0.00741,136.0616,0.52032,0.002475,0.2944}, /*cmy*/
          {1.637571,0.7942,6.2577,5.4318}, /*cfy*/
          {-1.0721,-0.03221,421.5804,1.35825,0.00488,0.8659}, /*cmz*/
          {0.073395,4.8095,3.9947,3.829} /*cfz*/
     },
     {
          2452829.4,
          {-1.5587,0.03583,395.3635,1.51293,0.002502,0.8072}, /*cmx*/
          {4.41533,2.7463,1.3755,1.9717}, /*cfx*/
          {0.5918,-0.01273,146.8502,0.62574,0.00199,0.3124}, /*cmy*/
          {1.27724,0.337,5.1968,5.1199}, /*cfy*/
          {-2.1067,-0.0163,421.6605,1.56706,0.004304,0.8484}, /*cmz*/
          {5.98648,4.4323,3.1913,3.545} /*cfz*/
     },
     {
          2452859.4,
          {-0.3908,0.03754,391.1984,1.56798,0.003483,0.7677}, /*cmx*/
          {4.032951,2.3826,0.34,1.6735}, /*cfx*/
          {0.1811,-0.01558,157.4256,0.66256,0.002399,0.3201}, /*cmy*/
          {0.906758,6.1604,4.2021,4.8343}, /*cfy*/
          {-2.5829,0.00052,421.7614,1.64378,0.003283,0.8877}, /*cmz*/
          {5.605893,4.0332,2.229,3.2833} /*cfz*/
     },
     {
          2452889.4,
          {0.7777,0.03366,387.5444,1.48436,0.003655,0.7466}, /*cmx*/
          {3.649465,2.002,5.8459,1.4343}, /*cfx*/
          {-0.3017,-0.01566,166.4643,0.62786,0.002445,0.3293}, /*cmy*/
          {0.535882,5.6869,3.4672,4.6098}, /*cfy*/
          {-2.3917,0.01647,421.7289,1.59749,0.004295,0.8977}, /*cmz*/
          {5.224611,3.6498,1.1457,3.0684} /*cfz*/
     },
     {
          2452919.4,
          {1.7157,0.02117,384.6831,1.31536,0.005435,0.7358}, /*cmx*/
          {3.274806,1.6283,4.9673,1.2245}, /*cfx*/
          {-0.7409,-0.01106,173.1993,0.54781,0.00261,0.3364}, /*cmy*/
          {0.174039,5.2094,2.4549,4.4147}, /*cfy*/
          {-1.6966,0.03269,421.7263,1.38586,0.005744,0.8673}, /*cmz*/
          {4.851873,3.2767,0.4425,2.8797} /*cfz*/
     },
     {
          2452949.4,
          {2.2396,0.00339,382.6449,1.00839,0.008412,0.741}, /*cmx*/
          {2.918883,1.3035,4.5326,1.0482}, /*cfx*/
          {-1.0214,-0.00314,177.4278,0.41147,0.003839,0.3467}, /*cmy*/
          {6.113753,4.799,1.738,4.2488}, /*cfy*/
          {-0.6667,0.04002,421.7724,1.03005,0.007843,0.8259}, /*cmz*/
          {4.498441,2.9032,6.0783,2.6426} /*cfz*/
     },
     {
          2452979.4,
          {2.2973,-0.01302,381.5931,0.50594,0.00999,0.7754}, /*cmx*/
          {2.59338,1.0334,4.2286,0.8507}, /*cfx*/
          {-1.0932,0.00485,179.6033,0.18825,0.004532,0.3654}, /*cmy*/
          {5.799342,4.5367,1.3508,4.0573}, /*cfy*/
          {0.5028,0.03355,421.7005,0.5287,0.010851,0.8111}, /*cmz*/
          {4.175864,2.5515,5.6655,2.4523} /*cfz*/
     },
     {
          2453009.4,
          {1.8839,-0.01837,381.3572,0.14308,0.008733,0.8021}, /*cmx*/
          {2.310739,3.7728,3.9453,0.6974}, /*cfx*/
          {-0.9375,0.00806,180.3142,0.10585,0.003746,0.3766}, /*cmy*/
          {5.524904,0.7019,1.1461,3.9086}, /*cfy*/
          {1.5406,0.019,421.5733,0.14099,0.010516,0.8308}, /*cmz*/
          {3.895237,5.4537,5.4857,2.3538} /*cfz*/
     },
     {
          2453039.4,
          {1.2264,-0.01798,381.692,0.73704,0.002814,0.8154}, /*cmx*/
          {2.076078,3.6252,3.809,0.6074}, /*cfx*/
          {-0.6498,0.00848,179.7656,0.35355,0.001208,0.3775}, /*cmy*/
          {5.293758,0.7128,1.6613,3.8181}, /*cfy*/
          {2.2529,0.00715,421.6697,0.79358,0.003634,0.8316}, /*cmz*/
          {3.661014,5.2264,5.5735,2.326} /*cfz*/
     },
     {
          2453069.4,
          {0.4979,-0.01845,382.5627,0.92613,0.005891,0.7875}, /*cmx*/
          {1.873828,3.4068,0.2112,0.562}, /*cfx*/
          {-0.3104,0.00874,177.7991,0.40802,0.003045,0.3592}, /*cmy*/
          {5.089344,0.6123,3.5264,3.7722}, /*cfy*/
          {2.5802,0.00199,421.831,1.0004,0.006638,0.8343}, /*cmz*/
          {3.458016,5.0524,1.8386,2.2449} /*cfz*/
     },
     {
          2453099.4,
          {-0.2332,-0.02388,383.6996,0.56376,0.01112,0.7943}, /*cmx*/
          {1.665743,3.1569,0.0179,0.4838}, /*cfx*/
          {0.0329,0.0111,175.1946,0.22497,0.004893,0.3601}, /*cmy*/
          {4.875135,0.498,3.5192,3.686}, /*cfy*/
          {2.6288,-0.00427,421.8242,0.57243,0.011376,0.8272}, /*cmz*/
          {3.248705,4.8736,1.7383,2.0564} /*cfz*/
     },
     {
          2453129.4,
          {-1.0258,-0.02537,384.3401,0.08246,0.011102,0.8197}, /*cmx*/
          {1.417204,6.2577,6.033,0.3139}, /*cfx*/
          {0.4016,0.01217,173.9245,0.06267,0.004742,0.3731}, /*cmy*/
          {4.620636,3.0962,3.2474,3.5127}, /*cfy*/
          {2.3946,-0.01693,421.625,0.14811,0.010277,0.8592}, /*cmz*/
          {2.999043,1.4158,1.409,1.84} /*cfz*/
     },
     {
          2453159.4,
          {-1.8127,-0.01677,383.9804,0.70342,0.007755,0.8535}, /*cmx*/
          {1.119172,5.7681,5.7079,0.1005}, /*cfx*/
          {0.778,0.00913,174.9785,0.32489,0.00343,0.394}, /*cmy*/
          {4.320165,2.9562,2.8062,3.2993}, /*cfy*/
          {1.8477,-0.03457,421.5212,0.78262,0.007925,0.8714}, /*cmz*/
          {2.700338,1.1624,0.8718,1.6229} /*cfz*/
     },
     {
          2453189.4,
          {-2.3938,0.00196,382.7717,1.15525,0.004098,0.8434}, /*cmx*/
          {0.780566,5.446,5.0688,6.1331}, /*cfx*/
          {1.0863,0.00097,177.5732,0.51928,0.002038,0.3954}, /*cmy*/
          {3.983574,2.6008,1.9059,3.0532}, /*cfy*/
          {0.8631,-0.0433,421.5681,1.2253,0.005834,0.8558}, /*cmz*/
          {2.362157,0.8027,0.3035,1.4109} /*cfz*/
     },
     {
          2453219.4,
          {-2.4893,0.02087,381.4861,1.39896,0.002825,0.7871}, /*cmx*/
          {0.414941,5.1017,4.0119,5.8694}, /*cfx*/
          {1.1881,-0.0082,180.3501,0.62327,0.002085,0.3751}, /*cmy*/
          {3.623821,2.1878,0.7409,2.7997}, /*cfy*/
          {-0.4261,-0.03816,421.5877,1.51389,0.003424,0.8505}, /*cmz*/
          {1.998299,0.4243,5.7678,1.1362} /*cfz*/
     },
     {
          2453249.4,
          {-1.9413,0.03184,380.7523,1.4873,0.002139,0.7521}, /*cmx*/
          {0.035313,4.7292,3.0297,5.5657}, /*cfx*/
          {0.9837,-0.0142,182.1149,0.65211,0.002112,0.3601}, /*cmy*/
          {3.252998,1.7203,6.2159,2.5098}, /*cfy*/
          {-1.7014,-0.02106,421.5037,1.63758,0.00338,0.8737}, /*cmz*/
          {1.620481,0.0535,4.5222,0.8617} /*cfz*/
     },
     {
          2453279.4,
          {-0.9276,0.03609,380.8027,1.4787,0.003031,0.7479}, /*cmx*/
          {5.935884,4.3599,1.6857,5.2846}, /*cfx*/
          {0.5368,-0.01672,182.1104,0.63728,0.002222,0.3554}, /*cmy*/
          {2.881369,1.2352,5.1809,2.2473}, /*cfy*/
          {-2.5039,-0.00311,421.5534,1.58614,0.003734,0.9158}, /*cmz*/
          {1.239272,5.9514,3.691,0.6101} /*cfz*/
     },
     {
          2453309.4,
          {0.2448,0.03489,381.6269,1.33561,0.005305,0.7685}, /*cmx*/
          {5.559868,4.0188,1.1127,5.0799}, /*cfx*/
          {-0.0027,-0.0163,180.203,0.56193,0.002928,0.3604}, /*cmy*/
          {2.517817,0.7741,4.3862,2.054}, /*cfy*/
          {-2.6581,0.01441,421.6607,1.41796,0.004722,0.9073}, /*cmz*/
          {0.865173,5.5512,2.6377,0.3696} /*cfz*/
     },
     {
          2453339.4,
          {1.2612,0.02812,383.141,1.03198,0.007149,0.754}, /*cmx*/
          {5.201087,3.6895,0.6594,4.8863}, /*cfx*/
          {-0.4748,-0.01345,177.075,0.41593,0.003365,0.3459}, /*cmy*/
          {2.172037,0.3204,3.7177,1.8728}, /*cfy*/
          {-2.2336,0.02979,421.5608,1.1308,0.008436,0.8707}, /*cmz*/
          {0.50841,5.1808,2.026,0.1587} /*cfz*/
     },
     {
          2453369.4,
          {2.0146,0.0118,384.6889,0.58216,0.009222,0.7339}, /*cmx*/
          {4.871377,3.3679,0.2211,4.6886}, /*cfx*/
          {-0.8316,-0.00686,173.9594,0.21518,0.00397,0.3296}, /*cmy*/
          {1.854553,6.1306,3.1035,1.6835}, /*cfy*/
          {-1.4159,0.03918,421.337,0.63751,0.011072,0.835}, /*cmz*/
          {0.179947,4.8703,1.7227,6.2612} /*cfz*/
     },
     {
          2453399.4,
          {2.3797,-0.00543,385.4517,0.00972,0.009701,0.7491}, /*cmx*/
          {4.582117,5.4623,6.2295,4.4906}, /*cfx*/
          {-1.0332,6e-05,172.3988,0.04415,0.003963,0.3312}, /*cmy*/
          {1.574676,3.3471,2.7911,1.486}, /*cfy*/
          {-0.4169,0.03825,421.3076,0.03805,0.010391,0.8274}, /*cmz*/
          {6.174927,1.6264,1.4654,6.1761} /*cfz*/
     },
     {
          2453429.4,
          {2.3573,-0.01697,385.0525,0.62281,0.004808,0.7648}, /*cmx*/
          {4.339121,5.9551,6.173,4.3949}, /*cfx*/
          {-1.0882,0.00538,173.4026,0.2893,0.001729,0.3427}, /*cmy*/
          {1.335351,2.6131,2.8866,1.3939}, /*cfy*/
          {0.5804,0.02972,421.3709,0.6947,0.004786,0.8683}, /*cmz*/
          {5.933359,1.2592,1.2137,6.1226} /*cfz*/
     },
     {
          2453459.4,
          {1.9911,-0.02016,383.8362,0.92566,0.004521,0.7699}, /*cmx*/
          {4.131792,5.7636,2.4763,4.3641}, /*cfx*/
          {-0.9897,0.00779,176.2012,0.396,0.002321,0.3537}, /*cmy*/
          {1.124546,2.4357,5.4166,1.36}, /*cfy*/
          {1.4083,0.0219,421.3965,0.96356,0.003821,0.8893}, /*cmz*/
          {5.726823,1.0492,4.235,6.0564} /*cfz*/
     },
     {
          2453489.4,
          {1.4079,-0.02388,382.6359,0.66572,0.010602,0.7523}, /*cmx*/
          {3.926905,5.5725,2.4412,4.3006}, /*cfx*/
          {-0.7653,0.01047,178.6817,0.26067,0.004765,0.3527}, /*cmy*/
          {0.911368,2.2743,5.4754,1.2901}, /*cfy*/
          {2.0588,0.0157,421.32,0.65548,0.00977,0.8829}, /*cmz*/
          {5.520969,0.8195,3.9646,5.9142} /*cfz*/
     },
     {
          2453519.4,
          {0.6508,-0.03055,382.0492,0.0436,0.010562,0.7721}, /*cmx*/
          {3.688102,5.7432,2.2091,4.1273}, /*cfx*/
          {-0.4281,0.01407,179.6788,0.02254,0.004536,0.3625}, /*cmy*/
          {0.664329,5.5249,5.2512,1.1015}, /*cfy*/
          {2.4684,0.00824,421.312,0.01791,0.010868,0.8504}, /*cmz*/
          {5.280354,5.8706,3.649,5.7248} /*cfz*/
     },
     {
          2453549.4,
          {-0.2326,-0.0371,382.1692,0.59121,0.007716,0.8119}, /*cmx*/
          {3.400651,1.87,1.7796,3.8908}, /*cfx*/
          {-0.0139,0.01742,179.2247,0.29315,0.003183,0.3758}, /*cmy*/
          {0.372416,4.9682,4.6668,0.8563}, /*cfy*/
          {2.5935,-0.00738,421.3745,0.64883,0.008742,0.8504}, /*cmz*/
          {4.991779,3.4209,3.3011,5.5274} /*cfz*/
     },
     {
          2453579.4,
          {-1.1827,-0.03321,383.1514,1.05376,0.005265,0.853}, /*cmx*/
          {3.070453,1.5503,1.1884,3.6741}, /*cfx*/
          {0.439,0.01564,177.3098,0.4813,0.002458,0.3869}, /*cmy*/
          {0.042662,4.5691,3.7492,0.6349}, /*cfy*/
          {2.2871,-0.02692,421.3265,1.17395,0.005171,0.8568}, /*cmz*/
          {4.661476,3.0845,2.7421,5.3082} /*cfz*/
     },
     {
          2453609.4,
          {-2.0405,-0.01558,385.0416,1.35312,0.003041,0.8422}, /*cmx*/
          {2.710837,1.187,0.5286,3.4287}, /*cfx*/
          {0.8439,0.00747,173.4721,0.59357,0.002152,0.369}, /*cmy*/
          {5.971338,4.1041,2.7644,0.3973}, /*cfy*/
          {1.5008,-0.04275,421.1846,1.49337,0.003726,0.8687}, /*cmz*/
          {4.301645,2.7418,1.6611,5.0689} /*cfz*/
     },
     {
          2453639.4,
          {-2.4924,0.00731,387.7972,1.52277,0.002055,0.8101}, /*cmx*/
          {2.334641,0.8246,5.2552,3.1517}, /*cfx*/
          {1.054,-0.00276,167.242,0.64774,0.002502,0.3391}, /*cmy*/
          {5.60445,3.6178,1.7193,0.139}, /*cfy*/
          {0.261,-0.04341,421.1997,1.61253,0.003586,0.8774}, /*cmz*/
          {3.925004,2.3626,0.8667,4.765} /*cfz*/
     },
     {
          2453669.4,
          {-2.3033,0.02476,391.3635,1.53173,0.003597,0.8174}, /*cmx*/
          {1.952809,0.4685,4.3092,2.8635}, /*cfx*/
          {0.9783,-0.00954,158.5814,0.63398,0.002939,0.3212}, /*cmy*/
          {5.235724,3.1137,0.9872,6.1508}, /*cfy*/
          {-1.0827,-0.03296,421.2965,1.61316,0.002847,0.8696}, /*cmz*/
          {3.543238,1.96,5.9935,4.4449} /*cfz*/
     },
     {
          2453699.4,
          {-1.4694,0.03154,395.4984,1.39328,0.00474,0.8252}, /*cmx*/
          {1.57626,0.1018,3.6101,2.6438}, /*cfx*/
          {0.6538,-0.01092,148.1185,0.56946,0.002815,0.3024}, /*cmy*/
          {4.875659,2.5838,0.2077,5.9533}, /*cfy*/
          {-2.1063,-0.01775,421.247,1.50231,0.005407,0.8823}, /*cmz*/
          {3.166451,1.5791,4.9635,4.1502} /*cfz*/
     },
     {
          2453729.4,
          {-0.3424,0.0335,399.4266,1.13695,0.007237,0.8212}, /*cmx*/
          {1.215639,6.0245,2.9486,2.4812}, /*cfx*/
          {0.2554,-0.01025,137.1601,0.46451,0.003201,0.2794}, /*cmy*/
          {4.534224,2.0661,5.5787,5.81}, /*cfy*/
          {-2.5468,-0.00296,421.1475,1.20712,0.008129,0.8712}, /*cmz*/
          {2.804702,1.2293,4.4878,3.9299} /*cfz*/
     },
     {
          2453759.4,
          {0.7642,0.02989,402.3893,0.71703,0.010143,0.7914}, /*cmx*/
          {0.881577,5.7263,2.5855,2.2886}, /*cfx*/
          {-0.0969,-0.009,127.8498,0.29265,0.003969,0.2496}, /*cmy*/
          {4.21981,1.5897,4.9381,5.6401}, /*cfy*/
          {-2.4317,0.0119,421.1802,0.73165,0.010222,0.8494}, /*cmz*/
          {2.469798,0.8803,4.0365,3.7983} /*cfz*/
     },
     {
          2453789.4,
          {1.6267,0.02136,403.9928,0.11323,0.010282,0.7763}, /*cmx*/
          {0.585086,5.8004,2.3555,2.1007}, /*cfx*/
          {-0.3635,-0.00798,122.8499,0.05782,0.003971,0.2376}, /*cmy*/
          {3.937891,0.7108,4.5462,5.4609}, /*cfy*/
          {-1.9344,0.02358,421.1557,0.11826,0.011246,0.8361}, /*cmz*/
          {2.173559,0.3793,3.682,3.6778} /*cfz*/
     },
     {
          2453819.4,
          {2.2129,0.00731,403.8488,0.55302,0.005701,0.7748}, /*cmx*/
          {0.333753,1.9676,2.2175,1.9473}, /*cfx*/
          {-0.5874,-0.0055,124.0285,0.21649,0.002268,0.2432}, /*cmy*/
          {3.689268,4.4186,4.3724,5.3082}, /*cfy*/
          {-1.184,0.02691,421.0199,0.54079,0.007635,0.8622}, /*cmz*/
          {1.923087,3.5109,3.5322,3.5788} /*cfz*/
     },
     {
          2453849.4,
          {2.4874,-0.00481,401.8879,0.92113,0.002727,0.7573}, /*cmx*/
          {0.120679,1.8102,4.7641,1.9051}, /*cfx*/
          {-0.7721,-0.0019,130.5272,0.3613,0.000979,0.2563}, /*cmy*/
          {3.465896,4.163,0.981,5.2631}, /*cfy*/
          {-0.333,0.02478,420.9339,0.94482,0.001904,0.9053}, /*cmz*/
          {1.710908,3.2726,5.8183,3.4801} /*cfz*/
     },
     {
          2453879.4,
          {2.4601,-0.01393,399.1566,0.74206,0.009033,0.7478}, /*cmx*/
          {6.200026,1.6149,4.7527,1.8588}, /*cfx*/
          {-0.8771,0.00254,138.2099,0.29018,0.003601,0.2675}, /*cmy*/
          {3.24589,3.9289,0.9508,5.1988}, /*cfy*/
          {0.5704,0.02115,420.9834,0.78353,0.009724,0.8915}, /*cmz*/
          {1.507775,3.0622,6.1531,3.4068} /*cfz*/
     },
     {
          2453909.4,
          {2.088,-0.02009,397.3772,0.1716,0.01071,0.7451}, /*cmx*/
          {5.968688,1.3429,4.4716,1.7257}, /*cfx*/
          {-0.8273,0.0062,142.7506,0.07916,0.004339,0.2696}, /*cmy*/
          {3.00088,3.1116,0.6802,5.0521}, /*cfy*/
          {1.4247,0.01948,421.0779,0.15963,0.011377,0.857}, /*cmz*/
          {1.276546,2.8137,5.9745,3.2974} /*cfz*/
     },
     {
          2453939.4,
          {1.3798,-0.02784,397.5355,0.46849,0.009251,0.7926}, /*cmx*/
          {5.690979,4.2199,4.114,1.4891}, /*cfx*/
          {-0.6108,0.00964,142.4137,0.20598,0.003728,0.2761}, /*cmy*/
          {2.716376,0.6829,0.1965,4.8002}, /*cfy*/
          {2.1509,0.01392,421.0634,0.55651,0.008586,0.8276}, /*cmz*/
          {0.998061,5.7354,5.5811,3.1285} /*cfz*/
     },
     {
          2453969.4,
          {0.412,-0.03557,399.4643,1.01021,0.006119,0.8389}, /*cmx*/
          {5.369276,3.88,3.671,1.2326}, /*cfx*/
          {-0.2786,0.01175,137.1328,0.41417,0.002782,0.2721}, /*cmy*/
          {2.396072,0.1464,5.6756,4.5479}, /*cfy*/
          {2.5688,0.00097,421.0214,1.10483,0.006074,0.8636}, /*cmz*/
          {0.674465,5.4167,4.8859,2.9035} /*cfz*/
     },
     {
          2453999.4,
          {-0.7066,-0.03616,402.6624,1.39467,0.003419,0.863}, /*cmx*/
          {5.015051,3.5394,2.6883,0.9962}, /*cfx*/
          {0.0854,0.01049,127.2389,0.55509,0.002857,0.2522}, /*cmy*/
          {2.051941,5.9418,4.6412,4.3269}, /*cfy*/
          {2.5796,-0.02156,421.0775,1.43952,0.004831,0.894}, /*cmz*/
          {0.318037,5.0456,4.1958,2.6528} /*cfz*/
     },
     {
          2454029.4,
          {-1.7845,-0.02319,406.766,1.57734,0.003812,0.8527}, /*cmx*/
          {4.640907,3.1769,1.5885,0.7338}, /*cfx*/
          {0.3832,0.00504,113.2872,0.62791,0.003151,0.2132}, /*cmy*/
          {1.69786,5.4105,3.8756,4.0877}, /*cfy*/
          {2.0227,-0.04072,421.1521,1.62673,0.003053,0.8895}, /*cmz*/
          {6.225362,4.6505,3.3285,2.4003} /*cfz*/
     },
     {
          2454059.4,
          {-2.5592,0.00057,411.2241,1.60283,0.003772,0.8484}, /*cmx*/
          {4.259262,2.7789,0.7458,0.4889}, /*cfx*/
          {0.5332,-0.00164,96.204,0.65983,0.002862,0.1757}, /*cmy*/
          {1.349662,4.8538,3.0816,3.8647}, /*cfy*/
          {0.911,-0.04632,421.1183,1.6741,0.003535,0.859}, /*cmz*/
          {5.841597,4.2688,2.0319,2.0834} /*cfz*/
     },
     {
          2454089.4,
          {-2.6828,0.02121,415.1287,1.52091,0.005127,0.8811}, /*cmx*/
          {3.880885,2.3785,5.9674,0.2474}, /*cfx*/
          {0.5003,-0.00509,77.4917,0.64694,0.002724,0.1452}, /*cmy*/
          {1.025314,4.3187,2.121,3.6575}, /*cfy*/
          {-0.4989,-0.03601,421.1325,1.5487,0.004941,0.8503}, /*cmz*/
          {5.460495,3.8932,1.2681,1.7663} /*cfz*/
     },
     {
          2454119.4,
          {-2.1284,0.03355,417.8969,1.27676,0.007858,0.9045}, /*cmx*/
          {3.515595,2.0168,5.39,0.0294}, /*cfx*/
          {0.3647,-0.00493,59.4754,0.56456,0.002981,0.1142}, /*cmy*/
          {0.745738,3.8198,1.1476,3.5333}, /*cfy*/
          {-1.7313,-0.02091,421.2388,1.28559,0.006859,0.8823}, /*cmz*/
          {5.093118,3.5145,0.538,1.5215} /*cfz*/
     },
     {
          2454149.4,
          {-1.1192,0.03688,419.6616,0.82929,0.009314,0.922}, /*cmx*/
          {3.174172,1.6839,4.9342,6.1135}, /*cfx*/
          {0.2266,-0.00325,45.1247,0.4046,0.003876,0.0891}, /*cmy*/
          {0.526728,3.3659,0.34,3.4541}, /*cfy*/
          {-2.4353,-0.00776,421.2519,0.88169,0.01016,0.8646}, /*cmz*/
          {4.750381,3.1631,0.0316,1.3494} /*cfz*/
     },
     {
          2454179.4,
          {-0.0433,0.03659,420.5502,0.23429,0.009858,0.8877}, /*cmx*/
          {2.868396,1.3822,4.5025,5.9296}, /*cfx*/
          {0.1364,-0.00279,37.1043,0.16358,0.004679,0.0749}, /*cmy*/
          {0.339522,2.9603,6.1652,3.3861}, /*cfy*/
          {-2.6204,0.00471,421.2028,0.29375,0.011833,0.8337}, /*cmz*/
          {4.443429,2.9011,6.0434,1.2171} /*cfz*/
     },
     {
          2454209.4,
          {0.9098,0.03067,420.6089,0.41432,0.0076,0.8373}, /*cmx*/
          {2.60662,4.1921,4.2854,5.8114}, /*cfx*/
          {0.0608,-0.00395,36.6195,0.13204,0.003745,0.0801}, /*cmy*/
          {0.089836,5.9726,6.0086,3.2533}, /*cfy*/
          {-2.4339,0.01721,421.228,0.40961,0.00857,0.8242}, /*cmz*/
          {4.181096,5.7199,5.8859,1.063} /*cfz*/
     },
     {
          2454239.4,
          {1.6594,0.02198,419.9277,0.89219,0.001525,0.8101}, /*cmx*/
          {2.385752,3.9794,5.6162,5.7361}, /*cfx*/
          {-0.0472,-0.00537,43.4058,0.36628,0.000659,0.0982}, /*cmy*/
          {6.044727,5.7458,0.486,3.08}, /*cfy*/
          {-2.0425,0.02862,421.2227,0.92218,0.001068,0.8603}, /*cmz*/
          {3.961274,5.5356,0.9935,0.9599} /*cfz*/
     },
     {
          2454269.4,
          {2.2246,0.0105,418.6924,0.88209,0.008949,0.8245}, /*cmx*/
          {2.182267,3.7938,0.5421,5.6977}, /*cfx*/
          {-0.201,-0.00465,54.2977,0.38429,0.003263,0.1222}, /*cmy*/
          {5.725876,5.5814,2.483,2.9288}, /*cfy*/
          {-1.4089,0.03425,421.1502,0.88328,0.008508,0.8841}, /*cmz*/
          {3.759705,5.3379,2.1626,0.876} /*cfz*/
     },
     {
          2454299.4,
          {2.5561,-0.00116,417.5862,0.35794,0.012347,0.8501}, /*cmx*/
          {1.959616,3.6138,0.4407,5.5692}, /*cfx*/
          {-0.3432,-0.0018,62.7543,0.18228,0.004685,0.1339}, /*cmy*/
          {5.43721,5.2635,2.3727,2.7379}, /*cfy*/
          {-0.5325,0.03544,421.0546,0.32372,0.011386,0.8579}, /*cmz*/
          {3.538083,5.0405,1.9202,0.7981} /*cfz*/
     },
     {
          2454329.4,
          {2.5296,-0.01379,417.3912,0.36367,0.010228,0.8397}, /*cmx*/
          {1.692752,0.1254,0.1719,5.3677}, /*cfx*/
          {-0.3953,0.00161,63.9786,0.11753,0.004184,0.125}, /*cmy*/
          {5.151462,2.4811,1.945,2.538}, /*cfy*/
          {0.5469,0.03203,421.1168,0.38929,0.010322,0.8332}, /*cmz*/
          {3.270674,1.8074,1.5177,0.6264} /*cfz*/
     },
     {
          2454359.4,
          {2.0546,-0.02728,418.24,0.98814,0.006618,0.834}, /*cmx*/
          {1.378929,6.1493,5.8377,5.0988}, /*cfx*/
          {-0.3271,0.00346,57.1232,0.36264,0.003484,0.1014}, /*cmy*/
          {4.862582,1.8362,1.205,2.34}, /*cfy*/
          {1.554,0.02729,421.271,0.99246,0.007813,0.8399}, /*cmz*/
          {2.955482,1.4088,1.0411,0.3937} /*cfz*/
     },
     {
          2454389.4,
          {1.1503,-0.04003,419.8086,1.39043,0.005315,0.8223}, /*cmx*/
          {1.028333,5.7975,4.9583,4.8283}, /*cfx*/
          {-0.1912,0.00272,43.6245,0.54981,0.003131,0.0674}, /*cmy*/
          {4.60382,1.3319,0.3431,2.3037}, /*cfy*/
          {2.2835,0.01498,421.3409,1.42642,0.004849,0.897}, /*cmz*/
          {2.603318,1.0362,0.3565,0.1641} /*cfz*/
     },
     {
          2454419.4,
          {-0.0215,-0.04533,421.2908,1.61374,0.004284,0.8389}, /*cmx*/
          {0.654897,5.3897,4.1483,4.5926}, /*cfx*/
          {-0.0838,-0.00043,26.5158,0.67624,0.002945,0.039}, /*cmy*/
          {4.514456,0.8174,5.7123,2.7443}, /*cfy*/
          {2.552,-0.00574,421.322,1.65992,0.003864,0.9115}, /*cmz*/
          {2.227477,0.6646,5.5885,6.2159} /*cfz*/
     },
     {
          2454449.4,
          {-1.2855,-0.03427,421.7593,1.70913,0.004101,0.8483}, /*cmx*/
          {0.270954,4.9746,2.9522,4.3472}, /*cfx*/
          {-0.0809,-0.00365,16.6738,0.73518,0.002856,0.0494}, /*cmy*/
          {5.153333,0.3004,4.7918,3.6052}, /*cfy*/
          {2.2736,-0.03011,421.4254,1.70092,0.003568,0.8893}, /*cmz*/
          {1.840778,0.272,4.7347,5.9612} /*cfz*/
     },
     {
          2454479.4,
          {-2.2742,-0.01241,420.8385,1.63221,0.005793,0.8531}, /*cmx*/
          {6.170176,4.5778,2.1453,4.0911}, /*cfx*/
          {-0.1864,-0.00402,30.413,0.72285,0.002837,0.0852}, /*cmy*/
          {5.643147,6.0768,3.8302,3.7373}, /*cfy*/
          {1.3944,-0.043,421.5511,1.624,0.003858,0.8663}, /*cmz*/
          {1.455134,6.153,3.5594,5.647} /*cfz*/
     },
     {
          2454509.4,
          {-2.6745,0.00905,418.9742,1.37837,0.006494,0.8879}, /*cmx*/
          {5.796652,4.1784,1.4586,3.8072}, /*cfx*/
          {-0.3114,-0.0012,49.8744,0.63485,0.003153,0.1269}, /*cmy*/
          {5.510653,5.6017,2.9063,3.6022}, /*cfy*/
          {0.0947,-0.03945,421.5312,1.42223,0.006849,0.8511}, /*cmz*/
          {1.080701,5.7803,2.809,5.3825} /*cfz*/
     },
     {
          2454539.4,
          {-2.3437,0.01917,416.7126,0.9972,0.008304,0.9135}, /*cmx*/
          {5.444597,3.7834,0.7303,3.5833}, /*cfx*/
          {-0.3359,0.00209,66.3971,0.4714,0.003803,0.161}, /*cmy*/
          {5.249553,5.1774,2.1146,3.44}, /*cfy*/
          {-1.1907,-0.02703,421.532,1.0318,0.009286,0.8434}, /*cmz*/
          {0.72775,5.4457,2.3937,5.1908} /*cfz*/
     },
     {
          2454569.4,
          {-1.5579,0.02329,414.7992,0.46655,0.01055,0.9165}, /*cmx*/
          {5.124947,3.4341,0.3047,3.4413}, /*cfx*/
          {-0.2311,0.00439,77.0837,0.24076,0.004652,0.1765}, /*cmy*/
          {4.970444,4.8788,1.5991,3.3175}, /*cfy*/
          {-2.1046,-0.01477,421.7092,0.46937,0.010621,0.816}, /*cmz*/
          {0.407785,5.1114,1.99,5.0492} /*cfz*/
     },
     {
          2454599.4,
          {-0.6427,0.02489,414.1301,0.21082,0.009108,0.8654}, /*cmx*/
          {4.847658,0.0401,0.1126,3.3351}, /*cfx*/
          {-0.0551,0.0048,80.2058,0.06663,0.004457,0.1633}, /*cmy*/
          {4.707443,0.6119,1.4321,3.1966}, /*cfy*/
          {-2.5133,-0.00634,421.7665,0.19321,0.009793,0.8222}, /*cmz*/
          {0.131041,1.7872,1.6953,4.9231} /*cfz*/
     },
     {
          2454629.4,
          {0.1972,0.02629,415.1334,0.82838,0.001956,0.8479}, /*cmx*/
          {4.615409,6.1116,0.373,3.252}, /*cfx*/
          {0.1096,0.00351,75.179,0.33073,0.002117,0.1399}, /*cmy*/
          {4.469065,1.001,1.7755,3.0812}, /*cfy*/
          {-2.5816,0.00283,421.6515,0.78302,0.003677,0.8376}, /*cmz*/
          {6.182546,1.4772,1.7076,4.773} /*cfz*/
     },
     {
          2454659.4,
          {0.9876,0.02329,417.0838,0.98654,0.007723,0.8755}, /*cmx*/
          {4.411711,5.9383,2.7765,3.1513}, /*cfx*/
          {0.2191,0.00141,64.2255,0.43321,0.002603,0.1199}, /*cmy*/
          {4.23942,0.9482,3.7741,2.9412}, /*cfy*/
          {-2.4092,0.01362,421.5184,0.9639,0.006451,0.8493}, /*cmz*/
          {5.979008,1.2573,4.2378,4.6577} /*cfz*/
     },
     {
          2454689.4,
          {1.763,0.01535,418.6262,0.53405,0.012007,0.9073}, /*cmx*/
          {4.1997,5.7531,2.6429,3.054}, /*cfx*/
          {0.2729,0.00036,53.5447,0.27979,0.004893,0.1082}, /*cmy*/
          {3.99061,0.837,3.9401,2.8321}, /*cfy*/
          {-2.0195,0.02659,421.5306,0.55643,0.012453,0.8312}, /*cmz*/
          {5.767239,1.033,4.1525,4.5397} /*cfz*/
     },
     {
          2454719.4,
          {2.4126,0.003,419.0621,0.201,0.010935,0.882}, /*cmx*/
          {3.946311,2.3584,2.2888,2.9004}, /*cfx*/
          {0.3047,0.0006,49.552,0.0206,0.004847,0.1068}, /*cmy*/
          {3.722197,3.4819,3.6544,2.7101}, /*cfy*/
          {-1.2495,0.03397,421.5852,0.18065,0.012006,0.807}, /*cmz*/
          {5.514286,3.9617,3.9049,4.415} /*cfz*/
     },
     {
          2454749.4,
          {2.6917,-0.01018,418.4568,0.8663,0.008316,0.8141}, /*cmx*/
          {3.642347,2.028,1.7732,2.6878}, /*cfx*/
          {0.3419,0.00065,54.4892,0.31419,0.003772,0.1151}, /*cmy*/
          {3.447274,3.3824,3.0326,2.5331}, /*cfy*/
          {-0.147,0.03529,421.5649,0.89049,0.00831,0.8241}, /*cmz*/
          {5.210426,3.6503,3.4331,4.2084} /*cfz*/
     },
     {
          2454779.4,
          {2.404,-0.02307,416.6177,1.352,0.005404,0.7933}, /*cmx*/
          {3.296633,1.6522,1.1317,2.403}, /*cfx*/
          {0.3562,-0.00129,67.0107,0.5333,0.003014,0.141}, /*cmy*/
          {3.151051,2.964,2.132,2.2746}, /*cfy*/
          {1.0793,0.0291,421.5516,1.37844,0.005924,0.8632}, /*cmz*/
          {4.863844,3.3129,2.6535,3.9715} /*cfz*/
     },
     {
          2454809.4,
          {1.6181,-0.03669,413.3498,1.64901,0.003649,0.805}, /*cmx*/
          {2.922931,1.2674,6.2793,2.1311}, /*cfx*/
          {0.2901,-0.00624,84.2686,0.66957,0.00276,0.18}, /*cmy*/
          {2.82206,2.4856,1.1079,2.0282}, /*cfy*/
          {2.0646,0.01736,421.7287,1.64155,0.004493,0.9089}, /*cmz*/
          {4.489255,2.9213,1.9494,3.7161} /*cfz*/
     },
     {
          2454839.4,
          {0.4821,-0.04393,408.9024,1.73605,0.004204,0.821}, /*cmx*/
          {2.534305,0.8753,5.3085,1.9043}, /*cfx*/
          {0.0845,-0.01159,103.2039,0.72406,0.002997,0.2235}, /*cmy*/
          {2.467728,1.9876,0.1677,1.8309}, /*cfy*/
          {2.599,-0.00358,421.877,1.76653,0.002727,0.9056}, /*cmz*/
          {4.100941,2.5131,0.7943,3.4436} /*cfz*/
     },
     {
          2454869.4,
          {-0.7554,-0.03802,403.9562,1.66853,0.004187,0.7969}, /*cmx*/
          {2.1429,0.4682,4.4564,1.6415}, /*cfx*/
          {-0.2532,-0.01311,121.245,0.70037,0.00294,0.2554}, /*cmy*/
          {2.102396,1.4787,5.6594,1.5968}, /*cfy*/
          {2.5417,-0.02737,421.8319,1.74869,0.004518,0.8775}, /*cmz*/
          {3.710354,2.1262,5.8463,3.1878} /*cfz*/
     },
     {
          2454899.4,
          {-1.8629,-0.01667,399.0567,1.49423,0.005635,0.79}, /*cmx*/
          {1.759301,0.0743,3.5367,1.3561}, /*cfx*/
          {-0.6515,-0.00764,136.5322,0.62123,0.00273,0.2857}, /*cmy*/
          {1.739286,0.9749,4.6872,1.3405}, /*cfy*/
          {1.8442,-0.04247,421.7997,1.54509,0.006117,0.8488}, /*cmz*/
          {3.327714,1.7518,5.2522,2.9347} /*cfz*/
     },
     {
          2454929.4,
          {-2.4822,0.00552,394.8938,1.17402,0.007961,0.8309}, /*cmx*/
          {1.393389,5.9993,2.9851,1.0878}, /*cfx*/
          {-0.9365,0.00052,148.0832,0.4866,0.003428,0.3234}, /*cmy*/
          {1.38996,0.5292,3.7998,1.0931}, /*cfy*/
          {0.6766,-0.04254,421.9174,1.20425,0.007818,0.8366}, /*cmz*/
          {2.963726,1.3678,4.5799,2.7269} /*cfz*/
     },
     {
          2454959.4,
          {-2.4761,0.01933,392.0988,0.68622,0.009484,0.8467}, /*cmx*/
          {1.05617,5.6543,2.5422,0.9006}, /*cfx*/
          {-0.989,0.00682,155.5981,0.27778,0.004124,0.3418}, /*cmy*/
          {1.066053,0.196,3.2379,0.9172}, /*cfy*/
          {-0.6049,-0.03257,421.8827,0.73886,0.010888,0.8718}, /*cmz*/
          {2.628998,1.0102,4.1137,2.556} /*cfz*/
     },
     {
          2454989.4,
          {-1.9619,0.02284,390.8462,0.08181,0.009899,0.8301}, /*cmx*/
          {0.759376,4.931,2.1626,0.7684}, /*cfx*/
          {-0.8114,0.00909,158.978,0.03552,0.004066,0.3372}, /*cmy*/
          {0.779016,1.2004,2.8987,0.7902}, /*cfy*/
          {-1.5943,-0.0232,421.7249,0.10751,0.011845,0.8858}, /*cmz*/
          {2.333806,0.7827,3.9071,2.4227} /*cfz*/
     },
     {
          2455019.4,
          {-1.2597,0.0249,391.1201,0.56677,0.006073,0.7966}, /*cmx*/
          {0.510119,2.0489,1.921,0.6538}, /*cfx*/
          {-0.5284,0.01015,158.0992,0.27239,0.002319,0.3155}, /*cmy*/
          {0.535091,2.5399,2.9808,0.6764}, /*cfy*/
          {-2.2117,-0.01474,421.6612,0.59909,0.006779,0.8732}, /*cmz*/
          {2.084849,3.6163,3.8795,2.302} /*cfz*/
     },
     {
          2455049.4,
          {-0.5654,0.02949,392.9613,0.94231,0.002936,0.8211}, /*cmx*/
          {0.300422,1.7964,4.9223,0.5722}, /*cfx*/
          {-0.24,0.01139,153.2984,0.42011,0.001894,0.3102}, /*cmy*/
          {0.325535,2.4792,5.0832,0.587}, /*cfy*/
          {-2.5138,-0.00617,421.7558,1.00386,0.003891,0.8286}, /*cmz*/
          {1.874767,3.4464,0.0256,2.1682} /*cfz*/
     },
     {
          2455079.4,
          {0.1492,0.03449,395.5008,0.7418,0.010878,0.8646}, /*cmx*/
          {0.098377,1.5756,4.7406,0.4733}, /*cfx*/
          {0.0385,0.01253,146.7218,0.3244,0.004716,0.3132}, /*cmy*/
          {0.119155,2.4255,5.4156,0.4833}, /*cfy*/
          {-2.6274,0.0078,421.7878,0.75854,0.011198,0.8184}, /*cmz*/
          {1.67197,3.2712,0.1374,2.0597} /*cfz*/
     },
     {
          2455109.4,
          {0.9837,0.03136,397.1112,0.06905,0.012163,0.8753}, /*cmx*/
          {6.146692,1.3583,4.503,0.3543}, /*cfx*/
          {0.3385,0.01164,142.6118,0.0582,0.005218,0.3149}, /*cmy*/
          {6.16212,2.9269,5.2712,0.3695}, /*cfy*/
          {-2.439,0.02292,421.6719,0.04203,0.011922,0.8361}, /*cmz*/
          {1.436234,2.9703,6.1431,1.929} /*cfz*/
     },
     {
          2455139.4,
          {1.8534,0.01777,396.6324,0.6795,0.008773,0.8348}, /*cmx*/
          {5.858796,4.1872,4.1217,0.1444}, /*cfx*/
          {0.6601,0.00799,143.8619,0.2744,0.003948,0.3091}, /*cmy*/
          {5.872171,4.8244,4.8255,0.1672}, /*cfy*/
          {-1.8248,0.03576,421.6012,0.70153,0.009773,0.8494}, /*cmz*/
          {1.147694,5.9001,5.6602,1.7575} /*cfz*/
     },
     {
          2455169.4,
          {2.4114,0.00044,394.2076,1.24162,0.005207,0.7893}, /*cmx*/
          {5.521825,3.8684,3.3806,6.1638}, /*cfx*/
          {0.912,0.0025,150.0281,0.51838,0.00258,0.3085}, /*cmy*/
          {5.538216,4.5245,3.8903,6.1911}, /*cfy*/
          {-0.7365,0.03992,421.6921,1.2622,0.00719,0.8513}, /*cmz*/
          {0.811159,5.5326,5.1234,1.4844} /*cfz*/
     },
     {
          2455199.4,
          {2.4002,-0.01594,390.7209,1.55018,0.00395,0.7867}, /*cmx*/
          {5.150246,3.5033,2.4762,5.8955}, /*cfx*/
          {0.9825,-0.00424,158.7714,0.65988,0.00267,0.3282}, /*cmy*/
          {5.174007,4.1021,2.8043,5.9257}, /*cfy*/
          {0.546,0.03835,421.7516,1.6375,0.004121,0.8465}, /*cmz*/
          {0.441371,5.1477,4.3469,1.1647} /*cfz*/
     },
     {
          2455229.4,
          {1.7804,-0.029,387.0686,1.68556,0.002872,0.7773}, /*cmx*/
          {4.75985,3.1118,1.4914,5.6651}, /*cfx*/
          {0.798,-0.01112,167.612,0.71944,0.002632,0.3452}, /*cmy*/
          {4.793961,3.6116,1.9671,5.7052}, /*cfy*/
          {1.6738,0.02913,421.7146,1.81725,0.003712,0.8772}, /*cmz*/
          {0.05297,4.7649,3.0351,0.8711} /*cfz*/
     },
     {
          2455259.4,
          {0.7881,-0.03903,383.831,1.69522,0.003782,0.766}, /*cmx*/
          {4.363356,2.7347,0.3203,5.4408}, /*cfx*/
          {0.4087,-0.0173,174.7304,0.72615,0.002666,0.3565}, /*cmy*/
          {4.40966,3.1119,0.9757,5.4945}, /*cfy*/
          {2.3881,0.01049,421.739,1.8036,0.004356,0.8793}, /*cmz*/
          {5.941852,4.3695,2.1846,0.6277} /*cfz*/
     },
     {
          2455289.4,
          {-0.3806,-0.03746,381.629,1.55103,0.005209,0.7566}, /*cmx*/
          {3.971133,2.377,6.0157,5.1538}, /*cfx*/
          {-0.112,-0.01793,179.3661,0.66279,0.003105,0.3593}, /*cmy*/
          {4.030621,2.6387,0.1981,5.222}, /*cfy*/
          {2.5461,-0.0145,421.8021,1.67303,0.005274,0.8561}, /*cmz*/
          {5.552777,3.9638,1.2358,0.4167} /*cfz*/
     },
     {
          2455319.4,
          {-1.4566,-0.02426,380.7763,1.27375,0.005949,0.7585}, /*cmx*/
          {3.593467,2.0125,5.3765,4.8694}, /*cfx*/
          {-0.6273,-0.01248,181.6307,0.5294,0.003029,0.3619}, /*cmy*/
          {3.66638,2.1665,5.7088,4.9504}, /*cfy*/
          {2.0901,-0.03362,421.6806,1.42217,0.008044,0.8491}, /*cmz*/
          {5.178255,3.5856,0.5678,0.1738} /*cfz*/
     },
     {
          2455349.4,
          {-2.1842,-0.00546,380.7955,0.90333,0.008465,0.7697}, /*cmx*/
          {3.240972,1.6494,4.7662,4.6111}, /*cfx*/
          {-1.0015,-0.00381,182.0844,0.35482,0.003771,0.3652}, /*cmy*/
          {3.326811,1.699,4.8671,4.7045}, /*cfy*/
          {1.074,-0.03587,421.4984,0.99545,0.010465,0.8744}, /*cmz*/
          {4.827932,3.2514,0.1634,6.2582} /*cfz*/
     },
     {
          2455379.4,
          {-2.3732,0.00711,380.9686,0.39077,0.010968,0.7525}, /*cmx*/
          {2.924121,1.3452,4.4622,4.438}, /*cfx*/
          {-1.1333,0.00215,181.6968,0.12519,0.00474,0.3549}, /*cmy*/
          {3.02127,1.3077,4.4585,4.5491}, /*cfy*/
          {-0.141,-0.0273,421.3691,0.39213,0.011556,0.9161}, /*cmz*/
          {4.512923,2.9538,6.1016,6.1293} /*cfz*/
     },
     {
          2455409.4,
          {-2.1007,0.01254,380.9775,0.27049,0.009181,0.7472}, /*cmx*/
          {2.652748,4.1944,4.308,4.3505}, /*cfx*/
          {-1.0517,0.00499,181.6116,0.16123,0.003719,0.3534}, /*cmy*/
          {2.757599,4.2093,4.3741,4.4662}, /*cfy*/
          {-1.2,-0.01744,421.235,0.31484,0.009545,0.8923}, /*cmz*/
          {4.243399,5.7733,5.8879,6.0359} /*cfz*/
     },
     {
          2455439.4,
          {-1.6001,0.01563,380.8107,0.84194,0.001144,0.7551}, /*cmx*/
          {2.428481,4.0149,4.6545,4.2832}, /*cfx*/
          {-0.8507,0.00692,182.1569,0.39306,0.000785,0.3591}, /*cmy*/
          {2.535125,4.0544,5.8702,4.3912}, /*cfy*/
          {-1.8905,-0.01406,421.1891,0.89529,0.00208,0.8527}, /*cmz*/
          {4.01979,5.5678,0.1127,5.9365} /*cfz*/
     },
     {
          2455469.4,
          {-1.0105,0.02174,380.7333,0.88915,0.008266,0.7973}, /*cmx*/
          {2.230099,3.8323,0.7222,4.1864}, /*cfx*/
          {-0.5866,0.01032,182.4677,0.38166,0.004124,0.3803}, /*cmy*/
          {2.332084,3.9564,0.7816,4.2787}, /*cfy*/
          {-2.3342,-0.00983,421.2651,0.94464,0.008806,0.8296}, /*cmz*/
          {3.820109,5.3679,2.1126,5.8057} /*cfz*/
     },
     {
          2455499.4,
          {-0.3128,0.029,380.7808,0.33838,0.011357,0.8194}, /*cmx*/
          {2.014415,3.6178,0.4898,4.0243}, /*cfx*/
          {-0.2547,0.0141,182.0806,0.1153,0.00514,0.3888}, /*cmy*/
          {2.1084,3.8834,0.6646,4.1109}, /*cfy*/
          {-2.6122,0.00091,421.3783,0.37854,0.013262,0.8619}, /*cmz*/
          {3.602262,5.1183,1.9765,5.6885} /*cfz*/
     },
     {
          2455529.4,
          {0.5808,0.02935,380.711,0.40567,0.009611,0.8113}, /*cmx*/
          {1.748164,0.218,0.0483,3.8491}, /*cfx*/
          {0.1773,0.0148,181.8634,0.22041,0.00406,0.3848}, /*cmy*/
          {1.83581,0.3391,0.152,3.9345}, /*cfy*/
          {-2.6625,0.02018,421.4327,0.42373,0.011551,0.8741}, /*cmz*/
          {3.334728,1.7836,1.6823,5.5274} /*cfz*/
     },
     {
          2455559.4,
          {1.5394,0.01964,380.5826,1.00716,0.007146,0.7871}, /*cmx*/
          {1.4274,6.1573,5.7938,3.633}, /*cfx*/
          {0.6543,0.01057,182.1688,0.47762,0.003206,0.3736}, /*cmy*/
          {1.513427,6.2761,5.6282,3.7179}, /*cfy*/
          {-2.2086,0.0356,421.3859,1.11024,0.007539,0.845}, /*cmz*/
          {3.01399,1.4512,1.154,5.3085} /*cfz*/
     },
     {
          2451179.4,
          {-4.6942,-0.08842,608.2918,1.67663,0.009756,2.7381}, /*cmx*/
          {4.265965,2.6815,2.4143,6.1143}, /*cfx*/
          {-1.8935,-0.04559,284.2012,0.77858,0.004499,1.2797}, /*cmy*/
          {4.353977,2.8609,2.2694,6.2034}, /*cfy*/
          {7.9523,-0.11236,670.5151,1.81741,0.011956,3.0094}, /*cmz*/
          {5.852216,4.2992,3.8925,1.4306} /*cfz*/
     },
     {
          2451209.4,
          {-7.4565,-0.02917,607.9752,2.22184,0.006476,2.727}, /*cmx*/
          {0.699314,5.4079,4.8353,5.7726}, /*cfx*/
          {-3.3148,-0.01861,285.2157,1.00289,0.004057,1.2806}, /*cmy*/
          {0.790002,5.5032,4.3777,5.8658}, /*cfy*/
          {4.5804,-0.15071,670.6113,2.48476,0.006758,2.9738}, /*cmz*/
          {2.287111,0.7176,6.097,1.0477} /*cfz*/
     },
     {
          2451239.4,
          {-8.4221,0.03977,608.362,2.54569,0.005489,2.7074}, /*cmx*/
          {3.395533,1.8585,0.4054,5.3786}, /*cfx*/
          {-3.9177,0.01455,283.5393,1.12621,0.004804,1.2513}, /*cmy*/
          {3.492358,1.8386,0.1371,5.4813}, /*cfy*/
          {-0.0858,-0.1479,670.6799,2.79322,0.005478,3.024}, /*cmz*/
          {4.983588,3.4071,1.9195,0.6772} /*cfz*/
     },
     {
          2451269.4,
          {-7.1571,0.09912,611.1889,2.60751,0.004592,2.7285}, /*cmx*/
          {6.082768,4.5494,2.4324,4.9744}, /*cfx*/
          {-3.4517,0.04206,278.596,1.12469,0.004378,1.2182}, /*cmy*/
          {6.188121,4.3945,2.3912,5.0857}, /*cfy*/
          {-4.7299,-0.10891,670.4357,2.81569,0.006203,3.036}, /*cmz*/
          {1.387971,6.099,4.1458,0.3022} /*cfz*/
     },
     {
          2451299.4,
          {-4.0193,0.13508,615.1309,2.47327,0.006094,2.7873}, /*cmx*/
          {2.488918,0.9768,4.727,4.6119}, /*cfx*/
          {-2.1125,0.05575,269.7204,1.0398,0.004455,1.1895}, /*cmy*/
          {2.605182,0.6825,4.6989,4.7315}, /*cfy*/
          {-8.0217,-0.04683,670.3907,2.71429,0.00834,2.9585}, /*cmz*/
          {4.078794,2.5044,6.2188,6.2042} /*cfz*/
     },
     {
          2451329.4,
          {0.0987,0.13891,619.9972,2.17221,0.009567,2.8195}, /*cmx*/
          {5.190271,3.6973,0.8167,4.265}, /*cfx*/
          {-0.4065,0.05503,258.344,0.88665,0.004905,1.144}, /*cmy*/
          {5.319127,3.2593,0.6332,4.4002}, /*cfy*/
          {-9.3196,0.02984,670.5342,2.3098,0.009654,3.0308}, /*cmz*/
          {0.496441,5.192,2.2843,5.8509} /*cfz*/
     },
     {
          2451359.4,
          {4.2321,0.10329,625.09,1.65189,0.013838,2.8699}, /*cmx*/
          {1.629804,0.1333,3.2989,3.924}, /*cfx*/
          {1.2197,0.04063,246.6238,0.65455,0.006016,1.1063}, /*cmy*/
          {1.772048,5.851,2.8978,4.0711}, /*cfy*/
          {-8.3737,0.08924,670.069,1.74319,0.014679,3.1104}, /*cmz*/
          {3.219553,1.6453,4.865,5.5131} /*cfz*/
     },
     {
          2451389.4,
          {7.3597,0.04935,628.4126,0.80983,0.017201,2.9488}, /*cmx*/
          {4.384348,2.9275,6.0802,3.6092}, /*cfx*/
          {2.4356,0.02299,237.5405,0.3021,0.0069,1.0985}, /*cmy*/
          {4.539456,2.177,5.4906,3.7677}, /*cfy*/
          {-5.7202,0.11669,670.3016,0.86134,0.01843,3.1034}, /*cmz*/
          {5.974752,4.3819,1.2406,5.2147} /*cfz*/
     },
     {
          2451419.4,
          {8.9019,0.00419,629.6171,0.23148,0.016634,2.9706}, /*cmx*/
          {0.900922,2.524,2.5809,3.3673}, /*cfx*/
          {3.1508,0.01036,234.8282,0.12888,0.006515,1.1168}, /*cmy*/
          {1.064193,2.2724,1.9941,3.5304}, /*cfy*/
          {-2.246,0.11043,669.8689,0.29612,0.016658,3.1024}, /*cmz*/
          {2.490935,3.9897,4.1287,4.9485} /*cfz*/
     },
     {
          2451449.4,
          {9.1005,-0.02922,628.0232,1.31343,0.003868,2.991}, /*cmx*/
          {3.747913,5.419,5.7387,3.1497}, /*cfx*/
          {3.5011,-0.00053,239.7142,0.53919,0.001268,1.1733}, /*cmy*/
          {3.911308,4.9253,5.2395,3.3088}, /*cfy*/
          {1.134,0.09227,670.0269,1.34605,0.006274,3.1566}, /*cmz*/
          {5.340154,0.6225,0.9403,4.7327} /*cfz*/
     },
     {
          2451479.4,
          {8.2363,-0.05104,623.9998,1.53521,0.010565,2.9439}, /*cmx*/
          {0.346216,1.9994,5.0388,2.9289}, /*cfx*/
          {3.501,-0.01307,248.8497,0.61006,0.004836,1.1973}, /*cmy*/
          {0.501402,1.509,4.573,3.082}, /*cfy*/
          {3.9951,0.08321,670.1555,1.65306,0.011847,3.2374}, /*cmz*/
          {1.937719,3.5197,0.3142,4.5037} /*cfz*/
     },
     {
          2451509.4,
          {6.6334,-0.08475,621.2977,0.85896,0.019555,2.9482}, /*cmx*/
          {3.217517,4.892,1.7367,2.6676}, /*cfx*/
          {3.083,-0.03131,256.3309,0.29876,0.008177,1.2232}, /*cmy*/
          {3.360813,4.3873,1.367,2.8065}, /*cfy*/
          {6.556,0.07016,670.0339,0.89498,0.02061,3.1829}, /*cmz*/
          {4.809133,0.0855,3.2213,4.2706} /*cfz*/
     },
     {
          2451539.4,
          {4.0409,-0.11902,620.0568,0.32906,0.01712,2.9542}, /*cmx*/
          {6.044463,4.5976,4.484,2.3794}, /*cfx*/
          {2.111,-0.04821,257.8819,0.20464,0.007005,1.2196}, /*cmy*/
          {6.178557,4.4269,4.0145,2.5079}, /*cfy*/
          {8.6458,0.03612,670.3654,0.38671,0.018246,3.1285}, /*cmz*/
          {1.351804,6.065,6.0423,3.9741} /*cfz*/
     },
     {
          2451569.4,
          {0.5009,-0.13668,622.1358,1.36415,0.011904,2.9269}, /*cmx*/
          {2.53464,1.0394,0.8591,2.0519}, /*cfx*/
          {0.6674,-0.05498,253.6008,0.61912,0.005024,1.1706}, /*cmy*/
          {2.664766,0.6766,0.1098,2.1819}, /*cfy*/
          {9.7177,-0.02749,670.2784,1.47375,0.013245,3.177}, /*cmz*/
          {4.12358,2.567,2.3017,3.6123} /*cfz*/
     },
     {
          2451599.4,
          {-3.6019,-0.11176,626.1019,2.07082,0.007829,2.9063}, /*cmx*/
          {5.265987,3.785,3.2479,1.6551}, /*cfx*/
          {-0.9824,-0.04097,243.0411,0.88889,0.004489,1.0863}, /*cmy*/
          {5.39845,3.2985,2.1667,1.7945}, /*cfy*/
          {8.9577,-0.09917,670.1806,2.26201,0.007951,3.1371}, /*cmz*/
          {0.571299,5.2975,4.5693,3.2411} /*cfz*/
     },
     {
          2451629.4,
          {-7.0792,-0.05594,632.2063,2.47204,0.005831,2.8906}, /*cmx*/
          {1.688539,0.2156,5.3766,1.2608}, /*cfx*/
          {-2.2445,-0.01583,226.732,1.03447,0.004776,0.9808}, /*cmy*/
          {1.829182,5.864,4.3471,1.4064}, /*cfy*/
          {6.0336,-0.14642,670.5321,2.63817,0.005898,3.0545}, /*cmz*/
          {3.275135,1.7001,0.5819,2.8651} /*cfz*/
     },
     {
          2451659.4,
          {-8.8609,0.01711,639.6988,2.66704,0.005327,2.9083}, /*cmx*/
          {4.382415,2.9079,1.0343,0.8918}, /*cfx*/
          {-2.7339,0.01039,205.0036,1.09242,0.005078,0.8671}, /*cmy*/
          {4.536973,2.1244,0.3493,1.0486}, /*cfy*/
          {1.5272,-0.15275,670.1492,2.79841,0.006224,2.9923}, /*cmz*/
          {5.967234,4.4012,2.5938,2.4743} /*cfz*/
     },
     {
          2451689.4,
          {-8.3246,0.08427,647.4457,2.58466,0.005856,2.9126}, /*cmx*/
          {0.790714,5.5947,3.3761,0.5136}, /*cfx*/
          {-2.4041,0.02624,179.1931,1.07387,0.004626,0.7371}, /*cmy*/
          {0.9673,4.6489,2.6792,0.702}, /*cfy*/
          {-3.2134,-0.12511,670.4444,2.72582,0.00647,2.9968}, /*cmz*/
          {2.374159,0.7978,4.749,2.0925} /*cfz*/
     },
     {
          2451719.4,
          {-5.65,0.12997,654.2967,2.39246,0.009012,2.8958}, /*cmx*/
          {3.490823,2.0083,5.5555,0.1431}, /*cfx*/
          {-1.573,0.02859,151.6151,0.99681,0.004532,0.6118}, /*cmy*/
          {3.698677,0.9138,4.831,0.3689}, /*cfy*/
          {-7.0193,-0.06551,670.3834,2.4886,0.0094,2.9768}, /*cmz*/
          {5.071775,3.4916,0.682,1.7329} /*cfz*/
     },
     {
          2451749.4,
          {-1.6757,0.14345,660.0373,1.90622,0.011656,2.9424}, /*cmx*/
          {6.206426,4.7077,1.7343,6.102}, /*cfx*/
          {-0.7005,0.02373,125.5377,0.82487,0.005014,0.5053}, /*cmy*/
          {0.17437,3.4854,0.6646,0.0769}, /*cfy*/
          {-8.9024,0.00079,670.2943,1.98067,0.012639,2.922}, /*cmz*/
          {1.502738,6.2086,3.2079,1.4063} /*cfz*/
     },
     {
          2451779.4,
          {2.5821,0.11856,663.229,1.20006,0.016824,2.9821}, /*cmx*/
          {2.66654,1.1697,4.326,5.8233}, /*cfx*/
          {-0.0124,0.01727,105.2341,0.5381,0.006993,0.4484}, /*cmy*/
          {2.968564,6.1233,3.0774,6.1399}, /*cfy*/
          {-8.7798,0.06153,670.4341,1.23744,0.017298,2.975}, /*cmz*/
          {4.24453,2.6528,5.7812,1.0866} /*cfz*/
     },
     {
          2451809.4,
          {6.0718,0.07452,665.1839,0.1737,0.018503,2.9802}, /*cmx*/
          {5.448903,3.8743,0.78,5.5552}, /*cfx*/
          {0.4797,0.01591,95.4018,0.11732,0.007883,0.4352}, /*cmy*/
          {5.786611,2.4153,5.784,5.8983}, /*cfy*/
          {-6.9734,0.09302,670.2411,0.15533,0.018432,3.0634}, /*cmz*/
          {0.742568,5.5011,2.3474,0.8198} /*cfz*/
     },
     {
          2451839.4,
          {8.3238,0.03078,664.2361,0.99334,0.010946,2.9818}, /*cmx*/
          {1.995879,3.5959,3.8398,5.3032}, /*cfx*/
          {0.9585,0.01683,98.9217,0.38656,0.004506,0.479}, /*cmy*/
          {2.324831,2.3868,2.5137,5.6157}, /*cfy*/
          {-4.2636,0.09878,670.1468,0.9922,0.011899,3.0989}, /*cmz*/
          {3.57403,5.127,5.2725,0.6217} /*cfz*/
     },
     {
          2451869.4,
          {9.3392,-0.00235,661.9904,1.65951,0.00637,3.0655}, /*cmx*/
          {4.868347,0.229,3.072,5.128}, /*cfx*/
          {1.497,0.01306,114.332,0.67062,0.00246,0.5693}, /*cmy*/
          {5.151346,5.2851,1.91,5.394}, /*cfy*/
          {-1.3184,0.09766,670.4962,1.72918,0.007118,3.096}, /*cmz*/
          {0.163304,1.7514,4.7239,0.4176} /*cfz*/
     },
     {
          2451899.4,
          {9.3159,-0.03302,658.6929,1.24644,0.018087,3.1084}, /*cmx*/
          {1.464939,3.1304,6.2582,4.8928}, /*cfx*/
          {1.9161,0.00204,131.993,0.51067,0.00721,0.652}, /*cmy*/
          {1.703064,1.8874,5.1358,5.1183}, /*cfy*/
          {1.6857,0.10184,670.1397,1.26506,0.018113,3.1752}, /*cmz*/
          {3.04495,4.6153,1.4689,0.1952} /*cfz*/
     },
     {
          2451929.4,
          {8.2558,-0.075,656.6752,0.11488,0.018926,3.1125}, /*cmx*/
          {4.310613,5.9736,2.7969,4.6138}, /*cfx*/
          {1.9589,-0.01335,140.8165,0.0875,0.007714,0.6642}, /*cmy*/
          {4.523502,3.9392,1.6727,4.8245}, /*cfy*/
          {4.8054,0.09812,670.5356,0.12703,0.020285,3.2366}, /*cmz*/
          {5.890253,1.1965,4.31,6.1909} /*cfz*/
     },
     {
          2451959.4,
          {5.9321,-0.1251,657.5951,1.04962,0.013773,3.1383}, /*cmx*/
          {0.820562,5.6164,5.4784,4.275}, /*cfx*/
          {1.5218,-0.02532,136.455,0.42027,0.006134,0.6099}, /*cmy*/
          {1.028952,4.6612,4.1582,4.4872}, /*cfy*/
          {7.7501,0.06437,670.2104,1.08319,0.01428,3.2262}, /*cmz*/
          {2.399575,0.8576,0.6588,5.8667} /*cfz*/
     },
     {
          2451989.4,
          {2.1825,-0.15125,660.667,1.87385,0.009782,3.2055}, /*cmx*/
          {3.567808,2.0789,1.5683,3.91}, /*cfx*/
          {0.7421,-0.02435,119.9406,0.76438,0.00528,0.5164}, /*cmy*/
          {3.794329,0.9577,0.1091,4.1546}, /*cfy*/
          {9.6165,0.00117,670.5984,1.93482,0.00955,3.2029}, /*cmz*/
          {5.145915,3.5785,3.166,5.5025} /*cfz*/
     },
     {
          2452019.4,
          {-2.3385,-0.13876,664.681,2.40887,0.006658,3.2351}, /*cmx*/
          {0.002195,4.7802,3.7062,3.528}, /*cfx*/
          {0.0063,-0.01137,94.2553,1.00214,0.004804,0.3848}, /*cmy*/
          {0.27805,3.5267,2.2566,3.8267}, /*cfy*/
          {9.6688,-0.07944,670.5217,2.45513,0.006231,3.1808}, /*cmz*/
          {1.57803,0.0108,5.3478,5.0858} /*cfz*/
     },
     {
          2452049.4,
          {-6.5526,-0.08261,668.6382,2.62378,0.00614,3.1354}, /*cmx*/
          {2.702663,1.1684,5.9495,3.1239}, /*cfx*/
          {-0.321,0.00378,62.6649,1.12675,0.004645,0.2148}, /*cmy*/
          {3.103339,6.0837,4.5331,3.6434}, /*cfy*/
          {7.3397,-0.13501,670.5983,2.6862,0.005334,3.1767}, /*cmz*/
          {4.276896,2.7047,1.1275,4.6831} /*cfz*/
     },
     {
          2452079.4,
          {-9.1545,-0.00652,670.5579,2.66946,0.007001,3.0818}, /*cmx*/
          {5.398191,3.8418,1.6916,2.7252}, /*cfx*/
          {-0.1817,0.01137,31.4791,1.16371,0.004594,0.1042}, /*cmy*/
          {6.226218,2.3646,0.4814,4.1741}, /*cfy*/
          {3.2137,-0.15517,670.6333,2.71661,0.006225,3.1076}, /*cmz*/
          {0.687085,5.3992,3.1711,4.307} /*cfz*/
     },
     {
          2452109.4,
          {-9.3167,0.06212,670.966,2.46674,0.007329,3.0833}, /*cmx*/
          {1.813933,0.2232,3.9738,2.3606}, /*cfx*/
          {0.1756,0.00682,26.5225,1.1093,0.004457,0.1704}, /*cmy*/
          {3.989692,4.9399,2.6258,4.919}, /*cfy*/
          {-1.6001,-0.13524,670.6206,2.50726,0.007698,3.03}, /*cmz*/
          {3.383782,1.8141,5.5475,3.9297} /*cfz*/
     },
     {
          2452139.4,
          {-7.2909,0.11416,669.3472,2.09037,0.010883,2.9756}, /*cmx*/
          {4.52516,2.9107,6.272,2.0087}, /*cfx*/
          {0.3822,-0.00582,52.0764,0.94564,0.00486,0.2854}, /*cmy*/
          {0.981506,1.2555,4.746,4.8474}, /*cfy*/
          {-5.732,-0.08861,670.7286,2.14409,0.011729,3.0449}, /*cmz*/
          {6.094102,4.511,1.498,3.5647} /*cfz*/
     },
     {
          2452169.4,
          {-3.7486,0.13161,666.9,1.47096,0.016074,2.9069}, /*cmx*/
          {0.976542,5.6343,2.562,1.6845}, /*cfx*/
          {0.1925,-0.01486,75.8857,0.67273,0.006731,0.3682}, /*cmy*/
          {3.863229,3.9193,0.8005,4.593}, /*cfy*/
          {-8.2936,-0.02849,670.9487,1.45755,0.015063,2.9714}, /*cmz*/
          {2.543772,0.9556,4.1214,3.259} /*cfz*/
     },
     {
          2452199.4,
          {0.184,0.12097,665.3024,0.5121,0.018869,2.9144}, /*cmx*/
          {3.745537,2.0817,5.2295,1.4157}, /*cfx*/
          {-0.2672,-0.01545,90.0013,0.26322,0.008107,0.403}, /*cmy*/
          {0.401368,0.4396,3.4549,4.3637}, /*cfy*/
          {-9.0161,0.02554,670.4582,0.50159,0.018897,2.9267}, /*cmz*/
          {5.312586,3.7959,0.6357,3.0066} /*cfz*/
     },
     {
          2452229.4,
          {3.7241,0.09042,665.0694,0.67733,0.014012,2.9447}, /*cmx*/
          {0.277878,1.7874,1.8912,1.2049}, /*cfx*/
          {-0.7233,-0.00646,90.6346,0.25415,0.006749,0.3718}, /*cmy*/
          {3.224537,6.1043,0.1793,4.1419}, /*cfy*/
          {-8.2172,0.06226,670.9412,0.67375,0.014515,2.9422}, /*cmz*/
          {1.845758,3.4192,3.4751,2.7787} /*cfz*/
     },
     {
          2452259.4,
          {6.3998,0.06107,666.7625,1.54551,0.00154,2.9811}, /*cmx*/
          {3.140613,4.6677,6.0219,1.0179}, /*cfx*/
          {-0.9148,0.00467,77.4669,0.67003,0.00172,0.308}, /*cmy*/
          {6.056076,2.8701,4.3895,3.8796}, /*cfy*/
          {-6.4172,0.08022,670.6207,1.60615,0.002683,2.9431}, /*cmz*/
          {4.708036,6.2659,1.9023,2.5716} /*cfz*/
     },
     {
          2452289.4,
          {8.3248,0.03054,668.8712,1.51784,0.016138,2.9585}, /*cmx*/
          {6.02273,1.2881,4.392,0.8175}, /*cfx*/
          {-0.7694,0.00654,57.401,0.67257,0.006411,0.2123}, /*cmy*/
          {2.575509,5.85,2.6294,3.5842}, /*cfy*/
          {-4.0424,0.10009,670.8869,1.51098,0.015474,3.0264}, /*cmz*/
          {1.30887,2.8939,6.0084,2.3927} /*cfz*/
     },
     {
          2452319.4,
          {9.3264,-0.0026,669.6568,0.50355,0.018676,3.0756}, /*cmx*/
          {2.599806,4.1157,0.9964,0.5707}, /*cfx*/
          {-0.5592,0.00322,43.2553,0.26541,0.008311,0.1924}, /*cmy*/
          {5.335782,2.4401,5.6312,3.2979}, /*cfy*/
          {-0.9554,0.11637,670.8611,0.53508,0.019796,3.082}, /*cmz*/
          {4.168679,5.7442,2.6001,2.1622} /*cfz*/
     },
     {
          2452349.4,
          {9.1682,-0.055,669.9856,0.64856,0.016571,3.1711}, /*cmx*/
          {5.410346,3.8308,3.7222,0.2691}, /*cfx*/
          {-0.4666,0.00086,42.6747,0.24641,0.006879,0.23}, /*cmy*/
          {1.870893,2.2476,2.0025,3.0944}, /*cfy*/
          {2.6939,0.11999,670.644,0.68434,0.015523,3.1325}, /*cmz*/
          {0.696706,5.4438,5.2978,1.8459} /*cfz*/
     },
     {
          2452379.4,
          {7.3961,-0.11416,668.6812,1.59983,0.010726,3.198}, /*cmx*/
          {1.890013,0.3052,6.1702,6.2119}, /*cfx*/
          {-0.4533,0.00565,55.7252,0.66079,0.004999,0.3144}, /*cmy*/
          {4.746086,4.9113,4.3174,2.8428}, /*cfy*/
          {6.3142,0.09485,670.9451,1.62204,0.010115,3.1761}, /*cmz*/
          {3.459045,1.8827,1.6752,1.4714} /*cfz*/
     },
     {
          2452409.4,
          {3.9153,-0.15237,666.5448,2.22514,0.006487,3.1612}, /*cmx*/
          {4.618784,2.9978,2.139,5.8207}, /*cfx*/
          {-0.295,0.01877,79.3095,0.92593,0.004197,0.4422}, /*cmy*/
          {1.293775,1.2561,0.1536,2.5405}, /*cfy*/
          {9.11,0.02945,670.7737,2.215,0.007315,3.2348}, /*cmz*/
          {6.186603,4.6246,3.8982,1.1107} /*cfz*/
     },
     {
          2452439.4,
          {-0.6603,-0.14907,662.292,2.50235,0.0058,3.2038}, /*cmx*/
          {1.04266,5.6876,4.3042,5.424}, /*cfx*/
          {0.2604,0.0311,108.6976,1.06461,0.004056,0.6048}, /*cmy*/
          {4.066021,3.8477,2.3045,2.1907}, /*cfy*/
          {9.9852,-0.04832,670.7349,2.55138,0.005393,3.2624}, /*cmz*/
          {2.610775,1.0471,5.9182,0.7134} /*cfz*/
     },
     {
          2452469.4,
          {-5.19,-0.10273,656.3719,2.58919,0.005928,3.1902}, /*cmx*/
          {3.741143,2.0857,0.0825,5.0233}, /*cfx*/
          {1.219,0.03201,139.492,1.09586,0.0042,0.7522}, /*cmy*/
          {0.52101,0.1468,4.5329,1.8159}, /*cfy*/
          {8.542,-0.11688,671.0386,2.61274,0.004913,3.2265}, /*cmz*/
          {5.308508,3.7353,1.9337,0.2957} /*cfz*/
     },
     {
          2452499.4,
          {-8.3693,-0.03353,649.865,2.46787,0.006593,3.0557}, /*cmx*/
          {0.156202,4.7555,2.0881,4.6207}, /*cfx*/
          {2.2249,0.01955,168.3524,1.03794,0.003751,0.854}, /*cmy*/
          {3.246401,2.7188,0.429,1.4389}, /*cfy*/
          {4.9935,-0.14952,670.8429,2.53064,0.007258,3.2346}, /*cmz*/
          {1.723836,0.1548,3.9353,6.1879} /*cfz*/
     },
     {
          2452529.4,
          {-9.4152,0.03426,642.7126,2.11954,0.009207,2.9787}, /*cmx*/
          {2.863515,1.1891,4.6375,4.2491}, /*cfx*/
          {2.8351,-0.00237,192.6705,0.89863,0.004552,0.9452}, /*cmy*/
          {5.972691,5.3365,2.6417,1.0849}, /*cfy*/
          {0.3455,-0.14128,671.0388,2.23604,0.010696,3.1782}, /*cmz*/
          {4.432341,2.8539,6.2124,5.8274} /*cfz*/
     },
     {
          2452559.4,
          {-8.2595,0.08004,636.8982,1.58091,0.014363,2.9917}, /*cmx*/
          {5.590949,3.9138,0.8408,3.8983}, /*cfx*/
          {2.7262,-0.02261,210.8516,0.66346,0.006082,1.0234}, /*cmy*/
          {2.431505,1.7053,4.8555,0.7449}, /*cfy*/
          {-4.044,-0.10551,671.1747,1.60975,0.013975,3.0848}, /*cmz*/
          {0.876323,5.5719,2.4709,5.4915} /*cfz*/
     },
     {
          2452589.4,
          {-5.6825,0.10407,633.4991,0.73063,0.017295,2.8848}, /*cmx*/
          {2.06699,0.3522,3.5012,3.6132}, /*cfx*/
          {1.9822,-0.03555,221.8794,0.2929,0.007235,1.0212}, /*cmy*/
          {5.201538,4.5077,1.1888,0.4699}, /*cfy*/
          {-7.1847,-0.05827,670.8568,0.75885,0.018793,3.0172}, /*cmz*/
          {3.637092,2.0815,5.2334,5.1725} /*cfz*/
     },
     {
          2452619.4,
          {-2.5219,0.10489,632.1011,0.38315,0.015473,2.7884}, /*cmx*/
          {4.870629,6.2818,0.1645,3.3778}, /*cfx*/
          {0.8916,-0.03669,224.3021,0.18492,0.006935,0.9775}, /*cmy*/
          {1.729027,3.5897,4.1818,0.2377}, /*cfy*/
          {-8.7904,-0.01103,671.2282,0.40259,0.016452,2.9544}, /*cmz*/
          {0.158427,1.7749,1.721,4.9361} /*cfz*/
     },
     {
          2452649.4,
          {0.53,0.09679,634.6651,1.33379,0.00434,2.7894}, /*cmx*/
          {1.440599,2.923,3.2068,3.1859}, /*cfx*/
          {-0.1808,-0.03117,218.2944,0.58599,0.002395,0.9331}, /*cmy*/
          {4.584786,0.5476,1.4895,0.0387}, /*cfy*/
          {-9.1058,0.02853,670.9091,1.42774,0.003905,2.9213}, /*cmz*/
          {3.011292,4.5809,5.0423,4.759} /*cfz*/
     },
     {
          2452679.4,
          {3.4213,0.07986,638.6629,1.58381,0.012167,2.8274}, /*cmx*/
          {4.321454,5.7933,2.5369,2.9942}, /*cfx*/
          {-1.1067,-0.02196,205.6509,0.66989,0.005047,0.8768}, /*cmy*/
          {1.180447,3.5526,0.1346,6.1346}, /*cfy*/
          {-8.3331,0.05857,671.0732,1.60737,0.011703,2.9181}, /*cmz*/
          {5.893093,1.1896,4.2719,4.5721} /*cfz*/
     },
     {
          2452709.4,
          {5.9538,0.0645,642.3685,0.79406,0.01786,2.8268}, /*cmx*/
          {0.908752,2.3841,5.5435,2.7856}, /*cfx*/
          {-1.7985,-0.01795,193.9438,0.35096,0.007734,0.8427}, /*cmy*/
          {4.045938,0.2943,3.3532,5.9192}, /*cfy*/
          {-6.6299,0.09335,671.0211,0.85338,0.019912,2.9107}, /*cmz*/
          {2.478742,4.0486,0.8977,4.3392} /*cfz*/
     },
     {
          2452739.4,
          {8.0121,0.0278,643.5729,0.28758,0.016731,2.8174}, /*cmx*/
          {3.733694,2.0169,2.0793,2.5343}, /*cfx*/
          {-2.3688,-0.01151,190.7003,0.11517,0.007121,0.8488}, /*cmy*/
          {0.58409,5.9671,6.1132,5.6684}, /*cfy*/
          {-3.7621,0.12403,670.9161,0.34895,0.015815,2.9804}, /*cmz*/
          {5.304533,3.7775,3.6716,4.0703} /*cfz*/
     },
     {
          2452769.4,
          {8.8755,-0.02654,640.998,1.28371,0.011229,2.869}, /*cmx*/
          {0.227861,4.8825,4.542,2.1937}, /*cfx*/
          {-2.7331,0.00197,197.4265,0.54203,0.004647,0.9138}, /*cmy*/
          {3.361982,2.6185,2.209,5.3278}, /*cfy*/
          {0.1202,0.13627,671.1578,1.34796,0.011082,3.0633}, /*cmz*/
          {1.798129,0.2235,0.0546,3.7746} /*cfz*/
     },
     {
          2452799.4,
          {7.9746,-0.08761,636.8331,1.92899,0.006937,2.9336}, /*cmx*/
          {2.966508,1.3044,0.7558,1.8266}, /*cfx*/
          {-2.6524,0.02289,211.5958,0.813,0.003643,1.019}, /*cmy*/
          {6.105542,5.2923,4.4019,4.9731}, /*cfy*/
          {4.3358,0.11791,670.9056,1.9864,0.008112,3.1216}, /*cmz*/
          {4.5366,2.9748,2.4168,3.415} /*cfz*/
     },
     {
          2452829.4,
          {5.249,-0.13546,630.8078,2.28308,0.004966,2.9669}, /*cmx*/
          {5.680568,4.0175,2.9761,1.4597}, /*cfx*/
          {-1.9384,0.04682,228.7848,0.96289,0.00381,1.125}, /*cmy*/
          {2.543888,1.6385,0.2692,4.6108}, /*cfy*/
          {7.8575,0.0656,671.0061,2.41829,0.005015,3.116}, /*cmz*/
          {0.969092,5.6826,4.5126,3.0206} /*cfz*/
     },
     {
          2452859.4,
          {1.186,-0.14906,624.3784,2.43676,0.004628,2.9542}, /*cmx*/
          {2.099034,0.4428,4.8058,1.0656}, /*cfx*/
          {-0.5368,0.06041,245.6537,1.03161,0.00367,1.2043}, /*cmy*/
          {5.254821,4.2334,2.3836,4.227}, /*cfy*/
          {9.8013,-0.01539,671.1911,2.54186,0.004194,3.2292}, /*cmz*/
          {3.671313,2.092,0.4179,2.6443} /*cfz*/
     },
     {
          2452889.4,
          {-3.2986,-0.1175,618.7018,2.38403,0.005673,2.9931}, /*cmx*/
          {4.797545,3.1436,0.5554,0.6623}, /*cfx*/
          {1.2896,0.05379,260.1616,1.00356,0.003445,1.2907}, /*cmy*/
          {1.680311,0.5364,4.5663,3.8351}, /*cfy*/
          {9.3996,-0.08919,670.7846,2.51686,0.006529,3.2729}, /*cmz*/
          {0.088748,4.8064,2.4472,2.2485} /*cfz*/
     },
     {
          2452919.4,
          {-6.9591,-0.05954,613.9679,2.09396,0.008215,3.0277}, /*cmx*/
          {1.218938,5.8664,3.0279,0.2769}, /*cfx*/
          {2.972,0.03167,270.8731,0.8801,0.004213,1.3593}, /*cmy*/
          {4.395445,3.1613,0.5067,3.4588}, /*cfy*/
          {6.7239,-0.13323,671.1366,2.2593,0.009129,3.2362}, /*cmz*/
          {2.795944,1.2118,4.597,1.85} /*cfz*/
     },
     {
          2452949.4,
          {-8.8256,-0.0023,610.8672,1.65195,0.013245,2.932}, /*cmx*/
          {3.942029,2.3224,5.5418,6.207}, /*cfx*/
          {3.9642,0.00592,277.812,0.67966,0.005999,1.3463}, /*cmy*/
          {0.845878,5.8073,2.7501,3.1164}, /*cfy*/
          {2.5928,-0.13755,670.9138,1.72838,0.012942,3.2353}, /*cmz*/
          {5.520157,3.9405,0.8813,1.4886} /*cfz*/
     },
     {
          2452979.4,
          {-8.8404,0.04519,609.5422,0.85072,0.015743,2.8933}, /*cmx*/
          {0.410167,5.0459,1.8977,5.8907}, /*cfx*/
          {4.1214,-0.01708,281.5776,0.3128,0.006811,1.3414}, /*cmy*/
          {3.606785,2.2311,5.3019,2.8093}, /*cfy*/
          {-1.6852,-0.11637,670.7773,0.9212,0.017819,3.2265}, /*cmz*/
          {1.991096,0.4233,3.5791,1.1766} /*cfz*/
     },
     {
          2453009.4,
          {-7.3815,0.07081,608.6,0.12904,0.016243,2.8562}, /*cmx*/
          {3.205419,4.6504,4.7817,5.6007}, /*cfx*/
          {3.5617,-0.03072,282.5264,0.1171,0.006919,1.3225}, /*cmy*/
          {0.126439,1.5797,1.9283,2.5247}, /*cfy*/
          {-5.1827,-0.08052,670.9424,0.14941,0.017765,3.173}, /*cmz*/
          {4.787342,0.1162,0.0806,0.9156} /*cfz*/
     },
     {
          2453039.4,
          {-5.2106,0.08417,609.4362,1.13839,0.006314,2.8257}, /*cmx*/
          {6.048586,1.3092,1.4758,5.3882}, /*cfx*/
          {2.6167,-0.03863,281.7529,0.54408,0.002443,1.2991}, /*cmy*/
          {2.973116,4.6853,5.3403,2.3097}, /*cfy*/
          {-7.5463,-0.04257,670.6046,1.26862,0.006801,3.0372}, /*cmz*/
          {1.347546,2.8961,3.3225,0.6827} /*cfz*/
     },
     {
          2453069.4,
          {-2.7656,0.09545,610.5509,1.51581,0.008385,2.7217}, /*cmx*/
          {2.6434,4.1664,0.8846,5.2008}, /*cfx*/
          {1.4871,-0.04361,278.3608,0.66457,0.004358,1.2314}, /*cmy*/
          {5.849721,1.3643,4.2273,2.1238}, /*cfy*/
          {-8.7742,-0.01332,670.984,1.63323,0.009169,3.0076}, /*cmz*/
          {4.225591,5.8129,2.6213,0.4849} /*cfz*/
     },
     {
          2453099.4,
          {0.0181,0.10189,612.8079,0.95869,0.01575,2.6766}, /*cmx*/
          {5.51906,0.7763,3.9282,4.9912}, /*cfx*/
          {0.215,-0.04666,274.3174,0.3942,0.007211,1.193}, /*cmy*/
          {2.436729,4.3772,1.1858,1.9062}, /*cfy*/
          {-9.2448,0.02963,670.9115,1.07095,0.018588,3.0184}, /*cmz*/
          {0.815888,2.395,5.52,0.2717} /*cfz*/
     },
     {
          2453129.4,
          {3.1454,0.09061,613.4929,0.03443,0.015998,2.6802}, /*cmx*/
          {2.072786,0.5954,0.4321,4.7085}, /*cfx*/
          {-1.2065,-0.04268,272.081,0.05713,0.006932,1.1914}, /*cmy*/
          {5.267818,3.66,3.9644,1.6185}, /*cfy*/
          {-8.5064,0.07549,670.6677,0.0893,0.016278,2.9491}, /*cmz*/
          {3.652946,2.4524,2.0219,0.0221} /*cfz*/
     },
     {
          2453159.4,
          {6.0335,0.06015,612.6791,0.97908,0.011877,2.6667}, /*cmx*/
          {4.861557,3.2541,3.0883,4.4163}, /*cfx*/
          {-2.5621,-0.03132,273.7014,0.46376,0.005087,1.2}, /*cmy*/
          {1.770254,0.4745,0.1935,1.3248}, /*cfy*/
          {-6.2581,0.11787,671.0836,1.06796,0.013023,2.8919}, /*cmz*/
          {0.15746,4.8666,4.7473,6.0059} /*cfz*/
     },
     {
          2453189.4,
          {7.9034,0.00802,610.8949,1.70124,0.006911,2.6557}, /*cmx*/
          {1.326937,5.997,5.6245,4.1062}, /*cfx*/
          {-3.5407,-0.0092,278.0655,0.76949,0.0034,1.2232}, /*cmy*/
          {4.519348,3.1707,2.4563,1.0189}, /*cfy*/
          {-2.5753,0.14273,670.6706,1.83268,0.008525,2.9232}, /*cmz*/
          {2.906304,1.3507,0.8519,5.6717} /*cfz*/
     },
     {
          2453219.4,
          {8.0802,-0.05483,608.7145,2.08702,0.005083,2.7008}, /*cmx*/
          {4.047066,2.4468,1.6933,3.7365}, /*cfx*/
          {-3.7927,0.02021,282.7211,0.92982,0.003441,1.2644}, /*cmy*/
          {0.960276,5.8285,4.6098,0.6536}, /*cfy*/
          {1.814,0.1406,670.9616,2.2881,0.005713,3.0049}, /*cmz*/
          {5.627864,4.0568,3.1777,5.3296} /*cfz*/
     },
     {
          2453249.4,
          {6.3477,-0.113,607.2051,2.32102,0.003721,2.7606}, /*cmx*/
          {0.469351,5.1731,3.4546,3.3568}, /*cfx*/
          {-3.1438,0.04947,285.81,1.02255,0.003494,1.3007}, /*cmy*/
          {3.67257,2.1674,0.3498,0.2808}, /*cfy*/
          {6.0349,0.09566,670.8402,2.5235,0.004481,3.0429}, /*cmz*/
          {2.051034,0.4768,5.077,4.9542} /*cfz*/
     },
     {
          2453279.4,
          {2.9666,-0.14301,607.2903,2.30111,0.004339,2.8401}, /*cmx*/
          {3.168595,1.6024,5.5735,2.9942}, /*cfx*/
          {-1.6613,0.06511,286.3278,0.99246,0.003569,1.3328}, /*cmy*/
          {0.09756,4.7666,2.6573,6.2096}, /*cfy*/
          {8.8822,0.02507,670.754,2.51569,0.005803,3.0675}, /*cmz*/
          {4.752422,3.1788,0.8737,4.5742} /*cfz*/
     },
     {
          2453309.4,
          {-1.3117,-0.13037,608.2289,2.1217,0.007494,2.8853}, /*cmx*/
          {5.873113,4.3345,1.5367,2.6327}, /*cfx*/
          {0.2855,0.0597,283.7171,0.89236,0.004263,1.337}, /*cmy*/
          {2.812771,1.0976,4.8138,5.8625}, /*cfy*/
          {9.6565,-0.05335,670.7865,2.31813,0.008707,3.1907}, /*cmz*/
          {1.175477,5.8779,3.0317,4.1929} /*cfz*/
     },
     {
          2453339.4,
          {-5.2727,-0.08903,610.7746,1.70407,0.011565,2.9283}, /*cmx*/
          {2.309758,0.7712,3.9714,2.2564}, /*cfx*/
          {2.0919,0.04153,279.3984,0.69193,0.005373,1.3269}, /*cmy*/
          {5.544056,3.6981,0.7351,5.4978}, /*cfy*/
          {8.1147,-0.10518,670.6767,1.81535,0.012201,3.2791}, /*cmz*/
          {3.896298,2.3121,5.5622,3.8399} /*cfz*/
     },
     {
          2453369.4,
          {-8.0373,-0.03367,612.7911,1.01695,0.015985,2.9788}, /*cmx*/
          {5.056929,3.538,0.3918,1.9124}, /*cfx*/
          {3.3737,0.01866,274.6362,0.37968,0.006845,1.3225}, /*cmy*/
          {2.019245,0.0765,3.2953,5.1619}, /*cfy*/
          {4.8994,-0.12162,670.3682,1.09392,0.017755,3.2478}, /*cmz*/
          {0.362316,5.0785,1.9461,3.5177} /*cfz*/
     },
     {
          2453399.4,
          {-9.0555,0.00706,613.8538,0.03209,0.015864,2.9702}, /*cmx*/
          {1.561153,0.4937,3.2233,1.6516}, /*cfx*/
          {3.9416,0.00302,272.3288,0.04844,0.006435,1.3217}, /*cmy*/
          {4.81553,0.2633,6.0789,4.9085}, /*cfy*/
          {1.1306,-0.112,670.5435,0.00289,0.016632,3.2398}, /*cmz*/
          {3.150115,5.1888,4.7482,3.2269} /*cfz*/
     },
     {
          2453429.4,
          {-8.7243,0.03653,613.344,0.97623,0.008132,2.9502}, /*cmx*/
          {4.395942,6.0246,6.1328,1.3965}, /*cfx*/
          {3.9897,-0.00978,273.9548,0.45321,0.002953,1.3302}, /*cmy*/
          {1.370704,2.6649,2.868,4.6569}, /*cfy*/
          {-2.2596,-0.09459,670.1287,1.04949,0.009777,3.2566}, /*cmz*/
          {5.986289,1.258,1.4279,2.995} /*cfz*/
     },
     {
          2453459.4,
          {-7.5743,0.06389,611.2389,1.48365,0.005871,2.8714}, /*cmx*/
          {0.985472,2.6021,5.4558,1.1654}, /*cfx*/
          {3.6719,-0.0244,278.1423,0.63515,0.003228,1.3165}, /*cmy*/
          {4.240445,5.5592,2.1166,4.4198}, /*cfy*/
          {-5.0001,-0.07703,670.7151,1.61272,0.006558,3.2569}, /*cmz*/
          {2.575627,4.1661,0.9056,2.7783} /*cfz*/
     },
     {
          2453489.4,
          {-5.7224,0.09184,609.5772,1.09666,0.014686,2.8649}, /*cmx*/
          {3.863274,5.4868,2.35,0.9337}, /*cfx*/
          {2.9624,-0.04057,281.9688,0.43137,0.006605,1.328}, /*cmy*/
          {0.827143,2.2002,5.3733,4.1752}, /*cfy*/
          {-7.2311,-0.05396,670.2027,1.19671,0.016509,3.1008}, /*cmz*/
          {5.452241,0.7264,3.8417,2.5432} /*cfz*/
     },
     {
          2453519.4,
          {-3.0503,0.11423,608.732,0.19516,0.016511,2.8116}, /*cmx*/
          {0.425468,2.063,5.1582,0.6843}, /*cfx*/
          {1.7797,-0.0531,283.5098,0.02804,0.007073,1.3088}, /*cmy*/
          {3.664418,4.5994,1.911,3.9185}, /*cfy*/
          {-8.8624,-0.01464,670.7184,0.16733,0.017464,3.0402}, /*cmz*/
          {2.014075,3.6304,0.451,2.2771} /*cfz*/
     },
     {
          2453549.4,
          {0.387,0.11763,608.6882,0.80692,0.012012,2.7581}, /*cmx*/
          {3.224802,1.7126,1.5705,0.3862}, /*cfx*/
          {0.1828,-0.05574,282.9083,0.40452,0.005003,1.2771}, /*cmy*/
          {0.175655,4.7921,4.4492,3.6181}, /*cfy*/
          {-9.4167,0.04412,670.5703,0.88826,0.013469,3.0036}, /*cmz*/
          {4.811734,3.2572,3.1242,1.9556} /*cfz*/
     },
     {
          2453579.4,
          {4.0276,0.09319,610.1939,1.52516,0.009055,2.6782}, /*cmx*/
          {5.980799,4.4564,4.1733,0.0415}, /*cfx*/
          {-1.5399,-0.04377,280.2611,0.69695,0.004056,1.2169}, /*cmy*/
          {2.931303,1.1731,0.4976,3.2779}, /*cfy*/
          {-8.1441,0.09799,670.628,1.68939,0.00933,2.9635}, /*cmz*/
          {1.284722,6.0,5.6626,1.6248} /*cfz*/
     },
     {
          2453609.4,
          {6.9327,0.04503,612.6009,2.04577,0.005132,2.6681}, /*cmx*/
          {2.424057,0.9145,0.1813,5.9754}, /*cfx*/
          {-2.9056,-0.02043,274.501,0.89727,0.003558,1.173}, /*cmy*/
          {5.661964,3.8158,2.4778,2.9329}, /*cfy*/
          {-5.0915,0.13993,670.6097,2.23434,0.005822,2.8942}, /*cmz*/
          {4.010999,2.4432,1.6132,1.2891} /*cfz*/
     },
     {
          2453639.4,
          {8.2202,-0.01816,616.9825,2.2905,0.004109,2.7132}, /*cmx*/
          {5.132183,3.6324,2.4344,5.6386}, /*cfx*/
          {-3.4887,0.00761,265.2981,0.97518,0.003631,1.1362}, /*cmy*/
          {2.09493,0.121,4.7929,2.6033}, /*cfy*/
          {-0.7496,0.15002,670.4472,2.49012,0.005429,2.8997}, /*cmz*/
          {0.435858,5.1533,3.7118,0.9287} /*cfz*/
     },
     {
          2453669.4,
          {7.5582,-0.08748,622.4298,2.36517,0.004302,2.7169}, /*cmx*/
          {1.54984,0.0638,4.1868,5.2708}, /*cfx*/
          {-3.1966,0.03406,252.1465,0.97872,0.00399,1.0622}, /*cmy*/
          {4.807436,2.6994,0.7052,2.2559}, /*cfy*/
          {3.7775,0.12409,670.4432,2.56146,0.005405,3.0037}, /*cmz*/
          {3.137213,1.5604,5.5033,0.5635} /*cfz*/
     },
     {
          2453699.4,
          {4.8997,-0.13179,628.7397,2.24051,0.007564,2.8002}, /*cmx*/
          {4.254216,2.7773,0.0361,4.8987}, /*cfx*/
          {-2.1505,0.04667,236.1795,0.91043,0.004419,1.0065}, /*cmy*/
          {1.243798,5.2686,2.8853,1.9004}, /*cfy*/
          {7.4276,0.06193,670.5664,2.35641,0.007364,2.9935}, /*cmz*/
          {5.840719,4.2588,1.5309,0.2225} /*cfz*/
     },
     {
          2453729.4,
          {0.9671,-0.13949,634.9648,1.855,0.011489,2.9203}, /*cmx*/
          {0.688601,5.498,2.4626,4.569}, /*cfx*/
          {-0.7579,0.04449,219.368,0.74042,0.004913,0.9676}, /*cmy*/
          {3.97875,1.5525,5.0455,1.5784}, /*cfy*/
          {9.2779,-0.01119,670.1113,1.9425,0.012196,3.0223}, /*cmz*/
          {2.274954,0.7039,3.9975,6.1689} /*cfz*/
     },
     {
          2453759.4,
          {-3.2411,-0.10904,639.7542,1.16232,0.015045,3.002}, /*cmx*/
          {3.431212,1.9654,5.1312,4.2684}, /*cfx*/
          {0.5703,0.03458,205.0304,0.46876,0.006133,0.9379}, /*cmy*/
          {0.456726,4.1452,1.155,1.3013}, /*cfy*/
          {8.9548,-0.06591,670.3918,1.21628,0.015702,3.1271}, /*cmz*/
          {5.017753,3.4258,0.2881,5.8372} /*cfz*/
     },
     {
          2453789.4,
          {-6.5829,-0.06633,642.2155,0.245,0.017538,3.0583}, /*cmx*/
          {6.212115,4.755,1.5746,3.9682}, /*cfx*/
          {1.6138,0.02569,197.3667,0.10443,0.006924,0.939}, /*cmy*/
          {3.251442,0.2238,3.8639,1.0119}, /*cfy*/
          {6.9478,-0.09222,670.0606,0.21904,0.017428,3.1905}, /*cmz*/
          {1.514731,6.2722,3.1082,5.5555} /*cfz*/
     },
     {
          2453819.4,
          {-8.6148,-0.02578,641.7639,0.84347,0.009917,3.0631}, /*cmx*/
          {2.754637,4.4098,4.5699,3.715}, /*cfx*/
          {2.408,0.0184,199.2337,0.33879,0.003853,0.9768}, /*cmy*/
          {6.08041,0.5397,0.5345,0.7587}, /*cfy*/
          {4.0888,-0.09622,670.0558,0.85887,0.01157,3.2134}, /*cmz*/
          {4.342059,5.8999,6.0373,5.3267} /*cfz*/
     },
     {
          2453849.4,
          {-9.3158,-0.00023,638.1566,1.45952,0.002811,3.1115}, /*cmx*/
          {5.621263,0.9948,3.4202,3.5075}, /*cfx*/
          {2.9551,0.01234,209.3137,0.58632,0.001609,1.051}, /*cmy*/
          {2.654888,3.3549,5.9123,0.532}, /*cfy*/
          {1.1049,-0.09621,670.2791,1.58229,0.003939,3.2277}, /*cmz*/
          {0.925181,2.5069,5.3776,5.097} /*cfz*/
     },
     {
          2453879.4,
          {-9.1891,0.03503,634.5578,1.27475,0.014637,3.1194}, /*cmx*/
          {2.216249,3.9112,0.7489,3.2713}, /*cfx*/
          {3.2865,-0.00365,221.5977,0.4854,0.005895,1.1148}, /*cmy*/
          {5.51779,6.2764,3.2296,0.2825}, /*cfy*/
          {-1.799,-0.10271,670.0807,1.33343,0.015074,3.2438}, /*cmz*/
          {3.804217,5.3762,2.1942,4.8549} /*cfz*/
     },
     {
          2453909.4,
          {-8.1206,0.07823,631.4126,0.38624,0.016731,3.0391}, /*cmx*/
          {5.069242,0.422,3.5581,2.9985}, /*cfx*/
          {3.1658,-0.02406,228.6646,0.13707,0.006806,1.1076}, /*cmy*/
          {2.07471,2.5018,6.0385,0.0008}, /*cfy*/
          {-4.7876,-0.09582,670.3515,0.38776,0.017713,3.2508}, /*cmz*/
          {0.373874,1.9699,5.1219,4.5639} /*cfz*/
     },
     {
          2453939.4,
          {-5.8303,0.11867,631.8267,0.64845,0.013757,2.9837}, /*cmx*/
          {1.594374,0.0956,0.0754,2.6698}, /*cfx*/
          {2.451,-0.04132,228.3747,0.3025,0.005386,1.0576}, /*cmy*/
          {4.876259,2.7772,2.3945,5.951}, /*cfy*/
          {-7.6593,-0.05601,670.2393,0.68942,0.015024,3.1843}, /*cmz*/
          {3.180881,1.6388,1.5075,4.2715} /*cfz*/
     },
     {
          2453969.4,
          {-2.2725,0.1378,634.4835,1.47736,0.009952,2.9991}, /*cmx*/
          {4.357739,2.8923,2.591,2.3339}, /*cfx*/
          {1.2035,-0.04619,220.1607,0.61833,0.004604,1.0031}, /*cmy*/
          {1.357592,5.3855,4.6609,5.6198}, /*cfy*/
          {-9.4462,0.00305,670.2407,1.59358,0.009896,3.1189}, /*cmz*/
          {5.944043,4.3892,4.0459,3.9176} /*cfz*/
     },
     {
          2453999.4,
          {2.0068,0.12491,639.5083,2.06964,0.006676,2.9567}, /*cmx*/
          {0.80562,5.6215,4.9457,1.9693}, /*cfx*/
          {-0.2305,-0.0358,204.9304,0.84967,0.004376,0.8999}, /*cmy*/
          {4.09827,1.7018,0.5066,5.2675}, /*cfy*/
          {-9.3966,0.0713,670.4265,2.15431,0.008026,3.0599}, /*cmz*/
          {2.39008,0.8265,0.1925,3.5347} /*cfz*/
     },
     {
          2454029.4,
          {5.8942,0.08348,646.3662,2.39398,0.004144,2.8559}, /*cmx*/
          {3.515546,2.0315,0.9117,1.5829}, /*cfx*/
          {-1.3455,-0.01649,183.4031,0.98613,0.004188,0.7476}, /*cmy*/
          {0.543343,4.2476,2.7483,4.9095}, /*cfy*/
          {-7.1679,0.12612,670.2312,2.52795,0.005404,3.0312}, /*cmz*/
          {5.099009,3.5334,2.1061,3.1684} /*cfz*/
     },
     {
          2454059.4,
          {8.4077,0.01579,653.0291,2.50445,0.005978,2.8619}, /*cmx*/
          {6.216352,4.7456,2.8449,1.2217}, /*cfx*/
          {-1.8318,0.00317,156.5902,1.03543,0.004433,0.6127}, /*cmy*/
          {3.275821,0.5219,5.0751,4.5895}, /*cfy*/
          {-3.2086,0.15142,670.4498,2.63886,0.005443,2.9378}, /*cmz*/
          {1.515209,6.2209,4.015,2.8147} /*cfz*/
     },
     {
          2454089.4,
          {8.7596,-0.0555,659.4558,2.40421,0.007791,2.9312}, /*cmx*/
          {2.635484,1.1454,4.831,0.8706}, /*cfx*/
          {-1.6955,0.01477,127.3129,1.02217,0.004205,0.4973}, /*cmy*/
          {6.027563,3.0693,0.8661,4.2869}, /*cfy*/
          {1.4383,0.13934,670.3787,2.45476,0.007024,2.9041}, /*cmz*/
          {4.21446,2.6365,0.0115,2.4614} /*cfz*/
     },
     {
          2454119.4,
          {6.977,-0.11298,664.6617,2.02234,0.010262,2.9003}, /*cmx*/
          {5.349067,3.8283,0.8737,0.5456}, /*cfx*/
          {-1.2251,0.0159,98.8775,0.898,0.004771,0.3762}, /*cmy*/
          {2.535086,5.6496,2.9347,4.0461}, /*cfy*/
          {5.5889,0.09298,670.2088,2.09585,0.011491,2.9303}, /*cmz*/
          {0.643424,5.3517,2.4047,2.1078} /*cfz*/
     },
     {
          2454149.4,
          {3.5911,-0.13473,667.2968,1.39233,0.015206,2.9266}, /*cmx*/
          {1.80246,0.2867,3.4895,0.2368}, /*cfx*/
          {-0.7488,0.01184,75.9834,0.64313,0.006305,0.2968}, /*cmy*/
          {5.379862,1.9976,5.2601,3.869}, /*cfy*/
          {8.3293,0.02783,670.4807,1.42448,0.015433,2.9289}, /*cmz*/
          {3.378181,1.7817,4.9163,1.8124} /*cfz*/
     },
     {
          2454179.4,
          {-0.4399,-0.11859,668.9566,0.49299,0.017807,3.0072}, /*cmx*/
          {4.574291,3.0176,6.1508,6.2516}, /*cfx*/
          {-0.4117,0.01057,63.0516,0.26023,0.007593,0.2739}, /*cmy*/
          {1.97135,4.68,1.6049,3.6636}, /*cfy*/
          {9.2211,-0.02764,670.0955,0.47243,0.017368,2.9743}, /*cmz*/
          {6.148514,4.5986,1.4544,1.5575} /*cfz*/
     },
     {
          2454209.4,
          {-4.1132,-0.0845,668.8746,0.63954,0.012771,3.11}, /*cmx*/
          {1.105774,2.6802,2.8465,6.0266}, /*cfx*/
          {-0.102,0.01406,62.2918,0.21296,0.005926,0.3159}, /*cmy*/
          {4.798597,4.4753,4.5281,3.3819}, /*cfy*/
          {8.411,-0.05559,670.1775,0.60695,0.014389,3.0473}, /*cmz*/
          {2.681293,4.2332,4.3144,1.3035} /*cfz*/
     },
     {
          2454239.4,
          {-6.761,-0.06133,667.6943,1.41984,0.002126,3.1016}, /*cmx*/
          {3.964927,5.5781,0.3948,5.8192}, /*cfx*/
          {0.3425,0.01785,73.4654,0.57893,0.001183,0.3799}, /*cmy*/
          {1.282825,1.0504,2.0193,3.0907}, /*cfy*/
          {6.6834,-0.07527,670.2931,1.48339,0.001722,3.1359}, /*cmz*/
          {5.540112,0.8281,2.4978,1.0774} /*cfz*/
     },
     {
          2454269.4,
          {-8.6031,-0.03511,665.8691,1.4852,0.013814,3.1057}, /*cmx*/
          {0.55922,2.2189,5.3525,5.5939}, /*cfx*/
          {0.9012,0.01672,91.0694,0.60142,0.004876,0.4686}, /*cmy*/
          {4.059682,3.9859,0.8622,2.7887}, /*cfy*/
          {4.3193,-0.09404,670.1065,1.4658,0.012376,3.2055}, /*cmz*/
          {2.136804,3.7017,0.4747,0.8772} /*cfz*/
     },
     {
          2454299.4,
          {-9.6268,-0.00092,663.3151,0.62829,0.017571,3.1905}, /*cmx*/
          {3.421158,5.0412,1.8923,5.3242}, /*cfx*/
          {1.4063,0.00662,104.5524,0.29044,0.007401,0.5109}, /*cmy*/
          {0.58014,0.4772,3.7834,2.474}, /*cfy*/
          {1.4286,-0.11876,670.5397,0.63092,0.017901,3.2517}, /*cmz*/
          {4.998917,0.3251,3.4704,0.633} /*cfz*/
     },
     {
          2454329.4,
          {-9.6122,0.05236,663.2213,0.45431,0.015845,3.2461}, /*cmx*/
          {6.239265,4.747,4.6721,5.0133}, /*cfx*/
          {1.5959,-0.00763,106.6338,0.17474,0.006739,0.4971}, /*cmy*/
          {3.381231,0.6411,0.2063,2.1598}, /*cfy*/
          {-2.1486,-0.1233,670.1724,0.45866,0.01637,3.2812}, /*cmz*/
          {1.533349,0.021,6.1517,0.3096} /*cfz*/
     },
     {
          2454359.4,
          {-8.0675,0.11138,664.6429,1.39896,0.012328,3.2328}, /*cmx*/
          {2.727682,1.2365,0.9145,4.6648}, /*cfx*/
          {1.3492,-0.01663,95.7765,0.56886,0.005611,0.417}, /*cmy*/
          {6.176374,3.1483,2.5949,1.8654}, /*cfy*/
          {-5.8625,-0.09666,670.4385,1.45509,0.011544,3.2388}, /*cmz*/
          {4.30467,2.7358,2.5358,6.2272} /*cfz*/
     },
     {
          2454389.4,
          {-4.7569,0.15034,667.4776,2.11642,0.007517,3.1852}, /*cmx*/
          {5.463069,3.9413,3.226,4.2746}, /*cfx*/
          {0.8368,-0.01522,74.3898,0.87906,0.004811,0.2856}, /*cmy*/
          {2.710271,5.7516,4.7839,1.6051}, /*cfy*/
          {-8.8459,-0.03324,670.5243,2.11438,0.00836,3.2514}, /*cmz*/
          {0.754381,5.4663,4.9694,5.8679} /*cfz*/
     },
     {
          2454419.4,
          {-0.1488,0.14871,670.056,2.51067,0.006073,3.2055}, /*cmx*/
          {1.890557,0.3425,5.3987,3.8833}, /*cfx*/
          {0.3782,-0.00264,46.5636,1.07315,0.004767,0.1507}, /*cmy*/
          {5.662831,2.0517,0.6848,1.6871}, /*cfy*/
          {-9.9689,0.0425,670.1818,2.55986,0.006478,3.1803}, /*cmz*/
          {3.4638,1.908,0.6249,5.4654} /*cfz*/
     },
     {
          2454449.4,
          {4.5277,0.10935,670.9382,2.63021,0.006562,3.1729}, /*cmx*/
          {4.588698,3.0199,1.2283,3.4955}, /*cfx*/
          {0.3071,0.00989,26.6822,1.16526,0.004562,0.1437}, /*cmy*/
          {2.968264,4.6186,2.8652,2.5332}, /*cfy*/
          {-8.6671,0.10684,670.6792,2.69945,0.004935,3.0938}, /*cmz*/
          {6.160038,4.5823,2.6441,5.051} /*cfz*/
     },
     {
          2454479.4,
          {7.8809,0.04808,670.048,2.58993,0.008268,2.9955}, /*cmx*/
          {1.003396,5.6865,3.1997,3.1173}, /*cfx*/
          {0.6275,0.01282,44.2441,1.14473,0.00434,0.2579}, /*cmy*/
          {0.387065,0.9034,4.9742,2.6794}, /*cfy*/
          {-5.2808,0.14379,670.5168,2.59902,0.006778,3.0555}, /*cmz*/
          {2.571759,0.9988,4.8313,4.6745} /*cfz*/
     },
     {
          2454509.4,
          {9.226,-0.02579,667.4982,2.20964,0.0094,2.9483}, /*cmx*/
          {3.708922,2.07,5.4881,2.7668}, /*cfx*/
          {1.0206,0.00432,74.7617,1.00441,0.004659,0.391}, /*cmy*/
          {3.376725,3.5018,0.8276,2.5103}, /*cfy*/
          {-0.8464,0.14777,670.5524,2.28143,0.010413,2.9927}, /*cmz*/
          {5.276403,3.7023,0.8311,4.3338} /*cfz*/
     },
     {
          2454539.4,
          {8.3619,-0.08374,663.6184,1.65946,0.014259,2.9375}, /*cmx*/
          {0.152487,4.7912,1.7375,2.4389}, /*cfx*/
          {1.1441,-0.01075,101.0499,0.76097,0.006176,0.4915}, /*cmy*/
          {6.20474,6.1486,3.0864,2.235}, /*cfy*/
          {3.5638,0.11221,670.7945,1.71145,0.014837,2.9353}, /*cmz*/
          {1.718285,0.1303,3.3044,4.0131} /*cfz*/
     },
     {
          2454569.4,
          {5.8558,-0.11323,661.0375,0.80021,0.017106,2.8804}, /*cmx*/
          {2.910251,1.2328,4.3877,2.1682}, /*cfx*/
          {0.818,-0.02083,118.3055,0.3904,0.007463,0.5295}, /*cmy*/
          {2.723693,2.6226,5.6512,1.9934}, /*cfy*/
          {6.914,0.05778,670.5547,0.81036,0.017669,2.923}, /*cmz*/
          {4.475152,2.9164,6.079,3.7174} /*cfz*/
     },
     {
          2454599.4,
          {2.5207,-0.11117,659.6796,0.27585,0.015342,2.8384}, /*cmx*/
          {5.710617,0.8627,0.9923,1.9357}, /*cfx*/
          {0.1885,-0.02033,123.3554,0.0904,0.007148,0.5152}, /*cmy*/
          {5.538768,1.533,2.2627,1.7601}, /*cfy*/
          {8.6746,0.00959,670.7487,0.25797,0.016561,2.9404}, /*cmz*/
          {0.993029,2.5745,2.5679,3.4977} /*cfz*/
     },
     {
          2454629.4,
          {-0.8338,-0.09563,661.4081,1.22919,0.006546,2.8931}, /*cmx*/
          {2.274415,3.7741,4.0443,1.7399}, /*cfx*/
          {-0.4312,-0.01245,115.398,0.51948,0.003154,0.4731}, /*cmy*/
          {2.094613,4.9715,5.5513,1.5347}, /*cfy*/
          {9.0593,-0.02738,670.8507,1.32897,0.004486,2.9993}, /*cmz*/
          {3.839193,5.4194,5.735,3.3086} /*cfz*/
     },
     {
          2454659.4,
          {-3.8018,-0.08427,664.1988,1.56431,0.009452,3.0153}, /*cmx*/
          {5.151001,0.3854,3.4169,1.5231}, /*cfx*/
          {-0.8137,-0.00446,97.883,0.68435,0.003886,0.3976}, /*cmy*/
          {4.940535,1.6909,4.5946,1.2895}, /*cfy*/
          {8.3002,-0.05233,670.531,1.58127,0.009167,3.0043}, /*cmz*/
          {0.434819,1.9995,5.0012,3.1194} /*cfz*/
     },
     {
          2454689.4,
          {-6.4386,-0.06979,666.3306,0.96464,0.018173,3.0546}, /*cmx*/
          {1.738891,3.252,0.0994,1.3176}, /*cfx*/
          {-0.9489,-0.00273,80.8655,0.44003,0.007642,0.3514}, /*cmy*/
          {1.484113,4.6329,1.4919,1.0525}, /*cfy*/
          {6.6777,-0.08679,670.9512,0.99437,0.019107,3.0528}, /*cmz*/
          {3.305994,4.9003,1.7542,2.8754} /*cfz*/
     },
     {
          2454719.4,
          {-8.5415,-0.03786,667.2661,0.17177,0.017465,3.0908}, /*cmx*/
          {4.571097,2.9553,2.9432,1.0446}, /*cfx*/
          {-1.0201,-0.00453,74.5914,0.03296,0.007815,0.3599}, /*cmy*/
          {4.296933,4.5808,4.2853,0.7881}, /*cfy*/
          {3.9875,-0.12291,670.4927,0.17109,0.017849,3.1431}, /*cmz*/
          {6.138719,4.7046,4.5134,2.599} /*cfz*/
     },
     {
          2454749.4,
          {-9.6331,0.02187,666.1394,1.21817,0.013814,3.1756}, /*cmx*/
          {1.070188,5.7495,5.5043,0.6881}, /*cfx*/
          {-1.1602,-0.00277,82.4998,0.5019,0.006063,0.4397}, /*cmy*/
          {0.828521,0.8529,0.4644,0.4768}, /*cfy*/
          {0.3008,-0.14522,670.8702,1.25216,0.013606,3.2267}, /*cmz*/
          {2.63774,1.0688,0.9061,2.2811} /*cfz*/
     },
     {
          2454779.4,
          {-8.9964,0.09425,663.2625,2.04534,0.008784,3.2149}, /*cmx*/
          {3.811175,2.1896,1.5502,0.3106}, /*cfx*/
          {-1.2762,0.00839,102.5528,0.8563,0.004575,0.5617}, /*cmy*/
          {3.626823,3.4974,2.6543,0.1666}, /*cfy*/
          {-4.039,-0.12345,670.6684,2.05707,0.009264,3.233}, /*cmz*/
          {5.377333,3.814,3.3228,1.8863} /*cfz*/
     },
     {
          2454809.4,
          {-6.2332,0.14459,658.5689,2.48817,0.00673,3.193}, /*cmx*/
          {0.238823,4.8682,3.8403,6.2077}, /*cfx*/
          {-1.0547,0.02572,130.4921,1.05542,0.004524,0.7115}, /*cmy*/
          {0.105171,6.1049,4.766,6.1033}, /*cfy*/
          {-7.8244,-0.06596,670.7754,2.55135,0.006483,3.2217}, /*cmz*/
          {1.804871,0.2376,5.4907,1.4762} /*cfz*/
     },
     {
          2454839.4,
          {-1.8303,0.1525,651.3598,2.70175,0.006426,3.115}, /*cmx*/
          {2.934244,1.2742,5.8146,5.8013}, /*cfx*/
          {-0.2661,0.04071,161.0124,1.14932,0.004852,0.8428}, /*cmy*/
          {2.838508,2.3984,0.5896,5.7193}, /*cfy*/
          {-9.9151,0.01418,670.9171,2.79105,0.005522,3.2615}, /*cmz*/
          {4.499737,2.9273,1.1232,1.0731} /*cfz*/
     },
     {
          2454869.4,
          {2.8844,0.12445,643.7254,2.65184,0.006399,3.0666}, /*cmx*/
          {5.624521,3.9421,1.5935,5.3867}, /*cfx*/
          {1.007,0.0435,190.3608,1.116,0.004449,0.971}, /*cmy*/
          {5.557478,4.9549,2.8263,5.3324}, /*cfy*/
          {-9.5184,0.08538,670.9796,2.72263,0.006153,3.2422}, /*cmz*/
          {0.906585,5.6132,3.3402,0.6713} /*cfz*/
     },
     {
          2454899.4,
          {6.7055,0.06612,635.6717,2.40847,0.009445,2.9958}, /*cmx*/
          {2.037609,0.352,3.8167,4.9961}, /*cfx*/
          {2.3634,0.02957,215.2598,0.99809,0.004352,1.0677}, /*cmy*/
          {1.992484,1.243,4.9303,4.9634}, /*cfy*/
          {-6.818,0.13179,670.8826,2.50295,0.009746,3.1422}, /*cmz*/
          {3.604062,2.0328,5.5452,0.2788} /*cfz*/
     },
     {
          2454929.4,
          {8.6287,0.00505,628.8899,1.8936,0.012094,2.8663}, /*cmx*/
          {4.750208,3.0671,0.0547,4.6562}, /*cfx*/
          {3.2416,0.00745,234.1291,0.78296,0.005319,1.1023}, /*cmy*/
          {4.722582,3.8769,0.9077,4.6349}, /*cfy*/
          {-2.7415,0.14539,671.1026,1.96602,0.012241,3.1046}, /*cmz*/
          {0.034237,4.7406,1.7546,6.2079} /*cfz*/
     },
     {
          2454959.4,
          {8.6509,-0.05128,624.2652,1.17393,0.015965,2.802}, /*cmx*/
          {1.207577,5.7982,2.6537,4.3237}, /*cfx*/
          {3.4186,-0.01785,246.4969,0.4683,0.00672,1.1235}, /*cmy*/
          {1.193956,0.2939,3.3223,4.3164}, /*cfy*/
          {1.6103,0.12296,670.8182,1.22765,0.017232,3.0785}, /*cmz*/
          {2.776585,1.2063,4.3601,5.9154} /*cfz*/
     },
     {
          2454989.4,
          {7.1114,-0.08334,621.8305,0.18665,0.01688,2.7921}, /*cmx*/
          {3.987825,2.3242,5.5059,4.0462}, /*cfx*/
          {2.8809,-0.03384,251.9728,0.07609,0.007311,1.1303}, /*cmy*/
          {3.984152,3.9035,6.1663,4.0451}, /*cfy*/
          {5.203,0.08139,671.275,0.18766,0.018086,2.9888}, /*cmz*/
          {5.558301,3.8819,0.8241,5.6536} /*cfz*/
     },
     {
          2455019.4,
          {4.6993,-0.09305,622.3854,0.85197,0.011347,2.779}, /*cmx*/
          {0.533632,2.0094,2.1043,3.853}, /*cfx*/
          {1.8908,-0.03821,250.6481,0.40536,0.004603,1.1039}, /*cmy*/
          {0.535183,2.5301,2.966,3.8517}, /*cfy*/
          {7.6076,0.03746,670.7555,0.95283,0.011136,2.8854}, /*cmz*/
          {2.104095,3.6425,3.8603,5.4141} /*cfz*/
     },
     {
          2455049.4,
          {1.9672,-0.09362,625.6957,1.55896,0.004811,2.7351}, /*cmx*/
          {3.402924,4.8995,1.5653,3.6751}, /*cfx*/
          {0.7664,-0.03683,242.94,0.68602,0.003065,1.0297}, /*cmy*/
          {3.404276,5.5532,1.7786,3.6742}, /*cfy*/
          {8.812,0.00206,671.0947,1.62882,0.004755,2.9186}, /*cmz*/
          {4.974521,0.2658,3.0734,5.2491} /*cfz*/
     },
     {
          2455079.4,
          {-0.8912,-0.09634,629.4185,1.24409,0.015618,2.7759}, /*cmx*/
          {0.000863,1.4709,4.6041,3.4823}, /*cfx*/
          {-0.3509,-0.03404,232.1322,0.531,0.006964,1.0074}, /*cmy*/
          {6.280496,2.2845,5.3438,3.4737}, /*cfy*/
          {8.9598,-0.02922,671.0514,1.32002,0.017169,2.9476}, /*cmz*/
          {1.570911,3.149,6.2744,5.0392} /*cfz*/
     },
     {
          2455109.4,
          {-3.8782,-0.09167,632.1114,0.26056,0.019464,2.818}, /*cmx*/
          {2.85037,4.3232,1.1781,3.2212}, /*cfx*/
          {-1.4032,-0.03326,225.5468,0.1045,0.008168,1.0072}, /*cmy*/
          {2.841191,5.3704,1.9588,3.2115}, /*cfy*/
          {8.0474,-0.07077,671.0074,0.24703,0.019691,2.9644}, /*cmz*/
          {4.420526,5.9843,2.8384,4.7997} /*cfz*/
     },
     {
          2455139.4,
          {-6.6706,-0.063,630.9979,0.90506,0.014552,2.8503}, /*cmx*/
          {5.649199,4.0144,3.8398,2.9273}, /*cfx*/
          {-2.41,-0.02768,227.5552,0.3959,0.006143,1.0482}, /*cmy*/
          {5.638094,4.7434,4.543,2.9168}, /*cfy*/
          {5.8333,-0.12062,671.051,0.95866,0.015388,2.9921}, /*cmz*/
          {0.935641,5.6588,5.5425,4.4939} /*cfz*/
     },
     {
          2455169.4,
          {-8.486,-0.00605,627.5399,1.7784,0.010262,2.8787}, /*cmx*/
          {2.116107,0.4539,0.1118,2.5897}, /*cfx*/
          {-3.2195,-0.00959,237.9059,0.76426,0.004889,1.1285}, /*cmy*/
          {2.108776,1.1747,0.4989,2.5906}, /*cfy*/
          {2.1668,-0.15058,670.9093,1.88246,0.010991,3.0951}, /*cmz*/
          {3.685845,2.1283,1.6956,4.1405} /*cfz*/
     },
     {
          2455199.4,
          {-8.6366,0.06984,621.7258,2.34242,0.006353,2.8729}, /*cmx*/
          {4.830871,3.1754,2.355,2.1867}, /*cfx*/
          {-3.5135,0.02128,252.3124,1.00486,0.004316,1.2073}, /*cmy*/
          {4.831886,3.8029,2.5979,2.1937}, /*cfy*/
          {-2.3299,-0.14422,670.8881,2.50348,0.006842,3.215}, /*cmz*/
          {0.118905,4.8369,3.9314,3.7583} /*cfz*/
     },
     {
          2455229.4,
          {-6.578,0.12518,615.6678,2.61384,0.004775,2.9183}, /*cmx*/
          {1.241902,5.8761,4.3311,1.7681}, /*cfx*/
          {-2.8986,0.04985,266.9603,1.11932,0.004305,1.2996}, /*cmy*/
          {1.254265,0.1062,4.7483,1.7859}, /*cfy*/
          {-6.6627,-0.08947,671.1037,2.77683,0.00585,3.1828}, /*cmz*/
          {2.814377,1.2414,6.1022,3.3619} /*cfz*/
     },
     {
          2455259.4,
          {-2.7923,0.14623,610.339,2.65057,0.005619,2.9335}, /*cmx*/
          {3.92757,2.2976,0.0433,1.3757}, /*cfx*/
          {-1.3914,0.06565,278.96,1.13882,0.004368,1.3653}, /*cmy*/
          {3.953327,2.684,0.6214,1.4085}, /*cfy*/
          {-9.4616,-0.01121,670.8469,2.84324,0.006699,3.1875}, /*cmz*/
          {5.502745,3.9321,1.7676,2.9493} /*cfz*/
     },
     {
          2455289.4,
          {1.7236,0.12681,606.5951,2.45512,0.007092,2.9046}, /*cmx*/
          {0.332293,5.0069,2.4035,0.982}, /*cfx*/
          {0.6403,0.06084,286.9784,1.04263,0.004441,1.3886}, /*cmy*/
          {0.37231,5.2722,2.9179,1.0309}, /*cfy*/
          {-9.8087,0.06159,671.0602,2.63525,0.007214,3.264}, /*cmz*/
          {1.910618,0.3316,4.0593,2.5491} /*cfz*/
     },
     {
          2455319.4,
          {5.6298,0.08313,604.851,2.11053,0.010592,2.931}, /*cmx*/
          {3.033633,1.434,4.6946,0.5788}, /*cfx*/
          {2.5201,0.04216,291.0511,0.87643,0.005104,1.414}, /*cmy*/
          {3.088313,1.5827,4.9934,0.6402}, /*cfy*/
          {-7.8345,0.11562,670.8747,2.25771,0.011082,3.2245}, /*cmz*/
          {4.614517,3.0361,0.1158,2.1747} /*cfz*/
     },
     {
          2455349.4,
          {8.0707,0.02736,604.546,1.4889,0.013253,2.8862}, /*cmx*/
          {5.757669,4.1779,1.0776,0.234}, /*cfx*/
          {3.7644,0.01688,292.0849,0.58676,0.005938,1.3918}, /*cmy*/
          {5.826386,4.2341,1.1744,0.3076}, /*cfy*/
          {-4.2108,0.134,670.7116,1.63818,0.01594,3.1595}, /*cmz*/
          {1.058906,5.7661,2.6918,1.8241} /*cfz*/
     },
     {
          2455379.4,
          {8.756,-0.02248,604.4011,0.65488,0.017096,2.8463}, /*cmx*/
          {2.234183,0.7117,3.8501,6.2324}, /*cfx*/
          {4.2059,-0.00607,291.5439,0.21282,0.007411,1.3743}, /*cmy*/
          {2.315056,0.7278,3.8574,0.0337}, /*cfy*/
          {-0.1496,0.12442,670.8228,0.6904,0.018588,3.1323}, /*cmz*/
          {3.820354,2.219,5.3525,1.5142} /*cfz*/
     },
     {
          2455409.4,
          {8.0007,-0.0578,604.9356,0.39578,0.014586,2.7942}, /*cmx*/
          {5.040549,0.3601,0.3647,5.9745}, /*cfx*/
          {3.9842,-0.02373,291.7474,0.24262,0.005857,1.351}, /*cmy*/
          {5.129312,0.3505,0.4277,6.0659}, /*cfy*/
          {3.4976,0.09293,670.5338,0.47709,0.015493,3.1137}, /*cmz*/
          {0.344458,1.8947,1.9911,1.2682} /*cfz*/
     },
     {
          2455439.4,
          {6.3099,-0.07493,604.2625,1.33886,0.003222,2.7054}, /*cmx*/
          {1.611473,3.1737,3.9142,5.7475}, /*cfx*/
          {3.2921,-0.03433,292.2545,0.62425,0.001734,1.3095}, /*cmy*/
          {1.7019,3.2121,4.6733,5.8385}, /*cfy*/
          {6.2008,0.06044,670.6211,1.44374,0.003481,3.0731}, /*cmz*/
          {3.199893,4.7763,5.1006,1.0631} /*cfz*/
     },
     {
          2455469.4,
          {4.1306,-0.09091,604.4064,1.46531,0.012118,2.7018}, /*cmx*/
          {4.494808,6.0754,2.8977,5.5664}, /*cfx*/
          {2.2948,-0.04401,292.6218,0.62832,0.005953,1.3066}, /*cmy*/
          {4.580003,6.1983,2.971,5.6447}, /*cfy*/
          {8.0737,0.02801,670.715,1.61587,0.014281,2.9437}, /*cmz*/
          {6.081226,1.381,4.475,0.869} /*cfz*/
     },
     {
          2455499.4,
          {1.3634,-0.10229,604.5996,0.69739,0.01887,2.6872}, /*cmx*/
          {1.079163,2.6385,5.775,5.355}, /*cfx*/
          {0.9575,-0.05027,291.8343,0.25477,0.008395,1.2974}, /*cmy*/
          {1.155924,2.8273,5.9372,5.4274}, /*cfy*/
          {9.0243,-0.00373,670.568,0.7113,0.019722,2.9527}, /*cmz*/
          {2.664999,4.2216,1.0932,0.6387} /*cfz*/
     },
     {
          2455529.4,
          {-1.8661,-0.10496,604.4739,0.47207,0.016189,2.6603}, /*cmx*/
          {3.899506,2.3494,2.2405,5.0699}, /*cfx*/
          {-0.6288,-0.0524,291.5431,0.26658,0.006892,1.2859}, /*cmy*/
          {3.97001,2.4932,2.3465,5.1398}, /*cfy*/
          {8.8813,-0.0527,670.8762,0.50464,0.01894,2.988}, /*cmz*/
          {5.483377,3.9361,3.8427,0.3551} /*cfz*/
     },
     {
          2455559.4,
          {-5.0796,-0.0838,604.3941,1.45084,0.011167,2.6368}, /*cmx*/
          {0.382446,5.0784,4.9485,4.7204}, /*cfx*/
          {-2.2366,-0.04366,292.3736,0.68282,0.004827,1.2747}, /*cmy*/
          {0.451942,5.203,4.7957,4.7952}, /*cfy*/
          {7.1788,-0.11002,670.5766,1.60523,0.012365,3.0019}, /*cmz*/
          {1.966502,0.4156,0.08,0.0413} /*cfz*/
     },
     {
          2451179.4,
          {2.6629,0.00834,966.6214,2.65103,0.015009,0.9696}, /*cmx*/
          {3.399963,1.8171,1.4893,1.6107}, /*cfx*/
          {1.2008,0.00569,460.5835,1.23113,0.007127,0.4649}, /*cmy*/
          {3.470471,2.0087,1.2824,1.6938}, /*cfy*/
          {-1.9041,0.03768,1069.7669,2.91324,0.016889,1.121}, /*cmz*/
          {4.983914,3.4316,2.9779,3.2043} /*cfz*/
     },
     {
          2451219.4,
          {2.7855,0.01169,965.6427,3.8072,0.008177,0.9512}, /*cmx*/
          {0.695905,5.416,4.397,2.7348}, /*cfx*/
          {1.3078,0.00586,462.8025,1.70791,0.006604,0.4501}, /*cmy*/
          {0.774021,5.475,3.969,2.8276}, /*cfy*/
          {-0.9505,0.03372,1069.7503,4.14419,0.010575,1.1117}, /*cmz*/
          {2.281114,0.7148,5.9057,4.3483} /*cfz*/
     },
     {
          2451259.4,
          {2.6751,0.00501,968.7317,4.21359,0.007736,0.93}, /*cmx*/
          {4.243357,2.7072,0.763,3.8157}, /*cfx*/
          {1.2752,0.00166,456.6554,1.83425,0.007259,0.426}, /*cmy*/
          {4.335351,2.5975,0.6284,3.9165}, /*cfy*/
          {0.4171,0.01387,1069.7655,4.57538,0.009302,1.0637}, /*cmz*/
          {5.83065,4.2537,2.3393,5.4506} /*cfz*/
     },
     {
          2451299.4,
          {2.5923,-0.0183,976.8912,4.01075,0.010246,0.8483}, /*cmx*/
          {1.503428,6.2743,3.7081,4.9916}, /*cfx*/
          {1.2298,-0.00978,439.8093,1.68038,0.007006,0.3713}, /*cmy*/
          {1.6135,5.9771,3.6466,5.1082}, /*cfy*/
          {1.5815,-0.00552,1069.6295,4.37574,0.01256,0.9481}, /*cmz*/
          {3.092924,1.5109,5.2036,0.2953} /*cfz*/
     },
     {
          2451339.4,
          {2.1797,-0.02711,987.8925,3.33429,0.017907,0.7699}, /*cmx*/
          {5.066935,3.564,0.5382,6.1117}, /*cfx*/
          {1.0046,-0.01219,415.6216,1.34001,0.00833,0.3153}, /*cmy*/
          {5.197779,3.0861,0.2378,6.2625}, /*cfy*/
          {1.8787,-0.00711,1069.0724,3.57966,0.020012,0.8034}, /*cmz*/
          {0.374171,5.0783,2.1067,1.4275} /*cfz*/
     },
     {
          2451379.4,
          {1.6651,-0.01967,997.3563,1.91927,0.02709,0.6381}, /*cmx*/
          {2.390973,0.901,4.0429,0.8217}, /*cfx*/
          {0.729,-0.00777,392.9387,0.72501,0.011101,0.2412}, /*cmy*/
          {2.542637,0.2539,3.4814,0.9651}, /*cfy*/
          {1.4645,0.00306,1069.0217,2.00423,0.028389,0.6583}, /*cmz*/
          {3.981841,2.3913,5.5391,2.4932} /*cfz*/
     },
     {
          2451419.4,
          {0.9963,0.00952,1000.6227,0.37419,0.024466,0.5047}, /*cmx*/
          {6.069511,1.3691,1.5111,1.8324}, /*cfx*/
          {0.4482,0.00324,384.3485,0.21692,0.009329,0.1891}, /*cmy*/
          {6.234943,1.0335,0.9492,1.9616}, /*cfy*/
          {0.8799,0.00284,1068.6573,0.44481,0.025687,0.4989}, /*cmz*/
          {1.378012,2.9139,2.9993,3.472} /*cfz*/
     },
     {
          2451459.4,
          {0.8685,0.01689,995.9535,2.45077,0.005145,0.4277}, /*cmx*/
          {3.550872,5.2141,1.5852,2.7552}, /*cfx*/
          {0.3622,0.00716,396.6482,1.01017,0.003093,0.1812}, /*cmy*/
          {3.713599,4.7114,1.1371,2.8993}, /*cfy*/
          {0.834,-0.02594,1068.7298,2.62362,0.00512,0.4229}, /*cmz*/
          {5.143848,0.4416,3.2083,4.4759} /*cfz*/
     },
     {
          2451499.4,
          {1.3024,0.00919,988.1993,1.95715,0.029521,0.488}, /*cmx*/
          {1.069522,2.7394,5.8741,3.6368}, /*cfx*/
          {0.5698,0.00259,415.4282,0.73133,0.012483,0.2053}, /*cmy*/
          {1.216526,2.2875,5.4916,3.7792}, /*cfy*/
          {0.3818,-0.02684,1068.9748,2.03758,0.030988,0.5348}, /*cmz*/
          {2.662563,4.2447,1.1016,5.2706} /*cfz*/
     },
     {
          2451539.4,
          {2.0077,-0.00176,985.3225,0.48922,0.026033,0.6633}, /*cmx*/
          {4.813234,3.3517,3.2671,4.7655}, /*cfx*/
          {0.8383,-0.00125,421.077,0.31248,0.010546,0.2795}, /*cmy*/
          {4.947016,3.1577,2.768,4.8846}, /*cfy*/
          {-0.1983,-0.00431,1068.7501,0.57932,0.027842,0.697}, /*cmz*/
          {0.121402,4.947,4.7375,0.0417} /*cfz*/
     },
     {
          2451579.4,
          {2.514,0.00127,990.0634,2.59987,0.015402,0.8488}, /*cmx*/
          {2.18104,0.7063,0.3477,5.8349}, /*cfx*/
          {1.0182,-0.00057,409.5058,1.15768,0.007211,0.3426}, /*cmy*/
          {2.313267,0.2948,5.6942,5.9689}, /*cfy*/
          {-0.5933,0.02973,1069.0296,2.81231,0.016841,0.8844}, /*cmz*/
          {3.770915,2.2166,1.805,1.1297} /*cfz*/
     },
     {
          2451619.4,
          {2.6156,0.01138,1001.4198,3.78229,0.009912,0.9446}, /*cmx*/
          {5.766016,4.3005,3.2871,0.656}, /*cfx*/
          {0.9759,0.00301,380.8594,1.59404,0.007568,0.3373}, /*cmy*/
          {5.909039,3.7098,2.2284,0.8127}, /*cfy*/
          {-0.031,0.03552,1069.2383,4.04838,0.010016,0.9871}, /*cmz*/
          {1.071572,5.7838,4.7626,2.1698} /*cfz*/
     },
     {
          2451659.4,
          {2.533,0.00888,1017.464,4.24697,0.008821,1.0595}, /*cmx*/
          {3.037201,1.57,6.0667,1.758}, /*cfx*/
          {0.9096,-0.00108,336.2693,1.74767,0.007792,0.3146}, /*cmy*/
          {3.20308,0.7749,5.2516,1.9231}, /*cfy*/
          {1.1265,0.02384,1069.0953,4.52813,0.009247,1.0823}, /*cmz*/
          {4.624398,3.0487,1.104,3.2825} /*cfz*/
     },
     {
          2451699.4,
          {2.3613,-0.01171,1034.7486,4.13489,0.010916,1.0623}, /*cmx*/
          {0.304,5.1047,2.6048,2.8888}, /*cfx*/
          {0.7334,-0.00503,280.1509,1.70658,0.007074,0.2653}, /*cmy*/
          {0.507729,4.1051,1.9195,3.111}, /*cfy*/
          {2.4895,-0.00104,1068.9438,4.33198,0.011982,1.0851}, /*cmz*/
          {1.888501,0.3126,4.0797,4.4645} /*cfz*/
     },
     {
          2451739.4,
          {1.9844,-0.02926,1048.7385,3.48747,0.018692,1.0588}, /*cmx*/
          {3.871603,2.373,5.6897,4.0572}, /*cfx*/
          {0.5896,-0.00856,221.7679,1.45169,0.007981,0.1989}, /*cmy*/
          {4.13398,1.1963,4.7196,4.392}, /*cfy*/
          {3.0674,-0.0055,1068.9451,3.57291,0.018494,1.0824}, /*cmz*/
          {5.452896,3.8706,0.9048,5.6201} /*cfz*/
     },
     {
          2451779.4,
          {1.3823,-0.02982,1057.3566,2.04936,0.027939,0.9896}, /*cmx*/
          {1.196503,5.9703,2.8382,5.2251}, /*cfx*/
          {0.3551,-0.00398,175.8291,0.87466,0.011496,0.1508}, /*cmy*/
          {1.534714,4.6551,1.5714,5.5792}, /*cfy*/
          {2.9762,-0.00044,1069.0371,2.10169,0.028607,1.0321}, /*cmz*/
          {2.775748,1.1808,4.323,0.4987} /*cfz*/
     },
     {
          2451819.4,
          {0.6074,-0.00407,1059.9346,0.33675,0.025722,0.8307}, /*cmx*/
          {4.873155,0.1017,0.2922,0.1841}, /*cfx*/
          {0.2192,-0.00034,159.1694,0.11106,0.010747,0.1281}, /*cmy*/
          {5.255329,5.3683,5.2764,0.5425}, /*cfy*/
          {2.4268,0.00656,1068.782,0.3213,0.027035,0.8871}, /*cmz*/
          {0.168713,1.7126,1.7798,1.7348} /*cfz*/
     },
     {
          2451859.4,
          {-0.0035,0.02276,1056.8069,2.5475,0.004789,0.6396}, /*cmx*/
          {2.352072,4.0026,0.3221,1.4697}, /*cfx*/
          {0.0763,0.00606,180.1334,1.03451,0.002169,0.1423}, /*cmy*/
          {2.689003,2.7547,5.236,1.8494}, /*cfy*/
          {2.2828,-0.01742,1068.7493,2.61386,0.004611,0.6772}, /*cmz*/
          {3.931842,5.5054,1.7431,3.0037} /*cfz*/
     },
     {
          2451899.4,
          {0.3675,0.01258,1049.7435,2.06325,0.029592,0.5194}, /*cmx*/
          {6.153364,1.5523,4.6914,2.5105}, /*cfx*/
          {0.1966,0.00074,218.0874,0.82087,0.011863,0.11}, /*cmy*/
          {0.138333,0.3229,3.5626,2.751}, /*cfy*/
          {1.9895,-0.02688,1068.7761,2.13312,0.030867,0.5287}, /*cmz*/
          {1.451566,3.0277,6.1614,4.0368} /*cfz*/
     },
     {
          2451939.4,
          {0.9803,-0.00178,1046.0453,0.43487,0.026329,0.4787}, /*cmx*/
          {3.615893,2.2056,2.0604,3.3367}, /*cfx*/
          {0.2917,-0.00174,232.0928,0.21801,0.011129,0.0998}, /*cmy*/
          {3.854093,1.5627,0.8554,3.5701}, /*cfy*/
          {1.4557,-0.01658,1068.8221,0.43487,0.028012,0.5138}, /*cmz*/
          {5.197229,3.7307,3.5541,4.9347} /*cfz*/
     },
     {
          2451979.4,
          {1.5456,-0.00701,1050.6816,2.58504,0.016132,0.5768}, /*cmx*/
          {0.988881,5.8032,5.3539,4.0939}, /*cfx*/
          {0.3425,-0.00292,209.0667,1.07976,0.008288,0.1062}, /*cmy*/
          {1.240955,4.7081,3.8973,4.399}, /*cfy*/
          {0.849,0.01146,1069.1134,2.66707,0.016176,0.6066}, /*cmz*/
          {2.568787,1.0094,0.6475,5.6908} /*cfz*/
     },
     {
          2452019.4,
          {1.6142,0.00809,1059.8868,3.76348,0.01123,0.7421}, /*cmx*/
          {4.581039,3.0797,2.0504,4.9102}, /*cfx*/
          {0.2548,-1e-05,156.8763,1.61614,0.007547,0.0734}, /*cmy*/
          {4.905469,1.8202,0.4919,5.36}, /*cfy*/
          {0.7475,0.03057,1069.2331,3.90588,0.009631,0.7163}, /*cmz*/
          {6.158619,4.5917,3.5558,0.2918} /*cfz*/
     },
     {
          2452059.4,
          {1.5808,0.00995,1067.8118,4.26835,0.009699,0.914}, /*cmx*/
          {1.859765,0.3165,4.7746,5.9572}, /*cfx*/
          {0.1866,-0.00238,89.4305,1.85947,0.007378,0.046}, /*cmy*/
          {2.422796,5.1942,3.4294,0.5759}, /*cfy*/
          {1.4677,0.0265,1069.1375,4.36445,0.009036,0.9037}, /*cmz*/
          {3.433821,1.8651,0.0096,1.3268} /*cfz*/
     },
     {
          2452099.4,
          {1.343,-0.00085,1070.5697,4.16052,0.012106,1.0104}, /*cmx*/
          {5.415509,3.8318,1.3516,0.8045}, /*cfx*/
          {0.1071,-0.00206,45.2709,1.83683,0.007072,0.0558}, /*cmy*/
          {0.795069,2.2889,0.025,3.0549}, /*cfy*/
          {2.6589,0.00405,1069.419,4.21443,0.011042,1.0042}, /*cmz*/
          {0.702801,5.4092,2.8847,2.3926} /*cfz*/
     },
     {
          2452139.4,
          {1.155,-0.026,1067.5875,3.44969,0.018498,1.1241}, /*cmx*/
          {2.702873,1.0872,4.4403,1.9523}, /*cfx*/
          {0.0546,0.00039,87.7509,1.5362,0.008442,0.1283}, /*cmy*/
          {5.344301,5.7039,2.8372,4.753}, /*cfy*/
          {3.4486,-0.00584,1069.7501,3.50678,0.018323,1.1186}, /*cmz*/
          {4.270809,2.6842,5.9699,3.5525} /*cfz*/
     },
     {
          2452179.4,
          {0.6074,-0.03176,1062.5547,1.99677,0.027869,1.1815}, /*cmx*/
          {0.029683,4.6699,1.538,3.1703}, /*cfx*/
          {0.0396,0.00464,134.8372,0.89677,0.012104,0.1572}, /*cmy*/
          {2.875464,2.9407,6.046,6.0744}, /*cfy*/
          {3.581,-0.00265,1069.7246,2.0749,0.029433,1.1753}, /*cmz*/
          {1.596382,0.0106,3.1542,4.7216} /*cfz*/
     },
     {
          2452219.4,
          {-0.1082,-0.01401,1060.366,0.39355,0.025423,1.1563}, /*cmx*/
          {3.70835,5.2184,5.2608,4.4514}, /*cfx*/
          {0.1081,0.00282,151.3788,0.15549,0.011436,0.1511}, /*cmy*/
          {0.315849,2.9779,3.5362,1.1097}, /*cfy*/
          {3.1987,0.00896,1069.5508,0.39809,0.026185,1.0972}, /*cmz*/
          {5.274489,0.4683,0.6305,6.0119} /*cfz*/
     },
     {
          2452259.4,
          {-0.9227,0.02058,1063.3789,2.5753,0.005171,0.9991}, /*cmx*/
          {1.188948,2.7156,5.291,5.7905}, /*cfx*/
          {0.2183,-0.00245,128.2394,1.11315,0.002712,0.1045}, /*cmy*/
          {4.038834,0.9319,3.1414,2.1966}, /*cfy*/
          {2.9386,0.00045,1069.7291,2.63147,0.005464,0.986}, /*cmz*/
          {2.755939,4.3316,0.7146,1.0847} /*cfz*/
     },
     {
          2452299.4,
          {-0.7928,0.01037,1067.505,2.02188,0.028854,0.9098}, /*cmx*/
          {4.989959,0.2592,3.3982,0.7843}, /*cfx*/
          {0.1721,-0.00239,87.0912,0.91788,0.012619,0.0648}, /*cmy*/
          {1.413366,4.8477,1.7253,3.5563}, /*cfy*/
          {3.0622,-0.02379,1069.8089,2.08699,0.030084,0.8729}, /*cmz*/
          {0.274869,1.8622,5.0019,2.3955} /*cfz*/
     },
     {
          2452339.4,
          {-0.4275,-0.00603,1068.3013,0.41263,0.026268,0.765}, /*cmx*/
          {2.451216,0.9949,0.759,1.9619}, /*cfx*/
          {0.1355,-0.00132,71.2514,0.15784,0.011504,0.0603}, /*cmy*/
          {5.062819,5.8161,5.3725,4.7833}, /*cfy*/
          {2.6705,-0.02522,1069.7651,0.41138,0.02671,0.7547}, /*cmz*/
          {4.020143,2.4831,2.4048,3.5515} /*cfz*/
     },
     {
          2452379.4,
          {-0.1125,-0.01163,1066.5407,2.50036,0.016032,0.6184}, /*cmx*/
          {6.10927,4.5226,4.0844,2.9149}, /*cfx*/
          {0.0399,0.00242,93.6794,1.07691,0.007604,0.059}, /*cmy*/
          {2.5947,2.8637,2.1754,5.707}, /*cfy*/
          {1.9468,-0.00875,1069.6721,2.57188,0.015156,0.6015}, /*cmz*/
          {1.394576,6.1231,5.7415,4.4409} /*cfz*/
     },
     {
          2452419.4,
          {-0.0401,0.00248,1060.8387,3.68726,0.009603,0.5105}, /*cmx*/
          {3.422475,1.7919,0.7493,3.6153}, /*cfx*/
          {0.0574,-0.00064,146.1495,1.59166,0.006559,0.0916}, /*cmy*/
          {0.066978,0.0321,4.9423,0.2821}, /*cfy*/
          {1.2231,0.01745,1069.7859,3.73885,0.009777,0.5249}, /*cmz*/
          {4.98943,3.4279,2.4384,5.0978} /*cfz*/
     },
     {
          2452459.4,
          {-0.0588,0.01295,1049.6032,4.13691,0.008769,0.5714}, /*cmx*/
          {0.704505,5.33,3.4411,4.3845}, /*cfx*/
          {0.0306,-0.00221,211.5606,1.76586,0.006662,0.1327}, /*cmy*/
          {3.720065,3.4315,1.5557,1.1772}, /*cfy*/
          {1.319,0.02006,1070.0604,4.19043,0.008018,0.6163}, /*cmz*/
          {2.270255,0.6984,5.2014,5.8464} /*cfz*/
     },
     {
          2452499.4,
          {-0.1187,0.01056,1034.7117,3.99694,0.01152,0.6862}, /*cmx*/
          {4.262374,2.587,0.0191,5.2407}, /*cfx*/
          {0.0923,-0.00411,274.6229,1.68241,0.006647,0.1992}, /*cmy*/
          {1.04428,0.5369,4.4567,2.0069}, /*cfy*/
          {2.0117,0.00779,1070.3434,4.08986,0.010801,0.7337}, /*cmz*/
          {5.828065,4.2468,1.6467,0.4662} /*cfz*/
     },
     {
          2452539.4,
          {-0.0588,-0.01278,1020.0321,3.24619,0.017856,0.8631}, /*cmx*/
          {1.551272,6.1455,3.148,0.0011}, /*cfx*/
          {0.045,0.00451,325.0934,1.3485,0.008004,0.2947}, /*cmy*/
          {4.647673,3.9658,1.0429,3.1079}, /*cfy*/
          {2.8659,-0.00657,1070.3882,3.39207,0.019366,0.9329}, /*cmz*/
          {3.118152,1.5337,4.8043,1.5475} /*cfz*/
     },
     {
          2452579.4,
          {-0.2733,-0.02536,1009.4112,1.80334,0.027643,1.0118}, /*cmx*/
          {5.164388,3.4657,0.3255,1.1332}, /*cfx*/
          {0.1231,0.00901,356.6853,0.71558,0.011542,0.3639}, /*cmy*/
          {1.998223,1.2289,4.2747,4.2579}, /*cfy*/
          {3.1583,-0.00263,1070.1454,1.86654,0.029125,1.0835}, /*cmz*/
          {0.449318,5.1623,2.0288,2.7218} /*cfz*/
     },
     {
          2452619.4,
          {-0.7615,-0.01763,1006.0592,0.53467,0.023704,1.0556}, /*cmx*/
          {2.565605,4.0187,4.092,2.4012}, /*cfx*/
          {0.2848,0.00639,365.3408,0.29233,0.009886,0.3707}, /*cmy*/
          {5.694008,1.3861,1.8611,5.5324}, /*cfy*/
          {3.0275,0.01099,1070.2961,0.62632,0.023787,1.1678}, /*cmz*/
          {4.134597,5.6632,5.7801,4.0101} /*cfz*/
     },
     {
          2452659.4,
          {-1.4075,0.00678,1011.7924,2.52243,0.006503,1.0752}, /*cmx*/
          {0.051561,1.5295,4.343,3.7513}, /*cfx*/
          {0.5403,-0.00491,349.5906,1.10459,0.003976,0.365}, /*cmy*/
          {3.181167,5.4981,1.6796,0.5593}, /*cfy*/
          {2.7945,0.01802,1070.3735,2.66329,0.007471,1.1556}, /*cmz*/
          {1.620926,3.1987,6.0402,5.3169} /*cfz*/
     },
     {
          2452699.4,
          {-1.7561,0.00906,1020.8822,1.84977,0.02774,1.0622}, /*cmx*/
          {3.851811,5.3248,2.1812,5.1148}, /*cfx*/
          {0.5617,-0.0031,321.5359,0.7911,0.011825,0.3234}, /*cmy*/
          {0.690697,3.1754,6.2699,1.9558}, /*cfy*/
          {3.2875,-0.0158,1070.5125,1.91211,0.028818,1.173}, /*cmz*/
          {5.420915,0.7322,3.8793,0.39} /*cfz*/
     },
     {
          2452739.4,
          {-1.6599,-0.00849,1024.1262,0.44348,0.025012,1.0352}, /*cmx*/
          {1.309343,5.9963,5.8553,0.0963}, /*cfx*/
          {0.531,0.00262,310.9397,0.19443,0.010362,0.3196}, /*cmy*/
          {4.425285,3.751,3.6223,3.2291}, /*cfy*/
          {3.2127,-0.03085,1070.2358,0.50249,0.024897,1.0933}, /*cmz*/
          {2.878311,1.3595,1.2435,1.6458} /*cfz*/
     },
     {
          2452779.4,
          {-1.6265,-0.01372,1018.623,2.42025,0.013965,0.8934}, /*cmx*/
          {4.96611,3.3049,2.9509,1.1795}, /*cfx*/
          {0.5225,0.00699,328.6831,1.02184,0.006551,0.3008}, /*cmy*/
          {1.803436,1.0801,0.434,4.2921}, /*cfy*/
          {2.4595,-0.0238,1069.9244,2.51729,0.015013,0.9569}, /*cmz*/
          {0.251802,4.9903,4.5659,2.7903} /*cfz*/
     },
     {
          2452819.4,
          {-1.5902,-0.00489,1006.8992,3.50897,0.007857,0.7015}, /*cmx*/
          {2.279544,0.6125,5.8934,2.1914}, /*cfx*/
          {0.5844,0.00296,363.0468,1.4813,0.005717,0.273}, /*cmy*/
          {5.412883,4.5562,3.1963,5.3276}, /*cfy*/
          {1.3504,0.00108,1070.2898,3.64626,0.00913,0.7663}, /*cmz*/
          {3.849223,2.2831,1.3492,3.7936} /*cfz*/
     },
     {
          2452859.4,
          {-1.6739,0.01568,992.9335,3.88249,0.006945,0.5854}, /*cmx*/
          {5.844927,4.1842,2.2864,3.0818}, /*cfx*/
          {0.6698,-0.0052,399.6039,1.64401,0.005922,0.244}, /*cmy*/
          {2.711455,1.6962,6.1196,6.2442}, /*cfy*/
          {0.7541,0.01044,1070.5367,4.09097,0.007311,0.6101}, /*cmz*/
          {1.133649,5.8402,4.027,4.7706} /*cfz*/
     },
     {
          2452899.4,
          {-1.5245,0.02057,980.5819,3.72926,0.010345,0.4859}, /*cmx*/
          {3.12043,1.4725,5.0651,3.795}, /*cfx*/
          {0.6645,-0.009,429.1378,1.57313,0.006019,0.2166}, /*cmy*/
          {0.004468,5.1101,2.679,0.6795}, /*cfy*/
          {0.8329,0.00722,1070.4218,4.01074,0.011892,0.5189}, /*cmz*/
          {4.695691,3.1142,0.427,5.5049} /*cfz*/
     },
     {
          2452939.4,
          {-1.2049,0.00418,972.5373,2.99944,0.018305,0.5656}, /*cmx*/
          {0.412214,5.0558,1.9879,4.6356}, /*cfx*/
          {0.5309,-0.00178,448.0498,1.2355,0.008245,0.2652}, /*cmy*/
          {3.596747,2.2725,5.5471,1.5424}, /*cfy*/
          {1.4952,-0.00719,1070.2462,3.21365,0.019984,0.615}, /*cmz*/
          {1.990657,0.4086,3.6692,6.2144} /*cfz*/
     },
     {
          2452979.4,
          {-0.9476,-0.01623,968.3831,1.51988,0.027144,0.7168}, /*cmx*/
          {4.031411,2.4175,5.5617,5.5787}, /*cfx*/
          {0.3983,0.00764,456.6511,0.57046,0.011877,0.3398}, /*cmy*/
          {0.948075,5.8529,2.6659,2.4991}, /*cfy*/
          {1.863,-0.00065,1070.0175,1.57297,0.028615,0.7648}, /*cmz*/
          {5.612551,4.0347,0.8976,0.8614} /*cfz*/
     },
     {
          2453019.4,
          {-1.1355,-0.0166,967.5098,0.77401,0.020352,0.8205}, /*cmx*/
          {1.441851,2.9422,3.0718,0.487}, /*cfx*/
          {0.4828,0.00704,458.1585,0.4381,0.008345,0.3875}, /*cmy*/
          {4.651712,6.2562,0.3091,3.6987}, /*cfy*/
          {1.9378,0.01684,1070.0224,0.89604,0.021165,0.8973}, /*cmz*/
          {3.02509,4.5852,4.668,2.0224} /*cfz*/
     },
     {
          2453059.4,
          {-1.5278,-0.00599,969.7452,2.45658,0.008976,0.9724}, /*cmx*/
          {5.217723,0.4686,3.4202,1.7516}, /*cfx*/
          {0.6703,0.00095,453.8269,1.10542,0.005257,0.455}, /*cmy*/
          {2.145181,3.9246,0.4219,4.9647}, /*cfy*/
          {2.0209,0.0267,1070.31,2.66578,0.010055,1.0349}, /*cmz*/
          {0.517731,2.1058,5.0896,3.3076} /*cfz*/
     },
     {
          2453099.4,
          {-2.191,0.00684,973.8152,1.61024,0.026533,1.0654}, /*cmx*/
          {2.732218,4.2595,1.1223,3.0899}, /*cfx*/
          {0.9233,-0.00272,444.9806,0.65744,0.011828,0.4824}, /*cmy*/
          {5.935147,1.5616,4.6586,0.0042}, /*cfy*/
          {2.6486,-0.00347,1070.1298,1.68148,0.027887,1.1157}, /*cmz*/
          {4.313835,5.8963,2.7557,4.657} /*cfz*/
     },
     {
          2453139.4,
          {-2.3727,-0.00722,975.191,0.57466,0.022235,1.1039}, /*cmx*/
          {0.183791,4.8597,4.7914,4.3538}, /*cfx*/
          {0.9981,0.00479,441.7256,0.3096,0.009543,0.5028}, /*cmy*/
          {3.379395,2.0684,1.9961,1.2712}, /*cfy*/
          {2.9446,-0.02967,1069.9307,0.65042,0.023875,1.1857}, /*cmz*/
          {1.763917,0.2616,0.1003,5.929} /*cfz*/
     },
     {
          2453179.4,
          {-2.5009,-0.01564,972.031,2.3666,0.012744,1.077}, /*cmx*/
          {3.836534,2.2311,1.8821,5.5069}, /*cfx*/
          {1.1052,0.00854,448.2586,1.07961,0.005967,0.5029}, /*cmy*/
          {0.748762,5.7188,5.0464,2.4163}, /*cfy*/
          {2.3389,-0.03075,1069.8855,2.53557,0.014995,1.1752}, /*cmz*/
          {5.416516,3.8648,3.4632,0.7806} /*cfz*/
     },
     {
          2453219.4,
          {-2.574,-0.01236,967.5927,3.37102,0.007296,0.9781}, /*cmx*/
          {1.148299,5.838,4.8939,0.3251}, /*cfx*/
          {1.1825,0.00684,457.9981,1.50323,0.005403,0.4687}, /*cmy*/
          {4.350891,2.9351,1.5404,3.5327}, /*cfy*/
          {1.1751,-0.01476,1070.1,3.65702,0.008424,1.075}, /*cmz*/
          {2.730168,1.159,0.1952,1.8949} /*cfz*/
     },
     {
          2453259.4,
          {-2.7351,0.01134,965.4194,3.72326,0.005818,0.8435}, /*cmx*/
          {4.713586,3.1381,1.282,1.4694}, /*cfx*/
          {1.3166,-0.00596,463.327,1.62826,0.005502,0.4075}, /*cmy*/
          {1.645444,0.0916,4.4804,4.6953}, /*cfy*/
          {0.0061,0.0015,1070.0391,4.08562,0.007676,0.9645}, /*cmz*/
          {0.01511,4.7222,2.7721,2.9881} /*cfz*/
     },
     {
          2453299.4,
          {-2.5735,0.02486,967.1437,3.60222,0.010552,0.6968}, /*cmx*/
          {1.991306,0.4343,3.9087,2.493}, /*cfx*/
          {1.2365,-0.01212,460.4943,1.53119,0.006244,0.3294}, /*cmy*/
          {5.222109,3.5123,0.9567,5.7385}, /*cfy*/
          {-0.4801,0.00324,1069.629,3.92533,0.012706,0.7815}, /*cmz*/
          {3.578677,2.0022,5.5783,3.9811} /*cfz*/
     },
     {
          2453339.4,
          {-2.1485,0.02049,972.0009,2.83637,0.019637,0.5958}, /*cmx*/
          {5.571647,4.0353,0.9519,3.4103}, /*cfx*/
          {1.0064,-0.00992,450.8826,1.1503,0.008932,0.273}, /*cmy*/
          {2.536591,0.6785,3.9668,0.371}, /*cfy*/
          {-0.2408,-0.0069,1069.5694,3.03416,0.020917,0.666}, /*cmz*/
          {0.877942,5.5736,2.5117,4.9935} /*cfz*/
     },
     {
          2453379.4,
          {-1.4611,-0.00493,976.4004,1.23311,0.026807,0.5209}, /*cmx*/
          {2.916678,1.4212,4.5608,4.2151}, /*cfx*/
          {0.6462,0.00236,440.9464,0.43133,0.011178,0.2364}, /*cmy*/
          {6.180809,4.211,1.1432,1.2121}, /*cfy*/
          {0.1451,-0.00284,1069.2704,1.2872,0.028681,0.6092}, /*cmz*/
          {4.508084,2.9198,6.0644,5.7948} /*cfz*/
     },
     {
          2453419.4,
          {-1.2022,-0.01679,977.0782,1.05922,0.016867,0.5402}, /*cmx*/
          {0.338384,1.9416,2.0928,5.079}, /*cfx*/
          {0.5038,0.00766,439.8514,0.52832,0.006372,0.2488}, /*cmy*/
          {3.611494,4.8581,5.0844,2.0861}, /*cfy*/
          {0.2739,0.02099,1068.9552,1.1552,0.018731,0.5888}, /*cmz*/
          {1.931424,3.4899,3.5972,0.4423} /*cfz*/
     },
     {
          2453459.4,
          {-1.4291,-0.01265,973.5333,2.46261,0.012131,0.6859}, /*cmx*/
          {4.119683,5.7587,2.5227,6.1588}, /*cfx*/
          {0.6262,0.00461,448.535,1.05324,0.006161,0.3141}, /*cmy*/
          {1.106226,2.4424,5.4478,3.1451}, /*cfy*/
          {0.656,0.02952,1069.204,2.64018,0.012768,0.7926}, /*cmz*/
          {5.713171,1.0101,4.0209,1.5552} /*cfz*/
     },
     {
          2453499.4,
          {-2.1641,0.00486,969.6838,1.36706,0.025478,0.8146}, /*cmx*/
          {1.62939,3.2575,0.1183,1.1314}, /*cfx*/
          {0.9476,-0.00243,455.9137,0.51011,0.011153,0.383}, /*cmy*/
          {4.887572,6.2766,3.1614,4.3887}, /*cfy*/
          {1.3025,0.01015,1069.214,1.461,0.027977,0.944}, /*cmz*/
          {3.221212,4.7912,1.6511,2.7458} /*cfz*/
     },
     {
          2453539.4,
          {-2.5468,-0.00411,968.9395,0.75566,0.020819,0.958}, /*cmx*/
          {5.356013,3.8406,3.7557,2.3362}, /*cfx*/
          {1.1094,0.00259,456.7676,0.42004,0.00865,0.447}, /*cmy*/
          {2.322089,0.6561,0.4002,5.5894}, /*cfy*/
          {1.9519,-0.02295,1069.2511,0.84377,0.023101,1.0838}, /*cmz*/
          {0.663026,5.4227,5.2792,3.9606} /*cfz*/
     },
     {
          2453579.4,
          {-2.7397,-0.01783,971.2551,2.43286,0.013098,1.0727}, /*cmx*/
          {2.719877,1.2166,0.8171,3.4651}, /*cfx*/
          {1.1959,0.00816,451.1509,1.11446,0.006167,0.4886}, /*cmy*/
          {5.968784,4.2113,3.3623,0.434}, /*cfy*/
          {1.6626,-0.03132,1069.4659,2.66037,0.014383,1.2061}, /*cmz*/
          {4.309621,2.7471,2.3621,5.0648} /*cfz*/
     },
     {
          2453619.4,
          {-2.9557,-0.01829,977.9455,3.42158,0.007783,1.1208}, /*cmx*/
          {0.029302,4.8141,3.8867,4.5868}, /*cfx*/
          {1.2954,0.00635,437.1155,1.48819,0.005899,0.484}, /*cmy*/
          {3.28623,1.3867,6.1958,1.5604}, /*cfy*/
          {0.6764,-0.02511,1069.335,3.76607,0.008176,1.2058}, /*cmz*/
          {1.61955,0.0499,5.2187,6.1843} /*cfz*/
     },
     {
          2453659.4,
          {-3.1805,0.00294,989.1558,3.81689,0.006269,1.1109}, /*cmx*/
          {3.595032,2.1032,0.1162,5.7193}, /*cfx*/
          {1.3473,-0.00363,412.4493,1.60063,0.006096,0.4424}, /*cmy*/
          {0.583873,4.783,2.8108,2.7221}, /*cfy*/
          {-0.7364,-0.00578,1069.1799,4.12147,0.008331,1.1533}, /*cmz*/
          {5.185094,3.613,1.6122,1.0709} /*cfz*/
     },
     {
          2453699.4,
          {-3.1519,0.0245,1002.847,3.65262,0.012179,1.0668}, /*cmx*/
          {0.875537,5.6765,2.8697,0.5366}, /*cfx*/
          {1.2747,-0.01187,378.3543,1.48182,0.006767,0.3741}, /*cmy*/
          {4.168953,1.8828,5.6708,3.844}, /*cfy*/
          {-1.5983,-0.00304,1069.0738,3.86752,0.013021,1.0826}, /*cmz*/
          {2.464854,0.884,4.4019,2.1703} /*cfz*/
     },
     {
          2453739.4,
          {-2.7284,0.03077,1015.8464,2.77747,0.021585,0.9659}, /*cmx*/
          {4.462075,2.9849,6.1841,1.6968}, /*cfx*/
          {0.9823,-0.01001,342.1713,1.09758,0.008928,0.3074}, /*cmy*/
          {1.498386,5.2919,2.3412,5.0035}, /*cfy*/
          {-1.8355,-0.00703,1069.0554,2.90216,0.022421,0.9877}, /*cmz*/
          {6.050556,4.4578,1.363,3.3115} /*cfz*/
     },
     {
          2453779.4,
          {-1.836,0.00724,1023.9355,0.98995,0.026858,0.818}, /*cmx*/
          {1.816297,0.3691,3.5011,2.798}, /*cfx*/
          {0.6525,-0.00188,317.2991,0.37939,0.010659,0.251}, /*cmy*/
          {5.159714,2.4458,5.7465,6.1425}, /*cfy*/
          {-1.5626,-0.00769,1068.6717,1.0528,0.028904,0.8321}, /*cmz*/
          {3.4047,1.8185,4.9648,4.4098} /*cfz*/
     },
     {
          2453819.4,
          {-1.1238,-0.01657,1024.0814,1.33241,0.014394,0.6168}, /*cmx*/
          {5.531163,0.9069,1.0591,3.9188}, /*cfx*/
          {0.4028,0.00669,317.4551,0.55162,0.005344,0.2031}, /*cmy*/
          {2.598143,3.2668,3.4131,1.0236}, /*cfy*/
          {-1.4356,0.01548,1068.3072,1.3983,0.015786,0.6142}, /*cmz*/
          {0.836829,2.382,2.5792,5.4823} /*cfz*/
     },
     {
          2453859.4,
          {-1.2098,-0.01289,1016.9426,2.48062,0.014285,0.597}, /*cmx*/
          {3.0331,4.7277,1.5147,4.9563}, /*cfx*/
          {0.4886,0.0026,340.8339,0.96453,0.005977,0.2047}, /*cmy*/
          {0.084412,0.8131,3.9136,1.9482}, /*cfy*/
          {-1.0521,0.02671,1068.5204,2.64078,0.015712,0.5807}, /*cmz*/
          {4.622888,6.1992,2.9546,0.1618} /*cfz*/
     },
     {
          2453899.4,
          {-1.7779,0.00421,1008.8266,1.19119,0.026186,0.6194}, /*cmx*/
          {0.536494,2.2238,5.361,5.8643}, /*cfx*/
          {0.6616,-0.00246,362.5924,0.42172,0.010575,0.2262}, /*cmy*/
          {3.850145,4.5398,1.5456,2.8758}, /*cfy*/
          {-0.5139,0.02175,1068.7294,1.25759,0.028355,0.6094}, /*cmz*/
          {2.126586,3.6998,0.5633,1.1249} /*cfz*/
     },
     {
          2453939.4,
          {-2.2402,0.00266,1007.7549,0.99069,0.020946,0.7405}, /*cmx*/
          {4.254474,2.814,2.6728,0.5735}, /*cfx*/
          {0.7933,-0.00204,364.2338,0.47189,0.008518,0.2631}, /*cmy*/
          {1.274539,5.4533,4.9631,3.8821}, /*cfy*/
          {0.3417,-0.00964,1068.8647,1.06061,0.022516,0.7541}, /*cmz*/
          {5.843513,4.2997,4.1733,2.1166} /*cfz*/
     },
     {
          2453979.4,
          {-2.3843,-0.01604,1014.8233,2.65113,0.014277,0.9491}, /*cmx*/
          {1.611754,0.1613,5.9867,1.5573}, /*cfx*/
          {0.7607,0.00445,343.7714,1.12327,0.006959,0.2968}, /*cmy*/
          {4.919331,2.5889,1.6759,4.8503}, /*cfy*/
          {0.5559,-0.02718,1068.9578,2.86293,0.013636,0.9572}, /*cmz*/
          {3.199699,1.639,1.1837,3.1239} /*cfz*/
     },
     {
          2454019.4,
          {-2.6549,-0.02038,1027.845,3.68921,0.008447,1.0479}, /*cmx*/
          {5.200825,3.732,2.6387,2.6135}, /*cfx*/
          {0.8016,0.00152,303.6021,1.52943,0.006927,0.2846}, /*cmy*/
          {2.245512,5.9899,4.5267,5.9595}, /*cfy*/
          {-0.0824,-0.02794,1068.7161,3.90285,0.00901,1.1072}, /*cmz*/
          {0.503317,5.225,3.9972,4.1902} /*cfz*/
     },
     {
          2454059.4,
          {-2.8545,-0.00725,1042.8979,4.06173,0.008894,1.114}, /*cmx*/
          {2.481841,0.9988,5.2037,3.7462}, /*cfx*/
          {0.7261,-0.0022,247.6407,1.69254,0.006869,0.2342}, /*cmy*/
          {5.851729,3.0668,1.1817,0.8988}, /*cfy*/
          {-1.3614,-0.0107,1068.9879,4.20495,0.00843,1.1891}, /*cmz*/
          {4.064349,2.4895,0.4037,5.3005} /*cfz*/
     },
     {
          2454099.4,
          {-3.0319,0.02209,1055.8878,3.77423,0.014149,1.1978}, /*cmx*/
          {6.046023,4.5389,1.7782,4.8573}, /*cfx*/
          {0.646,-0.00798,184.5027,1.60877,0.006844,0.166}, /*cmy*/
          {3.21116,0.1475,3.9363,2.0893}, /*cfy*/
          {-2.4295,-0.00458,1069.1518,3.88283,0.013933,1.2671}, /*cmz*/
          {1.342145,6.0406,3.2101,0.1427} /*cfz*/
     },
     {
          2454139.4,
          {-2.6619,0.03381,1063.9958,2.74689,0.022775,1.1962}, /*cmx*/
          {3.352629,1.8204,5.0224,6.0615}, /*cfx*/
          {0.4076,-0.00324,128.8135,1.20261,0.00964,0.1325}, /*cmy*/
          {0.655332,3.5769,0.5589,3.3911}, /*cfy*/
          {-2.9428,-0.00663,1069.1509,2.85058,0.024061,1.2497}, /*cmz*/
          {4.929296,3.3374,0.2289,1.3236} /*cfz*/
     },
     {
          2454179.4,
          {-1.8149,0.01675,1067.4243,0.84294,0.027311,1.154}, /*cmx*/
          {0.712676,5.4463,2.3069,0.9749}, /*cfx*/
          {0.2784,-0.00041,97.7164,0.40983,0.011956,0.1061}, /*cmy*/
          {4.457986,0.844,4.0238,4.7185}, /*cfy*/
          {-2.8296,-0.01332,1068.8255,0.88731,0.028571,1.1619}, /*cmz*/
          {2.28757,0.7308,3.871,2.5313} /*cfz*/
     },
     {
          2454219.4,
          {-0.8573,-0.01517,1067.0189,1.51318,0.013542,0.9328}, /*cmx*/
          {4.433545,6.0244,6.2479,2.2138}, /*cfx*/
          {0.2221,0.00211,100.2063,0.61602,0.0058,0.1061}, /*cmy*/
          {1.882821,1.4752,1.7484,5.9765}, /*cfy*/
          {-2.732,0.00102,1068.7113,1.56541,0.013407,1.0004}, /*cmz*/
          {6.008448,1.2737,1.5062,3.8103} /*cfz*/
     },
     {
          2454259.4,
          {-0.8286,-0.00869,1063.6883,2.5241,0.016197,0.8469}, /*cmx*/
          {1.937789,3.5742,0.3447,3.5043}, /*cfx*/
          {0.2542,-0.00058,131.8847,1.06132,0.006819,0.1148}, /*cmy*/
          {5.512389,5.3481,2.1415,0.6525}, /*cfy*/
          {-2.7062,0.02233,1069.166,2.62413,0.017468,0.8885}, /*cmz*/
          {3.514197,5.1018,1.8994,5.1115} /*cfz*/
     },
     {
          2454299.4,
          {-1.1142,0.00713,1059.1933,1.06952,0.027982,0.6694}, /*cmx*/
          {5.719836,1.0746,4.2108,4.5964}, /*cfx*/
          {0.2804,-0.00238,162.9035,0.45499,0.01169,0.1052}, /*cmy*/
          {2.913369,2.7918,6.085,1.8065}, /*cfy*/
          {-2.3516,0.02762,1069.1884,1.10467,0.029102,0.7358}, /*cmz*/
          {1.014637,2.6043,5.7465,6.2192} /*cfz*/
     },
     {
          2454339.4,
          {-1.4243,0.01252,1058.8712,1.22123,0.022224,0.5771}, /*cmx*/
          {3.147043,1.6838,1.4812,5.5099}, /*cfx*/
          {0.2686,-0.00264,162.3754,0.51439,0.009835,0.0846}, /*cmy*/
          {0.326002,3.7001,3.2232,2.7993}, /*cfy*/
          {-1.5182,0.0058,1069.0851,1.29025,0.021951,0.6301}, /*cmz*/
          {4.724947,3.1779,3.0309,0.8236} /*cfz*/
     },
     {
          2454379.4,
          {-1.3735,-0.00781,1063.7828,2.9773,0.014249,0.6687}, /*cmx*/
          {0.497401,5.2702,4.7202,6.2112}, /*cfx*/
          {0.1992,-0.00084,127.3632,1.27632,0.007759,0.0565}, /*cmy*/
          {4.032135,0.8332,6.2042,3.5537}, /*cfy*/
          {-0.8089,-0.01781,1069.0388,3.07188,0.013894,0.685}, /*cmz*/
          {2.073344,0.5203,6.2516,1.5565} /*cfz*/
     },
     {
          2454419.4,
          {-1.4801,-0.01775,1068.9453,4.00247,0.010106,0.7837}, /*cmx*/
          {4.079902,2.5355,1.1893,0.7856}, /*cfx*/
          {0.1116,-0.0019,70.9113,1.73729,0.007394,0.0342}, /*cmy*/
          {1.648501,4.2418,2.772,5.0515}, /*cfy*/
          {-0.9604,-0.02097,1069.207,4.04367,0.009484,0.7731}, /*cmz*/
          {5.652585,4.0894,2.8713,2.3864} /*cfz*/
     },
     {
          2454459.4,
          {-1.593,-0.01528,1070.0364,4.28616,0.011034,0.9298}, /*cmx*/
          {1.355373,6.0542,3.9184,1.7968}, /*cfx*/
          {0.0549,-0.00452,49.6008,1.89005,0.007193,0.074}, /*cmy*/
          {0.300332,1.3387,5.6073,1.203}, /*cfy*/
          {-1.722,-0.01201,1069.6603,4.34235,0.009041,0.8891}, /*cmz*/
          {2.925161,1.3473,5.4264,3.362} /*cfz*/
     },
     {
          2454499.4,
          {-1.8649,0.01271,1065.6825,3.86527,0.01466,1.122}, /*cmx*/
          {4.915357,3.2861,0.5228,2.872}, /*cfx*/
          {-0.0931,-0.00083,109.2954,1.71356,0.007575,0.149}, /*cmy*/
          {4.545721,4.7325,2.1233,2.6325}, /*cfy*/
          {-2.7701,-0.00063,1069.8431,3.95868,0.015059,1.0721}, /*cmz*/
          {0.199636,4.8987,2.0524,4.4343} /*cfz*/
     },
     {
          2454539.4,
          {-1.7016,0.02801,1058.059,2.77521,0.02333,1.2023}, /*cmx*/
          {2.219651,0.5533,3.7358,4.0294}, /*cfx*/
          {-0.1547,0.00369,167.401,1.21349,0.010005,0.207}, /*cmy*/
          {2.00459,1.9083,5.0995,3.8576}, /*cfy*/
          {-3.3363,-0.0043,1069.7101,2.85029,0.024356,1.1535}, /*cmz*/
          {3.785536,2.2059,5.3984,5.6017} /*cfz*/
     },
     {
          2454579.4,
          {-1.1418,0.02145,1052.1405,0.85643,0.028172,1.2492}, /*cmx*/
          {5.862297,4.1894,1.06,5.2435}, /*cfx*/
          {-0.1164,0.00462,199.6862,0.38616,0.01211,0.2382}, /*cmy*/
          {5.697706,5.6028,2.322,5.0863}, /*cfy*/
          {-3.38,-0.01569,1069.7836,0.84268,0.028205,1.2407}, /*cmz*/
          {1.14411,5.8704,2.7253,0.5399} /*cfz*/
     },
     {
          2454619.4,
          {-0.3122,-0.00647,1052.444,1.54757,0.013486,1.2072}, /*cmx*/
          {3.300803,4.7743,5.02,0.2607}, /*cfx*/
          {0.0792,-0.00228,196.5341,0.66169,0.006465,0.2208}, /*cmy*/
          {3.141128,5.9433,0.1536,0.0619}, /*cfy*/
          {-3.2972,-0.01604,1069.7899,1.6133,0.013122,1.1722}, /*cmz*/
          {4.866113,0.1385,0.3502,1.7915} /*cfz*/
     },
     {
          2454659.4,
          {-0.0109,-0.00836,1058.4782,2.58,0.017787,1.1586}, /*cmx*/
          {0.806638,2.3215,5.3745,1.6569}, /*cfx*/
          {0.0826,-0.00088,162.1989,1.1299,0.007425,0.1483}, /*cmy*/
          {0.614195,3.6367,0.3523,1.4773}, /*cfy*/
          {-3.7132,0.01488,1070.1596,2.62061,0.017906,1.1498}, /*cmz*/
          {2.37334,3.9655,0.7824,3.2053} /*cfz*/
     },
     {
          2454699.4,
          {-0.0953,0.00782,1063.0131,1.03175,0.030117,1.0583}, /*cmx*/
          {4.588368,6.1077,2.9672,2.9168}, /*cfx*/
          {0.0985,-0.00013,129.1465,0.47158,0.012838,0.1237}, /*cmy*/
          {4.344289,1.1786,4.3505,2.671}, /*cfy*/
          {-3.6711,0.02845,1070.0174,1.01719,0.02974,1.0156}, /*cmz*/
          {6.156057,1.4564,4.5935,4.4378} /*cfz*/
     },
     {
          2454739.4,
          {-0.1747,0.02036,1062.6788,1.41077,0.022432,0.8898}, /*cmx*/
          {2.011227,0.4147,0.2251,4.0231}, /*cfx*/
          {0.0365,0.00358,130.6782,0.5876,0.010027,0.1246}, /*cmy*/
          {1.776575,1.8548,1.4942,3.7752}, /*cfy*/
          {-3.0379,0.01863,1069.5889,1.44499,0.022605,0.8326}, /*cmz*/
          {3.578859,2.0502,1.8415,5.5934} /*cfz*/
     },
     {
          2454779.4,
          {0.0491,0.00781,1057.2023,3.21964,0.013588,0.7342}, /*cmx*/
          {5.637288,4.0078,3.374,4.9781}, /*cfx*/
          {0.0841,0.0004,169.1735,1.37834,0.007295,0.1452}, /*cmy*/
          {5.47187,5.3453,4.3588,4.9058}, /*cfy*/
          {-2.0248,-0.00557,1069.7874,3.25376,0.014172,0.7274}, /*cmz*/
          {0.920767,5.6476,5.0821,0.1949} /*cfz*/
     },
     {
          2454819.4,
          {0.3623,-0.01403,1045.5523,4.14933,0.010212,0.5884}, /*cmx*/
          {2.927289,1.2747,6.1514,5.7546}, /*cfx*/
          {0.0947,-0.00216,229.2617,1.77755,0.007416,0.141}, /*cmy*/
          {2.824566,2.4766,0.8247,5.6554}, /*cfy*/
          {-1.5972,-0.0098,1070.1893,4.21619,0.009286,0.5871}, /*cmz*/
          {4.493286,2.9235,1.6617,0.9756} /*cfz*/
     },
     {
          2454859.4,
          {0.3097,-0.01995,1029.5198,4.33982,0.010129,0.5616}, /*cmx*/
          {0.193848,4.8016,2.5914,0.1436}, /*cfx*/
          {0.1401,-0.00744,293.0337,1.82982,0.007395,0.181}, /*cmy*/
          {0.134254,5.8455,3.7628,0.065}, /*cfy*/
          {-1.676,-0.00773,1070.3302,4.504,0.010242,0.611}, /*cmz*/
          {1.760521,0.1836,4.1938,1.7626} /*cfz*/
     },
     {
          2454899.4,
          {0.0335,-0.00406,1012.9235,3.89171,0.014353,0.6998}, /*cmx*/
          {3.745975,2.0546,5.4888,1.0216}, /*cfx*/
          {0.0237,-0.00135,347.0583,1.60775,0.00707,0.257}, /*cmy*/
          {3.716764,2.9367,0.3149,1.024}, /*cfy*/
          {-2.3704,0.0055,1070.4363,4.04664,0.015048,0.8075}, /*cmz*/
          {5.313839,3.7338,0.9415,2.6094} /*cfz*/
     },
     {
          2454939.4,
          {-0.2108,0.01757,999.2372,2.81745,0.022785,0.831}, /*cmx*/
          {1.043003,5.641,2.5477,2.0275}, /*cfx*/
          {-0.0679,0.00617,384.1892,1.13917,0.009677,0.3276}, /*cmy*/
          {1.036265,0.1087,3.2768,2.0238}, /*cfy*/
          {-2.8013,-0.00156,1070.41,2.9164,0.023382,0.9425}, /*cmz*/
          {2.612766,1.0276,4.2245,3.6221} /*cfz*/
     },
     {
          2454979.4,
          {-0.0394,0.02142,991.6649,0.97707,0.028021,0.9801}, /*cmx*/
          {4.679023,3.0176,6.1648,3.19}, /*cfx*/
          {-0.0255,0.0083,402.6022,0.35261,0.011922,0.3982}, /*cmy*/
          {4.688267,3.8359,0.518,3.2062}, /*cfy*/
          {-2.9563,-0.01636,1070.3724,0.97517,0.029054,1.1195}, /*cmz*/
          {6.25094,4.6688,1.5272,4.7869} /*cfz*/
     },
     {
          2455019.4,
          {0.4927,0.00485,991.6705,1.43024,0.014134,1.0927}, /*cmx*/
          {2.112776,3.5733,3.7725,4.4379}, /*cfx*/
          {0.1898,0.00076,402.1248,0.67945,0.006106,0.4362}, /*cmy*/
          {2.130353,4.1167,4.7129,4.4625}, /*cfy*/
          {-3.0083,-0.02567,1070.4355,1.53776,0.014626,1.2026}, /*cmz*/
          {3.686151,5.2529,5.4095,6.036} /*cfz*/
     },
     {
          2455059.4,
          {1.0826,-0.01131,999.102,2.56698,0.017268,1.1363}, /*cmx*/
          {5.902922,1.1109,4.1984,5.8561}, /*cfx*/
          {0.3564,-0.00278,384.5031,1.1182,0.008081,0.4107}, /*cmy*/
          {5.919436,1.8413,4.7889,5.8709}, /*cfy*/
          {-3.6276,0.003,1070.392,2.677,0.017673,1.2203}, /*cmz*/
          {1.192827,2.7739,5.836,1.1753} /*cfz*/
     },
     {
          2455099.4,
          {1.1087,0.00431,1006.492,1.03243,0.029913,1.1527}, /*cmx*/
          {3.405763,4.8924,1.753,0.8466}, /*cfx*/
          {0.3899,0.00166,364.6482,0.43108,0.012886,0.4148}, /*cmy*/
          {3.414813,5.7777,2.5492,0.8538}, /*cfy*/
          {-3.9446,0.02245,1070.2718,1.07029,0.031388,1.2418}, /*cmz*/
          {4.977701,0.2556,3.3971,2.455} /*cfz*/
     },
     {
          2455139.4,
          {1.1785,0.02099,1005.8619,1.43697,0.022001,1.0499}, /*cmx*/
          {0.828647,5.4724,5.2941,2.0386}, /*cfx*/
          {0.4206,0.0089,365.5297,0.62629,0.009451,0.3972}, /*cmy*/
          {0.834139,6.2333,5.9577,2.0361}, /*cfy*/
          {-3.634,0.02497,1070.1213,1.48682,0.023867,1.1792}, /*cmz*/
          {2.399936,0.8636,0.6683,3.6452} /*cfz*/
     },
     {
          2455179.4,
          {1.4429,0.02056,997.1942,3.22095,0.012483,0.9745}, /*cmx*/
          {4.449565,2.798,2.204,3.1292}, /*cfx*/
          {0.5463,0.00957,388.4837,1.38704,0.006946,0.3964}, /*cmy*/
          {4.460994,3.4953,2.4928,3.159}, /*cfy*/
          {-2.6542,0.00997,1070.2466,3.37515,0.014031,1.07}, /*cmz*/
          {6.021699,4.4596,3.8902,4.7606} /*cfz*/
     },
     {
          2455219.4,
          {1.9927,-0.00575,984.7753,4.05781,0.00837,0.7711}, /*cmx*/
          {1.732049,0.0865,5.0708,4.1653}, /*cfx*/
          {0.8365,-0.0013,419.2392,1.74906,0.007233,0.3386}, /*cmy*/
          {1.756556,0.6426,5.3496,4.1991}, /*cfy*/
          {-1.6431,0.00069,1070.3057,4.35333,0.009555,0.8613}, /*cmz*/
          {3.306833,1.737,0.3676,5.7758} /*cfz*/
     },
     {
          2455259.4,
          {2.0709,-0.0204,973.7924,4.25321,0.008383,0.6314}, /*cmx*/
          {5.275067,3.6415,1.3392,5.1488}, /*cfx*/
          {0.9269,-0.00881,444.9489,1.82354,0.006677,0.2953}, /*cmy*/
          {5.3164,4.0224,1.9542,5.1877}, /*cfy*/
          {-1.0786,-0.0005,1070.0438,4.58714,0.01104,0.6752}, /*cmz*/
          {0.569963,5.2826,3.0873,0.4015} /*cfz*/
     },
     {
          2455299.4,
          {1.833,-0.01988,967.2438,3.85113,0.013314,0.5963}, /*cmx*/
          {2.537955,0.9299,4.3792,5.9281}, /*cfx*/
          {0.8499,-0.00964,459.6274,1.63191,0.007181,0.2876}, /*cmy*/
          {2.597757,1.1418,4.8112,5.9882}, /*cfy*/
          {-1.1574,0.00876,1070.2601,4.13057,0.014154,0.5927}, /*cmz*/
          {4.119622,2.5355,6.0562,1.2286} /*cfz*/
     },
     {
          2455339.4,
          {1.2214,0.00452,965.3018,2.86481,0.021195,0.5793}, /*cmx*/
          {6.111791,4.5309,1.4522,0.3937}, /*cfx*/
          {0.5293,0.00247,463.7866,1.16692,0.009661,0.2778}, /*cmy*/
          {6.189962,4.6032,1.5716,0.484}, /*cfy*/
          {-1.421,0.0047,1070.0593,3.08021,0.023015,0.5976}, /*cmz*/
          {1.414079,6.1053,3.0229,1.9352} /*cfz*/
     },
     {
          2455379.4,
          {0.9444,0.01942,965.8176,1.13813,0.027423,0.7153}, /*cmx*/
          {3.457243,1.9089,5.047,1.3478}, /*cfx*/
          {0.3871,0.00849,462.7469,0.385,0.011785,0.344}, /*cmy*/
          {3.551352,1.9104,5.0527,1.4405}, /*cfy*/
          {-1.5884,-0.01223,1069.6977,1.21575,0.030396,0.7435}, /*cmz*/
          {5.045746,3.4511,0.3105,2.8536} /*cfz*/
     },
     {
          2455419.4,
          {1.1952,0.01284,966.0997,1.25618,0.015579,0.8639}, /*cmx*/
          {0.883602,2.4652,2.5813,2.4389}, /*cfx*/
          {0.4968,0.00487,462.9613,0.64832,0.005877,0.4141}, /*cmy*/
          {0.986798,2.4658,2.7915,2.5354}, /*cfy*/
          {-1.7504,-0.02763,1069.3041,1.37635,0.017414,0.9328}, /*cmz*/
          {2.473935,4.0201,4.1975,4.0206} /*cfz*/
     },
     {
          2455459.4,
          {1.9158,-0.01251,965.3353,2.53723,0.01507,0.9208}, /*cmx*/
          {4.672021,6.258,3.0493,3.8125}, /*cfx*/
          {0.8096,-0.00588,464.4947,1.11439,0.007785,0.445}, /*cmy*/
          {4.772997,0.0797,3.0863,3.9002}, /*cfy*/
          {-2.3007,-0.01495,1069.5453,2.77834,0.017445,1.0268}, /*cmz*/
          {6.261714,1.5558,4.5966,5.3447} /*cfz*/
     },
     {
          2455499.4,
          {2.0601,-5e-05,965.5977,1.1225,0.029284,1.0797}, /*cmx*/
          {2.180285,3.7441,0.6026,5.0617}, /*cfx*/
          {0.8692,0.00065,463.3632,0.40791,0.012937,0.5191}, /*cmy*/
          {2.270772,3.9489,0.771,5.1475}, /*cfy*/
          {-3.0536,0.01322,1069.7399,1.21018,0.032531,1.1851}, /*cmz*/
          {3.767803,5.3433,2.2037,0.3394} /*cfz*/
     },
     {
          2455539.4,
          {2.1741,0.01968,965.4039,1.29922,0.022341,1.1211}, /*cmx*/
          {5.89055,4.3431,4.1724,6.2639}, /*cfx*/
          {0.9391,0.00994,462.9219,0.66352,0.009503,0.5435}, /*cmy*/
          {5.97356,4.503,4.1677,0.0596}, /*cfy*/
          {-3.1023,0.02622,1069.8002,1.43669,0.024602,1.2457}, /*cmz*/
          {1.193642,5.9276,5.7694,1.5088} /*cfz*/
     },
     {
          2451179.3,
          {0.0908,0.05243,1703.0063,4.5589,0.028446,6.2885}, /*cmx*/
          {2.122546,0.5476,0.2132,4.1711}, /*cfx*/
          {-0.6515,0.02359,803.9969,2.11359,0.013644,2.9715}, /*cmy*/
          {2.200518,0.7441,0.0222,4.2481}, /*cfy*/
          {-20.9606,0.00271,1881.1649,5.10559,0.029227,6.928}, /*cmz*/
          {3.707964,2.1596,1.6884,5.7724} /*cfz*/
     },
     {
          2451219.3,
          {2.3545,0.07698,1701.9829,6.71014,0.014275,6.3084}, /*cmx*/
          {4.48468,2.9194,1.9229,2.7267}, /*cfx*/
          {0.3445,0.03503,807.5457,3.01056,0.011403,2.9726}, /*cmy*/
          {4.569049,2.9765,1.4859,2.8166}, /*cfy*/
          {-20.8038,0.01605,1881.2861,7.24978,0.019745,6.9821}, /*cmz*/
          {6.070563,4.5066,3.4717,4.3253} /*cfz*/
     },
     {
          2451259.3,
          {5.6765,0.06639,1707.015,7.40948,0.014171,6.3186}, /*cmx*/
          {0.530224,5.2827,3.4082,1.2577}, /*cfx*/
          {1.804,0.02682,795.7352,3.2225,0.013106,2.8793}, /*cmy*/
          {0.626887,5.1754,3.2502,1.3607}, /*cfy*/
          {-20.1229,0.02784,1881.3293,8.11222,0.016707,6.9182}, /*cmz*/
          {2.118415,0.5424,4.8892,2.8578} /*cfz*/
     },
     {
          2451299.3,
          {8.776,0.05684,1722.4014,7.17207,0.018416,6.3914}, /*cmx*/
          {2.854821,1.3328,4.9866,6.091}, /*cfx*/
          {3.0701,0.0146,766.2481,3.0165,0.012428,2.7574}, /*cmy*/
          {2.967726,1.038,4.9329,6.2113}, /*cfy*/
          {-19.2236,0.0521,1881.1903,7.79972,0.0226,6.9855}, /*cmz*/
          {4.444414,2.8645,0.3038,1.395} /*cfz*/
     },
     {
          2451339.3,
          {10.7922,0.0628,1740.8919,5.95741,0.030674,6.4518}, /*cmx*/
          {5.198147,3.695,0.6912,4.6593}, /*cfx*/
          {3.598,0.01542,723.0099,2.40167,0.014619,2.5728}, /*cmy*/
          {5.330407,3.2275,0.382,4.7983}, /*cfy*/
          {-17.536,0.04124,1880.7305,6.3957,0.034166,6.9977}, /*cmz*/
          {0.505065,5.2024,2.2239,6.2468} /*cfz*/
     },
     {
          2451379.3,
          {12.7996,0.01573,1757.2651,3.48101,0.047422,6.4864}, /*cmx*/
          {1.301246,6.0919,2.9535,3.2895}, /*cfx*/
          {3.9607,0.00471,682.7834,1.29455,0.01919,2.4723}, /*cmy*/
          {1.452861,5.4683,2.3924,3.4492}, /*cfy*/
          {-15.6653,-0.0024,1880.343,3.65673,0.050109,6.9221}, /*cmz*/
          {2.8917,1.3031,4.4558,4.8766} /*cfz*/
     },
     {
          2451419.3,
          {13.54,-0.02993,1763.3218,0.56528,0.043188,6.4455}, /*cmx*/
          {3.758693,5.4014,5.4591,1.9941}, /*cfx*/
          {4.0628,-0.00394,667.7897,0.33415,0.016895,2.4723}, /*cmy*/
          {3.923975,4.9757,4.9065,2.1581}, /*cfy*/
          {-14.9277,-0.04301,1879.1391,0.68484,0.045686,6.9344}, /*cmz*/
          {5.349791,0.5265,0.7067,3.5922} /*cfz*/
     },
     {
          2451459.3,
          {12.7817,-0.05118,1755.5971,4.24189,0.007173,6.4648}, /*cmx*/
          {0.019648,1.7037,4.5783,0.8049}, /*cfx*/
          {4.1164,-0.0194,689.4583,1.737,0.00453,2.6147}, /*cmy*/
          {0.182657,1.1788,3.8611,0.9556}, /*cfy*/
          {-16.9689,0.01079,1879.3652,4.61338,0.010532,6.9395}, /*cmz*/
          {1.61163,3.1736,5.6975,2.3651} /*cfz*/
     },
     {
          2451499.3,
          {10.6735,-0.00648,1741.268,3.35118,0.049073,6.4417}, /*cmx*/
          {2.602467,4.2675,1.1218,5.8307}, /*cfx*/
          {3.4084,0.00154,722.4112,1.25278,0.020833,2.7054}, /*cmy*/
          {2.750688,3.8025,0.7164,5.972}, /*cfy*/
          {-17.5153,-0.00651,1879.9547,3.61524,0.054545,6.909}, /*cmz*/
          {4.194677,5.7714,2.625,1.1367} /*cfz*/
     },
     {
          2451539.3,
          {9.8652,0.04248,1736.605,0.83163,0.045886,6.3928}, /*cmx*/
          {5.127949,3.6639,3.586,4.5193}, /*cfx*/
          {3.187,0.01774,732.5036,0.53872,0.01855,2.6677}, /*cmy*/
          {5.263159,3.4541,3.093,4.6543}, /*cfy*/
          {-17.8084,0.01317,1880.2148,0.97723,0.048914,6.9502}, /*cmz*/
          {0.435837,5.2019,5.0861,6.1043} /*cfz*/
     },
     {
          2451579.3,
          {11.2809,0.04378,1744.8938,4.47683,0.028321,6.4345}, /*cmx*/
          {1.277964,6.0837,5.7669,3.1184}, /*cfx*/
          {3.7982,0.00627,711.9149,2.01583,0.012535,2.5221}, /*cmy*/
          {1.410991,5.6678,4.8211,3.2616}, /*cfy*/
          {-16.9314,0.03105,1879.9009,4.87133,0.030972,6.8267}, /*cmz*/
          {2.867564,1.3255,0.8689,4.7016} /*cfz*/
     },
     {
          2451619.3,
          {13.1787,0.05724,1764.342,6.67372,0.017847,6.5473}, /*cmx*/
          {3.646025,2.181,1.1527,1.6775}, /*cfx*/
          {4.2441,0.00166,661.4488,2.80259,0.013402,2.3109}, /*cmy*/
          {3.78784,1.5889,0.1259,1.8322}, /*cfy*/
          {-15.5194,0.06234,1880.8838,7.09623,0.017837,6.8412}, /*cmz*/
          {5.233903,3.6608,2.697,3.2687} /*cfz*/
     },
     {
          2451659.3,
          {15.6876,0.04548,1792.1261,7.48445,0.01569,6.6262}, /*cmx*/
          {5.981684,4.5133,2.7747,0.2188}, /*cfx*/
          {4.3579,-0.00435,583.0122,3.08394,0.013307,1.9609}, /*cmy*/
          {6.144293,3.7176,1.9177,0.4065}, /*cfy*/
          {-12.9375,0.06584,1880.0883,7.99766,0.017203,6.8058}, /*cmz*/
          {1.285036,5.9983,4.0767,1.7997} /*cfz*/
     },
     {
          2451699.3,
          {17.9608,0.02338,1822.2955,7.41251,0.020469,6.7056}, /*cmx*/
          {2.029623,0.5421,4.307,5.0489}, /*cfx*/
          {4.1228,-0.01672,484.4286,3.03008,0.013324,1.6099}, /*cmy*/
          {2.227136,5.8448,3.6557,5.2778}, /*cfy*/
          {-10.2516,0.07522,1880.5823,7.67369,0.020534,6.876}, /*cmz*/
          {3.612856,2.0339,5.8091,0.3532} /*cfz*/
     },
     {
          2451739.3,
          {18.8753,0.03173,1846.1817,6.23397,0.032008,6.7764}, /*cmx*/
          {4.376712,2.872,6.1944,3.6165}, /*cfx*/
          {3.5123,-0.02145,381.8682,2.55151,0.013711,1.238}, /*cmy*/
          {4.628921,1.7087,5.2372,3.9039}, /*cfy*/
          {-7.7398,0.07274,1880.6492,6.42943,0.032631,6.8818}, /*cmz*/
          {5.957442,4.3703,1.3959,5.2059} /*cfz*/
     },
     {
          2451779.3,
          {19.5561,0.01714,1860.9992,3.69459,0.048495,6.7639}, /*cmx*/
          {0.480409,5.2462,2.1179,2.2494}, /*cfx*/
          {2.6017,-0.00176,301.2708,1.55354,0.020493,1.0312}, /*cmy*/
          {0.804474,3.9361,0.8286,2.5923}, /*cfy*/
          {-4.9668,0.00837,1880.3826,3.81254,0.049973,6.8556}, /*cmz*/
          {2.059123,0.4705,3.6179,3.8324} /*cfz*/
     },
     {
          2451819.3,
          {19.8203,0.00032,1864.9595,0.433,0.047064,6.8121}, /*cmx*/
          {2.936341,4.4033,4.6293,0.9565}, /*cfx*/
          {2.3256,0.01404,271.5148,0.21457,0.018574,1.0549}, /*cmy*/
          {3.303983,3.2701,3.3578,1.3237}, /*cfy*/
          {-3.9169,-0.04759,1880.0919,0.52912,0.046506,6.7938}, /*cmz*/
          {4.51374,6.0526,6.1226,2.542} /*cfz*/
     },
     {
          2451859.3,
          {20.4907,-0.05688,1859.459,4.36464,0.006866,6.6684}, /*cmx*/
          {5.477841,0.8343,3.0935,6.0325}, /*cfx*/
          {3.0927,0.00028,308.2762,1.8589,0.004735,1.2636}, /*cmy*/
          {5.801109,5.8733,2.1391,6.2807}, /*cfy*/
          {-5.7529,-0.02792,1880.6302,4.6164,0.008854,6.9623}, /*cmz*/
          {0.773253,2.3568,5.0298,1.3356} /*cfz*/
     },
     {
          2451899.3,
          {18.8263,-0.00145,1847.0761,3.59904,0.050567,6.7207}, /*cmx*/
          {1.776797,3.4369,0.2805,4.8002}, /*cfx*/
          {3.3835,0.00758,375.2095,1.4561,0.021087,1.4234}, /*cmy*/
          {2.034434,2.2185,5.4415,5.0386}, /*cfy*/
          {-7.6463,-0.00755,1880.3608,3.72177,0.053024,6.8867}, /*cmz*/
          {3.357468,4.9429,1.801,0.0882} /*cfz*/
     },
     {
          2451939.3,
          {18.2694,0.03022,1841.5395,0.71564,0.046887,6.7089}, /*cmx*/
          {4.304553,2.8716,2.7633,3.4829}, /*cfx*/
          {3.5262,-0.00165,400.0175,0.38001,0.019532,1.4023}, /*cmy*/
          {4.532815,2.2248,1.5525,3.7065}, /*cfy*/
          {-8.3784,0.03603,1880.491,0.76576,0.048396,6.8758}, /*cmz*/
          {5.885319,4.3649,4.2624,5.0691} /*cfz*/
     },
     {
          2451979.3,
          {19.0323,0.02076,1849.4317,4.48727,0.028616,6.6976}, /*cmx*/
          {0.459719,5.2713,4.842,2.0946}, /*cfx*/
          {3.2651,-0.01583,359.463,1.88119,0.014854,1.118}, /*cmy*/
          {0.69961,4.1737,3.3929,2.3635}, /*cfy*/
          {-6.7805,0.04405,1880.4214,4.58032,0.030618,6.8418}, /*cmz*/
          {2.038799,0.4865,0.1242,3.6686} /*cfz*/
     },
     {
          2452019.3,
          {19.9873,0.01026,1864.8658,6.62303,0.020689,6.8097}, /*cmx*/
          {2.834314,1.3356,0.2992,0.6717}, /*cfx*/
          {2.7116,-0.03671,268.1317,2.85625,0.012965,0.7614}, /*cmy*/
          {3.140454,0.0674,5.0242,1.0682}, /*cfy*/
          {-4.6202,0.07658,1881.1208,6.86579,0.016725,6.8101}, /*cmz*/
          {4.411283,2.8409,1.8469,2.2354} /*cfz*/
     },
     {
          2452059.3,
          {20.5533,0.0009,1878.3858,7.54499,0.016988,6.7985}, /*cmx*/
          {5.17746,3.6331,1.843,5.4996}, /*cfx*/
          {1.3427,-0.03446,148.9804,3.28037,0.013358,0.3328}, /*cmy*/
          {5.714981,2.2339,0.4495,0.2008}, /*cfy*/
          {-1.3371,0.0784,1880.4232,7.7004,0.016784,6.8336}, /*cmz*/
          {0.467876,5.1876,3.3731,0.7748} /*cfz*/
     },
     {
          2452099.3,
          {20.7839,-0.02287,1882.6657,7.42449,0.022441,6.8452}, /*cmx*/
          {1.230438,5.9351,3.4931,4.0523}, /*cfx*/
          {-0.2387,-0.02438,71.3365,3.21257,0.012102,0.3891}, /*cmy*/
          {2.959724,4.3805,2.1361,0.1431}, /*cfy*/
          {1.9993,0.07187,1881.9792,7.49607,0.019332,6.8242}, /*cmz*/
          {2.800769,1.2165,4.9441,5.6169} /*cfz*/
     },
     {
          2452139.3,
          {20.0745,-0.02012,1877.942,6.20078,0.032215,6.8465}, /*cmx*/
          {3.580531,1.9583,5.2934,2.6203}, /*cfx*/
          {-1.2789,-0.02565,152.4043,2.70062,0.014731,0.7427}, /*cmy*/
          {6.282806,0.2898,3.7032,5.4302}, /*cfy*/
          {4.442,0.07431,1881.8718,6.31609,0.032561,6.8202}, /*cmz*/
          {5.148957,3.5613,0.567,4.189} /*cfz*/
     },
     {
          2452179.3,
          {18.8531,0.01053,1869.1517,3.64148,0.049035,6.7959}, /*cmx*/
          {5.969302,4.3208,1.1874,1.2517}, /*cfx*/
          {-2.1549,-0.00895,236.1017,1.58479,0.02158,0.9246}, /*cmy*/
          {2.571243,2.5973,5.7238,4.1401}, /*cfy*/
          {6.9901,0.01569,1881.6151,3.71123,0.050332,6.7954}, /*cmz*/
          {1.253113,5.955,2.8204,2.8227} /*cfz*/
     },
     {
          2452219.3,
          {18.4749,0.03052,1863.9382,0.62657,0.045015,6.792}, /*cmx*/
          {2.143436,3.4941,3.7379,6.2553}, /*cfx*/
          {-2.3895,0.00526,265.1439,0.24774,0.020419,0.9386}, /*cmy*/
          {5.070406,1.5092,1.9388,2.8716}, /*cfy*/
          {7.9136,-0.03604,1882.0406,0.58815,0.04663,6.7896}, /*cmz*/
          {3.710361,5.3058,5.3024,1.5234} /*cfz*/
     },
     {
          2452259.3,
          {20.1914,-0.02692,1869.938,4.53496,0.010275,6.8709}, /*cmx*/
          {4.686785,6.2032,2.3916,5.0305}, /*cfx*/
          {-2.216,0.02486,224.5403,1.93907,0.00393,0.6363}, /*cmy*/
          {1.296437,4.4429,0.3009,1.5174}, /*cfy*/
          {6.9534,-0.05967,1882.1236,4.53239,0.007376,6.8015}, /*cmz*/
          {6.254722,1.5574,4.2526,0.3354} /*cfz*/
     },
     {
          2452299.3,
          {20.0864,0.00408,1877.3182,3.59962,0.051146,6.8191}, /*cmx*/
          {0.985847,2.5321,5.6621,3.7965}, /*cfx*/
          {-1.229,0.00469,151.85,1.61375,0.022161,0.4736}, /*cmy*/
          {3.753016,0.8347,3.994,0.251}, /*cfy*/
          {4.3588,-0.00366,1881.7184,3.6259,0.051058,6.8937}, /*cmz*/
          {2.554594,4.1375,0.9925,5.3705} /*cfz*/
     },
     {
          2452339.3,
          {20.0822,0.00328,1879.1033,0.70949,0.045738,6.8719}, /*cmx*/
          {3.512792,1.9952,1.8496,2.4857}, /*cfx*/
          {-0.9139,-0.01618,123.3211,0.27674,0.020259,0.497}, /*cmy*/
          {6.199541,0.5537,0.1693,5.2207}, /*cfy*/
          {3.4957,0.04582,1881.7705,0.73604,0.046005,6.8389}, /*cmz*/
          {5.082103,3.5543,3.4635,4.0594} /*cfz*/
     },
     {
          2452379.3,
          {19.7075,-0.00783,1875.7038,4.35311,0.028967,6.7977}, /*cmx*/
          {5.952904,4.3702,3.9232,1.094}, /*cfx*/
          {-1.5997,-0.01662,163.6503,1.90974,0.012883,0.7449}, /*cmy*/
          {2.495581,2.7076,2.0157,3.9902}, /*cfy*/
          {5.1662,0.0446,1881.6926,4.40053,0.028417,6.83}, /*cmz*/
          {1.238336,5.9626,5.6446,2.6722} /*cfz*/
     },
     {
          2452419.3,
          {19.2825,-0.042,1865.8735,6.44525,0.017906,6.7173}, /*cmx*/
          {2.048008,0.4181,5.7293,5.9609}, /*cfx*/
          {-2.393,-0.02451,256.2529,2.80292,0.01211,1.1189}, /*cmy*/
          {5.012468,4.9489,3.5573,2.6906}, /*cfy*/
          {7.4326,0.06195,1881.8657,6.58285,0.017204,6.8707}, /*cmz*/
          {3.615856,2.0536,1.0617,1.241} /*cfz*/
     },
     {
          2452459.3,
          {17.7384,-0.04946,1846.0344,7.35334,0.01584,6.6285}, /*cmx*/
          {4.394681,2.7403,0.8303,4.5025}, /*cfx*/
          {-3.3087,-0.01937,370.7417,3.10647,0.011699,1.548}, /*cmy*/
          {1.152631,0.8364,5.2601,1.2857}, /*cfy*/
          {10.2078,0.06542,1881.8391,7.39639,0.01472,6.8935}, /*cmz*/
          {5.961299,4.3942,2.6691,6.0737} /*cfz*/
     },
     {
          2452499.3,
          {15.82,-0.05536,1820.4742,7.06043,0.019477,6.5571}, /*cmx*/
          {0.449233,5.0601,2.5489,3.0634}, /*cfx*/
          {-4.1049,-0.00118,480.5905,2.98145,0.012201,1.9094}, /*cmy*/
          {3.534376,3.0051,0.6546,6.1659}, /*cfy*/
          {13.0155,0.04769,1883.0312,7.32494,0.020159,6.8924}, /*cmz*/
          {2.016768,0.4336,4.1042,4.6284} /*cfz*/
     },
     {
          2452539.3,
          {13.9176,-0.05273,1795.4107,5.87092,0.032124,6.5363}, /*cmx*/
          {2.801427,1.1105,4.3798,1.6372}, /*cfx*/
          {-4.3329,0.00539,568.5425,2.39975,0.014047,2.2052}, /*cmy*/
          {5.914142,5.1988,2.2811,4.7622}, /*cfy*/
          {14.6866,0.04958,1882.7249,6.08536,0.033749,6.8902}, /*cmz*/
          {4.369718,2.7847,6.0601,3.1999} /*cfz*/
     },
     {
          2452579.3,
          {11.692,0.00189,1776.6549,3.29028,0.048563,6.4841}, /*cmx*/
          {5.193306,3.5081,0.3698,0.2768}, /*cfx*/
          {-4.0576,-0.00598,623.3822,1.28698,0.020234,2.3279}, /*cmy*/
          {2.041521,1.2425,4.3203,3.4103}, /*cfy*/
          {16.1565,0.01634,1882.6436,3.36347,0.050222,6.858}, /*cmz*/
          {0.479601,5.1802,2.0446,1.8374} /*cfz*/
     },
     {
          2452619.3,
          {11.0329,0.04428,1771.0028,0.94769,0.040033,6.42}, /*cmx*/
          {1.372773,2.8338,2.8929,5.2751}, /*cfx*/
          {-3.9551,-0.01395,638.3341,0.50821,0.017411,2.2868}, /*cmy*/
          {4.515162,0.1755,0.6986,2.1404}, /*cfy*/
          {16.6119,-0.01461,1882.2761,0.90382,0.044699,6.9331}, /*cmz*/
          {2.944384,4.4629,4.5738,0.5507} /*cfz*/
     },
     {
          2452659.3,
          {12.853,0.0175,1781.3876,4.44688,0.011688,6.5967}, /*cmx*/
          {3.921916,5.4116,2.0135,4.0753}, /*cfx*/
          {-4.6178,0.01447,611.2421,1.95392,0.007433,2.1655}, /*cmy*/
          {0.783186,3.0831,5.5165,0.92}, /*cfy*/
          {16.6951,-0.06799,1882.2138,4.58914,0.011493,6.8475}, /*cmz*/
          {5.493278,0.7788,3.4928,5.6275} /*cfz*/
     },
     {
          2452699.3,
          {14.3148,0.00345,1796.6214,3.27608,0.048685,6.6209}, /*cmx*/
          {0.220377,1.6981,4.837,2.8177}, /*cfx*/
          {-4.3434,-5e-05,562.5259,1.41087,0.021062,2.0119}, /*cmy*/
          {3.358941,5.8248,2.6386,5.953}, /*cfy*/
          {14.4049,-0.00123,1882.5541,3.35958,0.049734,6.9031}, /*cmz*/
          {1.790975,3.3711,0.2226,4.395} /*cfz*/
     },
     {
          2452739.3,
          {14.7175,-0.02325,1802.3728,0.80909,0.042403,6.6234}, /*cmx*/
          {2.743665,1.1123,1.022,1.5091}, /*cfx*/
          {-4.2709,-0.00496,543.7899,0.35526,0.017774,2.0533}, /*cmy*/
          {5.87693,5.1722,5.0803,4.643}, /*cfy*/
          {13.7003,0.03971,1882.2221,0.86603,0.043533,6.9087}, /*cmz*/
          {4.313961,2.811,2.6783,3.0739} /*cfz*/
     },
     {
          2452779.3,
          {13.4252,-0.02657,1792.4755,4.17453,0.026248,6.5605}, /*cmx*/
          {5.182373,3.527,3.1872,0.1211}, /*cfx*/
          {-4.3267,-0.00112,574.584,1.78415,0.012231,2.2301}, /*cmy*/
          {2.035629,1.3201,0.6111,3.2502}, /*cfy*/
          {14.9031,0.03497,1882.2897,4.35977,0.02658,6.8568}, /*cmz*/
          {0.469606,5.1963,4.8466,1.6872} /*cfz*/
     },
     {
          2452819.3,
          {11.9006,-0.06154,1772.736,6.13025,0.014195,6.4333}, /*cmx*/
          {1.277866,5.8931,4.9838,4.9738}, /*cfx*/
          {-4.3583,0.01194,634.4612,2.58659,0.01024,2.4232}, /*cmy*/
          {4.425413,3.5552,2.2549,1.8409}, /*cfy*/
          {16.6903,0.03025,1882.455,6.38106,0.017293,6.8957}, /*cmz*/
          {2.849269,1.2865,0.3566,0.2683} /*cfz*/
     },
     {
          2452859.3,
          {9.427,-0.07238,1748.2187,6.90656,0.013182,6.3837}, /*cmx*/
          {3.62515,1.9724,0.0543,3.5173}, /*cfx*/
          {-3.8819,0.01747,697.5041,2.92951,0.010639,2.6634}, /*cmy*/
          {0.503603,5.7593,3.8679,0.3991}, /*cfy*/
          {18.2048,0.03408,1882.5764,7.24289,0.012714,6.9071}, /*cmz*/
          {5.198499,3.6227,1.8299,5.1025} /*cfz*/
     },
     {
          2452899.3,
          {6.5864,-0.06387,1728.0497,6.61756,0.017467,6.3054}, /*cmx*/
          {5.964082,4.3121,1.6177,2.073}, /*cfx*/
          {-3.126,0.02053,748.9819,2.77707,0.010234,2.802}, /*cmy*/
          {2.858059,1.6634,5.5638,5.2569}, /*cfy*/
          {19.6429,0.01593,1882.38,7.13987,0.021606,6.9136}, /*cmz*/
          {1.257794,5.9663,3.3465,3.6643} /*cfz*/
     },
     {
          2452939.3,
          {4.3702,-0.05975,1713.8333,5.41938,0.03266,6.2974}, /*cmx*/
          {2.036103,0.3996,3.6228,0.6563}, /*cfx*/
          {-2.4471,0.02398,781.3042,2.24226,0.014788,2.9094}, /*cmy*/
          {5.229036,3.8885,0.8866,3.8547}, /*cfy*/
          {20.2223,0.01417,1882.4443,5.76892,0.034894,6.9682}, /*cmz*/
          {3.615561,2.0296,5.2841,2.2367} /*cfz*/
     },
     {
          2452979.3,
          {2.1051,-0.00237,1706.6292,2.76558,0.047205,6.2482}, /*cmx*/
          {4.434056,2.8271,5.9709,5.5865}, /*cfx*/
          {-1.558,-0.00118,795.9072,1.04791,0.020642,2.9271}, /*cmy*/
          {1.357988,6.2531,3.0779,2.5164}, /*cfy*/
          {20.3578,0.013,1882.2409,2.92079,0.050992,6.9462}, /*cmz*/
          {6.016518,4.4265,1.2872,0.8834} /*cfz*/
     },
     {
          2453019.3,
          {1.6012,0.04287,1706.1738,1.30543,0.035314,6.2269}, /*cmx*/
          {0.62329,2.2025,2.1786,4.2959}, /*cfx*/
          {-1.4046,-0.02038,798.9375,0.75423,0.013982,2.8986}, /*cmy*/
          {3.840119,5.5021,5.7056,1.2325}, /*cfy*/
          {20.2976,0.01195,1880.8726,1.47296,0.038567,6.975}, /*cmz*/
          {2.207711,3.7004,3.9021,5.8977} /*cfz*/
     },
     {
          2453059.3,
          {3.0534,0.0463,1709.582,4.23584,0.013766,6.2375}, /*cmx*/
          {3.179229,4.7264,1.4437,3.1069}, /*cfx*/
          {-2.1989,-0.01185,791.5345,1.92763,0.00872,2.8627}, /*cmy*/
          {0.114299,1.9067,4.7362,0.0413}, /*cfy*/
          {21.2779,-0.04985,1881.7094,4.69567,0.01813,6.9953}, /*cmz*/
          {4.763006,0.0517,2.9444,4.6809} /*cfz*/
     },
     {
          2453099.3,
          {5.2374,0.00034,1715.9117,2.83756,0.046059,6.349}, /*cmx*/
          {5.757761,0.9988,4.1411,1.8525}, /*cfx*/
          {-2.8978,0.00038,776.0239,1.15902,0.020557,2.8541}, /*cmy*/
          {2.686227,4.5885,1.4042,5.0592}, /*cfy*/
          {20.0441,-0.00096,1881.9107,2.98365,0.049011,6.9302}, /*cmz*/
          {1.057415,2.6333,5.7699,3.4356} /*cfz*/
     },
     {
          2453139.3,
          {5.7507,-0.03724,1718.3905,1.02956,0.037959,6.3368}, /*cmx*/
          {1.991884,0.3902,0.3111,0.5334}, /*cfx*/
          {-3.0489,0.01401,770.3121,0.54671,0.016382,2.8617}, /*cmy*/
          {5.196324,3.8852,3.8019,3.7409}, /*cfy*/
          {19.6376,0.02178,1881.6419,1.1102,0.041773,6.9742}, /*cmz*/
          {3.573022,2.0659,1.9208,2.1131} /*cfz*/
     },
     {
          2453179.3,
          {4.1318,-0.03685,1712.9901,4.07612,0.02367,6.2722}, /*cmx*/
          {4.426652,2.8184,2.5316,5.4317}, /*cfx*/
          {-2.3713,0.01287,781.4911,1.8543,0.01113,2.9134}, /*cmy*/
          {1.347049,0.0287,5.7034,2.3542}, /*cfy*/
          {20.046,0.01784,1881.7468,4.4418,0.02602,6.9405}, /*cmz*/
          {6.008182,4.4541,4.068,0.7205} /*cfz*/
     },
     {
          2453219.3,
          {2.0637,-0.0608,1705.7785,5.88882,0.013156,6.262}, /*cmx*/
          {0.520794,5.2082,4.34,3.9985}, /*cfx*/
          {-1.596,0.02759,798.1655,2.62852,0.009483,2.9569}, /*cmy*/
          {3.730259,2.3065,0.9555,0.9297}, /*cfy*/
          {20.9217,-0.00756,1882.1177,6.37629,0.016379,6.8928}, /*cmz*/
          {2.103714,0.5352,5.9057,5.5823} /*cfz*/
     },
     {
          2453259.3,
          {-0.5072,-0.07528,1701.5262,6.60864,0.011132,6.3046}, /*cmx*/
          {2.868196,1.2996,5.7384,2.5456}, /*cfx*/
          {-0.4859,0.03394,806.7046,2.89152,0.010096,2.9854}, /*cmy*/
          {6.088312,4.5361,2.651,5.7719}, /*cfy*/
          {20.9386,-0.00886,1881.8412,7.2488,0.013116,6.9196}, /*cmz*/
          {4.453561,2.8759,0.9107,4.1327} /*cfz*/
     },
     {
          2453299.3,
          {-3.4682,-0.05876,1705.5318,6.42781,0.018714,6.338}, /*cmx*/
          {5.209878,3.65,0.8491,1.1038}, /*cfx*/
          {0.8225,0.02309,801.6827,2.74387,0.01114,2.9494}, /*cmy*/
          {2.160849,0.4457,4.1638,4.3485}, /*cfy*/
          {20.616,-0.0157,1881.1123,6.95119,0.021923,6.8564}, /*cmz*/
          {0.51401,5.2255,2.5923,2.6958} /*cfz*/
     },
     {
          2453339.3,
          {-5.5724,-0.052,1713.4885,5.11111,0.03453,6.3659}, /*cmx*/
          {1.286974,6.0353,2.965,5.9722}, /*cfx*/
          {1.7049,0.01618,784.1699,2.07351,0.015699,2.8781}, /*cmy*/
          {4.536783,2.6907,5.9954,2.9457}, /*cfy*/
          {20.0584,-0.01859,1881.5714,5.47436,0.036934,6.9627}, /*cmz*/
          {2.876245,1.2825,4.4966,1.2819} /*cfz*/
     },
     {
          2453379.3,
          {-7.4528,-0.00137,1721.4869,2.27086,0.046864,6.3371}, /*cmx*/
          {3.694093,2.1822,5.3227,4.6281}, /*cfx*/
          {2.3197,-0.00132,766.7715,0.80414,0.019568,2.8146}, /*cmy*/
          {0.675694,4.9925,1.8995,1.6166}, /*cfy*/
          {19.0795,0.00911,1880.6266,2.4339,0.051489,6.9395}, /*cmz*/
          {5.285378,3.7026,0.564,6.224} /*cfz*/
     },
     {
          2453419.3,
          {-7.5627,0.03256,1722.8836,1.70442,0.031845,6.3946}, /*cmx*/
          {6.178223,1.5374,1.5748,3.3485}, /*cfx*/
          {2.2384,-0.01031,764.8506,0.85194,0.012376,2.8636}, /*cmy*/
          {3.168758,4.4164,4.5788,0.3406}, /*cfy*/
          {18.8031,0.03383,1879.8875,2.06602,0.030777,6.8723}, /*cmz*/
          {1.486712,3.0256,3.1972,4.9593} /*cfz*/
     },
     {
          2453459.3,
          {-6.6208,0.0589,1715.7439,4.21237,0.018604,6.2748}, /*cmx*/
          {2.456056,4.0812,0.7856,2.1449}, /*cfx*/
          {1.9131,-0.02323,779.7917,1.80426,0.009823,2.8881}, /*cmy*/
          {5.727239,0.7564,3.6851,5.4117}, /*cfy*/
          {20.3471,-0.01568,1881.0661,4.68751,0.023298,6.9526}, /*cmz*/
          {4.048531,5.6391,2.3982,3.758} /*cfz*/
     },
     {
          2453499.3,
          {-4.3382,-0.00152,1709.6713,2.43208,0.04486,6.3115}, /*cmx*/
          {5.029649,0.3713,3.5134,0.9}, /*cfx*/
          {1.0002,0.00231,793.1771,0.90895,0.019633,2.938}, /*cmy*/
          {2.006964,3.3946,0.2748,4.155}, /*cfy*/
          {20.4117,-0.00164,1880.4313,2.57934,0.048839,6.9199}, /*cmz*/
          {0.33837,1.9032,5.0432,2.4908} /*cfz*/
     },
     {
          2453539.3,
          {-3.8693,-0.04225,1708.1078,1.31768,0.036269,6.3189}, /*cmx*/
          {1.255538,6.0492,5.9173,5.856}, /*cfx*/
          {0.8398,0.02043,794.5804,0.73414,0.01511,2.9192}, /*cmy*/
          {4.507237,2.8531,2.5619,2.8233}, /*cfy*/
          {20.2789,-0.00221,1880.827,1.44155,0.040533,6.9487}, /*cmz*/
          {2.845548,1.3061,1.1929,1.1653} /*cfz*/
     },
     {
          2453579.3,
          {-5.5099,-0.04192,1712.6676,4.24392,0.022761,6.2761}, /*cmx*/
          {3.685054,2.1706,1.8506,4.4626}, /*cfx*/
          {1.6543,0.01486,784.7068,1.95037,0.010414,2.8226}, /*cmy*/
          {0.652354,5.1663,4.3661,1.4323}, /*cfy*/
          {19.7096,-0.00345,1880.6605,4.66585,0.025342,6.9366}, /*cmz*/
          {5.274738,3.7187,3.3137,6.0551} /*cfz*/
     },
     {
          2453619.3,
          {-7.7759,-0.05205,1724.3565,5.99668,0.014227,6.3253}, /*cmx*/
          {6.059918,4.5586,3.6616,3.0343}, /*cfx*/
          {2.5799,0.01422,760.0086,2.61235,0.010199,2.6976}, /*cmy*/
          {3.033591,1.1267,5.9702,0.0165}, /*cfy*/
          {19.3818,-0.04143,1881.0326,6.54119,0.015635,6.8953}, /*cmz*/
          {1.366321,6.0796,5.0965,4.6208} /*cfz*/
     },
     {
          2453659.3,
          {-10.0501,-0.06775,1743.0889,6.73685,0.011188,6.4672}, /*cmx*/
          {2.124158,0.6342,5.0357,1.5851}, /*cfx*/
          {3.2216,0.01782,716.3144,2.82882,0.010526,2.5268}, /*cmy*/
          {5.394273,3.3141,1.366,4.8638}, /*cfy*/
          {18.027,-0.05226,1880.5652,7.33817,0.014892,6.9203}, /*cmz*/
          {3.713712,2.141,0.0966,3.1701} /*cfz*/
     },
     {
          2453699.3,
          {-12.6279,-0.04842,1766.9628,6.5514,0.022437,6.524}, /*cmx*/
          {4.468636,2.9859,0.2026,0.1551}, /*cfx*/
          {3.733,0.00871,656.3354,2.6338,0.01229,2.2839}, /*cmy*/
          {1.474572,5.491,3.0232,3.4642}, /*cfy*/
          {16.0277,-0.04165,1880.6596,6.86156,0.022112,6.8744}, /*cmz*/
          {6.056666,4.4761,1.7492,1.7245} /*cfz*/
     },
     {
          2453739.3,
          {-14.4105,-0.0344,1789.482,4.97008,0.037,6.6371}, /*cmx*/
          {0.551275,5.3535,2.2834,5.0255}, /*cfx*/
          {4.0396,-0.00459,593.0756,1.93918,0.015089,2.092}, /*cmy*/
          {3.86408,1.3848,4.6963,2.0702}, /*cfy*/
          {14.4589,-0.03917,1880.8036,5.26709,0.039979,6.9235}, /*cmz*/
          {2.139002,0.5426,3.7316,0.325} /*cfz*/
     },
     {
          2453779.3,
          {-15.6271,0.00112,1803.5602,1.89731,0.048353,6.6107}, /*cmx*/
          {2.967884,1.4902,4.6298,3.6893}, /*cfx*/
          {3.9399,-0.00282,549.5184,0.70798,0.019407,1.9969}, /*cmy*/
          {0.020274,3.6471,0.6134,0.7507}, /*cfy*/
          {12.8134,0.00786,1879.5924,1.9725,0.050864,6.892}, /*cmz*/
          {4.55492,2.9888,6.1318,5.2779} /*cfz*/
     },
     {
          2453819.3,
          {-15.3417,0.01441,1802.9622,2.19338,0.028013,6.666}, /*cmx*/
          {5.4617,0.8105,1.0173,2.4324}, /*cfx*/
          {3.7847,0.00555,549.3643,0.9682,0.009393,2.0745}, /*cmy*/
          {2.520838,3.148,3.4197,5.7738}, /*cfy*/
          {12.7655,0.04122,1880.1648,2.45289,0.025907,6.8492}, /*cmz*/
          {0.76561,2.3552,2.4107,4.004} /*cfz*/
     },
     {
          2453859.3,
          {-15.0721,0.05828,1790.5038,4.36845,0.025033,6.5897}, /*cmx*/
          {1.743039,3.4145,0.1339,1.215}, /*cfx*/
          {4.0853,-0.01099,590.1861,1.73822,0.011379,2.2789}, /*cmy*/
          {5.070912,5.7954,2.5836,4.5385}, /*cfy*/
          {14.4504,0.01887,1880.504,4.56369,0.025603,6.8081}, /*cmz*/
          {3.332242,4.9287,1.7391,2.815} /*cfz*/
     },
     {
          2453899.3,
          {-13.1125,-0.00215,1777.4362,2.11206,0.0459,6.5228}, /*cmx*/
          {4.3113,5.999,2.8545,6.2453}, /*cfx*/
          {3.7703,0.00231,628.7536,0.74193,0.018472,2.3294}, /*cmy*/
          {1.33651,2.0336,5.315,3.2642}, /*cfy*/
          {15.644,-0.0042,1879.7445,2.24476,0.050078,6.8839}, /*cmz*/
          {5.900283,1.1781,4.3229,1.5447} /*cfz*/
     },
     {
          2453939.3,
          {-12.7655,-0.03939,1775.2016,1.6871,0.037554,6.5467}, /*cmx*/
          {0.528213,5.3945,5.2086,4.9122}, /*cfx*/
          {3.734,0.00758,631.5087,0.80307,0.01546,2.2795}, /*cmy*/
          {3.826077,1.7278,1.2376,1.9281}, /*cfy*/
          {15.6698,-0.02784,1880.4481,1.86167,0.03888,6.8933}, /*cmz*/
          {2.116489,0.5617,0.4526,0.214} /*cfz*/
     },
     {
          2453979.3,
          {-14.1642,-0.0394,1787.7219,4.68943,0.023718,6.5648}, /*cmx*/
          {2.951453,1.4936,1.0572,3.508}, /*cfx*/
          {3.9353,0.00149,595.7798,1.97882,0.01209,2.0591}, /*cmy*/
          {6.252199,3.9248,3.0131,0.5316}, /*cfy*/
          {14.1373,-0.02695,1880.0442,4.9946,0.024548,6.8531}, /*cmz*/
          {4.538059,2.9804,2.5425,5.1016} /*cfz*/
     },
     {
          2454019.3,
          {-16.2667,-0.02884,1810.2547,6.46777,0.016207,6.6139}, /*cmx*/
          {5.322234,3.853,2.7957,2.0736}, /*cfx*/
          {4.1323,-0.01693,525.5576,2.70393,0.012191,1.7534}, /*cmy*/
          {2.357702,6.1107,4.6381,5.4097}, /*cfy*/
          {12.5189,-0.06444,1880.5028,6.813,0.015654,6.8536}, /*cmz*/
          {0.623399,5.3387,4.2319,3.6658} /*cfz*/
     },
     {
          2454059.3,
          {-17.7547,-0.03839,1835.8681,7.18521,0.01465,6.764}, /*cmx*/
          {1.384434,6.1785,4.1435,0.6292}, /*cfx*/
          {3.6313,-0.02148,427.4075,2.98185,0.01204,1.3644}, /*cmy*/
          {4.740756,1.9719,0.0969,4.0132}, /*cfy*/
          {10.1722,-0.08482,1880.3387,7.46777,0.01558,6.8875}, /*cmz*/
          {2.966048,1.3948,5.6195,2.2093} /*cfz*/
     },
     {
          2454099.3,
          {-19.0855,-0.02741,1857.6825,6.76031,0.025797,6.719}, /*cmx*/
          {3.728711,2.2269,5.8012,5.4775}, /*cfx*/
          {2.6274,-0.01401,316.5921,2.82412,0.011836,0.9641}, /*cmy*/
          {0.873442,4.1154,1.6209,2.6767}, /*cfy*/
          {7.0234,-0.05946,1881.0789,6.93848,0.024499,6.9065}, /*cmz*/
          {5.307204,3.7201,0.8881,0.7688} /*cfz*/
     },
     {
          2454139.3,
          {-20.0387,-0.00718,1872.5482,4.93563,0.03914,6.8399}, /*cmx*/
          {6.097524,4.5519,1.4644,4.0778}, /*cfx*/
          {1.9067,-0.0165,218.7282,2.12543,0.017197,0.6647}, /*cmy*/
          {3.371536,0.0404,3.2921,1.4209}, /*cfy*/
          {4.6826,-0.04323,1880.801,5.13672,0.042011,6.9138}, /*cmz*/
          {1.390538,6.0869,2.998,5.6501} /*cfz*/
     },
     {
          2454179.3,
          {-20.2512,0.00053,1877.517,1.66896,0.049985,6.8377}, /*cmx*/
          {2.236601,0.703,3.844,2.747}, /*cfx*/
          {1.293,-0.0002,163.4632,0.71879,0.021117,0.5839}, /*cmy*/
          {5.948966,2.403,5.5672,0.1957}, /*cfy*/
          {2.827,0.01163,1880.279,1.67315,0.050236,6.8474}, /*cmz*/
          {3.810744,2.2482,5.3869,4.3252} /*cfz*/
     },
     {
          2454219.3,
          {-19.913,-0.00842,1876.6178,2.64808,0.023282,6.8016}, /*cmx*/
          {4.735974,0.0221,0.3295,1.4967}, /*cfx*/
          {1.4357,0.01164,167.8189,1.0789,0.010291,0.6541}, /*cmy*/
          {2.151958,1.7907,1.9828,5.087}, /*cfy*/
          {3.2395,0.03562,1880.8911,2.59066,0.025686,6.9522}, /*cmz*/
          {0.027804,1.6163,1.6722,3.0579} /*cfz*/
     },
     {
          2454259.3,
          {-20.4466,0.03811,1871.8914,4.53773,0.030382,6.8329}, /*cmx*/
          {1.020156,2.6611,5.7216,0.2935}, /*cfx*/
          {1.9568,0.01556,224.1408,1.85027,0.011465,0.9348}, /*cmy*/
          {4.566601,4.4409,1.2677,3.8195}, /*cfy*/
          {4.6517,0.04587,1880.5518,4.5062,0.027795,6.8047}, /*cmz*/
          {2.596798,4.1768,0.9518,1.8511} /*cfz*/
     },
     {
          2454299.3,
          {-19.3557,-0.00262,1863.6927,1.87718,0.048476,6.7844}, /*cmx*/
          {3.584563,5.2192,2.0747,5.304}, /*cfx*/
          {2.5519,0.00031,278.7188,0.80949,0.020761,1.0289}, /*cmy*/
          {0.754758,0.6511,3.9384,2.4621}, /*cfy*/
          {6.6091,-0.00767,1880.7087,1.98363,0.051486,6.883}, /*cmz*/
          {5.161523,0.4563,3.6014,0.5915} /*cfz*/
     },
     {
          2454339.3,
          {-19.1807,-0.02184,1863.2386,2.08094,0.040122,6.8013}, /*cmx*/
          {6.076936,4.6146,4.4118,3.9674}, /*cfx*/
          {2.6364,-0.01731,278.1275,0.9119,0.017062,0.9207}, /*cmy*/
          {3.231522,0.3195,6.1769,1.1584}, /*cfy*/
          {6.6695,-0.0481,1880.624,2.25886,0.038381,6.8856}, /*cmz*/
          {1.371248,6.118,5.9422,5.5367} /*cfz*/
     },
     {
          2454379.3,
          {-19.7007,-0.02201,1871.339,5.24845,0.025008,6.8369}, /*cmx*/
          {2.209746,0.7024,0.1277,2.5561}, /*cfx*/
          {1.8905,-0.02037,216.5774,2.26419,0.013246,0.6036}, /*cmy*/
          {5.713854,2.5442,1.6213,6.1887}, /*cfy*/
          {4.4938,-0.04813,1880.5393,5.37261,0.02418,6.8154}, /*cmz*/
          {3.784953,2.2286,1.7219,4.1297} /*cfz*/
     },
     {
          2454419.3,
          {-20.7898,0.01439,1880.515,7.02962,0.01837,6.8687}, /*cmx*/
          {4.573656,3.028,1.7518,1.1152}, /*cfx*/
          {0.8908,-0.03311,115.8908,3.04445,0.013422,0.311}, /*cmy*/
          {2.099419,4.7396,3.2774,5.4871}, /*cfy*/
          {1.8512,-0.07044,1881.4026,7.12938,0.016129,6.7842}, /*cmz*/
          {6.146123,4.5775,3.3785,2.69} /*cfz*/
     },
     {
          2454459.3,
          {-20.7629,0.02163,1882.3413,7.60792,0.018632,6.8677}, /*cmx*/
          {0.629919,5.3239,3.2057,5.9475}, /*cfx*/
          {-0.3567,-0.03961,79.5345,3.32485,0.012269,0.4855}, /*cmy*/
          {5.94084,0.6072,4.8807,5.4213}, /*cfy*/
          {-0.8863,-0.09427,1881.5358,7.68334,0.015802,6.8628}, /*cmz*/
          {2.199815,0.6242,4.7769,1.2312} /*cfz*/
     },
     {
          2454499.3,
          {-19.8654,0.00996,1874.1964,6.89964,0.025719,6.7764}, /*cmx*/
          {2.969472,1.3454,4.9051,4.4976}, /*cfx*/
          {-1.8312,-0.02429,189.0207,3.03106,0.014083,0.8693}, /*cmy*/
          {2.650383,2.7889,0.1919,4.2208}, /*cfy*/
          {-4.224,-0.0672,1881.8205,7.08716,0.027104,6.8291}, /*cmz*/
          {4.537632,2.9565,0.1254,6.0803} /*cfz*/
     },
     {
          2454539.3,
          {-19.2474,0.01878,1861.5596,5.03415,0.04125,6.7628}, /*cmx*/
          {5.336085,3.6674,0.5638,3.0999}, /*cfx*/
          {-2.9076,-0.00829,291.5679,2.1303,0.017389,1.1787}, /*cmy*/
          {5.155304,5.0095,1.93,2.9491}, /*cfy*/
          {-6.8416,-0.03585,1881.88,5.10322,0.041711,6.8923}, /*cmz*/
          {0.619431,5.3227,2.2454,4.6771} /*cfz*/
     },
     {
          2454579.3,
          {-18.3847,-0.00465,1850.511,1.63718,0.050135,6.7496}, /*cmx*/
          {1.474134,6.125,2.9823,1.7761}, /*cfx*/
          {-3.2934,0.00056,348.0119,0.6855,0.021405,1.2848}, /*cmy*/
          {1.337557,1.1946,4.2252,1.6463}, /*cfy*/
          {-8.4808,0.013,1881.877,1.63766,0.050814,6.8307}, /*cmz*/
          {3.04023,1.4708,4.6096,3.3442} /*cfz*/
     },
     {
          2454619.3,
          {-18.518,-0.02146,1852.1115,2.70788,0.022388,6.7943}, /*cmx*/
          {3.97456,5.4799,5.6041,0.51}, /*cfx*/
          {-3.0492,0.00214,342.6478,1.16938,0.011537,1.1365}, /*cmy*/
          {3.843219,0.3253,0.8643,0.3891}, /*cfy*/
          {-7.8246,0.02173,1881.432,2.64609,0.026449,6.9409}, /*cmz*/
          {5.541629,0.8008,1.0183,2.0993} /*cfz*/
     },
     {
          2454659.3,
          {-19.5723,-0.00254,1862.843,4.51975,0.030342,6.7221}, /*cmx*/
          {0.260983,1.8008,4.912,5.6038}, /*cfx*/
          {-2.9846,0.02674,282.9853,2.01663,0.01354,0.9139}, /*cmy*/
          {0.103159,3.0821,6.0491,5.4359}, /*cfy*/
          {-6.9992,0.05896,1881.6569,4.63036,0.03156,6.9249}, /*cmz*/
          {1.828134,3.3973,0.147,0.8779} /*cfz*/
     },
     {
          2454699.3,
          {-19.9232,-8e-05,1869.3655,1.80932,0.052114,6.8203}, /*cmx*/
          {2.824617,4.3223,1.1863,4.3277}, /*cfx*/
          {-2.163,-0.00014,224.6838,0.8307,0.022627,0.8022}, /*cmy*/
          {2.625176,5.7114,2.6036,4.1371}, /*cfy*/
          {-4.814,-0.00834,1882.3439,1.83332,0.05258,6.9165}, /*cmz*/
          {4.39268,5.9879,2.8446,5.8998} /*cfz*/
     },
     {
          2454739.3,
          {-19.898,0.01438,1869.4809,2.42915,0.040246,6.7853}, /*cmx*/
          {5.312813,3.7068,3.5425,2.9847}, /*cfx*/
          {-2.0929,-0.02188,227.2807,1.04566,0.017586,0.9227}, /*cmy*/
          {5.12129,5.1796,4.7669,2.8364}, /*cfy*/
          {-4.8061,-0.0512,1881.1992,2.49882,0.040404,6.9213}, /*cmz*/
          {0.597988,5.3707,5.1175,4.559} /*cfz*/
     },
     {
          2454779.3,
          {-18.9077,0.01343,1859.3288,5.65751,0.024138,6.7411}, /*cmx*/
          {1.437948,6.0966,5.4628,1.5704}, /*cfx*/
          {-2.8134,-0.02498,294.9084,2.41926,0.013294,1.2807}, /*cmy*/
          {1.305707,1.155,0.1578,1.4798}, /*cfy*/
          {-6.928,-0.05669,1881.7662,5.69763,0.024732,6.8705}, /*cmz*/
          {3.00538,1.4479,0.8973,3.1367} /*cfz*/
     },
     {
          2454819.3,
          {-18.0589,0.05481,1839.8108,7.31191,0.017386,6.6603}, /*cmx*/
          {3.792565,2.1384,0.7669,0.13}, /*cfx*/
          {-3.9056,-0.00921,399.9397,3.12389,0.01288,1.676}, /*cmy*/
          {3.714962,3.3371,1.7071,0.0625}, /*cfy*/
          {-9.8479,-0.05412,1882.6532,7.46383,0.016463,6.8516}, /*cmz*/
          {5.359983,3.7894,2.4897,1.6832} /*cfz*/
     },
     {
          2454859.3,
          {-16.3764,0.07574,1812.4024,7.71436,0.017267,6.5731}, /*cmx*/
          {6.123301,4.4462,2.2472,4.9449}, /*cfx*/
          {-4.4835,-0.00162,510.9526,3.23406,0.013132,2.0615}, /*cmy*/
          {6.08232,5.4862,3.417,4.9174}, /*cfy*/
          {-12.2058,-0.0703,1882.7424,7.92866,0.016785,6.9088}, /*cmz*/
          {1.407911,6.1126,3.9311,0.2266} /*cfz*/
     },
     {
          2454899.3,
          {-13.6361,0.04761,1783.1886,6.94086,0.02505,6.488}, /*cmx*/
          {2.171989,0.4883,3.9508,3.4945}, /*cfx*/
          {-4.5166,-0.00169,604.9531,2.84264,0.012461,2.3549}, /*cmy*/
          {2.15728,1.36,5.0799,3.4812}, /*cfy*/
          {-14.5698,-0.0565,1882.4177,7.23337,0.027288,6.8206}, /*cmz*/
          {3.741342,2.1664,5.6845,5.0608} /*cfz*/
     },
     {
          2454939.3,
          {-11.518,0.03185,1760.1308,5.09294,0.040187,6.4653}, /*cmx*/
          {4.531518,2.8495,6.0436,2.0839}, /*cfx*/
          {-4.492,0.00664,669.4718,2.05482,0.017223,2.5452}, /*cmy*/
          {4.537241,3.5775,0.4751,2.0957}, /*cfy*/
          {-16.6416,-0.01951,1883.0071,5.23115,0.040153,6.8676}, /*cmz*/
          {6.102646,4.5132,1.4294,3.6621} /*cfz*/
     },
     {
          2454979.3,
          {-9.9731,-0.0089,1746.7687,1.81115,0.048951,6.3995}, /*cmx*/
          {0.66293,5.3053,2.162,0.7515}, /*cfx*/
          {-4.1634,-0.00464,701.3289,0.65172,0.020877,2.5805}, /*cmy*/
          {0.68319,6.0735,2.7964,0.7785}, /*cfy*/
          {-17.571,0.00689,1882.5173,1.87693,0.052411,6.8835}, /*cmz*/
          {2.236585,0.6609,3.8045,2.3229} /*cfz*/
     },
     {
          2455019.3,
          {-10.5148,-0.02106,1747.7338,2.33794,0.027497,6.5645}, /*cmx*/
          {3.159445,4.6575,4.7078,5.778}, /*cfx*/
          {-4.327,-0.00733,700.9856,1.16591,0.010235,2.5772}, /*cmy*/
          {3.18796,5.2223,5.6289,5.8032}, /*cfy*/
          {-17.1466,0.00633,1881.84,2.64264,0.026341,6.8777}, /*cmz*/
          {4.733683,6.2679,0.2448,1.0695} /*cfz*/
     },
     {
          2455059.3,
          {-11.5399,-0.04225,1759.5503,4.41148,0.027318,6.4516}, /*cmx*/
          {5.729453,0.9326,3.995,4.5583}, /*cfx*/
          {-4.7253,0.00129,670.279,1.94893,0.0135,2.3541}, /*cmy*/
          {5.75841,1.6898,4.6775,4.5822}, /*cfy*/
          {-16.9206,0.04621,1882.9444,4.80884,0.033367,6.9117}, /*cmz*/
          {1.019991,2.6082,5.6842,6.1539} /*cfz*/
     },
     {
          2455099.3,
          {-13.2062,0.00333,1772.0762,1.88975,0.053639,6.5445}, /*cmx*/
          {2.013328,3.486,0.3502,3.2996}, /*cfx*/
          {-4.818,0.00179,635.456,0.76131,0.022577,2.333}, /*cmy*/
          {2.03616,4.3597,1.1455,3.3213}, /*cfy*/
          {-15.2556,-0.00773,1882.6884,1.87563,0.054082,6.9401}, /*cmz*/
          {3.58708,5.1705,2.0271,4.8797} /*cfz*/
     },
     {
          2455139.3,
          {-13.2053,0.04111,1771.4879,2.52442,0.038266,6.5288}, /*cmx*/
          {4.502233,2.8631,2.6834,1.9513}, /*cfx*/
          {-4.8391,0.00641,637.1359,1.08539,0.016849,2.3923}, /*cmy*/
          {4.521145,3.6255,3.3615,1.9679}, /*cfy*/
          {-15.3412,-0.03281,1881.8334,2.52797,0.043593,6.8926}, /*cmz*/
          {6.07466,4.5572,4.3242,3.5387} /*cfz*/
     },
     {
          2455179.3,
          {-11.279,0.0467,1756.1345,5.62221,0.022611,6.427}, /*cmx*/
          {0.62208,5.2599,4.6738,0.5313}, /*cfx*/
          {-4.4038,0.0025,676.6675,2.43561,0.0122,2.5863}, /*cmy*/
          {0.645548,5.957,4.9648,0.5612}, /*cfy*/
          {-16.5535,-0.0438,1882.3407,5.92564,0.024459,6.9095}, /*cmz*/
          {2.195925,0.633,0.0719,2.1091} /*cfz*/
     },
     {
          2455219.3,
          {-8.9379,0.07129,1735.6116,7.17458,0.013944,6.2867}, /*cmx*/
          {2.969899,1.3221,6.2712,5.3614}, /*cfx*/
          {-4.0609,0.02353,730.1658,3.08836,0.012536,2.7367}, /*cmy*/
          {3.004152,1.8786,0.2909,5.4031}, /*cfy*/
          {-18.6561,-0.01661,1882.3695,7.67249,0.017298,6.9468}, /*cmz*/
          {4.546148,2.9782,1.6138,0.656} /*cfz*/
     },
     {
          2455259.3,
          {-6.3973,0.09362,1716.6647,7.53048,0.014589,6.2864}, /*cmx*/
          {5.294378,3.663,1.4189,3.8897}, /*cfx*/
          {-3.3343,0.03879,774.6205,3.23447,0.011804,2.8998}, /*cmy*/
          {5.343157,4.0402,2.0008,3.9459}, /*cfy*/
          {-19.8267,-0.01598,1882.5998,8.09557,0.017609,6.9472}, /*cmz*/
          {0.59023,5.2942,3.1363,5.4731} /*cfz*/
     },
     {
          2455299.3,
          {-3.1013,0.06747,1705.1036,6.85042,0.023263,6.2251}, /*cmx*/
          {1.337545,6.017,3.1997,2.4358}, /*cfx*/
          {-2.018,0.02717,799.6202,2.9117,0.012686,2.9355}, /*cmy*/
          {1.402589,6.2275,3.6303,2.5102}, /*cfy*/
          {-20.2624,-0.02272,1882.0118,7.3652,0.025286,6.9256}, /*cmz*/
          {2.919961,1.3421,4.9129,4.0138} /*cfz*/
     },
     {
          2455339.3,
          {-0.2757,0.03476,1702.2256,5.14834,0.036912,6.2925}, /*cmx*/
          {3.691195,2.1125,5.3329,1.0279}, /*cfx*/
          {-0.8144,0.0109,806.7387,2.10335,0.016788,2.9803}, /*cmy*/
          {3.772754,2.1852,5.4549,1.1173}, /*cfy*/
          {-20.8556,0.00338,1882.4982,5.53813,0.039979,6.9135}, /*cmz*/
          {5.276898,3.6774,0.5876,2.6032} /*cfz*/
     },
     {
          2455379.3,
          {1.4611,-0.0069,1703.1884,2.099,0.048108,6.2736}, /*cmx*/
          {6.098667,4.5466,1.4037,5.9616}, /*cfx*/
          {-0.16,-0.00593,804.739,0.72434,0.020668,2.9612}, /*cmy*/
          {6.195143,4.5502,1.4067,6.0642}, /*cfy*/
          {-20.7043,0.0005,1881.1267,2.26828,0.053746,6.9265}, /*cmz*/
          {1.404133,6.115,2.9782,1.2642} /*cfz*/
     },
     {
          2455419.3,
          {0.9616,-0.01742,1702.9834,1.99067,0.031586,6.2997}, /*cmx*/
          {2.304672,3.8576,4.0151,4.7138}, /*cfx*/
          {-0.5096,-0.00718,804.7655,1.03675,0.012344,2.9833}, /*cmy*/
          {2.410248,3.8538,4.2024,4.8194}, /*cfy*/
          {-20.7938,-0.00121,1881.2909,2.36947,0.029901,7.0181}, /*cmz*/
          {3.894256,5.4706,5.5601,6.2795} /*cfz*/
     },
     {
          2455459.3,
          {0.1409,-0.06062,1701.7431,4.47705,0.026907,6.3153}, /*cmx*/
          {4.871946,0.1575,3.1701,3.4904}, /*cfx*/
          {-0.9068,-0.02429,807.65,1.95076,0.013577,2.9955}, /*cmy*/
          {4.976413,0.2616,3.2111,3.585}, /*cfy*/
          {-20.9164,0.00706,1882.0585,4.83967,0.029323,6.8182}, /*cmz*/
          {0.179001,1.7817,4.8978,5.0766} /*cfz*/
     },
     {
          2455499.3,
          {-2.1259,0.00364,1703.0441,2.05488,0.052597,6.3156}, /*cmx*/
          {1.161354,2.746,5.8885,2.2302}, /*cfx*/
          {-1.8255,0.00283,806.194,0.75679,0.023303,2.9844}, /*cmy*/
          {1.256132,2.9462,6.0533,2.3207}, /*cfy*/
          {-20.5796,-0.00563,1881.1842,2.13015,0.056398,6.9397}, /*cmz*/
          {2.749721,4.3134,1.1744,3.8181} /*cfz*/
     },
     {
          2455539.3,
          {-2.0971,0.04284,1701.9586,2.27407,0.039163,6.2992}, /*cmx*/
          {3.65454,2.1326,1.9019,0.8934}, /*cfx*/
          {-1.8053,0.02254,805.0906,1.17059,0.016501,2.9878}, /*cmy*/
          {3.741828,2.2855,1.8993,0.9773}, /*cfy*/
          {-20.6971,-0.00124,1881.6216,2.45724,0.044093,6.8577}, /*cmz*/
          {5.240922,3.6893,3.5415,2.4684} /*cfz*/
     }

};

static unsigned idn_list[] = {2,149,296,406};
static double freq_list[] = {3.5516,1.7693,0.8782,0.3765};
static double delt_list[] = {30.0,30.0,40.0,40.0};

BDL_Dataset jupiter_9910 = {
     4, /*nsat*/
     2451179.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};

