#!/usr/bin/python
import sys

if len(sys.argv) != 2:
    sys.stderr.write("Usage:  %s 'Host Name'\n" % (sys.argv[0]))
    sys.exit(2)

## This is for the custom nagios module
sys.path.insert(1, '../')
from pynag.Parsers import config

target_host = sys.argv[1]

## Create the plugin option
nc = config('/etc/nagios/nagios.cfg')
#nc.parse()
nc.extended_parse()


host = nc.get_host(target_host)

if not host:
    sys.stderr.write("Host not found: %s\n" % host)
    sys.exit(2)

print nc.print_conf(host)
