#!/usr/bin/env python
#  pyNeighborhood -- SMB/CIFS Client
#  Copyright (C) 2008 Stefan J. Betz
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import sys
import subprocess
import stat
from distutils.core import setup

setup(name='pyneighborhood',
      version='0.5.1',
      description='Python SMB Browsing Tool',
      author='Mykola Lynnyk',
      author_email='pydefiner@gmail.com',
      maintainer='Stefan J. Betz',
      maintainer_email='info@stefan-betz.net',
      url='http://pyneighborhood.sourceforge.net',
      scripts=['pyNeighborhood'],
      packages=['pyneighborhood'],
      data_files=[('share/pyneighborhood/icons', 
                            ['icons/filemanager.png', 
                             'icons/groups.png', 
                             'icons/host.png', 
                             'icons/scan.png', 
                             'icons/share.png', 
                             'icons/workgroup.png', 
                             'icons/pyneighborhood.png']), 
                   ('share/doc/pyneighborhood/', ['README', 'Changelog']), 
                   ('share/applications/', ["pyNeighborhood.desktop"]), 
                   ('share/pyneighborhood', ['pyNeighborhood.glade', 'pyNeighborhood.gladep']),
                  ]
     )
