/**************************************************************************
 * Copyright 2009-2015 Olivier Belanger                                   *
 *                                                                        *
 * This file is part of pyo, a python module to help digital signal       *
 * processing script creation.                                            *
 *                                                                        *
 * pyo is free software: you can redistribute it and/or modify            *
 * it under the terms of the GNU Lesser General Public License as         *
 * published by the Free Software Foundation, either version 3 of the     *
 * License, or (at your option) any later version.                        *
 *                                                                        *
 * pyo is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 * GNU Lesser General Public License for more details.                    *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with pyo.  If not, see <http://www.gnu.org/licenses/>.   *
 *************************************************************************/

#include <Python.h>
#include "structmember.h"
#include <math.h>
#include "pyomodule.h"
#include "streammodule.h"
#include "servermodule.h"
#include "dummymodule.h"

static MYFLT ENVELOPE[8193] = {1.4706855888668713e-07, 5.882741490603749e-07, 1.323616510895409e-06, 2.3530952119044102e-06, 3.6767096464052074e-06, 5.2944590357983934e-06, 7.2063424284007915e-06, 9.4123586994454556e-06, 1.1912506551192692e-05, 1.470678451293006e-05, 1.779519094086135e-05, 2.117772401805107e-05, 2.4854381754757515e-05, 2.882516198804419e-05, 3.309006238200185e-05, 3.7649080427748505e-05, 4.2502213443262882e-05, 4.7649458573606474e-05, 5.3090812790757003e-05, 5.8826272893719445e-05, 6.4855835508526027e-05, 7.1179497088069699e-05, 7.7797253912381681e-05, 8.4709102088298405e-05, 9.1915037549794576e-05, 9.9415056057872153e-05, 0.00010720915320039381, 0.00011529732439236051, 0.00012367956487557841, 0.00013235586971915847, 0.00014132623381890586, 0.00015059065189787502, 0.00016014911850603664, 0.00017000162802038865, 0.00018014817464490074, 0.00019058875241068085, 0.00020132335517580868, 0.00021235197662539118, 0.00022367461027150704, 0.00023529124945342872, 0.00024720188733734494, 0.00025940651691652716, 0.00027190513101132963, 0.00028469772226913381, 0.00029778428316434846, 0.0003111648059985761, 0.00032483928290027997, 0.00033880770582522812, 0.00035307006655616036, 0.0003676263567027882, 0.0003824765677020725, 0.00039762069081805684, 0.00041305871714181208, 0.00042879063759154734, 0.00044481644291255451, 0.00046113612367731927, 0.00047774967028535453, 0.00049465707296331152, 0.00051185832176509072, 0.00052935340657156438, 0.00054714231709085404, 0.00056522504285821951, 0.00058360157323600337, 0.0006022718974137975, 0.00062123600440833204, 0.00064049388306353094, 0.00066004552205045641, 0.00067989090986741996, 0.00070003003483981585, 0.00072046288512034318, 0.00074118944868895031, 0.00076220971335261289, 0.00078352366674577789, 0.00080513129632991953, 0.00082703258939381685, 0.0008492275330535537, 0.00087171611425240769, 0.00089449831976090577, 0.00091757413617687966, 0.00094094354992541041, 0.00096460654725882833, 0.00098856311425687959, 0.0010128132368265041, 0.0010373569007020023, 0.0010621940914449235, 0.0010873247944441777, 0.0011127489949160907, 0.0011384666779041819, 0.0011644778282794976, 0.0011907824307402226, 0.0012173804698121238, 0.001244271929848273, 0.0012714567950290467, 0.0012989350493623486, 0.0013267066766834423, 0.0013547716606548965, 0.0013831299847668621, 0.0014117816323369614, 0.0014407265865100105, 0.0014699648302585189, 0.0014994963463823563, 0.0015293211175089194, 0.0015594391260930762, 0.001589850354417166, 0.0016205547845909996, 0.0016515523985519698, 0.0016828431780650521, 0.0017144271047225823, 0.0017463041599445894, 0.001778474324978685, 0.0018109375808998962, 0.0018436939086109994, 0.001876743288842242, 0.0019100857021515094, 0.001943721128924436, 0.0019776495493740165, 0.0020118709435411053, 0.0020463852912941394, 0.0020811925723291935, 0.0021162927661700914, 0.0021516858521682392, 0.0021873718095028472, 0.0022233506171807638, 0.0022596222540365307, 0.0022961866987325497, 0.0023330439297588601, 0.0023701939254333615, 0.0024076366639015911, 0.0024453721231369463, 0.0024834002809406841, 0.0025217211149418106, 0.0025603346025971918, 0.0025992407211914426, 0.0026384394478371487, 0.0026779307594746449, 0.0027177146328722923, 0.0027577910446262011, 0.0027981599711604521, 0.0028388213887270974, 0.0028797752734060489, 0.0029210216011051338, 0.0029625603475603168, 0.0030043914883353118, 0.0030465149988219697, 0.0030889308542401683, 0.0031316390296377006, 0.0031746394998904415, 0.003217932239702348, 0.0032615172236054035, 0.0033053944259596735, 0.0033495638209533607, 0.00339402538260275, 0.0034387790847522082, 0.003483824901074295, 0.0035291628050697632, 0.0035747927700674476, 0.0036207147692244313, 0.0036669287755259905, 0.0037134347617855945, 0.0037602327006450165, 0.0038073225645741671, 0.003854704325871372, 0.003902377956663039, 0.0039503434289041017, 0.0039986007143777424, 0.0040471497846953364, 0.0040959906112967848, 0.0041451231654502374, 0.0041945474182523146, 0.0042442633406280517, 0.0042942709033307325, 0.0043445700769422779, 0.004395160831873024, 0.0044460431383615551, 0.0044972169664753148, 0.0045486822861099951, 0.0046004390669898143, 0.004652487278667683, 0.0047048268905249269, 0.0047574578717714533, 0.0048103801914459177, 0.0048635938184154459, 0.0049170987213758011, 0.0049708948688514942, 0.0050249822291955071, 0.0050793607705897359, 0.0051340304610447141, 0.005188991268399612, 0.0052442431603224038, 0.0052997861043098116, 0.0053556200676874166, 0.0054117450176094928, 0.0054681609210592286, 0.0055248677448485051, 0.0055818654556182845, 0.0056391540198381107, 0.0056967334038067752, 0.0057546035736517065, 0.0058127644953293589, 0.0058712161346252678, 0.0059299584571537167, 0.0059889914283582368, 0.0060483150135111075, 0.0061079291777139111, 0.0061678338858971449, 0.0062280291028203871, 0.0062885147930722973, 0.0063492909210707826, 0.0064103574510628314, 0.0064717143471245131, 0.006533361573161145, 0.0065952990929072364, 0.0066575268699266554, 0.0067200448676122959, 0.0067828530491864658, 0.0068459513777007208, 0.0069093398160359198, 0.0069730183269022805, 0.0070369868728394347, 0.0071012454162163174, 0.0071657939192312226, 0.0072306323439119691, 0.0072957606521157903, 0.0073611788055293892, 0.0074268867656689386, 0.0074928844938800809, 0.0075591719513381506, 0.007625749099047896, 0.007692615897843702, 0.0077597723083895342, 0.00782721829117905, 0.0078949538065354874, 0.0079629788146117764, 0.0080312932753905386, 0.0080998971486841986, 0.0081687903941348727, 0.008237972971214369, 0.0083074448392244093, 0.008377205957296463, 0.008447256284391802, 0.0085175957793017787, 0.0085882244006473818, 0.0086591421068795693, 0.0087303488562793796, 0.0088018446069576539, 0.0088736293168553138, 0.00894570294374325, 0.0090180654452223785, 0.0090907167787237508, 0.0091636569015084435, 0.0092368857706676133, 0.0093104033431227196, 0.0093842095756251909, 0.0094583044247567027, 0.0095326878469291776, 0.0096073597983847847, 0.0096823202351959403, 0.0097575691132653075, 0.0098331063883260184, 0.0099089320159413408, 0.0099850459515050116, 0.010061448150241181, 0.010138138567204413, 0.010215117157279741, 0.010292383875182609, 0.01036993867545899, 0.010447781512485432, 0.010525912340468901, 0.010604331113447163, 0.010683037785288452, 0.010762032309691583, 0.010841314640186228, 0.010920884730132474, 0.01100074253272143, 0.011080888000974787, 0.011161321087745035, 0.011242041745715414, 0.01132304992740002, 0.01140434558514386, 0.011485928671122803, 0.011567799137343682, 0.011649956935644135, 0.011732402017692822, 0.01181513433498943, 0.011898153838864722, 0.011981460480480488, 0.012065054210829484, 0.01214893498073577, 0.012233102740854374, 0.012317557441671512, 0.012402299033504816, 0.01248732746650294, 0.012572642690645786, 0.012658244655744666, 0.012744133311442085, 0.012830308607212071, 0.012916770492359841, 0.013003518916022083, 0.013090553827166951, 0.013177875174594067, 0.013265482906934467, 0.013353376972650877, 0.013441557320037434, 0.013530023897219967, 0.013618776652155773, 0.013707815532633894, 0.013797140486275117, 0.013886751460531865, 0.013976648402688308, 0.014066831259860357, 0.014157299978995785, 0.014248054506874108, 0.014339094790106921, 0.014430420775137454, 0.014522032408241015, 0.01461392963552488, 0.014706112402928184, 0.014798580656222249, 0.01489133434101042, 0.014984373402728013, 0.015077697786642585, 0.015171307437853832, 0.015265202301293468, 0.015359382321725734, 0.015453847443746949, 0.015548597611785564, 0.015643632770102667, 0.015738952862791311, 0.015834557833777407, 0.015930447626818833, 0.016026622185506101, 0.0161230814532623, 0.016219825373342822, 0.016316853888835747, 0.016414166942661734, 0.016511764477573965, 0.016609646436158365, 0.016707812760833496, 0.016806263393850551, 0.016904998277293748, 0.017004017353079715, 0.017103320562958213, 0.017202907848511639, 0.017302779151155356, 0.017402934412137638, 0.017503373572539838, 0.017604096573276107, 0.017705103355093676, 0.017806393858572911, 0.017907968024127086, 0.018009825792002943, 0.01811196710228008, 0.018214391894871396, 0.018317100109523032, 0.018420091685814322, 0.018523366563158061, 0.018626924680800294, 0.018730765977820418, 0.018834890393131298, 0.01893929786547921, 0.019043988333443895, 0.01914896173543873, 0.0192542180097105, 0.01935975709433968, 0.019465578927240379, 0.019571683446160226, 0.019678070588680707, 0.019784740292217107, 0.019891692494018287, 0.019998927131167077, 0.020106444140580049, 0.020214243459007741, 0.020322325023034604, 0.020430688769079053, 0.020539334633393469, 0.020648262552064256, 0.02075747246101195, 0.020866964295991164, 0.020976737992590755, 0.021086793486233546, 0.021197130712176881, 0.021307749605512072, 0.021418650101164893, 0.021529832133895588, 0.021641295638298474, 0.021753040548802505, 0.021865066799670985, 0.021977374325001797, 0.022089963058727291, 0.022202832934614447, 0.022315983886264878, 0.022429415847114664, 0.022543128750434793, 0.022657122529330831, 0.022771397116743253, 0.022885952445447222, 0.023000788448052756, 0.023115905057004893, 0.023231302204583415, 0.023346979822903069, 0.0234629378439139, 0.023579176199400698, 0.023695694820983382, 0.023812493640117116, 0.023929572588092085, 0.024046931596033827, 0.024164570594903068, 0.024282489515495831, 0.024400688288443384, 0.024519166844212514, 0.024637925113105197, 0.024756963025259149, 0.024876280510647386, 0.0249958774990785, 0.025115753920196715, 0.025235909703481663, 0.02535634477824894, 0.025477059073649722, 0.025598052518670811, 0.025719325042134866, 0.025840876572700511, 0.025962707038861887, 0.026084816368949493, 0.026207204491129454, 0.026329871333404031, 0.026452816823611447, 0.026576040889425945, 0.026699543458358233, 0.026823324457754705, 0.026947383814798331, 0.027071721456508102, 0.02719633730973936, 0.027321231301183857, 0.027446403357369697, 0.027571853404661395, 0.027697581369259927, 0.02782358717720268, 0.02794987075436367, 0.028076432026453657, 0.028203270919019807, 0.028330387357446141, 0.028457781266953308, 0.028585452572598702, 0.028713401199276567, 0.028841627071718112, 0.028970130114491344, 0.029098910252001176, 0.029227967408489652, 0.029357301508035616, 0.029486912474555371, 0.029616800231801965, 0.029746964703365852, 0.029877405812674618, 0.030008123482993088, 0.030139117637423329, 0.030270388198905041, 0.030401935090215049, 0.030533758233967756, 0.030665857552614972, 0.030798232968445916, 0.030930884403587822, 0.031063811780005113, 0.031197015019500007, 0.031330494043712576, 0.031464248774120462, 0.031598279132039164, 0.031732585038622252, 0.03186716641486087, 0.032002023181584349, 0.032137155259459871, 0.032272562568992635, 0.032408245030526195, 0.032544202564241953, 0.032680435090159665, 0.032816942528137105, 0.03295372479787062, 0.033090781818894521, 0.033228113510581914, 0.033365719792143977, 0.033503600582630577, 0.033641755800929929, 0.033780185365768767, 0.033918889195712787, 0.034057867209165926, 0.034197119324371084, 0.034336645459409842, 0.034476445532202415, 0.034616519460508144, 0.034756867161925165, 0.034897488553890521, 0.035038383553680219, 0.035179552078409393, 0.035320994045032195, 0.035462709370342127, 0.035604697970971544, 0.035746959763392261, 0.035889494663915333, 0.036032302588691112, 0.036175383453709409, 0.036318737174799443, 0.036462363667629949, 0.036606262847709126, 0.036750434630384798, 0.03689487893084431, 0.037039595664114966, 0.037184584745063642, 0.037329846088396901, 0.037475379608661263, 0.037621185220243103, 0.037767262837368643, 0.037913612374104455, 0.038060233744356631, 0.038207126861871721, 0.038354291640236238, 0.038501727992876822, 0.038649435833060686, 0.038797415073895059, 0.038945665628327464, 0.039094187409145997, 0.039242980328979105, 0.039392044300295637, 0.039541379235405294, 0.039690985046458072, 0.039840861645444758, 0.039991008944196771, 0.04014142685438632, 0.040292115287526464, 0.040443074154971115, 0.04059430336791503, 0.04074580283739393, 0.040897572474284605, 0.041049612189304752, 0.041201921893013582, 0.041354501495811047, 0.041507350907938556, 0.041660470039478703, 0.04181385880035543, 0.04196751710033414, 0.042121444849021639, 0.042275641955866139, 0.042430108330157423, 0.042584843881027012, 0.042739848517447721, 0.042895122148234655, 0.043050664682044215, 0.043206476027374596, 0.043362556092566173, 0.043518904785800894, 0.043675522015103052, 0.043832407688338626, 0.043989561713215886, 0.044146983997285116, 0.044304674447938897, 0.04446263297241182, 0.044620859477781216, 0.044779353870966432, 0.044938116058729216, 0.045097145947673944, 0.045256443444247285, 0.04541600845473881, 0.045575840885280494, 0.045735940641846939, 0.045896307630255706, 0.04605694175616698, 0.046217842925083685, 0.046379011042352092, 0.046540446013160985, 0.046702147742542333, 0.046864116135371225, 0.04702635109636577, 0.047188852530087366, 0.047351620340940648, 0.047514654433173376, 0.047677954710876935, 0.047841521077985893, 0.048005353438278331, 0.048169451695376009, 0.048333815752744091, 0.048498445513691479, 0.048663340881370643, 0.048828501758777842, 0.04899392804875341, 0.049159619653981135, 0.049325576476989041, 0.049491798420148891, 0.049658285385676626, 0.049825037275632145, 0.04999205399191986, 0.050159335436288033, 0.050326881510329269, 0.050494692115480522, 0.050662767153023036, 0.050831106524082847, 0.050999710129630116, 0.051168577870479626, 0.051337709647290897, 0.051507105360568073, 0.051676764910659867, 0.051846688197760227, 0.052016875121907447, 0.052187325582985, 0.052358039480721263, 0.052529016714689625, 0.052700257184308652, 0.052871760788841982, 0.053043527427398374, 0.053215556998932045, 0.053387849402242393, 0.053560404535974104, 0.053733222298617711, 0.053906302588508759, 0.054079645303828694, 0.054253250342604364, 0.054427117602708353, 0.054601246981859253, 0.054775638377621061, 0.054950291687403896, 0.055125206808463667, 0.055300383637902295, 0.055475822072667713, 0.0556515220095542, 0.055827483345201878, 0.056003705976097273, 0.056180189798573088, 0.056356934708808371, 0.056533940602828903, 0.056711207376506478, 0.056888734925559736, 0.05706652314555366, 0.057244571931900079, 0.057422881179857443, 0.057601450784531105, 0.05778028064087315, 0.057959370643682562, 0.058138720687605283, 0.058318330667134155, 0.058498200476609585, 0.058678330010218605, 0.058858719161995698, 0.059039367825822531, 0.059220275895428165, 0.059401443264388953, 0.059582869826129037, 0.059764555473919623, 0.059946500100879874, 0.060128703599976352, 0.060311165864023353, 0.060493886785683237, 0.060676866257465933, 0.060860104171729268, 0.061043600420679134, 0.061227354896369435, 0.061411367490701974, 0.061595638095427174, 0.061780166602143194, 0.061964952902296755, 0.062149996887182757, 0.062335298447944554, 0.062520857475574176, 0.062706673860911943, 0.062892747494646906, 0.063079078267316624, 0.063265666069307613, 0.063452510790854899, 0.063639612322042849, 0.063826970552804285, 0.064014585372921151, 0.06420245667202451, 0.064390584339594492, 0.064578968264960568, 0.064767608337301219, 0.064956504445644325, 0.06514565647886722, 0.06533506432569669, 0.065524727874708755, 0.065714647014329552, 0.065904821632834398, 0.066095251618348394, 0.066285936858846595, 0.066476877242153676, 0.066668072655944433, 0.066859522987743503, 0.067051228124925588, 0.067243187954715511, 0.067435402364188213, 0.067627871240268811, 0.067820594469732987, 0.068013571939206652, 0.068206803535166005, 0.068400289143937976, 0.068594028651699779, 0.068788021944479749, 0.068982268908156397, 0.06917676942845935, 0.06937152339096897, 0.069566530681116401, 0.069761791184183908, 0.06995730478530493, 0.070153071369463693, 0.070349090821495874, 0.070545363026088159, 0.070741887867778575, 0.070938665230956932, 0.071135694999863941, 0.071332977058592206, 0.071530511291085674, 0.071728297581140077, 0.071926335812402709, 0.072124625868373093, 0.072323167632401986, 0.072521960987692591, 0.072721005817299789, 0.072920302004130577, 0.073119849430944295, 0.073319647980352287, 0.073519697534818185, 0.073719997976658014, 0.073920549188040141, 0.074121351050985385, 0.074322403447367402, 0.074523706258912137, 0.074725259367198316, 0.07492706265365745, 0.075129115999573726, 0.075331419286084611, 0.075533972394180193, 0.075736775204703677, 0.075939827598351439, 0.07614312945567292, 0.076346680657070787, 0.07655048108280138, 0.076754530612973992, 0.076958829127551587, 0.077163376506350523, 0.077368172629040832, 0.077573217375146442, 0.077778510624044672, 0.077984052254966796, 0.078189842146997979, 0.078395880179077337, 0.078602166229997883, 0.078808700178407076, 0.079015481902806162, 0.079222511281550834, 0.079429788192851014, 0.079637312514770908, 0.079845084125229615, 0.080053102902000239, 0.08026136872271078, 0.080469881464843684, 0.080678641005736407, 0.080887647222580961, 0.081096899992424532, 0.081306399192169088, 0.081516144698571547, 0.081726136388244053, 0.081936374137653867, 0.082146857823123698, 0.082357587320831316, 0.082568562506809995, 0.082779783256948458, 0.082991249446990989, 0.083202960952537375, 0.083414917649043407, 0.083627119411820272, 0.083839566116035213, 0.084052257636711258, 0.084265193848727327, 0.084478374626818842, 0.084691799845576843, 0.084905469379448872, 0.085119383102738533, 0.085333540889605985, 0.085547942614067507, 0.085762588149996433, 0.085977477371122157, 0.086192610151030857, 0.08640798636316549, 0.086623605880825794, 0.086839468577168233, 0.087055574325206608, 0.08727192299781128, 0.087488514467709944, 0.087705348607487466, 0.087922425289585715, 0.088139744386304286, 0.088357305769799943, 0.088575109312086897, 0.088793154885036862, 0.089011442360379278, 0.089229971609701197, 0.089448742504447676, 0.089667754915921272, 0.089887008715282712, 0.090106503773550561, 0.090326239961601495, 0.090546217150170527, 0.090766435209850671, 0.090986894011093278, 0.0912075934242082, 0.091428533319363625, 0.091649713566586077, 0.091871134035761304, 0.09209279459663311, 0.092314695118804413, 0.0925368354717368, 0.092759215524750638, 0.092981835147025793, 0.093204694207600802, 0.093427792575373259, 0.093651130119100312, 0.09387470670739817, 0.094098522208742263, 0.094322576491468135, 0.094546869423770163, 0.094771400873702671, 0.094996170709179539, 0.095221178797974315, 0.095446425007720881, 0.095671909205912509, 0.095897631259902694, 0.096123591036904876, 0.096349788403992886, 0.096576223228100333, 0.096802895376021825, 0.09702980471441186, 0.097256951109785494, 0.097484334428518282, 0.097711954536846446, 0.097939811300867152, 0.098167904586537957, 0.098396234259677584, 0.098624800185965478, 0.098853602230942195, 0.099082640260009347, 0.09931191413842988, 0.099541423731327849, 0.099771168903688645, 0.1000011495203591, 0.10023136544604749, 0.10046181654532382, 0.10069250268261959, 0.10092342372222812, 0.10115457952830453, 0.10138596996486571, 0.10161759489579059, 0.10184945418482044, 0.10208154769555827, 0.1023138752914694, 0.1025464368358816, 0.1027792321919847, 0.10301226122283141, 0.10324552379133672, 0.10347901976027818, 0.10371274899229621, 0.10394671134989392, 0.10418090669543706, 0.10441533489115495, 0.10464999579913919, 0.10488488928134504, 0.10512001519959058, 0.10535537341555712, 0.10559096379078986, 0.10582678618669689, 0.10606284046454995, 0.10629912648548434, 0.10653564411049921, 0.10677239320045712, 0.10700937361608492, 0.10724658521797303, 0.10748402786657602, 0.10772170142221243, 0.10795960574506497, 0.10819774069518084, 0.10843610613247134, 0.10867470191671219, 0.10891352790754361, 0.10915258396447036, 0.10939186994686195, 0.10963138571395276, 0.1098711311248417, 0.11011110603849283, 0.11035131031373496, 0.11059174380926196, 0.1108324063836334, 0.11107329789527348, 0.1113144182024719, 0.11155576716338383, 0.11179734463602992, 0.11203915047829616, 0.11228118454793473, 0.11252344670256309, 0.11276593679966462, 0.11300865469658872, 0.11325160025055042, 0.1134947733186315, 0.11373817375777939, 0.11398180142480779, 0.11422565617639691, 0.1144697378690932, 0.1147140463593096, 0.11495858150332605, 0.11520334315728853, 0.11544833117721021, 0.11569354541897092, 0.11593898573831729, 0.11618465199086331, 0.11643054403208986, 0.11667666171734481, 0.1169230049018436, 0.11716957344066886, 0.11741636718877052, 0.11766338600096643, 0.11791062973194166, 0.11815809823624912, 0.11840579136830942, 0.11865370898241101, 0.11890185093271055, 0.11915021707323237, 0.11939880725786911, 0.11964762134038159, 0.1198966591743989, 0.12014592061341828, 0.12039540551080602, 0.12064511371979636, 0.12089504509349241, 0.12114519948486602, 0.12139557674675766, 0.12164617673187716, 0.12189699929280273, 0.12214804428198212, 0.12239931155173178, 0.12265080095423786, 0.12290251234155541, 0.12315444556560934, 0.1234066004781938, 0.12365897693097239, 0.12391157477547871, 0.12416439386311573, 0.12441743404515682, 0.12467069517274471, 0.12492417709689252, 0.12517787966848332, 0.12543180273827048, 0.12568594615687734, 0.1259403097747982, 0.12619489344239743, 0.12644969700990999, 0.12670472032744146, 0.12695996324496805, 0.12721542561233729, 0.12747110727926703, 0.12772700809534637, 0.12798312791003541, 0.12823946657266555, 0.12849602393243914, 0.12875279983843035, 0.12900979413958452, 0.12926700668471841, 0.12952443732252056, 0.12978208590155094, 0.1300399522702419, 0.13029803627689718, 0.13055633776969244, 0.1308148565966758, 0.13107359260576712, 0.13133254564475855, 0.1315917155613151, 0.13185110220297347, 0.13211070541714331, 0.13237052505110669, 0.13263056095201819, 0.13289081296690586, 0.13315128094266987, 0.13341196472608363, 0.13367286416379365, 0.13393397910231941, 0.13419530938805369, 0.13445685486726289, 0.1347186153860862, 0.13498059079053693, 0.13524278092650155, 0.13550518563974023, 0.1357678047758874, 0.13603063818045069, 0.13629368569881217, 0.13655694717622757, 0.13682042245782711, 0.13708411138861482, 0.13734801381346962, 0.13761212957714442, 0.13787645852426655, 0.13814100049933831, 0.13840575534673627, 0.13867072291071214, 0.13893590303539238, 0.13920129556477817, 0.139466900342746, 0.13973271721304747, 0.13999874601930917, 0.1402649866050335, 0.14053143881359781, 0.14079810248825519, 0.1410649774721342, 0.14133206360823913, 0.14159936073945023, 0.1418668687085235, 0.1421345873580907, 0.14240251653066005, 0.14267065606861556, 0.14293900581421759, 0.14320756560960324, 0.14347633529678538, 0.14374531471765384, 0.14401450371397506, 0.14428390212739173, 0.14455350979942416, 0.14482332657146885, 0.14509335228479958, 0.14536358678056727, 0.14563402989979979, 0.1459046814834023, 0.14617554137215782, 0.14644660940672627, 0.1467178854276453, 0.14698936927533024, 0.14726106079007389, 0.14753295981204756, 0.14780506618129985, 0.14807737973775759, 0.14834990032122575, 0.14862262777138746, 0.14889556192780407, 0.14916870262991577, 0.14944204971704073, 0.14971560302837589, 0.14998936240299693, 0.15026332767985806, 0.15053749869779293, 0.1508118752955136, 0.15108645731161141, 0.1513612445845568, 0.15163623695269957, 0.15191143425426851, 0.15218683632737257, 0.15246244300999962, 0.15273825414001729, 0.15301426955517311, 0.15329048909309406, 0.15356691259128769, 0.15384353988714095, 0.15412037081792118, 0.15439740522077589, 0.15467464293273281, 0.15495208379070002, 0.15522972763146659, 0.15550757429170148, 0.15578562360795484, 0.15606387541665734, 0.15634232955412042, 0.15662098585653705, 0.15689984415998071, 0.15717890430040632, 0.15745816611364988, 0.15773762943542896, 0.15801729410134224, 0.15829715994687066, 0.15857722680737601, 0.15885749451810227, 0.1591379629141752, 0.15941863183060229, 0.15969950110227349, 0.15998057056396053, 0.16026184005031752, 0.16054330939588085, 0.16082497843506938, 0.16110684700218425, 0.16138891493140983, 0.16167118205681258, 0.16195364821234209, 0.1622363132318308, 0.16251917694899398, 0.16280223919743048, 0.16308549981062198, 0.16336895862193357, 0.16365261546461363, 0.16393647017179425, 0.16422052257649078, 0.16450477251160289, 0.16478921980991351, 0.16507386430408955, 0.16535870582668211, 0.16564374421012595, 0.16592897928674077, 0.1662144108887299, 0.16650003884818132, 0.16678586299706744, 0.16707188316724531, 0.16735809919045641, 0.1676445108983276, 0.16793111812237005, 0.16821792069398017, 0.16850491844443938, 0.16879211120491411, 0.16907949880645656, 0.16936708108000392, 0.1696548578563789, 0.16994282896628987, 0.17023099424033078, 0.17051935350898134, 0.17080790660260747, 0.17109665335146074, 0.17138559358567879, 0.17167472713528559, 0.17196405383019114, 0.17225357350019233, 0.17254328597497198, 0.17283319108409978, 0.17312328865703203, 0.17341357852311173, 0.17370406051156873, 0.17399473445152025, 0.17428560017197015, 0.17457665750180962, 0.17486790626981713, 0.17515934630465835, 0.17545097743488702, 0.17574279948894378, 0.17603481229515738, 0.17632701568174403, 0.17661940947680815, 0.1769119935083418, 0.17720476760422565, 0.17749773159222804, 0.17779088530000592, 0.17808422855510436, 0.17837776118495707, 0.17867148301688657, 0.17896539387810378, 0.17925949359570847, 0.17955378199668942, 0.17984825890792427, 0.18014292415617972, 0.18043777756811213, 0.18073281897026666, 0.18102804818907803, 0.18132346505087055, 0.18161906938185784, 0.18191486100814391, 0.18221083975572194, 0.18250700545047532, 0.18280335791817737, 0.18309989698449153, 0.18339662247497135, 0.18369353421506124, 0.18399063203009552, 0.18428791574529918, 0.18458538518578782, 0.18488304017656776, 0.18518088054253651, 0.18547890610848206, 0.1857771166990837, 0.18607551213891182, 0.18637409225242807, 0.18667285686398527, 0.18697180579782824, 0.18727093887809287, 0.18757025592880688, 0.18786975677388978, 0.18816944123715268, 0.18846930914229937, 0.18876936031292502, 0.18906959457251737, 0.18937001174445628, 0.1896706116520141, 0.1899713941183554, 0.19027235896653799, 0.1905735060195119, 0.19087483510011999, 0.19117634603109812, 0.19147803863507507, 0.19177991273457318, 0.19208196815200751, 0.19238420470968665, 0.19268662222981259, 0.19298922053448092, 0.19329199944568065, 0.19359495878529515, 0.19389809837510102, 0.1942014180367691, 0.19450491759186422, 0.19480859686184526, 0.19511245566806579, 0.19541649383177345, 0.19572071117411033, 0.19602510751611324, 0.1963296826787137, 0.19663443648273771, 0.19693936874890694, 0.19724447929783728, 0.19754976795004014, 0.19785523452592207, 0.19816087884578476, 0.19846670072982592, 0.19877269999813812, 0.19907887647071004, 0.1993852299674258, 0.19969176030806568, 0.19999846731230547, 0.20030535079971773, 0.2006124105897707, 0.20091964650182892, 0.20122705835515348, 0.20153464596890175, 0.20184240916212814, 0.20215034775378338, 0.20245846156271508, 0.20276675040766784, 0.20307521410728335, 0.20338385248010005, 0.20369266534455444, 0.20400165251897956, 0.20431081382160632, 0.20462014907056297, 0.20492965808387553, 0.20523934067946803, 0.20554919667516214, 0.20585922588867739, 0.20616942813763173, 0.20647980323954113, 0.2067903510118197, 0.20710107127178057, 0.20741196383663485, 0.20772302852349245, 0.20803426514936196, 0.2083456735311508, 0.20865725348566577, 0.20896900482961228, 0.20928092737959492, 0.20959302095211785, 0.20990528536358433, 0.21021772043029713, 0.21053032596845911, 0.21084310179417226, 0.21115604772343871, 0.21146916357216033, 0.21178244915613909, 0.21209590429107733, 0.21240952879257746, 0.21272332247614217, 0.21303728515717474, 0.21335141665097901, 0.21366571677275936, 0.21398018533762148, 0.21429482216057139, 0.21460962705651643, 0.21492459984026496, 0.21523974032652637, 0.21555504832991207, 0.21587052366493426, 0.21618616614600694, 0.21650197558744577, 0.21681795180346819, 0.21713409460819338, 0.21745040381564301, 0.21776687923974031, 0.21808352069431103, 0.21840032799308307, 0.21871730094968672, 0.21903443937765527, 0.21935174309042427, 0.21966921190133204, 0.21998684562361992, 0.2203046440704321, 0.22062260705481579, 0.22094073438972195, 0.22125902588800428, 0.22157748136242006, 0.22189610062563014, 0.22221488349019902, 0.22253382976859482, 0.22285293927319, 0.2231722118162604, 0.22349164720998632, 0.22381124526645213, 0.22413100579764628, 0.22445092861546229, 0.22477101353169765, 0.2250912603580546, 0.22541166890614023, 0.22573223898746647, 0.22605297041344991, 0.22637386299541296, 0.22669491654458263, 0.22701613087209133, 0.22733750578897693, 0.22765904110618268, 0.22798073663455809, 0.22830259218485766, 0.22862460756774211, 0.22894678259377815, 0.22926911707343839, 0.22959161081710167, 0.22991426363505357, 0.23023707533748561, 0.2305600457344959, 0.23088317463608932, 0.23120646185217725, 0.23152990719257854, 0.23185351046701846, 0.23217727148512957, 0.23250119005645153, 0.23282526599043141, 0.23314949909642352, 0.23347388918369028, 0.2337984360614011, 0.23412313953863345, 0.23444799942437267, 0.23477301552751179, 0.2350981876568527, 0.2354235156211047, 0.23574899922888587, 0.23607463828872244, 0.23640043260904947, 0.23672638199821028, 0.23705248626445768, 0.2373787452159527, 0.23770515866076564, 0.23803172640687587, 0.23835844826217178, 0.2386853240344517, 0.23901235353142286, 0.23933953656070228, 0.23966687292981653, 0.23999436244620215, 0.24032200491720518, 0.24064980015008253, 0.24097774795200039, 0.24130584813003558, 0.24163410049117517, 0.24196250484231663, 0.24229106099026854, 0.24261976874174945, 0.24294862790338922, 0.24327763828172838, 0.24360679968321863, 0.24393611191422265, 0.24426557478101485, 0.24459518808978054, 0.24492495164661671, 0.24525486525753198, 0.24558492872844645, 0.2459151418651927, 0.24624550447351462, 0.2465760163590684, 0.24690667732742244, 0.24723748718405741, 0.2475684457343662, 0.24789955278365483, 0.24823080813714127, 0.24856221159995662, 0.24889376297714472, 0.24922546207366231, 0.24955730869437964, 0.24988930264407971, 0.25022144372745914, 0.25055373174912776, 0.25088616651360923, 0.25121874782534043, 0.25155147548867274, 0.25188434930787096, 0.25221736908711384, 0.25255053463049454, 0.25288384574202011, 0.25321730222561262, 0.25355090388510804, 0.25388465052425702, 0.25421854194672511, 0.2545525779560926, 0.25488675835585439, 0.25522108294942125, 0.25555555154011844, 0.25589016393118669, 0.25622491992578211, 0.25655981932697625, 0.25689486193775679, 0.25723004756102658, 0.2575653759996045, 0.25790084705622562, 0.25823646053354077, 0.25857221623411719, 0.25890811396043867, 0.25924415351490515, 0.2595803346998331, 0.25991665731745595, 0.2602531211699235, 0.26058972605930303, 0.2609264717875785, 0.26126335815665103, 0.26160038496833904, 0.2619375520243783, 0.26227485912642201, 0.26261230607604147, 0.26294989267472502, 0.26328761872387929, 0.26362548402482872, 0.26396348837881561, 0.26430163158700115, 0.26463991345046423, 0.26497833377020225, 0.26531689234713129, 0.26565558898208619, 0.26599442347582003, 0.26633339562900576, 0.26667250524223457, 0.26701175211601702, 0.26735113605078281, 0.26769065684688104, 0.26803031430458069, 0.26837010822406993, 0.26871003840545665, 0.26905010464876872, 0.26939030675395392, 0.26973064452087991, 0.27007111774933523, 0.27041172623902798, 0.27075246978958695, 0.27109334820056152, 0.27143436127142145, 0.27177550880155799, 0.27211679059028271, 0.27245820643682817, 0.27279975614034824, 0.2731414394999182, 0.27348325631453418, 0.27382520638311458, 0.27416728950449876, 0.27450950547744812, 0.27485185410064578, 0.27519433517269665, 0.27553694849212834, 0.27587969385739008, 0.27622257106685355, 0.27656557991881303, 0.2769087202114851, 0.27725199174300907, 0.27759539431144753, 0.27793892771478546, 0.27828259175093084, 0.27862638621771507, 0.27897031091289259, 0.27931436563414164, 0.27965855017906355, 0.2800028643451834, 0.28034730792995011, 0.28069188073073631, 0.28103658254483854, 0.28138141316947796, 0.28172637240179943, 0.28207146003887229, 0.28241667587769048, 0.28276201971517212, 0.28310749134816071, 0.28345309057342405, 0.28379881718765498, 0.28414467098747143, 0.28449065176941657, 0.28483675932995867, 0.28518299346549181, 0.28552935397233525, 0.2858758406467341, 0.28622245328485907, 0.2865691916828067, 0.28691605563660016, 0.28726304494218813, 0.28761015939544565, 0.2879573987921743, 0.28830476292810214, 0.28865225159888347, 0.28899986460010019, 0.28934760172726021, 0.28969546277579883, 0.29004344754107825, 0.29039155581838794, 0.29073978740294515, 0.29108814208989386, 0.29143661967430612, 0.29178521995118151, 0.29213394271544735, 0.29248278776195924, 0.29283175488550045, 0.29318084388078275, 0.29353005454244607, 0.29387938666505853, 0.29422884004311745, 0.2945784144710481, 0.29492810974320488, 0.29527792565387123, 0.29562786199725932, 0.29597791856751066, 0.29632809515869607, 0.29667839156481546, 0.29702880757979877, 0.29737934299750513, 0.29772999761172347, 0.29808077121617299, 0.29843166360450246, 0.29878267457029078, 0.29913380390704758, 0.29948505140821213, 0.29983641686715501, 0.30018790007717666, 0.30053950083150854, 0.30089121892331322, 0.30124305414568386, 0.30159500629164482, 0.30194707515415187, 0.30229926052609191, 0.30265156220028322, 0.30300397996947603, 0.30335651362635174, 0.30370916296352424, 0.30406192777353891, 0.30441480784887309, 0.30476780298193673, 0.30512091296507182, 0.30547413759055281, 0.3058274766505869, 0.30618092993731372, 0.30653449724280568, 0.30688817835906856, 0.30724197307804058, 0.30759588119159359, 0.30794990249153253, 0.30830403676959567, 0.30865828381745514, 0.30901264342671642, 0.30936711538891881, 0.30972169949553574, 0.3100763955379745, 0.31043120330757634, 0.31078612259561722, 0.31114115319330715, 0.31149629489179087, 0.31185154748214766, 0.31220691075539142, 0.3125623845024712, 0.31291796851427106, 0.31327366258160982, 0.31362946649524215, 0.31398538004585758, 0.3143414030240812, 0.31469753522047422, 0.31505377642553289, 0.31541012642969002, 0.31576658502331389, 0.31612315199670904, 0.31647982714011647, 0.31683661024371323, 0.31719350109761307, 0.31755049949186637, 0.31790760521646011, 0.31826481806131812, 0.31862213781630144, 0.31897956427120788, 0.31933709721577286, 0.31969473643966895, 0.32005248173250589, 0.32041033288383181, 0.32076828968313176, 0.32112635191982908, 0.32148451938328504, 0.32184279186279885, 0.3222011691476081, 0.32255965102688866, 0.32291823728975477, 0.32327692772525962, 0.32363572212239466, 0.32399462027009041, 0.32435362195721651, 0.32471272697258124, 0.32507193510493254, 0.32543124614295754, 0.32579065987528277, 0.32615017609047431, 0.32650979457703821, 0.32686951512342, 0.32722933751800548, 0.32758926154912038, 0.32794928700503057, 0.32830941367394251, 0.32866964134400289, 0.32902996980329891, 0.32939039883985888, 0.32975092824165153, 0.33011155779658657, 0.33047228729251521, 0.33083311651722941, 0.33119404525846274, 0.33155507330389, 0.33191620044112768, 0.33227742645773423, 0.33263875114120944, 0.33300017427899531, 0.33336169565847606, 0.33372331506697794, 0.33408503229176945, 0.33444684712006184, 0.33480875933900855, 0.33517076873570628, 0.33553287509719398, 0.33589507821045372, 0.33625737786241106, 0.33661977383993413, 0.33698226592983488, 0.33734485391886859, 0.33770753759373395, 0.33807031674107357, 0.33843319114747389, 0.33879616059946505, 0.33915922488352174, 0.33952238378606248, 0.33988563709345004, 0.34024898459199215, 0.34061242606794084, 0.34097596130749253, 0.34133959009678916, 0.34170331222191713, 0.34206712746890799, 0.34243103562373883, 0.34279503647233167, 0.3431591298005543, 0.34352331539421999, 0.34388759303908756, 0.3442519625208621, 0.34461642362519429, 0.34498097613768108, 0.34534561984386569, 0.34571035452923754, 0.34607517997923254, 0.34644009597923353, 0.34680510231456951, 0.34717019877051691, 0.34753538513229887, 0.34790066118508545, 0.34826602671399437, 0.34863148150409051, 0.34899702534038596, 0.34936265800784105, 0.34972837929136336, 0.35009418897580835, 0.35046008684597985, 0.35082607268662924, 0.35119214628245687, 0.35155830741811089, 0.35192455587818805, 0.35229089144723402, 0.35265731390974286, 0.35302382305015767, 0.35339041865287069, 0.35375710050222314, 0.35412386838250537, 0.35449072207795751, 0.35485766137276886, 0.35522468605107849, 0.35559179589697532, 0.35595899069449788, 0.3563262702276353, 0.35669363428032619, 0.35706108263645969, 0.35742861507987567, 0.35779623139436412, 0.35816393136366576, 0.35853171477147239, 0.3588995814014263, 0.35926753103712106, 0.35963556346210146, 0.36000367845986336, 0.36037187581385444, 0.3607401553074735, 0.36110851672407118, 0.36147695984695005, 0.36184548445936454, 0.3622140903445209, 0.36258277728557808, 0.36295154506564686, 0.36332039346779066, 0.36368932227502559, 0.36405833127032011, 0.36442742023659602, 0.36479658895672762, 0.36516583721354245, 0.3655351647898214, 0.36590457146829847, 0.36627405703166116, 0.36664362126255085, 0.36701326394356226, 0.36738298485724408, 0.36775278378609921, 0.3681226605125843, 0.36849261481911055, 0.36886264648804323, 0.36923275530170224, 0.36960294104236224, 0.36997320349225249, 0.37034354243355688, 0.37071395764841486, 0.37108444891892056, 0.37145501602712344, 0.3718256587550286, 0.37219637688459628, 0.37256717019774277, 0.37293803847633977, 0.37330898150221492, 0.37367999905715227, 0.37405109092289157, 0.37442225688112907, 0.37479349671351742, 0.37516481020166581, 0.37553619712713993, 0.37590765727146269, 0.37627919041611335, 0.37665079634252879, 0.37702247483210277, 0.37739422566618619, 0.37776604862608798, 0.378137943493074, 0.37850991004836809, 0.37888194807315201, 0.37925405734856543, 0.3796262376557058, 0.37999848877562931, 0.38037081048935001, 0.38074320257784078, 0.38111566482203296, 0.38148819700281639, 0.38186079890104024, 0.38223347029751231, 0.38260621097299952, 0.38297902070822831, 0.38335189928388425, 0.38372484648061239, 0.38409786207901764, 0.3844709458596644, 0.38484409760307731, 0.38521731708974061, 0.38559060410009888, 0.38596395841455716, 0.38633737981348065, 0.38671086807719501, 0.38708442298598694, 0.38745804432010367, 0.38783173185975323, 0.38820548538510502, 0.38857930467628943, 0.38895318951339825, 0.38932713967648463, 0.38970115494556323, 0.39007523510061071, 0.39044937992156514, 0.39082358918832683, 0.39119786268075823, 0.39157220017868377, 0.39194660146189025, 0.39232106631012731, 0.39269559450310659, 0.39307018582050313, 0.39344484004195435, 0.39381955694706078, 0.39419433631538625, 0.39456917792645763, 0.39494408155976518, 0.39531904699476295, 0.39569407401086831, 0.39606916238746248, 0.39644431190389079, 0.39681952233946222, 0.39719479347345038, 0.39757012508509282, 0.39794551695359154, 0.39832096885811336, 0.3986964805777895, 0.39907205189171596, 0.39944768257895408, 0.39982337241852983, 0.40019912118943451, 0.400574928670625, 0.40095079464102318, 0.40132671887951704, 0.40170270116495993, 0.40207874127617105, 0.4024548389919359, 0.40283099409100576, 0.40320720635209817, 0.4035834755538974, 0.40395980147505384, 0.40433618389418458, 0.40471262258987367, 0.40508911734067177, 0.40546566792509692, 0.40584227412163398, 0.40621893570873518, 0.40659565246482038, 0.40697242416827673, 0.40734925059745908, 0.40772613153069026, 0.40810306674626085, 0.40848005602242954, 0.40885709913742341, 0.40923419586943749, 0.40961134599663573, 0.40998854929715028, 0.41036580554908209, 0.41074311453050127, 0.41112047601944646, 0.41149788979392565, 0.41187535563191607, 0.4122528733113644, 0.41263044261018639, 0.41300806330626816, 0.4133857351774648, 0.41376345800160202, 0.41414123155647509, 0.41451905561984936, 0.41489692996946098, 0.41527485438301609, 0.41565282863819131, 0.41603085251263444, 0.4164089257839636, 0.41678704822976798, 0.417165219627608, 0.41754343975501501, 0.41792170838949211, 0.41830002530851346, 0.4186783902895248, 0.41905680310994409, 0.41943526354716065, 0.41981377137853587, 0.42019232638140352, 0.42057092833306936, 0.42094957701081148, 0.4213282721918809, 0.42170701365350077, 0.42208580117286743, 0.42246463452714977, 0.42284351349348992, 0.42322243784900332, 0.42360140737077834, 0.42398042183587697, 0.42435948102133492, 0.42473858470416137, 0.42511773266133923, 0.4254969246698258, 0.42587616050655197, 0.42625543994842324, 0.42663476277231915, 0.42701412875509387, 0.4273935376735763, 0.42777298930456986, 0.42815248342485279, 0.42853201981117872, 0.42891159824027603, 0.42929121848884849, 0.42967088033357542, 0.43005058355111137, 0.43043032791808689, 0.43081011321110813, 0.43118993920675697, 0.43156980568159187, 0.43194971241214697, 0.43232965917493288, 0.43270964574643694, 0.4330896719031227, 0.43346973742143047, 0.43384984207777771, 0.43422998564855841, 0.43461016791014417, 0.4349903886388834, 0.43537064761110189, 0.43575094460310343, 0.43613127939116891, 0.43651165175155704, 0.43689206146050485, 0.43727250829422692, 0.43765299202891617, 0.43803351244074396, 0.43841406930585974, 0.43879466240039189, 0.43917529150044732, 0.43955595638211142, 0.43993665682144928, 0.44031739259450436, 0.44069816347729962, 0.44107896924583756, 0.44145980967609977, 0.44184068454404762, 0.44222159362562241, 0.44260253669674493, 0.44298351353331644, 0.44336452391121789, 0.44374556760631062, 0.44412664439443672, 0.44450775405141835, 0.44488889635305845, 0.44527007107514105, 0.44565127799343074, 0.44603251688367318, 0.44641378752159561, 0.44679508968290615, 0.4471764231432947, 0.44755778767843257, 0.44793918306397268, 0.44832060907555021, 0.44870206548878194, 0.44908355207926676, 0.44946506862258612, 0.44984661489430366, 0.45022819066996533, 0.45060979572510024, 0.45099142983521967, 0.45137309277581839, 0.45175478432237376, 0.4521365042503464, 0.4525182523351805, 0.45290002835230347, 0.45328183207712608, 0.45366366328504337, 0.4540455217514337, 0.45442740725165948, 0.45480931956106757, 0.45519125845498859, 0.45557322370873771, 0.45595521509761483, 0.45633723239690394, 0.45671927538187446, 0.45710134382778012, 0.45748343750985987, 0.45786555620333802, 0.45824769968342383, 0.45862986772531217, 0.45901206010418349, 0.45939427659520388, 0.45977651697352501, 0.46015878101428498, 0.46054106849260751, 0.46092337918360293, 0.46130571286236755, 0.46168806930398426, 0.46207044828352284, 0.46245284957603944, 0.46283527295657712, 0.46321771820016633, 0.46360018508182427, 0.46398267337655535, 0.46436518285935185, 0.46474771330519304, 0.46513026448904637, 0.4655128361858667, 0.46589542817059681, 0.46627804021816799, 0.46666067210349926, 0.46704332360149808, 0.46742599448706063, 0.46780868453507135, 0.46819139352040345, 0.46857412121791936, 0.46895686740246995, 0.46933963184889571, 0.46972241433202616, 0.47010521462668003, 0.47048803250766608, 0.47087086774978221, 0.47125372012781624, 0.47163658941654618, 0.4720194753907398, 0.47240237782515504, 0.47278529649454049, 0.47316823117363471, 0.47355118163716736, 0.47393414765985842, 0.4743171290164187, 0.47470012548155038, 0.47508313682994641, 0.47546616283629101, 0.47584920327525998, 0.47623225792152041, 0.4766153265497311, 0.47699840893454276, 0.47738150485059772, 0.47776461407253068, 0.47814773637496832, 0.4785308715325296, 0.47891401931982608, 0.47929717951146172, 0.47968035188203312, 0.48006353620613013, 0.48044673225833512, 0.48082993981322364, 0.48121315864536479, 0.48159638852932057, 0.48197962923964693, 0.4823628805508931, 0.48274614223760209, 0.48312941407431126, 0.4835126958355514, 0.48389598729584771, 0.48427928822971988, 0.48466259841168174, 0.48504591761624172, 0.48542924561790318, 0.48581258219116391, 0.48619592711051718, 0.48657928015045082, 0.48696264108544807, 0.48734600968998776, 0.48772938573854391, 0.4881127690055862, 0.48849615926558038, 0.48887955629298763, 0.48926295986226526, 0.48964636974786713, 0.49002978572424277, 0.49041320756583873, 0.49079663504709764, 0.49118006794245894, 0.49156350602635918, 0.49194694907323144, 0.49233039685750596, 0.49271384915361049, 0.49309730573596988, 0.49348076637900634, 0.4938642308571401, 0.49424769894478865, 0.49463117041636778, 0.49501464504629106, 0.49539812260897009, 0.49578160287881512, 0.49616508563023454, 0.49654857063763513, 0.49693205767542281, 0.49731554651800192, 0.49769903693977574, 0.49808252871514691, 0.498466021618517, 0.49884951542428713, 0.49923300990685771, 0.49961650484062864, 0.5, 0.50038349515937142, 0.50076699009314241, 0.50115048457571298, 0.50153397838148306, 0.50191747128485309, 0.50230096306022431, 0.50268445348199819, 0.5030679423245773, 0.50345142936236498, 0.50383491436976557, 0.50421839712118488, 0.50460187739103002, 0.504985354953709, 0.50536882958363227, 0.50575230105521141, 0.50613576914285996, 0.50651923362099371, 0.50690269426403023, 0.50728615084638951, 0.5076696031424941, 0.50805305092676867, 0.50843649397364088, 0.50881993205754106, 0.50920336495290242, 0.50958679243416138, 0.50997021427575728, 0.51035363025213298, 0.5107370401377348, 0.51112044370701248, 0.51150384073441968, 0.5118872309944138, 0.51227061426145615, 0.51265399031001235, 0.51303735891455204, 0.51342071984954929, 0.51380407288948293, 0.51418741780883614, 0.51457075438209687, 0.51495408238375828, 0.51533740158831831, 0.51572071177028023, 0.5161040127041524, 0.51648730416444866, 0.5168705859256888, 0.51725385776239796, 0.51763711944910695, 0.51802037076035312, 0.51840361147067948, 0.51878684135463526, 0.51917006018677636, 0.51955326774166488, 0.51993646379386993, 0.52031964811796694, 0.52070282048853833, 0.52108598068017398, 0.52146912846747051, 0.52185226362503168, 0.52223538592746932, 0.5226184951494024, 0.52300159106545729, 0.52338467345026896, 0.52376774207847965, 0.52415079672474008, 0.52453383716370905, 0.52491686317005359, 0.52529987451844962, 0.52568287098358135, 0.52606585234014169, 0.52644881836283275, 0.52683176882636529, 0.52721470350545963, 0.52759762217484507, 0.52798052460926026, 0.52836341058345393, 0.52874627987218381, 0.52912913225021785, 0.52951196749233398, 0.52989478537332002, 0.53027758566797389, 0.53066036815110429, 0.53104313259753011, 0.5314258787820807, 0.5318086064795966, 0.5321913154649287, 0.53257400551293943, 0.53295667639850197, 0.53333932789650074, 0.53372195978183201, 0.53410457182940319, 0.53448716381413341, 0.53486973551095374, 0.53525228669480696, 0.5356348171406482, 0.5360173266234447, 0.53639981491817579, 0.53678228179983378, 0.53716472704342288, 0.53754715042396062, 0.53792955171647727, 0.53831193069601579, 0.53869428713763257, 0.53907662081639718, 0.53945893150739255, 0.53984121898571502, 0.54022348302647505, 0.54060572340479618, 0.54098793989581651, 0.54137013227468789, 0.54175230031657617, 0.54213444379666209, 0.54251656249014024, 0.54289865617222, 0.5432807246181256, 0.54366276760309606, 0.54404478490238528, 0.54442677629126235, 0.54480874154501147, 0.54519068043893248, 0.54557259274834058, 0.54595447824856635, 0.54633633671495663, 0.54671816792287398, 0.54709997164769664, 0.5474817476648195, 0.54786349574965365, 0.5482452156776263, 0.54862690722418173, 0.54900857016478044, 0.54939020427489982, 0.54977180933003467, 0.55015338510569645, 0.55053493137741394, 0.55091644792073335, 0.55129793451121811, 0.55167939092444984, 0.55206081693602738, 0.55244221232156754, 0.55282357685670536, 0.55320491031709396, 0.55358621247840445, 0.55396748311632693, 0.55434872200656937, 0.55472992892485906, 0.55511110364694161, 0.55549224594858171, 0.55587335560556328, 0.55625443239368944, 0.55663547608878217, 0.55701648646668367, 0.55739746330325513, 0.55777840637437759, 0.55815931545595243, 0.55854019032390023, 0.55892103075416255, 0.55930183652270038, 0.55968260740549569, 0.56006334317855078, 0.56044404361788858, 0.56082470849955279, 0.56120533759960811, 0.56158593069414031, 0.56196648755925604, 0.56234700797108383, 0.56272749170577308, 0.56310793853949526, 0.56348834824844296, 0.56386872060883109, 0.56424905539689663, 0.56462935238889811, 0.56500961136111671, 0.56538983208985594, 0.56577001435144159, 0.56615015792222234, 0.56653026257856953, 0.56691032809687736, 0.56729035425356311, 0.56767034082506718, 0.56805028758785303, 0.56843019431840824, 0.56881006079324314, 0.56918988678889193, 0.56956967208191311, 0.56994941644888863, 0.57032911966642463, 0.57070878151115156, 0.57108840175972397, 0.57146798018882139, 0.57184751657514732, 0.57222701069543025, 0.57260646232642376, 0.57298587124490619, 0.57336523722768085, 0.57374456005157681, 0.57412383949344814, 0.5745030753301742, 0.57488226733866077, 0.57526141529583863, 0.57564051897866508, 0.57601957816412308, 0.57639859262922166, 0.57677756215099674, 0.57715648650651008, 0.57753536547285023, 0.57791419882713269, 0.57829298634649928, 0.57867172780811915, 0.57905042298918852, 0.5794290716669307, 0.57980767361859653, 0.58018622862146418, 0.58056473645283935, 0.58094319689005591, 0.5813216097104752, 0.5816999746914866, 0.58207829161050795, 0.58245656024498504, 0.58283478037239211, 0.58321295177023214, 0.5835910742160364, 0.58396914748736561, 0.58434717136180869, 0.58472514561698397, 0.58510307003053907, 0.58548094438015064, 0.58585876844352502, 0.58623654199839803, 0.5866142648225352, 0.58699193669373195, 0.58736955738981367, 0.58774712668863571, 0.58812464436808398, 0.58850211020607446, 0.58887952398055354, 0.58925688546949884, 0.58963419445091791, 0.59001145070284977, 0.59038865400336438, 0.59076580413056257, 0.5911429008625767, 0.59151994397757046, 0.59189693325373915, 0.59227386846930985, 0.59265074940254103, 0.59302757583172327, 0.59340434753517968, 0.59378106429126487, 0.59415772587836602, 0.59453433207490314, 0.59491088265932834, 0.59528737741012638, 0.59566381610581554, 0.59604019852494616, 0.5964165244461026, 0.59679279364790183, 0.59716900590899424, 0.59754516100806421, 0.59792125872382895, 0.59829729883504013, 0.59867328112048301, 0.59904920535897688, 0.59942507132937506, 0.59980087881056554, 0.60017662758147017, 0.60055231742104598, 0.60092794810828409, 0.6013035194222105, 0.6016790311418867, 0.60205448304640852, 0.60242987491490718, 0.60280520652654968, 0.60318047766053784, 0.60355568809610927, 0.60393083761253763, 0.60430592598913169, 0.60468095300523705, 0.60505591844023487, 0.60543082207354237, 0.60580566368461386, 0.60618044305293928, 0.60655515995804565, 0.60692981417949687, 0.60730440549689346, 0.6076789336898728, 0.6080533985381098, 0.60842779982131634, 0.60880213731924182, 0.60917641081167317, 0.60955062007843486, 0.6099247648993894, 0.61029884505443688, 0.61067286032351542, 0.61104681048660181, 0.61142069532371068, 0.61179451461489498, 0.61216826814024683, 0.61254195567989633, 0.61291557701401311, 0.6132891319228051, 0.6136626201865194, 0.61403604158544289, 0.61440939589990118, 0.61478268291025939, 0.61515590239692275, 0.61552905414033565, 0.61590213792098236, 0.61627515351938766, 0.61664810071611575, 0.61702097929177169, 0.61739378902700048, 0.61776652970248769, 0.61813920109895981, 0.61851180299718367, 0.61888433517796715, 0.61925679742215922, 0.61962918951065005, 0.62000151122437075, 0.6203737623442942, 0.62074594265143468, 0.62111805192684799, 0.62149008995163202, 0.62186205650692605, 0.62223395137391213, 0.62260577433381381, 0.62297752516789728, 0.62334920365747126, 0.62372080958388676, 0.62409234272853742, 0.62446380287286019, 0.6248351897983343, 0.62520650328648264, 0.62557774311887104, 0.62594890907710843, 0.62632000094284779, 0.62669101849778519, 0.62706196152366034, 0.62743282980225734, 0.62780362311540383, 0.6281743412449714, 0.62854498397287661, 0.62891555108107944, 0.62928604235158514, 0.62965645756644317, 0.63002679650774751, 0.63039705895763776, 0.63076724469829781, 0.63113735351195677, 0.63150738518088956, 0.63187733948741576, 0.63224721621390079, 0.63261701514275592, 0.63298673605643774, 0.63335637873744921, 0.63372594296833884, 0.63409542853170153, 0.63446483521017871, 0.63483416278645755, 0.63520341104327238, 0.63557257976340398, 0.63594166872967994, 0.63631067772497452, 0.63667960653220934, 0.63704845493435314, 0.63741722271442192, 0.6377859096554791, 0.63815451554063551, 0.63852304015304995, 0.63889148327592893, 0.6392598446925265, 0.63962812418614567, 0.63999632154013675, 0.64036443653789865, 0.64073246896287905, 0.64110041859857381, 0.64146828522852772, 0.64183606863633424, 0.64220376860563588, 0.64257138492012433, 0.64293891736354036, 0.64330636571967392, 0.64367372977236481, 0.64404100930550212, 0.6444082041030248, 0.64477531394892162, 0.64514233862723114, 0.6455092779220426, 0.64587613161749469, 0.64624289949777691, 0.64660958134712931, 0.64697617694984233, 0.64734268609025714, 0.64770910855276598, 0.64807544412181195, 0.64844169258188911, 0.64880785371754313, 0.64917392731337076, 0.64953991315402027, 0.64990581102419176, 0.65027162070863676, 0.65063734199215895, 0.6510029746596141, 0.6513685184959096, 0.65173397328600569, 0.65209933881491466, 0.65246461486770113, 0.65282980122948309, 0.65319489768543049, 0.65355990402076658, 0.65392482002076746, 0.65428964547076252, 0.65465438015613442, 0.65501902386231903, 0.65538357637480571, 0.65574803747913801, 0.65611240696091255, 0.65647668460578013, 0.6568408701994457, 0.65720496352766844, 0.65756896437626122, 0.65793287253109201, 0.65829668777808292, 0.65866040990321095, 0.65902403869250747, 0.65938757393205927, 0.65975101540800785, 0.66011436290655001, 0.66047761621393763, 0.66084077511647832, 0.66120383940053495, 0.66156680885252617, 0.66192968325892654, 0.66229246240626605, 0.66265514608113152, 0.66301773407016518, 0.66338022616006587, 0.66374262213758906, 0.66410492178954628, 0.66446712490280613, 0.66482923126429383, 0.66519124066099145, 0.66555315287993821, 0.66591496770823055, 0.66627668493302206, 0.66663830434152394, 0.6669998257210048, 0.66736124885879056, 0.66772257354226583, 0.66808379955887232, 0.66844492669611, 0.66880595474153737, 0.66916688348277065, 0.66952771270748479, 0.66988844220341348, 0.67024907175834858, 0.67060960116014123, 0.67097003019670121, 0.67133035865599722, 0.6716905863260576, 0.67205071299496955, 0.67241073845087962, 0.67277066248199457, 0.67313048487658, 0.6734902054229619, 0.67384982390952575, 0.67420934012471723, 0.67456875385704251, 0.67492806489506751, 0.67528727302741876, 0.6756463780427836, 0.67600537972990959, 0.67636427787760534, 0.67672307227474038, 0.67708176271024523, 0.67744034897311134, 0.67779883085239201, 0.67815720813720115, 0.67851548061671507, 0.67887364808017092, 0.67923171031686824, 0.67958966711616831, 0.67994751826749411, 0.68030526356033116, 0.68066290278422714, 0.68102043572879212, 0.68137786218369856, 0.68173518193868188, 0.68209239478353989, 0.68244950050813369, 0.68280649890238698, 0.68316338975628677, 0.68352017285988365, 0.68387684800329107, 0.68423341497668622, 0.68458987357030998, 0.68494622357446711, 0.68530246477952583, 0.6856585969759188, 0.68601461995414248, 0.68637053350475785, 0.68672633741839018, 0.68708203148572899, 0.6874376154975288, 0.68779308924460869, 0.68814845251785239, 0.68850370510820913, 0.68885884680669296, 0.68921387740438278, 0.68956879669242377, 0.68992360446202561, 0.69027830050446426, 0.69063288461108119, 0.69098735657328358, 0.69134171618254492, 0.69169596323040439, 0.69205009750846758, 0.69240411880840647, 0.69275802692195954, 0.69311182164093155, 0.69346550275719432, 0.69381907006268628, 0.69417252334941315, 0.69452586240944725, 0.69487908703492818, 0.69523219701806327, 0.69558519215112702, 0.6959380722264612, 0.69629083703647576, 0.69664348637364826, 0.69699602003052408, 0.69734843779971678, 0.69770073947390809, 0.69805292484584813, 0.69840499370835518, 0.69875694585431614, 0.69910878107668684, 0.69946049916849151, 0.69981209992282345, 0.7001635831328451, 0.70051494859178787, 0.70086619609295253, 0.70121732542970927, 0.70156833639549765, 0.70191922878382706, 0.70227000238827653, 0.70262065700249487, 0.70297119242020123, 0.70332160843518454, 0.70367190484130404, 0.70402208143248934, 0.70437213800274079, 0.70472207434612877, 0.70507189025679518, 0.70542158552895196, 0.70577115995688267, 0.70612061333494147, 0.70646994545755404, 0.70681915611921731, 0.70716824511449961, 0.70751721223804087, 0.70786605728455276, 0.70821478004881866, 0.70856338032569388, 0.70891185791010614, 0.70926021259705485, 0.70960844418161195, 0.70995655245892186, 0.71030453722420128, 0.71065239827273985, 0.71100013539989992, 0.71134774840111648, 0.71169523707189808, 0.71204260120782581, 0.71238984060455435, 0.71273695505781198, 0.71308394436339984, 0.71343080831719319, 0.71377754671514104, 0.7141241593532659, 0.71447064602766475, 0.7148170065345083, 0.71516324067004133, 0.71550934823058354, 0.71585532901252868, 0.71620118281234513, 0.71654690942657595, 0.71689250865183929, 0.71723798028482788, 0.71758332412230974, 0.71792853996112771, 0.71827362759820068, 0.71861858683052215, 0.71896341745516146, 0.71930811926926386, 0.71965269207005, 0.7199971356548166, 0.72034144982093651, 0.72068563436585831, 0.72102968908710741, 0.72137361378228504, 0.72171740824906916, 0.72206107228521466, 0.72240460568855247, 0.72274800825699081, 0.72309127978851506, 0.72343442008118719, 0.72377742893314645, 0.72412030614261003, 0.7244630515078716, 0.72480566482730335, 0.72514814589935439, 0.72549049452255188, 0.72583271049550124, 0.72617479361688553, 0.72651674368546582, 0.72685856050008191, 0.72720024385965187, 0.72754179356317195, 0.7278832094097174, 0.7282244911984419, 0.72856563872857849, 0.7289066517994387, 0.72924753021041311, 0.72958827376097202, 0.72992888225066477, 0.73026935547911997, 0.73060969324604619, 0.73094989535123145, 0.7312899615945434, 0.73162989177593007, 0.7319696856954192, 0.73230934315311891, 0.73264886394921735, 0.73298824788398309, 0.73332749475776549, 0.73366660437099429, 0.73400557652417997, 0.73434441101791403, 0.73468310765286882, 0.73502166622979781, 0.73536008654953589, 0.73569836841299896, 0.73603651162118433, 0.73637451597517145, 0.73671238127612071, 0.73705010732527498, 0.73738769392395864, 0.73772514087357788, 0.73806244797562182, 0.73839961503166118, 0.73873664184334897, 0.73907352821242156, 0.73941027394069703, 0.7397468788300765, 0.74008334268254428, 0.74041966530016701, 0.74075584648509496, 0.74109188603956144, 0.74142778376588281, 0.74176353946645945, 0.7420991529437746, 0.74243462400039562, 0.74276995243897348, 0.74310513806224332, 0.74344018067302375, 0.743775080074218, 0.74410983606881342, 0.74444444845988156, 0.74477891705057875, 0.74511324164414561, 0.74544742204390757, 0.74578145805327511, 0.74611534947574309, 0.74644909611489207, 0.74678269777438744, 0.74711615425797984, 0.74744946536950563, 0.74778263091288633, 0.74811565069212915, 0.74844852451132737, 0.74878125217465952, 0.74911383348639093, 0.74944626825087246, 0.74977855627254097, 0.7501106973559204, 0.75044269130562047, 0.75077453792633775, 0.75110623702285539, 0.75143778840004349, 0.75176919186285884, 0.75210044721634528, 0.7524315542656338, 0.75276251281594275, 0.75309332267257778, 0.75342398364093166, 0.75375449552648544, 0.75408485813480741, 0.75441507127155361, 0.75474513474246829, 0.75507504835338346, 0.75540481191021958, 0.75573442521898526, 0.75606388808577729, 0.75639320031678148, 0.75672236171827179, 0.75705137209661089, 0.7573802312582506, 0.75770893900973157, 0.75803749515768337, 0.75836589950882494, 0.75869415186996458, 0.75902225204799967, 0.75935019984991758, 0.75967799508279477, 0.76000563755379802, 0.76033312707018363, 0.76066046343929783, 0.76098764646857719, 0.76131467596554847, 0.76164155173782822, 0.76196827359312436, 0.76229484133923453, 0.76262125478404741, 0.76294751373554237, 0.76327361800178972, 0.7635995673909507, 0.76392536171127778, 0.7642510007711143, 0.76457648437889536, 0.76490181234314747, 0.76522698447248816, 0.76555200057562756, 0.7658768604613666, 0.76620156393859906, 0.76652611081630984, 0.76685050090357643, 0.76717473400956882, 0.76749880994354869, 0.76782272851487054, 0.76814648953298159, 0.76847009280742151, 0.76879353814782281, 0.76911682536391091, 0.76943995426550416, 0.7697629246625145, 0.77008573636494648, 0.77040838918289833, 0.77073088292656178, 0.77105321740622201, 0.77137539243225794, 0.7716974078151424, 0.77201926336544191, 0.77234095889381726, 0.77266249421102329, 0.77298386912790884, 0.77330508345541749, 0.77362613700458704, 0.77394702958655015, 0.7742677610125337, 0.77458833109385994, 0.77490873964194551, 0.77522898646830241, 0.77554907138453777, 0.77586899420235378, 0.77618875473354809, 0.77650835279001384, 0.77682778818373965, 0.77714706072681006, 0.77746617023140518, 0.77778511650980109, 0.77810389937437008, 0.77842251863758016, 0.77874097411199583, 0.77905926561027816, 0.77937739294518416, 0.77969535592956807, 0.78001315437638019, 0.78033078809866807, 0.78064825690957584, 0.78096556062234468, 0.78128269905031322, 0.78159967200691716, 0.78191647930568919, 0.78223312076025975, 0.78254959618435704, 0.78286590539180656, 0.78318204819653192, 0.78349802441255434, 0.78381383385399317, 0.7841294763350658, 0.78444495167008799, 0.78476025967347363, 0.7850754001597352, 0.78539037294348368, 0.78570517783942861, 0.78601981466237858, 0.78633428322724064, 0.7866485833490211, 0.78696271484282543, 0.78727667752385799, 0.78759047120742265, 0.78790409570892272, 0.78821755084386091, 0.78853083642783983, 0.78884395227656146, 0.78915689820582791, 0.789469674031541, 0.78978227956970293, 0.7900947146364159, 0.79040697904788226, 0.79071907262040519, 0.79103099517038777, 0.79134274651433423, 0.79165432646884915, 0.79196573485063815, 0.79227697147650766, 0.79258803616336526, 0.79289892872821943, 0.79320964898818036, 0.79352019676045904, 0.79383057186236838, 0.79414077411132267, 0.79445080332483786, 0.79476065932053197, 0.79507034191612447, 0.79537985092943719, 0.7956891861783939, 0.7959983474810205, 0.79630733465544568, 0.79661614751989995, 0.79692478589271687, 0.79723324959233222, 0.79754153843728504, 0.79784965224621673, 0.79815759083787197, 0.7984653540310982, 0.79877294164484658, 0.79908035349817119, 0.79938758941022936, 0.79969464920028233, 0.80000153268769458, 0.80030823969193454, 0.80061477003257431, 0.80092112352929012, 0.80122730000186193, 0.80153329927017414, 0.8018391211542153, 0.80214476547407809, 0.80245023204996002, 0.80275552070216283, 0.80306063125109306, 0.80336556351726229, 0.80367031732128646, 0.80397489248388687, 0.80427928882588973, 0.80458350616822671, 0.80488754433193421, 0.80519140313815474, 0.80549508240813594, 0.80579858196323095, 0.80610190162489903, 0.80640504121470491, 0.80670800055431935, 0.80701077946551925, 0.80731337777018752, 0.80761579529031347, 0.8079180318479926, 0.80822008726542682, 0.80852196136492493, 0.80882365396890199, 0.80912516489988007, 0.80942649398048827, 0.80972764103346195, 0.8100286058816446, 0.81032938834798607, 0.81062998825554389, 0.81093040542748263, 0.81123063968707498, 0.81153069085770069, 0.81183055876284738, 0.81213024322611038, 0.81242974407119317, 0.81272906112190713, 0.81302819420217176, 0.81332714313601473, 0.81362590774757204, 0.81392448786108829, 0.81422288330091641, 0.81452109389151806, 0.81481911945746355, 0.81511695982343224, 0.81541461481421229, 0.81571208425470099, 0.81600936796990453, 0.81630646578493882, 0.81660337752502865, 0.81690010301550864, 0.81719664208182285, 0.81749299454952484, 0.81778916024427817, 0.8180851389918562, 0.81838093061814221, 0.81867653494912962, 0.81897195181092208, 0.81926718102973339, 0.81956222243188792, 0.81985707584382028, 0.82015174109207589, 0.82044621800331075, 0.82074050640429164, 0.82103460612189627, 0.82132851698311349, 0.82162223881504293, 0.82191577144489569, 0.82220911469999425, 0.82250226840777207, 0.82279523239577435, 0.82308800649165814, 0.82338059052319201, 0.82367298431825609, 0.82396518770484273, 0.82425720051105622, 0.82454902256511309, 0.82484065369534165, 0.82513209373018293, 0.82542334249819049, 0.82571439982802997, 0.82600526554847975, 0.82629593948843127, 0.82658642147688843, 0.82687671134296803, 0.82716680891590033, 0.82745671402502807, 0.82774642649980779, 0.8280359461698088, 0.82832527286471458, 0.82861440641432127, 0.82890334664853937, 0.82919209339739264, 0.82948064649101871, 0.82976900575966939, 0.83005717103371035, 0.83034514214362121, 0.83063291891999613, 0.83092050119354344, 0.83120788879508589, 0.83149508155556073, 0.83178207930601999, 0.83206888187763006, 0.83235548910167245, 0.83264190080954359, 0.83292811683275492, 0.83321413700293268, 0.83349996115181879, 0.83378558911127021, 0.83407102071325934, 0.83435625578987405, 0.83464129417331812, 0.83492613569591057, 0.83521078019008654, 0.83549522748839711, 0.83577947742350922, 0.83606352982820598, 0.83634738453538648, 0.83663104137806654, 0.83691450018937807, 0.83719776080256958, 0.83748082305100602, 0.83776368676816926, 0.83804635178765796, 0.83832881794318748, 0.83861108506859017, 0.83889315299781586, 0.83917502156493073, 0.8394566906041192, 0.83973815994968248, 0.84001942943603947, 0.84030049889772651, 0.84058136816939766, 0.84086203708582485, 0.84114250548189784, 0.84142277319262404, 0.84170284005312945, 0.84198270589865776, 0.84226237056457121, 0.84254183388635018, 0.84282109569959385, 0.84310015584001929, 0.84337901414346295, 0.84365767044587958, 0.84393612458334277, 0.84421437639204533, 0.84449242570829863, 0.84477027236853353, 0.84504791620930009, 0.84532535706726741, 0.84560259477922428, 0.84587962918207893, 0.84615646011285917, 0.84643308740871237, 0.84670951090690594, 0.84698573044482695, 0.84726174585998282, 0.84753755699000044, 0.84781316367262749, 0.84808856574573155, 0.84836376304730066, 0.84863875541544331, 0.8489135426883887, 0.84918812470448646, 0.84946250130220713, 0.84973667232014194, 0.85001063759700313, 0.85028439697162428, 0.85055795028295944, 0.85083129737008423, 0.85110443807219593, 0.85137737222861265, 0.85165009967877436, 0.85192262026224252, 0.85219493381870026, 0.8524670401879525, 0.85273893920992605, 0.85301063072466987, 0.85328211457235481, 0.85355339059327373, 0.85382445862784218, 0.8540953185165977, 0.85436597010020032, 0.85463641321943284, 0.85490664771520042, 0.85517667342853121, 0.85544649020057584, 0.85571609787260816, 0.85598549628602505, 0.85625468528234616, 0.85652366470321462, 0.85679243439039676, 0.85706099418578241, 0.85732934393138449, 0.85759748346934006, 0.8578654126419093, 0.85813313129147661, 0.85840063926054977, 0.85866793639176087, 0.8589350225278658, 0.85920189751174492, 0.85946856118640225, 0.8597350133949665, 0.86000125398069083, 0.86026728278695264, 0.860533099657254, 0.86079870443522188, 0.86106409696460773, 0.86132927708928786, 0.86159424465326373, 0.86185899950066169, 0.86212354147573356, 0.86238787042285558, 0.86265198618653038, 0.86291588861138524, 0.863179577542173, 0.86344305282377243, 0.86370631430118783, 0.86396936181954931, 0.86423219522411254, 0.86449481436025966, 0.86475721907349845, 0.86501940920946307, 0.8652813846139138, 0.86554314513273711, 0.86580469061194631, 0.8660660208976807, 0.86632713583620635, 0.86658803527391637, 0.86684871905733019, 0.86710918703309414, 0.86736943904798169, 0.86762947494889342, 0.8678892945828568, 0.86814889779702653, 0.8684082844386849, 0.86866745435524151, 0.86892640739423299, 0.86918514340332431, 0.86944366223030756, 0.86970196372310293, 0.8699600477297581, 0.87021791409844895, 0.87047556267747961, 0.87073299331528164, 0.87099020586041553, 0.87124720016156965, 0.87150397606756091, 0.87176053342733462, 0.87201687208996459, 0.87227299190465368, 0.87252889272073297, 0.87278457438766277, 0.87304003675503195, 0.8732952796725586, 0.87355030299009007, 0.87380510655760257, 0.8740596902252018, 0.87431405384312266, 0.87456819726172963, 0.87482212033151674, 0.87507582290310748, 0.87532930482725535, 0.87558256595484318, 0.87583560613688416, 0.87608842522452135, 0.87634102306902761, 0.87659339952180626, 0.87684555443439072, 0.87709748765844453, 0.87734919904576225, 0.87760068844826833, 0.877851955718018, 0.87810300070719727, 0.87835382326812284, 0.87860442325324228, 0.87885480051513409, 0.87910495490650764, 0.87935488628020364, 0.87960459448919392, 0.87985407938658167, 0.88010334082560115, 0.88035237865961846, 0.88060119274213089, 0.88084978292676763, 0.88109814906728945, 0.88134629101758899, 0.88159420863169069, 0.88184190176375088, 0.88208937026805834, 0.88233661399903363, 0.88258363281122953, 0.88283042655933119, 0.88307699509815651, 0.88332333828265519, 0.88356945596791014, 0.88381534800913664, 0.88406101426168271, 0.88430645458102919, 0.8845516688227899, 0.88479665684271147, 0.88504141849667395, 0.8852859536406904, 0.88553026213090691, 0.88577434382360321, 0.88601819857519226, 0.88626182624222061, 0.88650522668136844, 0.88674839974944952, 0.8869913453034115, 0.88723406320033549, 0.88747655329743691, 0.88771881545206521, 0.88796084952170384, 0.88820265536397014, 0.88844423283661622, 0.8886855817975281, 0.88892670210472657, 0.88916759361636655, 0.88940825619073793, 0.8896486896862652, 0.88988889396150728, 0.8901288688751583, 0.89036861428604719, 0.8906081300531381, 0.89084741603552975, 0.89108647209245651, 0.89132529808328786, 0.89156389386752866, 0.89180225930481916, 0.89204039425493498, 0.89227829857778762, 0.89251597213342404, 0.89275341478202697, 0.89299062638391513, 0.89322760679954283, 0.89346435588950091, 0.89370087351451566, 0.89393715953545017, 0.89417321381330317, 0.89440903620921008, 0.89464462658444277, 0.89487998480040953, 0.89511511071865502, 0.89535000420086086, 0.89558466510884505, 0.89581909330456289, 0.89605328865010625, 0.89628725100770379, 0.89652098023972182, 0.89675447620866333, 0.89698773877716853, 0.8972207678080153, 0.89745356316411851, 0.8976861247085306, 0.89791845230444178, 0.8981505458151795, 0.89838240510420941, 0.8986140300351344, 0.89884542047169558, 0.89907657627777193, 0.89930749731738047, 0.89953818345467618, 0.89976863455395251, 0.89999885047964101, 0.90022883109631135, 0.9004585762686721, 0.90068808586157012, 0.90091735973999065, 0.90114639776905792, 0.90137519981403458, 0.90160376574032242, 0.90183209541346199, 0.90206018869913285, 0.90228804546315355, 0.90251566557148188, 0.90274304889021462, 0.9029701952855882, 0.90319710462397818, 0.90342377677189967, 0.90365021159600722, 0.90387640896309518, 0.90410236874009742, 0.90432809079408749, 0.90455357499227906, 0.90477882120202557, 0.90500382929082057, 0.90522859912629738, 0.90545313057622989, 0.90567742350853186, 0.90590147779125774, 0.90612529329260194, 0.9063488698808998, 0.90657220742462674, 0.9067953057923992, 0.90701816485297426, 0.90724078447524925, 0.90746316452826337, 0.9076853048811957, 0.90790720540336689, 0.9081288659642387, 0.90835028643341387, 0.90857146668063649, 0.90879240657579186, 0.90901310598890672, 0.90923356479014927, 0.90945378284982947, 0.9096737600383985, 0.90989349622644955, 0.91011299128471734, 0.91033224508407873, 0.91055125749555232, 0.91077002839029886, 0.91098855763962083, 0.91120684511496319, 0.91142489068791321, 0.91164269423020006, 0.91186025561369566, 0.91207757471041428, 0.91229465139251265, 0.91251148553229011, 0.91272807700218883, 0.91294442567479339, 0.91316053142283171, 0.91337639411917426, 0.91359201363683451, 0.91380738984896914, 0.91402252262887784, 0.91423741185000362, 0.91445205738593249, 0.91466645911039413, 0.91488061689726152, 0.91509453062055113, 0.91530820015442316, 0.91552162537318116, 0.91573480615127267, 0.9159477423632888, 0.91616043388396484, 0.91637288058817967, 0.91658508235095659, 0.91679703904746257, 0.91700875055300912, 0.91722021674305165, 0.91743143749319001, 0.91764241267916868, 0.9178531421768763, 0.91806362586234613, 0.918273863611756, 0.91848385530142851, 0.91869360080783102, 0.91890310000757547, 0.91911235277741898, 0.9193213589942637, 0.91953011853515632, 0.91973863127728928, 0.91994689709799982, 0.92015491587477038, 0.92036268748522909, 0.92057021180714904, 0.92077748871844922, 0.92098451809719384, 0.92119129982159298, 0.92139783377000206, 0.92160411982092272, 0.92181015785300202, 0.92201594774503315, 0.92222148937595527, 0.92242678262485356, 0.92263182737095906, 0.92283662349364959, 0.92304117087244852, 0.92324546938702601, 0.92344951891719862, 0.92365331934292916, 0.92385687054432719, 0.92406017240164862, 0.92426322479529632, 0.92446602760581986, 0.92466858071391544, 0.92487088400042627, 0.92507293734634266, 0.92527474063280168, 0.92547629374108786, 0.9256775965526326, 0.9258786489490145, 0.92607945081195986, 0.92628000202334204, 0.92648030246518176, 0.92668035201964771, 0.92688015056905571, 0.92707969799586942, 0.92727899418270021, 0.92747803901230741, 0.92767683236759801, 0.92787537413162691, 0.92807366418759729, 0.92827170241886003, 0.92846948870891444, 0.92866702294140779, 0.92886430500013606, 0.92906133476904307, 0.92925811213222143, 0.92945463697391195, 0.92965090917850424, 0.92984692863053631, 0.93004269521469507, 0.93023820881581609, 0.9304334693188836, 0.93062847660903114, 0.93082323057154071, 0.9310177310918436, 0.93121197805552025, 0.93140597134830017, 0.93159971085606208, 0.93179319646483405, 0.93198642806079335, 0.93217940553026701, 0.93237212875973119, 0.9325645976358119, 0.93275681204528449, 0.93294877187507441, 0.93314047701225644, 0.93333192734405557, 0.93352312275784632, 0.93371406314115346, 0.93390474838165161, 0.9340951783671656, 0.9342853529856705, 0.93447527212529113, 0.93466493567430342, 0.93485434352113284, 0.93504349555435573, 0.93523239166269878, 0.93542103173503943, 0.93560941566040556, 0.93579754332797549, 0.93598541462707896, 0.93617302944719571, 0.93636038767795715, 0.93654748920914499, 0.93673433393069239, 0.93692092173268349, 0.93710725250535321, 0.93729332613908811, 0.93747914252442577, 0.93766470155205539, 0.9378500031128173, 0.93803504709770325, 0.93821983339785686, 0.93840436190457277, 0.93858863250929803, 0.93877264510363068, 0.93895639957932087, 0.93913989582827084, 0.93932313374253407, 0.93950611321431676, 0.93968883413597659, 0.93987129640002376, 0.94005349989912013, 0.94023544452608032, 0.94041713017387096, 0.94059855673561099, 0.94077972410457189, 0.94096063217417747, 0.94114128083800441, 0.9413216699897814, 0.94150179952339041, 0.94168166933286579, 0.94186127931239483, 0.94204062935631749, 0.94221971935912685, 0.94239854921546895, 0.94257711882014261, 0.94275542806809998, 0.9429334768544464, 0.94311126507444032, 0.94328879262349352, 0.9434660593971711, 0.94364306529119157, 0.94381981020142702, 0.94399629402390284, 0.94417251665479818, 0.94434847799044586, 0.94452417792733234, 0.94469961636209776, 0.94487479319153644, 0.94504970831259616, 0.94522436162237899, 0.94539875301814069, 0.94557288239729154, 0.94574674965739569, 0.94592035469617142, 0.9460936974114913, 0.94626677770138223, 0.9464395954640259, 0.94661215059775761, 0.9467844430010679, 0.94695647257260163, 0.94712823921115807, 0.94729974281569129, 0.94747098328531032, 0.94764196051927874, 0.947812674417015, 0.94798312487809255, 0.94815331180223983, 0.94832323508934013, 0.94849289463943198, 0.9486622903527091, 0.94883142212952043, 0.94900028987037, 0.94916889347591715, 0.94933723284697691, 0.94950530788451948, 0.94967311848967073, 0.94984066456371197, 0.95000794600808014, 0.95017496272436786, 0.95034171461432349, 0.95050820157985116, 0.95067442352301101, 0.95084038034601881, 0.95100607195124653, 0.95117149824122205, 0.95133665911862941, 0.95150155448630858, 0.95166618424725591, 0.95183054830462399, 0.95199464656172172, 0.95215847892201411, 0.95232204528912312, 0.95248534556682662, 0.95264837965905946, 0.95281114746991258, 0.95297364890363423, 0.95313588386462889, 0.95329785225745767, 0.95345955398683913, 0.95362098895764791, 0.95378215707491631, 0.95394305824383308, 0.95410369236974435, 0.95426405935815306, 0.95442415911471956, 0.95458399154526119, 0.95474355655575271, 0.95490285405232611, 0.95506188394127078, 0.95522064612903357, 0.95537914052221873, 0.95553736702758818, 0.95569532555206127, 0.95585301600271499, 0.95601043828678423, 0.95616759231166137, 0.95632447798489695, 0.95648109521419911, 0.95663744390743388, 0.9567935239726254, 0.9569493353179559, 0.95710487785176535, 0.95726015148255228, 0.9574151561189731, 0.95756989166984263, 0.95772435804413392, 0.95787855515097831, 0.9580324828996658, 0.95818614119964463, 0.9583395299605213, 0.95849264909206155, 0.95864549850418901, 0.95879807810698647, 0.9589503878106953, 0.95910242752571551, 0.95925419716260607, 0.95940569663208497, 0.95955692584502894, 0.95970788471247359, 0.95985857314561374, 0.96000899105580328, 0.96015913835455535, 0.96030901495354193, 0.96045862076459476, 0.96060795569970436, 0.9607570196710209, 0.96090581259085406, 0.96105433437167254, 0.961202584926105, 0.96135056416693931, 0.96149827200712312, 0.96164570835976382, 0.96179287313812833, 0.96193976625564337, 0.9620863876258956, 0.96223273716263136, 0.96237881477975695, 0.96252462039133879, 0.96267015391160315, 0.96281541525493641, 0.96296040433588503, 0.96310512106915569, 0.96324956536961526, 0.96339373715229093, 0.96353763633237, 0.9636812628252005, 0.96382461654629059, 0.96396769741130894, 0.96411050533608478, 0.96425304023660785, 0.96439530202902857, 0.96453729062965787, 0.96467900595496769, 0.96482044792159061, 0.96496161644631984, 0.96510251144610959, 0.96524313283807484, 0.96538348053949186, 0.96552355446779758, 0.96566335454059016, 0.96580288067562892, 0.96594213279083407, 0.96608111080428727, 0.96621981463423112, 0.96635824419907013, 0.96649639941736942, 0.96663428020785602, 0.96677188648941814, 0.96690921818110542, 0.96704627520212949, 0.96718305747186295, 0.96731956490984039, 0.96745579743575805, 0.96759175496947381, 0.96772743743100731, 0.96786284474054018, 0.96799797681841571, 0.96813283358513913, 0.96826741496137769, 0.96840172086796072, 0.96853575122587965, 0.96866950595628754, 0.96880298498049999, 0.96893618821999494, 0.96906911559641218, 0.96920176703155403, 0.96933414244738514, 0.96946624176603224, 0.96959806490978495, 0.96972961180109496, 0.96986088236257673, 0.96999187651700702, 0.97012259418732549, 0.97025303529663409, 0.97038319976819798, 0.97051308752544463, 0.97064269849196427, 0.97077203259151035, 0.97090108974799882, 0.97102986988550866, 0.97115837292828189, 0.97128659880072343, 0.97141454742740141, 0.97154221873304669, 0.97166961264255391, 0.97179672908098014, 0.97192356797354629, 0.97205012924563627, 0.97217641282279743, 0.97230241863074007, 0.9724281465953386, 0.9725535966426303, 0.97267876869881609, 0.97280366269026064, 0.97292827854349195, 0.97305261618520178, 0.9731766755422453, 0.97330045654164177, 0.973423959110574, 0.97354718317638866, 0.97367012866659608, 0.97379279550887055, 0.97391518363105045, 0.97403729296113806, 0.9741591234272996, 0.97428067495786519, 0.97440194748132924, 0.97452294092635028, 0.974643655221751, 0.97476409029651834, 0.97488424607980328, 0.9750041225009215, 0.97512371948935261, 0.97524303697474091, 0.97536207488689475, 0.9754808331557876, 0.97559931171155667, 0.97571751048450417, 0.97583542940509693, 0.97595306840396612, 0.97607042741190786, 0.97618750635988294, 0.97630430517901667, 0.97642082380059936, 0.97653706215608604, 0.97665302017709688, 0.97676869779541664, 0.97688409494299511, 0.97699921155194724, 0.97711404755455278, 0.97722860288325675, 0.97734287747066917, 0.97745687124956526, 0.97757058415288534, 0.97768401611373523, 0.97779716706538555, 0.97791003694127276, 0.9780226256749982, 0.97813493320032907, 0.97824695945119755, 0.97835870436170147, 0.97847016786610441, 0.97858134989883505, 0.97869225039448793, 0.97880286928782323, 0.97891320651376645, 0.9790232620074093, 0.97913303570400889, 0.97924252753898811, 0.9793517374479358, 0.97946066536660659, 0.97956931123092095, 0.97967767497696534, 0.9797857565409922, 0.97989355585941995, 0.98000107286883298, 0.98010830750598177, 0.98021525970778289, 0.98032192941131924, 0.98042831655383988, 0.98053442107275968, 0.98064024290566032, 0.9807457819902895, 0.98085103826456121, 0.9809560116665561, 0.98106070213452079, 0.98116510960686876, 0.98126923402217958, 0.98137307531919971, 0.98147663343684188, 0.98157990831418562, 0.98168289989047697, 0.9817856081051286, 0.98188803289771998, 0.98199017420799706, 0.98209203197587291, 0.98219360614142714, 0.98229489664490632, 0.982395903426724, 0.98249662642746016, 0.98259706558786242, 0.9826972208488447, 0.98279709215148836, 0.98289667943704184, 0.98299598264692034, 0.98309500172270625, 0.98319373660614939, 0.98329218723916656, 0.98339035356384163, 0.98348823552242604, 0.98358583305733838, 0.98368314611116425, 0.98378017462665723, 0.98387691854673776, 0.9839733778144939, 0.98406955237318128, 0.98416544216622259, 0.98426104713720863, 0.98435636722989739, 0.98445140238821449, 0.98454615255625311, 0.98464061767827427, 0.98473479769870653, 0.98482869256214622, 0.98492230221335741, 0.98501562659727204, 0.98510866565898958, 0.9852014193437777, 0.98529388759707182, 0.98538607036447523, 0.98547796759175899, 0.98556957922486255, 0.98566090520989302, 0.98575194549312584, 0.98584270002100427, 0.9859331687401397, 0.9860233515973118, 0.98611324853946813, 0.98620285951372488, 0.98629218446736611, 0.98638122334784428, 0.98646997610278009, 0.98655844267996251, 0.98664662302734918, 0.98673451709306548, 0.98682212482540599, 0.98690944617283305, 0.98699648108397797, 0.98708322950764016, 0.98716969139278787, 0.9872558666885578, 0.98734175534425539, 0.98742735730935416, 0.98751267253349706, 0.98759770096649513, 0.98768244255832849, 0.98776689725914568, 0.98785106501926423, 0.98793494578917052, 0.98801853951951957, 0.98810184616113528, 0.98818486566501051, 0.98826759798230723, 0.98835004306435592, 0.98843220086265626, 0.98851407132887714, 0.9885956544148562, 0.98867695007260004, 0.9887579582542847, 0.98883867891225496, 0.98891911199902527, 0.98899925746727857, 0.98907911526986747, 0.98915868535981377, 0.98923796769030847, 0.98931696221471155, 0.98939566888655284, 0.98947408765953115, 0.98955221848751462, 0.98963006132454101, 0.98970761612481739, 0.98978488284272026, 0.98986186143279564, 0.98993855184975876, 0.99001495404849504, 0.99009106798405866, 0.99016689361167398, 0.99024243088673469, 0.99031767976480412, 0.99039264020161522, 0.99046731215307082, 0.9905416955752433, 0.99061579042437486, 0.99068959665687728, 0.99076311422933239, 0.99083634309849156, 0.99090928322127625, 0.99098193455477768, 0.99105429705625681, 0.99112637068314469, 0.99119815539304235, 0.99126965114372068, 0.99134085789312043, 0.99141177559935256, 0.99148240422069822, 0.9915527437156082, 0.99162279404270359, 0.99169255516077559, 0.99176202702878569, 0.99183120960586513, 0.9919001028513158, 0.99196870672460946, 0.99203702118538817, 0.99210504619346451, 0.99217278170882095, 0.99224022769161047, 0.99230738410215635, 0.9923742509009521, 0.99244082804866185, 0.99250711550611992, 0.99257311323433117, 0.99263882119447056, 0.99270423934788421, 0.99276936765608803, 0.99283420608076878, 0.99289875458378374, 0.99296301312716051, 0.99302698167309766, 0.99309066018396419, 0.99315404862229939, 0.99321714695081353, 0.99327995513238765, 0.99334247313007329, 0.99340470090709276, 0.99346663842683891, 0.99352828565287554, 0.99358964254893722, 0.99365070907892927, 0.99371148520692776, 0.99377197089717961, 0.99383216611410286, 0.99389207082228603, 0.99395168498648889, 0.99401100857164182, 0.99407004154284628, 0.99412878386537473, 0.99418723550467059, 0.99424539642634824, 0.99430326659619328, 0.99436084598016183, 0.99441813454438177, 0.99447513225515149, 0.99453183907894083, 0.99458825498239056, 0.99464437993231258, 0.99470021389569019, 0.99475575683967765, 0.99481100873160044, 0.99486596953895523, 0.99492063922941032, 0.99497501777080455, 0.99502910513114862, 0.9950829012786242, 0.99513640618158461, 0.99518961980855414, 0.99524254212822849, 0.99529517310947502, 0.99534751272133226, 0.99539956093301019, 0.99545131771388995, 0.99550278303352469, 0.9955539568616385, 0.99560483916812703, 0.99565542992305778, 0.99570572909666932, 0.99575573665937189, 0.99580545258174769, 0.99585487683454976, 0.99590400938870327, 0.99595285021530466, 0.99600139928562226, 0.9960496565710959, 0.99609762204333696, 0.99614529567412868, 0.99619267743542583, 0.99623976729935504, 0.99628656523821446, 0.99633307122447401, 0.99637928523077557, 0.99642520722993255, 0.99647083719493024, 0.99651617509892576, 0.99656122091524779, 0.99660597461739719, 0.99665043617904669, 0.99669460557404033, 0.99673848277639454, 0.99678206776029765, 0.99682536050010961, 0.99686836097036235, 0.99691106914575989, 0.99695348500117809, 0.99699560851166469, 0.99703743965243974, 0.99707897839889492, 0.99712022472659401, 0.99716117861127285, 0.9972018400288396, 0.99724220895537385, 0.99728228536712771, 0.99732206924052536, 0.99736156055216285, 0.99740075927880856, 0.99743966539740281, 0.99747827888505824, 0.99751659971905937, 0.997554627876863, 0.99759236333609846, 0.99762980607456675, 0.99766695607024114, 0.99770381330126745, 0.99774037774596347, 0.99777664938281929, 0.9978126281904971, 0.99784831414783182, 0.99788370723382991, 0.99791880742767081, 0.99795361470870581, 0.99798812905645895, 0.99802235045062604, 0.99805627887107562, 0.99808991429784855, 0.99812325671115776, 0.99815630609138895, 0.9981890624191001, 0.99822152567502132, 0.99825369584005541, 0.99828557289527742, 0.99831715682193489, 0.99834844760144803, 0.998379445215409, 0.99841014964558283, 0.99844056087390687, 0.99847067888249108, 0.99850050365361764, 0.99853003516974148, 0.99855927341349005, 0.99858821836766309, 0.99861687001523314, 0.9986452283393451, 0.99867329332331667, 0.9987010649506376, 0.99872854320497095, 0.99875572807015178, 0.99878261953018788, 0.99880921756925978, 0.99883552217172045, 0.99886153332209582, 0.99888725100508391, 0.99891267520555582, 0.99893780590855508, 0.99896264309929794, 0.99898718676317344, 0.99901143688574312, 0.99903539345274117, 0.99905905645007453, 0.99908242586382312, 0.99910550168023904, 0.99912828388574759, 0.99915077246694639, 0.99917296741060624, 0.99919486870367002, 0.99921647633325428, 0.99923779028664739, 0.99925881055131116, 0.99927953711487971, 0.99929996996516013, 0.99932010909013269, 0.99933995447794954, 0.99935950611693647, 0.99937876399559167, 0.9993977281025862, 0.999416398426764, 0.99943477495714172, 0.99945285768290915, 0.99947064659342844, 0.99948814167823485, 0.99950534292703663, 0.99952225032971465, 0.99953886387632274, 0.9995551835570875, 0.99957120936240851, 0.99958694128285819, 0.99960237930918194, 0.99961752343229793, 0.99963237364329727, 0.99964692993344384, 0.99966119229417472, 0.99967516071709972, 0.99968883519400142, 0.9997022157168356, 0.99971530227773087, 0.99972809486898861, 0.99974059348308342, 0.9997527981126626, 0.99976470875054657, 0.99977632538972849, 0.99978764802337461, 0.99979867664482414, 0.99980941124758926, 0.99981985182535515, 0.99982999837197961, 0.99983985088149396, 0.99984940934810207, 0.99985867376618109, 0.99986764413028084, 0.99987632043512442, 0.99988470267560769, 0.99989279084679961, 0.99990058494394218, 0.99990808496245021, 0.99991529089791165, 0.99992220274608767, 0.99992882050291199, 0.99993514416449147, 0.99994117372710623, 0.9999469091872093, 0.9999523505414265, 0.99995749778655674, 0.99996235091957231, 0.99996690993761805, 0.99997117483801201, 0.9999751456182453, 0.999978822275982, 0.99998220480905919, 0.99998529321548713, 0.99998808749344881, 0.99999058764130055, 0.99999279365757165, 0.99999470554096415, 0.99999632329035359, 0.9999976469047881, 0.99999867638348916, 0.99999941172585094, 0.99999985293144111, 1.0, 0.99999985293144111, 0.99999941172585094, 0.99999867638348916, 0.9999976469047881, 0.99999632329035359, 0.99999470554096415, 0.99999279365757165, 0.99999058764130055, 0.99998808749344881, 0.99998529321548713, 0.99998220480905919, 0.999978822275982, 0.9999751456182453, 0.99997117483801201, 0.99996690993761805, 0.99996235091957231, 0.99995749778655674, 0.9999523505414265, 0.9999469091872093, 0.99994117372710623, 0.99993514416449147, 0.99992882050291199, 0.99992220274608767, 0.99991529089791165, 0.99990808496245021, 0.99990058494394218, 0.99989279084679961, 0.99988470267560769, 0.99987632043512442, 0.99986764413028084, 0.99985867376618109, 0.99984940934810207, 0.99983985088149396, 0.99982999837197961, 0.99981985182535515, 0.99980941124758926, 0.99979867664482414, 0.99978764802337461, 0.99977632538972849, 0.99976470875054657, 0.9997527981126626, 0.99974059348308342, 0.99972809486898861, 0.99971530227773087, 0.9997022157168356, 0.99968883519400142, 0.99967516071709972, 0.99966119229417472, 0.99964692993344384, 0.99963237364329727, 0.99961752343229793, 0.99960237930918194, 0.99958694128285819, 0.99957120936240851, 0.9995551835570875, 0.99953886387632274, 0.99952225032971465, 0.99950534292703663, 0.99948814167823485, 0.99947064659342844, 0.99945285768290915, 0.99943477495714172, 0.999416398426764, 0.9993977281025862, 0.99937876399559167, 0.99935950611693647, 0.99933995447794954, 0.99932010909013269, 0.99929996996516013, 0.99927953711487971, 0.99925881055131116, 0.99923779028664739, 0.99921647633325428, 0.99919486870367002, 0.99917296741060624, 0.99915077246694639, 0.99912828388574759, 0.99910550168023904, 0.99908242586382312, 0.99905905645007453, 0.99903539345274117, 0.99901143688574312, 0.99898718676317344, 0.99896264309929794, 0.99893780590855508, 0.99891267520555582, 0.99888725100508391, 0.99886153332209582, 0.99883552217172045, 0.99880921756925978, 0.99878261953018788, 0.99875572807015178, 0.99872854320497095, 0.9987010649506376, 0.99867329332331667, 0.9986452283393451, 0.99861687001523314, 0.99858821836766309, 0.99855927341349005, 0.99853003516974148, 0.99850050365361764, 0.99847067888249108, 0.99844056087390687, 0.99841014964558283, 0.998379445215409, 0.99834844760144803, 0.99831715682193489, 0.99828557289527742, 0.99825369584005541, 0.99822152567502132, 0.9981890624191001, 0.99815630609138895, 0.99812325671115776, 0.99808991429784855, 0.99805627887107562, 0.99802235045062604, 0.99798812905645895, 0.99795361470870581, 0.99791880742767081, 0.99788370723382991, 0.99784831414783182, 0.9978126281904971, 0.99777664938281929, 0.99774037774596347, 0.99770381330126745, 0.99766695607024114, 0.99762980607456675, 0.99759236333609846, 0.997554627876863, 0.99751659971905937, 0.99747827888505824, 0.99743966539740281, 0.99740075927880856, 0.99736156055216285, 0.99732206924052536, 0.99728228536712771, 0.99724220895537385, 0.9972018400288396, 0.99716117861127285, 0.99712022472659401, 0.99707897839889492, 0.99703743965243974, 0.99699560851166469, 0.99695348500117809, 0.99691106914575989, 0.99686836097036235, 0.99682536050010961, 0.99678206776029765, 0.99673848277639454, 0.99669460557404033, 0.99665043617904669, 0.99660597461739719, 0.99656122091524779, 0.99651617509892576, 0.99647083719493024, 0.99642520722993255, 0.99637928523077557, 0.99633307122447401, 0.99628656523821446, 0.99623976729935504, 0.99619267743542583, 0.99614529567412868, 0.99609762204333696, 0.9960496565710959, 0.99600139928562226, 0.99595285021530466, 0.99590400938870327, 0.99585487683454976, 0.99580545258174769, 0.99575573665937189, 0.99570572909666932, 0.99565542992305778, 0.99560483916812703, 0.9955539568616385, 0.99550278303352469, 0.99545131771388995, 0.99539956093301019, 0.99534751272133226, 0.99529517310947502, 0.99524254212822849, 0.99518961980855414, 0.99513640618158461, 0.9950829012786242, 0.99502910513114862, 0.99497501777080455, 0.99492063922941032, 0.99486596953895523, 0.99481100873160044, 0.99475575683967765, 0.99470021389569019, 0.99464437993231258, 0.99458825498239056, 0.99453183907894083, 0.99447513225515149, 0.99441813454438177, 0.99436084598016183, 0.99430326659619328, 0.99424539642634824, 0.99418723550467059, 0.99412878386537473, 0.99407004154284628, 0.99401100857164182, 0.99395168498648889, 0.99389207082228603, 0.99383216611410286, 0.99377197089717961, 0.99371148520692776, 0.99365070907892927, 0.99358964254893722, 0.99352828565287554, 0.99346663842683891, 0.99340470090709276, 0.99334247313007329, 0.99327995513238765, 0.99321714695081353, 0.99315404862229939, 0.99309066018396419, 0.99302698167309766, 0.99296301312716051, 0.99289875458378374, 0.99283420608076878, 0.99276936765608803, 0.99270423934788421, 0.99263882119447056, 0.99257311323433117, 0.99250711550611992, 0.99244082804866185, 0.9923742509009521, 0.99230738410215635, 0.99224022769161047, 0.99217278170882095, 0.99210504619346451, 0.99203702118538817, 0.99196870672460946, 0.9919001028513158, 0.99183120960586513, 0.99176202702878569, 0.99169255516077559, 0.99162279404270359, 0.9915527437156082, 0.99148240422069822, 0.99141177559935256, 0.99134085789312043, 0.99126965114372068, 0.99119815539304235, 0.99112637068314469, 0.99105429705625681, 0.99098193455477768, 0.99090928322127625, 0.99083634309849156, 0.99076311422933239, 0.99068959665687728, 0.99061579042437486, 0.9905416955752433, 0.99046731215307082, 0.99039264020161522, 0.99031767976480412, 0.99024243088673469, 0.99016689361167398, 0.99009106798405866, 0.99001495404849504, 0.98993855184975876, 0.98986186143279564, 0.98978488284272026, 0.98970761612481739, 0.98963006132454101, 0.98955221848751462, 0.98947408765953115, 0.98939566888655284, 0.98931696221471155, 0.98923796769030847, 0.98915868535981377, 0.98907911526986747, 0.98899925746727857, 0.98891911199902527, 0.98883867891225496, 0.9887579582542847, 0.98867695007260004, 0.9885956544148562, 0.98851407132887714, 0.98843220086265626, 0.98835004306435592, 0.98826759798230723, 0.98818486566501051, 0.98810184616113528, 0.98801853951951957, 0.98793494578917052, 0.98785106501926423, 0.98776689725914568, 0.98768244255832849, 0.98759770096649513, 0.98751267253349706, 0.98742735730935416, 0.98734175534425539, 0.9872558666885578, 0.98716969139278787, 0.98708322950764016, 0.98699648108397797, 0.98690944617283305, 0.98682212482540599, 0.98673451709306548, 0.98664662302734918, 0.98655844267996251, 0.98646997610278009, 0.98638122334784428, 0.98629218446736611, 0.98620285951372488, 0.98611324853946813, 0.9860233515973118, 0.9859331687401397, 0.98584270002100427, 0.98575194549312584, 0.98566090520989302, 0.98556957922486255, 0.98547796759175899, 0.98538607036447523, 0.98529388759707182, 0.9852014193437777, 0.98510866565898958, 0.98501562659727204, 0.98492230221335741, 0.98482869256214622, 0.98473479769870653, 0.98464061767827427, 0.98454615255625311, 0.98445140238821449, 0.98435636722989739, 0.98426104713720863, 0.98416544216622259, 0.98406955237318128, 0.9839733778144939, 0.98387691854673776, 0.98378017462665723, 0.98368314611116425, 0.98358583305733838, 0.98348823552242604, 0.98339035356384163, 0.98329218723916656, 0.98319373660614939, 0.98309500172270625, 0.98299598264692034, 0.98289667943704184, 0.98279709215148836, 0.9826972208488447, 0.98259706558786242, 0.98249662642746016, 0.982395903426724, 0.98229489664490632, 0.98219360614142714, 0.98209203197587291, 0.98199017420799706, 0.98188803289771998, 0.9817856081051286, 0.98168289989047697, 0.98157990831418562, 0.98147663343684188, 0.98137307531919971, 0.98126923402217958, 0.98116510960686876, 0.98106070213452079, 0.9809560116665561, 0.98085103826456121, 0.9807457819902895, 0.98064024290566032, 0.98053442107275968, 0.98042831655383988, 0.98032192941131924, 0.98021525970778289, 0.98010830750598177, 0.98000107286883298, 0.97989355585941995, 0.9797857565409922, 0.97967767497696534, 0.97956931123092095, 0.97946066536660659, 0.9793517374479358, 0.97924252753898811, 0.97913303570400889, 0.9790232620074093, 0.97891320651376645, 0.97880286928782323, 0.97869225039448793, 0.97858134989883505, 0.97847016786610441, 0.97835870436170147, 0.97824695945119755, 0.97813493320032907, 0.9780226256749982, 0.97791003694127276, 0.97779716706538555, 0.97768401611373523, 0.97757058415288534, 0.97745687124956526, 0.97734287747066917, 0.97722860288325675, 0.97711404755455278, 0.97699921155194724, 0.97688409494299511, 0.97676869779541664, 0.97665302017709688, 0.97653706215608604, 0.97642082380059936, 0.97630430517901667, 0.97618750635988294, 0.97607042741190786, 0.97595306840396612, 0.97583542940509693, 0.97571751048450417, 0.97559931171155667, 0.9754808331557876, 0.97536207488689475, 0.97524303697474091, 0.97512371948935261, 0.9750041225009215, 0.97488424607980328, 0.97476409029651834, 0.974643655221751, 0.97452294092635028, 0.97440194748132924, 0.97428067495786519, 0.9741591234272996, 0.97403729296113806, 0.97391518363105045, 0.97379279550887055, 0.97367012866659608, 0.97354718317638866, 0.973423959110574, 0.97330045654164177, 0.9731766755422453, 0.97305261618520178, 0.97292827854349195, 0.97280366269026064, 0.97267876869881609, 0.9725535966426303, 0.9724281465953386, 0.97230241863074007, 0.97217641282279743, 0.97205012924563627, 0.97192356797354629, 0.97179672908098014, 0.97166961264255391, 0.97154221873304669, 0.97141454742740141, 0.97128659880072343, 0.97115837292828189, 0.97102986988550866, 0.97090108974799882, 0.97077203259151035, 0.97064269849196427, 0.97051308752544463, 0.97038319976819798, 0.97025303529663409, 0.97012259418732549, 0.96999187651700702, 0.96986088236257673, 0.96972961180109496, 0.96959806490978495, 0.96946624176603224, 0.96933414244738514, 0.96920176703155403, 0.96906911559641218, 0.96893618821999494, 0.96880298498049999, 0.96866950595628754, 0.96853575122587965, 0.96840172086796072, 0.96826741496137769, 0.96813283358513913, 0.96799797681841571, 0.96786284474054018, 0.96772743743100731, 0.96759175496947381, 0.96745579743575805, 0.96731956490984039, 0.96718305747186295, 0.96704627520212949, 0.96690921818110542, 0.96677188648941814, 0.96663428020785602, 0.96649639941736942, 0.96635824419907013, 0.96621981463423112, 0.96608111080428727, 0.96594213279083407, 0.96580288067562892, 0.96566335454059016, 0.96552355446779758, 0.96538348053949186, 0.96524313283807484, 0.96510251144610959, 0.96496161644631984, 0.96482044792159061, 0.96467900595496769, 0.96453729062965787, 0.96439530202902857, 0.96425304023660785, 0.96411050533608478, 0.96396769741130894, 0.96382461654629059, 0.9636812628252005, 0.96353763633237, 0.96339373715229093, 0.96324956536961526, 0.96310512106915569, 0.96296040433588503, 0.96281541525493641, 0.96267015391160315, 0.96252462039133879, 0.96237881477975695, 0.96223273716263136, 0.9620863876258956, 0.96193976625564337, 0.96179287313812833, 0.96164570835976382, 0.96149827200712312, 0.96135056416693931, 0.961202584926105, 0.96105433437167254, 0.96090581259085406, 0.9607570196710209, 0.96060795569970436, 0.96045862076459476, 0.96030901495354193, 0.96015913835455535, 0.96000899105580328, 0.95985857314561374, 0.95970788471247359, 0.95955692584502894, 0.95940569663208497, 0.95925419716260607, 0.95910242752571551, 0.9589503878106953, 0.95879807810698647, 0.95864549850418901, 0.95849264909206155, 0.9583395299605213, 0.95818614119964463, 0.9580324828996658, 0.95787855515097831, 0.95772435804413392, 0.95756989166984263, 0.9574151561189731, 0.95726015148255228, 0.95710487785176535, 0.9569493353179559, 0.9567935239726254, 0.95663744390743388, 0.95648109521419911, 0.95632447798489695, 0.95616759231166137, 0.95601043828678423, 0.95585301600271499, 0.95569532555206127, 0.95553736702758818, 0.95537914052221873, 0.95522064612903357, 0.95506188394127078, 0.95490285405232611, 0.95474355655575271, 0.95458399154526119, 0.95442415911471956, 0.95426405935815306, 0.95410369236974435, 0.95394305824383308, 0.95378215707491631, 0.95362098895764791, 0.95345955398683913, 0.95329785225745767, 0.95313588386462889, 0.95297364890363423, 0.95281114746991258, 0.95264837965905946, 0.95248534556682662, 0.95232204528912312, 0.95215847892201411, 0.95199464656172172, 0.95183054830462399, 0.95166618424725591, 0.95150155448630858, 0.95133665911862941, 0.95117149824122205, 0.95100607195124653, 0.95084038034601881, 0.95067442352301101, 0.95050820157985116, 0.95034171461432349, 0.95017496272436786, 0.95000794600808014, 0.94984066456371197, 0.94967311848967073, 0.94950530788451948, 0.94933723284697691, 0.94916889347591715, 0.94900028987037, 0.94883142212952043, 0.9486622903527091, 0.94849289463943198, 0.94832323508934013, 0.94815331180223983, 0.94798312487809255, 0.947812674417015, 0.94764196051927874, 0.94747098328531032, 0.94729974281569129, 0.94712823921115807, 0.94695647257260163, 0.9467844430010679, 0.94661215059775761, 0.9464395954640259, 0.94626677770138223, 0.9460936974114913, 0.94592035469617142, 0.94574674965739569, 0.94557288239729154, 0.94539875301814069, 0.94522436162237899, 0.94504970831259616, 0.94487479319153644, 0.94469961636209776, 0.94452417792733234, 0.94434847799044586, 0.94417251665479818, 0.94399629402390284, 0.94381981020142702, 0.94364306529119157, 0.9434660593971711, 0.94328879262349352, 0.94311126507444032, 0.9429334768544464, 0.94275542806809998, 0.94257711882014261, 0.94239854921546895, 0.94221971935912685, 0.94204062935631749, 0.94186127931239483, 0.94168166933286579, 0.94150179952339041, 0.9413216699897814, 0.94114128083800441, 0.94096063217417747, 0.94077972410457189, 0.94059855673561099, 0.94041713017387096, 0.94023544452608032, 0.94005349989912013, 0.93987129640002376, 0.93968883413597659, 0.93950611321431676, 0.93932313374253407, 0.93913989582827084, 0.93895639957932087, 0.93877264510363068, 0.93858863250929803, 0.93840436190457277, 0.93821983339785686, 0.93803504709770325, 0.9378500031128173, 0.93766470155205539, 0.93747914252442577, 0.93729332613908811, 0.93710725250535321, 0.93692092173268349, 0.93673433393069239, 0.93654748920914499, 0.93636038767795715, 0.93617302944719571, 0.93598541462707896, 0.93579754332797549, 0.93560941566040556, 0.93542103173503943, 0.93523239166269878, 0.93504349555435573, 0.93485434352113284, 0.93466493567430342, 0.93447527212529113, 0.9342853529856705, 0.9340951783671656, 0.93390474838165161, 0.93371406314115346, 0.93352312275784632, 0.93333192734405557, 0.93314047701225644, 0.93294877187507441, 0.93275681204528449, 0.9325645976358119, 0.93237212875973119, 0.93217940553026701, 0.93198642806079335, 0.93179319646483405, 0.93159971085606208, 0.93140597134830017, 0.93121197805552025, 0.9310177310918436, 0.93082323057154071, 0.93062847660903114, 0.9304334693188836, 0.93023820881581609, 0.93004269521469507, 0.92984692863053631, 0.92965090917850424, 0.92945463697391195, 0.92925811213222143, 0.92906133476904307, 0.92886430500013606, 0.92866702294140779, 0.92846948870891444, 0.92827170241886003, 0.92807366418759729, 0.92787537413162691, 0.92767683236759801, 0.92747803901230741, 0.92727899418270021, 0.92707969799586942, 0.92688015056905571, 0.92668035201964771, 0.92648030246518176, 0.92628000202334204, 0.92607945081195986, 0.9258786489490145, 0.9256775965526326, 0.92547629374108786, 0.92527474063280168, 0.92507293734634266, 0.92487088400042627, 0.92466858071391544, 0.92446602760581986, 0.92426322479529632, 0.92406017240164862, 0.92385687054432719, 0.92365331934292916, 0.92344951891719862, 0.92324546938702601, 0.92304117087244852, 0.92283662349364959, 0.92263182737095906, 0.92242678262485356, 0.92222148937595527, 0.92201594774503315, 0.92181015785300202, 0.92160411982092272, 0.92139783377000206, 0.92119129982159298, 0.92098451809719384, 0.92077748871844922, 0.92057021180714904, 0.92036268748522909, 0.92015491587477038, 0.91994689709799982, 0.91973863127728928, 0.91953011853515632, 0.9193213589942637, 0.91911235277741898, 0.91890310000757547, 0.91869360080783102, 0.91848385530142851, 0.918273863611756, 0.91806362586234613, 0.9178531421768763, 0.91764241267916868, 0.91743143749319001, 0.91722021674305165, 0.91700875055300912, 0.91679703904746257, 0.91658508235095659, 0.91637288058817967, 0.91616043388396484, 0.9159477423632888, 0.91573480615127267, 0.91552162537318116, 0.91530820015442316, 0.91509453062055113, 0.91488061689726152, 0.91466645911039413, 0.91445205738593249, 0.91423741185000362, 0.91402252262887784, 0.91380738984896914, 0.91359201363683451, 0.91337639411917426, 0.91316053142283171, 0.91294442567479339, 0.91272807700218883, 0.91251148553229011, 0.91229465139251265, 0.91207757471041428, 0.91186025561369566, 0.91164269423020006, 0.91142489068791321, 0.91120684511496319, 0.91098855763962083, 0.91077002839029886, 0.91055125749555232, 0.91033224508407873, 0.91011299128471734, 0.90989349622644955, 0.9096737600383985, 0.90945378284982947, 0.90923356479014927, 0.90901310598890672, 0.90879240657579186, 0.90857146668063649, 0.90835028643341387, 0.9081288659642387, 0.90790720540336689, 0.9076853048811957, 0.90746316452826337, 0.90724078447524925, 0.90701816485297426, 0.9067953057923992, 0.90657220742462674, 0.9063488698808998, 0.90612529329260194, 0.90590147779125774, 0.90567742350853186, 0.90545313057622989, 0.90522859912629738, 0.90500382929082057, 0.90477882120202557, 0.90455357499227906, 0.90432809079408749, 0.90410236874009742, 0.90387640896309518, 0.90365021159600722, 0.90342377677189967, 0.90319710462397818, 0.9029701952855882, 0.90274304889021462, 0.90251566557148188, 0.90228804546315355, 0.90206018869913285, 0.90183209541346199, 0.90160376574032242, 0.90137519981403458, 0.90114639776905792, 0.90091735973999065, 0.90068808586157012, 0.9004585762686721, 0.90022883109631135, 0.89999885047964101, 0.89976863455395251, 0.89953818345467618, 0.89930749731738047, 0.89907657627777193, 0.89884542047169558, 0.8986140300351344, 0.89838240510420941, 0.8981505458151795, 0.89791845230444178, 0.8976861247085306, 0.89745356316411851, 0.8972207678080153, 0.89698773877716853, 0.89675447620866333, 0.89652098023972182, 0.89628725100770379, 0.89605328865010625, 0.89581909330456289, 0.89558466510884505, 0.89535000420086086, 0.89511511071865502, 0.89487998480040953, 0.89464462658444277, 0.89440903620921008, 0.89417321381330317, 0.89393715953545017, 0.89370087351451566, 0.89346435588950091, 0.89322760679954283, 0.89299062638391513, 0.89275341478202697, 0.89251597213342404, 0.89227829857778762, 0.89204039425493498, 0.89180225930481916, 0.89156389386752866, 0.89132529808328786, 0.89108647209245651, 0.89084741603552975, 0.8906081300531381, 0.89036861428604719, 0.8901288688751583, 0.88988889396150728, 0.8896486896862652, 0.88940825619073793, 0.88916759361636655, 0.88892670210472657, 0.8886855817975281, 0.88844423283661622, 0.88820265536397014, 0.88796084952170384, 0.88771881545206521, 0.88747655329743691, 0.88723406320033549, 0.8869913453034115, 0.88674839974944952, 0.88650522668136844, 0.88626182624222061, 0.88601819857519226, 0.88577434382360321, 0.88553026213090691, 0.8852859536406904, 0.88504141849667395, 0.88479665684271147, 0.8845516688227899, 0.88430645458102919, 0.88406101426168271, 0.88381534800913664, 0.88356945596791014, 0.88332333828265519, 0.88307699509815651, 0.88283042655933119, 0.88258363281122953, 0.88233661399903363, 0.88208937026805834, 0.88184190176375088, 0.88159420863169069, 0.88134629101758899, 0.88109814906728945, 0.88084978292676763, 0.88060119274213089, 0.88035237865961846, 0.88010334082560115, 0.87985407938658167, 0.87960459448919392, 0.87935488628020364, 0.87910495490650764, 0.87885480051513409, 0.87860442325324228, 0.87835382326812284, 0.87810300070719727, 0.877851955718018, 0.87760068844826833, 0.87734919904576225, 0.87709748765844453, 0.87684555443439072, 0.87659339952180626, 0.87634102306902761, 0.87608842522452135, 0.87583560613688416, 0.87558256595484318, 0.87532930482725535, 0.87507582290310748, 0.87482212033151674, 0.87456819726172963, 0.87431405384312266, 0.8740596902252018, 0.87380510655760257, 0.87355030299009007, 0.8732952796725586, 0.87304003675503195, 0.87278457438766277, 0.87252889272073297, 0.87227299190465368, 0.87201687208996459, 0.87176053342733462, 0.87150397606756091, 0.87124720016156965, 0.87099020586041553, 0.87073299331528164, 0.87047556267747961, 0.87021791409844895, 0.8699600477297581, 0.86970196372310293, 0.86944366223030756, 0.86918514340332431, 0.86892640739423299, 0.86866745435524151, 0.8684082844386849, 0.86814889779702653, 0.8678892945828568, 0.86762947494889342, 0.86736943904798169, 0.86710918703309414, 0.86684871905733019, 0.86658803527391637, 0.86632713583620635, 0.8660660208976807, 0.86580469061194631, 0.86554314513273711, 0.8652813846139138, 0.86501940920946307, 0.86475721907349845, 0.86449481436025966, 0.86423219522411254, 0.86396936181954931, 0.86370631430118783, 0.86344305282377243, 0.863179577542173, 0.86291588861138524, 0.86265198618653038, 0.86238787042285558, 0.86212354147573356, 0.86185899950066169, 0.86159424465326373, 0.86132927708928786, 0.86106409696460773, 0.86079870443522188, 0.860533099657254, 0.86026728278695264, 0.86000125398069083, 0.8597350133949665, 0.85946856118640225, 0.85920189751174492, 0.8589350225278658, 0.85866793639176087, 0.85840063926054977, 0.85813313129147661, 0.8578654126419093, 0.85759748346934006, 0.85732934393138449, 0.85706099418578241, 0.85679243439039676, 0.85652366470321462, 0.85625468528234616, 0.85598549628602505, 0.85571609787260816, 0.85544649020057584, 0.85517667342853121, 0.85490664771520042, 0.85463641321943284, 0.85436597010020032, 0.8540953185165977, 0.85382445862784218, 0.85355339059327373, 0.85328211457235481, 0.85301063072466987, 0.85273893920992605, 0.8524670401879525, 0.85219493381870026, 0.85192262026224252, 0.85165009967877436, 0.85137737222861265, 0.85110443807219593, 0.85083129737008423, 0.85055795028295944, 0.85028439697162428, 0.85001063759700313, 0.84973667232014194, 0.84946250130220713, 0.84918812470448646, 0.8489135426883887, 0.84863875541544331, 0.84836376304730066, 0.84808856574573155, 0.84781316367262749, 0.84753755699000044, 0.84726174585998282, 0.84698573044482695, 0.84670951090690594, 0.84643308740871237, 0.84615646011285917, 0.84587962918207893, 0.84560259477922428, 0.84532535706726741, 0.84504791620930009, 0.84477027236853353, 0.84449242570829863, 0.84421437639204533, 0.84393612458334277, 0.84365767044587958, 0.84337901414346295, 0.84310015584001929, 0.84282109569959385, 0.84254183388635018, 0.84226237056457121, 0.84198270589865776, 0.84170284005312945, 0.84142277319262404, 0.84114250548189784, 0.84086203708582485, 0.84058136816939766, 0.84030049889772651, 0.84001942943603947, 0.83973815994968248, 0.8394566906041192, 0.83917502156493073, 0.83889315299781586, 0.83861108506859017, 0.83832881794318748, 0.83804635178765796, 0.83776368676816926, 0.83748082305100602, 0.83719776080256958, 0.83691450018937807, 0.83663104137806654, 0.83634738453538648, 0.83606352982820598, 0.83577947742350922, 0.83549522748839711, 0.83521078019008654, 0.83492613569591057, 0.83464129417331812, 0.83435625578987405, 0.83407102071325934, 0.83378558911127021, 0.83349996115181879, 0.83321413700293268, 0.83292811683275492, 0.83264190080954359, 0.83235548910167245, 0.83206888187763006, 0.83178207930601999, 0.83149508155556073, 0.83120788879508589, 0.83092050119354344, 0.83063291891999613, 0.83034514214362121, 0.83005717103371035, 0.82976900575966939, 0.82948064649101871, 0.82919209339739264, 0.82890334664853937, 0.82861440641432127, 0.82832527286471458, 0.8280359461698088, 0.82774642649980779, 0.82745671402502807, 0.82716680891590033, 0.82687671134296803, 0.82658642147688843, 0.82629593948843127, 0.82600526554847975, 0.82571439982802997, 0.82542334249819049, 0.82513209373018293, 0.82484065369534165, 0.82454902256511309, 0.82425720051105622, 0.82396518770484273, 0.82367298431825609, 0.82338059052319201, 0.82308800649165814, 0.82279523239577435, 0.82250226840777207, 0.82220911469999425, 0.82191577144489569, 0.82162223881504293, 0.82132851698311349, 0.82103460612189627, 0.82074050640429164, 0.82044621800331075, 0.82015174109207589, 0.81985707584382028, 0.81956222243188792, 0.81926718102973339, 0.81897195181092208, 0.81867653494912962, 0.81838093061814221, 0.8180851389918562, 0.81778916024427817, 0.81749299454952484, 0.81719664208182285, 0.81690010301550864, 0.81660337752502865, 0.81630646578493882, 0.81600936796990453, 0.81571208425470099, 0.81541461481421229, 0.81511695982343224, 0.81481911945746355, 0.81452109389151806, 0.81422288330091641, 0.81392448786108829, 0.81362590774757204, 0.81332714313601473, 0.81302819420217176, 0.81272906112190713, 0.81242974407119317, 0.81213024322611038, 0.81183055876284738, 0.81153069085770069, 0.81123063968707498, 0.81093040542748263, 0.81062998825554389, 0.81032938834798607, 0.8100286058816446, 0.80972764103346195, 0.80942649398048827, 0.80912516489988007, 0.80882365396890199, 0.80852196136492493, 0.80822008726542682, 0.8079180318479926, 0.80761579529031347, 0.80731337777018752, 0.80701077946551925, 0.80670800055431935, 0.80640504121470491, 0.80610190162489903, 0.80579858196323095, 0.80549508240813594, 0.80519140313815474, 0.80488754433193421, 0.80458350616822671, 0.80427928882588973, 0.80397489248388687, 0.80367031732128646, 0.80336556351726229, 0.80306063125109306, 0.80275552070216283, 0.80245023204996002, 0.80214476547407809, 0.8018391211542153, 0.80153329927017414, 0.80122730000186193, 0.80092112352929012, 0.80061477003257431, 0.80030823969193454, 0.80000153268769458, 0.79969464920028233, 0.79938758941022936, 0.79908035349817119, 0.79877294164484658, 0.7984653540310982, 0.79815759083787197, 0.79784965224621673, 0.79754153843728504, 0.79723324959233222, 0.79692478589271687, 0.79661614751989995, 0.79630733465544568, 0.7959983474810205, 0.7956891861783939, 0.79537985092943719, 0.79507034191612447, 0.79476065932053197, 0.79445080332483786, 0.79414077411132267, 0.79383057186236838, 0.79352019676045904, 0.79320964898818036, 0.79289892872821943, 0.79258803616336526, 0.79227697147650766, 0.79196573485063815, 0.79165432646884915, 0.79134274651433423, 0.79103099517038777, 0.79071907262040519, 0.79040697904788226, 0.7900947146364159, 0.78978227956970293, 0.789469674031541, 0.78915689820582791, 0.78884395227656146, 0.78853083642783983, 0.78821755084386091, 0.78790409570892272, 0.78759047120742265, 0.78727667752385799, 0.78696271484282543, 0.7866485833490211, 0.78633428322724064, 0.78601981466237858, 0.78570517783942861, 0.78539037294348368, 0.7850754001597352, 0.78476025967347363, 0.78444495167008799, 0.7841294763350658, 0.78381383385399317, 0.78349802441255434, 0.78318204819653192, 0.78286590539180656, 0.78254959618435704, 0.78223312076025975, 0.78191647930568919, 0.78159967200691716, 0.78128269905031322, 0.78096556062234468, 0.78064825690957584, 0.78033078809866807, 0.78001315437638019, 0.77969535592956807, 0.77937739294518416, 0.77905926561027816, 0.77874097411199583, 0.77842251863758016, 0.77810389937437008, 0.77778511650980109, 0.77746617023140518, 0.77714706072681006, 0.77682778818373965, 0.77650835279001384, 0.77618875473354809, 0.77586899420235378, 0.77554907138453777, 0.77522898646830241, 0.77490873964194551, 0.77458833109385994, 0.7742677610125337, 0.77394702958655015, 0.77362613700458704, 0.77330508345541749, 0.77298386912790884, 0.77266249421102329, 0.77234095889381726, 0.77201926336544191, 0.7716974078151424, 0.77137539243225794, 0.77105321740622201, 0.77073088292656178, 0.77040838918289833, 0.77008573636494648, 0.7697629246625145, 0.76943995426550416, 0.76911682536391091, 0.76879353814782281, 0.76847009280742151, 0.76814648953298159, 0.76782272851487054, 0.76749880994354869, 0.76717473400956882, 0.76685050090357643, 0.76652611081630984, 0.76620156393859906, 0.7658768604613666, 0.76555200057562756, 0.76522698447248816, 0.76490181234314747, 0.76457648437889536, 0.7642510007711143, 0.76392536171127778, 0.7635995673909507, 0.76327361800178972, 0.76294751373554237, 0.76262125478404741, 0.76229484133923453, 0.76196827359312436, 0.76164155173782822, 0.76131467596554847, 0.76098764646857719, 0.76066046343929783, 0.76033312707018363, 0.76000563755379802, 0.75967799508279477, 0.75935019984991758, 0.75902225204799967, 0.75869415186996458, 0.75836589950882494, 0.75803749515768337, 0.75770893900973157, 0.7573802312582506, 0.75705137209661089, 0.75672236171827179, 0.75639320031678148, 0.75606388808577729, 0.75573442521898526, 0.75540481191021958, 0.75507504835338346, 0.75474513474246829, 0.75441507127155361, 0.75408485813480741, 0.75375449552648544, 0.75342398364093166, 0.75309332267257778, 0.75276251281594275, 0.7524315542656338, 0.75210044721634528, 0.75176919186285884, 0.75143778840004349, 0.75110623702285539, 0.75077453792633775, 0.75044269130562047, 0.7501106973559204, 0.74977855627254097, 0.74944626825087246, 0.74911383348639093, 0.74878125217465952, 0.74844852451132737, 0.74811565069212915, 0.74778263091288633, 0.74744946536950563, 0.74711615425797984, 0.74678269777438744, 0.74644909611489207, 0.74611534947574309, 0.74578145805327511, 0.74544742204390757, 0.74511324164414561, 0.74477891705057875, 0.74444444845988156, 0.74410983606881342, 0.743775080074218, 0.74344018067302375, 0.74310513806224332, 0.74276995243897348, 0.74243462400039562, 0.7420991529437746, 0.74176353946645945, 0.74142778376588281, 0.74109188603956144, 0.74075584648509496, 0.74041966530016701, 0.74008334268254428, 0.7397468788300765, 0.73941027394069703, 0.73907352821242156, 0.73873664184334897, 0.73839961503166118, 0.73806244797562182, 0.73772514087357788, 0.73738769392395864, 0.73705010732527498, 0.73671238127612071, 0.73637451597517145, 0.73603651162118433, 0.73569836841299896, 0.73536008654953589, 0.73502166622979781, 0.73468310765286882, 0.73434441101791403, 0.73400557652417997, 0.73366660437099429, 0.73332749475776549, 0.73298824788398309, 0.73264886394921735, 0.73230934315311891, 0.7319696856954192, 0.73162989177593007, 0.7312899615945434, 0.73094989535123145, 0.73060969324604619, 0.73026935547911997, 0.72992888225066477, 0.72958827376097202, 0.72924753021041311, 0.7289066517994387, 0.72856563872857849, 0.7282244911984419, 0.7278832094097174, 0.72754179356317195, 0.72720024385965187, 0.72685856050008191, 0.72651674368546582, 0.72617479361688553, 0.72583271049550124, 0.72549049452255188, 0.72514814589935439, 0.72480566482730335, 0.7244630515078716, 0.72412030614261003, 0.72377742893314645, 0.72343442008118719, 0.72309127978851506, 0.72274800825699081, 0.72240460568855247, 0.72206107228521466, 0.72171740824906916, 0.72137361378228504, 0.72102968908710741, 0.72068563436585831, 0.72034144982093651, 0.7199971356548166, 0.71965269207005, 0.71930811926926386, 0.71896341745516146, 0.71861858683052215, 0.71827362759820068, 0.71792853996112771, 0.71758332412230974, 0.71723798028482788, 0.71689250865183929, 0.71654690942657595, 0.71620118281234513, 0.71585532901252868, 0.71550934823058354, 0.71516324067004133, 0.7148170065345083, 0.71447064602766475, 0.7141241593532659, 0.71377754671514104, 0.71343080831719319, 0.71308394436339984, 0.71273695505781198, 0.71238984060455435, 0.71204260120782581, 0.71169523707189808, 0.71134774840111648, 0.71100013539989992, 0.71065239827273985, 0.71030453722420128, 0.70995655245892186, 0.70960844418161195, 0.70926021259705485, 0.70891185791010614, 0.70856338032569388, 0.70821478004881866, 0.70786605728455276, 0.70751721223804087, 0.70716824511449961, 0.70681915611921731, 0.70646994545755404, 0.70612061333494147, 0.70577115995688267, 0.70542158552895196, 0.70507189025679518, 0.70472207434612877, 0.70437213800274079, 0.70402208143248934, 0.70367190484130404, 0.70332160843518454, 0.70297119242020123, 0.70262065700249487, 0.70227000238827653, 0.70191922878382706, 0.70156833639549765, 0.70121732542970927, 0.70086619609295253, 0.70051494859178787, 0.7001635831328451, 0.69981209992282345, 0.69946049916849151, 0.69910878107668684, 0.69875694585431614, 0.69840499370835518, 0.69805292484584813, 0.69770073947390809, 0.69734843779971678, 0.69699602003052408, 0.69664348637364826, 0.69629083703647576, 0.6959380722264612, 0.69558519215112702, 0.69523219701806327, 0.69487908703492818, 0.69452586240944725, 0.69417252334941315, 0.69381907006268628, 0.69346550275719432, 0.69311182164093155, 0.69275802692195954, 0.69240411880840647, 0.69205009750846758, 0.69169596323040439, 0.69134171618254492, 0.69098735657328358, 0.69063288461108119, 0.69027830050446426, 0.68992360446202561, 0.68956879669242377, 0.68921387740438278, 0.68885884680669296, 0.68850370510820913, 0.68814845251785239, 0.68779308924460869, 0.6874376154975288, 0.68708203148572899, 0.68672633741839018, 0.68637053350475785, 0.68601461995414248, 0.6856585969759188, 0.68530246477952583, 0.68494622357446711, 0.68458987357030998, 0.68423341497668622, 0.68387684800329107, 0.68352017285988365, 0.68316338975628677, 0.68280649890238698, 0.68244950050813369, 0.68209239478353989, 0.68173518193868188, 0.68137786218369856, 0.68102043572879212, 0.68066290278422714, 0.68030526356033116, 0.67994751826749411, 0.67958966711616831, 0.67923171031686824, 0.67887364808017092, 0.67851548061671507, 0.67815720813720115, 0.67779883085239201, 0.67744034897311134, 0.67708176271024523, 0.67672307227474038, 0.67636427787760534, 0.67600537972990959, 0.6756463780427836, 0.67528727302741876, 0.67492806489506751, 0.67456875385704251, 0.67420934012471723, 0.67384982390952575, 0.6734902054229619, 0.67313048487658, 0.67277066248199457, 0.67241073845087962, 0.67205071299496955, 0.6716905863260576, 0.67133035865599722, 0.67097003019670121, 0.67060960116014123, 0.67024907175834858, 0.66988844220341348, 0.66952771270748479, 0.66916688348277065, 0.66880595474153737, 0.66844492669611, 0.66808379955887232, 0.66772257354226583, 0.66736124885879056, 0.6669998257210048, 0.66663830434152394, 0.66627668493302206, 0.66591496770823055, 0.66555315287993821, 0.66519124066099145, 0.66482923126429383, 0.66446712490280613, 0.66410492178954628, 0.66374262213758906, 0.66338022616006587, 0.66301773407016518, 0.66265514608113152, 0.66229246240626605, 0.66192968325892654, 0.66156680885252617, 0.66120383940053495, 0.66084077511647832, 0.66047761621393763, 0.66011436290655001, 0.65975101540800785, 0.65938757393205927, 0.65902403869250747, 0.65866040990321095, 0.65829668777808292, 0.65793287253109201, 0.65756896437626122, 0.65720496352766844, 0.6568408701994457, 0.65647668460578013, 0.65611240696091255, 0.65574803747913801, 0.65538357637480571, 0.65501902386231903, 0.65465438015613442, 0.65428964547076252, 0.65392482002076746, 0.65355990402076658, 0.65319489768543049, 0.65282980122948309, 0.65246461486770113, 0.65209933881491466, 0.65173397328600569, 0.6513685184959096, 0.6510029746596141, 0.65063734199215895, 0.65027162070863676, 0.64990581102419176, 0.64953991315402027, 0.64917392731337076, 0.64880785371754313, 0.64844169258188911, 0.64807544412181195, 0.64770910855276598, 0.64734268609025714, 0.64697617694984233, 0.64660958134712931, 0.64624289949777691, 0.64587613161749469, 0.6455092779220426, 0.64514233862723114, 0.64477531394892162, 0.6444082041030248, 0.64404100930550212, 0.64367372977236481, 0.64330636571967392, 0.64293891736354036, 0.64257138492012433, 0.64220376860563588, 0.64183606863633424, 0.64146828522852772, 0.64110041859857381, 0.64073246896287905, 0.64036443653789865, 0.63999632154013675, 0.63962812418614567, 0.6392598446925265, 0.63889148327592893, 0.63852304015304995, 0.63815451554063551, 0.6377859096554791, 0.63741722271442192, 0.63704845493435314, 0.63667960653220934, 0.63631067772497452, 0.63594166872967994, 0.63557257976340398, 0.63520341104327238, 0.63483416278645755, 0.63446483521017871, 0.63409542853170153, 0.63372594296833884, 0.63335637873744921, 0.63298673605643774, 0.63261701514275592, 0.63224721621390079, 0.63187733948741576, 0.63150738518088956, 0.63113735351195677, 0.63076724469829781, 0.63039705895763776, 0.63002679650774751, 0.62965645756644317, 0.62928604235158514, 0.62891555108107944, 0.62854498397287661, 0.6281743412449714, 0.62780362311540383, 0.62743282980225734, 0.62706196152366034, 0.62669101849778519, 0.62632000094284779, 0.62594890907710843, 0.62557774311887104, 0.62520650328648264, 0.6248351897983343, 0.62446380287286019, 0.62409234272853742, 0.62372080958388676, 0.62334920365747126, 0.62297752516789728, 0.62260577433381381, 0.62223395137391213, 0.62186205650692605, 0.62149008995163202, 0.62111805192684799, 0.62074594265143468, 0.6203737623442942, 0.62000151122437075, 0.61962918951065005, 0.61925679742215922, 0.61888433517796715, 0.61851180299718367, 0.61813920109895981, 0.61776652970248769, 0.61739378902700048, 0.61702097929177169, 0.61664810071611575, 0.61627515351938766, 0.61590213792098236, 0.61552905414033565, 0.61515590239692275, 0.61478268291025939, 0.61440939589990118, 0.61403604158544289, 0.6136626201865194, 0.6132891319228051, 0.61291557701401311, 0.61254195567989633, 0.61216826814024683, 0.61179451461489498, 0.61142069532371068, 0.61104681048660181, 0.61067286032351542, 0.61029884505443688, 0.6099247648993894, 0.60955062007843486, 0.60917641081167317, 0.60880213731924182, 0.60842779982131634, 0.6080533985381098, 0.6076789336898728, 0.60730440549689346, 0.60692981417949687, 0.60655515995804565, 0.60618044305293928, 0.60580566368461386, 0.60543082207354237, 0.60505591844023487, 0.60468095300523705, 0.60430592598913169, 0.60393083761253763, 0.60355568809610927, 0.60318047766053784, 0.60280520652654968, 0.60242987491490718, 0.60205448304640852, 0.6016790311418867, 0.6013035194222105, 0.60092794810828409, 0.60055231742104598, 0.60017662758147017, 0.59980087881056554, 0.59942507132937506, 0.59904920535897688, 0.59867328112048301, 0.59829729883504013, 0.59792125872382895, 0.59754516100806421, 0.59716900590899424, 0.59679279364790183, 0.5964165244461026, 0.59604019852494616, 0.59566381610581554, 0.59528737741012638, 0.59491088265932834, 0.59453433207490314, 0.59415772587836602, 0.59378106429126487, 0.59340434753517968, 0.59302757583172327, 0.59265074940254103, 0.59227386846930985, 0.59189693325373915, 0.59151994397757046, 0.5911429008625767, 0.59076580413056257, 0.59038865400336438, 0.59001145070284977, 0.58963419445091791, 0.58925688546949884, 0.58887952398055354, 0.58850211020607446, 0.58812464436808398, 0.58774712668863571, 0.58736955738981367, 0.58699193669373195, 0.5866142648225352, 0.58623654199839803, 0.58585876844352502, 0.58548094438015064, 0.58510307003053907, 0.58472514561698397, 0.58434717136180869, 0.58396914748736561, 0.5835910742160364, 0.58321295177023214, 0.58283478037239211, 0.58245656024498504, 0.58207829161050795, 0.5816999746914866, 0.5813216097104752, 0.58094319689005591, 0.58056473645283935, 0.58018622862146418, 0.57980767361859653, 0.5794290716669307, 0.57905042298918852, 0.57867172780811915, 0.57829298634649928, 0.57791419882713269, 0.57753536547285023, 0.57715648650651008, 0.57677756215099674, 0.57639859262922166, 0.57601957816412308, 0.57564051897866508, 0.57526141529583863, 0.57488226733866077, 0.5745030753301742, 0.57412383949344814, 0.57374456005157681, 0.57336523722768085, 0.57298587124490619, 0.57260646232642376, 0.57222701069543025, 0.57184751657514732, 0.57146798018882139, 0.57108840175972397, 0.57070878151115156, 0.57032911966642463, 0.56994941644888863, 0.56956967208191311, 0.56918988678889193, 0.56881006079324314, 0.56843019431840824, 0.56805028758785303, 0.56767034082506718, 0.56729035425356311, 0.56691032809687736, 0.56653026257856953, 0.56615015792222234, 0.56577001435144159, 0.56538983208985594, 0.56500961136111671, 0.56462935238889811, 0.56424905539689663, 0.56386872060883109, 0.56348834824844296, 0.56310793853949526, 0.56272749170577308, 0.56234700797108383, 0.56196648755925604, 0.56158593069414031, 0.56120533759960811, 0.56082470849955279, 0.56044404361788858, 0.56006334317855078, 0.55968260740549569, 0.55930183652270038, 0.55892103075416255, 0.55854019032390023, 0.55815931545595243, 0.55777840637437759, 0.55739746330325513, 0.55701648646668367, 0.55663547608878217, 0.55625443239368944, 0.55587335560556328, 0.55549224594858171, 0.55511110364694161, 0.55472992892485906, 0.55434872200656937, 0.55396748311632693, 0.55358621247840445, 0.55320491031709396, 0.55282357685670536, 0.55244221232156754, 0.55206081693602738, 0.55167939092444984, 0.55129793451121811, 0.55091644792073335, 0.55053493137741394, 0.55015338510569645, 0.54977180933003467, 0.54939020427489982, 0.54900857016478044, 0.54862690722418173, 0.5482452156776263, 0.54786349574965365, 0.5474817476648195, 0.54709997164769664, 0.54671816792287398, 0.54633633671495663, 0.54595447824856635, 0.54557259274834058, 0.54519068043893248, 0.54480874154501147, 0.54442677629126235, 0.54404478490238528, 0.54366276760309606, 0.5432807246181256, 0.54289865617222, 0.54251656249014024, 0.54213444379666209, 0.54175230031657617, 0.54137013227468789, 0.54098793989581651, 0.54060572340479618, 0.54022348302647505, 0.53984121898571502, 0.53945893150739255, 0.53907662081639718, 0.53869428713763257, 0.53831193069601579, 0.53792955171647727, 0.53754715042396062, 0.53716472704342288, 0.53678228179983378, 0.53639981491817579, 0.5360173266234447, 0.5356348171406482, 0.53525228669480696, 0.53486973551095374, 0.53448716381413341, 0.53410457182940319, 0.53372195978183201, 0.53333932789650074, 0.53295667639850197, 0.53257400551293943, 0.5321913154649287, 0.5318086064795966, 0.5314258787820807, 0.53104313259753011, 0.53066036815110429, 0.53027758566797389, 0.52989478537332002, 0.52951196749233398, 0.52912913225021785, 0.52874627987218381, 0.52836341058345393, 0.52798052460926026, 0.52759762217484507, 0.52721470350545963, 0.52683176882636529, 0.52644881836283275, 0.52606585234014169, 0.52568287098358135, 0.52529987451844962, 0.52491686317005359, 0.52453383716370905, 0.52415079672474008, 0.52376774207847965, 0.52338467345026896, 0.52300159106545729, 0.5226184951494024, 0.52223538592746932, 0.52185226362503168, 0.52146912846747051, 0.52108598068017398, 0.52070282048853833, 0.52031964811796694, 0.51993646379386993, 0.51955326774166488, 0.51917006018677636, 0.51878684135463526, 0.51840361147067948, 0.51802037076035312, 0.51763711944910695, 0.51725385776239796, 0.5168705859256888, 0.51648730416444866, 0.5161040127041524, 0.51572071177028023, 0.51533740158831831, 0.51495408238375828, 0.51457075438209687, 0.51418741780883614, 0.51380407288948293, 0.51342071984954929, 0.51303735891455204, 0.51265399031001235, 0.51227061426145615, 0.5118872309944138, 0.51150384073441968, 0.51112044370701248, 0.5107370401377348, 0.51035363025213298, 0.50997021427575728, 0.50958679243416138, 0.50920336495290242, 0.50881993205754106, 0.50843649397364088, 0.50805305092676867, 0.5076696031424941, 0.50728615084638951, 0.50690269426403023, 0.50651923362099371, 0.50613576914285996, 0.50575230105521141, 0.50536882958363227, 0.504985354953709, 0.50460187739103002, 0.50421839712118488, 0.50383491436976557, 0.50345142936236498, 0.5030679423245773, 0.50268445348199819, 0.50230096306022431, 0.50191747128485309, 0.50153397838148306, 0.50115048457571298, 0.50076699009314241, 0.50038349515937142, 0.5, 0.49961650484062864, 0.49923300990685771, 0.49884951542428713, 0.498466021618517, 0.49808252871514691, 0.49769903693977574, 0.49731554651800192, 0.49693205767542281, 0.49654857063763513, 0.49616508563023454, 0.49578160287881512, 0.49539812260897009, 0.49501464504629106, 0.49463117041636778, 0.49424769894478865, 0.4938642308571401, 0.49348076637900634, 0.49309730573596988, 0.49271384915361049, 0.49233039685750596, 0.49194694907323144, 0.49156350602635918, 0.49118006794245894, 0.49079663504709764, 0.49041320756583873, 0.49002978572424277, 0.48964636974786713, 0.48926295986226526, 0.48887955629298763, 0.48849615926558038, 0.4881127690055862, 0.48772938573854391, 0.48734600968998776, 0.48696264108544807, 0.48657928015045082, 0.48619592711051718, 0.48581258219116391, 0.48542924561790318, 0.48504591761624172, 0.48466259841168174, 0.48427928822971988, 0.48389598729584771, 0.4835126958355514, 0.48312941407431126, 0.48274614223760209, 0.4823628805508931, 0.48197962923964693, 0.48159638852932057, 0.48121315864536479, 0.48082993981322364, 0.48044673225833512, 0.48006353620613013, 0.47968035188203312, 0.47929717951146172, 0.47891401931982608, 0.4785308715325296, 0.47814773637496832, 0.47776461407253068, 0.47738150485059772, 0.47699840893454276, 0.4766153265497311, 0.47623225792152041, 0.47584920327525998, 0.47546616283629101, 0.47508313682994641, 0.47470012548155038, 0.4743171290164187, 0.47393414765985842, 0.47355118163716736, 0.47316823117363471, 0.47278529649454049, 0.47240237782515504, 0.4720194753907398, 0.47163658941654618, 0.47125372012781624, 0.47087086774978221, 0.47048803250766608, 0.47010521462668003, 0.46972241433202616, 0.46933963184889571, 0.46895686740246995, 0.46857412121791936, 0.46819139352040345, 0.46780868453507135, 0.46742599448706063, 0.46704332360149808, 0.46666067210349926, 0.46627804021816799, 0.46589542817059681, 0.4655128361858667, 0.46513026448904637, 0.46474771330519304, 0.46436518285935185, 0.46398267337655535, 0.46360018508182427, 0.46321771820016633, 0.46283527295657712, 0.46245284957603944, 0.46207044828352284, 0.46168806930398426, 0.46130571286236755, 0.46092337918360293, 0.46054106849260751, 0.46015878101428498, 0.45977651697352501, 0.45939427659520388, 0.45901206010418349, 0.45862986772531217, 0.45824769968342383, 0.45786555620333802, 0.45748343750985987, 0.45710134382778012, 0.45671927538187446, 0.45633723239690394, 0.45595521509761483, 0.45557322370873771, 0.45519125845498859, 0.45480931956106757, 0.45442740725165948, 0.4540455217514337, 0.45366366328504337, 0.45328183207712608, 0.45290002835230347, 0.4525182523351805, 0.4521365042503464, 0.45175478432237376, 0.45137309277581839, 0.45099142983521967, 0.45060979572510024, 0.45022819066996533, 0.44984661489430366, 0.44946506862258612, 0.44908355207926676, 0.44870206548878194, 0.44832060907555021, 0.44793918306397268, 0.44755778767843257, 0.4471764231432947, 0.44679508968290615, 0.44641378752159561, 0.44603251688367318, 0.44565127799343074, 0.44527007107514105, 0.44488889635305845, 0.44450775405141835, 0.44412664439443672, 0.44374556760631062, 0.44336452391121789, 0.44298351353331644, 0.44260253669674493, 0.44222159362562241, 0.44184068454404762, 0.44145980967609977, 0.44107896924583756, 0.44069816347729962, 0.44031739259450436, 0.43993665682144928, 0.43955595638211142, 0.43917529150044732, 0.43879466240039189, 0.43841406930585974, 0.43803351244074396, 0.43765299202891617, 0.43727250829422692, 0.43689206146050485, 0.43651165175155704, 0.43613127939116891, 0.43575094460310343, 0.43537064761110189, 0.4349903886388834, 0.43461016791014417, 0.43422998564855841, 0.43384984207777771, 0.43346973742143047, 0.4330896719031227, 0.43270964574643694, 0.43232965917493288, 0.43194971241214697, 0.43156980568159187, 0.43118993920675697, 0.43081011321110813, 0.43043032791808689, 0.43005058355111137, 0.42967088033357542, 0.42929121848884849, 0.42891159824027603, 0.42853201981117872, 0.42815248342485279, 0.42777298930456986, 0.4273935376735763, 0.42701412875509387, 0.42663476277231915, 0.42625543994842324, 0.42587616050655197, 0.4254969246698258, 0.42511773266133923, 0.42473858470416137, 0.42435948102133492, 0.42398042183587697, 0.42360140737077834, 0.42322243784900332, 0.42284351349348992, 0.42246463452714977, 0.42208580117286743, 0.42170701365350077, 0.4213282721918809, 0.42094957701081148, 0.42057092833306936, 0.42019232638140352, 0.41981377137853587, 0.41943526354716065, 0.41905680310994409, 0.4186783902895248, 0.41830002530851346, 0.41792170838949211, 0.41754343975501501, 0.417165219627608, 0.41678704822976798, 0.4164089257839636, 0.41603085251263444, 0.41565282863819131, 0.41527485438301609, 0.41489692996946098, 0.41451905561984936, 0.41414123155647509, 0.41376345800160202, 0.4133857351774648, 0.41300806330626816, 0.41263044261018639, 0.4122528733113644, 0.41187535563191607, 0.41149788979392565, 0.41112047601944646, 0.41074311453050127, 0.41036580554908209, 0.40998854929715028, 0.40961134599663573, 0.40923419586943749, 0.40885709913742341, 0.40848005602242954, 0.40810306674626085, 0.40772613153069026, 0.40734925059745908, 0.40697242416827673, 0.40659565246482038, 0.40621893570873518, 0.40584227412163398, 0.40546566792509692, 0.40508911734067177, 0.40471262258987367, 0.40433618389418458, 0.40395980147505384, 0.4035834755538974, 0.40320720635209817, 0.40283099409100576, 0.4024548389919359, 0.40207874127617105, 0.40170270116495993, 0.40132671887951704, 0.40095079464102318, 0.400574928670625, 0.40019912118943451, 0.39982337241852983, 0.39944768257895408, 0.39907205189171596, 0.3986964805777895, 0.39832096885811336, 0.39794551695359154, 0.39757012508509282, 0.39719479347345038, 0.39681952233946222, 0.39644431190389079, 0.39606916238746248, 0.39569407401086831, 0.39531904699476295, 0.39494408155976518, 0.39456917792645763, 0.39419433631538625, 0.39381955694706078, 0.39344484004195435, 0.39307018582050313, 0.39269559450310659, 0.39232106631012731, 0.39194660146189025, 0.39157220017868377, 0.39119786268075823, 0.39082358918832683, 0.39044937992156514, 0.39007523510061071, 0.38970115494556323, 0.38932713967648463, 0.38895318951339825, 0.38857930467628943, 0.38820548538510502, 0.38783173185975323, 0.38745804432010367, 0.38708442298598694, 0.38671086807719501, 0.38633737981348065, 0.38596395841455716, 0.38559060410009888, 0.38521731708974061, 0.38484409760307731, 0.3844709458596644, 0.38409786207901764, 0.38372484648061239, 0.38335189928388425, 0.38297902070822831, 0.38260621097299952, 0.38223347029751231, 0.38186079890104024, 0.38148819700281639, 0.38111566482203296, 0.38074320257784078, 0.38037081048935001, 0.37999848877562931, 0.3796262376557058, 0.37925405734856543, 0.37888194807315201, 0.37850991004836809, 0.378137943493074, 0.37776604862608798, 0.37739422566618619, 0.37702247483210277, 0.37665079634252879, 0.37627919041611335, 0.37590765727146269, 0.37553619712713993, 0.37516481020166581, 0.37479349671351742, 0.37442225688112907, 0.37405109092289157, 0.37367999905715227, 0.37330898150221492, 0.37293803847633977, 0.37256717019774277, 0.37219637688459628, 0.3718256587550286, 0.37145501602712344, 0.37108444891892056, 0.37071395764841486, 0.37034354243355688, 0.36997320349225249, 0.36960294104236224, 0.36923275530170224, 0.36886264648804323, 0.36849261481911055, 0.3681226605125843, 0.36775278378609921, 0.36738298485724408, 0.36701326394356226, 0.36664362126255085, 0.36627405703166116, 0.36590457146829847, 0.3655351647898214, 0.36516583721354245, 0.36479658895672762, 0.36442742023659602, 0.36405833127032011, 0.36368932227502559, 0.36332039346779066, 0.36295154506564686, 0.36258277728557808, 0.3622140903445209, 0.36184548445936454, 0.36147695984695005, 0.36110851672407118, 0.3607401553074735, 0.36037187581385444, 0.36000367845986336, 0.35963556346210146, 0.35926753103712106, 0.3588995814014263, 0.35853171477147239, 0.35816393136366576, 0.35779623139436412, 0.35742861507987567, 0.35706108263645969, 0.35669363428032619, 0.3563262702276353, 0.35595899069449788, 0.35559179589697532, 0.35522468605107849, 0.35485766137276886, 0.35449072207795751, 0.35412386838250537, 0.35375710050222314, 0.35339041865287069, 0.35302382305015767, 0.35265731390974286, 0.35229089144723402, 0.35192455587818805, 0.35155830741811089, 0.35119214628245687, 0.35082607268662924, 0.35046008684597985, 0.35009418897580835, 0.34972837929136336, 0.34936265800784105, 0.34899702534038596, 0.34863148150409051, 0.34826602671399437, 0.34790066118508545, 0.34753538513229887, 0.34717019877051691, 0.34680510231456951, 0.34644009597923353, 0.34607517997923254, 0.34571035452923754, 0.34534561984386569, 0.34498097613768108, 0.34461642362519429, 0.3442519625208621, 0.34388759303908756, 0.34352331539421999, 0.3431591298005543, 0.34279503647233167, 0.34243103562373883, 0.34206712746890799, 0.34170331222191713, 0.34133959009678916, 0.34097596130749253, 0.34061242606794084, 0.34024898459199215, 0.33988563709345004, 0.33952238378606248, 0.33915922488352174, 0.33879616059946505, 0.33843319114747389, 0.33807031674107357, 0.33770753759373395, 0.33734485391886859, 0.33698226592983488, 0.33661977383993413, 0.33625737786241106, 0.33589507821045372, 0.33553287509719398, 0.33517076873570628, 0.33480875933900855, 0.33444684712006184, 0.33408503229176945, 0.33372331506697794, 0.33336169565847606, 0.33300017427899531, 0.33263875114120944, 0.33227742645773423, 0.33191620044112768, 0.33155507330389, 0.33119404525846274, 0.33083311651722941, 0.33047228729251521, 0.33011155779658657, 0.32975092824165153, 0.32939039883985888, 0.32902996980329891, 0.32866964134400289, 0.32830941367394251, 0.32794928700503057, 0.32758926154912038, 0.32722933751800548, 0.32686951512342, 0.32650979457703821, 0.32615017609047431, 0.32579065987528277, 0.32543124614295754, 0.32507193510493254, 0.32471272697258124, 0.32435362195721651, 0.32399462027009041, 0.32363572212239466, 0.32327692772525962, 0.32291823728975477, 0.32255965102688866, 0.3222011691476081, 0.32184279186279885, 0.32148451938328504, 0.32112635191982908, 0.32076828968313176, 0.32041033288383181, 0.32005248173250589, 0.31969473643966895, 0.31933709721577286, 0.31897956427120788, 0.31862213781630144, 0.31826481806131812, 0.31790760521646011, 0.31755049949186637, 0.31719350109761307, 0.31683661024371323, 0.31647982714011647, 0.31612315199670904, 0.31576658502331389, 0.31541012642969002, 0.31505377642553289, 0.31469753522047422, 0.3143414030240812, 0.31398538004585758, 0.31362946649524215, 0.31327366258160982, 0.31291796851427106, 0.3125623845024712, 0.31220691075539142, 0.31185154748214766, 0.31149629489179087, 0.31114115319330715, 0.31078612259561722, 0.31043120330757634, 0.3100763955379745, 0.30972169949553574, 0.30936711538891881, 0.30901264342671642, 0.30865828381745514, 0.30830403676959567, 0.30794990249153253, 0.30759588119159359, 0.30724197307804058, 0.30688817835906856, 0.30653449724280568, 0.30618092993731372, 0.3058274766505869, 0.30547413759055281, 0.30512091296507182, 0.30476780298193673, 0.30441480784887309, 0.30406192777353891, 0.30370916296352424, 0.30335651362635174, 0.30300397996947603, 0.30265156220028322, 0.30229926052609191, 0.30194707515415187, 0.30159500629164482, 0.30124305414568386, 0.30089121892331322, 0.30053950083150854, 0.30018790007717666, 0.29983641686715501, 0.29948505140821213, 0.29913380390704758, 0.29878267457029078, 0.29843166360450246, 0.29808077121617299, 0.29772999761172347, 0.29737934299750513, 0.29702880757979877, 0.29667839156481546, 0.29632809515869607, 0.29597791856751066, 0.29562786199725932, 0.29527792565387123, 0.29492810974320488, 0.2945784144710481, 0.29422884004311745, 0.29387938666505853, 0.29353005454244607, 0.29318084388078275, 0.29283175488550045, 0.29248278776195924, 0.29213394271544735, 0.29178521995118151, 0.29143661967430612, 0.29108814208989386, 0.29073978740294515, 0.29039155581838794, 0.29004344754107825, 0.28969546277579883, 0.28934760172726021, 0.28899986460010019, 0.28865225159888347, 0.28830476292810214, 0.2879573987921743, 0.28761015939544565, 0.28726304494218813, 0.28691605563660016, 0.2865691916828067, 0.28622245328485907, 0.2858758406467341, 0.28552935397233525, 0.28518299346549181, 0.28483675932995867, 0.28449065176941657, 0.28414467098747143, 0.28379881718765498, 0.28345309057342405, 0.28310749134816071, 0.28276201971517212, 0.28241667587769048, 0.28207146003887229, 0.28172637240179943, 0.28138141316947796, 0.28103658254483854, 0.28069188073073631, 0.28034730792995011, 0.2800028643451834, 0.27965855017906355, 0.27931436563414164, 0.27897031091289259, 0.27862638621771507, 0.27828259175093084, 0.27793892771478546, 0.27759539431144753, 0.27725199174300907, 0.2769087202114851, 0.27656557991881303, 0.27622257106685355, 0.27587969385739008, 0.27553694849212834, 0.27519433517269665, 0.27485185410064578, 0.27450950547744812, 0.27416728950449876, 0.27382520638311458, 0.27348325631453418, 0.2731414394999182, 0.27279975614034824, 0.27245820643682817, 0.27211679059028271, 0.27177550880155799, 0.27143436127142145, 0.27109334820056152, 0.27075246978958695, 0.27041172623902798, 0.27007111774933523, 0.26973064452087991, 0.26939030675395392, 0.26905010464876872, 0.26871003840545665, 0.26837010822406993, 0.26803031430458069, 0.26769065684688104, 0.26735113605078281, 0.26701175211601702, 0.26667250524223457, 0.26633339562900576, 0.26599442347582003, 0.26565558898208619, 0.26531689234713129, 0.26497833377020225, 0.26463991345046423, 0.26430163158700115, 0.26396348837881561, 0.26362548402482872, 0.26328761872387929, 0.26294989267472502, 0.26261230607604147, 0.26227485912642201, 0.2619375520243783, 0.26160038496833904, 0.26126335815665103, 0.2609264717875785, 0.26058972605930303, 0.2602531211699235, 0.25991665731745595, 0.2595803346998331, 0.25924415351490515, 0.25890811396043867, 0.25857221623411719, 0.25823646053354077, 0.25790084705622562, 0.2575653759996045, 0.25723004756102658, 0.25689486193775679, 0.25655981932697625, 0.25622491992578211, 0.25589016393118669, 0.25555555154011844, 0.25522108294942125, 0.25488675835585439, 0.2545525779560926, 0.25421854194672511, 0.25388465052425702, 0.25355090388510804, 0.25321730222561262, 0.25288384574202011, 0.25255053463049454, 0.25221736908711384, 0.25188434930787096, 0.25155147548867274, 0.25121874782534043, 0.25088616651360923, 0.25055373174912776, 0.25022144372745914, 0.24988930264407971, 0.24955730869437964, 0.24922546207366231, 0.24889376297714472, 0.24856221159995662, 0.24823080813714127, 0.24789955278365483, 0.2475684457343662, 0.24723748718405741, 0.24690667732742244, 0.2465760163590684, 0.24624550447351462, 0.2459151418651927, 0.24558492872844645, 0.24525486525753198, 0.24492495164661671, 0.24459518808978054, 0.24426557478101485, 0.24393611191422265, 0.24360679968321863, 0.24327763828172838, 0.24294862790338922, 0.24261976874174945, 0.24229106099026854, 0.24196250484231663, 0.24163410049117517, 0.24130584813003558, 0.24097774795200039, 0.24064980015008253, 0.24032200491720518, 0.23999436244620215, 0.23966687292981653, 0.23933953656070228, 0.23901235353142286, 0.2386853240344517, 0.23835844826217178, 0.23803172640687587, 0.23770515866076564, 0.2373787452159527, 0.23705248626445768, 0.23672638199821028, 0.23640043260904947, 0.23607463828872244, 0.23574899922888587, 0.2354235156211047, 0.2350981876568527, 0.23477301552751179, 0.23444799942437267, 0.23412313953863345, 0.2337984360614011, 0.23347388918369028, 0.23314949909642352, 0.23282526599043141, 0.23250119005645153, 0.23217727148512957, 0.23185351046701846, 0.23152990719257854, 0.23120646185217725, 0.23088317463608932, 0.2305600457344959, 0.23023707533748561, 0.22991426363505357, 0.22959161081710167, 0.22926911707343839, 0.22894678259377815, 0.22862460756774211, 0.22830259218485766, 0.22798073663455809, 0.22765904110618268, 0.22733750578897693, 0.22701613087209133, 0.22669491654458263, 0.22637386299541296, 0.22605297041344991, 0.22573223898746647, 0.22541166890614023, 0.2250912603580546, 0.22477101353169765, 0.22445092861546229, 0.22413100579764628, 0.22381124526645213, 0.22349164720998632, 0.2231722118162604, 0.22285293927319, 0.22253382976859482, 0.22221488349019902, 0.22189610062563014, 0.22157748136242006, 0.22125902588800428, 0.22094073438972195, 0.22062260705481579, 0.2203046440704321, 0.21998684562361992, 0.21966921190133204, 0.21935174309042427, 0.21903443937765527, 0.21871730094968672, 0.21840032799308307, 0.21808352069431103, 0.21776687923974031, 0.21745040381564301, 0.21713409460819338, 0.21681795180346819, 0.21650197558744577, 0.21618616614600694, 0.21587052366493426, 0.21555504832991207, 0.21523974032652637, 0.21492459984026496, 0.21460962705651643, 0.21429482216057139, 0.21398018533762148, 0.21366571677275936, 0.21335141665097901, 0.21303728515717474, 0.21272332247614217, 0.21240952879257746, 0.21209590429107733, 0.21178244915613909, 0.21146916357216033, 0.21115604772343871, 0.21084310179417226, 0.21053032596845911, 0.21021772043029713, 0.20990528536358433, 0.20959302095211785, 0.20928092737959492, 0.20896900482961228, 0.20865725348566577, 0.2083456735311508, 0.20803426514936196, 0.20772302852349245, 0.20741196383663485, 0.20710107127178057, 0.2067903510118197, 0.20647980323954113, 0.20616942813763173, 0.20585922588867739, 0.20554919667516214, 0.20523934067946803, 0.20492965808387553, 0.20462014907056297, 0.20431081382160632, 0.20400165251897956, 0.20369266534455444, 0.20338385248010005, 0.20307521410728335, 0.20276675040766784, 0.20245846156271508, 0.20215034775378338, 0.20184240916212814, 0.20153464596890175, 0.20122705835515348, 0.20091964650182892, 0.2006124105897707, 0.20030535079971773, 0.19999846731230547, 0.19969176030806568, 0.1993852299674258, 0.19907887647071004, 0.19877269999813812, 0.19846670072982592, 0.19816087884578476, 0.19785523452592207, 0.19754976795004014, 0.19724447929783728, 0.19693936874890694, 0.19663443648273771, 0.1963296826787137, 0.19602510751611324, 0.19572071117411033, 0.19541649383177345, 0.19511245566806579, 0.19480859686184526, 0.19450491759186422, 0.1942014180367691, 0.19389809837510102, 0.19359495878529515, 0.19329199944568065, 0.19298922053448092, 0.19268662222981259, 0.19238420470968665, 0.19208196815200751, 0.19177991273457318, 0.19147803863507507, 0.19117634603109812, 0.19087483510011999, 0.1905735060195119, 0.19027235896653799, 0.1899713941183554, 0.1896706116520141, 0.18937001174445628, 0.18906959457251737, 0.18876936031292502, 0.18846930914229937, 0.18816944123715268, 0.18786975677388978, 0.18757025592880688, 0.18727093887809287, 0.18697180579782824, 0.18667285686398527, 0.18637409225242807, 0.18607551213891182, 0.1857771166990837, 0.18547890610848206, 0.18518088054253651, 0.18488304017656776, 0.18458538518578782, 0.18428791574529918, 0.18399063203009552, 0.18369353421506124, 0.18339662247497135, 0.18309989698449153, 0.18280335791817737, 0.18250700545047532, 0.18221083975572194, 0.18191486100814391, 0.18161906938185784, 0.18132346505087055, 0.18102804818907803, 0.18073281897026666, 0.18043777756811213, 0.18014292415617972, 0.17984825890792427, 0.17955378199668942, 0.17925949359570847, 0.17896539387810378, 0.17867148301688657, 0.17837776118495707, 0.17808422855510436, 0.17779088530000592, 0.17749773159222804, 0.17720476760422565, 0.1769119935083418, 0.17661940947680815, 0.17632701568174403, 0.17603481229515738, 0.17574279948894378, 0.17545097743488702, 0.17515934630465835, 0.17486790626981713, 0.17457665750180962, 0.17428560017197015, 0.17399473445152025, 0.17370406051156873, 0.17341357852311173, 0.17312328865703203, 0.17283319108409978, 0.17254328597497198, 0.17225357350019233, 0.17196405383019114, 0.17167472713528559, 0.17138559358567879, 0.17109665335146074, 0.17080790660260747, 0.17051935350898134, 0.17023099424033078, 0.16994282896628987, 0.1696548578563789, 0.16936708108000392, 0.16907949880645656, 0.16879211120491411, 0.16850491844443938, 0.16821792069398017, 0.16793111812237005, 0.1676445108983276, 0.16735809919045641, 0.16707188316724531, 0.16678586299706744, 0.16650003884818132, 0.1662144108887299, 0.16592897928674077, 0.16564374421012595, 0.16535870582668211, 0.16507386430408955, 0.16478921980991351, 0.16450477251160289, 0.16422052257649078, 0.16393647017179425, 0.16365261546461363, 0.16336895862193357, 0.16308549981062198, 0.16280223919743048, 0.16251917694899398, 0.1622363132318308, 0.16195364821234209, 0.16167118205681258, 0.16138891493140983, 0.16110684700218425, 0.16082497843506938, 0.16054330939588085, 0.16026184005031752, 0.15998057056396053, 0.15969950110227349, 0.15941863183060229, 0.1591379629141752, 0.15885749451810227, 0.15857722680737601, 0.15829715994687066, 0.15801729410134224, 0.15773762943542896, 0.15745816611364988, 0.15717890430040632, 0.15689984415998071, 0.15662098585653705, 0.15634232955412042, 0.15606387541665734, 0.15578562360795484, 0.15550757429170148, 0.15522972763146659, 0.15495208379070002, 0.15467464293273281, 0.15439740522077589, 0.15412037081792118, 0.15384353988714095, 0.15356691259128769, 0.15329048909309406, 0.15301426955517311, 0.15273825414001729, 0.15246244300999962, 0.15218683632737257, 0.15191143425426851, 0.15163623695269957, 0.1513612445845568, 0.15108645731161141, 0.1508118752955136, 0.15053749869779293, 0.15026332767985806, 0.14998936240299693, 0.14971560302837589, 0.14944204971704073, 0.14916870262991577, 0.14889556192780407, 0.14862262777138746, 0.14834990032122575, 0.14807737973775759, 0.14780506618129985, 0.14753295981204756, 0.14726106079007389, 0.14698936927533024, 0.1467178854276453, 0.14644660940672627, 0.14617554137215782, 0.1459046814834023, 0.14563402989979979, 0.14536358678056727, 0.14509335228479958, 0.14482332657146885, 0.14455350979942416, 0.14428390212739173, 0.14401450371397506, 0.14374531471765384, 0.14347633529678538, 0.14320756560960324, 0.14293900581421759, 0.14267065606861556, 0.14240251653066005, 0.1421345873580907, 0.1418668687085235, 0.14159936073945023, 0.14133206360823913, 0.1410649774721342, 0.14079810248825519, 0.14053143881359781, 0.1402649866050335, 0.13999874601930917, 0.13973271721304747, 0.139466900342746, 0.13920129556477817, 0.13893590303539238, 0.13867072291071214, 0.13840575534673627, 0.13814100049933831, 0.13787645852426655, 0.13761212957714442, 0.13734801381346962, 0.13708411138861482, 0.13682042245782711, 0.13655694717622757, 0.13629368569881217, 0.13603063818045069, 0.1357678047758874, 0.13550518563974023, 0.13524278092650155, 0.13498059079053693, 0.1347186153860862, 0.13445685486726289, 0.13419530938805369, 0.13393397910231941, 0.13367286416379365, 0.13341196472608363, 0.13315128094266987, 0.13289081296690586, 0.13263056095201819, 0.13237052505110669, 0.13211070541714331, 0.13185110220297347, 0.1315917155613151, 0.13133254564475855, 0.13107359260576712, 0.1308148565966758, 0.13055633776969244, 0.13029803627689718, 0.1300399522702419, 0.12978208590155094, 0.12952443732252056, 0.12926700668471841, 0.12900979413958452, 0.12875279983843035, 0.12849602393243914, 0.12823946657266555, 0.12798312791003541, 0.12772700809534637, 0.12747110727926703, 0.12721542561233729, 0.12695996324496805, 0.12670472032744146, 0.12644969700990999, 0.12619489344239743, 0.1259403097747982, 0.12568594615687734, 0.12543180273827048, 0.12517787966848332, 0.12492417709689252, 0.12467069517274471, 0.12441743404515682, 0.12416439386311573, 0.12391157477547871, 0.12365897693097239, 0.1234066004781938, 0.12315444556560934, 0.12290251234155541, 0.12265080095423786, 0.12239931155173178, 0.12214804428198212, 0.12189699929280273, 0.12164617673187716, 0.12139557674675766, 0.12114519948486602, 0.12089504509349241, 0.12064511371979636, 0.12039540551080602, 0.12014592061341828, 0.1198966591743989, 0.11964762134038159, 0.11939880725786911, 0.11915021707323237, 0.11890185093271055, 0.11865370898241101, 0.11840579136830942, 0.11815809823624912, 0.11791062973194166, 0.11766338600096643, 0.11741636718877052, 0.11716957344066886, 0.1169230049018436, 0.11667666171734481, 0.11643054403208986, 0.11618465199086331, 0.11593898573831729, 0.11569354541897092, 0.11544833117721021, 0.11520334315728853, 0.11495858150332605, 0.1147140463593096, 0.1144697378690932, 0.11422565617639691, 0.11398180142480779, 0.11373817375777939, 0.1134947733186315, 0.11325160025055042, 0.11300865469658872, 0.11276593679966462, 0.11252344670256309, 0.11228118454793473, 0.11203915047829616, 0.11179734463602992, 0.11155576716338383, 0.1113144182024719, 0.11107329789527348, 0.1108324063836334, 0.11059174380926196, 0.11035131031373496, 0.11011110603849283, 0.1098711311248417, 0.10963138571395276, 0.10939186994686195, 0.10915258396447036, 0.10891352790754361, 0.10867470191671219, 0.10843610613247134, 0.10819774069518084, 0.10795960574506497, 0.10772170142221243, 0.10748402786657602, 0.10724658521797303, 0.10700937361608492, 0.10677239320045712, 0.10653564411049921, 0.10629912648548434, 0.10606284046454995, 0.10582678618669689, 0.10559096379078986, 0.10535537341555712, 0.10512001519959058, 0.10488488928134504, 0.10464999579913919, 0.10441533489115495, 0.10418090669543706, 0.10394671134989392, 0.10371274899229621, 0.10347901976027818, 0.10324552379133672, 0.10301226122283141, 0.1027792321919847, 0.1025464368358816, 0.1023138752914694, 0.10208154769555827, 0.10184945418482044, 0.10161759489579059, 0.10138596996486571, 0.10115457952830453, 0.10092342372222812, 0.10069250268261959, 0.10046181654532382, 0.10023136544604749, 0.1000011495203591, 0.099771168903688645, 0.099541423731327849, 0.09931191413842988, 0.099082640260009347, 0.098853602230942195, 0.098624800185965478, 0.098396234259677584, 0.098167904586537957, 0.097939811300867152, 0.097711954536846446, 0.097484334428518282, 0.097256951109785494, 0.09702980471441186, 0.096802895376021825, 0.096576223228100333, 0.096349788403992886, 0.096123591036904876, 0.095897631259902694, 0.095671909205912509, 0.095446425007720881, 0.095221178797974315, 0.094996170709179539, 0.094771400873702671, 0.094546869423770163, 0.094322576491468135, 0.094098522208742263, 0.09387470670739817, 0.093651130119100312, 0.093427792575373259, 0.093204694207600802, 0.092981835147025793, 0.092759215524750638, 0.0925368354717368, 0.092314695118804413, 0.09209279459663311, 0.091871134035761304, 0.091649713566586077, 0.091428533319363625, 0.0912075934242082, 0.090986894011093278, 0.090766435209850671, 0.090546217150170527, 0.090326239961601495, 0.090106503773550561, 0.089887008715282712, 0.089667754915921272, 0.089448742504447676, 0.089229971609701197, 0.089011442360379278, 0.088793154885036862, 0.088575109312086897, 0.088357305769799943, 0.088139744386304286, 0.087922425289585715, 0.087705348607487466, 0.087488514467709944, 0.08727192299781128, 0.087055574325206608, 0.086839468577168233, 0.086623605880825794, 0.08640798636316549, 0.086192610151030857, 0.085977477371122157, 0.085762588149996433, 0.085547942614067507, 0.085333540889605985, 0.085119383102738533, 0.084905469379448872, 0.084691799845576843, 0.084478374626818842, 0.084265193848727327, 0.084052257636711258, 0.083839566116035213, 0.083627119411820272, 0.083414917649043407, 0.083202960952537375, 0.082991249446990989, 0.082779783256948458, 0.082568562506809995, 0.082357587320831316, 0.082146857823123698, 0.081936374137653867, 0.081726136388244053, 0.081516144698571547, 0.081306399192169088, 0.081096899992424532, 0.080887647222580961, 0.080678641005736407, 0.080469881464843684, 0.08026136872271078, 0.080053102902000239, 0.079845084125229615, 0.079637312514770908, 0.079429788192851014, 0.079222511281550834, 0.079015481902806162, 0.078808700178407076, 0.078602166229997883, 0.078395880179077337, 0.078189842146997979, 0.077984052254966796, 0.077778510624044672, 0.077573217375146442, 0.077368172629040832, 0.077163376506350523, 0.076958829127551587, 0.076754530612973992, 0.07655048108280138, 0.076346680657070787, 0.07614312945567292, 0.075939827598351439, 0.075736775204703677, 0.075533972394180193, 0.075331419286084611, 0.075129115999573726, 0.07492706265365745, 0.074725259367198316, 0.074523706258912137, 0.074322403447367402, 0.074121351050985385, 0.073920549188040141, 0.073719997976658014, 0.073519697534818185, 0.073319647980352287, 0.073119849430944295, 0.072920302004130577, 0.072721005817299789, 0.072521960987692591, 0.072323167632401986, 0.072124625868373093, 0.071926335812402709, 0.071728297581140077, 0.071530511291085674, 0.071332977058592206, 0.071135694999863941, 0.070938665230956932, 0.070741887867778575, 0.070545363026088159, 0.070349090821495874, 0.070153071369463693, 0.06995730478530493, 0.069761791184183908, 0.069566530681116401, 0.06937152339096897, 0.06917676942845935, 0.068982268908156397, 0.068788021944479749, 0.068594028651699779, 0.068400289143937976, 0.068206803535166005, 0.068013571939206652, 0.067820594469732987, 0.067627871240268811, 0.067435402364188213, 0.067243187954715511, 0.067051228124925588, 0.066859522987743503, 0.066668072655944433, 0.066476877242153676, 0.066285936858846595, 0.066095251618348394, 0.065904821632834398, 0.065714647014329552, 0.065524727874708755, 0.06533506432569669, 0.06514565647886722, 0.064956504445644325, 0.064767608337301219, 0.064578968264960568, 0.064390584339594492, 0.06420245667202451, 0.064014585372921151, 0.063826970552804285, 0.063639612322042849, 0.063452510790854899, 0.063265666069307613, 0.063079078267316624, 0.062892747494646906, 0.062706673860911943, 0.062520857475574176, 0.062335298447944554, 0.062149996887182757, 0.061964952902296755, 0.061780166602143194, 0.061595638095427174, 0.061411367490701974, 0.061227354896369435, 0.061043600420679134, 0.060860104171729268, 0.060676866257465933, 0.060493886785683237, 0.060311165864023353, 0.060128703599976352, 0.059946500100879874, 0.059764555473919623, 0.059582869826129037, 0.059401443264388953, 0.059220275895428165, 0.059039367825822531, 0.058858719161995698, 0.058678330010218605, 0.058498200476609585, 0.058318330667134155, 0.058138720687605283, 0.057959370643682562, 0.05778028064087315, 0.057601450784531105, 0.057422881179857443, 0.057244571931900079, 0.05706652314555366, 0.056888734925559736, 0.056711207376506478, 0.056533940602828903, 0.056356934708808371, 0.056180189798573088, 0.056003705976097273, 0.055827483345201878, 0.0556515220095542, 0.055475822072667713, 0.055300383637902295, 0.055125206808463667, 0.054950291687403896, 0.054775638377621061, 0.054601246981859253, 0.054427117602708353, 0.054253250342604364, 0.054079645303828694, 0.053906302588508759, 0.053733222298617711, 0.053560404535974104, 0.053387849402242393, 0.053215556998932045, 0.053043527427398374, 0.052871760788841982, 0.052700257184308652, 0.052529016714689625, 0.052358039480721263, 0.052187325582985, 0.052016875121907447, 0.051846688197760227, 0.051676764910659867, 0.051507105360568073, 0.051337709647290897, 0.051168577870479626, 0.050999710129630116, 0.050831106524082847, 0.050662767153023036, 0.050494692115480522, 0.050326881510329269, 0.050159335436288033, 0.04999205399191986, 0.049825037275632145, 0.049658285385676626, 0.049491798420148891, 0.049325576476989041, 0.049159619653981135, 0.04899392804875341, 0.048828501758777842, 0.048663340881370643, 0.048498445513691479, 0.048333815752744091, 0.048169451695376009, 0.048005353438278331, 0.047841521077985893, 0.047677954710876935, 0.047514654433173376, 0.047351620340940648, 0.047188852530087366, 0.04702635109636577, 0.046864116135371225, 0.046702147742542333, 0.046540446013160985, 0.046379011042352092, 0.046217842925083685, 0.04605694175616698, 0.045896307630255706, 0.045735940641846939, 0.045575840885280494, 0.04541600845473881, 0.045256443444247285, 0.045097145947673944, 0.044938116058729216, 0.044779353870966432, 0.044620859477781216, 0.04446263297241182, 0.044304674447938897, 0.044146983997285116, 0.043989561713215886, 0.043832407688338626, 0.043675522015103052, 0.043518904785800894, 0.043362556092566173, 0.043206476027374596, 0.043050664682044215, 0.042895122148234655, 0.042739848517447721, 0.042584843881027012, 0.042430108330157423, 0.042275641955866139, 0.042121444849021639, 0.04196751710033414, 0.04181385880035543, 0.041660470039478703, 0.041507350907938556, 0.041354501495811047, 0.041201921893013582, 0.041049612189304752, 0.040897572474284605, 0.04074580283739393, 0.04059430336791503, 0.040443074154971115, 0.040292115287526464, 0.04014142685438632, 0.039991008944196771, 0.039840861645444758, 0.039690985046458072, 0.039541379235405294, 0.039392044300295637, 0.039242980328979105, 0.039094187409145997, 0.038945665628327464, 0.038797415073895059, 0.038649435833060686, 0.038501727992876822, 0.038354291640236238, 0.038207126861871721, 0.038060233744356631, 0.037913612374104455, 0.037767262837368643, 0.037621185220243103, 0.037475379608661263, 0.037329846088396901, 0.037184584745063642, 0.037039595664114966, 0.03689487893084431, 0.036750434630384798, 0.036606262847709126, 0.036462363667629949, 0.036318737174799443, 0.036175383453709409, 0.036032302588691112, 0.035889494663915333, 0.035746959763392261, 0.035604697970971544, 0.035462709370342127, 0.035320994045032195, 0.035179552078409393, 0.035038383553680219, 0.034897488553890521, 0.034756867161925165, 0.034616519460508144, 0.034476445532202415, 0.034336645459409842, 0.034197119324371084, 0.034057867209165926, 0.033918889195712787, 0.033780185365768767, 0.033641755800929929, 0.033503600582630577, 0.033365719792143977, 0.033228113510581914, 0.033090781818894521, 0.03295372479787062, 0.032816942528137105, 0.032680435090159665, 0.032544202564241953, 0.032408245030526195, 0.032272562568992635, 0.032137155259459871, 0.032002023181584349, 0.03186716641486087, 0.031732585038622252, 0.031598279132039164, 0.031464248774120462, 0.031330494043712576, 0.031197015019500007, 0.031063811780005113, 0.030930884403587822, 0.030798232968445916, 0.030665857552614972, 0.030533758233967756, 0.030401935090215049, 0.030270388198905041, 0.030139117637423329, 0.030008123482993088, 0.029877405812674618, 0.029746964703365852, 0.029616800231801965, 0.029486912474555371, 0.029357301508035616, 0.029227967408489652, 0.029098910252001176, 0.028970130114491344, 0.028841627071718112, 0.028713401199276567, 0.028585452572598702, 0.028457781266953308, 0.028330387357446141, 0.028203270919019807, 0.028076432026453657, 0.02794987075436367, 0.02782358717720268, 0.027697581369259927, 0.027571853404661395, 0.027446403357369697, 0.027321231301183857, 0.02719633730973936, 0.027071721456508102, 0.026947383814798331, 0.026823324457754705, 0.026699543458358233, 0.026576040889425945, 0.026452816823611447, 0.026329871333404031, 0.026207204491129454, 0.026084816368949493, 0.025962707038861887, 0.025840876572700511, 0.025719325042134866, 0.025598052518670811, 0.025477059073649722, 0.02535634477824894, 0.025235909703481663, 0.025115753920196715, 0.0249958774990785, 0.024876280510647386, 0.024756963025259149, 0.024637925113105197, 0.024519166844212514, 0.024400688288443384, 0.024282489515495831, 0.024164570594903068, 0.024046931596033827, 0.023929572588092085, 0.023812493640117116, 0.023695694820983382, 0.023579176199400698, 0.0234629378439139, 0.023346979822903069, 0.023231302204583415, 0.023115905057004893, 0.023000788448052756, 0.022885952445447222, 0.022771397116743253, 0.022657122529330831, 0.022543128750434793, 0.022429415847114664, 0.022315983886264878, 0.022202832934614447, 0.022089963058727291, 0.021977374325001797, 0.021865066799670985, 0.021753040548802505, 0.021641295638298474, 0.021529832133895588, 0.021418650101164893, 0.021307749605512072, 0.021197130712176881, 0.021086793486233546, 0.020976737992590755, 0.020866964295991164, 0.02075747246101195, 0.020648262552064256, 0.020539334633393469, 0.020430688769079053, 0.020322325023034604, 0.020214243459007741, 0.020106444140580049, 0.019998927131167077, 0.019891692494018287, 0.019784740292217107, 0.019678070588680707, 0.019571683446160226, 0.019465578927240379, 0.01935975709433968, 0.0192542180097105, 0.01914896173543873, 0.019043988333443895, 0.01893929786547921, 0.018834890393131298, 0.018730765977820418, 0.018626924680800294, 0.018523366563158061, 0.018420091685814322, 0.018317100109523032, 0.018214391894871396, 0.01811196710228008, 0.018009825792002943, 0.017907968024127086, 0.017806393858572911, 0.017705103355093676, 0.017604096573276107, 0.017503373572539838, 0.017402934412137638, 0.017302779151155356, 0.017202907848511639, 0.017103320562958213, 0.017004017353079715, 0.016904998277293748, 0.016806263393850551, 0.016707812760833496, 0.016609646436158365, 0.016511764477573965, 0.016414166942661734, 0.016316853888835747, 0.016219825373342822, 0.0161230814532623, 0.016026622185506101, 0.015930447626818833, 0.015834557833777407, 0.015738952862791311, 0.015643632770102667, 0.015548597611785564, 0.015453847443746949, 0.015359382321725734, 0.015265202301293468, 0.015171307437853832, 0.015077697786642585, 0.014984373402728013, 0.01489133434101042, 0.014798580656222249, 0.014706112402928184, 0.01461392963552488, 0.014522032408241015, 0.014430420775137454, 0.014339094790106921, 0.014248054506874108, 0.014157299978995785, 0.014066831259860357, 0.013976648402688308, 0.013886751460531865, 0.013797140486275117, 0.013707815532633894, 0.013618776652155773, 0.013530023897219967, 0.013441557320037434, 0.013353376972650877, 0.013265482906934467, 0.013177875174594067, 0.013090553827166951, 0.013003518916022083, 0.012916770492359841, 0.012830308607212071, 0.012744133311442085, 0.012658244655744666, 0.012572642690645786, 0.01248732746650294, 0.012402299033504816, 0.012317557441671512, 0.012233102740854374, 0.01214893498073577, 0.012065054210829484, 0.011981460480480488, 0.011898153838864722, 0.01181513433498943, 0.011732402017692822, 0.011649956935644135, 0.011567799137343682, 0.011485928671122803, 0.01140434558514386, 0.01132304992740002, 0.011242041745715414, 0.011161321087745035, 0.011080888000974787, 0.01100074253272143, 0.010920884730132474, 0.010841314640186228, 0.010762032309691583, 0.010683037785288452, 0.010604331113447163, 0.010525912340468901, 0.010447781512485432, 0.01036993867545899, 0.010292383875182609, 0.010215117157279741, 0.010138138567204413, 0.010061448150241181, 0.0099850459515050116, 0.0099089320159413408, 0.0098331063883260184, 0.0097575691132653075, 0.0096823202351959403, 0.0096073597983847847, 0.0095326878469291776, 0.0094583044247567027, 0.0093842095756251909, 0.0093104033431227196, 0.0092368857706676133, 0.0091636569015084435, 0.0090907167787237508, 0.0090180654452223785, 0.00894570294374325, 0.0088736293168553138, 0.0088018446069576539, 0.0087303488562793796, 0.0086591421068795693, 0.0085882244006473818, 0.0085175957793017787, 0.008447256284391802, 0.008377205957296463, 0.0083074448392244093, 0.008237972971214369, 0.0081687903941348727, 0.0080998971486841986, 0.0080312932753905386, 0.0079629788146117764, 0.0078949538065354874, 0.00782721829117905, 0.0077597723083895342, 0.007692615897843702, 0.007625749099047896, 0.0075591719513381506, 0.0074928844938800809, 0.0074268867656689386, 0.0073611788055293892, 0.0072957606521157903, 0.0072306323439119691, 0.0071657939192312226, 0.0071012454162163174, 0.0070369868728394347, 0.0069730183269022805, 0.0069093398160359198, 0.0068459513777007208, 0.0067828530491864658, 0.0067200448676122959, 0.0066575268699266554, 0.0065952990929072364, 0.006533361573161145, 0.0064717143471245131, 0.0064103574510628314, 0.0063492909210707826, 0.0062885147930722973, 0.0062280291028203871, 0.0061678338858971449, 0.0061079291777139111, 0.0060483150135111075, 0.0059889914283582368, 0.0059299584571537167, 0.0058712161346252678, 0.0058127644953293589, 0.0057546035736517065, 0.0056967334038067752, 0.0056391540198381107, 0.0055818654556182845, 0.0055248677448485051, 0.0054681609210592286, 0.0054117450176094928, 0.0053556200676874166, 0.0052997861043098116, 0.0052442431603224038, 0.005188991268399612, 0.0051340304610447141, 0.0050793607705897359, 0.0050249822291955071, 0.0049708948688514942, 0.0049170987213758011, 0.0048635938184154459, 0.0048103801914459177, 0.0047574578717714533, 0.0047048268905249269, 0.004652487278667683, 0.0046004390669898143, 0.0045486822861099951, 0.0044972169664753148, 0.0044460431383615551, 0.004395160831873024, 0.0043445700769422779, 0.0042942709033307325, 0.0042442633406280517, 0.0041945474182523146, 0.0041451231654502374, 0.0040959906112967848, 0.0040471497846953364, 0.0039986007143777424, 0.0039503434289041017, 0.003902377956663039, 0.003854704325871372, 0.0038073225645741671, 0.0037602327006450165, 0.0037134347617855945, 0.0036669287755259905, 0.0036207147692244313, 0.0035747927700674476, 0.0035291628050697632, 0.003483824901074295, 0.0034387790847522082, 0.00339402538260275, 0.0033495638209533607, 0.0033053944259596735, 0.0032615172236054035, 0.003217932239702348, 0.0031746394998904415, 0.0031316390296377006, 0.0030889308542401683, 0.0030465149988219697, 0.0030043914883353118, 0.0029625603475603168, 0.0029210216011051338, 0.0028797752734060489, 0.0028388213887270974, 0.0027981599711604521, 0.0027577910446262011, 0.0027177146328722923, 0.0026779307594746449, 0.0026384394478371487, 0.0025992407211914426, 0.0025603346025971918, 0.0025217211149418106, 0.0024834002809406841, 0.0024453721231369463, 0.0024076366639015911, 0.0023701939254333615, 0.0023330439297588601, 0.0022961866987325497, 0.0022596222540365307, 0.0022233506171807638, 0.0021873718095028472, 0.0021516858521682392, 0.0021162927661700914, 0.0020811925723291935, 0.0020463852912941394, 0.0020118709435411053, 0.0019776495493740165, 0.001943721128924436, 0.0019100857021515094, 0.001876743288842242, 0.0018436939086109994, 0.0018109375808998962, 0.001778474324978685, 0.0017463041599445894, 0.0017144271047225823, 0.0016828431780650521, 0.0016515523985519698, 0.0016205547845909996, 0.001589850354417166, 0.0015594391260930762, 0.0015293211175089194, 0.0014994963463823563, 0.0014699648302585189, 0.0014407265865100105, 0.0014117816323369614, 0.0013831299847668621, 0.0013547716606548965, 0.0013267066766834423, 0.0012989350493623486, 0.0012714567950290467, 0.001244271929848273, 0.0012173804698121238, 0.0011907824307402226, 0.0011644778282794976, 0.0011384666779041819, 0.0011127489949160907, 0.0010873247944441777, 0.0010621940914449235, 0.0010373569007020023, 0.0010128132368265041, 0.00098856311425687959, 0.00096460654725882833, 0.00094094354992541041, 0.00091757413617687966, 0.00089449831976090577, 0.00087171611425240769, 0.0008492275330535537, 0.00082703258939381685, 0.00080513129632991953, 0.00078352366674577789, 0.00076220971335261289, 0.00074118944868895031, 0.00072046288512034318, 0.00070003003483981585, 0.00067989090986741996, 0.00066004552205045641, 0.00064049388306353094, 0.00062123600440833204, 0.0006022718974137975, 0.00058360157323600337, 0.00056522504285821951, 0.00054714231709085404, 0.00052935340657156438, 0.00051185832176509072, 0.00049465707296331152, 0.00047774967028535453, 0.00046113612367731927, 0.00044481644291255451, 0.00042879063759154734, 0.00041305871714181208, 0.00039762069081805684, 0.0003824765677020725, 0.0003676263567027882, 0.00035307006655616036, 0.00033880770582522812, 0.00032483928290027997, 0.0003111648059985761, 0.00029778428316434846, 0.00028469772226913381, 0.00027190513101132963, 0.00025940651691652716, 0.00024720188733734494, 0.00023529124945342872, 0.00022367461027150704, 0.00021235197662539118, 0.00020132335517580868, 0.00019058875241068085, 0.00018014817464490074, 0.00017000162802038865, 0.00016014911850603664, 0.00015059065189787502, 0.00014132623381890586, 0.00013235586971915847, 0.00012367956487557841, 0.00011529732439236051, 0.00010720915320039381, 9.9415056057872153e-05, 9.1915037549794576e-05, 8.4709102088298405e-05, 7.7797253912381681e-05, 7.1179497088069699e-05, 6.4855835508526027e-05, 5.8826272893719445e-05, 5.3090812790757003e-05, 4.7649458573606474e-05, 4.2502213443262882e-05, 3.7649080427748505e-05, 3.309006238200185e-05, 2.882516198804419e-05, 2.4854381754757515e-05, 2.117772401805107e-05, 1.779519094086135e-05, 1.470678451293006e-05, 1.1912506551192692e-05, 9.4123586994454556e-06, 7.2063424284007915e-06, 5.2944590357983934e-06, 3.6767096464052074e-06, 2.3530952119044102e-06, 1.323616510895409e-06, 5.882741490603749e-07, 1.4706855888668713e-07, 0.0, 0.0};

typedef struct {
    pyo_audio_HEAD
    PyObject *input;
    Stream *input_stream;
    PyObject *transpo;
    Stream *transpo_stream;
    PyObject *feedback;
    Stream *feedback_stream;
    MYFLT winsize;
	MYFLT pointerPos;
    int in_count;
    MYFLT *buffer; // samples memory
    int modebuffer[4];
} Harmonizer;

static void
Harmonizer_transform_ii(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT trans = PyFloat_AS_DOUBLE(self->transpo);
    MYFLT feed = PyFloat_AS_DOUBLE(self->feedback);
    if (feed < 0.0)
        feed = 0.0;
    else if (feed > 1.0)
        feed = 1.0;

    ratio = MYPOW(2.0, trans/12.0);
	rate = (ratio-1.0) / self->winsize;
    inc = -rate / self->sr;

    for (i=0; i<self->bufsize; i++) {
		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos >= 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0.0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1.0)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feed);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_ai(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT *trans = Stream_getData((Stream *)self->transpo_stream);
    MYFLT feed = PyFloat_AS_DOUBLE(self->feedback);
    if (feed < 0.0)
        feed = 0.0;
    else if (feed > 1.0)
        feed = 1.0;

	MYFLT oneOnWinsize = 1.0 / self->winsize;
	MYFLT oneOnSr = 1.0 / self->sr;
    for (i=0; i<self->bufsize; i++) {
		ratio = MYPOW(2.0, trans[i]/12.0);
		rate = (ratio-1.0) * oneOnWinsize;
		inc = -rate * oneOnSr;;

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos >= 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feed);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_ia(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart, feedback;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT trans = PyFloat_AS_DOUBLE(self->transpo);
    MYFLT *feed = Stream_getData((Stream *)self->feedback_stream);

	ratio = MYPOW(2.0, trans/12.0);
	rate = (ratio-1.0) / self->winsize;
    inc = -rate / self->sr;

    for (i=0; i<self->bufsize; i++) {
        if (feed[i] < 0.0)
            feedback = 0.0;
        else if (feed[i] > 1.0)
            feedback = 1.0;
        else
            feedback = feed[i];

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos > 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feedback);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_aa(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart, feedback;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT *trans = Stream_getData((Stream *)self->transpo_stream);
    MYFLT *feed = Stream_getData((Stream *)self->feedback_stream);

	MYFLT oneOnWinsize = 1.0 / self->winsize;
	MYFLT oneOnSr = 1.0 / self->sr;
    for (i=0; i<self->bufsize; i++) {
		ratio = MYPOW(2.0, trans[i]/12.0);
		rate = (ratio-1.0) * oneOnWinsize;
		inc = -rate * oneOnSr;;

        if (feed[i] < 0.0)
            feedback = 0.0;
        else if (feed[i] > 1.0)
            feedback = 1.0;
        else
            feedback = feed[i];

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos > 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feedback);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void Harmonizer_feedbacktprocessing_ii(Harmonizer *self) { POST_PROCESSING_II };
static void Harmonizer_feedbacktprocessing_ai(Harmonizer *self) { POST_PROCESSING_AI };
static void Harmonizer_feedbacktprocessing_ia(Harmonizer *self) { POST_PROCESSING_IA };
static void Harmonizer_feedbacktprocessing_aa(Harmonizer *self) { POST_PROCESSING_AA };
static void Harmonizer_feedbacktprocessing_ireva(Harmonizer *self) { POST_PROCESSING_IREVA };
static void Harmonizer_feedbacktprocessing_areva(Harmonizer *self) { POST_PROCESSING_AREVA };
static void Harmonizer_feedbacktprocessing_revai(Harmonizer *self) { POST_PROCESSING_REVAI };
static void Harmonizer_feedbacktprocessing_revaa(Harmonizer *self) { POST_PROCESSING_REVAA };
static void Harmonizer_feedbacktprocessing_revareva(Harmonizer *self) { POST_PROCESSING_REVAREVA };

static void
Harmonizer_setProcMode(Harmonizer *self)
{
    int procmode, muladdmode;
    procmode = self->modebuffer[2] + self->modebuffer[3] * 10;
    muladdmode = self->modebuffer[0] + self->modebuffer[1] * 10;

	switch (procmode) {
        case 0:
            self->proc_func_ptr = Harmonizer_transform_ii;
            break;
        case 1:
            self->proc_func_ptr = Harmonizer_transform_ai;
            break;
        case 10:
            self->proc_func_ptr = Harmonizer_transform_ia;
            break;
        case 11:
            self->proc_func_ptr = Harmonizer_transform_aa;
            break;
    }
	switch (muladdmode) {
        case 0:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ii;
            break;
        case 1:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ai;
            break;
        case 2:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revai;
            break;
        case 10:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ia;
            break;
        case 11:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_aa;
            break;
        case 12:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revaa;
            break;
        case 20:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ireva;
            break;
        case 21:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_areva;
            break;
        case 22:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revareva;
            break;
    }
}

static void
Harmonizer_compute_next_data_frame(Harmonizer *self)
{
    (*self->proc_func_ptr)(self);
    (*self->muladd_func_ptr)(self);
}

static int
Harmonizer_traverse(Harmonizer *self, visitproc visit, void *arg)
{
    pyo_VISIT
    Py_VISIT(self->input);
    Py_VISIT(self->input_stream);
    Py_VISIT(self->transpo);
    Py_VISIT(self->transpo_stream);
    Py_VISIT(self->feedback);
    Py_VISIT(self->feedback_stream);
    return 0;
}

static int
Harmonizer_clear(Harmonizer *self)
{
    pyo_CLEAR
    Py_CLEAR(self->input);
    Py_CLEAR(self->input_stream);
    Py_CLEAR(self->transpo);
    Py_CLEAR(self->transpo_stream);
    Py_CLEAR(self->feedback);
    Py_CLEAR(self->feedback_stream);
    return 0;
}

static void
Harmonizer_dealloc(Harmonizer* self)
{
    pyo_DEALLOC
    free(self->buffer);
    Harmonizer_clear(self);
    self->ob_type->tp_free((PyObject*)self);
}

static PyObject *
Harmonizer_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    int i;
    MYFLT wintmp;
    PyObject *inputtmp, *input_streamtmp, *transpotmp=NULL, *feedbacktmp=NULL, *multmp=NULL, *addtmp=NULL;
    Harmonizer *self;
    self = (Harmonizer *)type->tp_alloc(type, 0);

    self->transpo = PyFloat_FromDouble(-7.0);
    self->feedback = PyFloat_FromDouble(0.0);
    self->winsize = 0.1;
    self->pointerPos = 1.0;
	self->in_count = 0;
	self->modebuffer[0] = 0;
	self->modebuffer[1] = 0;
	self->modebuffer[2] = 0;
	self->modebuffer[3] = 0;

    INIT_OBJECT_COMMON
    Stream_setFunctionPtr(self->stream, Harmonizer_compute_next_data_frame);
    self->mode_func_ptr = Harmonizer_setProcMode;

    static char *kwlist[] = {"input", "transpo", "feedback", "winsize", "mul", "add", NULL};

    if (! PyArg_ParseTupleAndKeywords(args, kwds, TYPE_O_OOFOO, kwlist, &inputtmp, &transpotmp, &feedbacktmp, &wintmp, &multmp, &addtmp))
        Py_RETURN_NONE;

	INIT_INPUT_STREAM

    if (transpotmp) {
        PyObject_CallMethod((PyObject *)self, "setTranspo", "O", transpotmp);
    }

    if (feedbacktmp) {
        PyObject_CallMethod((PyObject *)self, "setFeedback", "O", feedbacktmp);
    }

    if (multmp) {
        PyObject_CallMethod((PyObject *)self, "setMul", "O", multmp);
    }

    if (addtmp) {
        PyObject_CallMethod((PyObject *)self, "setAdd", "O", addtmp);
    }

    PyObject_CallMethod(self->server, "addStream", "O", self->stream);

    self->buffer = (MYFLT *)realloc(self->buffer, (self->sr+1) * sizeof(MYFLT));
    for (i=0; i<(self->sr+1); i++) {
        self->buffer[i] = 0.;
    }

    if (wintmp > 0.0 && wintmp <= 1.0)
        self->winsize = wintmp;
    else
        printf("Harmonizer : winsize lower than 0.0 or larger than 1.0 second, keeping default value.\n");

    (*self->mode_func_ptr)(self);

    return (PyObject *)self;
}

static PyObject * Harmonizer_getServer(Harmonizer* self) { GET_SERVER };
static PyObject * Harmonizer_getStream(Harmonizer* self) { GET_STREAM };
static PyObject * Harmonizer_setMul(Harmonizer *self, PyObject *arg) { SET_MUL };
static PyObject * Harmonizer_setAdd(Harmonizer *self, PyObject *arg) { SET_ADD };
static PyObject * Harmonizer_setSub(Harmonizer *self, PyObject *arg) { SET_SUB };
static PyObject * Harmonizer_setDiv(Harmonizer *self, PyObject *arg) { SET_DIV };

static PyObject * Harmonizer_play(Harmonizer *self, PyObject *args, PyObject *kwds) { PLAY };
static PyObject * Harmonizer_out(Harmonizer *self, PyObject *args, PyObject *kwds) { OUT };
static PyObject * Harmonizer_stop(Harmonizer *self) { STOP };

static PyObject * Harmonizer_multiply(Harmonizer *self, PyObject *arg) { MULTIPLY };
static PyObject * Harmonizer_inplace_multiply(Harmonizer *self, PyObject *arg) { INPLACE_MULTIPLY };
static PyObject * Harmonizer_add(Harmonizer *self, PyObject *arg) { ADD };
static PyObject * Harmonizer_inplace_add(Harmonizer *self, PyObject *arg) { INPLACE_ADD };
static PyObject * Harmonizer_sub(Harmonizer *self, PyObject *arg) { SUB };
static PyObject * Harmonizer_inplace_sub(Harmonizer *self, PyObject *arg) { INPLACE_SUB };
static PyObject * Harmonizer_div(Harmonizer *self, PyObject *arg) { DIV };
static PyObject * Harmonizer_inplace_div(Harmonizer *self, PyObject *arg) { INPLACE_DIV };

static PyObject *
Harmonizer_setTranspo(Harmonizer *self, PyObject *arg)
{
	PyObject *tmp, *streamtmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	tmp = arg;
	Py_INCREF(tmp);
	Py_DECREF(self->transpo);
	if (isNumber == 1) {
		self->transpo = PyNumber_Float(tmp);
        self->modebuffer[2] = 0;
	}
	else {
		self->transpo = tmp;
        streamtmp = PyObject_CallMethod((PyObject *)self->transpo, "_getStream", NULL);
        Py_INCREF(streamtmp);
        Py_XDECREF(self->transpo_stream);
        self->transpo_stream = (Stream *)streamtmp;
		self->modebuffer[2] = 1;
	}

    (*self->mode_func_ptr)(self);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Harmonizer_setFeedback(Harmonizer *self, PyObject *arg)
{
	PyObject *tmp, *streamtmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	tmp = arg;
	Py_INCREF(tmp);
	Py_DECREF(self->feedback);
	if (isNumber == 1) {
		self->feedback = PyNumber_Float(tmp);
        self->modebuffer[3] = 0;
	}
	else {
		self->feedback = tmp;
        streamtmp = PyObject_CallMethod((PyObject *)self->feedback, "_getStream", NULL);
        Py_INCREF(streamtmp);
        Py_XDECREF(self->feedback_stream);
        self->feedback_stream = (Stream *)streamtmp;
		self->modebuffer[3] = 1;
	}

    (*self->mode_func_ptr)(self);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Harmonizer_setWinsize(Harmonizer *self, PyObject *arg)
{
	MYFLT wintmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	if (isNumber == 1) {
        wintmp = PyFloat_AsDouble(arg);
        if (wintmp > 0.0 && wintmp <= 1.0)
			self->winsize = wintmp;
        else
            printf("winsize lower than 0.0 or larger than 1.0 second!\n");
	}

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMemberDef Harmonizer_members[] = {
    {"server", T_OBJECT_EX, offsetof(Harmonizer, server), 0, "Pyo server."},
    {"stream", T_OBJECT_EX, offsetof(Harmonizer, stream), 0, "Stream object."},
    {"input", T_OBJECT_EX, offsetof(Harmonizer, input), 0, "Input sound object."},
    {"transpo", T_OBJECT_EX, offsetof(Harmonizer, transpo), 0, "Transposition factor."},
    {"feedback", T_OBJECT_EX, offsetof(Harmonizer, feedback), 0, "Feedback factor."},
    {"mul", T_OBJECT_EX, offsetof(Harmonizer, mul), 0, "Mul factor."},
    {"add", T_OBJECT_EX, offsetof(Harmonizer, add), 0, "Add factor."},
    {NULL}  /* Sentinel */
};

static PyMethodDef Harmonizer_methods[] = {
    {"getServer", (PyCFunction)Harmonizer_getServer, METH_NOARGS, "Returns server object."},
    {"_getStream", (PyCFunction)Harmonizer_getStream, METH_NOARGS, "Returns stream object."},
    {"play", (PyCFunction)Harmonizer_play, METH_VARARGS|METH_KEYWORDS, "Starts computing without sending sound to soundcard."},
    {"out", (PyCFunction)Harmonizer_out, METH_VARARGS|METH_KEYWORDS, "Starts computing and sends sound to soundcard channel speficied by argument."},
    {"stop", (PyCFunction)Harmonizer_stop, METH_NOARGS, "Stops computing."},
	{"setTranspo", (PyCFunction)Harmonizer_setTranspo, METH_O, "Sets global transpo factor."},
    {"setFeedback", (PyCFunction)Harmonizer_setFeedback, METH_O, "Sets feedback factor."},
    {"setWinsize", (PyCFunction)Harmonizer_setWinsize, METH_O, "Sets the window size."},
	{"setMul", (PyCFunction)Harmonizer_setMul, METH_O, "Sets granulator mul factor."},
	{"setAdd", (PyCFunction)Harmonizer_setAdd, METH_O, "Sets granulator add factor."},
    {"setSub", (PyCFunction)Harmonizer_setSub, METH_O, "Sets inverse add factor."},
    {"setDiv", (PyCFunction)Harmonizer_setDiv, METH_O, "Sets inverse mul factor."},
    {NULL}  /* Sentinel */
};

static PyNumberMethods Harmonizer_as_number = {
    (binaryfunc)Harmonizer_add,                      /*nb_add*/
    (binaryfunc)Harmonizer_sub,                 /*nb_subtract*/
    (binaryfunc)Harmonizer_multiply,                 /*nb_multiply*/
    (binaryfunc)Harmonizer_div,                   /*nb_divide*/
    0,                /*nb_remainder*/
    0,                   /*nb_divmod*/
    0,                   /*nb_power*/
    0,                  /*nb_neg*/
    0,                /*nb_feedback*/
    0,                  /*(unaryfunc)array_abs,*/
    0,                    /*nb_nonzero*/
    0,                    /*nb_invert*/
    0,               /*nb_lshift*/
    0,              /*nb_rshift*/
    0,              /*nb_and*/
    0,              /*nb_xor*/
    0,               /*nb_or*/
    0,                                          /*nb_coerce*/
    0,                       /*nb_int*/
    0,                      /*nb_long*/
    0,                     /*nb_float*/
    0,                       /*nb_oct*/
    0,                       /*nb_hex*/
    (binaryfunc)Harmonizer_inplace_add,              /*inplace_add*/
    (binaryfunc)Harmonizer_inplace_sub,         /*inplace_subtract*/
    (binaryfunc)Harmonizer_inplace_multiply,         /*inplace_multiply*/
    (binaryfunc)Harmonizer_inplace_div,           /*inplace_divide*/
    0,        /*inplace_remainder*/
    0,           /*inplace_power*/
    0,       /*inplace_lshift*/
    0,      /*inplace_rshift*/
    0,      /*inplace_and*/
    0,      /*inplace_xor*/
    0,       /*inplace_or*/
    0,             /*nb_floor_divide*/
    0,              /*nb_true_divide*/
    0,     /*nb_inplace_floor_divide*/
    0,      /*nb_inplace_true_divide*/
    0,                     /* nb_index */
};

PyTypeObject HarmonizerType = {
    PyObject_HEAD_INIT(NULL)
    0,                         /*ob_transpo*/
    "_pyo.Harmonizer_base",         /*tp_name*/
    sizeof(Harmonizer),         /*tp_basictranspo*/
    0,                         /*tp_itemtranspo*/
    (destructor)Harmonizer_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_compare*/
    0,                         /*tp_repr*/
    &Harmonizer_as_number,             /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC | Py_TPFLAGS_CHECKTYPES, /*tp_flags*/
    "Harmonizer objects. Harmonize an input sound.",           /* tp_doc */
    (traverseproc)Harmonizer_traverse,   /* tp_traverse */
    (inquiry)Harmonizer_clear,           /* tp_clear */
    0,		               /* tp_richcompare */
    0,		               /* tp_weaklistoffset */
    0,		               /* tp_iter */
    0,		               /* tp_iternext */
    Harmonizer_methods,             /* tp_methods */
    Harmonizer_members,             /* tp_members */
    0,                      /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    0,      /* tp_init */
    0,                         /* tp_alloc */
    Harmonizer_new,                 /* tp_new */
};
