import sys

from typing import Optional, Union, Any, NoReturn

if sys.version_info < (3, 8):
    from typing_extensions import Literal
else:
    from typing import Literal

BUFFER_SIZE: int

class BGZFile:
    def __init__(
        self,
        filename: str,
        mode: Optional[Literal["r", "rb", "a", "ab", "w", "wb", "x", "xb"]],
        index: Optional[str],
    ) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def index(self) -> Optional[str]: ...
    def write(self, data: Union[bytes, bytearray, memoryview]) -> int: ...
    def read(self, size: int = ...) -> bytes: ...
    @property
    def closed(self) -> bool: ...
    def close(self) -> None: ...
    def __enter__(self) -> BGZFile: ...
    def __exit__(self, type, value, traceback) -> Any: ...
    def flush(self) -> None: ...
    def fileno(self) -> NoReturn: ...
    def rewind(self) -> None: ...
    def readable(self) -> bool: ...
    def writable(self) -> bool: ...
    def seekable(self) -> bool: ...
    def tell(self) -> int: ...
    def seek(self, offset: int, whence: int = ...) -> int: ...
    def readline(self, size: int = ...) -> bytes: ...
    def __iter__(self) -> BGZFile: ...
    def __next__(self) -> bytes: ...
