# PySNMP SMI module. Autogenerated from smidump -f python RFC1285-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:32 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( Bits, Counter32, Integer32, Integer32, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "Integer32", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "transmission")

# Types

class FddiMACLongAddressType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(6,6)
    fixedLength = 6
    
class FddiResourceId(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)
    
class FddiSMTStationIdType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    
class FddiTime(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)
    

# Objects

fddi = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15))
snmpFddiSMT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 1))
snmpFddiSMTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTNumber.setDescription("The number of SMT implementations (regardless of\ntheir current state) on this network management\napplication entity.  The value for this variable\nmust remain constant at least from one re-\ninitialization of the entity's network management\nsystem to the next re-initialization.")
snmpFddiSMTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 1, 2))
if mibBuilder.loadTexts: snmpFddiSMTTable.setDescription("A list of SMT entries.  The number of entries is\ngiven by  the value of snmpFddiSMTNumber.")
snmpFddiSMTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1)).setIndexNames((0, "RFC1285-MIB", "snmpFddiSMTIndex"))
if mibBuilder.loadTexts: snmpFddiSMTEntry.setDescription("An SMT entry containing information common to a\ngiven SMT.")
snmpFddiSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTIndex.setDescription("A unique value for each SMT.  Its value ranges\nbetween 1 and the value of snmpFddiSMTNumber.  The\nvalue for each SMT must remain constant at least\nfrom one re-initialization of the entity's network\nmanagement system to the next re-initialization.")
snmpFddiSMTStationId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 2), FddiSMTStationIdType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTStationId.setDescription("Uniquely identifies an FDDI station.")
snmpFddiSMTOpVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiSMTOpVersionId.setDescription("The version that this station is using for its\noperation (refer to ANSI 7.1.2.2).")
snmpFddiSMTHiVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTHiVersionId.setDescription("The highest version of SMT that this station\nsupports (refer to ANSI 7.1.2.2).")
snmpFddiSMTLoVersionId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTLoVersionId.setDescription("The lowest version of SMT that this station\nsupports (refer to ANSI 7.1.2.2).")
snmpFddiSMTMACCt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTMACCt.setDescription("The number of MACs in the station or\nconcentrator.")
snmpFddiSMTNonMasterCt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 2))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTNonMasterCt.setDescription("The number of Non Master PORTs (A, B, or S PORTs)\nin the station or concentrator.")
snmpFddiSMTMasterCt = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTMasterCt.setDescription("The number of Master PORTs in a node.  If the\nnode is not a concentrator, the value is zero.")
snmpFddiSMTPathsAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTPathsAvailable.setDescription("A value that indicates the PATH types available\nin the station.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis node has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary   0\n    Secondary   1\n        Local   2\n\nFor example, a station having Primary and Local\nPATHs available would have a value of 5 (2**0 +\n2**2).")
snmpFddiSMTConfigCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 3))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTConfigCapabilities.setDescription("A value that indicates capabilities that are\npresent in the node.  If 'holdAvailable' is\npresent, this indicates support of the optional\nHold Function (refer to ANSI SMT 9.4.3.2).  If\n'CF-Wrap-AB' is present, this indicates that the\nWRAP_AB state is forced.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the configuration\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n           Policy   Power\n    holdAvailable   0\n       CF-Wrap-AB   1 ")
snmpFddiSMTConfigPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 3))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiSMTConfigPolicy.setDescription("A value that indicates the configuration policies\ncurrently enforced in the node (refer to ANSI SMT\n9.4.3.2).  The 'configurationHold' policy refers\nto the Hold flag, and should not be present only\nif the Hold function is supported.  The 'CF-Wrap-\nAB' policy refers to the CF_Wrap_AB flag.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the configuration\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n               Policy   Power\n    configurationHold   0\n           CF-Wrap-AB   1 ")
snmpFddiSMTConnectionPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiSMTConnectionPolicy.setDescription("A value that indicates the connection policies\nenforced at the station.  A station sets the\ncorresponding policy for each of the connection\ntypes that it rejects.  The letter designations, X\nand Y, in the 'rejectX-Y' names have the following\nsignificance:  X represents the PC-Type of the\nlocal PORT and Y represents a PC-Neighbor in the\nevaluation of Connection-Policy (PC-Type, PC-\nNeighbor) that is done to determine the setting of\nT-Val(3) in the PC-Signaling sequence (refer to\nANSI Section 9.6.3).\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each of the connection\npolicies currently enforced on the node, 2 raised\nto a power is added to the sum.  The powers are\naccording to the following table:\n\n       Policy   Power\n    rejectA-A   0\n    rejectA-B   1\n    rejectA-S   2\n    rejectA-M   3\n    rejectB-A   4\n    rejectB-B   5\n    rejectB-S   6\n    rejectB-M   7\n    rejectS-A   8\n    rejectS-B   9\n    rejectS-S   10\n    rejectS-M   11\n    rejectM-A   12\n    rejectM-B   13\n    rejectM-S   14\n    rejectM-M   15\n\nImplementors should note that the polarity of\nthese bits is different in different places in an\nSMT system.  Implementors should take appropriate\ncare.")
snmpFddiSMTTNotify = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(2, 30))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiSMTTNotify.setDescription("The timer used in the Neighbor Notification\nprotocol, reported in seconds and ranging from 2\nto 30 seconds (refer to ANSI SMT 8.3.1).")
snmpFddiSMTStatusReporting = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTStatusReporting.setDescription("Indicates whether the node implements the Status\nReporting Protocol.  This object is included for\ncompatibility with products that were designed\nprior to the adoption of this standard.")
snmpFddiSMTECMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 15), Integer().subtype(subtypeSpec=SingleValueConstraint(8,7,6,5,4,3,2,1,)).subtype(namedValues=NamedValues(("ec0", 1), ("ec1", 2), ("ec2", 3), ("ec3", 4), ("ec4", 5), ("ec5", 6), ("ec6", 7), ("ec7", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTECMState.setDescription("Indicates the current state of the ECM state\nmachine (refer to ANSI SMT 9.5.2).")
snmpFddiSMTCFState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(5,6,3,4,1,2,)).subtype(namedValues=NamedValues(("cf0", 1), ("cf1", 2), ("cf2", 3), ("cf3", 4), ("cf4", 5), ("cf5", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTCFState.setDescription("The attachment configuration for the station or\nconcentrator (refer to ANSI SMT 9.7.4.3).")
snmpFddiSMTHoldState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 17), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,4,2,)).subtype(namedValues=NamedValues(("not-implemented", 1), ("not-holding", 2), ("holding-prm", 3), ("holding-sec", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTHoldState.setDescription("This value indicates the current state of the\nHold function.  The values are determined as\nfollows:  'holding-prm' is set if the primary ring\nis operational and the Recovery Enable Flag is\nclear (NOT NO_Flag(primary) AND NOT RE_Flag).  is\nset if the secondary ring is operational and the\nRecovery Enable Flag is clear (NOT\nNO_Flag(secondary) AND NOT RE_Flag).  Ref 9.4.3.\nand 10.3.1.  the primary or secondary, i.e., the\nRecovery Enable, RE_Flag, is set.")
snmpFddiSMTRemoteDisconnectFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiSMTRemoteDisconnectFlag.setDescription("A flag indicating that the station was remotely\ndisconnected from the network.  A station requires\na Connect Action (SM_CM_CONNECT.request (Connect))\nto rejoin and clear the flag (refer to ANSI\n6.4.5.2).")
snmpFddiSMTStationAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 1, 2, 1, 19), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,5,)).subtype(namedValues=NamedValues(("other", 1), ("connect", 2), ("disconnect", 3), ("path-Test", 4), ("self-Test", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiSMTStationAction.setDescription("This object, when read, always returns a value of\nother(1).  The behavior of setting this variable\nto each of the acceptable values is as follows:\n\nOther:          Results in a badValue error.\n\nConnect:        Generates an\nSM_CM_Connect.request(connect) signal to CMT\nindicating that the ECM State machine is to begin\na connection sequence.  The\nfddiSMTRemoteDisconnectFlag is cleared on the\nsetting of this variable to 1.  See ANSI Ref\n9.3.1.1.\n\nDisconnect:     Generates an\nSM_CM_Connect.request(disconnect) signal to ECM\nand sets the fddiSMTRemoteDisconnectFlag.  See\nANSI Ref 9.3.1.1.\n\nPath-Test:      Initiates a station path test.\nThe Path_Test variable (See ANSI Ref. 9.4.1) is\nset to Testing.  The results of this action are\nnot specified in this standard.\n\nSelf-Test:      Initiates a station self test.\nThe results of this action are not specified in\nthis standard.\n\nAttempts to set this object to all other values\nresults in a badValue error.  Agents may elect to\nreturn a badValue error on attempts to set this\nvariable to path-Test(4) or self-Test(5).")
snmpFddiMAC = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 2))
snmpFddiMACNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 2, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACNumber.setDescription("The total number of MAC implementations (across\nall SMTs) on this network management application\nentity.  The value for this variable must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
snmpFddiMACTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 2, 2))
if mibBuilder.loadTexts: snmpFddiMACTable.setDescription("A list of MAC entries.  The number of entries is\ngiven by the value of snmpFddiMACNumber.")
snmpFddiMACEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1)).setIndexNames((0, "RFC1285-MIB", "snmpFddiMACSMTIndex"), (0, "RFC1285-MIB", "snmpFddiMACIndex"))
if mibBuilder.loadTexts: snmpFddiMACEntry.setDescription("A MAC entry containing information common to a\ngiven MAC.")
snmpFddiMACSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACSMTIndex.setDescription("The value of the SMT index associated with this\nMAC.")
snmpFddiMACIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACIndex.setDescription("A unique value for each MAC on the managed\nentity.  The MAC identified by a particular value\nof this index is that identified by the same value\nof an ifIndex object instance.  That is, if a MAC\nis associated with the interface whose value of\nifIndex in the Internet-Standard MIB is equal to\n5, then the value of snmpFddiMACIndex shall also\nequal 5.  The value for each MAC must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
snmpFddiMACFrameStatusCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1799))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACFrameStatusCapabilities.setDescription("A value that indicates the MAC's bridge and end-\nstation capabilities for operating in a bridged\nFDDI network.\nThe value is a sum.  This value initially takes\nthe value zero, then for each capability present,\n2 raised to a power is added to the sum.  The\npowers are according to the following table:\n\n\n     Capability    Power\n     FSC-Type0    0\n     -- MAC repeats A/C indicators as received on\n     -- copying with the intent to forward.\n\n     FSC-Type1    1\n     -- MAC sets C but not A on copying for\n     -- forwarding.\n\n     FSC-Type2    2\n     -- MAC resets C and sets A on C set and\n     -- A reset if the frame is not copied and the\n     -- frame was addressed to this MAC\n\n     FSC-Type0-programmable    8\n     -- Type0 capability is programmable\n\n     FSC-Type1-programmable    9\n     -- Type1 capability is programmable\n\n     FSC-Type2-programmable   10\n     -- Type2 capability is programmable")
snmpFddiMACTMaxGreatestLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 4), FddiTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiMACTMaxGreatestLowerBound.setDescription("The greatest lower bound of T_Max supported for\nthis MAC.")
snmpFddiMACTVXGreatestLowerBound = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 5), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACTVXGreatestLowerBound.setDescription("The greatest lower bound of TVX supported for\nthis MAC.")
snmpFddiMACPathsAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACPathsAvailable.setDescription("A value that indicates the PATH types available\nfor this MAC.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis MAC has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary   0\n    Secondary   1\n        Local   2 ")
snmpFddiMACCurrentPath = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,16,8,4,)).subtype(namedValues=NamedValues(("unknown", 1), ("isolated", 16), ("primary", 2), ("secondary", 4), ("local", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACCurrentPath.setDescription("Indicates the association of the MAC with a\nstation PATH.")
snmpFddiMACUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 8), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACUpstreamNbr.setDescription("The MAC's upstream neighbor's long individual MAC\naddress.  It may be determined by the Neighbor\nInformation Frame protocol (refer to ANSI SMT\n7.2.1).  The value shall be reported as '00 00 00\n00 00 00' if it is unknown.")
snmpFddiMACOldUpstreamNbr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 9), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACOldUpstreamNbr.setDescription("The previous value of the MAC's upstream\nneighbor's long individual MAC address.  It may be\ndetermined by the Neighbor Information Frame\nprotocol (refer to ANSI SMT 7.2.1).  The value\nshall be reported as '00 00 00 00 00 00' if it is\nunknown.")
snmpFddiMACDupAddrTest = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("none", 1), ("pass", 2), ("fail", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACDupAddrTest.setDescription("The Duplicate Address Test flag, Dup_Addr_Test\n(refer to ANSI 8.3.1).")
snmpFddiMACPathsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 11), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiMACPathsRequested.setDescription("A value that indicates PATH(s) desired for this\nMAC.\n\nThe value is a sum which represents the individual\nPATHs that are desired.  This value initially\ntakes the value zero, then for each type of PATH\nthat this node is, 2 raised to a power is added to\nthe sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary   0\n    Secondary   1\n        Local   2\n     Isolated   3\n\nThe precedence order is primary, secondary, local,\nand then isolated if multiple PATHs are desired\nare set.")
snmpFddiMACDownstreamPORTType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,5,4,3,)).subtype(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("unknown", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACDownstreamPORTType.setDescription("Indicates the PC-Type of the first port that is\ndownstream of this MAC (the exit port).")
snmpFddiMACSMTAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 13), FddiMACLongAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACSMTAddress.setDescription("The 48 bit individual address of the MAC used for\nSMT frames.")
snmpFddiMACTReq = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 14), FddiTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiMACTReq.setDescription("The value of T-Req (refer to ANSI MAC 2.2.1 and\nANSI MAC 7.3.5.2).")
snmpFddiMACTNeg = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 15), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACTNeg.setDescription("The value of T-Neg (refer to ANSI MAC 2.2.1 and\nANSI MAC 7.3.5.2).")
snmpFddiMACTMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 16), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACTMax.setDescription("The value of T-Max (refer to ANSI MAC 2.2.1 and\nANSI MAC 7.3.5.2).")
snmpFddiMACTvxValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 17), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACTvxValue.setDescription("The value of TvxValue (refer to ANSI MAC 2.2.1\nand ANSI MAC 7.3.5.2).")
snmpFddiMACTMin = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 18), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACTMin.setDescription("The value of T-Min (refer to ANSI MAC 2.2.1 and\nANSI MAC 7.3.5.2).")
snmpFddiMACCurrentFrameStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiMACCurrentFrameStatus.setDescription("A value that indicates the MAC's operational\nframe status setting functionality.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each functionality\npresent, 2 raised to a power is added to the sum.\nThe powers are according to the following table:\n\n    Functionality   Power\n        FSC-Type0   0\n        -- MAC repeats A/C indicators as received\n\n        FSC-Type1   1\n        -- MAC sets C but not A on copying for\n        -- forwarding\n\n        FSC-Type2   2\n        -- MAC resets C and sets A on C set and A\n        -- reset if frame is not copied")
snmpFddiMACFrameCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACFrameCts.setDescription("Frame_Ct (refer to ANSI MAC 2.2.1).")
snmpFddiMACErrorCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACErrorCts.setDescription("Error_Ct (refer to ANSI MAC 2.2.1).")
snmpFddiMACLostCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACLostCts.setDescription("Lost_Ct (refer to ANSI MAC 2.2.1).")
snmpFddiMACFrameErrorThreshold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACFrameErrorThreshold.setDescription("A threshold for determining when a MAC Condition\nreport should be generated.  The condition is true\nwhen the ratio, ((delta snmpFddiMACLostCt + delta\nsnmpFddiMACErrorCt) / (delta snmpFddiMACFrameCt +\ndelta snmpFddiMACLostCt)) x 2**16. exceeds the\nthreshold.  It is used to determine when a station\nhas an unacceptable frame error threshold.  The\nsampling algorithm is implementation dependent.\nAny attempt to set this variable to a value of\nless than one shall result in a badValue error.\nThose who are familiar with the SNMP management\nframework will recognize that thresholds are not\nin keeping with the SNMP philosophy.  However,\nthis variable is supported by underlying SMT\nimplementations already and maintaining this\nthreshold should not pose an undue additional\nburden on SNMP agent implementors.")
snmpFddiMACFrameErrorRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACFrameErrorRatio.setDescription("This attribute is the actual ratio, ((delta\nsnmpFddiMACLostCt + delta snmpFddiMACErrorCt) /\n(delta snmpFddiMACFrameCt + delta\nsnmpFddiMACLostCt)) x 2**16.")
snmpFddiMACRMTState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 25), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,1,2,7,8,5,6,)).subtype(namedValues=NamedValues(("rm0", 1), ("rm1", 2), ("rm2", 3), ("rm3", 4), ("rm4", 5), ("rm5", 6), ("rm6", 7), ("rm7", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACRMTState.setDescription("Indicates the current state of the Ring\nManagement state machine (refer to ANSI Section\n10).")
snmpFddiMACDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 26), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACDaFlag.setDescription("The RMT flag Duplicate Address Flag, DA_Flag\n(refer to ANSI 10.3.1.2).")
snmpFddiMACUnaDaFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 27), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACUnaDaFlag.setDescription("A flag set when the upstream neighbor reports a\nduplicate address condition.  Reset when the\ncondition clears.")
snmpFddiMACFrameCondition = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 28), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACFrameCondition.setDescription("Indicates the MAC Condition is active when set.\nCleared when the condition clears and on power\nup.")
snmpFddiMACChipSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 29), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiMACChipSet.setDescription("This object identifies the hardware chip(s) which\nis (are) principally responsible for the\nimplementation of the MAC function.  A few OBJECT\nIDENTIFIERS are identified elsewhere in this memo.\nFor those The assignment of additional OBJECT\nIDENTIFIERs to various types of hardware chip sets\nis managed by the IANA.  For example, vendors\nwhose chip sets are not defined in this memo may\nrequest a number from the Internet Assigned\nNumbers Authority (IANA) which indicates the\nassignment of a enterprise specific subtree which,\namong other things, may be used to allocate OBJECT\nIDENTIFIER assignments for that enterprise's chip\nsets.  Similarly, in the absence of an\nappropriately assigned OBJECT IDENTIFIER in this\nmemo or in an enterprise specific subtree of a\nchip vendor, a board or system vendor can request\na number for a subtree from the IANA and make an\nappropriate assignment.  It is desired that,\nwhenever possible, the same OBJECT IDENTIFIER be\nused for all chips of a given type.  Consequently,\nthe assignment made in this memo for a chip, if\nany, should be used in preference to any other\nassignment and the assignment made by the chip\nmanufacturer, if any, should be used in preference\nto assignments made by users of those chips.  If\nthe hardware chip set is unknown, the object\nidentifier\n\nunknownChipSet OBJECT IDENTIFIER ::= { 0 0 }\n\nis returned.  Note that unknownChipSet is a\nsyntactically valid object identifier, and any\nconformant implementation of ASN.1 and the BER\nmust be able to generate and recognize this\nvalue.")
snmpFddiMACAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 2, 2, 1, 30), Integer().subtype(subtypeSpec=SingleValueConstraint(2,5,1,4,3,)).subtype(namedValues=NamedValues(("other", 1), ("enableLLCService", 2), ("disableLLCService", 3), ("connectMAC", 4), ("disconnectMAC", 5), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiMACAction.setDescription("This object, when read, always returns a value of\nother(1).  The behavior of setting this variable\nto each of the acceptable values is as follows:\n\nOther:                  Results in a badValue\n                        error.\n\nenableLLCService:       enables MAC service to\n                        higher layers.\n\ndisableLLCService:      disables MAC service to\n                        higher layers.\n\nconnectMAC:             connect this MAC in\n                        station.\n\ndisconnectMAC:          disconnect this MAC in\n                        station.\n\nAttempts to set this object to all other values\nresults in a badValue error.")
snmpFddiPATH = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 3))
snmpFddiPORT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 4))
snmpFddiPORTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 4, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTNumber.setDescription("The total number of PORT implementations (across\nall SMTs) on this network management application\nentity.  The value for this variable must remain\nconstant at least from one re-initialization of\nthe entity's network management system to the next\nre-initialization.")
snmpFddiPORTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 4, 2))
if mibBuilder.loadTexts: snmpFddiPORTTable.setDescription("A list of PORT entries.  The number of entries is\ngiven by the value of snmpFddiPORTNumber.")
snmpFddiPORTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1)).setIndexNames((0, "RFC1285-MIB", "snmpFddiPORTSMTIndex"), (0, "RFC1285-MIB", "snmpFddiPORTIndex"))
if mibBuilder.loadTexts: snmpFddiPORTEntry.setDescription("A PORT entry containing information common to a\ngiven PORT.")
snmpFddiPORTSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTSMTIndex.setDescription("The value of the SMT index associated with this\nPORT.")
snmpFddiPORTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTIndex.setDescription("A unique value for each PORT within a given SMT.\nIts value ranges between 1 and the sum of the\nvalues of snmpFddiSMTNonMasterCt\n{ snmpFddiSMTEntry 6 } and snmpFddiSMTMasterCt\n{ snmpFddiSMTEntry 7 } on the given SMT.  The\nvalue for each PORT must remain constant at least\nfrom one re-initialization of the entity's network\nmanagement system to the next re-initialization.")
snmpFddiPORTPCType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,4,)).subtype(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTPCType.setDescription("PC_Type (refer to ANSI SMT 9.2.2 and ANSI SMT\n9.6.3.2).")
snmpFddiPORTPCNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,5,4,3,)).subtype(namedValues=NamedValues(("a", 1), ("b", 2), ("s", 3), ("m", 4), ("unknown", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTPCNeighbor.setDescription("The type (PC_Neighbor) of the remote PORT that is\ndetermined in PC_Signaling in R_Val (1,2) (refer\nto ANSI SMT 9.6.3.2).")
snmpFddiPORTConnectionPolicies = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTConnectionPolicies.setDescription("A value that indicates the node's PORT policies.\nPc-MAC-LCT, Pc-MAC-Loop, and Pc-MAC-Placement\nindicate how the respective PC Signaling\nCapability flags should  be set (refer to ANSI SMT\n9.4.3.2).\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each PORT policy, 2\nraised to a power is added to the sum.  The powers\nare according to the following table:\n\n              Policy   Power\n          Pc-MAC-LCT   0\n         Pc-MAC-Loop   1\n    Pc-MAC-Placement   2 ")
snmpFddiPORTRemoteMACIndicated = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTRemoteMACIndicated.setDescription("The indication, in PC-Signaling that the remote\npartner intends to place a MAC in the output token\nPATH of this PORT.  Signaled as R_Val (9) (refer\nto ANSI SMT 9.6.3.2).")
snmpFddiPORTCEState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(5,4,3,2,1,)).subtype(namedValues=NamedValues(("ce0", 1), ("ce1", 2), ("ce2", 3), ("ce3", 4), ("ce4", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTCEState.setDescription("Indicates the current state of PORT's\nConfiguration Element (CE) (refer to ANSI 9.7.5).\nNote that this value represents the Current Path\ninformation for this PORT.")
snmpFddiPORTPathsRequested = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTPathsRequested.setDescription("A value that indicates the desired association(s)\nof the port with a station PATH.  The 'Primary'\nPath is the default.  The value of 'Secondary' is\nonly meaningful for S (slave) or M (master) PORT\nPC-Types.  This value effects the setting of the\nCF_Insert_S, and CF_Insert_L flags (refer to ANSI\nSection 9.4.3).  If the 'Primary' PATH is present,\nthen the Primary PATH (the default PATH) is\nselected.  If the 'Secondary' PATH is present and\nthe 'Primary' PATH is not present, then the\nCF_Insert_S flag is set.  If the 'Local' PATH is\nsent and neither the 'Primary' or 'Secondary'\nPATHs are sent, then the CF_Insert_L flag is set.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH\ndesired, 2 raised to a power is added to the sum.\nThe powers are according to the following table:\n\n         Path   Power\n      Primary   0\n    Secondary   1\n        Local   2\n     Isolated   3 ")
snmpFddiPORTMACPlacement = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 9), FddiResourceId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTMACPlacement.setDescription("Indicates the upstream MAC, if any, that is\nassociated with the PORT.  The value shall be zero\nif there is no MAC associated with the PORT.\nOtherwise, the value shall be equal to the value\nof snmpFddiMACIndex associated with the MAC.")
snmpFddiPORTAvailablePaths = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 7))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTAvailablePaths.setDescription("A value that indicates the PATH types available\nfor M and S PORTs.\n\nThe value is a sum.  This value initially takes\nthe value zero, then for each type of PATH that\nthis port has available, 2 raised to a power is\nadded to the sum.  The powers are according to the\nfollowing table:\n\n         Path   Power\n      Primary   0\n    Secondary   1\n        Local   2 ")
snmpFddiPORTMACLoopTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 11), FddiTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTMACLoopTime.setDescription("Time for the optional MAC Local Loop, T_Next(9),\nwhich is greater-than or equal-to 200 milliseconds\n(refer to ANSI SMT 9.4.4.2.3).")
snmpFddiPORTTBMax = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 12), FddiTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTTBMax.setDescription("TB_Max (refer to ANSI SMT 9.4.4.2.1).")
snmpFddiPORTBSFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTBSFlag.setDescription("The Break State, BS_Flag (refer to ANSI SMT\n9.4.3.4).")
snmpFddiPORTLCTFailCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTLCTFailCts.setDescription("The count of the consecutive times the link\nconfidence test (LCT) has failed during connection\nmanagement (refer to ANSI 9.4.1).")
snmpFddiPORTLerEstimate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4, 15))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTLerEstimate.setDescription("A long term average link error rate.  It ranges\nfrom 10**-4 to 10**-15 and is reported as the\nabsolute value of the exponent of the estimate.")
snmpFddiPORTLemRejectCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTLemRejectCts.setDescription("A link error monitoring count of the times that a\nlink has been rejected.")
snmpFddiPORTLemCts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTLemCts.setDescription("The aggregate link error monitor error count, set\nto zero only on station power_up.")
snmpFddiPORTLerCutoff = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTLerCutoff.setDescription("The link error rate estimate at which a link\nconnection will be broken.  It ranges from 10**-4\nto 10**-15 and is reported as the absolute value\nof the exponent.")
snmpFddiPORTLerAlarm = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(4, 15))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTLerAlarm.setDescription("The link error rate estimate at which a link\nconnection will generate an alarm.  It ranges from\n10**-4 to 10**-15 and is reported as the absolute\nvalue of the exponent of the estimate.")
snmpFddiPORTConnectState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 20), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,4,)).subtype(namedValues=NamedValues(("disabled", 1), ("connecting", 2), ("standby", 3), ("active", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTConnectState.setDescription("An indication of the connect state of this PORT.\nBasically, this gives a higher level view of the\nstate of the connection by grouping PCM states and\nthe PC-Withhold flag state.  The supported values\nand their corresponding PCM states and PC-Withhold\ncondition, when relevant, are:\n  disabled: (PC0:Off, PC9:Maint)\n\nconnecting: (PC1(Break) || PC3 (Connect) || PC4\n(Next)                 || PC5 (Signal) || PC6\n(Join) || PC7 (Verify))             &&\n(PC_Withhold = None)\n\n   standby: (NOT PC_Withhold == None)\n\n    active: (PC2:Trace || PC8:Active) ")
snmpFddiPORTPCMState = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 21), Integer().subtype(subtypeSpec=SingleValueConstraint(9,10,3,4,1,2,7,8,5,6,)).subtype(namedValues=NamedValues(("pc0", 1), ("pc9", 10), ("pc1", 2), ("pc2", 3), ("pc3", 4), ("pc4", 5), ("pc5", 6), ("pc6", 7), ("pc7", 8), ("pc8", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTPCMState.setDescription("(refer to SMT 9.6.2).")
snmpFddiPORTPCWithhold = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 22), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("none", 1), ("m-m", 2), ("other", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTPCWithhold.setDescription("PC_Withhold, (refer to ANSI SMT 9.4.1).")
snmpFddiPORTLerCondition = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTLerCondition.setDescription("This variable is set to true whenever LerEstimate\nis less than or equal to LerAlarm.")
snmpFddiPORTChipSet = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 24), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiPORTChipSet.setDescription("This object identifies the hardware chip(s) which\nis (are) principally responsible for the\nimplementation of the PORT (PHY) function.  A few\nOBJECT IDENTIFIERS are identified elsewhere in\nthis memo.  For those The assignment of additional\nOBJECT IDENTIFIERs to various types of hardware\nchip sets is managed by the IANA.  For example,\nvendors whose chip sets are not defined in this\nmemo may request a number from the Internet\nAssigned Numbers Authority (IANA) which indicates\nthe assignment of a enterprise specific subtree\nwhich, among other things, may be used to allocate\nOBJECT IDENTIFIER assignments for that\nenterprise's chip sets.  Similarly, in the absence\nof an appropriately assigned OBJECT IDENTIFIER in\nthis memo or in an enterprise specific subtree of\na chip vendor, a board or system vendor can\nrequest a number for a subtree from the IANA and\nmake an appropriate assignment.  It is desired\nthat, whenever possible, the same OBJECT\nIDENTIFIER be used for all chips of a given type.\nConsequently, the assignment made in this memo for\na chip, if any, should be used in preference to\nany other assignment and the assignment made by\nthe chip manufacturer, if any, should be used in\npreference to assignments made by users of those\nchips.  If the hardware chip set is unknown, the\nobject identifier\n\nunknownChipSet OBJECT IDENTIFIER ::= { 0 0 }\n\nis returned.  Note that unknownChipSet is a\nsyntactically valid object identifier, and any\nconformant implementation of ASN.1 and the BER\nmust be able to generate and recognize this\nvalue.")
snmpFddiPORTAction = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 4, 2, 1, 25), Integer().subtype(subtypeSpec=SingleValueConstraint(5,4,3,1,2,6,)).subtype(namedValues=NamedValues(("other", 1), ("maintPORT", 2), ("enablePORT", 3), ("disablePORT", 4), ("startPORT", 5), ("stopPORT", 6), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiPORTAction.setDescription("This object, when read, always returns a value of\nother(1).  The behavior of setting this variable\nto each of the acceptable values is as follows:\n\nOther:          Results in a badValue error.\n\nmaintPORT:      Signal PC_Maint\n\nenablePORT:     Signal PC_Enable\n\ndisablePORT:    Signal PC_Disable\n\nstartPORT:      Signal PC_Start\n\nstopPORT:       Signal PC_Stop\n\nSignals cause an SM_CM_CONTROL.request service to\nbe generated with a control_action of `Signal' and\nthe `variable' parameter set with the appropriate\nvalue (i.e., PC_Maint, PC_Enable, PC_Disable,\nPC_Start, PC_Stop).  Ref. ANSI SMT Section 9.3.2.\n\nAttempts to set this object to all other values\nresults in a badValue error.")
snmpFddiATTACHMENT = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 5))
snmpFddiATTACHMENTNumber = MibScalar((1, 3, 6, 1, 2, 1, 10, 15, 5, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTNumber.setDescription("The total number of attachments (across all SMTs)\non this network management application entity.\nThe value for this variable must remain constant\nat least from one re-initialization of the\nentity's network management system to the next\nre-initialization.")
snmpFddiATTACHMENTTable = MibTable((1, 3, 6, 1, 2, 1, 10, 15, 5, 2))
if mibBuilder.loadTexts: snmpFddiATTACHMENTTable.setDescription("A list of ATTACHMENT entries.  The number of\nentries is given by the value of\nsnmpFddiATTACHMENTNumber.")
snmpFddiATTACHMENTEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1)).setIndexNames((0, "RFC1285-MIB", "snmpFddiATTACHMENTSMTIndex"), (0, "RFC1285-MIB", "snmpFddiATTACHMENTIndex"))
if mibBuilder.loadTexts: snmpFddiATTACHMENTEntry.setDescription("An ATTACHMENT entry containing information common\nto a given set of ATTACHMENTs.\n\nThe ATTACHMENT Resource represents a PORT or a\npair of PORTs plus the optional associated optical\nbypass that are managed as a functional unit.\nBecause of its relationship to the PORT Objects,\nthere is a natural association of ATTACHMENT\nResource Indices to the PORT Indices.  The\nresource index for the ATTACHMENT is equal to the\nassociated PORT index for 'single-attachment' and\n'concentrator' type snmpFddiATTACHMENTClasses.\nFor 'dual-attachment' Classes, the ATTACHMENT\nIndex is the PORT Index of the A PORT of the A/B\nPORT Pair that represents the ATTACHMENT.")
snmpFddiATTACHMENTSMTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTSMTIndex.setDescription("The value of the SMT index associated with this\nATTACHMENT.")
snmpFddiATTACHMENTIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTIndex.setDescription("A unique value for each ATTACHMENT on a given\nSMT.  Its value ranges between 1 and the sum of\nthe values of snmpFddiSMTNonMasterCt {\nsnmpFddiSMTEntry 6 } and snmpFddiSMTMasterCt {\nsnmpFddiSMTEntry 7 } on the given SMT.  The value\nfor each ATTACHMENT must remain constant at least\nfrom one re-initialization of the entity's network\nmanagement system to the next re-initialization.")
snmpFddiATTACHMENTClass = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("single-attachment", 1), ("dual-attachment", 2), ("concentrator", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTClass.setDescription("The Attachment class.  This  represents a PORT or\na pair of PORTs plus the associated optional\noptical bypass that are managed as a functional\nunit.  The PORT associations are the following:\n\n    single-attachment - S PORTs\n      dual-attachment - A/B PORT Pairs\n         concentrator - M PORTs ")
snmpFddiATTACHMENTOpticalBypassPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTOpticalBypassPresent.setDescription("The value of this value is false for 'single-\nattachment' and { snmpFddiATTACHMENT 11 }.\nCorrect operation of CMT for single-attachment and\nconcentrator attachments requires that a bypass\nfunction must not loopback the network side of the\nMIC, but only the node side.")
snmpFddiATTACHMENTIMaxExpiration = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 5), FddiTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTIMaxExpiration.setDescription("I_Max (refer to ANSI SMT 9.4.4.2.1).  It is\nrecognized that some currently deployed systems do\nnot implement an optical bypass.  Systems which do\nnot implement optical bypass should return a value\nof 0.")
snmpFddiATTACHMENTInsertedStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ("unimplemented", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: snmpFddiATTACHMENTInsertedStatus.setDescription("Indicates whether the attachment is currently\ninserted in the node.")
snmpFddiATTACHMENTInsertPolicy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 15, 5, 2, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("true", 1), ("false", 2), ("unimplemented", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: snmpFddiATTACHMENTInsertPolicy.setDescription("Indicates the Insert Policy for this Attachment.\nInsert: True (1), Don't Insert:  False (2),\nUnimplemented (3)")
snmpFddiChipSets = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 6))
snmpFddiPHYChipSets = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 6, 1))
snmpFddiMACChipSets = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 6, 2))
snmpFddiPHYMACChipSets = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 15, 6, 3))

# Augmentions

# Exports

# Types
mibBuilder.exportSymbols("RFC1285-MIB", FddiMACLongAddressType=FddiMACLongAddressType, FddiResourceId=FddiResourceId, FddiSMTStationIdType=FddiSMTStationIdType, FddiTime=FddiTime)

# Objects
mibBuilder.exportSymbols("RFC1285-MIB", fddi=fddi, snmpFddiSMT=snmpFddiSMT, snmpFddiSMTNumber=snmpFddiSMTNumber, snmpFddiSMTTable=snmpFddiSMTTable, snmpFddiSMTEntry=snmpFddiSMTEntry, snmpFddiSMTIndex=snmpFddiSMTIndex, snmpFddiSMTStationId=snmpFddiSMTStationId, snmpFddiSMTOpVersionId=snmpFddiSMTOpVersionId, snmpFddiSMTHiVersionId=snmpFddiSMTHiVersionId, snmpFddiSMTLoVersionId=snmpFddiSMTLoVersionId, snmpFddiSMTMACCt=snmpFddiSMTMACCt, snmpFddiSMTNonMasterCt=snmpFddiSMTNonMasterCt, snmpFddiSMTMasterCt=snmpFddiSMTMasterCt, snmpFddiSMTPathsAvailable=snmpFddiSMTPathsAvailable, snmpFddiSMTConfigCapabilities=snmpFddiSMTConfigCapabilities, snmpFddiSMTConfigPolicy=snmpFddiSMTConfigPolicy, snmpFddiSMTConnectionPolicy=snmpFddiSMTConnectionPolicy, snmpFddiSMTTNotify=snmpFddiSMTTNotify, snmpFddiSMTStatusReporting=snmpFddiSMTStatusReporting, snmpFddiSMTECMState=snmpFddiSMTECMState, snmpFddiSMTCFState=snmpFddiSMTCFState, snmpFddiSMTHoldState=snmpFddiSMTHoldState, snmpFddiSMTRemoteDisconnectFlag=snmpFddiSMTRemoteDisconnectFlag, snmpFddiSMTStationAction=snmpFddiSMTStationAction, snmpFddiMAC=snmpFddiMAC, snmpFddiMACNumber=snmpFddiMACNumber, snmpFddiMACTable=snmpFddiMACTable, snmpFddiMACEntry=snmpFddiMACEntry, snmpFddiMACSMTIndex=snmpFddiMACSMTIndex, snmpFddiMACIndex=snmpFddiMACIndex, snmpFddiMACFrameStatusCapabilities=snmpFddiMACFrameStatusCapabilities, snmpFddiMACTMaxGreatestLowerBound=snmpFddiMACTMaxGreatestLowerBound, snmpFddiMACTVXGreatestLowerBound=snmpFddiMACTVXGreatestLowerBound, snmpFddiMACPathsAvailable=snmpFddiMACPathsAvailable, snmpFddiMACCurrentPath=snmpFddiMACCurrentPath, snmpFddiMACUpstreamNbr=snmpFddiMACUpstreamNbr, snmpFddiMACOldUpstreamNbr=snmpFddiMACOldUpstreamNbr, snmpFddiMACDupAddrTest=snmpFddiMACDupAddrTest, snmpFddiMACPathsRequested=snmpFddiMACPathsRequested, snmpFddiMACDownstreamPORTType=snmpFddiMACDownstreamPORTType, snmpFddiMACSMTAddress=snmpFddiMACSMTAddress, snmpFddiMACTReq=snmpFddiMACTReq, snmpFddiMACTNeg=snmpFddiMACTNeg, snmpFddiMACTMax=snmpFddiMACTMax, snmpFddiMACTvxValue=snmpFddiMACTvxValue, snmpFddiMACTMin=snmpFddiMACTMin, snmpFddiMACCurrentFrameStatus=snmpFddiMACCurrentFrameStatus, snmpFddiMACFrameCts=snmpFddiMACFrameCts, snmpFddiMACErrorCts=snmpFddiMACErrorCts, snmpFddiMACLostCts=snmpFddiMACLostCts, snmpFddiMACFrameErrorThreshold=snmpFddiMACFrameErrorThreshold, snmpFddiMACFrameErrorRatio=snmpFddiMACFrameErrorRatio, snmpFddiMACRMTState=snmpFddiMACRMTState, snmpFddiMACDaFlag=snmpFddiMACDaFlag, snmpFddiMACUnaDaFlag=snmpFddiMACUnaDaFlag, snmpFddiMACFrameCondition=snmpFddiMACFrameCondition, snmpFddiMACChipSet=snmpFddiMACChipSet, snmpFddiMACAction=snmpFddiMACAction, snmpFddiPATH=snmpFddiPATH, snmpFddiPORT=snmpFddiPORT, snmpFddiPORTNumber=snmpFddiPORTNumber, snmpFddiPORTTable=snmpFddiPORTTable, snmpFddiPORTEntry=snmpFddiPORTEntry, snmpFddiPORTSMTIndex=snmpFddiPORTSMTIndex, snmpFddiPORTIndex=snmpFddiPORTIndex, snmpFddiPORTPCType=snmpFddiPORTPCType, snmpFddiPORTPCNeighbor=snmpFddiPORTPCNeighbor, snmpFddiPORTConnectionPolicies=snmpFddiPORTConnectionPolicies, snmpFddiPORTRemoteMACIndicated=snmpFddiPORTRemoteMACIndicated, snmpFddiPORTCEState=snmpFddiPORTCEState, snmpFddiPORTPathsRequested=snmpFddiPORTPathsRequested, snmpFddiPORTMACPlacement=snmpFddiPORTMACPlacement, snmpFddiPORTAvailablePaths=snmpFddiPORTAvailablePaths, snmpFddiPORTMACLoopTime=snmpFddiPORTMACLoopTime, snmpFddiPORTTBMax=snmpFddiPORTTBMax, snmpFddiPORTBSFlag=snmpFddiPORTBSFlag, snmpFddiPORTLCTFailCts=snmpFddiPORTLCTFailCts, snmpFddiPORTLerEstimate=snmpFddiPORTLerEstimate, snmpFddiPORTLemRejectCts=snmpFddiPORTLemRejectCts, snmpFddiPORTLemCts=snmpFddiPORTLemCts, snmpFddiPORTLerCutoff=snmpFddiPORTLerCutoff, snmpFddiPORTLerAlarm=snmpFddiPORTLerAlarm, snmpFddiPORTConnectState=snmpFddiPORTConnectState, snmpFddiPORTPCMState=snmpFddiPORTPCMState, snmpFddiPORTPCWithhold=snmpFddiPORTPCWithhold, snmpFddiPORTLerCondition=snmpFddiPORTLerCondition, snmpFddiPORTChipSet=snmpFddiPORTChipSet, snmpFddiPORTAction=snmpFddiPORTAction, snmpFddiATTACHMENT=snmpFddiATTACHMENT, snmpFddiATTACHMENTNumber=snmpFddiATTACHMENTNumber, snmpFddiATTACHMENTTable=snmpFddiATTACHMENTTable, snmpFddiATTACHMENTEntry=snmpFddiATTACHMENTEntry, snmpFddiATTACHMENTSMTIndex=snmpFddiATTACHMENTSMTIndex, snmpFddiATTACHMENTIndex=snmpFddiATTACHMENTIndex, snmpFddiATTACHMENTClass=snmpFddiATTACHMENTClass, snmpFddiATTACHMENTOpticalBypassPresent=snmpFddiATTACHMENTOpticalBypassPresent, snmpFddiATTACHMENTIMaxExpiration=snmpFddiATTACHMENTIMaxExpiration, snmpFddiATTACHMENTInsertedStatus=snmpFddiATTACHMENTInsertedStatus, snmpFddiATTACHMENTInsertPolicy=snmpFddiATTACHMENTInsertPolicy, snmpFddiChipSets=snmpFddiChipSets, snmpFddiPHYChipSets=snmpFddiPHYChipSets, snmpFddiMACChipSets=snmpFddiMACChipSets, snmpFddiPHYMACChipSets=snmpFddiPHYMACChipSets)

