% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{findInsDupOverlaps}
\alias{findInsDupOverlaps}
\title{Finds duplication events that are reported as inserts.
As sequence alignment algorithms do no allow backtracking, long read-based
variant callers will frequently report small duplication as insertion events.
Whilst both the duplication and insertion representations result in the same
sequence, this representational difference is problematic when comparing
variant call sets.}
\usage{
findInsDupOverlaps(query, subject, maxgap = -1L, maxsizedifference = 0L)
}
\arguments{
\item{query}{a breakpoint GRanges object}

\item{subject}{a breakpoint GRanges object}

\item{maxgap}{maximum distance between the insertion position and the duplication}

\item{maxsizedifference}{maximum size difference between the duplication and insertion.}
}
\value{
Hits object containing the ordinals of the matching breakends
in the query and subject
}
\description{
WARNING: this method does not check that the inserted sequence actually matched the duplicated sequence.
}
