% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{get.incidence}
\alias{get.incidence}
\title{Bipartite adjacency matrix of a bipartite graph}
\usage{
get.incidence(graph, types = NULL, attr = NULL, names = TRUE, sparse = FALSE)
}
\arguments{
\item{graph}{The input graph. The direction of the edges is ignored in
directed graphs.}

\item{types}{An optional vertex type vector to use instead of the
\code{type} vertex attribute. You must supply this argument if the graph has
no \code{type} vertex attribute.}

\item{attr}{Either \code{NULL} or a character string giving an edge
attribute name. If \code{NULL}, then a traditional bipartite adjacency matrix is
returned. If not \code{NULL} then the values of the given edge attribute are
included in the bipartite adjacency matrix. If the graph has multiple edges, the edge
attribute of an arbitrarily chosen edge (for the multiple edges) is
included.}

\item{names}{Logical scalar, if \code{TRUE} and the vertices in the graph
are named (i.e. the graph has a vertex attribute called \code{name}), then
vertex names will be added to the result as row and column names. Otherwise
the ids of the vertices are used as row and column names.}

\item{sparse}{Logical scalar, if it is \code{TRUE} then a sparse matrix is
created, you will need the \code{Matrix} package for this.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{get.incidence()} was renamed to \code{as_biadjacency_matrix()} to create a more
consistent API.
}
\keyword{internal}
